/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.drizzle.jdbc.DrizzleConnection;
import org.drizzle.jdbc.JDBCUrl;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.query.DrizzleQueryFactory;
import org.drizzle.jdbc.internal.drizzle.DrizzleProtocol;
import org.drizzle.jdbc.internal.mysql.MySQLProtocol;

public final class Driver
implements java.sql.Driver {
    private static final Logger log = Logger.getLogger(Driver.class.getName());

    public Connection connect(String url, Properties info) throws SQLException {
        log.finest("Connecting to: " + url);
        try {
            JDBCUrl jdbcUrl = new JDBCUrl(url);
            Protocol protocol = jdbcUrl.getDBType() == JDBCUrl.DBType.DRIZZLE ? new DrizzleProtocol(jdbcUrl.getHostname(), jdbcUrl.getPort(), jdbcUrl.getDatabase(), jdbcUrl.getUsername(), jdbcUrl.getPassword()) : new MySQLProtocol(jdbcUrl.getHostname(), jdbcUrl.getPort(), jdbcUrl.getDatabase(), jdbcUrl.getUsername(), jdbcUrl.getPassword());
            return new DrizzleConnection(protocol, new DrizzleQueryFactory());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:drizzle://") || url.startsWith("jdbc:mysql:thin://");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

