package torrentsearch.providers

import torrentsearch.Category
import torrentsearch.SearchParam
import torrentsearch.TorrentDescription
import torrentsearch.TorrentQuery

class LibreProvider : BaseTorrentProvider() {
    override val name: String = "libre"
    override val baseUrl: String = ""
    override val tokenPath: String = ""
    override val searchPath: String = ""
    override val categories: Map<Category, String> = emptyMap()
    override val searchParams: Map<SearchParam, String> = emptyMap()

    override suspend fun search(query: TorrentQuery): List<TorrentDescription> {
        return when (query.content.orEmpty().lowercase()) {
            "sintel" -> listOf(
                TorrentDescription(
                    provider = name,
                    magnetUrl = "magnet:?xt=urn:btih:08ada5a7a6183aae1e09d831df6748d566095a10&dn=Sintel&tr=udp%3A%2F%2Fexplodie.org%3A6969&tr=udp%3A%2F%2Ftracker.coppersurfer.tk%3A6969&tr=udp%3A%2F%2Ftracker.empire-js.us%3A1337&tr=udp%3A%2F%2Ftracker.leechers-paradise.org%3A6969&tr=udp%3A%2F%2Ftracker.opentrackr.org%3A1337&tr=wss%3A%2F%2Ftracker.btorrent.xyz&tr=wss%3A%2F%2Ftracker.fastcast.nz&tr=wss%3A%2F%2Ftracker.openwebtorrent.com&ws=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2F&xs=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2Fsintel.torrent",
                    title = "Sintel",
                    size = 0L,
                    seeds = 0,
                    peers = 0,
                    themoviedbId = 45745,
                    imdbId = "tt1727587",
                )
            )
            "big buck bunny" -> listOf(
                TorrentDescription(
                    provider = name,
                    magnetUrl = "magnet:?xt=urn:btih:dd8255ecdc7ca55fb0bbf81323d87062db1f6d1c&dn=Big+Buck+Bunny&tr=udp%3A%2F%2Fexplodie.org%3A6969&tr=udp%3A%2F%2Ftracker.coppersurfer.tk%3A6969&tr=udp%3A%2F%2Ftracker.empire-js.us%3A1337&tr=udp%3A%2F%2Ftracker.leechers-paradise.org%3A6969&tr=udp%3A%2F%2Ftracker.opentrackr.org%3A1337&tr=wss%3A%2F%2Ftracker.btorrent.xyz&tr=wss%3A%2F%2Ftracker.fastcast.nz&tr=wss%3A%2F%2Ftracker.openwebtorrent.com&ws=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2F&xs=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2Fbig-buck-bunny.torrent",
                    title = "Big Buck Bunny",
                    size = 0L,
                    seeds = 0,
                    peers = 0,
                    themoviedbId = 10378,
                    imdbId = "tt1254207",
                )
            )
            "cosmos laundromat" -> listOf(
                TorrentDescription(
                    provider = name,
                    magnetUrl = "magnet:?xt=urn:btih:c9e15763f722f23e98a29decdfae341b98d53056&dn=Cosmos+Laundromat&tr=udp%3A%2F%2Fexplodie.org%3A6969&tr=udp%3A%2F%2Ftracker.coppersurfer.tk%3A6969&tr=udp%3A%2F%2Ftracker.empire-js.us%3A1337&tr=udp%3A%2F%2Ftracker.leechers-paradise.org%3A6969&tr=udp%3A%2F%2Ftracker.opentrackr.org%3A1337&tr=wss%3A%2F%2Ftracker.btorrent.xyz&tr=wss%3A%2F%2Ftracker.fastcast.nz&tr=wss%3A%2F%2Ftracker.openwebtorrent.com&ws=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2F&xs=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2Fcosmos-laundromat.torrent",
                    title = "Cosmos Laundromat",
                    size = 0L,
                    seeds = 0,
                    peers = 0,
                    themoviedbId = 358332,
                    imdbId = "tt4957236",
                )
            )
            "tears of steel" -> listOf(
                TorrentDescription(
                    provider = name,
                    magnetUrl = "Tears of Steel",
                    title = "magnet:?xt=urn:btih:209c8226b299b308beaf2b9cd3fb49212dbd13ec&dn=Tears+of+Steel&tr=udp%3A%2F%2Fexplodie.org%3A6969&tr=udp%3A%2F%2Ftracker.coppersurfer.tk%3A6969&tr=udp%3A%2F%2Ftracker.empire-js.us%3A1337&tr=udp%3A%2F%2Ftracker.leechers-paradise.org%3A6969&tr=udp%3A%2F%2Ftracker.opentrackr.org%3A1337&tr=wss%3A%2F%2Ftracker.btorrent.xyz&tr=wss%3A%2F%2Ftracker.fastcast.nz&tr=wss%3A%2F%2Ftracker.openwebtorrent.com&ws=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2F&xs=https%3A%2F%2Fwebtorrent.io%2Ftorrents%2Ftears-of-steel.torrent",
                    size = 0L,
                    seeds = 0,
                    peers = 0,
                    themoviedbId = 133701,
                    imdbId = "tt2285752",
                )
            )
            else -> emptyList()
        }
    }
}
