package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.UploadSlotsBehavior

internal object UploadSlotsBehaviorSerializer : KSerializer<UploadSlotsBehavior> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("UploadSlotsBehavior", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): UploadSlotsBehavior {
    val value = decoder.decodeInt()
    return UploadSlotsBehavior.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown UploadSlotsBehavior value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: UploadSlotsBehavior) {
    encoder.encodeInt(value.value)
  }
}
