package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.TorrentEncryption

internal object TorrentEncryptionSerializer : KSerializer<TorrentEncryption> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("TorrentEncryption", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): TorrentEncryption {
    val value = decoder.decodeInt()
    return TorrentEncryption.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown TorrentEncryption value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: TorrentEncryption) {
    encoder.encodeInt(value.value)
  }
}
