package qbittorrent.models

import kotlin.Boolean
import kotlin.Float
import kotlin.Int
import kotlin.PublishedApi
import kotlin.String
import kotlin.reflect.KProperty1
import kotlinx.serialization.KSerializer
import kotlinx.serialization.serializer
import qbittorrent.models.preferences.ProxyType
import qbittorrent.models.serialization.BittorrentProtocolSerializer
import qbittorrent.models.serialization.DyndnsServiceSerializer
import qbittorrent.models.serialization.MaxRatioActionSerializer
import qbittorrent.models.serialization.NewLineListSerializer
import qbittorrent.models.serialization.ScanDirSerializer
import qbittorrent.models.serialization.SchedulerDaysSerializer
import qbittorrent.models.serialization.SemiColonListSerializer
import qbittorrent.models.serialization.TorrentEncryptionSerializer
import qbittorrent.models.serialization.UploadChokingAlgorithmSerializer
import qbittorrent.models.serialization.UploadSlotsBehaviorSerializer
import qbittorrent.models.serialization.UtpTcpMixedModeSerializer

@PublishedApi
internal fun KProperty1<QBittorrentPrefs, *>.getSerializer(): KSerializer<*> = when (name) {
  "locale" -> serializer<String>()
  "createSubfolderEnabled" -> serializer<Boolean?>()
  "startPausedEnabled" -> serializer<Boolean?>()
  "autoDeleteMode" -> serializer<Int>()
  "preallocateAll" -> serializer<Boolean>()
  "incompleteFilesExt" -> serializer<Boolean>()
  "autoTmmEnabled" -> serializer<Boolean>()
  "torrentChangedTmmEnabled" -> serializer<Boolean>()
  "savePathChangedTmmEnabled" -> serializer<Boolean>()
  "categoryChangedTmmEnabled" -> serializer<Boolean>()
  "savePath" -> serializer<String>()
  "tempPathEnabled" -> serializer<Boolean>()
  "tempPath" -> serializer<String>()
  "scanDirs" -> ScanDirSerializer
  "exportDir" -> serializer<String>()
  "exportDirFinished" -> serializer<String>()
  "mailNotificationEnabled" -> serializer<Boolean>()
  "mailNotificationSender" -> serializer<String>()
  "mailNotificationEmail" -> serializer<String>()
  "mailNotificationSmtp" -> serializer<String>()
  "mailNotificationSslEnabled" -> serializer<Boolean>()
  "mailNotificationAuthEnabled" -> serializer<Boolean>()
  "mailNotificationUsername" -> serializer<String>()
  "mailNotificationPassword" -> serializer<String>()
  "autorunEnabled" -> serializer<Boolean>()
  "autorunProgram" -> serializer<String>()
  "queueingEnabled" -> serializer<Boolean>()
  "maxActiveDownloads" -> serializer<Int>()
  "maxActiveTorrents" -> serializer<Int>()
  "maxActiveUploads" -> serializer<Int>()
  "dontCountSlowTorrents" -> serializer<Boolean>()
  "slowTorrentDlRateThreshold" -> serializer<Int>()
  "slowTorrentUlRateThreshold" -> serializer<Int>()
  "slowTorrentInactiveTimer" -> serializer<Int>()
  "maxRatioEnabled" -> serializer<Boolean>()
  "maxRatio" -> serializer<Float>()
  "maxRatioAction" -> MaxRatioActionSerializer
  "listenPort" -> serializer<Int>()
  "upnp" -> serializer<Boolean>()
  "randomPort" -> serializer<Boolean>()
  "dlLimit" -> serializer<Int>()
  "upLimit" -> serializer<Int>()
  "maxConnections" -> serializer<Int>()
  "maxConnectionsPerTorrent" -> serializer<Int>()
  "maxUploads" -> serializer<Int>()
  "maxUploadsPerTorrent" -> serializer<Int>()
  "stopTrackerTimeout" -> serializer<Int>()
  "enablePieceExtentAffinity" -> serializer<Boolean>()
  "bittorrentProtocol" -> BittorrentProtocolSerializer
  "limitUtpRate" -> serializer<Boolean>()
  "limitTcpOverhead" -> serializer<Boolean>()
  "limitLanPeers" -> serializer<Boolean>()
  "altDlLimit" -> serializer<Int>()
  "altUpLimit" -> serializer<Int>()
  "schedulerEnabled" -> serializer<Boolean>()
  "scheduleFromHour" -> serializer<Int>()
  "scheduleFromMin" -> serializer<Int>()
  "scheduleToHour" -> serializer<Int>()
  "scheduleToMin" -> serializer<Int>()
  "schedulerDays" -> SchedulerDaysSerializer
  "dht" -> serializer<Boolean>()
  "pex" -> serializer<Boolean>()
  "lsd" -> serializer<Boolean>()
  "encryption" -> TorrentEncryptionSerializer
  "anonymousMode" -> serializer<Boolean>()
  "proxyType" -> serializer<ProxyType>()
  "proxyIp" -> serializer<String>()
  "proxyPort" -> serializer<Int>()
  "proxyPeerConnections" -> serializer<Boolean>()
  "proxyAuthEnabled" -> serializer<Boolean>()
  "proxyUsername" -> serializer<String>()
  "proxyPassword" -> serializer<String>()
  "proxyTorrentsOnly" -> serializer<Boolean?>()
  "ipFilterEnabled" -> serializer<Boolean>()
  "ipFilterPath" -> serializer<String>()
  "ipFilterTrackers" -> serializer<Boolean>()
  "webUiDomainList" -> SemiColonListSerializer
  "webUiAddress" -> serializer<String>()
  "webUiPort" -> serializer<Int>()
  "webUiUpnp" -> serializer<Boolean>()
  "webUiUsername" -> serializer<String>()
  "webUiPassword" -> serializer<String?>()
  "webUiCsrfProtectionEnabled" -> serializer<Boolean>()
  "webUiClickjackingProtectionEnabled" -> serializer<Boolean>()
  "webUiSecureCookieEnabled" -> serializer<Boolean>()
  "webUiMaxAuthFailCount" -> serializer<Int>()
  "webUiBanDuration" -> serializer<Int>()
  "webUiSessionTimeout" -> serializer<Int>()
  "webUiHostHeaderValidationEnabled" -> serializer<Boolean>()
  "bypassLocalAuth" -> serializer<Boolean>()
  "bypassAuthSubnetWhitelistEnabled" -> serializer<Boolean>()
  "bypassAuthSubnetWhitelist" -> NewLineListSerializer
  "alternativeWebUiEnabled" -> serializer<Boolean>()
  "alternativeWebUiPath" -> serializer<String>()
  "useHttps" -> serializer<Boolean>()
  "webUiHttpsKeyPath" -> serializer<String>()
  "webUiHttpsCertPath" -> serializer<String>()
  "dyndnsEnabled" -> serializer<Boolean>()
  "dyndnsService" -> DyndnsServiceSerializer
  "dyndnsUsername" -> serializer<String>()
  "dyndnsPassword" -> serializer<String>()
  "dyndnsDomain" -> serializer<String>()
  "rssRefreshInterval" -> serializer<Int>()
  "rssMaxArticlesPerFeed" -> serializer<Int>()
  "rssProcessingEnabled" -> serializer<Boolean>()
  "rssAutoDownloadingEnabled" -> serializer<Boolean>()
  "rssDownloadRepackProperEpisodes" -> serializer<Boolean>()
  "rssSmartEpisodeFilters" -> serializer<String>()
  "addTrackersEnabled" -> serializer<Boolean>()
  "addTrackers" -> NewLineListSerializer
  "webUiUseCustomHttpHeadersEnabled" -> serializer<Boolean>()
  "webUiCustomHttpHeaders" -> NewLineListSerializer
  "maxSeedingTimeEnabled" -> serializer<Boolean>()
  "maxSeedingTime" -> serializer<Int>()
  "announceIp" -> serializer<String>()
  "announceToAllTiers" -> serializer<Boolean>()
  "announceToAllTrackers" -> serializer<Boolean>()
  "asyncIoThreads" -> serializer<Int>()
  "bannedIps" -> NewLineListSerializer
  "checkingMemoryUse" -> serializer<Int>()
  "currentInterfaceAddress" -> serializer<String>()
  "currentNetworkInterface" -> serializer<String>()
  "diskCache" -> serializer<Int>()
  "diskCacheTtl" -> serializer<Int>()
  "embeddedTrackerPort" -> serializer<Int>()
  "enableCoalesceReadWrite" -> serializer<Boolean>()
  "enableEmbeddedTracker" -> serializer<Boolean>()
  "enableMultiConnectionsFromSameIp" -> serializer<Boolean>()
  "enableOsCache" -> serializer<Boolean?>()
  "enableUploadSuggestions" -> serializer<Boolean>()
  "filePoolSize" -> serializer<Int>()
  "outgoingPortsMax" -> serializer<Int>()
  "outgoingPortsMin" -> serializer<Int>()
  "recheckCompletedTorrents" -> serializer<Boolean>()
  "resolvePeerCountries" -> serializer<Boolean>()
  "saveResumeDataInterval" -> serializer<Int>()
  "sendBufferLowWatermark" -> serializer<Int>()
  "sendBufferWatermark" -> serializer<Int>()
  "sendBufferWatermarkFactor" -> serializer<Int>()
  "socketBacklogSize" -> serializer<Int>()
  "uploadChokingAlgorithm" -> UploadChokingAlgorithmSerializer
  "uploadSlotsBehavior" -> UploadSlotsBehaviorSerializer
  "upnpLeaseDuration" -> serializer<Int>()
  "utpTcpMixedMode" -> UtpTcpMixedModeSerializer
  else -> error("no serializer found for property")
}
