package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.UtpTcpMixedMode

internal object UtpTcpMixedModeSerializer : KSerializer<UtpTcpMixedMode> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("UtpTcpMixedMode", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): UtpTcpMixedMode {
    val value = decoder.decodeInt()
    return UtpTcpMixedMode.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown UtpTcpMixedMode value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: UtpTcpMixedMode) {
    encoder.encodeInt(value.value)
  }
}
