package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.UploadChokingAlgorithm

internal object UploadChokingAlgorithmSerializer : KSerializer<UploadChokingAlgorithm> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("UploadChokingAlgorithm", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): UploadChokingAlgorithm {
    val value = decoder.decodeInt()
    return UploadChokingAlgorithm.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown UploadChokingAlgorithm value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: UploadChokingAlgorithm) {
    encoder.encodeInt(value.value)
  }
}
