package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.TrackerStatus

internal object TrackerStatusSerializer : KSerializer<TrackerStatus> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("TrackerStatus", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): TrackerStatus {
    val value = decoder.decodeInt()
    return TrackerStatus.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown TrackerStatus value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: TrackerStatus) {
    encoder.encodeInt(value.value)
  }
}
