package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.SchedulerDays

internal object SchedulerDaysSerializer : KSerializer<SchedulerDays> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("SchedulerDays", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): SchedulerDays {
    val value = decoder.decodeInt()
    return SchedulerDays.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown SchedulerDays value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: SchedulerDays) {
    encoder.encodeInt(value.value)
  }
}
