package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.DyndnsService

internal object DyndnsServiceSerializer : KSerializer<DyndnsService> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("DyndnsService", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): DyndnsService {
    val value = decoder.decodeInt()
    return DyndnsService.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown DyndnsService value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: DyndnsService) {
    encoder.encodeInt(value.value)
  }
}
