package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.MaxRatioAction

internal object MaxRatioActionSerializer : KSerializer<MaxRatioAction> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("MaxRatioAction", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): MaxRatioAction {
    val value = decoder.decodeInt()
    return MaxRatioAction.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown MaxRatioAction value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: MaxRatioAction) {
    encoder.encodeInt(value.value)
  }
}
