package qbittorrent.models.serialization

import kotlinx.serialization.KSerializer
import kotlinx.serialization.SerializationException
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import qbittorrent.models.preferences.BittorrentProtocol

internal object BittorrentProtocolSerializer : KSerializer<BittorrentProtocol> {
  override val descriptor: SerialDescriptor =
      PrimitiveSerialDescriptor("BittorrentProtocol", PrimitiveKind.INT)

  override fun deserialize(decoder: Decoder): BittorrentProtocol {
    val value = decoder.decodeInt()
    return BittorrentProtocol.entries.firstOrNull { it.value == value }
       ?: throw SerializationException("Unknown BittorrentProtocol value '${'$'}value'")
  }

  override fun serialize(encoder: Encoder, `value`: BittorrentProtocol) {
    encoder.encodeInt(value.value)
  }
}
