/*
 * Decompiled with CFR 0.152.
 */
package kt.mobius.test.matcher;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kt.mobius.test.matcher.BaseDescriptionKt;
import kt.mobius.test.matcher.Description;
import kt.mobius.test.matcher.SelfDescribing;
import kt.mobius.test.matcher.SelfDescribingValueIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u000bH\u0016J?\u0010\f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\u0012\"\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0013J4\u0010\f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0014H\u0016J4\u0010\f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0002J.\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J.\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH$J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001cH\u0002\u00a8\u0006 "}, d2={"Lkt/mobius/test/matcher/BaseDescription;", "Lkt/mobius/test/matcher/Description;", "<init>", "()V", "appendText", "text", "", "appendDescriptionOf", "value", "Lkt/mobius/test/matcher/SelfDescribing;", "appendValue", "", "appendValueList", "T", "start", "separator", "end", "values", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lkt/mobius/test/matcher/Description;", "", "", "appendList", "i", "append", "", "str", "c", "", "toJavaSyntax", "unformatted", "ch", "mobiuskt-test"})
public abstract class BaseDescription
implements Description {
    @Override
    @NotNull
    public Description appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.append(text);
        return this;
    }

    @Override
    @NotNull
    public Description appendDescriptionOf(@NotNull SelfDescribing value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.describeTo(this);
        return this;
    }

    @Override
    @NotNull
    public Description appendValue(@Nullable Object value) {
        Object object = value;
        if (object == null) {
            this.append("null");
        } else if (object instanceof String) {
            this.toJavaSyntax((String)value);
        } else if (object instanceof Character) {
            this.append('\"');
            this.toJavaSyntax(((Character)value).charValue());
            this.append('\"');
        } else if (object instanceof Byte) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("b>");
        } else if (object instanceof Short) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("s>");
        } else if (object instanceof Long) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("L>");
        } else if (object instanceof Float) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("F>");
        } else if (object instanceof Object[]) {
            this.appendValueList("[", ", ", "]", ArrayIteratorKt.iterator((Object[])((Object[])value)));
        } else {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append('>');
        }
        return this;
    }

    @Override
    @NotNull
    public <T> Description appendValueList(@NotNull String start, @NotNull String separator, @NotNull String end, T ... values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendValueList(start, separator, end, ArraysKt.asList((Object[])values));
    }

    @Override
    @NotNull
    public <T> Description appendValueList(@NotNull String start, @NotNull String separator, @NotNull String end, @NotNull Iterable<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendValueList(start, separator, end, values.iterator());
    }

    private final <T> Description appendValueList(String start, String separator, String end, Iterator<? extends T> values) {
        return this.appendList(start, separator, end, (Iterator<? extends SelfDescribing>)new SelfDescribingValueIterator<T>(values));
    }

    @Override
    @NotNull
    public Description appendList(@NotNull String start, @NotNull String separator, @NotNull String end, @NotNull Iterable<? extends SelfDescribing> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendList(start, separator, end, values.iterator());
    }

    private final Description appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i) {
        boolean separate = false;
        this.append(start);
        while (i.hasNext()) {
            if (separate) {
                this.append(separator);
            }
            this.appendDescriptionOf(i.next());
            separate = true;
        }
        this.append(end);
        return this;
    }

    protected void append(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char element = str.charAt(i);
            this.append(element);
        }
    }

    protected abstract void append(char var1);

    private final void toJavaSyntax(String unformatted) {
        this.append('\"');
        int n = unformatted.length();
        for (int i = 0; i < n; ++i) {
            char element = unformatted.charAt(i);
            this.toJavaSyntax(element);
        }
        this.append('\"');
    }

    private final void toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                this.append("\\\"");
                break;
            }
            case '\n': {
                this.append("\\n");
                break;
            }
            case '\r': {
                this.append("\\r");
                break;
            }
            case '\t': {
                this.append("\\t");
                break;
            }
            case '\\': {
                this.append("\\\\");
                break;
            }
            default: {
                this.append(ch);
            }
        }
    }
}

