/*
 * Decompiled with CFR 0.152.
 */
package kt.mobius.test.matcher;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kt.mobius.test.matcher.AllOf;
import kt.mobius.test.matcher.Description;
import kt.mobius.test.matcher.IsEqual;
import kt.mobius.test.matcher.Matcher;
import kt.mobius.test.matcher.TypeSafeDiagnosingMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002:\u0001\u0012B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkt/mobius/test/matcher/IsIterableContaining;", "T", "Lkt/mobius/test/matcher/TypeSafeDiagnosingMatcher;", "", "elementMatcher", "Lkt/mobius/test/matcher/Matcher;", "<init>", "(Lkt/mobius/test/matcher/Matcher;)V", "matchesSafely", "", "item", "mismatchDescription", "Lkt/mobius/test/matcher/Description;", "isEmpty", "iterable", "describeTo", "", "description", "Companion", "mobiuskt-test"})
public final class IsIterableContaining<T>
extends TypeSafeDiagnosingMatcher<Iterable<? extends T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Matcher<? super T> elementMatcher;

    public IsIterableContaining(@NotNull Matcher<? super T> elementMatcher) {
        Intrinsics.checkNotNullParameter(elementMatcher, (String)"elementMatcher");
        KTypeParameter kTypeParameter = Reflection.typeParameter((Object)Reflection.getOrCreateKotlinClass(IsIterableContaining.class), (String)"T", (KVariance)KVariance.INVARIANT, (boolean)false);
        Reflection.setUpperBounds((KTypeParameter)kTypeParameter, (KType)Reflection.nullableTypeOf(Object.class));
        super(Reflection.typeOf(Iterable.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf((KClassifier)kTypeParameter))));
        this.elementMatcher = elementMatcher;
    }

    @Override
    protected boolean matchesSafely(@NotNull Iterable<? extends T> item, @NotNull Description mismatchDescription) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)mismatchDescription, (String)"mismatchDescription");
        if (this.isEmpty(item)) {
            mismatchDescription.appendText("was empty");
            return false;
        }
        for (T element : item) {
            if (!this.elementMatcher.matches(element)) continue;
            return true;
        }
        mismatchDescription.appendText("mismatches were: [");
        boolean isPastFirst = false;
        for (T element : item) {
            if (isPastFirst) {
                mismatchDescription.appendText(", ");
            }
            this.elementMatcher.describeMismatch(element, mismatchDescription);
            isPastFirst = true;
        }
        mismatchDescription.appendText("]");
        return false;
    }

    private final boolean isEmpty(Iterable<? extends T> iterable) {
        return !iterable.iterator().hasNext();
    }

    @Override
    public void describeTo(@NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        description.appendText("a collection containing ").appendDescriptionOf(this.elementMatcher);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005J%\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0001\u0010\u00072\u0006\u0010\t\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\nJ=\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0001\u0010\u00072\u001e\u0010\f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00050\r\"\b\u0012\u0004\u0012\u0002H\u00070\u0005\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0001\u0010\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\r\"\u0002H\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lkt/mobius/test/matcher/IsIterableContaining$Companion;", "", "<init>", "()V", "hasItem", "Lkt/mobius/test/matcher/Matcher;", "", "T", "itemMatcher", "item", "(Ljava/lang/Object;)Lkt/mobius/test/matcher/Matcher;", "hasItems", "itemMatchers", "", "([Lkt/mobius/test/matcher/Matcher;)Lkt/mobius/test/matcher/Matcher;", "items", "([Ljava/lang/Object;)Lkt/mobius/test/matcher/Matcher;", "mobiuskt-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Matcher<Iterable<T>> hasItem(@NotNull Matcher<T> itemMatcher) {
            Intrinsics.checkNotNullParameter(itemMatcher, (String)"itemMatcher");
            return new IsIterableContaining<T>(itemMatcher);
        }

        @NotNull
        public final <T> Matcher<Iterable<T>> hasItem(T item) {
            return new IsIterableContaining<T>(IsEqual.Companion.equalTo(item));
        }

        @NotNull
        public final <T> Matcher<Iterable<T>> hasItems(Matcher<T> ... itemMatchers) {
            Intrinsics.checkNotNullParameter(itemMatchers, (String)"itemMatchers");
            List all = new ArrayList(itemMatchers.length);
            for (Matcher<T> elementMatcher : itemMatchers) {
                all.add(new IsIterableContaining<T>(elementMatcher));
            }
            return AllOf.Companion.allOf(all);
        }

        @NotNull
        public final <T> Matcher<Iterable<T>> hasItems(T ... items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            List all = new ArrayList(items.length);
            for (T item : items) {
                all.add(this.hasItem(item));
            }
            return AllOf.Companion.allOf(all);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

