/*
 * Decompiled with CFR 0.152.
 */
package kt.mobius.test.matcher;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kt.mobius.test.matcher.BaseDescriptionKt;
import kt.mobius.test.matcher.Description;
import kt.mobius.test.matcher.SelfDescribing;
import kt.mobius.test.matcher.SelfDescribingValueIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016J.\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0012\u0010\u0016\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u0017H\u0016J?\u0010\u0018\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00192\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00190\u001a\"\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ4\u0010\u0018\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00192\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0011H\u0016J4\u0010\u0018\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00192\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a8\u0006\u001f"}, d2={"Lkt/mobius/test/matcher/BaseDescription;", "Lkt/mobius/test/matcher/Description;", "()V", "append", "", "c", "", "str", "", "appendDescriptionOf", "value", "Lkt/mobius/test/matcher/SelfDescribing;", "appendList", "start", "separator", "end", "values", "", "i", "", "appendText", "text", "appendValue", "", "appendValueList", "T", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lkt/mobius/test/matcher/Description;", "toJavaSyntax", "ch", "unformatted", "mobiuskt-test"})
public abstract class BaseDescription
implements Description {
    @Override
    @NotNull
    public Description appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.append(text);
        return this;
    }

    @Override
    @NotNull
    public Description appendDescriptionOf(@NotNull SelfDescribing value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.describeTo(this);
        return this;
    }

    @Override
    @NotNull
    public Description appendValue(@Nullable Object value) {
        Object object = value;
        if (object == null) {
            this.append("null");
        } else if (object instanceof String) {
            this.toJavaSyntax((String)value);
        } else if (object instanceof Character) {
            this.append('\"');
            this.toJavaSyntax(((Character)value).charValue());
            this.append('\"');
        } else if (object instanceof Byte) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("b>");
        } else if (object instanceof Short) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("s>");
        } else if (object instanceof Long) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("L>");
        } else if (object instanceof Float) {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append("F>");
        } else if (object instanceof Object[]) {
            this.appendValueList("[", ", ", "]", ArrayIteratorKt.iterator((Object[])((Object[])value)));
        } else {
            this.append('<');
            this.append(BaseDescriptionKt.descriptionOf(value));
            this.append('>');
        }
        return this;
    }

    @Override
    @NotNull
    public <T> Description appendValueList(@NotNull String start, @NotNull String separator, @NotNull String end, T ... values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendValueList(start, separator, end, ArraysKt.asList((Object[])values));
    }

    @Override
    @NotNull
    public <T> Description appendValueList(@NotNull String start, @NotNull String separator, @NotNull String end, @NotNull Iterable<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendValueList(start, separator, end, values.iterator());
    }

    private final <T> Description appendValueList(String start, String separator, String end, Iterator<? extends T> values) {
        return this.appendList(start, separator, end, (Iterator<? extends SelfDescribing>)new SelfDescribingValueIterator<T>(values));
    }

    @Override
    @NotNull
    public Description appendList(@NotNull String start, @NotNull String separator, @NotNull String end, @NotNull Iterable<? extends SelfDescribing> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.appendList(start, separator, end, values.iterator());
    }

    private final Description appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i) {
        boolean separate = false;
        this.append(start);
        while (i.hasNext()) {
            if (separate) {
                this.append(separator);
            }
            this.appendDescriptionOf(i.next());
            separate = true;
        }
        this.append(end);
        return this;
    }

    protected void append(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char element = str.charAt(i);
            this.append(element);
        }
    }

    protected abstract void append(char var1);

    private final void toJavaSyntax(String unformatted) {
        this.append('\"');
        int n = unformatted.length();
        for (int i = 0; i < n; ++i) {
            char element = unformatted.charAt(i);
            this.toJavaSyntax(element);
        }
        this.append('\"');
    }

    private final void toJavaSyntax(char ch) {
        char c = ch;
        if (c == '\"') {
            this.append("\\\"");
        } else if (c == '\n') {
            this.append("\\n");
        } else if (c == '\r') {
            this.append("\\r");
        } else if (c == '\t') {
            this.append("\\t");
        } else if (c == '\\') {
            this.append("\\\\");
        } else {
            this.append(ch);
        }
    }
}

