/*
 * Decompiled with CFR 0.152.
 */
package kjob.kron;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.util.Locale;
import kjob.core.BaseJob;
import kjob.core.BaseKJob;
import kjob.core.KJob;
import kjob.core.KronJob;
import kjob.core.dsl.JobContext;
import kjob.core.dsl.JobRegisterContext;
import kjob.core.dsl.KJobFunctions;
import kjob.core.extension.BaseExtension;
import kjob.core.extension.ExtensionId;
import kjob.core.internal.DefaultRunnableJob;
import kjob.core.internal.RunnableJob;
import kjob.kron.CronScheduler;
import kjob.kron.Kron;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ`\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u0002H\u001a2A\u0010\u001d\u001a=\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0 0\u001f\u0012\u0004\u0012\u0002H\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0 0!0\u001e\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0014\u001a\n \u000b*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkjob/kron/KronEx;", "Lkjob/core/extension/BaseExtension;", "config", "Lkjob/kron/KronEx$Configuration;", "kjobConfig", "Lkjob/core/BaseKJob$Configuration;", "kjob", "Lkjob/core/BaseKJob;", "(Lkjob/kron/KronEx$Configuration;Lkjob/core/BaseKJob$Configuration;Lkjob/core/BaseKJob;)V", "cronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "kotlin.jvm.PlatformType", "cronParser", "Lcom/cronutils/parser/CronParser;", "cronScheduler", "Lkjob/kron/CronScheduler;", "getCronScheduler", "()Lkjob/kron/CronScheduler;", "cronScheduler$delegate", "Lkotlin/Lazy;", "descriptor", "Lcom/cronutils/descriptor/CronDescriptor;", "logger", "Lorg/slf4j/Logger;", "kron", "", "J", "Lkjob/core/KronJob;", "kronJob", "block", "Lkotlin/Function2;", "Lkjob/core/dsl/JobRegisterContext;", "Lkjob/core/dsl/JobContext;", "Lkjob/core/dsl/KJobFunctions;", "Lkotlin/ExtensionFunctionType;", "(Lkjob/core/KronJob;Lkotlin/jvm/functions/Function2;)V", "shutdown", "start", "Configuration", "kjob-kron"})
public final class KronEx
extends BaseExtension {
    @NotNull
    private final Configuration config;
    @NotNull
    private final BaseKJob.Configuration kjobConfig;
    @NotNull
    private final BaseKJob<BaseKJob.Configuration> kjob;
    private final Logger logger;
    private final CronDefinition cronDefinition;
    @NotNull
    private final CronParser cronParser;
    private final CronDescriptor descriptor;
    @NotNull
    private final Lazy cronScheduler$delegate;

    public KronEx(@NotNull Configuration config, @NotNull BaseKJob.Configuration kjobConfig, @NotNull BaseKJob<BaseKJob.Configuration> kjob) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)kjobConfig, (String)"kjobConfig");
        Intrinsics.checkNotNullParameter(kjob, (String)"kjob");
        super((ExtensionId)Kron.INSTANCE);
        this.config = config;
        this.kjobConfig = kjobConfig;
        this.kjob = kjob;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        this.cronParser = new CronParser(this.cronDefinition);
        this.descriptor = CronDescriptor.instance((Locale)Locale.UK);
        this.cronScheduler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CronScheduler>(this){
            final /* synthetic */ KronEx this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CronScheduler invoke() {
                return new CronScheduler(KronEx.access$getKjob$p(this.this$0).jobExecutors().getExecutorService(), KronEx.access$getKjob$p(this.this$0).jobScheduler(), KronEx.access$getKjob$p(this.this$0).getClock(), 1000L);
            }
        }));
    }

    private final CronScheduler getCronScheduler() {
        Lazy lazy = this.cronScheduler$delegate;
        return (CronScheduler)((Object)lazy.getValue());
    }

    public void start() {
        this.getCronScheduler().start();
        this.logger.debug("Started " + this.getId().name() + " extension.");
    }

    public void shutdown() {
        this.logger.debug("Shutting down " + this.getId().name() + " extension.");
        this.getCronScheduler().shutdown();
    }

    public final <J extends KronJob> void kron(@NotNull J kronJob, @NotNull Function2<? super JobRegisterContext<J, JobContext<J>>, ? super J, KJobFunctions<J, JobContext<J>>> block) {
        Intrinsics.checkNotNullParameter(kronJob, (String)"kronJob");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DefaultRunnableJob runnableJob = new DefaultRunnableJob((BaseJob)kronJob, (KJob.Configuration)this.kjobConfig, block);
        this.kjob.jobRegister().register((RunnableJob)runnableJob);
        Cron cron = this.cronParser.parse(kronJob.getCronExpression());
        cron.validate();
        this.logger.debug("Add '" + kronJob.getName() + "' with cron expression '" + this.descriptor.describe(cron) + "'...");
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        CronScheduler cronScheduler2 = this.getCronScheduler();
        Intrinsics.checkNotNullExpressionValue((Object)executionTime, (String)"executionTime");
        cronScheduler2.add(kronJob, executionTime);
    }

    public static final /* synthetic */ BaseKJob access$getKjob$p(KronEx $this) {
        return $this.kjob;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkjob/kron/KronEx$Configuration;", "Lkjob/core/extension/BaseExtension$Configuration;", "()V", "kjob-kron"})
    public static final class Configuration
    extends BaseExtension.Configuration {
    }
}

