/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_quirks":has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_16["dj_ie"]=true;_16["dj_ie"+maj(ie)]=true;_16["dj_iequirks"]=has("quirks");}if(ff){_16["dj_ff"+maj(ff)]=true;}_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(_19,_1a,_1b,lin,du){return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_1c,_1d){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_1d);du.updateWithPattern(this.opt,_1d,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_1e,_1f){this.scale=_1e;this.offset=_1f;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,_20){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=lin.buildScaler(min,max,_20,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_20,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_21,_22){var du=_22.getObject("lang.utils",true,_21);var _23={},_24=Object.prototype.toString;var _25=function(o){if(o){switch(_24.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _22.delegate(o);}}return o;};_22.mixin(du,{coerceType:function(_26,_27){switch(typeof _26){case "number":return Number(eval("("+_27+")"));case "string":return String(_27);case "boolean":return Boolean(eval("("+_27+")"));}return eval("("+_27+")");},updateWithObject:function(_28,_29,_2a){if(!_29){return _28;}for(var x in _28){if(x in _29&&!(x in _23)){var t=_28[x];if(t&&typeof t=="object"){du.updateWithObject(t,_29[x],_2a);}else{_28[x]=_2a?du.coerceType(t,_29[x]):_25(_29[x]);}}}return _28;},updateWithPattern:function(_2b,_2c,_2d,_2e){if(!_2c||!_2d){return _2b;}for(var x in _2d){if(x in _2c&&!(x in _23)){_2b[x]=_2e?du.coerceType(_2d[x],_2c[x]):_25(_2c[x]);}}return _2b;},merge:function(_2f,_30){if(_30){var _31=_24.call(_2f),_32=_24.call(_30),t,i,l,m;switch(_32){case "[object Array]":if(_32==_31){t=new Array(Math.max(_2f.length,_30.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_2f[i],_30[i]);}return t;}return _30.slice(0);case "[object Object]":if(_32==_31&&_2f){t=_22.delegate(_2f);for(i in _30){if(i in _2f){l=_2f[i];m=_30[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_22.clone(_30[i]);}}return t;}return _22.clone(_30);}}return _30;}});return du;});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(_33,arr,_34,_35,_36,dc,g,m,df,du,has){var _37=0.2;return _34("dojox.charting.plot2d.Pie",[_35,_36],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_38,_39){this.opt=_33.clone(this.defaultParams);du.updateWithObject(this.opt,_39);du.updateWithPattern(this.opt,_39,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(_3a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _33.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_3b.l-_3b.r)/2,ry=(dim.height-_3b.t-_3b.b)/2,r=Math.min(rx,ry),_3c="font" in this.opt?this.opt.font:t.series.font,_3d,_3e=m._degToRad(this.opt.startAngle),_3f=_3e,_40,_41,_42,_43,_44,run=this.run.data,_45=this.events();this.dyn=[];if("radius" in this.opt){r=this.opt.radius;_44=r-this.opt.labelOffset;}var _46={cx:_3b.l+rx,cy:_3b.t+ry,r:r};if(this.opt.shadow||t.shadow){var _47=this.opt.shadow||t.shadow;var _48=_33.clone(_46);_48.cx+=_47.dx;_48.cy+=_47.dy;s.createCircle(_48).setFill(_47.color).setStroke(_47);}if(s.setFilter&&(this.opt.filter||t.filter)){s.createCircle(_46).setFill(t.series.stroke).setFilter(this.opt.filter||t.filter);}if(typeof run[0]=="number"){_40=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}}else{_40=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x,i){if(x<0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}}var _49=df.map(run,function(v,i){var _4a=[this.opt,this.run];if(v!==null&&typeof v!="number"){_4a.push(v);}if(this.opt.styleFunc){_4a.push(this.opt.styleFunc(v));}return t.next("slice",_4a,true);},this);if(this.opt.labels){_3d=_3c?g.normalizedLength(g.splitFontString(_3c).size):0;_43=df.foldl1(df.map(_42,function(_4b,i){var _4c=_49[i].series.font;return g._base._getTextBox(_4b,{font:_4c}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_43,ry-_3d)+this.opt.labelOffset;}_44=r-this.opt.labelOffset;}var _4d=new Array(_41.length);arr.some(_41,function(_4e,i){if(_4e<0){return false;}if(_4e==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_4f=_49[i],_50,o;if(_4e>=1){_50=this._plotFill(_4f.series.fill,dim,_3b);_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},_46.r);var _51=s.createCircle(_46).setFill(_50).setStroke(_4f.series.stroke);this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}return false;}var end=_3f+_4e*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _52=end-_3f,x1=_46.cx+r*Math.cos(_3f),y1=_46.cy+r*Math.sin(_3f),x2=_46.cx+r*Math.cos(end),y2=_46.cy+r*Math.sin(end);var _53=m._degToRad(this.opt.fanSize);if(_4f.series.fill&&_4f.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_52>_53){var _54=s.createGroup(),_55=Math.ceil(_52/_53),_56=_52/_55;_50=this._shapeFill(_4f.series.fill,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});for(var j=0;j<_55;++j){var _57=j==0?x1:_46.cx+r*Math.cos(_3f+(j-_37)*_56),_58=j==0?y1:_46.cy+r*Math.sin(_3f+(j-_37)*_56),_59=j==_55-1?x2:_46.cx+r*Math.cos(_3f+(j+1+_37)*_56),_5a=j==_55-1?y2:_46.cy+r*Math.sin(_3f+(j+1+_37)*_56);_54.createPath().moveTo(_46.cx,_46.cy).lineTo(_57,_58).arcTo(r,r,0,_56>Math.PI,true,_59,_5a).lineTo(_46.cx,_46.cy).closePath().setFill(this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f+(j+0.5)*_56,_3f+(j+0.5)*_56));}_54.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_51=_54;}else{_51=s.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_50=_4f.series.fill;if(_50&&_50.type==="radial"){_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});if(this.opt.radGrad==="linear"){_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f,end);}}else{if(_50&&_50.type==="linear"){_50=this._plotFill(_50,dim,_3b);_50=this._shapeFill(_50,_51.getBoundingBox());}}_51.setFill(_50);}this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}_3f=end;return false;},this);if(this.opt.labels){var _5b=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3f=_3e;arr.some(_41,function(_5c,i){if(_5c<=0){return false;}var _5d=_49[i];if(_5c>=1){this.renderLabel(s,_46.cx,_46.cy+_3d/2,_42[i],_5d,this.opt.labelOffset>0);return true;}var end=_3f+_5c*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}if(this.opt.omitLabels&&end-_3f<0.001){return false;}var _5e=(_3f+end)/2,x=_46.cx+_44*Math.cos(_5e),y=_46.cy+_44*Math.sin(_5e)+_3d/2;this.renderLabel(s,_5b?dim.width-x:x,y,_42[i],_5d,this.opt.labelOffset>0);_3f=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_3f=_3e;var _5f=this.opt.omitLabels;var _60=[];arr.forEach(_41,function(_61,i){var end=_3f+_61*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _62=(_3f+end)/2;_60.push({angle:_62,left:Math.cos(_62)<0,theme:_49[i],index:i,omit:_5f?end-_3f<0.001:false});_3f=end;});var _63=g._base._getTextBox("a",{font:_3c}).h;this._getProperLabelRadius(_60,_63,_46.r*1.1);arr.forEach(_60,function(_64,i){if(!_64.omit){var _65=_46.cx-_46.r*2,_66=_46.cx+_46.r*2,_67=g._base._getTextBox(_42[i],{font:_64.theme.series.font}).w,x=_46.cx+_64.labelR*Math.cos(_64.angle),y=_46.cy+_64.labelR*Math.sin(_64.angle),_68=(_64.left)?(_65+_67):(_66-_67),_69=(_64.left)?_65:_68;var _6a=s.createPath().moveTo(_46.cx+_46.r*Math.cos(_64.angle),_46.cy+_46.r*Math.sin(_64.angle));if(Math.abs(_64.labelR*Math.cos(_64.angle))<_46.r*2-_67){_6a.lineTo(x,y);}_6a.lineTo(_68,y).setStroke(_64.theme.series.labelWiring);this.renderLabel(s,_5b?dim.width-_67-_69:_69,y,_42[i],_64.theme,false,"left");}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_4d[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b);}return this;},_getProperLabelRadius:function(_6b,_6c,_6d){var _6e,_6f,_70=1,_71=1;if(_6b.length==1){_6b[0].labelR=_6d;return;}for(var i=0;i<_6b.length;i++){var _72=Math.abs(Math.sin(_6b[i].angle));if(_6b[i].left){if(_70>=_72){_70=_72;_6e=_6b[i];}}else{if(_71>=_72){_71=_72;_6f=_6b[i];}}}_6e.labelR=_6f.labelR=_6d;this._calculateLabelR(_6e,_6b,_6c);this._calculateLabelR(_6f,_6b,_6c);},_calculateLabelR:function(_73,_74,_75){var i=_73.index,_76=_74.length,_77=_73.labelR,_78;while(!(_74[i%_76].left^_74[(i+1)%_76].left)){if(!_74[(i+1)%_76].omit){_78=(Math.sin(_74[i%_76].angle)*_77+((_74[i%_76].left)?(-_75):_75))/Math.sin(_74[(i+1)%_76].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[(i+1)%_76].labelR=_77;}i++;}i=_73.index;var j=(i==0)?_76-1:i-1;while(!(_74[i].left^_74[j].left)){if(!_74[j].omit){_78=(Math.sin(_74[i].angle)*_77+((_74[i].left)?_75:(-_75)))/Math.sin(_74[j].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[j].labelR=_77;}i--;j--;i=(i<0)?i+_74.length:i;j=(j<0)?j+_74.length:j;}}});});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_79,has,_7a,win){_7a(function(){if(has("highcontrast")){_79.add(win.body(),"dijit_a11y");}});return has;});},"dojox/charting/action2d/Shake":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_7b,_7c,df,dfe,m,gf){var _7d=3;return _7b("dojox.charting.action2d.Shake",_7c,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_7d,shiftY:_7d},optionalParams:{},constructor:function(_7e,_7f,_80){if(!_80){_80={};}this.shiftX=typeof _80.shiftX=="number"?_80.shiftX:_7d;this.shiftY=typeof _80.shiftY=="number"?_80.shiftY:_7d;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _81=o.run.name,_82=o.index,_83=[],_84;if(_81 in this.anim){_84=this.anim[_81][_82];}else{this.anim[_81]={};}if(_84){_84.action.stop(true);}else{this.anim[_81][_82]=_84={};}var _85={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_83.push(gf.animateTransform(_85));}if(o.oultine){_85.shape=o.outline;_83.push(gf.animateTransform(_85));}if(o.shadow){_85.shape=o.shadow;_83.push(gf.animateTransform(_85));}if(!_83.length){delete this.anim[_81][_82];return;}_84.action=df.combine(_83);if(o.type=="onmouseout"){hub.connect(_84.action,"onEnd",this,function(){if(this.anim[_81]){delete this.anim[_81][_82];}});}_84.action.play();}});});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_86,_87,arr){var df=_87.getObject("lang.functional",true,_86);var _88={};var _89="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8a=function(s){var _8b=[],_8c=_89.call(s,/\s*->\s*/m);if(_8c.length>1){while(_8c.length){s=_8c.pop();_8b=_8c.pop().split(/\s*,\s*|\s+/m);if(_8c.length){_8c.push("(function("+_8b.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){_8b=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_8b.push("$1");s="$1"+s;}if(r){_8b.push("$2");s=s+"$2";}}else{var _8d=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_8d,function(v){if(!t.hasOwnProperty(v)){_8b.push(v);t[v]=1;}});}}}return {args:_8b,body:s};};var _8e=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_87.mixin(df,{rawLambda:function(s){return _8a(s);},buildLambda:function(s){var l=_8a(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _8e(s);}if(_88.hasOwnProperty(s)){return _88[s];}var l=_8a(s);return _88[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_88={};}});return df;});},"dojox/charting/plot2d/Candlesticks":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_8f,_90,arr,has,_91,_92,dc,df,dfr,du,fx){var _93=dfr.lambda("item.purgeGroup()");return _90("dojox.charting.plot2d.Candlesticks",[_91,_92],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_94,_95){this.opt=_8f.clone(this.defaultParams);du.updateWithObject(this.opt,_95);du.updateWithPattern(this.opt,_95,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_96){var _97=_8f.delegate(dc.defaultStats);for(var i=0;i<_96.length;i++){var run=_96[i];if(!run.data.length){continue;}var _98=_97.vmin,_99=_97.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_97.hmin=Math.min(_97.hmin,x);_97.hmax=Math.max(_97.hmax,x);_97.vmin=Math.min(_97.vmin,val.open,val.close,val.high,val.low);_97.vmax=Math.max(_97.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_97.vmin=Math.min(_98,run.ymin);}if("ymax" in run){_97.vmax=Math.max(_99,run.ymax);}}return _97;},getSeriesStats:function(){var _9a=this.collectStats(this.series);_9a.hmin-=0.5;_9a.hmax+=0.5;return _9a;},render:function(dim,_9b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_9b);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_93);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_9c){_9c.cleanGroup(s);});}var t=this.chart.theme,f,gap,_9d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_9e=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_9d=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();s=run.group;var _9f=t.next("candlestick",[this.opt,run]),_a0=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _a1=t.addMixin(_9f,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_9b.l+gap,y=dim.height-_9b.b,_a2=vt(v.open),_a3=vt(v.close),_a4=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_a4){var tmp=_a4;_a4=low;low=tmp;}if(_9d>=1){var _a5=_a2>_a3;var _a6={x1:_9d/2,x2:_9d/2,y1:y-_a4,y2:y-low},_a7={x:0,y:y-Math.max(_a2,_a3),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1)};var _a8=s.createGroup();_a8.setTransform({dx:x,dy:0});var _a9=_a8.createGroup();_a9.createLine(_a6).setStroke(_a1.series.stroke);_a9.createRect(_a7).setStroke(_a1.series.stroke).setFill(_a5?_a1.series.fill:"white");if("mid" in v){_a9.createLine({x1:(_a1.series.stroke.width||1),x2:_9d-(_a1.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_a5?"white":_a1.series.stroke);}run.dyn.fill=_a1.series.fill;run.dyn.stroke=_a1.series.stroke;if(_9e){var o={element:"candlestick",index:j,run:run,shape:_a9,x:x,y:y-Math.max(_a2,_a3),cx:_9d/2,cy:(y-Math.max(_a2,_a3))+(Math.max(_a5?_a2-_a3:_a3-_a2,1)/2),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1),data:v};this._connectEvents(o);_a0[j]=o;}}if(this.animate){this._animateCandlesticks(_a8,y-low,_a4-low);}}}this._eventSeries[run.name]=_a0;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_9b);}return this;},tooltipFunc:function(o){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";},_animateCandlesticks:function(_aa,_ab,_ac){fx.animateTransform(_8f.delegate({shape:_aa,duration:1200,transform:[{name:"translate",start:[0,_ab-(_ab/_ac)],end:[0,0]},{name:"scale",start:[1,1/_ac],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(_ad,_ae,df){_ad.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(_af){var _b0=_af.getObject("dojox.charting.scaler.primitive",true);return _af.mixin(_b0,{buildScaler:function(min,max,_b1,_b2){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_b1/(max-min),span:_b1},scaler:_b0};},buildTicks:function(_b3,_b4){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_b5){var _b6=_b5.bounds.from,_b7=_b5.bounds.scale;return function(x){return (x-_b6)*_b7;};},getTransformerFromPlot:function(_b8){var _b9=_b8.bounds.from,_ba=_b8.bounds.scale;return function(x){return x/_ba+_b9;};}});});},"dojox/charting/widget/Sparkline":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_bb,_bc,_bd,_be,_bf,_c0,_c1){_bc("dojox.charting.widget.Sparkline",_be,{theme:_bf,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_bd("> .axis, > .plot, > .action, > .series",n).length){var _c2=document.createElement("div");_c1.set(_c2,{"class":"plot","name":"default","type":this.type});n.appendChild(_c2);var _c3=document.createElement("div");_c1.set(_c3,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_bb.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_c1.set(_c3,i,this[i]);}},this);n.appendChild(_c3);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,_c4){var m=g.matrix={};var _c5={};m._degToRad=function(_c6){return _c5[_c6]||(_c5[_c6]=(Math.PI*_c6/180));};m._radToDeg=function(_c7){return _c7/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _c8=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_c8,r=m.normalize(arg[i]);_c8=new m.Matrix2D();_c8.xx=l.xx*r.xx+l.xy*r.yx;_c8.xy=l.xx*r.xy+l.xy*r.yy;_c8.yx=l.yx*r.xx+l.yy*r.yx;_c8.yy=l.yx*r.xy+l.yy*r.yy;_c8.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_c8.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_c4.mixin(this,_c8);}}else{_c4.mixin(this,arg);}}}};_c4.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_c4.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_c9){var c=Math.cos(_c9);var s=Math.sin(_c9);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_ca){return m.rotate(m._degToRad(_ca));},skewX:function(_cb){return new m.Matrix2D({xy:Math.tan(_cb)});},skewXg:function(_cc){return m.skewX(m._degToRad(_cc));},skewY:function(_cd){return new m.Matrix2D({yx:Math.tan(_cd)});},skewYg:function(_ce){return m.skewY(m._degToRad(_ce));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_cf){return (_cf instanceof m.Matrix2D)?_cf:new m.Matrix2D(_cf);},isIdentity:function(_d0){return _d0.xx==1&&_d0.xy==0&&_d0.yx==0&&_d0.yy==1&&_d0.dx==0&&_d0.dy==0;},clone:function(_d1){var obj=new m.Matrix2D();for(var i in _d1){if(typeof (_d1[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_d1[i]){obj[i]=_d1[i];}}return obj;},invert:function(_d2){var M=m.normalize(_d2),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_d3,x,y){return {x:_d3.xx*x+_d3.xy*y+_d3.dx,y:_d3.yx*x+_d3.yy*y+_d3.dy};},multiplyPoint:function(_d4,a,b){var M=m.normalize(_d4);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_d5,_d6){var M=m.normalize(_d5);_d6=_d6||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:_d6.x,y:_d6.y,width:_d6.width,height:_d6.height};}var p0=m.multiplyPoint(M,_d6.x,_d6.y),p1=m.multiplyPoint(M,_d6.x,_d6.y+_d6.height),p2=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y),p3=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y+_d6.height),_d7=Math.min(p0.x,p1.x,p2.x,p3.x),_d8=Math.min(p0.y,p1.y,p2.y,p3.y),_d9=Math.max(p0.x,p1.x,p2.x,p3.x),_da=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:_d7,y:_d8,width:_d9-_d7,height:_da-_d8};},multiply:function(_db){var M=m.normalize(_db);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_dc,x,y){return m.multiply(m.translate(x,y),_dc,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_dd,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_dd),a,b);}return m._sandwich(m.rotate(_dd),a.x,a.y);},rotategAt:function(_de,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_de),a,b);}return m._sandwich(m.rotateg(_de),a.x,a.y);},skewXAt:function(_df,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_df),a,b);}return m._sandwich(m.skewX(_df),a.x,a.y);},skewXgAt:function(_e0,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_e0),a,b);}return m._sandwich(m.skewXg(_e0),a.x,a.y);},skewYAt:function(_e1,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_e1),a,b);}return m._sandwich(m.skewY(_e1),a.x,a.y);},skewYgAt:function(_e2,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_e2),a,b);}return m._sandwich(m.skewYg(_e2),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(_e3,arr,_e4,has,_e5,_e6,dc,df,dfr,du,fx,_e7){var _e8=dfr.lambda("item.purgeGroup()");return _e4("dojox.charting.plot2d.Scatter",[_e5,_e6],{defaultParams:{shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",styleFunc:null},constructor:function(_e9,_ea){this.opt=_e3.clone(_e3.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_ea);du.updateWithPattern(this.opt,_ea,this.optionalParams);this.animate=this.opt.animate;},render:function(dim,_eb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_eb);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_e8);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_ec){_ec.cleanGroup(s);});}var t=this.chart.theme,_ed=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _ee=t.next("marker",[this.opt,run]),_ef,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);s=run.group;if(typeof run.data[0]=="number"){_ef=arr.map(run.data,function(v,i){return {x:ht(i+1)+_eb.l,y:dim.height-_eb.b-vt(v)};},this);}else{_ef=arr.map(run.data,function(v,i){return {x:ht(v.x)+_eb.l,y:dim.height-_eb.b-vt(v.y)};},this);}var _f0=new Array(_ef.length),_f1=new Array(_ef.length),_f2=new Array(_ef.length);arr.forEach(_ef,function(c,i){var _f3=run.data[i],_f4;if(this.opt.styleFunc||typeof _f3!="number"){var _f5=typeof _f3!="number"?[_f3]:[];if(this.opt.styleFunc){_f5.push(this.opt.styleFunc(_f3));}_f4=t.addMixin(_ee,"marker",_f5,true);}else{_f4=t.post(_ee,"marker");}var _f6="M"+c.x+" "+c.y+" "+_f4.symbol;if(_f4.marker.shadow){_f0[i]=s.createPath("M"+(c.x+_f4.marker.shadow.dx)+" "+(c.y+_f4.marker.shadow.dy)+" "+_f4.symbol).setStroke(_f4.marker.shadow).setFill(_f4.marker.shadow.color);if(this.animate){this._animateScatter(_f0[i],dim.height-_eb.b);}}if(_f4.marker.outline){var _f7=dc.makeStroke(_f4.marker.outline);_f7.width=2*_f7.width+_f4.marker.stroke.width;_f2[i]=s.createPath(_f6).setStroke(_f7);if(this.animate){this._animateScatter(_f2[i],dim.height-_eb.b);}}var _f8=dc.makeStroke(_f4.marker.stroke),_f9=this._plotFill(_f4.marker.fill,dim,_eb);if(_f9&&(_f9.type==="linear"||_f9.type=="radial")){var _fa=_e7.getColor(_f9,{x:c.x,y:c.y});if(_f8){_f8.color=_fa;}_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_fa);}else{_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_f9);}if(this.opt.labels){var _fb=_f1[i].getBoundingBox();this.createLabel(s,_f3,_fb,_f4);}if(this.animate){this._animateScatter(_f1[i],dim.height-_eb.b);}},this);if(_f1.length){run.dyn.marker=_ee.symbol;run.dyn.markerStroke=_f1[_f1.length-1].getStroke();run.dyn.markerFill=_f1[_f1.length-1].getFill();}if(_ed){var _fc=new Array(_f1.length);arr.forEach(_f1,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_f2&&_f2[i]||null,shadow:_f0&&_f0[i]||null,cx:_ef[i].x,cy:_ef[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_fc[i]=o;},this);this._eventSeries[run.name]=_fc;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_eb);}return this;},_animateScatter:function(_fd,_fe){fx.animateTransform(_e3.delegate({shape:_fd,duration:1200,transform:[{name:"translate",start:[0,_fe],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_ff,lang,df){var _100={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _100)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,z,_101=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _100)){if(_101){t=[z=a[i]];_101=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_102,on,_103,has,_104){var _105=new _102();var _106;_103(function(){var _107=_104.getBox();_105._rlh=on(window,"resize",function(){var _108=_104.getBox();if(_107.h==_108.h&&_107.w==_108.w){return;}_107=_108;_105.emit("resize");});if(has("ie")==8){var _109=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_109){_109=screen.deviceXDPI;_105.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_106=evt.target;});on(document,"focusout",function(evt){_106=null;});}});_105.getEffectiveBox=function(doc){var box=_104.getBox(doc);var tag=_106&&_106.tagName&&_106.tagName.toLowerCase();if(has("ios")&&_106&&!_106.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_106.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_106.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _105;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_10a,lang,_10b,_10c){var cx=lang.getObject("color",true,_10a);cx.Color=_10b;cx.blend=_10b.blendColors;cx.fromRgb=_10b.fromRgb;cx.fromHex=_10b.fromHex;cx.fromArray=_10b.fromArray;cx.fromString=_10b.fromString;cx.greyscale=_10c.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_10d,_10e){if(lang.isArray(cyan)){_10d=cyan[1],_10e=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10d=cyan.m,_10e=cyan.y,cyan=cyan.c;}}cyan/=100,_10d/=100,_10e/=100;var r=1-cyan,g=1-_10d,b=1-_10e;return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_10f,_110,_111){if(lang.isArray(cyan)){_10f=cyan[1],_110=cyan[2],_111=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10f=cyan.m,_110=cyan.y,_111=cyan.b,cyan=cyan.c;}}cyan/=100,_10f/=100,_110/=100,_111/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_111)+_111);g=1-Math.min(1,_10f*(1-_111)+_111);b=1-Math.min(1,_110*(1-_111)+_111);return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_112,_113){if(lang.isArray(hue)){_112=hue[1],_113=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_112=hue.s,_113=hue.l,hue=hue.h;}}_112/=100;_113/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_112*Math.min(r,1)+(1-_112);g=2*_112*Math.min(g,1)+(1-_112);b=2*_112*Math.min(b,1)+(1-_112);if(_113<0.5){r*=_113,g*=_113,b*=_113;}else{r=(1-_113)*r+2*_113-1;g=(1-_113)*g+2*_113-1;b=(1-_113)*b+2*_113-1;}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_114,_115){if(lang.isArray(hue)){_114=hue[1],_115=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_114=hue.s,_115=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_114/=100;_115/=100;var r,g,b;if(_114==0){r=_115,b=_115,g=_115;}else{var _116=hue/60,i=Math.floor(_116),f=_116-i;var p=_115*(1-_114);var q=_115*(1-(_114*f));var t=_115*(1-(_114*(1-f)));switch(i){case 0:r=_115,g=t,b=p;break;case 1:r=q,g=_115,b=p;break;case 2:r=p,g=_115,b=t;break;case 3:r=p,g=q,b=_115;break;case 4:r=t,g=p,b=_115;break;case 5:r=_115,g=p,b=q;break;}}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_10b,{toCmy:function(){var cyan=1-(this.r/255),_117=1-(this.g/255),_118=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_117*100),y:Math.round(_118*100)};},toCmyk:function(){var cyan,_119,_11a,_11b;var r=this.r/255,g=this.g/255,b=this.b/255;_11b=Math.min(1-r,1-g,1-b);cyan=(1-r-_11b)/(1-_11b);_119=(1-g-_11b)/(1-_11b);_11a=(1-b-_11b)/(1-_11b);return {c:Math.round(cyan*100),m:Math.round(_119*100),y:Math.round(_11a*100),b:Math.round(_11b*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11c=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_11c/((l<0.5)?(2*l):(2-2*l));}if(_11c>0){if(max==r&&max!=g){h+=(g-b)/_11c;}if(max==g&&max!=b){h+=(2+(b-r)/_11c);}if(max==b&&max!=r){h+=(4+(r-g)/_11c);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11d=max-min;var h=null,s=(max==0)?0:(_11d/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_11d;}else{if(g==max){h=120+60*(b-r)/_11d;}else{h=240+60*(r-g)/_11d;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_11e,has,_11f,_120,dc,df,dfr,du,fx){var _121=dfr.lambda("item.purgeGroup()");return _11e("dojox.charting.plot2d.OHLC",[_11f,_120],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_122,_123){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_123);du.updateWithPattern(this.opt,_123,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_124){var _125=lang.delegate(dc.defaultStats);for(var i=0;i<_124.length;i++){var run=_124[i];if(!run.data.length){continue;}var _126=_125.vmin,_127=_125.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_125.hmin=Math.min(_125.hmin,x);_125.hmax=Math.max(_125.hmax,x);_125.vmin=Math.min(_125.vmin,val.open,val.close,val.high,val.low);_125.vmax=Math.max(_125.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_125.vmin=Math.min(_126,run.ymin);}if("ymax" in run){_125.vmax=Math.max(_127,run.ymax);}}return _125;},getSeriesStats:function(){var _128=this.collectStats(this.series);_128.hmin-=0.5;_128.hmax+=0.5;return _128;},render:function(dim,_129){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_129);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_121);this._eventSeries={};this.cleanGroup();var s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_12a,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_12b=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_12a=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _12c=t.next("candlestick",[this.opt,run]),s=run.group,_12d=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _12e=t.addMixin(_12c,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_129.l+gap,y=dim.height-_129.b,open=vt(v.open),_12f=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_12a>=1){var hl={x1:_12a/2,x2:_12a/2,y1:y-high,y2:y-low},op={x1:0,x2:((_12a/2)+((_12e.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_12a/2)-((_12e.series.stroke.width||1)/2)),x2:_12a,y1:y-_12f,y2:y-_12f};var _130=s.createGroup();_130.setTransform({dx:x,dy:0});var _131=_130.createGroup();_131.createLine(hl).setStroke(_12e.series.stroke);_131.createLine(op).setStroke(_12e.series.stroke);_131.createLine(cl).setStroke(_12e.series.stroke);run.dyn.stroke=_12e.series.stroke;if(_12b){var o={element:"candlestick",index:j,run:run,shape:_131,x:x,y:y-Math.max(open,_12f),cx:_12a/2,cy:(y-Math.max(open,_12f))+(Math.max(open>_12f?open-_12f:_12f-open,1)/2),width:_12a,height:Math.max(open>_12f?open-_12f:_12f-open,1),data:v};this._connectEvents(o);_12d[j]=o;}}if(this.animate){this._animateOHLC(_130,y-low,high-low);}}}this._eventSeries[run.name]=_12d;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_129);}return this;},_animateOHLC:function(_132,_133,_134){fx.animateTransform(lang.delegate({shape:_132,duration:1200,transform:[{name:"translate",start:[0,_133-(_133/_134)],end:[0,0]},{name:"scale",start:[1,1/_134],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_135,on,_136){function _137(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _138;on(document,"keydown",function(e){if(_137(e)){_138=e.target;e.preventDefault();}else{_138=null;}});on(document,"keyup",function(e){if(_137(e)&&e.target==_138){_138=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _139=function(node,_13a){node.dojoClick=true;return on(node,"click",_13a);};_139.click=_139;_139.press=function(node,_13b){var _13c=on(node,_136.press,function(evt){if(evt.type=="mousedown"&&!_135.isLeft(evt)){return;}_13b(evt);}),_13d=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13b(evt);}});return {remove:function(){_13c.remove();_13d.remove();}};};_139.release=function(node,_13e){var _13f=on(node,_136.release,function(evt){if(evt.type=="mouseup"&&!_135.isLeft(evt)){return;}_13e(evt);}),_140=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13e(evt);}});return {remove:function(){_13f.remove();_140.remove();}};};_139.move=_136.move;return _139;});},"dojox/charting/plot2d/ClusteredColumns":function(){define(["dojo/_base/declare","./Columns","./common"],function(_141,_142,dc){return _141("dojox.charting.plot2d.ClusteredColumns",_142,{getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,width:f.size,thickness:f.size};}});});},"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_143,lang,arr,_144,_145,dom,_146,_147,_148,has,_149,_14a,_14b,_14c,_14d,g,_14e,func){var dc=lang.getObject("charting",true,_143),_14f=func.lambda("item.clear()"),_150=func.lambda("item.purgeGroup()"),_151=func.lambda("item.destroy()"),_152=func.lambda("item.dirty = false"),_153=func.lambda("item.dirty = true"),_154=func.lambda("item.name");var _155=_144(has("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(node,_156){if(!_156){_156={};}this.margins=_156.margins?_156.margins:{l:10,t:10,r:10,b:10};this.stroke=_156.stroke;this.fill=_156.fill;this.delayInMs=_156.delayInMs||200;this.title=_156.title;this.titleGap=_156.titleGap;this.titlePos=_156.titlePos;this.titleFont=_156.titleFont;this.titleFontColor=_156.titleFontColor;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _156){this.htmlLabels=_156.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=dom.byId(node);var box=_146.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){arr.forEach(this.series,_151);arr.forEach(this.stack,_151);func.forIn(this.axes,_151);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}},getCoords:function(){var node=this.node;var s=_145.getComputedStyle(node),_157=_146.getMarginBox(node,s);var abs=_146.position(node,true);_157.x=abs.x;_157.y=abs.y;return _157;},setTheme:function(_158){this.theme=_158.clone();this.dirty=true;return this;},addAxis:function(name,_159){var axis,_15a=_159&&_159.type||"Default";if(typeof _15a=="string"){if(!dc.axis2d||!dc.axis2d[_15a]){throw Error("Can't find axis: "+_15a+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_15a](this,_159);}else{axis=new _15a(this,_159);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_15b){var plot,_15c=_15b&&_15b.type||"Default";if(typeof _15c=="string"){if(!dc.plot2d||!dc.plot2d[_15c]){throw Error("Can't find plot: "+_15c+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_15c](this,_15b);}else{plot=new _15c(this,_15b);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _15d=this.plots[name];delete this.plots[name];this.stack[_15d].destroy();this.stack.splice(_15d,1);func.forIn(this.plots,function(idx,name,_15e){if(idx>_15d){_15e[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_15f){this.runs[run.plot]=_15f;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_154);},setPlotOrder:function(_160){var _161={},_162=func.filter(_160,function(name){if(!(name in this.plots)||(name in _161)){return false;}_161[name]=1;return true;},this);if(_162.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _161)){_162.push(name);}});}var _163=func.map(_162,function(name){return this.stack[this.plots[name]];},this);func.forEach(_163,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_163;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _164=this.plots[name];if(_164){var _165=this.getPlotOrder();_165.splice(_164,1);_165.unshift(name);return this.setPlotOrder(_165);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _166=this.plots[name];if(_166<this.stack.length-1){var _167=this.getPlotOrder();_167.splice(_166,1);_167.push(name);return this.setPlotOrder(_167);}}return this;},addSeries:function(name,data,_168){var run=new _14b(this,data,_168);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _169=this.runs[name];delete this.runs[name];this.series[_169].destroy();this.series.splice(_169,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_169){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data,_16a){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);if(_16a){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_16b){return func.map(func.filter(this.series,function(run){return run.plot==_16b;}),_154);},setSeriesOrder:function(_16c){var _16d,_16e={},_16f=func.filter(_16c,function(name){if(!(name in this.runs)||(name in _16e)){return false;}var run=this.series[this.runs[name]];if(_16d){if(run.plot!=_16d){return false;}}else{_16d=run.plot;}_16e[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _16e)&&run.plot==_16d){_16f.push(name);}});var _170=func.map(_16f,function(name){return this.series[this.runs[name]];},this);this.series=_170.concat(func.filter(this.series,function(run){return run.plot!=_16d;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _171=this.runs[name],_172=this.getSeriesOrder(this.series[_171].plot);if(name!=_172[0]){_172.splice(_171,1);_172.unshift(name);return this.setSeriesOrder(_172);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _173=this.runs[name],_174=this.getSeriesOrder(this.series[_173].plot);if(name!=_174[_174.length-1]){_174.splice(_173,1);_174.push(name);return this.setSeriesOrder(_174);}}return this;},resize:function(_175,_176){switch(arguments.length){case 1:_146.setMarginBox(this.node,_175);break;case 2:_146.setMarginBox(this.node,{w:_175,h:_176});break;}var box=_146.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_177,_178,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_177,_178);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _179,_17a,_17b=axis.getScaler().bounds,s=_17b.span/(_17b.upper-_17b.lower);if(axis.vertical){_179=sy;_17a=dy/s/_179;}else{_179=sx;_17a=dx/s/_179;}axis.setWindow(_179,_17a);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_17c,_17d){var axis=this.axes[name];if(axis){var _17e,_17f,_180=axis.getScaler().bounds;var _181=Math.min(_17c[0],_17c[1]);var _182=Math.max(_17c[0],_17c[1]);_181=_17c[0]<_180.lower?_180.lower:_181;_182=_17c[1]>_180.upper?_180.upper:_182;_17e=(_180.upper-_180.lower)/(_182-_181);_17f=_181-_180.lower;this.setAxisWindow(name,_17e,_17f);if(_17d){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _183=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_184(_183,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_14f);if(!this.theme){this.setTheme(new _14a());}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.assignAxes){plot.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_14f);_184(this.stack,dim);var _185=this.offsets={l:0,r:0,t:0,b:0};var self=this;func.forIn(this.axes,function(axis){if(has("dojo-bidi")){self._resetLeftBottom(axis);}func.forIn(axis.getOffsets(),function(o,i){_185[i]=Math.max(o,_185[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _186=g.normalizedLength(g.splitFontString(this.titleFont).size);_185[this.titlePos=="top"?"t":"b"]+=(_186+this.titleGap);}func.forIn(this.margins,function(o,i){_185[i]+=o;});this.plotArea={width:dim.width-_185.l-_185.r,height:dim.height-_185.t-_185.b};func.forIn(this.axes,_14f);_184(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _187=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_187.l-_187.r),h=Math.max(0,dim.height-_187.t-_187.b);arr.forEach(this.series,_150);func.forIn(this.axes,_150);arr.forEach(this.stack,_150);var _188=this.surface.children;if(_14d.dispose){for(var i=0;i<_188.length;++i){_14d.dispose(_188[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_187);if(this._nativeClip){this._renderPlotBackground(dim,_187,w,h);}else{this._renderPlotBackground(dim,_187,w,h);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_187),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_187);}if(this.title){var _189=(g.renderer=="canvas")&&this.htmlLabels,_18a=_189||!has("ie")&&!has("opera")&&this.htmlLabels?"html":"gfx",_18b=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_14c.createText[_18a](this,this.surface,dim.width/2,this.titlePos=="top"?_18b+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_187);});this._makeClean();return this;},_renderChartBackground:function(dim,_18c){var t=this.theme,rect;var fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _18d=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node;fill=new _148(_145.get(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _148(_145.get(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(this._nativeClip){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(fill);}else{fill=_149.prototype._plotFill(fill,dim,_18c);if(_18c.l){rect={x:0,y:0,width:_18c.l,height:dim.height+1};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.r){rect={x:dim.width-_18c.r,y:0,width:_18c.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.t){rect={x:0,y:0,width:dim.width+1,height:_18c.t};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.b){rect={x:0,y:dim.height-_18c.b,width:dim.width+1,height:_18c.b+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}}}if(_18d){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_18d);}},_renderPlotBackground:function(dim,_18e,w,h){var t=this.theme;var fill=t.plotarea&&t.plotarea.fill;var _18f=t.plotarea&&t.plotarea.stroke;var rect={x:_18e.l-1,y:_18e.t-1,width:w+2,height:h+2};if(fill){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim,_18e),rect);this.surface.createRect(rect).setFill(fill);}if(_18f){this.surface.createRect({x:_18e.l,y:_18e.t,width:w+1,height:h+1}).setStroke(_18f);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_190,_191){return name in this.plots?this.stack[this.plots[name]].connect(_190,_191):null;},fireEvent:function(_192,_193,_194){if(_192 in this.runs){var _195=this.series[this.runs[_192]].plot;if(_195 in this.plots){var plot=this.stack[this.plots[_195]];if(plot){plot.fireEvent(_192,_193,_194);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_152);arr.forEach(this.stack,_152);arr.forEach(this.series,_152);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_153);arr.forEach(this.stack,_153);arr.forEach(this.series,_153);this.dirty=true;},_invalidateDependentPlots:function(_196,_197){if(_196 in this.plots){var plot=this.stack[this.plots[_196]],axis,_198=_197?"vAxis":"hAxis";if(plot[_198]){axis=this.axes[plot[_198]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_198]&&p[_198]==plot[_198]){p.dirty=true;}});}}else{plot.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(axis){},formatTruncatedLabel:function(_199,_19a,_19b){}});function _19c(_19d){return {min:_19d.hmin,max:_19d.hmax};};function _19e(_19f){return {min:_19f.vmin,max:_19f.vmax};};function _1a0(_1a1,h){_1a1.hmin=h.min;_1a1.hmax=h.max;};function _1a2(_1a3,v){_1a3.vmin=v.min;_1a3.vmax=v.max;};function _1a4(_1a5,_1a6){if(_1a5&&_1a6){_1a5.min=Math.min(_1a5.min,_1a6.min);_1a5.max=Math.max(_1a5.max,_1a6.max);}return _1a5||_1a6;};function _184(_1a7,_1a8){var _1a9={},axes={};arr.forEach(_1a7,function(plot){var _1aa=_1a9[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1a4(axes[plot.hAxis],_19c(_1aa));}if(plot.vAxis){axes[plot.vAxis]=_1a4(axes[plot.vAxis],_19e(_1aa));}});arr.forEach(_1a7,function(plot){var _1ab=_1a9[plot.name];if(plot.hAxis){_1a0(_1ab,axes[plot.hAxis]);}if(plot.vAxis){_1a2(_1ab,axes[plot.vAxis]);}plot.initializeScalers(_1a8,_1ab);});};return has("dojo-bidi")?_144("dojox.charting.Chart",[_155,_14e]):_155;});},"dojox/charting/plot2d/MarkersOnly":function(){define(["dojo/_base/declare","./Default"],function(_1ac,_1ad){return _1ac("dojox.charting.plot2d.MarkersOnly",_1ad,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define(["dojo/_base/declare","./Default"],function(_1ae,_1af){return _1ae("dojox.charting.plot2d.Areas",_1af,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_1b0,_1b1){return _1b0("dojox.charting.action2d.Base",_1b1,{constructor:function(_1b2,plot){this.chart=_1b2;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1b3,dojo,_1b4,_1b5,_1b6,dom,_1b7,geom,_1b8,_1b9){if(!dojo.isAsync){_1b8(0,function(){var _1ba=["./fx/Toggler"];_1b9(_1ba);});}var _1bb=dojo.fx={};var _1bc={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1bd=function(_1be){this._index=-1;this._animations=_1be||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1b4.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1bd.prototype=new _1b3();lang.extend(_1bd,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_1bf,_1c0){if(!this._current){this._current=this._animations[this._index=0];}if(!_1c0&&this._current.status()=="playing"){return this;}var _1c1=_1b5.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_1c2=_1b5.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_1c3=_1b5.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_1c1.remove();_1c2.remove();_1c3.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1b5.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_1c4,_1c5){this.pause();var _1c6=this.duration*_1c4;this._current=null;_1b4.some(this._animations,function(a){if(a.duration<=_1c6){this._current=a;return true;}_1c6-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1c6/this._current.duration,_1c5);}return this;},stop:function(_1c7){if(this._current){if(_1c7){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1b5.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_1bd,_1bc);_1bb.chain=function(_1c8){return new _1bd(_1c8);};var _1c9=function(_1ca){this._animations=_1ca||[];this._connects=[];this._finished=0;this.duration=0;_1b4.forEach(_1ca,function(a){var _1cb=a.duration;if(a.delay){_1cb+=a.delay;}if(this.duration<_1cb){this.duration=_1cb;}this._connects.push(_1b5.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _1b6.Animation({curve:[0,1],duration:this.duration});var self=this;_1b4.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1b5.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_1c9,{_doAction:function(_1cc,args){_1b4.forEach(this._animations,function(a){a[_1cc].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1cd,args){var t=this._pseudoAnimation;t[_1cd].apply(t,args);},play:function(_1ce,_1cf){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1d0,_1d1){var ms=this.duration*_1d0;_1b4.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1d1);});this._call("gotoPercent",arguments);return this;},stop:function(_1d2){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1b4.forEach(this._connects,function(_1d3){_1d3.remove();});}});lang.extend(_1c9,_1bc);_1bb.combine=function(_1d4){return new _1c9(_1d4);};_1bb.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1d5=_1b7.get(node,"height");return Math.max(_1d5,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1b5.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1b7.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1b6.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1b5.after(anim,"beforeBegin",init,true);return anim;};return _1bb;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_1d6,Base,dfe,df){var _1d7=400,_1d8=dfe.backOut;return _1d6("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_1d9,plot,_1da){this.anim={};if(!_1da){_1da={};}this.duration=_1da.duration?_1da.duration:_1d7;this.easing=_1da.easing?_1da.easing:_1d8;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/plot2d/commonStacked":function(){define(["dojo/_base/lang","./common"],function(lang,_1db){var _1dc=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_1dc,{collectStats:function(_1dd){var _1de=lang.delegate(_1db.defaultStats);for(var i=0;i<_1dd.length;++i){var run=_1dd[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_1dc.getIndexValue(_1dd,i,j)[0];x=j+1;}else{x=run.data[j].x;if(x!==null){y=_1dc.getValue(_1dd,i,x)[0];y=y!=null&&y.y?y.y:null;}}_1de.hmin=Math.min(_1de.hmin,x);_1de.hmax=Math.max(_1de.hmax,x);_1de.vmin=Math.min(_1de.vmin,y);_1de.vmax=Math.max(_1de.vmax,y);}}}return _1de;},getIndexValue:function(_1df,i,_1e0){var _1e1=0,v,j,_1e2;for(j=0;j<=i;++j){_1e2=_1e1;v=_1df[j].data[_1e0];if(v!=null){if(isNaN(v)){v=v.y||0;}_1e1+=v;}}return [_1e1,_1e2];},getValue:function(_1e3,i,x){var _1e4=null,j,z,v,_1e5;for(j=0;j<=i;++j){for(z=0;z<_1e3[j].data.length;z++){_1e5=_1e4;v=_1e3[j].data[z];if(v!==null){if(v.x==x){if(!_1e4){_1e4={x:x};}if(v.y!=null){if(_1e4.y==null){_1e4.y=0;}_1e4.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return [_1e4,_1e5];}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_1e6,arr,fx,Hub,has){var fxg=g.fx={};function _1e7(_1e8,end){this.start=_1e8,this.end=end;};_1e7.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1e9(_1ea,end,_1eb){this.start=_1ea,this.end=end;this.units=_1eb;};_1e9.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1ec(_1ed,end){this.start=_1ed,this.end=end;this.temp=new _1e6();};_1ec.prototype.getValue=function(r){return _1e6.blendColors(this.start,this.end,r,this.temp);};function _1ee(_1ef){this.values=_1ef;this.length=_1ef.length;};_1ee.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f0(_1f1,def){this.values=_1f1;this.def=def?def:{};};_1f0.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f2(_1f3,_1f4){this.stack=_1f3;this.original=_1f4;};_1f2.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _1f5=new m.Matrix2D();for(var p in t.start){_1f5[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_1f5);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1f6=f.apply(m,val);if(_1f6 instanceof m.Matrix2D){ret.push(_1f6);}},this);return ret;};var _1f7=new _1e6(0,0,0,0);function _1f8(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1f9,_1fa,end;if(prop.start){_1fa=g.normalizeColor(prop.start);}else{_1fa=_1f9=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1f9){_1f9=obj?(name?obj[name]:obj):def;}end=_1f9;}return new _1ec(_1fa,end);};function _1fb(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1fc,_1fd,end;if(prop.start){_1fd=prop.start;}else{_1fd=_1fc=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _1fc!="number"){_1fc=obj?obj[name]:def;}end=_1fc;}return new _1e7(_1fd,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1fe=args.shape,_1ff;Hub.connect(anim,"beforeBegin",anim,function(){_1ff=_1fe.getStroke();var prop=args.color,_200={},_201,_202,end;if(prop){_200.color=_1f8(prop,_1ff,"color",_1f7);}prop=args.style;if(prop&&prop.values){_200.style=new _1ee(prop.values);}prop=args.width;if(prop){_200.width=_1fb(prop,_1ff,"width",1);}prop=args.cap;if(prop&&prop.values){_200.cap=new _1ee(prop.values);}prop=args.join;if(prop){if(prop.values){_200.join=new _1ee(prop.values);}else{_202=prop.start?prop.start:(_1ff&&_1ff.join||0);end=prop.end?prop.end:(_1ff&&_1ff.join||0);if(typeof _202=="number"&&typeof end=="number"){_200.join=new _1e7(_202,end);}}}this.curve=new _1f0(_200,_1ff);});Hub.connect(anim,"onAnimate",_1fe,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_203=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_203.getFill();var prop=args.color,_204={};if(prop){this.curve=_1f8(prop,fill,"",_1f7);}});Hub.connect(anim,"onAnimate",_203,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_205=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_205.getFont();var prop=args.style,_206={},_207,_208,end;if(prop&&prop.values){_206.style=new _1ee(prop.values);}prop=args.variant;if(prop&&prop.values){_206.variant=new _1ee(prop.values);}prop=args.weight;if(prop&&prop.values){_206.weight=new _1ee(prop.values);}prop=args.family;if(prop&&prop.values){_206.family=new _1ee(prop.values);}prop=args.size;if(prop&&prop.units){_208=parseFloat(prop.start?prop.start:(_205.font&&_205.font.size||"0"));end=parseFloat(prop.end?prop.end:(_205.font&&_205.font.size||"0"));_206.size=new _1e9(_208,end,prop.units);}this.curve=new _1f0(_206,font);});Hub.connect(anim,"onAnimate",_205,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,_20a;Hub.connect(anim,"beforeBegin",anim,function(){_20a=_209.getTransform();this.curve=new _1f2(args.transform,_20a);});Hub.connect(anim,"onAnimate",_209,"setTransform");if(g.renderer==="svg"&&has("ie")>=10){var _20b=[Hub.connect(anim,"onBegin",anim,function(){var _20c=_209.getParent();while(_20c&&_20c.getParent){_20c=_20c.getParent();}if(_20c){_209.__svgContainer=_20c.rawNode.parentNode;}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;_209.__svgContainer.style.visibility="visible";var _20d=_209.__svgContainer.offsetHeight;_209.__svgContainer.style.visibility=ov;}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_20b,Hub.disconnect);if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;var sn=_209.__svgContainer;_209.__svgContainer.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn=null;}catch(e){}},100);}delete _209.__svgContainer;})];}return anim;};return fxg;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_20e,_20f,_210,_211,_212,lang,on,has){has.add("config-bgIframe",!has("touch"));var _213=new function(){var _214=[];this.pop=function(){var _215;if(_214.length){_215=_214.pop();_215.style.display="";}else{if(has("ie")<9){var burl=_210["dojoBlankHtmlUrl"]||_20e.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_215=document.createElement(html);}else{_215=_211.create("iframe");_215.src="javascript:\"\"";_215.className="dijitBackgroundIframe";_215.setAttribute("role","presentation");_212.set(_215,"opacity",0.1);}_215.tabIndex=-1;}return _215;};this.push=function(_216){_216.style.display="none";_214.push(_216);};}();_20f.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _217=(this.iframe=_213.pop());node.appendChild(_217);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_212.set(_217,{width:"100%",height:"100%"});}}};lang.extend(_20f.BackgroundIframe,{resize:function(node){if(this.iframe){_212.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_213.push(this.iframe);delete this.iframe;}}});return _20f.BackgroundIframe;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_218,_219,m,gf,df,dfe){var _21a=2;return _218("dojox.charting.action2d.Magnify",_219,{defaultParams:{duration:400,easing:dfe.backOut,scale:_21a},optionalParams:{},constructor:function(_21b,plot,_21c){this.scale=_21c&&typeof _21c.scale=="number"?_21c.scale:_21a;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}if(o.element=="spider_plot"||o.element=="spider_poly"){return;}var _21d=o.run.name,_21e=o.index,_21f=[],anim,init,_220;if(_21d in this.anim){anim=this.anim[_21d][_21e];}else{this.anim[_21d]={};}if(anim){anim.action.stop(true);}else{this.anim[_21d][_21e]=anim={};}if(o.type=="onmouseover"){init=m.identity;_220=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_220=1/this.scale;}var _221={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_220,o.cx,o.cy]},init]};if(o.shape){_21f.push(gf.animateTransform(_221));}if(o.outline){_221.shape=o.outline;_21f.push(gf.animateTransform(_221));}if(o.shadow){_221.shape=o.shadow;_21f.push(gf.animateTransform(_221));}if(!_21f.length){delete this.anim[_21d][_21e];return;}anim.action=df.combine(_21f);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_21d]){delete this.anim[_21d][_21e];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_222,lang,_223,when){return _222("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_224){if(_224){this.set(_224);}},_get:function(name,_225){return typeof this[_225.g]==="function"?this[_225.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_226){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _227=this._getAttrNames(name),_228=this._get(name,_227),_229=this[_227.s],_22a;if(typeof _229==="function"){_22a=_229.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_226;}if(this._watchCallbacks){var self=this;when(_22a,function(){self._watchCallbacks(name,_228,_226);});}return this;},_changeAttrValue:function(name,_22b){var _22c=this.get(name);this[name]=_22b;if(this._watchCallbacks){this._watchCallbacks(name,_22c,_22b);}return this;},watch:function(name,_22d){var _22e=this._watchCallbacks;if(!_22e){var self=this;_22e=this._watchCallbacks=function(name,_22f,_230,_231){var _232=function(_233){if(_233){_233=_233.slice();for(var i=0,l=_233.length;i<l;i++){_233[i].call(self,name,_22f,_230);}}};_232(_22e["_"+name]);if(!_231){_232(_22e["*"]);}};}if(!_22d&&typeof name==="function"){_22d=name;name="*";}else{name="_"+name;}var _234=_22e[name];if(typeof _234!=="object"){_234=_22e[name]=[];}_234.push(_22d);var _235={};_235.unwatch=_235.remove=function(){var _236=_223.indexOf(_234,_22d);if(_236>-1){_234.splice(_236,1);}};return _235;}});});},"dojox/charting/plot2d/Markers":function(){define(["dojo/_base/declare","./Default"],function(_237,_238){return _237("dojox.charting.plot2d.Markers",_238,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_239,arr,has,_23a,_23b,dc,df,dfr,du,fx){var _23c=dfr.lambda("item.purgeGroup()");return _239("dojox.charting.plot2d.Bubble",[_23a,_23b],{defaultParams:{animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelFunc:null},constructor:function(_23d,_23e){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_23e);du.updateWithPattern(this.opt,_23e,this.optionalParams);if(!this.opt.labelFunc){this.opt.labelFunc=function(_23f,_240,_241){return this._getLabel(_23f.size,_240,_241);};}this.animate=this.opt.animate;},render:function(dim,_242){var s;if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_242);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_23c);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_243=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}s=run.group;var _244=t.next("circle",[this.opt,run]),_245=arr.map(run.data,function(v){return v?{x:ht(v.x)+_242.l,y:dim.height-_242.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _246=null,_247=null,_248=null,_249=this.opt.styleFunc;var _24a=function(item){if(_249){return t.addMixin(_244,"circle",[item,_249(item)],true);}return t.addMixin(_244,"circle",item,true);};if(_244.series.shadow){_248=arr.map(_245,function(item,i){if(item!==null){var _24b=_24a(run.data[i]),_24c=_24b.series.shadow;var _24d=s.createCircle({cx:item.x+_24c.dx,cy:item.y+_24c.dy,r:item.radius}).setStroke(_24c).setFill(_24c.color);if(this.animate){this._animateBubble(_24d,dim.height-_242.b,item.radius);}return _24d;}return null;},this);if(_248.length){run.dyn.shadow=_248[_248.length-1].getStroke();}}if(_244.series.outline){_247=arr.map(_245,function(item,i){if(item!==null){var _24e=_24a(run.data[i]),_24f=dc.makeStroke(_24e.series.outline);_24f.width=2*_24f.width+_244.series.stroke.width;var _250=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_24f);if(this.animate){this._animateBubble(_250,dim.height-_242.b,item.radius);}return _250;}return null;},this);if(_247.length){run.dyn.outline=_247[_247.length-1].getStroke();}}_246=arr.map(_245,function(item,i){if(item!==null){var _251=_24a(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _252=this._plotFill(_251.series.fill,dim,_242);_252=this._shapeFill(_252,rect);var _253=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_252).setStroke(_251.series.stroke);if(_253.setFilter&&_251.series.filter){_253.setFilter(_251.series.filter);}if(this.animate){this._animateBubble(_253,dim.height-_242.b,item.radius);}this.createLabel(s,run.data[i],rect,_251);return _253;}return null;},this);if(_246.length){run.dyn.fill=_246[_246.length-1].getFill();run.dyn.stroke=_246[_246.length-1].getStroke();}if(_243){var _254=new Array(_246.length);arr.forEach(_246,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_247&&_247[i]||null,shadow:_248&&_248[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_245[i].x,cy:_245[i].y,cr:_245[i].radius};this._connectEvents(o);_254[i]=o;}},this);this._eventSeries[run.name]=_254;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_242);}return this;},_animateBubble:function(_255,_256,size){fx.animateTransform(lang.delegate({shape:_255,duration:1200,transform:[{name:"translate",start:[0,_256],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_257,dom,_258,lang,on,has,_259,_25a,win){var _25b=has("touch");var ios4=has("ios")<5;var _25c=navigator.pointerEnabled||navigator.msPointerEnabled,_25d=(function(){var _25e={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_25e[type]=!navigator.pointerEnabled?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _25e;})();var _25f,_260,_261,_262,_263,_264,_265,_266;var _267;function _268(_269,_26a,_26b){if(_25c&&_26b){return function(node,_26c){return on(node,_26b,_26c);};}else{if(_25b){return function(node,_26d){var _26e=on(node,_26a,function(evt){_26d.call(this,evt);_267=(new Date()).getTime();}),_26f=on(node,_269,function(evt){if(!_267||(new Date()).getTime()>_267+1000){_26d.call(this,evt);}});return {remove:function(){_26e.remove();_26f.remove();}};};}else{return function(node,_270){return on(node,_269,_270);};}}};function _271(node){do{if(node.dojoClick!==undefined){return node.dojoClick;}}while(node=node.parentNode);};function _272(e,_273,_274){_260=!e.target.disabled&&_271(e.target);if(_260){_261=e.target;_262=e.changedTouches?e.changedTouches[0].pageX:e.clientX;_263=e.changedTouches?e.changedTouches[0].pageY:e.clientY;_264=(typeof _260=="object"?_260.x:(typeof _260=="number"?_260:0))||4;_265=(typeof _260=="object"?_260.y:(typeof _260=="number"?_260:0))||4;if(!_25f){_25f=true;win.doc.addEventListener(_273,function(e){_260=_260&&(e.changedTouches?e.changedTouches[0].target:e.target)==_261&&Math.abs((e.changedTouches?e.changedTouches[0].pageX:e.clientX)-_262)<=_264&&Math.abs((e.changedTouches?e.changedTouches[0].pageY:e.clientY)-_263)<=_265;},true);win.doc.addEventListener(_274,function(e){if(_260){_266=(new Date()).getTime();var _275=e.target;if(_275.tagName==="LABEL"){_275=dom.byId(_275.getAttribute("for"))||_275;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _276=document.createEvent("MouseEvents");_276._dojo_click=true;_276.initMouseEvent("click",true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);setTimeout(function(){on.emit(_275,"click",_276);},0);}},true);function _277(type){win.doc.addEventListener(type,function(e){if(!e._dojo_click&&(new Date()).getTime()<=_266+1000&&!(e.target.tagName=="INPUT"&&_258.contains(e.target,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(e.target.tagName!="INPUT"||e.target.type=="radio"||e.target.type=="checkbox")&&e.target.tagName!="TEXTAREA"&&e.target.tagName!="AUDIO"&&e.target.tagName!="VIDEO"){e.preventDefault();}}},true);};_277("click");_277("mousedown");_277("mouseup");}}};var _278;if(_25b){if(_25c){_25a(function(){win.doc.addEventListener(_25d.down,function(evt){_272(evt,_25d.move,_25d.up);},true);});}else{_25a(function(){_278=win.body();win.doc.addEventListener("touchstart",function(evt){_267=(new Date()).getTime();var _279=_278;_278=evt.target;on.emit(_279,"dojotouchout",{relatedTarget:_278,bubbles:true});on.emit(_278,"dojotouchover",{relatedTarget:_279,bubbles:true});_272(evt,"touchmove","touchend");},true);function _27a(evt){var _27b=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_27b.touches=evt.touches;_27b.altKey=evt.altKey;_27b.changedTouches=evt.changedTouches;_27b.ctrlKey=evt.ctrlKey;_27b.metaKey=evt.metaKey;_27b.shiftKey=evt.shiftKey;_27b.targetTouches=evt.targetTouches;}return _27b;};on(win.doc,"touchmove",function(evt){_267=(new Date()).getTime();var _27c=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_27c){if(_278!==_27c){on.emit(_278,"dojotouchout",{relatedTarget:_27c,bubbles:true});on.emit(_27c,"dojotouchover",{relatedTarget:_278,bubbles:true});_278=_27c;}if(!on.emit(_27c,"dojotouchmove",_27a(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_267=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_27a(evt));});});}}var _27d={press:_268("mousedown","touchstart",_25d.down),move:_268("mousemove","dojotouchmove",_25d.move),release:_268("mouseup","dojotouchend",_25d.up),cancel:_268(_259.leave,"touchcancel",_25b?_25d.cancel:null),over:_268("mouseover","dojotouchover",_25d.over),out:_268("mouseout","dojotouchout",_25d.out),enter:_259._eventHandler(_268("mouseover","dojotouchover",_25d.over)),leave:_259._eventHandler(_268("mouseout","dojotouchout",_25d.out))};1&&(dojo.touch=_27d);return _27d;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_27e){var _27f=g.gradutils={};function _280(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _27e.blendColors(new _27e(prev.color),new _27e(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_27f.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _281=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_282=m.rotate(-_281),_283=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_283,pt),pf1=m.multiplyPoint(_283,fill.x1,fill.y1),pf2=m.multiplyPoint(_283,fill.x2,fill.y2),_284=m.multiplyPoint(_282,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_282,p.x-pf1.x,p.y-pf1.y).x/_284;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _280(o,fill.colors);}return new _27e(fill||[0,0,0,0]);};_27f.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _27f;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_285,_286,_287,_288,has,_289,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_286.blankGif||_285.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_288.getComputedStyle(div),_28a=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_28a&&(_28a=="none"||_28a=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_289(function(){if(has("highcontrast")){_287.add(win.body(),"dj_a11y");}});return has;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_28b,lang){var _28c={};lang.setObject("dojo.string",_28c);_28c.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_28c.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_28c.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_28c.substitute=function(_28d,map,_28e,_28f){_28f=_28f||_28b.global;_28e=_28e?lang.hitch(_28f,_28e):function(v){return v;};return _28d.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_290,key,_291){var _292=lang.getObject(key,false,map);if(_291){_292=lang.getObject(_291,false,_28f).call(_28f,_292,key);}return _28e(_292,key).toString();});};_28c.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _28c;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_293,_294,_295,_296,lang,_297,on,_298,_299){var _29a=lang.delegate(_298,{"mouseenter":_297.enter,"mouseleave":_297.leave,"keypress":_295._keypress});var _29b;var _29c=_296("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_29d){var node=_29d;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_29d){return;}while(!node.nextSibling){node=node.parentNode;if(node==_29d){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_29e,_29f,_2a0){var ret=true;var _2a1=this.attachScope||this,_2a2=_29f(_29e,"dojoAttachPoint")||_29f(_29e,"data-dojo-attach-point");if(_2a2){var _2a3,_2a4=_2a2.split(/\s*,\s*/);while((_2a3=_2a4.shift())){if(lang.isArray(_2a1[_2a3])){_2a1[_2a3].push(_29e);}else{_2a1[_2a3]=_29e;}ret=(_2a3!="containerNode");this._attachPoints.push(_2a3);}}var _2a5=_29f(_29e,"dojoAttachEvent")||_29f(_29e,"data-dojo-attach-event");if(_2a5){var _2a6,_2a7=_2a5.split(/\s*,\s*/);var trim=lang.trim;while((_2a6=_2a7.shift())){if(_2a6){var _2a8=null;if(_2a6.indexOf(":")!=-1){var _2a9=_2a6.split(":");_2a6=trim(_2a9[0]);_2a8=trim(_2a9[1]);}else{_2a6=trim(_2a6);}if(!_2a8){_2a8=_2a6;}this._attachEvents.push(_2a0(_29e,_2a6,lang.hitch(_2a1,_2a8)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_29b||(_29b=_293("./a11yclick"));}else{type=_29a[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _2aa=this.attachScope||this;_294.forEach(this._attachPoints,function(_2ab){delete _2aa[_2ab];});this._attachPoints=[];_294.forEach(this._attachEvents,function(_2ac){_2ac.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_299,{dojoAttachEvent:"",dojoAttachPoint:""});return _29c;});},"dojox/charting/plot2d/Lines":function(){define(["dojo/_base/declare","./Default"],function(_2ad,_2ae){return _2ad("dojox.charting.plot2d.Lines",_2ae,{constructor:function(){this.opt.lines=true;}});});},"dijit/registry":function(){define(["dojo/_base/array","dojo/sniff","dojo/_base/window","./main"],function(_2af,has,win,_2b0){var _2b1={},hash={};var _2b2={length:0,add:function(_2b3){if(hash[_2b3.id]){throw new Error("Tried to register widget with id=="+_2b3.id+" but that id is already registered");}hash[_2b3.id]=_2b3;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_2b4){var id;do{id=_2b4+"_"+(_2b4 in _2b1?++_2b1[_2b4]:_2b1[_2b4]=0);}while(hash[id]);return _2b0._scopeName=="dijit"?id:_2b0._scopeName+"_"+id;},findWidgets:function(root,_2b5){var _2b6=[];function _2b7(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _2b8=node.getAttribute("widgetId");if(_2b8){var _2b9=hash[_2b8];if(_2b9){_2b6.push(_2b9);}}else{if(node!==_2b5){_2b7(node);}}}}};_2b7(root);return _2b6;},_destroyAll:function(){_2b0._curFocus=null;_2b0._prevFocus=null;_2b0._activeStack=[];_2af.forEach(_2b2.findWidgets(win.body()),function(_2ba){if(!_2ba._destroyed){if(_2ba.destroyRecursive){_2ba.destroyRecursive();}else{if(_2ba.destroy){_2ba.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_2b0.registry=_2b2;return _2b2;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_2bb,_2bc,_2bd){return _2bd("dijit.Destroyable",null,{destroy:function(_2be){this._destroyed=true;},own:function(){_2bb.forEach(arguments,function(_2bf){var _2c0="destroyRecursive" in _2bf?"destroyRecursive":"destroy" in _2bf?"destroy":"remove";var odh=_2bc.before(this,"destroy",function(_2c1){_2bf[_2c0](_2c1);});var hdh=_2bc.after(_2bf,_2c0,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dojox/charting/plot2d/StackedAreas":function(){define(["dojo/_base/declare","./Stacked"],function(_2c2,_2c3){return _2c2("dojox.charting.plot2d.StackedAreas",_2c3,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_2c4,_2c5,lang,_2c6,_2c7){var _2c8={};_2c4.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_2c8[name]=_2c6[name];});lang.mixin(_2c8,{defaultDuration:_2c5["defaultDuration"]||200});lang.mixin(_2c7,_2c8);return _2c7;});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","./Default","./commonStacked"],function(_2c9,_2ca,_2cb){return _2c9("dojox.charting.plot2d.Stacked",_2ca,{getSeriesStats:function(){var _2cc=_2cb.collectStats(this.series);return _2cc;},buildSegments:function(i,_2cd){var run=this.series[i],min=_2cd?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_2cd?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_2ce=[];for(var j=min;j<=max;j++){var _2cf=_2cd?_2cb.getIndexValue(this.series,i,j):_2cb.getValue(this.series,i,run.data[j]?run.data[j].x:null);if(_2cf[0]!=null&&(_2cd||_2cf[0].y!=null)){if(!rseg){rseg=[];_2ce.push({index:j,rseg:rseg});}rseg.push(_2cf[0]);}else{if(!this.opt.interpolate||_2cd){rseg=null;}}}return _2ce;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _2d0={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_2d0.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _2d0.bounceIn(n*2)/2;}return (_2d0.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_2d0);return _2d0;});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_2d1,_2d2,hub,c,_2d3,dfe,dgf){var _2d4=100,_2d5=75,_2d6=50,cc=function(_2d7){return function(){return _2d7;};},hl=function(_2d8){var a=new c.Color(_2d8),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_2d4;if(x.l<_2d6){x.l=_2d5;}else{if(x.l>_2d5){x.l=_2d6;}else{x.l=x.l-_2d6>_2d5-x.l?_2d6:_2d5;}}}var _2d9=c.fromHsl(x);_2d9.a=a.a;return _2d9;},_2da=function(_2db){var r=hl(_2db);r.a=0.7;return r;};return _2d1("dojox.charting.action2d.Highlight",_2d3,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_2dc,plot,_2dd){var a=_2dd&&_2dd.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_2da;}}var _2de=o.run.name,_2df=o.index,anim;if(_2de in this.anim){anim=this.anim[_2de][_2df];}else{this.anim[_2de]={};}if(anim){anim.action.stop(true);}else{var _2e0=o.shape.getFill();if(!_2e0||!(_2e0 instanceof _2d2)){return;}this.anim[_2de][_2df]=anim={start:_2e0,end:this.colorFunc(_2e0)};}var _2e1=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_2e1;_2e1=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_2e1,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_2de]){delete this.anim[_2de][_2df];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_2e2,_2e3){return _2e2("dojox.charting.axis2d.Base",_2e3,{constructor:function(_2e4,_2e5){this.vertical=_2e5&&_2e5.vertical;this.opt={};this.opt.min=_2e5&&_2e5.min;this.opt.max=_2e5&&_2e5.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2e6){this.dirty=false;return this;}});});},"dojox/charting/plot2d/Grid":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/sniff","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2e7,arr,has,_2e8,dc,du,fx){var _2e9=function(a,b){return a.value-b.value;};return _2e7("dojox.charting.plot2d.Grid",_2e8,{defaultParams:{hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{},hFill:{},vFill:{},hAlternateFill:{},vAlternateFill:{}},constructor:function(_2ea,_2eb){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2eb);du.updateWithPattern(this.opt,_2eb,this.optionalParams);this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];this._rectFreePool=[];this._rectUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._rectFreePool=this._rectFreePool.concat(this._rectUsePool);this._rectUsePool=[];}},createLine:function(_2ec,_2ed){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2ed);_2ec.add(line);}else{line=_2ec.createLine(_2ed);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},createRect:function(_2ee,_2ef){var rect;if(this.opt.enableCache&&this._rectFreePool.length>0){rect=this._rectFreePool.pop();rect.setShape(_2ef);_2ee.add(rect);}else{rect=_2ee.createRect(_2ef);}if(this.opt.enableCache){this._rectUsePool.push(rect);}return rect;},render:function(dim,_2f0){if(this.zoom){return this.performZoom(dim,_2f0);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.getGroup(),ta=this.chart.theme,_2f1,_2f2;if((has("ios")&&has("ios")<6)||has("android")||(has("safari")&&!has("ios"))){var w=Math.max(0,dim.width-_2f0.l-_2f0.r),h=Math.max(0,dim.height-_2f0.t-_2f0.b);s.createRect({x:_2f0.l,y:_2f0.t,width:w,height:h});}if(this._vAxis){_2f2=this._vAxis.getTicks();var _2f3=this._vAxis.getScaler();if(_2f2!=null&&_2f3!=null){var vt=_2f3.scaler.getTransformerFromModel(_2f3);if(this.opt.hStripes){this._renderHRect(_2f2,ta.grid,dim,_2f0,_2f3,vt);}if(this.opt.hMinorLines){_2f1=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderHLines(_2f2.minor,_2f1,dim,_2f0,_2f3,vt);}if(this.opt.hMajorLines){_2f1=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderHLines(_2f2.major,_2f1,dim,_2f0,_2f3,vt);}}}if(this._hAxis){_2f2=this._hAxis.getTicks();var _2f4=this._hAxis.getScaler();if(_2f2!=null&&_2f4!=null){var ht=_2f4.scaler.getTransformerFromModel(_2f4);if(this.opt.vStripes){this._renderVRect(_2f2,ta.grid,dim,_2f0,_2f4,ht);}if(_2f2&&this.opt.vMinorLines){_2f1=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderVLines(_2f2.minor,_2f1,dim,_2f0,_2f4,ht);}if(_2f2&&this.opt.vMajorLines){_2f1=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderVLines(_2f2.major,_2f1,dim,_2f0,_2f4,ht);}}}this.dirty=false;return this;},_renderHLines:function(_2f5,_2f6,dim,_2f7,_2f8,vt){var s=this.getGroup();arr.forEach(_2f5,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._vAxis.opt.leftBottom?_2f8.bounds.from:_2f8.bounds.to)){return;}var y=dim.height-_2f7.b-vt(tick.value);var _2f9=this.createLine(s,{x1:_2f7.l,y1:y,x2:dim.width-_2f7.r,y2:y}).setStroke(_2f6);if(this.animate){this._animateGrid(_2f9,"h",_2f7.l,_2f7.r+_2f7.l-dim.width);}},this);},_renderVLines:function(_2fa,_2fb,dim,_2fc,_2fd,ht){var s=this.getGroup();arr.forEach(_2fa,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._hAxis.opt.leftBottom?_2fd.bounds.from:_2fd.bounds.to)){return;}var x=_2fc.l+ht(tick.value);var _2fe=this.createLine(s,{x1:x,y1:_2fc.t,x2:x,y2:dim.height-_2fc.b}).setStroke(_2fb);if(this.animate){this._animateGrid(_2fe,"v",dim.height-_2fc.b,dim.height-_2fc.b-_2fc.t);}},this);},_renderHRect:function(_2ff,_300,dim,_301,_302,vt){var fill,tick,y,y2,_303;var _304=_2ff.major.concat(_2ff.minor);_304.sort(_2e9);if(_304[0].value>_302.bounds.from){_304.splice(0,0,{value:_302.bounds.from});}if(_304[_304.length-1].value<_302.bounds.to){_304.push({value:_302.bounds.to});}var s=this.getGroup();for(var j=0;j<_304.length-1;j++){tick=_304[j];y=dim.height-_301.b-vt(tick.value);y2=dim.height-_301.b-vt(_304[j+1].value);fill=(j%2==0)?(this.opt.hAlternateFill||(_300&&_300.alternateFill)):(this.opt.hFill||(_300&&_300.fill));if(fill){_303=this.createRect(s,{x:_301.l,y:y,width:dim.width-_301.r,height:y-y2}).setFill(fill);if(this.animate){this._animateGrid(_303,"h",_301.l,_301.r+_301.l-dim.width);}}}},_renderVRect:function(_305,_306,dim,_307,_308,ht){var fill,tick,x,x2,_309;var _30a=_305.major.concat(_305.minor);_30a.sort(_2e9);if(_30a[0].value>_308.bounds.from){_30a.splice(0,0,{value:_308.bounds.from});}if(_30a[_30a.length-1].value<_308.bounds.to){_30a.push({value:_308.bounds.to});}var s=this.getGroup();for(var j=0;j<_30a.length-1;j++){tick=_30a[j];x=_307.l+ht(tick.value);x2=_307.l+ht(_30a[j+1].value);fill=(j%2==0)?(this.opt.vAlternateFill||(_306&&_306.alternateFill)):(this.opt.vFill||(_306&&_306.fill));if(fill){_309=this.createRect(s,{x:x,y:_307.t,width:x2-x,height:dim.width-_307.r}).setFill(fill);if(this.animate){this._animateGrid(_309,"v",dim.height-_307.b,dim.height-_307.b-_307.t);}}}},_animateGrid:function(_30b,type,_30c,size){var _30d=type=="h"?[_30c,0]:[0,_30c];var _30e=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_30b,duration:1200,transform:[{name:"translate",start:_30d,end:[0,0]},{name:"scale",start:_30e,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_30f,dom,_310,_311,lang,has,_312){var _313;var a11y={_isElementShown:function(elem){var s=_311.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_310.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _310.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _314=elem.contentDocument;if("designMode" in _314&&_314.designMode=="on"){return true;}body=_314.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_310.get(elem,"disabled")){return _313;}else{if(_310.has(elem,"tabIndex")){return +_310.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_313;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _315,last,_316,_317,_318,_319,_31a={};function _31b(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _31c=a11y._isElementShown,_31d=a11y.effectiveTabIndex;var _31e=function(_31f){for(var _320=_31f.firstChild;_320;_320=_320.nextSibling){if(_320.nodeType!=1||(has("ie")<=9&&_320.scopeName!=="HTML")||!_31c(_320)){continue;}var _321=_31d(_320);if(_321>=0){if(_321==0){if(!_315){_315=_320;}last=_320;}else{if(_321>0){if(!_316||_321<_317){_317=_321;_316=_320;}if(!_318||_321>=_319){_319=_321;_318=_320;}}}var rn=_31b(_320);if(_310.get(_320,"checked")&&rn){_31a[rn]=_320;}}if(_320.nodeName.toUpperCase()!="SELECT"){_31e(_320);}}};if(_31c(root)){_31e(root);}function rs(node){return _31a[_31b(node)]||node;};return {first:rs(_315),last:rs(last),lowest:rs(_316),highest:rs(_318)};},getFirstInTabbingOrder:function(root,doc){var _322=a11y._getTabNavigable(dom.byId(root,doc));return _322.lowest?_322.lowest:_322.first;},getLastInTabbingOrder:function(root,doc){var _323=a11y._getTabNavigable(dom.byId(root,doc));return _323.last?_323.last:_323.highest;}};1&&lang.mixin(_312,a11y);return a11y;});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_324,df){var _325={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_324.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _325)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_324.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _326=true;for(i in a){if(!(i in _325)){if(_326){z=a[i];_326=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_324.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_324.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_324.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/charting/plot2d/Spider":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/sniff","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_327,hub,arr,_328,_329,_32a,has,Base,_32b,dc,da,g,m,_32c,df,du,_32d){var _32e=0.2;var _32f=_327("dojox.charting.plot2d.Spider",[Base,_32b],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_32d.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_330,_331){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_331);du.updateWithPattern(this.opt,_331,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){this.series.push(run);var key;for(key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _332="__"+key;this.axes.push(_332);this[_332]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},render:function(dim,_333){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_333.l-_333.r)/2,ry=(dim.height-_333.t-_333.b)/2,r=Math.min(rx,ry),_334=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_335=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_336=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_337=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_338=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_339=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_33a=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_33b=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_33c=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_33d=g.normalizedLength(g.splitFontString(_335).size),_33e=m._degToRad(o.startAngle),_33f=_33e,_340,_341,_342,_343,_344,_345,_346,_347,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_348=o.labelOffset<-10?o.labelOffset:-10,_349=0.2,i,j,_34a,len,_34b,_34c,_34d,run,data,min,max,_34e;if(o.labels){_340=arr.map(this.series,function(s){return s.name;},this);_341=df.foldl1(df.map(_340,function(_34f){var font=t.series.font;return g._base._getTextBox(_34f,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_341,ry-_33d)+_348;_342=r-_348;}if("radius" in o){r=o.radius;_342=r-_348;}r/=(1+_349);var _350={cx:_333.l+rx,cy:_333.t+ry,r:r};for(i=this.series.length-1;i>=0;i--){_34d=this.series[i];if(!this.dirty&&!_34d.dirty){t.skip();continue;}_34d.cleanGroup();run=_34d.data;if(run!==null){len=this._getObjectLength(run);if(!_343||_343.length<=0){_343=[],_344=[],_347=[];this._buildPoints(_343,len,_350,r,_33f,true,dim);this._buildPoints(_344,len,_350,r*ro,_33f,true,dim);this._buildPoints(_347,len,_350,_342,_33f,false,dim);if(dv>2){_345=[],_346=[];for(j=0;j<dv-2;j++){_345[j]=[];this._buildPoints(_345[j],len,_350,r*(ro+(1-ro)*(j+1)/(dv-1)),_33f,true,dim);_346[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _351=s.createGroup(),_352={color:_338,width:_33a},_353={color:_339,width:_33b};for(j=_343.length-1;j>=0;--j){_34a=_343[j];var st={x:_34a.x+(_34a.x-_350.cx)*_349,y:_34a.y+(_34a.y-_350.cy)*_349},nd={x:_34a.x+(_34a.x-_350.cx)*_349/2,y:_34a.y+(_34a.y-_350.cy)*_349/2};_351.createLine({x1:_350.cx,y1:_350.cy,x2:st.x,y2:st.y}).setStroke(_352);this._drawArrow(_351,st,nd,_352);}var _354=s.createGroup();for(j=_347.length-1;j>=0;--j){_34a=_347[j];_34b=g._base._getTextBox(this.labelKey[j],{font:_335}).w||0;_34c=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";var elem=da.createText[_34c](this.chart,_354,(!_328.isBodyLtr()&&_34c=="html")?(_34a.x+_34b-dim.width):_34a.x,_34a.y,"middle",this.labelKey[j],_335,_337);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _355=s.createGroup();if(spt=="polygon"){_355.createPolyline(_343).setStroke(_353);_355.createPolyline(_344).setStroke(_353);if(_345.length>0){for(j=_345.length-1;j>=0;--j){_355.createPolyline(_345[j]).setStroke(_353);}}}else{_355.createCircle({cx:_350.cx,cy:_350.cy,r:r}).setStroke(_353);_355.createCircle({cx:_350.cx,cy:_350.cy,r:r*ro}).setStroke(_353);if(_346.length>0){for(j=_346.length-1;j>=0;--j){_355.createCircle({cx:_350.cx,cy:_350.cy,r:_346[j]}).setStroke(_353);}}}len=this._getObjectLength(this.datas);var _356=s.createGroup(),k=0;for(var key in this.datas){data=this.datas[key];min=data.min;max=data.max;_34e=max-min;end=_33f+2*Math.PI*k/len;for(i=0;i<dv;i++){var text=min+_34e*i/(dv-1);_34a=this._getCoordinate(_350,r*(ro+(1-ro)*i/(dv-1)),end,dim);text=this._getLabel(text);_34b=g._base._getTextBox(text,{font:_334}).w||0;_34c=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_34c](this.chart,_356,(!_328.isBodyLtr()&&_34c=="html")?(_34a.x+_34b-dim.width):_34a.x,_34a.y,"start",text,_334,_336));}}k++;}this.chart.seriesShapes={};for(i=this.series.length-1;i>=0;i--){_34d=this.series[i];run=_34d.data;if(run!==null){var _357=[],_358=[];k=0;for(key in run){data=this.datas[key];min=data.min;max=data.max;_34e=max-min;var _359=run[key],end=_33f+2*Math.PI*k/len;_34a=this._getCoordinate(_350,r*(ro+(1-ro)*(_359-min)/_34e),end,dim);_357.push(_34a);_358.push({sname:_34d.name,key:key,data:_359});k++;}_357[_357.length]=_357[0];_358[_358.length]=_358[0];var _35a=this._getBoundary(_357),_35b=t.next("spider",[o,_34d]),ts=_34d.group,f=g.normalizeColor(_35b.series.fill),sk={color:_35b.series.fill,width:_33c};f.a=o.seriesFillAlpha;_34d.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_34d.name];var cs=this._createSeriesEntry(ts,(osps||_344),_357,f,sk,r,ro,ms,at);this.chart.seriesShapes[_34d.name]=cs;this.oldSeriePoints[_34d.name]=_357;var po={element:"spider_poly",index:i,id:"spider_poly_"+_34d.name,run:_34d,plot:this,shape:cs.poly,parent:ts,brect:_35a,cx:_350.cx,cy:_350.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_34d.name,run:_34d,plot:this,shape:_34d.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var co={element:"spider_circle",index:i,id:"spider_circle_"+_34d.name+i,run:_34d,plot:this,shape:c,parent:ts,tdata:_358[i],cx:_357[i].x,cy:_357[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _35c=ts.createPolyline(osps).setFill(f).setStroke(sk),_35d=[];for(var j=0;j<osps.length;j++){var _35e=osps[j],cr=ms;var _35f=ts.createCircle({cx:_35e.x,cy:_35e.y,r:cr}).setFill(f).setStroke(sk);_35d.push(_35f);}var _360=arr.map(sps,function(np,j){var sp=osps[j],anim=new _329.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_35c,sc=_35d[j];hub.connect(anim,"onAnimate",function(y){var _361=spl.getShape();_361.points[j].y=y;spl.setShape(_361);var _362=sc.getShape();_362.cy=y;sc.setShape(_362);});return anim;});var _363=arr.map(sps,function(np,j){var sp=osps[j],anim=new _329.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_35c,sc=_35d[j];hub.connect(anim,"onAnimate",function(x){var _364=spl.getShape();_364.points[j].x=x;spl.setShape(_364);var _365=sc.getShape();_365.cx=x;sc.setShape(_365);});return anim;});var _366=_32a.combine(_360.concat(_363));_366.play();return {group:ts,poly:_35c,circles:_35d};},plotEvent:function(o){if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}},tooltipFunc:function(o){if(o.element=="spider_circle"){return o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data;}else{return null;}},_getBoundary:function(_367){var xmax=_367[0].x,xmin=_367[0].x,ymax=_367[0].y,ymin=_367[0].y;for(var i=0;i<_367.length;i++){var _368=_367[i];xmax=Math.max(_368.x,xmax);ymax=Math.max(_368.y,ymax);xmin=Math.min(_368.x,xmin);ymin=Math.min(_368.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_369,end,_36a){var len=Math.sqrt(Math.pow(end.x-_369.x,2)+Math.pow(end.y-_369.y,2)),sin=(end.y-_369.y)/len,cos=(end.x-_369.x)/len,_36b={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_36c={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_369,_36b,_36c]).setFill(_36a.color).setStroke(_36a);},_buildPoints:function(_36d,_36e,_36f,_370,_371,_372,dim){for(var i=0;i<_36e;i++){var end=_371+2*Math.PI*i/_36e;_36d.push(this._getCoordinate(_36f,_370,end,dim));}if(_372){_36d.push(this._getCoordinate(_36f,_370,_371+2*Math.PI,dim));}},_getCoordinate:function(_373,_374,_375,dim){var x=_373.cx+_374*Math.cos(_375);if(has("dojo-bidi")&&this.chart.isRightToLeft()&&dim){x=dim.width-x;}return {x:x,y:_373.cy+_374*Math.sin(_375)};},_getObjectLength:function(obj){var _376=0;if(lang.isObject(obj)){for(var key in obj){_376++;}}return _376;},_getLabel:function(_377){return dc.getLabel(_377,this.opt.fixed,this.opt.precision);}});return _32f;});},"dojox/charting/plot2d/StackedBars":function(){define(["dojo/_base/declare","./Bars","./commonStacked"],function(_378,Bars,_379){return _378("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _37a=_379.collectStats(this.series),t;_37a.hmin-=0.5;_37a.hmax+=0.5;t=_37a.hmin,_37a.hmin=_37a.vmin,_37a.vmin=t;t=_37a.hmax,_37a.hmax=_37a.vmax,_37a.vmax=t;return _37a;},getValue:function(_37b,_37c,_37d,_37e){var y,x;if(_37e){x=_37c;y=_379.getIndexValue(this.series,_37d,x);}else{x=_37b.x-1;y=_379.getValue(this.series,_37d,_37b.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/themes/GreySkies":function(){define(["../SimpleTheme","./common"],function(_37f,_380){_380.GreySkies=new _37f();return _380.GreySkies;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_381,_382,_383,_384,win,_385,_386){function _387(node,_388,_389,_38a){var view=_385.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_381.some(_388,function(_38b){var _38c=_38b.corner;var pos=_38b.pos;var _38d=0;var _38e={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_38c.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_38c.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_389){var res=_389(node,_38b.aroundCorner,_38c,_38e,_38a);_38d=typeof res=="undefined"?0:res;}var _38f=node.style;var _390=_38f.display;var _391=_38f.visibility;if(_38f.display=="none"){_38f.visibility="hidden";_38f.display="";}var bb=_382.position(node);_38f.display=_390;_38f.visibility=_391;var _392={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_38c.charAt(1)],_393={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_38c.charAt(0)],_394=Math.max(view.l,_392),_395=Math.max(view.t,_393),endX=Math.min(view.l+view.w,_392+bb.w),endY=Math.min(view.t+view.h,_393+bb.h),_396=endX-_394,_397=endY-_395;_38d+=(bb.w-_396)+(bb.h-_397);if(best==null||_38d<best.overflow){best={corner:_38c,aroundCorner:_38b.aroundCorner,x:_394,y:_395,w:_396,h:_397,overflow:_38d,spaceAvailable:_38e};}return !_38d;});if(best.overflow&&_389){_389(node,best.aroundCorner,best.corner,best.spaceAvailable,_38a);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_383.get(body,"position"))){top-=_383.get(body,"marginTop");side-=_383.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _398={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _399={at:function(node,pos,_39a,_39b,_39c){var _39d=_381.map(_39a,function(_39e){var c={corner:_39e,aroundCorner:_398[_39e],pos:{x:pos.x,y:pos.y}};if(_39b){c.pos.x+=_39e.charAt(1)=="L"?_39b.x:-_39b.x;c.pos.y+=_39e.charAt(0)=="T"?_39b.y:-_39b.y;}return c;});return _387(node,_39d,_39c);},around:function(node,_39f,_3a0,_3a1,_3a2){var _3a3;if(typeof _39f=="string"||"offsetWidth" in _39f||"ownerSVGElement" in _39f){_3a3=_382.position(_39f,true);if(/^(above|below)/.test(_3a0[0])){var _3a4=_382.getBorderExtents(_39f),_3a5=_39f.firstChild?_382.getBorderExtents(_39f.firstChild):{t:0,l:0,b:0,r:0},_3a6=_382.getBorderExtents(node),_3a7=node.firstChild?_382.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_3a3.y+=Math.min(_3a4.t+_3a5.t,_3a6.t+_3a7.t);_3a3.h-=Math.min(_3a4.t+_3a5.t,_3a6.t+_3a7.t)+Math.min(_3a4.b+_3a5.b,_3a6.b+_3a7.b);}}else{_3a3=_39f;}if(_39f.parentNode){var _3a8=_383.getComputedStyle(_39f).position=="absolute";var _3a9=_39f.parentNode;while(_3a9&&_3a9.nodeType==1&&_3a9.nodeName!="BODY"){var _3aa=_382.position(_3a9,true),pcs=_383.getComputedStyle(_3a9);if(/relative|absolute/.test(pcs.position)){_3a8=false;}if(!_3a8&&/hidden|auto|scroll/.test(pcs.overflow)){var _3ab=Math.min(_3a3.y+_3a3.h,_3aa.y+_3aa.h);var _3ac=Math.min(_3a3.x+_3a3.w,_3aa.x+_3aa.w);_3a3.x=Math.max(_3a3.x,_3aa.x);_3a3.y=Math.max(_3a3.y,_3aa.y);_3a3.h=_3ab-_3a3.y;_3a3.w=_3ac-_3a3.x;}if(pcs.position=="absolute"){_3a8=true;}_3a9=_3a9.parentNode;}}var x=_3a3.x,y=_3a3.y,_3ad="w" in _3a3?_3a3.w:(_3a3.w=_3a3.width),_3ae="h" in _3a3?_3a3.h:(_384.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_3a3.height+", width:"+_3ad+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_3a3.height+", w:"+_3ad+" }","","2.0"),_3a3.h=_3a3.height);var _3af=[];function push(_3b0,_3b1){_3af.push({aroundCorner:_3b0,corner:_3b1,pos:{x:{"L":x,"R":x+_3ad,"M":x+(_3ad>>1)}[_3b0.charAt(1)],y:{"T":y,"B":y+_3ae,"M":y+(_3ae>>1)}[_3b0.charAt(0)]}});};_381.forEach(_3a0,function(pos){var ltr=_3a1;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _3b2=_387(node,_3af,_3a2,{w:_3ad,h:_3ae});_3b2.aroundNodePos=_3a3;return _3b2;}};return _386.place=_399;});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_3b3,has,_3b4,_3b5,dc,df,dfr,du,fx){var _3b6=dfr.lambda("item.purgeGroup()");return _3b3("dojox.charting.plot2d.Columns",[_3b4,_3b5],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_3b7,_3b8){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_3b8);du.updateWithPattern(this.opt,_3b8,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _3b9=dc.collectSimpleStats(this.series);_3b9.hmin-=0.5;_3b9.hmax+=0.5;return _3b9;},createRect:function(run,_3ba,_3bb){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_3bb);_3ba.add(rect);}else{rect=_3ba.createRect(_3bb);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_3bc){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3bc);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_3b6);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3bd=Math.max(0,this._vScaler.bounds.lower),_3be=vt(_3bd),_3bf=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _3c0=t.next("column",[this.opt,run]),_3c1=new Array(run.data.length);s=run.group;var _3c2=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_3c2?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_3c2?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _3c3=run.data[j];if(_3c3!=null){var val=this.getValue(_3c3,j,i,_3c2),vv=vt(val.y),h=Math.abs(vv-_3be),_3c4,_3c5;if(this.opt.styleFunc||typeof _3c3!="number"){var _3c6=typeof _3c3!="number"?[_3c3]:[];if(this.opt.styleFunc){_3c6.push(this.opt.styleFunc(_3c3));}_3c4=t.addMixin(_3c0,"column",_3c6,true);}else{_3c4=t.post(_3c0,"column");}if(bar.width>=1&&h>=0){var rect={x:_3bc.l+ht(val.x+0.5)+bar.gap+bar.thickness*i,y:dim.height-_3bc.b-(val.y>_3bd?vv:_3be),width:bar.width,height:h};if(_3c4.series.shadow){var _3c7=lang.clone(rect);_3c7.x+=_3c4.series.shadow.dx;_3c7.y+=_3c4.series.shadow.dy;_3c5=this.createRect(run,s,_3c7).setFill(_3c4.series.shadow.color).setStroke(_3c4.series.shadow);if(this.animate){this._animateColumn(_3c5,dim.height-_3bc.b+_3be,h);}}var _3c8=this._plotFill(_3c4.series.fill,dim,_3bc);_3c8=this._shapeFill(_3c8,rect);var _3c9=this.createRect(run,s,rect).setFill(_3c8).setStroke(_3c4.series.stroke);if(_3c9.setFilter&&_3c4.series.filter){_3c9.setFilter(_3c4.series.filter);}run.dyn.fill=_3c9.getFill();run.dyn.stroke=_3c9.getStroke();if(_3bf){var o={element:"column",index:j,run:run,shape:_3c9,shadow:_3c5,cx:val.x+0.5,cy:val.y,x:_3c2?j:run.data[j].x,y:_3c2?run.data[j]:run.data[j].y};this._connectEvents(o);_3c1[j]=o;}if(!isNaN(val.py)&&val.py>_3bd){rect.height=vv-vt(val.py);}this.createLabel(s,_3c3,rect,_3c4);if(this.animate){this._animateColumn(_3c9,dim.height-_3bc.b-_3be,h);}}}}this._eventSeries[run.name]=_3c1;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3bc);}return this;},getValue:function(_3ca,j,_3cb,_3cc){var y,x;if(_3cc){if(typeof _3ca=="number"){y=_3ca;}else{y=_3ca.y;}x=j;}else{y=_3ca.y;x=_3ca.x-1;}return {x:x,y:y};},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_3cd,_3ce,_3cf){if(_3cf==0){_3cf=1;}fx.animateTransform(lang.delegate({shape:_3cd,duration:1200,transform:[{name:"translate",start:[0,_3ce-(_3ce/_3cf)],end:[0,0]},{name:"scale",start:[1,1/_3cf],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_3d0,lang,arr,df){var _3d1={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3d0.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _3d1)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3d0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _3d1)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3d0.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _3d1)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3d0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _3d1)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3d0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _3d1)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3d2,g,df,sc){var _3d3=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3d3,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3d4){if(!_3d4){return _3d4;}if(typeof _3d4=="string"||_3d4 instanceof _3d2){_3d4={color:_3d4};}return g.makeParameters(g.defaultStroke,_3d4);},augmentColor:function(_3d5,_3d6){var t=new _3d2(_3d5),c=new _3d2(_3d6);c.a=t.a;return c;},augmentStroke:function(_3d7,_3d8){var s=_3d3.makeStroke(_3d7);if(s){s.color=_3d3.augmentColor(s.color,_3d8);}return s;},augmentFill:function(fill,_3d9){var fc,c=new _3d2(_3d9);if(typeof fill=="string"||fill instanceof _3d2){return _3d3.augmentColor(fill,_3d9);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3da){var _3db=lang.delegate(_3d3.defaultStats);for(var i=0;i<_3da.length;++i){var run=_3da[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3dc=_3db.vmin,_3dd=_3db.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3db.hmin=Math.min(_3db.hmin,x);_3db.hmax=Math.max(_3db.hmax,x);_3db.vmin=Math.min(_3db.vmin,y);_3db.vmax=Math.max(_3db.vmax,y);}});}if("ymin" in run){_3db.vmin=Math.min(_3dc,run.ymin);}if("ymax" in run){_3db.vmax=Math.max(_3dd,run.ymax);}}else{var _3de=_3db.hmin,_3df=_3db.hmax,_3dc=_3db.vmin,_3dd=_3db.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3db.hmin=Math.min(_3db.hmin,x);_3db.hmax=Math.max(_3db.hmax,x);_3db.vmin=Math.min(_3db.vmin,y);_3db.vmax=Math.max(_3db.vmax,y);}});}if("xmin" in run){_3db.hmin=Math.min(_3de,run.xmin);}if("xmax" in run){_3db.hmax=Math.max(_3df,run.xmax);}if("ymin" in run){_3db.vmin=Math.min(_3dc,run.ymin);}if("ymax" in run){_3db.vmax=Math.max(_3dd,run.ymax);}}break;}}}return _3db;},calculateBarSize:function(_3e0,opt,_3e1){if(!_3e1){_3e1=1;}var gap=opt.gap,size=(_3e0-2*gap)/_3e1;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3e0-size*_3e1)/2;return {size:size,gap:gap};},collectStackedStats:function(_3e2){var _3e3=lang.clone(_3d3.defaultStats);if(_3e2.length){_3e3.hmin=Math.min(_3e3.hmin,1);_3e3.hmax=df.foldl(_3e2,"seed, run -> Math.max(seed, run.data.length)",_3e3.hmax);for(var i=0;i<_3e3.hmax;++i){var v=_3e2[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3e3.vmin=Math.min(_3e3.vmin,v);for(var j=1;j<_3e2.length;++j){var t=_3e2[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3e3.vmax=Math.max(_3e3.vmax,v);}}return _3e3;},curve:function(a,_3e4){var _3e5=a.slice(0);if(_3e4=="x"){_3e5[_3e5.length]=_3e5[0];}var p=arr.map(_3e5,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3e4)){var dx=item.x-_3e5[i-1].x,dy=_3e5[i-1].y;return "C"+(item.x-(_3e4-1)*(dx/_3e4))+","+dy+" "+(item.x-(dx/_3e4))+","+item.y+" "+item.x+","+item.y;}else{if(_3e4=="X"||_3e4=="x"||_3e4=="S"){var p0,p1=_3e5[i-1],p2=_3e5[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3e4=="x"){p0=_3e5[_3e5.length-2];}else{p0=p1;}f=1/3;}else{p0=_3e5[i-2];}if(i==(_3e5.length-1)){if(_3e4=="x"){p3=_3e5[1];}else{p3=p2;}f=1/3;}else{p3=_3e5[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3e6=p0p2*f;var _3e7=p1p3*f;if(_3e6>p1p2/2&&_3e7>p1p2/2){_3e6=p1p2/2;_3e7=p1p2/2;}else{if(_3e6>p1p2/2){_3e6=p1p2/2;_3e7=p1p2/2*p1p3/p0p2;}else{if(_3e7>p1p2/2){_3e7=p1p2/2;_3e6=p1p2/2*p0p2/p1p3;}}}if(_3e4=="S"){if(p0==p1){_3e6=0;}if(p2==p3){_3e7=0;}}bz1x=p1.x+_3e6*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3e6*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3e7*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3e7*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3e8,_3e9,_3ea){return sc.doIfLoaded("dojo/number",function(_3eb){return (_3e9?_3eb.format(_3e8,{places:_3ea}):_3eb.format(_3e8))||"";},function(){return _3e9?_3e8.toFixed(_3ea):_3e8.toString();});}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3ec,_3ed,_3ee,_3ef,has,_3f0,lang,_3f1,_3f2,_3f3,_3f4,_3f5,_3f6){function _3f7(){};function _3f8(_3f9){return function(obj,_3fa,_3fb,_3fc){if(obj&&typeof _3fa=="string"&&obj[_3fa]==_3f7){return obj.on(_3fa.substring(2).toLowerCase(),lang.hitch(_3fb,_3fc));}return _3f9.apply(_3ee,arguments);};};_3ec.around(_3ee,"connect",_3f8);if(_3f0.connect){_3ec.around(_3f0,"connect",_3f8);}var _3fd=_3ef("dijit._Widget",[_3f4,_3f5,_3f6],{onClick:_3f7,onDblClick:_3f7,onKeyDown:_3f7,onKeyPress:_3f7,onKeyUp:_3f7,onMouseDown:_3f7,onMouseMove:_3f7,onMouseOut:_3f7,onMouseOver:_3f7,onMouseLeave:_3f7,onMouseEnter:_3f7,onMouseUp:_3f7,constructor:function(_3fe){this._toConnect={};for(var name in _3fe){if(this[name]===_3f7){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3fe[name];delete _3fe[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3f7){return _3ee.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3ff){_3f0.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3ff);},attr:function(name,_400){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3f0.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3f1("[widgetId]",this.containerNode).map(_3f3.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_3f2(0,function(){var _401=["dijit/_base"];require(_401);});}return _3fd;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_402,_403,_404,lang){lang.extend(_403,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _404("dijit._FocusMixin",null,{_focusManager:_402});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_405,keys,_406,has,_407){var ret=_406("dijit._OnDijitClickMixin",null,{connect:function(obj,_408,_409){return this.inherited(arguments,[obj,_408=="ondijitclick"?_407:_408,_409]);}});ret.a11yclick=_407;return ret;});},"dojox/charting/plot2d/Bars":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(lang,arr,_40a,has,_40b,_40c,dc,fx,du,df,dfr){var _40d=dfr.lambda("item.purgeGroup()");return _40a("dojox.charting.plot2d.Bars",[_40b,_40c],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_40e,_40f){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_40f);du.updateWithPattern(this.opt,_40f,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _410=dc.collectSimpleStats(this.series),t;_410.hmin-=0.5;_410.hmax+=0.5;t=_410.hmin,_410.hmin=_410.vmin,_410.vmin=t;t=_410.hmax,_410.hmax=_410.vmax,_410.vmax=t;return _410;},createRect:function(run,_411,_412){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_412);_411.add(rect);}else{rect=_411.createRect(_412);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},createLabel:function(_413,_414,bbox,_415){if(this.opt.labels&&this.opt.labelStyle=="outside"){var y=bbox.y+bbox.height/2;var x=bbox.x+bbox.width+this.opt.labelOffset;this.renderLabel(_413,x,y,this._getLabel(isNaN(_414.y)?_414:_414.y),_415,"start");}else{this.inherited(arguments);}},render:function(dim,_416){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_416);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,_40d);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_417=Math.max(0,this._hScaler.bounds.lower),_418=ht(_417),_419=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _41a=t.next("bar",[this.opt,run]),_41b=new Array(run.data.length);s=run.group;var _41c=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_41c?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_41c?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _41d=run.data[j];if(_41d!=null){var val=this.getValue(_41d,j,i,_41c),hv=ht(val.y),w=Math.abs(hv-_418),_41e,_41f;if(this.opt.styleFunc||typeof _41d!="number"){var _420=typeof _41d!="number"?[_41d]:[];if(this.opt.styleFunc){_420.push(this.opt.styleFunc(_41d));}_41e=t.addMixin(_41a,"bar",_420,true);}else{_41e=t.post(_41a,"bar");}if(w>=0&&bar.height>=1){var rect={x:_416.l+(val.y<_417?hv:_418),y:dim.height-_416.b-vt(val.x+1.5)+bar.gap+bar.thickness*(this.series.length-i-1),width:w,height:bar.height};if(_41e.series.shadow){var _421=lang.clone(rect);_421.x+=_41e.series.shadow.dx;_421.y+=_41e.series.shadow.dy;_41f=this.createRect(run,s,_421).setFill(_41e.series.shadow.color).setStroke(_41e.series.shadow);if(this.animate){this._animateBar(_41f,_416.l+_418,-w);}}var _422=this._plotFill(_41e.series.fill,dim,_416);_422=this._shapeFill(_422,rect);var _423=this.createRect(run,s,rect).setFill(_422).setStroke(_41e.series.stroke);if(_423.setFilter&&_41e.series.filter){_423.setFilter(_41e.series.filter);}run.dyn.fill=_423.getFill();run.dyn.stroke=_423.getStroke();if(_419){var o={element:"bar",index:j,run:run,shape:_423,shadow:_41f,cx:val.y,cy:val.x+1.5,x:_41c?j:run.data[j].x,y:_41c?run.data[j]:run.data[j].y};this._connectEvents(o);_41b[j]=o;}if(!isNaN(val.py)&&val.py>_417){rect.x+=ht(val.py);rect.width-=ht(val.py);}this.createLabel(s,_41d,rect,_41e);if(this.animate){this._animateBar(_423,_416.l+_418,-w);}}}}this._eventSeries[run.name]=_41b;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_416);}return this;},getValue:function(_424,j,_425,_426){var y,x;if(_426){if(typeof _424=="number"){y=_424;}else{y=_424.y;}x=j;}else{y=_424.y;x=_424.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_427,_428,_429){if(_429==0){_429=1;}fx.animateTransform(lang.delegate({shape:_427,duration:1200,transform:[{name:"translate",start:[_428-(_428/_429),0],end:[0,0]},{name:"scale",start:[1/_429,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_42a,lang,_42b,has,win,arr,dom,_42c,_42d){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_42e){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_42e+" ")>=0;};g._addClass=function(node,_42f){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_42f+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_42f);}};g._removeClass=function(node,_430){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_430+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _431={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_432;if(has("ie")){_432=win.doc.documentElement.style.fontSize||"";if(!_432){win.doc.documentElement.style.fontSize="100%";}}var div=_42c.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _431){div.style.fontSize=p;_431[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_432;}win.body().removeChild(div);return _431;};var _433=null;b._getCachedFontMeasurements=function(_434){if(_434||!_433){_433=b._getFontMeasurements();}return _433;};var _435=null,_436={};b._getTextBox=function(text,_437,_438){var m,s,al=arguments.length;var i,box;if(!_435){_435=_42c.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_435;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_437){for(i in _437){if(i in _436){continue;}s[i]=_437[i];}}if(al>2&&_438){m.className=_438;}m.innerHTML=text;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_42d.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_439,_43a,_43b,_43c){var loc={},_43d=_439.align;switch(_43d){case "end":loc.x=_439.x-_43a;break;case "middle":loc.x=_439.x-_43a/2;break;default:loc.x=_439.x;break;}var c=_43c?0.75:1;loc.y=_439.y-_43b*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_43e=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_43e,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _43f=0;b._getUniqueId=function(){var id;do{id=_42a._scopeName+"xUnique"+(++_43f);}while(dom.byId(id));return id;};b._fixMsTouchAction=function(_440){var r=_440.rawNode;if(typeof r.style.msTouchAction!="undefined"){r.style.msTouchAction="none";}};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _441={};return function(type){var t=_441[type];if(t){return new t();}t=_441[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_442){return (_442 instanceof _42b)?_442:new _42b(_442);},normalizeParameters:function(_443,_444){var x;if(_444){var _445={};for(x in _443){if(x in _444&&!(x in _445)){_443[x]=_444[x];}}}return _443;},makeParameters:function(_446,_447){var i=null;if(!_447){return lang.delegate(_446);}var _448={};for(i in _446){if(!(i in _448)){_448[i]=lang.clone((i in _447)?_447[i]:_446[i]);}}return _448;},formatNumber:function(x,_449){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _44a=val.indexOf(".");if(_44a>=0&&val.length-_44a>5){val=x.toFixed(4);}}if(x<0){return val;}return _449?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _44b=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_44b;case "in":return val*72*_44b;case "pc":return val*12*_44b;case "mm":return val*g.mm_in_pt*_44b;case "cm":return val*g.cm_in_pt*_44b;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_44c){var ns=typeof _44c=="string"?g[_44c]:_44c;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _44c=="string"){g.renderer=_44c;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_44d,hub,has,Base,_44e,gfx,fx,du){return _44d("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true,labelFunc:null},constructor:function(_44f,_450){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_450&&_450.hAxis)||"x";this.vAxis=(_450&&_450.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_450);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_451,_452){this.inherited(arguments);if(!_452&&this.chart._nativeClip){var _453=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_453.l-_453.r),h=Math.max(0,dim.height-_453.t-_453.b);this.group.setClip({x:_453.l,y:_453.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_454){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_455){var r={};r.x=th(_455[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_455[av.name]);return r;};return _454?t(_454):t;},toData:function(_456){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_457){var r={};r[ah.name]=th(_457.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_457.y-o.b);return r;};return _456?t(_456):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_458,_459,bbox,_45a){if(this.opt.labels){var x,y,_45b=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_459,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_459.y)?_459:_459.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_45b,{font:_45a.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_458,x,y,_45b,_45a,this.opt.labelStyle=="inside");}},performZoom:function(dim,_45c){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_45d=dim.height-_45c.b,_45e=this._hScaler.bounds,_45f=(_45e.from-_45e.lower)*_45e.scale,_460=this._vScaler.bounds,_461=(_460.from-_460.lower)*_460.scale,_462=vs/this.lastWindow.vscale,_463=hs/this.lastWindow.hscale,_464=(this.lastWindow.xoffset-_45f)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_465=(_461-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_466=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_466,duration:1200,transform:[{name:"translate",start:[0,0],end:[_45c.l*(1-_463),_45d*(1-_462)]},{name:"scale",start:[1,1],end:[_463,_462]},{name:"original"},{name:"translate",start:[0,0],end:[_464,_465]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_45f,yoffset:_461});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_467){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_467.hmin,_467.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_44e.buildScaler(_467.hmin,_467.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_467.vmin,_467.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_44e.buildScaler(_467.vmin,_467.vmax,dim.height);}return this;}});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_468,_469,dom,_46a,_46b,_46c,_46d,lang,on,_46e,has,_46f,win,_470,a11y,_471,_472){var _473;var _474=_469([_46f,_46d],{curNode:null,activeStack:[],constructor:function(){var _475=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_468.before(_46c,"empty",_475);_468.before(_46c,"destroy",_475);},registerIframe:function(_476){return this.registerWin(_476.contentWindow,_476);},registerWin:function(_477,_478){var _479=this,body=_477.document&&_477.document.body;if(body){var mdh=on(_477.document,"mousedown, touchstart",function(evt){_479._justMouseDowned=true;setTimeout(function(){_479._justMouseDowned=false;},13);if(evt&&evt.target&&evt.target.parentNode==null){return;}_479._onTouchNode(_478||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){_473=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_479._onFocusNode(_478||evt.target);}else{_479._onTouchNode(_478||evt.target);}});var foh=on(body,"focusout",function(evt){if((new Date()).getTime()<_473+100){return;}_479._onBlurNode(_478||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_46b.contains(node,"dijitPopup")){node=node.firstChild;}var _47a=[];try{while(node){var _47b=_46a.get(node,"dijitPopupParent");if(_47b){node=_471.byId(_47b).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_470.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_47c=id&&_471.byId(id);if(_47c&&!(by=="mouse"&&_47c.get("disabled"))){_47a.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_47a,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_47d,by){var _47e=this.activeStack,_47f=_47e.length-1,_480=_47d.length-1;if(_47d[_480]==_47e[_47f]){return;}this.set("activeStack",_47d);var _481,i;for(i=_47f;i>=0&&_47e[i]!=_47d[i];i--){_481=_471.byId(_47e[i]);if(_481){_481._hasBeenBlurred=true;_481.set("focused",false);if(_481._focusManager==this){_481._onBlur(by);}this.emit("widget-blur",_481,by);}}for(i++;i<=_480;i++){_481=_471.byId(_47d[i]);if(_481){_481.set("focused",true);if(_481._focusManager==this){_481._onFocus(by);}this.emit("widget-focus",_481,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _482=new _474();_46e(function(){var _483=_482.registerWin(_470.get(document));if(has("ie")){on(window,"unload",function(){if(_483){_483.remove();_483=null;}});}});_472.focus=function(node){_482.focus(node);};for(var attr in _482){if(!/^_/.test(attr)){_472.focus[attr]=typeof _482[attr]=="function"?lang.hitch(_482,attr):_482[attr];}}_482.watch(function(attr,_484,_485){_472.focus[attr]=_485;});return _482;});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_486,_487,gfx,arr,has,_488,df,dom,_489,_48a,_48b){var _48c=_486(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_487,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_48b.byId(this.chartRef)||_48b.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_489.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_489.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_48d){_48d.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_48e){_48e.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_489.destroy(this.legendBody.lastChild);}if(this.horizontal){_48a.add(this.domNode,"dojoxLegendHorizontal");this._tr=_489.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _48f=df.map(t.run.data,"Math.max(x, 0)");var _490=df.map(_48f,"/this",df.foldl(_48f,"+",0));arr.forEach(_490,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_491){var _492=_489.create("td"),icon=_489.create("div",null,_492),text=_489.create("label",null,_492),div=_489.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_48a.add(icon,"dojoxLegendIcon dijitInline");_48a.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_492);if(++this._inrow===this.horizontal){this._tr=_489.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_489.create("tr",null,this.legendBody);tr.appendChild(_492);}this._makeIcon(div,dyn);text.innerHTML=String(_491);if(has("dojo-bidi")){text.dir=this.getTextDir(_491,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _493=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_493);if(dyn.fill){_493.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_493.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_493.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_493.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_493.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_493.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_486("dojox.charting.widget.Legend",[_48c,_488]):_48c;});},"dojox/charting/plot2d/StackedLines":function(){define(["dojo/_base/declare","./Stacked"],function(_494,_495){return _494("dojox.charting.plot2d.StackedLines",_495,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define(["dojo/_base/declare","./Columns","./commonStacked"],function(_496,_497,_498){return _496("dojox.charting.plot2d.StackedColumns",_497,{getSeriesStats:function(){var _499=_498.collectStats(this.series);_499.hmin-=0.5;_499.hmax+=0.5;return _499;},getValue:function(_49a,_49b,_49c,_49d){var x,y;if(_49d){x=_49b;y=_498.getIndexValue(this.series,_49c,x);}else{x=_49a.x-1;y=_498.getValue(this.series,_49c,_49a.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_49e,_49f){return _49e("dojox.charting.Series",_49f,{constructor:function(_4a0,data,_4a1){lang.mixin(this,_4a1);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_4a2,arr,has,_4a3,_4a4,dc,df,dfr,du,fx){var _4a5=dfr.lambda("item.purgeGroup()");var _4a6=1200;return _4a2("dojox.charting.plot2d.Default",[_4a3,_4a4],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_4a7,_4a8){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_4a8);du.updateWithPattern(this.opt,_4a8,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_4a9,_4aa){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_4aa);_4a9.add(path);}else{path=_4a9.createPath(_4aa);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_4ab){var run=this.series[i],min=_4ab?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_4ab?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_4ac=[];for(var j=min;j<max;j++){if(run.data[j]!=null&&(_4ab||run.data[j].y!=null)){if(!rseg){rseg=[];_4ac.push({index:j,rseg:rseg});}rseg.push((_4ab&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_4ab){rseg=null;}}}return _4ac;},render:function(dim,_4ad){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_4ad);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_4a5);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4ae,_4af,_4b0=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _4b1=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_4b2,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4b3=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;var _4b4=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _4b5=this.buildSegments(i,_4b4);for(var seg=0;seg<_4b5.length;seg++){var _4b6=_4b5[seg];if(_4b4){_4b2=arr.map(_4b6.rseg,function(v,i){return {x:ht(i+_4b6.index+1)+_4ad.l,y:dim.height-_4ad.b-vt(v),data:v};},this);}else{_4b2=arr.map(_4b6.rseg,function(v){return {x:ht(v.x)+_4ad.l,y:dim.height-_4ad.b-vt(v.y),data:v};},this);}if(_4b4&&this.opt.interpolate){while(seg<_4b5.length){seg++;_4b6=_4b5[seg];if(_4b6){_4b2=_4b2.concat(arr.map(_4b6.rseg,function(v,i){return {x:ht(i+_4b6.index+1)+_4ad.l,y:dim.height-_4ad.b-vt(v),data:v};},this));}}}var _4b7=this.opt.tension?dc.curve(_4b2,this.opt.tension):"";if(this.opt.areas&&_4b2.length>1){var fill=this._plotFill(_4b1.series.fill,dim,_4ad),_4b8=lang.clone(_4b2);if(this.opt.tension){var _4b9="L"+_4b8[_4b8.length-1].x+","+(dim.height-_4ad.b)+" L"+_4b8[0].x+","+(dim.height-_4ad.b)+" L"+_4b8[0].x+","+_4b8[0].y;run.dyn.fill=s.createPath(_4b7+" "+_4b9).setFill(fill).getFill();}else{_4b8.push({x:_4b2[_4b2.length-1].x,y:dim.height-_4ad.b});_4b8.push({x:_4b2[0].x,y:dim.height-_4ad.b});_4b8.push(_4b2[0]);run.dyn.fill=s.createPolyline(_4b8).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_4ae=_4b1.series.stroke;if(_4b1.series.outline){_4af=run.dyn.outline=dc.makeStroke(_4b1.series.outline);_4af.width=2*_4af.width+_4ae.width;}}if(this.opt.markers){run.dyn.marker=_4b1.symbol;}var _4ba=null,_4bb=null,_4bc=null;if(_4ae&&_4b1.series.shadow&&_4b2.length>1){var _4bd=_4b1.series.shadow,_4be=arr.map(_4b2,function(c){return {x:c.x+_4bd.dx,y:c.y+_4bd.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_4be,this.opt.tension)).setStroke(_4bd).getStroke();}else{run.dyn.shadow=s.createPolyline(_4be).setStroke(_4bd).getStroke();}}if(this.opt.markers&&_4b1.marker.shadow){_4bd=_4b1.marker.shadow;_4bc=arr.map(_4be,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_4b1.symbol).setStroke(_4bd).setFill(_4bd.color);},this);}}if(this.opt.lines&&_4b2.length>1){var _4bf;if(_4af){if(this.opt.tension){run.dyn.outline=s.createPath(_4b7).setStroke(_4af).getStroke();}else{run.dyn.outline=s.createPolyline(_4b2).setStroke(_4af).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_4bf=s.createPath(_4b7)).setStroke(_4ae).getStroke();}else{run.dyn.stroke=(_4bf=s.createPolyline(_4b2)).setStroke(_4ae).getStroke();}if(_4bf.setFilter&&_4b1.series.filter){_4bf.setFilter(_4b1.series.filter);}}var _4c0=null;if(this.opt.markers){var _4c1=_4b1;_4ba=new Array(_4b2.length);_4bb=new Array(_4b2.length);_4af=null;if(_4c1.marker.outline){_4af=dc.makeStroke(_4c1.marker.outline);_4af.width=2*_4af.width+(_4c1.marker.stroke?_4c1.marker.stroke.width:0);}arr.forEach(_4b2,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4c2=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4c2.push(this.opt.styleFunc(c.data));}_4c1=t.addMixin(_4b1,"marker",_4c2,true);}else{_4c1=t.post(_4b1,"marker");}var path="M"+c.x+" "+c.y+" "+_4c1.symbol;if(_4af){_4bb[i]=this.createPath(run,s,path).setStroke(_4af);}_4ba[i]=this.createPath(run,s,path).setStroke(_4c1.marker.stroke).setFill(_4c1.marker.fill);},this);run.dyn.markerFill=_4c1.marker.fill;run.dyn.markerStroke=_4c1.marker.stroke;if(!_4c0&&this.opt.labels){_4c0=_4ba[0].getBoundingBox();}if(_4b0){arr.forEach(_4ba,function(s,i){var o={element:"marker",index:i+_4b6.index,run:run,shape:s,outline:_4bb[i]||null,shadow:_4bc&&_4bc[i]||null,cx:_4b2[i].x,cy:_4b2[i].y};if(_4b4){o.x=i+_4b6.index+1;o.y=run.data[i+_4b6.index];}else{o.x=_4b6.rseg[i].x;o.y=run.data[i+_4b6.index].y;}this._connectEvents(o);_4b3[i+_4b6.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _4c3=_4c0?_4c0.width:2;var _4c4=_4c0?_4c0.height:2;arr.forEach(_4b2,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4c5=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4c5.push(this.opt.styleFunc(c.data));}_4c1=t.addMixin(_4b1,"marker",_4c5,true);}else{_4c1=t.post(_4b1,"marker");}this.createLabel(s,_4b6.rseg[i],{x:c.x-_4c3/2,y:c.y-_4c4/2,width:_4c3,height:_4c4},_4c1);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_4ad);}if(this.animate){var _4c6=this.getGroup();fx.animateTransform(lang.delegate({shape:_4c6,duration:_4a6,transform:[{name:"translate",start:[0,dim.height-_4ad.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_4c7,arr,gfx,_4c8,_4c9,ac,has){var Base=_4c7("dojox.charting.plot2d.Base",_4c8,{constructor:function(_4ca,_4cb){if(_4cb&&_4cb.tooltipFunc){this.tooltipFunc=_4cb.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _4c9.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_4cc){return this;},renderLabel:function(_4cd,x,y,_4ce,_4cf,_4d0,_4d1){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_4cd,x,y,_4d1?_4d1:"middle",_4ce,_4cf.series.font,_4cf.series.fontColor);if(_4d0){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_4d2){return _4c9.getLabel(_4d2,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_4d3,dim,_4d4){this.chart.applyMirroring(this.group,dim,_4d4);}});}return Base;});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_4d5,lang,_4d6,win,hub,_4d7,_4d8,m,has,_4d9,df){var _4da=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _4db=_4d6(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_4d8,{defaultParams:{text:_4da,mouseOver:true},optionalParams:{},constructor:function(_4dc,plot,_4dd){this.text=_4dd&&_4dd.text?_4dd.text:_4da;this.mouseOver=_4dd&&_4dd.mouseOver!=undefined?_4dd.mouseOver:true;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4d5.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _4de={type:"rect"},_4df=["after-centered","before-centered"];switch(o.element){case "marker":_4de.x=o.cx;_4de.y=o.cy;_4de.w=_4de.h=1;break;case "circle":_4de.x=o.cx-o.cr;_4de.y=o.cy-o.cr;_4de.w=_4de.h=2*o.cr;break;case "spider_circle":_4de.x=o.cx;_4de.y=o.cy;_4de.w=_4de.h=1;break;case "spider_plot":return;case "column":_4df=["above-centered","below-centered"];case "bar":_4de=lang.clone(o.shape.getShape());_4de.w=_4de.width;_4de.h=_4de.height;break;case "candlestick":_4de.x=o.x;_4de.y=o.y;_4de.w=o.width;_4de.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _4e0=m._degToRad(o.plot.opt.startAngle),_4e1=(this.angles[o.index]+this.angles[o.index+1])/2+_4e0;_4de.x=o.cx+o.cr*Math.cos(_4e1);_4de.y=o.cy+o.cr*Math.sin(_4e1);_4de.w=_4de.h=1;if(_4e0&&(_4e1<0||_4e1>2*Math.PI)){_4e1=Math.abs(2*Math.PI-Math.abs(_4e1));}if(_4e1<pi4){}else{if(_4e1<pi2+pi4){_4df=["below-centered","above-centered"];}else{if(_4e1<Math.PI+pi4){_4df=["before-centered","after-centered"];}else{if(_4e1<2*Math.PI-pi4){_4df=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_4de,_4df);}var lt=this.chart.getCoords();_4de.x+=lt.x;_4de.y+=lt.y;_4de.x=Math.round(_4de.x);_4de.y=Math.round(_4de.y);_4de.w=Math.ceil(_4de.w);_4de.h=Math.ceil(_4de.h);this.aroundRect=_4de;var _4e2=this.text(o,this.plot);if(_4e2){_4d5.show(this._format(_4e2),this.aroundRect,_4df);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_4e3){},_format:function(_4e4){return _4e4;}});return has("dojo-bidi")?_4d6("dojox.charting.action2d.Tooltip",[_4db,_4d9]):_4db;});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4e5,_4e6){_4e5.switchTo(_4e6);return _4e5;});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_4e7,_4e8,has,on,arr,_4e9,_4ea,_4eb){var _4ec=g.shape={};_4ec.Shape=_4e7("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_4ec.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_4ec.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_4eb;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_4ed){this.shape=g.makeParameters(this.shape,_4ed);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_4ee){if(!_4ee){this.strokeStyle=null;return this;}if(typeof _4ee=="string"||lang.isArray(_4ee)||_4ee instanceof _4ea){_4ee={color:_4ee};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_4ee);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_4ef){this.matrix=_4eb.clone(_4ef?_4eb.normalize(_4ef):_4eb.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_4f0){return _4f0?this.setTransform([this.matrix,_4f0]):this;},applyLeftTransform:function(_4f1){return _4f1?this.setTransform([_4f1,this.matrix]):this;},applyTransform:function(_4f2){return _4f2?this.setTransform([this.matrix,_4f2]):this;},removeShape:function(_4f3){if(this.parent){this.parent.remove(this,_4f3);}return this;},_setParent:function(_4f4,_4f5){this.parent=_4f4;return this._updateParentMatrix(_4f5);},_updateParentMatrix:function(_4f6){this.parentMatrix=_4f6?_4eb.clone(_4f6):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_4eb.multiply(p.matrix,m);}p=p.parent;}return m;}});_4ec._eventsProcessing={on:function(type,_4f7){return on(this.getEventSource(),type,_4ec.fixCallback(this,g.fixTarget,_4f7));},connect:function(name,_4f8,_4f9){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_4f9?lang.hitch(_4f8,_4f9):_4f8);},disconnect:function(_4fa){return _4fa.remove();}};_4ec.fixCallback=function(_4fb,_4fc,_4fd,_4fe){if(!_4fe){_4fe=_4fd;_4fd=null;}if(lang.isString(_4fe)){_4fd=_4fd||_4e8.global;if(!_4fd[_4fe]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_4fe,"\"] is null (scope=\"",_4fd,"\")"].join(""));}return function(e){return _4fc(e,_4fb)?_4fd[_4fe].apply(_4fd,arguments||[]):undefined;};}return !_4fd?function(e){return _4fc(e,_4fb)?_4fe.apply(_4fd,arguments):undefined;}:function(e){return _4fc(e,_4fb)?_4fe.apply(_4fd,arguments||[]):undefined;};};lang.extend(_4ec.Shape,_4ec._eventsProcessing);_4ec.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_4ff){var _500=_4ff.getParent();if(_500){_500.remove(_4ff,true);}this.children.push(_4ff);return _4ff._setParent(this,this._getRealMatrix());},remove:function(_501,_502){for(var i=0;i<this.children.length;++i){if(this.children[i]==_501){if(_502){}else{_501.parent=null;_501.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_503){var _504;for(var i=0;i<this.children.length;++i){_504=this.children[i];_504.parent=null;_504.parentMatrix=null;if(_503){_504.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _505=null;arr.forEach(this.children,function(_506){var bb=_506.getBoundingBox();if(bb){var ct=_506.getTransform();if(ct){bb=_4eb.multiplyRectangle(ct,bb);}if(_505){_505.x=Math.min(_505.x,bb.x);_505.y=Math.min(_505.y,bb.y);_505.endX=Math.max(_505.endX,bb.x+bb.width);_505.endY=Math.max(_505.endY,bb.y+bb.height);}else{_505={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_505){_505.width=_505.endX-_505.x;_505.height=_505.endY-_505.y;}return _505;}return null;},_moveChildToFront:function(_507){for(var i=0;i<this.children.length;++i){if(this.children[i]==_507){this.children.splice(i,1);this.children.push(_507);break;}}return this;},_moveChildToBack:function(_508){for(var i=0;i<this.children.length;++i){if(this.children[i]==_508){this.children.splice(i,1);this.children.unshift(_508);break;}}return this;}};_4ec.Surface=_4e7("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_4e9.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_4e9.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_509){},whenLoaded:function(_50a,_50b){var f=lang.hitch(_50a,_50b);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_50c){f(_50c);});}}});lang.extend(_4ec.Surface,_4ec._eventsProcessing);_4ec.Rect=_4e7("dojox.gfx.shape.Rect",_4ec.Shape,{constructor:function(_50d){this.shape=g.getDefault("Rect");this.rawNode=_50d;},getBoundingBox:function(){return this.shape;}});_4ec.Ellipse=_4e7("dojox.gfx.shape.Ellipse",_4ec.Shape,{constructor:function(_50e){this.shape=g.getDefault("Ellipse");this.rawNode=_50e;},getBoundingBox:function(){if(!this.bbox){var _50f=this.shape;this.bbox={x:_50f.cx-_50f.rx,y:_50f.cy-_50f.ry,width:2*_50f.rx,height:2*_50f.ry};}return this.bbox;}});_4ec.Circle=_4e7("dojox.gfx.shape.Circle",_4ec.Shape,{constructor:function(_510){this.shape=g.getDefault("Circle");this.rawNode=_510;},getBoundingBox:function(){if(!this.bbox){var _511=this.shape;this.bbox={x:_511.cx-_511.r,y:_511.cy-_511.r,width:2*_511.r,height:2*_511.r};}return this.bbox;}});_4ec.Line=_4e7("dojox.gfx.shape.Line",_4ec.Shape,{constructor:function(_512){this.shape=g.getDefault("Line");this.rawNode=_512;},getBoundingBox:function(){if(!this.bbox){var _513=this.shape;this.bbox={x:Math.min(_513.x1,_513.x2),y:Math.min(_513.y1,_513.y2),width:Math.abs(_513.x2-_513.x1),height:Math.abs(_513.y2-_513.y1)};}return this.bbox;}});_4ec.Polyline=_4e7("dojox.gfx.shape.Polyline",_4ec.Shape,{constructor:function(_514){this.shape=g.getDefault("Polyline");this.rawNode=_514;},setShape:function(_515,_516){if(_515&&_515 instanceof Array){this.inherited(arguments,[{points:_515}]);if(_516&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_515]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _517=[];for(var i=0;i<l;i+=2){_517.push({x:p[i],y:p[i+1]});}this.shape.points=_517;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_4ec.Image=_4e7("dojox.gfx.shape.Image",_4ec.Shape,{constructor:function(_518){this.shape=g.getDefault("Image");this.rawNode=_518;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_4ec.Text=_4e7(_4ec.Shape,{constructor:function(_519){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_519;},getFont:function(){return this.fontStyle;},setFont:function(_51a){this.fontStyle=typeof _51a=="string"?g.splitFontString(_51a):g.makeParameters(g.defaultFont,_51a);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_4ec.Creator={createShape:function(_51b){switch(_51b.type){case g.defaultPath.type:return this.createPath(_51b);case g.defaultRect.type:return this.createRect(_51b);case g.defaultCircle.type:return this.createCircle(_51b);case g.defaultEllipse.type:return this.createEllipse(_51b);case g.defaultLine.type:return this.createLine(_51b);case g.defaultPolyline.type:return this.createPolyline(_51b);case g.defaultImage.type:return this.createImage(_51b);case g.defaultText.type:return this.createText(_51b);case g.defaultTextPath.type:return this.createTextPath(_51b);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_51c){return this.createObject(g.Ellipse,_51c);},createCircle:function(_51d){return this.createObject(g.Circle,_51d);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_51e){return this.createObject(g.Polyline,_51e);},createImage:function(_51f){return this.createObject(g.Image,_51f);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_520,_521){return null;}};return _4ec;});},"dojox/charting/Chart2D":function(){define(["dojo/_base/kernel","dojo/_base/lang","..","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(_522,lang,_523,_524){_522.deprecated("dojox.charting.Chart2D","Use dojox.charting.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.Chart2D",_524);});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_525){var _526=lang.getObject("dojox.charting.scaler.linear",true);var _527=3,_528=_525.getNumericLabel;function _529(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _52a=function(min,max,_52b,_52c,_52d,_52e,span){_52b=lang.delegate(_52b);if(!_52c){if(_52b.fixUpper=="major"){_52b.fixUpper="minor";}if(_52b.fixLower=="major"){_52b.fixLower="minor";}}if(!_52d){if(_52b.fixUpper=="minor"){_52b.fixUpper="micro";}if(_52b.fixLower=="minor"){_52b.fixLower="micro";}}if(!_52e){if(_52b.fixUpper=="micro"){_52b.fixUpper="none";}if(_52b.fixLower=="micro"){_52b.fixLower="none";}}var _52f=_529(_52b.fixLower,["major"])?Math.floor(_52b.min/_52c)*_52c:_529(_52b.fixLower,["minor"])?Math.floor(_52b.min/_52d)*_52d:_529(_52b.fixLower,["micro"])?Math.floor(_52b.min/_52e)*_52e:_52b.min,_530=_529(_52b.fixUpper,["major"])?Math.ceil(_52b.max/_52c)*_52c:_529(_52b.fixUpper,["minor"])?Math.ceil(_52b.max/_52d)*_52d:_529(_52b.fixUpper,["micro"])?Math.ceil(_52b.max/_52e)*_52e:_52b.max;if(_52b.useMin){min=_52f;}if(_52b.useMax){max=_530;}var _531=(!_52c||_52b.useMin&&_529(_52b.fixLower,["major"]))?min:Math.ceil(min/_52c)*_52c,_532=(!_52d||_52b.useMin&&_529(_52b.fixLower,["major","minor"]))?min:Math.ceil(min/_52d)*_52d,_533=(!_52e||_52b.useMin&&_529(_52b.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_52e)*_52e,_534=!_52c?0:(_52b.useMax&&_529(_52b.fixUpper,["major"])?Math.round((max-_531)/_52c):Math.floor((max-_531)/_52c))+1,_535=!_52d?0:(_52b.useMax&&_529(_52b.fixUpper,["major","minor"])?Math.round((max-_532)/_52d):Math.floor((max-_532)/_52d))+1,_536=!_52e?0:(_52b.useMax&&_529(_52b.fixUpper,["major","minor","micro"])?Math.round((max-_533)/_52e):Math.floor((max-_533)/_52e))+1,_537=_52d?Math.round(_52c/_52d):0,_538=_52e?Math.round(_52d/_52e):0,_539=_52c?Math.floor(Math.log(_52c)/Math.LN10):0,_53a=_52d?Math.floor(Math.log(_52d)/Math.LN10):0,_53b=span/(max-min);if(!isFinite(_53b)){_53b=1;}return {bounds:{lower:_52f,upper:_530,from:min,to:max,scale:_53b,span:span},major:{tick:_52c,start:_531,count:_534,prec:_539},minor:{tick:_52d,start:_532,count:_535,prec:_53a},micro:{tick:_52e,start:_533,count:_536,prec:0},minorPerMajor:_537,microPerMinor:_538,scaler:_526};};return lang.mixin(_526,{buildScaler:function(min,max,span,_53c,_53d,_53e){var h={fixUpper:"none",fixLower:"none",natural:false};if(_53c){if("fixUpper" in _53c){h.fixUpper=String(_53c.fixUpper);}if("fixLower" in _53c){h.fixLower=String(_53c.fixLower);}if("natural" in _53c){h.natural=Boolean(_53c.natural);}}_53e=!_53e||_53e<_527?_527:_53e;if("min" in _53c){min=_53c.min;}if("max" in _53c){max=_53c.max;}if(_53c.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _53c){min=_53c.from;h.useMin=false;}if("to" in _53c){max=_53c.to;h.useMax=false;}if(max<=min){return _52a(min,max,h,0,0,0,span);}if(!_53d){_53d=max-min;}var mag=Math.floor(Math.log(_53d)/Math.LN10),_53f=_53c&&("majorTickStep" in _53c)?_53c.majorTickStep:Math.pow(10,mag),_540=0,_541=0,_542;if(_53c&&("minorTickStep" in _53c)){_540=_53c.minorTickStep;}else{do{_540=_53f/10;if(!h.natural||_540>0.9){_542=_52a(min,max,h,_53f,_540,0,span);if(_542.bounds.scale*_542.minor.tick>_53e){break;}}_540=_53f/5;if(!h.natural||_540>0.9){_542=_52a(min,max,h,_53f,_540,0,span);if(_542.bounds.scale*_542.minor.tick>_53e){break;}}_540=_53f/2;if(!h.natural||_540>0.9){_542=_52a(min,max,h,_53f,_540,0,span);if(_542.bounds.scale*_542.minor.tick>_53e){break;}}return _52a(min,max,h,_53f,0,0,span);}while(false);}if(_53c&&("microTickStep" in _53c)){_541=_53c.microTickStep;_542=_52a(min,max,h,_53f,_540,_541,span);}else{do{_541=_540/10;if(!h.natural||_541>0.9){_542=_52a(min,max,h,_53f,_540,_541,span);if(_542.bounds.scale*_542.micro.tick>_527){break;}}_541=_540/5;if(!h.natural||_541>0.9){_542=_52a(min,max,h,_53f,_540,_541,span);if(_542.bounds.scale*_542.micro.tick>_527){break;}}_541=_540/2;if(!h.natural||_541>0.9){_542=_52a(min,max,h,_53f,_540,_541,span);if(_542.bounds.scale*_542.micro.tick>_527){break;}}_541=0;}while(false);}return _541?_542:_52a(min,max,h,_53f,_540,0,span);},buildTicks:function(_543,_544){var step,next,tick,_545=_543.major.start,_546=_543.minor.start,_547=_543.micro.start;if(_544.microTicks&&_543.micro.tick){step=_543.micro.tick,next=_547;}else{if(_544.minorTicks&&_543.minor.tick){step=_543.minor.tick,next=_546;}else{if(_543.major.tick){step=_543.major.tick,next=_545;}else{return null;}}}var _548=1/_543.bounds.scale;if(_543.bounds.to<=_543.bounds.from||isNaN(_548)||!isFinite(_548)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _549=[],_54a=[],_54b=[];while(next<=_543.bounds.to+_548){if(Math.abs(_545-next)<step/2){tick={value:_545};if(_544.majorLabels){tick.label=_528(_545,_543.major.prec,_544);}_549.push(tick);_545+=_543.major.tick;_546+=_543.minor.tick;_547+=_543.micro.tick;}else{if(Math.abs(_546-next)<step/2){if(_544.minorTicks){tick={value:_546};if(_544.minorLabels&&(_543.minMinorStep<=_543.minor.tick*_543.bounds.scale)){tick.label=_528(_546,_543.minor.prec,_544);}_54a.push(tick);}_546+=_543.minor.tick;_547+=_543.micro.tick;}else{if(_544.microTicks){_54b.push({value:_547});}_547+=_543.micro.tick;}}next+=step;}return {major:_549,minor:_54a,micro:_54b};},getTransformerFromModel:function(_54c){var _54d=_54c.bounds.from,_54e=_54c.bounds.scale;return function(x){return (x-_54d)*_54e;};},getTransformerFromPlot:function(_54f){var _550=_54f.bounds.from,_551=_54f.bounds.scale;return function(x){return x/_551+_550;};}});});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_552){var _553=null;has.add("vml",function(_554,_555,_556){_556.innerHTML="<v:shape adj=\"1\"/>";var _557=("adj" in _556.firstChild);_556.innerHTML="";return _557;});return {load:function(id,_558,load){if(_553&&id!="force"){load(_553);return;}var _559=_552.forceGfxRenderer,_55a=!_559&&(lang.isString(_552.gfxRenderer)?_552.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_55b,_55c;while(!_559&&_55a.length){switch(_55a.shift()){case "svg":if("SVGAngle" in win.global){_559="svg";}break;case "vml":if(has("vml")){_559="vml";}break;case "silverlight":try{if(has("ie")){_55b=new ActiveXObject("AgControl.AgControl");if(_55b&&_55b.IsVersionSupported("1.0")){_55c=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_55c=true;}}}catch(e){_55c=false;}finally{_55b=null;}if(_55c){_559="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_559="canvas";}break;}}if(_559==="canvas"&&_552.canvasEvents!==false){_559="canvasWithEvents";}if(_552.isDebug){}function _55d(){_558(["dojox/gfx/"+_559],function(_55e){g.renderer=_559;_553=_55e;load(_55e);});};if(_559=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_55d);}else{_55d();}}};});},"dojox/charting/widget/Chart":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/dom-attr","dojo/_base/declare","dojo/query","dijit/_WidgetBase","../Chart","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda"],function(_55f,lang,arr,_560,_561,_562,_563,_564,has,_565,du,df,dfl){var _566,_567,_568,_569,_56a,_56b=function(o){return o;},dc=lang.getObject("dojox.charting");_566=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_567=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=_55f._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=_55f._scopeName+"x.charting.axis2d.Default";}_566(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_568=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=_55f._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=_55f._scopeName+"x.charting.plot2d.Default";}_566(node,type,kw);var dp=eval("("+type+".prototype.baseParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}return o;};_569=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=_55f._scopeName+"x.charting.action2d."+type;}var _56c=eval("("+type+")");if(!_56c){return null;}o.action=_56c;}else{return null;}_566(node,type,kw);return o;};_56a=function(node){var ga=lang.partial(_560.get,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};var _56d=_561(has("dojo-bidi")?"dojox.charting.widget.NonBidiChart":"dojox.charting.widget.Chart",_563,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);var n=this.domNode;var axes=_562("> .axis",n).map(_567).filter(_56b),_56e=_562("> .plot",n).map(_568).filter(_56b),_56f=_562("> .action",n).map(_569).filter(_56b),_570=_562("> .series",n).map(_56a).filter(_56b);n.innerHTML="";var c=this.chart=new _564(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_56e.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_56f.map(function(_571){return new _571.action(c,_571.plot,_571.kwArgs);});var _572=df.foldl(_570,function(_573,_574){if(_574.type=="data"){c.addSeries(_574.name,_574.data,_574.kwArgs);_573=true;}else{c.addSeries(_574.name,[0],_574.kwArgs);var kw={};du.updateWithPattern(kw,_574.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_574.kwArgs.sort){kw.sort=lang.clone(_574.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _575;if("valueFn" in _574.kwArgs){var fn=_574.kwArgs.valueFn;_575=arr.map(data,function(x){return fn(_574.data.getValue(x,_574.field,0));});}else{_575=arr.map(data,function(x){return _574.data.getValue(x,_574.field,0);});}c.addSeries(_574.name,_575,_574.kwArgs).render();}});_574.data.fetch(kw);}return _573;},false);if(_572){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize.apply(this.chart,arguments);}});return has("dojo-bidi")?_561("dojox.charting.widget.Chart",[_56d,_565]):_56d;});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _576=lang.getObject("dojox.charting.scaler.common",true);var _577={};return lang.mixin(_576,{doIfLoaded:function(_578,_579,_57a){if(_577[_578]==undefined){try{_577[_578]=require(_578);}catch(e){_577[_578]=null;}}if(_577[_578]){return _579(_577[_578]);}else{return _57a();}},getNumericLabel:function(_57b,_57c,_57d){var def="";_576.doIfLoaded("dojo/number",function(_57e){def=(_57d.fixed?_57e.format(_57b,{places:_57c<0?-_57c:0}):_57e.format(_57b))||"";},function(){def=_57d.fixed?_57b.toFixed(_57c<0?-_57c:0):_57b.toString();});if(_57d.labelFunc){var r=_57d.labelFunc(def,_57b,_57c);if(r){return r;}}if(_57d.labels){var l=_57d.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_57b){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_57b)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_57b)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_57b)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_57f,g,has){var _580=lang.getObject("dojox.charting.axis2d.common",true);var _581=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _582=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _57f.getMarginBox(n).w;}};return lang.mixin(_580,{createText:{gfx:function(_583,_584,x,y,_585,text,font,_586){return _584.createText({x:x,y:y,text:text,align:_585}).setFont(font).setFill(_586);},html:function(_587,_588,x,y,_589,text,font,_58a,_58b){var p=win.doc.createElement("div"),s=p.style,_58c;if(_587.getTextDir){p.dir=_587.getTextDir(text);}_581(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_58a;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_58b){_58c=_582(p);}if(p.dir=="rtl"){x+=_58b?_58b:_58c;}win.body().removeChild(p);s.position="relative";if(_58b){s.width=_58b+"px";switch(_589){case "middle":s.textAlign="center";s.left=(x-_58b/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_58b)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_589){case "middle":s.left=Math.floor(x-_58c/2)+"px";break;case "end":s.left=Math.floor(x-_58c)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_581(w);w.width="0px";w.height="0px";wrap.appendChild(p);_587.node.insertBefore(wrap,_587.node.firstChild);if(has("dojo-bidi")){_587.htmlElementsRegistry.push([wrap,x,y,_589,text,font,_58a]);}return wrap;}}});});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_58d,_58e,_58f,lang,on,has,_590,_591){var _592=_58e("dijit._TemplatedMixin",_591,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _593=this.declaredClass,_594=this;return _590.substitute(tmpl,this,function(_595,key){if(key.charAt(0)=="!"){_595=lang.getObject(key.substr(1),false,_594);}if(typeof _595=="undefined"){throw new Error(_593+" template:"+key);}if(_595==null){return "";}return key.charAt(0)=="!"?_595:_595.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_58d(this.templatePath,{sanitize:true});}var _596=_592.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_596)){node=_58f.toDom(this._stringRepl(_596),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_596);}}else{node=_596.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_597){var dest=this.containerNode;if(_597&&dest){while(_597.hasChildNodes()){dest.appendChild(_597.firstChild);}}}});_592._templateCache={};_592.getCachedTemplate=function(_598,_599,doc){var _59a=_592._templateCache;var key=_598;var _59b=_59a[key];if(_59b){try{if(!_59b.ownerDocument||_59b.ownerDocument==(doc||document)){return _59b;}}catch(e){}_58f.destroy(_59b);}_598=_590.trim(_598);if(_599||_598.match(/\$\{([^\}]+)\}/g)){return (_59a[key]=_598);}else{var node=_58f.toDom(_598,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_598);}return (_59a[key]=node);}};if(has("ie")){on(window,"unload",function(){var _59c=_592._templateCache;for(var key in _59c){var _59d=_59c[key];if(typeof _59d=="object"){_58f.destroy(_59d);}delete _59c[key];}});}return _592;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_59e,lang,df){var _59f={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _59f)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _59f)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_59e.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _59f)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_59e.global;f=df.lambda(f);for(var i in obj){if(!(i in _59f)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_59e.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _59f)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_5a0,dom,geom,_5a1,_5a2){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_5a0.body(doc),_5a3=_5a2.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_5a2.create("div",{style:{overflow:"hidden",direction:"ltr"}},_5a3,"last"),ret=geom.position(div).x!=0;_5a3.removeChild(div);body.removeChild(_5a3);return ret;});has.add("position-fixed-support",function(win,doc){var body=_5a0.body(doc),_5a4=_5a2.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_5a5=_5a2.create("span",{style:{position:"fixed",left:"0",top:"0"}},_5a4,"last"),ret=geom.position(_5a5).x!=geom.position(_5a4).x;_5a4.removeChild(_5a5);body.removeChild(_5a4);return ret;});var _5a6={getBox:function(doc){doc=doc||_5a0.doc;var _5a7=(doc.compatMode=="BackCompat")?_5a0.body(doc):doc.documentElement,_5a8=geom.docScroll(doc),w,h;if(has("touch")){var _5a9=_5a6.get(doc);w=_5a9.innerWidth||_5a7.clientWidth;h=_5a9.innerHeight||_5a7.clientHeight;}else{w=_5a7.clientWidth;h=_5a7.clientHeight;}return {l:_5a8.x,t:_5a8.y,w:w,h:h};},get:function(doc){if(has("ie")&&_5a6!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_5a0.doc,body=_5a0.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _5aa=doc.compatMode=="BackCompat",_5ab=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_5ac=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_5ad=(isWK||_5aa)?body:html,_5ae=pos||geom.position(node),el=node.parentNode,_5af=function(el){return (isIE<=6||(isIE==7&&_5aa))?false:(has("position-fixed-support")&&(_5a1.get(el,"position").toLowerCase()=="fixed"));},self=this,_5b0=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_5af(node)){return;}while(el){if(el==body){el=_5ad;}var _5b1=geom.position(el),_5b2=_5af(el),rtl=_5a1.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_5ad){_5b1.w=_5ab;_5b1.h=_5ac;if(_5ad==html&&(isIE||has("trident"))&&rtl){_5b1.x+=_5ad.offsetWidth-_5b1.w;}if(_5b1.x<0||!isIE||isIE>=9||has("trident")){_5b1.x=0;}if(_5b1.y<0||!isIE||isIE>=9||has("trident")){_5b1.y=0;}}else{var pb=geom.getPadBorderExtents(el);_5b1.w-=pb.w;_5b1.h-=pb.h;_5b1.x+=pb.l;_5b1.y+=pb.t;var _5b3=el.clientWidth,_5b4=_5b1.w-_5b3;if(_5b3>0&&_5b4>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_5b1.x+=_5b4;}_5b1.w=_5b3;}_5b3=el.clientHeight;_5b4=_5b1.h-_5b3;if(_5b3>0&&_5b4>0){_5b1.h=_5b3;}}if(_5b2){if(_5b1.y<0){_5b1.h+=_5b1.y;_5b1.y=0;}if(_5b1.x<0){_5b1.w+=_5b1.x;_5b1.x=0;}if(_5b1.y+_5b1.h>_5ac){_5b1.h=_5ac-_5b1.y;}if(_5b1.x+_5b1.w>_5ab){_5b1.w=_5ab-_5b1.x;}}var l=_5ae.x-_5b1.x,t=_5ae.y-_5b1.y,r=l+_5ae.w-_5b1.w,bot=t+_5ae.h-_5b1.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_5ad||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_5aa)||isIE>=9||has("trident"))){s=-s;}old=el.scrollLeft;_5b0(el,s,0);s=el.scrollLeft-old;_5ae.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_5ad||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_5b0(el,0,s);s=el.scrollTop-old;_5ae.y-=s;}el=(el!=_5ad)&&!_5b2&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_5a6);return _5a6;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_5b5,_5b6,_5b7,_5b8,lin,_5b9,g,du,df,_5ba){var _5bb=45;var _5bc=_5b5(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_5b8,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_5bd,_5be){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_5be);du.updateWithPattern(this.opt,_5be,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;},setWindow:function(_5bf,_5c0){if(_5bf!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_5c1,font,_5c2){if(!_5c1.length){return 0;}if(_5c1.length>50){_5c1.length=50;}if(lang.isObject(_5c1[0])){_5c1=df.map(_5c1,function(_5c3){return _5c3.text;});}if(_5c2){_5c1=df.map(_5c1,function(_5c4){return lang.trim(_5c4).length==0?"":_5c4.substring(0,_5c2)+this.trailingSymbol;},this);}var s=_5c1.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_5c5,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _5c6=0,_5c7=0;var _5c8=function(tick){if(tick.label){this.push(tick.label);}};var _5c9=[];if(this.opt.majorLabels){arr.forEach(tb.major,_5c8,_5c9);_5c6=this._groupLabelWidth(_5c9,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c6=Math.min(ob.maxLabelSize,_5c6);}}_5c9=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_5c8,_5c9);_5c7=this._groupLabelWidth(_5c9,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c7=Math.min(ob.maxLabelSize,_5c7);}}this._maxLabelSize={majLabelW:_5c6,minLabelW:_5c7,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_5ca=o.rotation%360,_5cb=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_5cc=this._getMaxLabelSize(min,max,span,_5ca,font,size);if(typeof _5cb!="number"){_5cb=4;}if(_5cc&&o.dropLabels){var cosr=Math.abs(Math.cos(_5ca*Math.PI/180)),sinr=Math.abs(Math.sin(_5ca*Math.PI/180));var _5cd,_5ce;if(_5ca<0){_5ca+=360;}switch(_5ca){case 0:case 180:if(this.vertical){_5cd=_5ce=size;}else{_5cd=_5cc.majLabelW;_5ce=_5cc.minLabelW;}break;case 90:case 270:if(this.vertical){_5cd=_5cc.majLabelW;_5ce=_5cc.minLabelW;}else{_5cd=_5ce=size;}break;default:_5cd=this.vertical?Math.min(_5cc.majLabelW,size/cosr):Math.min(_5cc.majLabelW,size/sinr);var gap1=Math.sqrt(_5cc.minLabelW*_5cc.minLabelW+size*size),gap2=this.vertical?size*cosr+_5cc.minLabelW*sinr:_5cc.minLabelW*cosr+size*sinr;_5ce=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_5cd,_5ce)+_5cb;var _5cf=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_5cf){this._skipInterval=Math.floor((_5cd+_5cb)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_5d0={l:0,r:0,t:0,b:0};if(!s){return _5d0;}var o=this.opt,ta=this.chart.theme.axis,_5d1=this.chart.theme.axis.tick.labelGap,_5d2=o.titleFont||(ta.title&&ta.title.font),_5d3=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_5d4=this.chart.theme.getTick("major",o),_5d5=this.chart.theme.getTick("minor",o),_5d6=_5d2?g.normalizedLength(g.splitFontString(_5d2).size):0,_5d7=o.rotation%360,_5d8=o.leftBottom,cosr=Math.abs(Math.cos(_5d7*Math.PI/180)),sinr=Math.abs(Math.sin(_5d7*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _5d1!="number"){_5d1=4;}if(_5d7<0){_5d7+=360;}var _5d9=this._getMaxLabelSize();if(_5d9){var side;var _5da=Math.ceil(Math.max(_5d9.majLabelW,_5d9.minLabelW))+1,size=Math.ceil(Math.max(_5d9.majLabelH,_5d9.minLabelH))+1;if(this.vertical){side=_5d8?"l":"r";switch(_5d7){case 0:case 180:_5d0[side]=_5da;_5d0.t=_5d0.b=size/2;break;case 90:case 270:_5d0[side]=size;_5d0.t=_5d0.b=_5da/2;break;default:if(_5d7<=_5bb||(180<_5d7&&_5d7<=(180+_5bb))){_5d0[side]=size*sinr/2+_5da*cosr;_5d0[_5d8?"t":"b"]=size*cosr/2+_5da*sinr;_5d0[_5d8?"b":"t"]=size*cosr/2;}else{if(_5d7>(360-_5bb)||(180>_5d7&&_5d7>(180-_5bb))){_5d0[side]=size*sinr/2+_5da*cosr;_5d0[_5d8?"b":"t"]=size*cosr/2+_5da*sinr;_5d0[_5d8?"t":"b"]=size*cosr/2;}else{if(_5d7<90||(180<_5d7&&_5d7<270)){_5d0[side]=size*sinr+_5da*cosr;_5d0[_5d8?"t":"b"]=size*cosr+_5da*sinr;}else{_5d0[side]=size*sinr+_5da*cosr;_5d0[_5d8?"b":"t"]=size*cosr+_5da*sinr;}}}break;}_5d0[side]+=_5d1+Math.max(_5d4.length>0?_5d4.length:0,_5d5.length>0?_5d5.length:0)+(o.title?(_5d6+_5d3):0);}else{side=_5d8?"b":"t";switch(_5d7){case 0:case 180:_5d0[side]=size;_5d0.l=_5d0.r=_5da/2;break;case 90:case 270:_5d0[side]=_5da;_5d0.l=_5d0.r=size/2;break;default:if((90-_5bb)<=_5d7&&_5d7<=90||(270-_5bb)<=_5d7&&_5d7<=270){_5d0[side]=size*cosr/2+_5da*sinr;_5d0[_5d8?"r":"l"]=size*sinr/2+_5da*cosr;_5d0[_5d8?"l":"r"]=size*sinr/2;}else{if(90<=_5d7&&_5d7<=(90+_5bb)||270<=_5d7&&_5d7<=(270+_5bb)){_5d0[side]=size*cosr/2+_5da*sinr;_5d0[_5d8?"l":"r"]=size*sinr/2+_5da*cosr;_5d0[_5d8?"r":"l"]=size*sinr/2;}else{if(_5d7<_5bb||(180<_5d7&&_5d7<(180+_5bb))){_5d0[side]=size*cosr+_5da*sinr;_5d0[_5d8?"r":"l"]=size*sinr+_5da*cosr;}else{_5d0[side]=size*cosr+_5da*sinr;_5d0[_5d8?"l":"r"]=size*sinr+_5da*cosr;}}}break;}_5d0[side]+=_5d1+Math.max(_5d4.length>0?_5d4.length:0,_5d5.length>0?_5d5.length:0)+(o.title?(_5d6+_5d3):0);}}return _5d0;},cleanGroup:function(_5db){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_5dc,_5dd,x,y,_5de,_5df,font,_5e0,_5e1){if(!this.opt.enableCache||_5dc=="html"){return _5b9.createText[_5dc](this.chart,_5dd,x,y,_5de,_5df,font,_5e0,_5e1);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_5df,align:_5de});_5dd.add(text);}else{text=_5b9.createText[_5dc](this.chart,_5dd,x,y,_5de,_5df,font,_5e0);}this._textUsePool.push(text);return text;},createLine:function(_5e2,_5e3){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_5e3);_5e2.add(line);}else{line=_5e2.createLine(_5e3);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_5e4){var _5e5=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_5e6=o.leftBottom,_5e7=o.rotation%360,_5e8,stop,_5e9,_5ea=0,_5eb,_5ec,_5ed,_5ee,_5ef,_5f0,_5f1=this.chart.theme.axis.tick.labelGap,_5f2=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_5f3=o.titleFont||(ta.title&&ta.title.font),_5f4=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_5f5=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_5f6=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_5f7=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_5f8=this.chart.theme.getTick("major",o),_5f9=this.chart.theme.getTick("minor",o),_5fa=this.chart.theme.getTick("micro",o),_5fb="stroke" in o?o.stroke:ta.stroke,size=_5f2?g.normalizedLength(g.splitFontString(_5f2).size):0,cosr=Math.abs(Math.cos(_5e7*Math.PI/180)),sinr=Math.abs(Math.sin(_5e7*Math.PI/180)),_5fc=_5f3?g.normalizedLength(g.splitFontString(_5f3).size):0;if(typeof _5f1!="number"){_5f1=4;}if(_5e7<0){_5e7+=360;}var _5fd=this._getMaxLabelSize();_5fd=_5fd&&_5fd.majLabelW;if(this.vertical){_5e8={y:dim.height-_5e4.b};stop={y:_5e4.t};_5e9={y:(dim.height-_5e4.b+_5e4.t)/2};_5eb=size*sinr+(_5fd||0)*cosr+_5f1+Math.max(_5f8.length>0?_5f8.length:0,_5f9.length>0?_5f9.length:0)+_5fc+_5f6;_5ec={x:0,y:-1};_5ef={x:0,y:0};_5ed={x:1,y:0};_5ee={x:_5f1,y:0};switch(_5e7){case 0:_5f0="end";_5ef.y=size*0.4;break;case 90:_5f0="middle";_5ef.x=-size;break;case 180:_5f0="start";_5ef.y=-size*0.4;break;case 270:_5f0="middle";break;default:if(_5e7<_5bb){_5f0="end";_5ef.y=size*0.4;}else{if(_5e7<90){_5f0="end";_5ef.y=size*0.4;}else{if(_5e7<(180-_5bb)){_5f0="start";}else{if(_5e7<(180+_5bb)){_5f0="start";_5ef.y=-size*0.4;}else{if(_5e7<270){_5f0="start";_5ef.x=_5e6?0:size*0.4;}else{if(_5e7<(360-_5bb)){_5f0="end";_5ef.x=_5e6?0:size*0.4;}else{_5f0="end";_5ef.y=size*0.4;}}}}}}}if(_5e6){_5e8.x=stop.x=_5e4.l;_5ea=(_5f7&&_5f7=="away")?90:270;_5e9.x=_5e4.l-_5eb+(_5ea==270?_5fc:0);_5ed.x=-1;_5ee.x=-_5ee.x;}else{_5e8.x=stop.x=dim.width-_5e4.r;_5ea=(_5f7&&_5f7=="axis")?90:270;_5e9.x=dim.width-_5e4.r+_5eb-(_5ea==270?0:_5fc);switch(_5f0){case "start":_5f0="end";break;case "end":_5f0="start";break;case "middle":_5ef.x+=size;break;}}}else{_5e8={x:_5e4.l};stop={x:dim.width-_5e4.r};_5e9={x:(dim.width-_5e4.r+_5e4.l)/2};_5eb=size*cosr+(_5fd||0)*sinr+_5f1+Math.max(_5f8.length>0?_5f8.length:0,_5f9.length>0?_5f9.length:0)+_5fc+_5f6;_5ec={x:_5e5?-1:1,y:0};_5ef={x:0,y:0};_5ed={x:0,y:1};_5ee={x:0,y:_5f1};switch(_5e7){case 0:_5f0="middle";_5ef.y=size;break;case 90:_5f0="start";_5ef.x=-size*0.4;break;case 180:_5f0="middle";break;case 270:_5f0="end";_5ef.x=size*0.4;break;default:if(_5e7<(90-_5bb)){_5f0="start";_5ef.y=_5e6?size:0;}else{if(_5e7<(90+_5bb)){_5f0="start";_5ef.x=-size*0.4;}else{if(_5e7<180){_5f0="start";_5ef.y=_5e6?0:-size;}else{if(_5e7<(270-_5bb)){_5f0="end";_5ef.y=_5e6?0:-size;}else{if(_5e7<(270+_5bb)){_5f0="end";_5ef.y=_5e6?size*0.4:0;}else{_5f0="end";_5ef.y=_5e6?size:0;}}}}}}if(_5e6){_5e8.y=stop.y=dim.height-_5e4.b;_5ea=(_5f7&&_5f7=="axis")?180:0;_5e9.y=dim.height-_5e4.b+_5eb-(_5ea?_5fc:0);}else{_5e8.y=stop.y=_5e4.t;_5ea=(_5f7&&_5f7=="away")?180:0;_5e9.y=_5e4.t-_5eb+(_5ea?0:_5fc);_5ed.y=-1;_5ee.y=-_5ee.y;switch(_5f0){case "start":_5f0="end";break;case "end":_5f0="start";break;case "middle":_5ef.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_5fe=(!o.title||!_5ea)&&!_5e7&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_5ed.x*_5f8.length,dy=_5ed.y*_5f8.length,skip=this._skipInterval;s.createLine({x1:_5e8.x,y1:_5e8.y,x2:stop.x,y2:stop.y}).setStroke(_5fb);if(o.title){var _5ff=_5b9.createText[_5fe](this.chart,s,_5e9.x,_5e9.y,"middle",o.title,_5f3,_5f5);if(_5fe=="html"){this.htmlElements.push(_5ff);}else{_5ff.setTransform(g.matrix.rotategAt(_5ea,_5e9.x,_5e9.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _600=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _601=f(tick.value),elem,x=(_5e5?stop.x:_5e8.x)+_5ec.x*_601,y=_5e8.y+_5ec.y*_601;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f8);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _602=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5f2,o.maxLabelCharCount):{text:tick.label,truncated:false};_602=o.maxLabelSize?this.getTextWithLimitLength(_602.text,_5f2,o.maxLabelSize,_602.truncated):_602;elem=this.createText(_5fe,s,x+(_5f8.length>0?dx:0)+_5ee.x+(_5e7?0:_5ef.x),y+(_5f8.length>0?dy:0)+_5ee.y+(_5e7?0:_5ef.y),_5f0,_602.text,_5f2,_5f4);if(_602.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5fe);}_602.truncated&&this.labelTooltip(elem,this.chart,tick.label,_602.text,_5f2,_5fe);if(_5fe=="html"){this.htmlElements.push(elem);}else{if(_5e7){elem.setTransform([{dx:_5ef.x,dy:_5ef.y},g.matrix.rotategAt(_5e7,x+(_5f8.length>0?dx:0)+_5ee.x,y+(_5f8.length>0?dy:0)+_5ee.y)]);}}}},this);dx=_5ed.x*_5f9.length;dy=_5ed.y*_5f9.length;_600=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _603=f(tick.value),elem,x=(_5e5?stop.x:_5e8.x)+_5ec.x*_603,y=_5e8.y+_5ec.y*_603;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f9);if(_600&&tick.label){var _604=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5f2,o.maxLabelCharCount):{text:tick.label,truncated:false};_604=o.maxLabelSize?this.getTextWithLimitLength(_604.text,_5f2,o.maxLabelSize,_604.truncated):_604;elem=this.createText(_5fe,s,x+(_5f9.length>0?dx:0)+_5ee.x+(_5e7?0:_5ef.x),y+(_5f9.length>0?dy:0)+_5ee.y+(_5e7?0:_5ef.y),_5f0,_604.text,_5f2,_5f4);if(_604.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5fe);}_604.truncated&&this.labelTooltip(elem,this.chart,tick.label,_604.text,_5f2,_5fe);if(_5fe=="html"){this.htmlElements.push(elem);}else{if(_5e7){elem.setTransform([{dx:_5ef.x,dy:_5ef.y},g.matrix.rotategAt(_5e7,x+(_5f9.length>0?dx:0)+_5ee.x,y+(_5f9.length>0?dy:0)+_5ee.y)]);}}}},this);dx=_5ed.x*_5fa.length;dy=_5ed.y*_5fa.length;arr.forEach(t.micro,function(tick){var _605=f(tick.value),x=_5e8.x+_5ec.x*_605,y=_5e8.y+_5ec.y*_605;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5fa);},this);this.dirty=false;return this;},labelTooltip:function(elem,_606,_607,_608,font,_609){var _60a=["dijit/Tooltip"];var _60b={type:"rect"},_60c=["above","below"],_60d=g._base._getTextBox(_608,{font:font}).w||0,_60e=font?g.normalizedLength(g.splitFontString(font).size):0;if(_609=="html"){lang.mixin(_60b,_5b7.position(elem.firstChild,true));_60b.width=Math.ceil(_60d);_60b.height=Math.ceil(_60e);this._events.push({shape:dojo,handle:_5b6.connect(elem.firstChild,"onmouseover",this,function(e){require(_60a,function(_60f){_60f.show(_607,_60b,_60c);});})});this._events.push({shape:dojo,handle:_5b6.connect(elem.firstChild,"onmouseout",this,function(e){require(_60a,function(_610){_610.hide(_60b);});})});}else{var shp=elem.getShape(),lt=_606.getCoords();_60b=lang.mixin(_60b,{x:shp.x-_60d/2,y:shp.y});_60b.x+=lt.x;_60b.y+=lt.y;_60b.x=Math.round(_60b.x);_60b.y=Math.round(_60b.y);_60b.width=Math.ceil(_60d);_60b.height=Math.ceil(_60e);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_60a,function(_611){_611.show(_607,_60b,_60c);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_60a,function(_612){_612.hide(_60b);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_5b5("dojox.charting.axis2d.Default",[_5bc,_5ba]):_5bc;});},"dojox/charting/plot2d/ClusteredBars":function(){define(["dojo/_base/declare","./Bars","./common"],function(_613,Bars,dc){return _613("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/action2d/MoveSlice":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/array","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_614,_615,_616,dfe,m,gf,df){var _617=1.05,_618=7;return _614("dojox.charting.action2d.MoveSlice",_616,{defaultParams:{duration:400,easing:dfe.backOut,scale:_617,shift:_618},optionalParams:{},constructor:function(_619,plot,_61a){if(!_61a){_61a={};}this.scale=typeof _61a.scale=="number"?_61a.scale:_617;this.shift=typeof _61a.shift=="number"?_61a.shift:_618;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _61b=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}this.angles=_615.map(this.angles,function(item){return item+_61b;});}var _61c=o.index,anim,_61d,_61e,_61f,_620,_621=(this.angles[_61c]+this.angles[_61c+1])/2,_622=m.rotateAt(-_621,o.cx,o.cy),_623=m.rotateAt(_621,o.cx,o.cy);anim=this.anim[_61c];if(anim){anim.action.stop(true);}else{this.anim[_61c]=anim={};}if(o.type=="onmouseover"){_61f=0;_620=this.shift;_61d=1;_61e=this.scale;}else{_61f=this.shift;_620=0;_61d=this.scale;_61e=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_623,{name:"translate",start:[_61f,0],end:[_620,0]},{name:"scaleAt",start:[_61d,o.cx,o.cy],end:[_61e,o.cx,o.cy]},_622]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_61c];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_624,_625){var _626={};lang.setObject("dojo.colors",_626);var _627=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_624.fromRgb=function(_628,obj){var m=_628.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_625.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _624.fromArray(a,obj);}return _624.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_627(m1,m2,H+1/3)*256,_627(m1,m2,H)*256,_627(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _624.fromArray(a,obj);}}return null;};var _629=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_624.prototype.sanitize=function(){var t=this;t.r=Math.round(_629(t.r,0,255));t.g=Math.round(_629(t.g,0,255));t.b=Math.round(_629(t.b,0,255));t.a=_629(t.a,0,1);return this;};_626.makeGrey=_624.makeGrey=function(g,a){return _624.fromArray([g,g,g,a]);};lang.mixin(_624.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _624;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_62a,_62b,dlu,dgg){var _62c=_62a("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_62d){_62d=_62d||{};var def=_62c.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_62d[name]);},this);if(_62d.seriesThemes&&_62d.seriesThemes.length){this.colors=null;this.seriesThemes=_62d.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_62d.colors||_62c.defaultColors).slice(0);}this.markerThemes=null;if(_62d.markerThemes&&_62d.markerThemes.length){this.markerThemes=_62d.markerThemes.slice(0);}this.markers=_62d.markers?lang.clone(_62d.markers):lang.delegate(_62c.defaultMarkers);this.noGradConv=_62d.noGradConv;this.noRadialConv=_62d.noRadialConv;if(_62d.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _62e=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_62e[name]=this[name];}},this);return _62e;},clear:function(){this._current=0;},next:function(_62f,_630,_631){var _632=dlu.merge,_633,_634;if(this.colors){_633=lang.delegate(this.series);_634=lang.delegate(this.marker);var _635=new _62b(this.colors[this._current%this.colors.length]),old;if(_633.stroke&&_633.stroke.color){_633.stroke=lang.delegate(_633.stroke);old=new _62b(_633.stroke.color);_633.stroke.color=new _62b(_635);_633.stroke.color.a=old.a;}else{_633.stroke={color:_635};}if(_634.stroke&&_634.stroke.color){_634.stroke=lang.delegate(_634.stroke);old=new _62b(_634.stroke.color);_634.stroke.color=new _62b(_635);_634.stroke.color.a=old.a;}else{_634.stroke={color:_635};}if(!_633.fill||_633.fill.type){_633.fill=_635;}else{old=new _62b(_633.fill);_633.fill=new _62b(_635);_633.fill.a=old.a;}if(!_634.fill||_634.fill.type){_634.fill=_635;}else{old=new _62b(_634.fill);_634.fill=new _62b(_635);_634.fill.a=old.a;}}else{_633=this.seriesThemes?_632(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_634=this.markerThemes?_632(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_633;}var _636=_634&&_634.symbol||this._markers[this._current%this._markers.length];var _637={series:_633,marker:_634,symbol:_636};++this._current;if(_630){_637=this.addMixin(_637,_62f,_630);}if(_631){_637=this.post(_637,_62f);}return _637;},skip:function(){++this._current;},addMixin:function(_638,_639,_63a,_63b){if(lang.isArray(_63a)){arr.forEach(_63a,function(m){_638=this.addMixin(_638,_639,m);},this);}else{var t={};if("color" in _63a){if(_639=="line"||_639=="area"){lang.setObject("series.stroke.color",_63a.color,t);lang.setObject("marker.stroke.color",_63a.color,t);}else{lang.setObject("series.fill",_63a.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _63c="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_63c in _63a;if(name in _63a){lang.setObject("series."+name,_63a[name],t);if(!b){lang.setObject("marker."+name,_63a[name],t);}}if(b){lang.setObject("marker."+name,_63a[_63c],t);}});if("marker" in _63a){t.symbol=_63a.marker;t.symbol=_63a.marker;}_638=dlu.merge(_638,t);}if(_63b){_638=this.post(_638,_639);}return _638;},post:function(_63d,_63e){var fill=_63d.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_63e=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_63e=="slice"||_63e=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_63d,{series:{fill:t}});}}return _63d;},getTick:function(name,_63f){var tick=this.axis.tick,_640=name+"Tick",_641=dlu.merge;if(tick){if(this.axis[_640]){tick=_641(tick,this.axis[_640]);}}else{tick=this.axis[_640];}if(_63f){if(tick){if(_63f[_640]){tick=_641(tick,_63f[_640]);}}else{tick=_63f[_640];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_642){this.markers[name]=_642;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_62c,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _62c;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_643,_644,fx,dom,_645,_646,_647,lang,_648,on,has,_649,_64a,_64b,_64c,_64d,_64e,_64f){var _650=_644("dijit._MasterTooltip",[_64b,_64c],{duration:_649.defaultDuration,templateString:_64e,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _64d(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_651,_652,_653,rtl,_654){if(this.aroundNode&&this.aroundNode===_652&&this.containerNode.innerHTML==_651){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_651;if(_654){this.set("textDir",_654);}this.containerNode.align=rtl?"right":"left";var pos=_64a.around(this.domNode,_652,_653&&_653.length?_653:_655.defaultPosition,!rtl,lang.hitch(this,"orient"));var _656=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_656.y+((_656.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_656.x+((_656.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_647.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_652;},orient:function(node,_657,_658,_659,_65a){this.connectorNode.style.top="";var _65b=_659.h,_65c=_659.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_657+"-"+_658];this.domNode.style.width="auto";var size=_646.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _65d=Math.min((Math.max(_65c,1)),size.w);_646.setMarginBox(this.domNode,{w:_65d});if(_658.charAt(0)=="B"&&_657.charAt(0)=="B"){var bb=_646.position(node);var _65e=this.connectorNode.offsetHeight;if(bb.h>_65b){var _65f=_65b-((_65a.h+_65e)>>1);this.connectorNode.style.top=_65f+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_65a.h/2-_65e/2,0),bb.h-_65e)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_65c);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_660){if(this._onDeck&&this._onDeck[1]==_660){this._onDeck=null;}else{if(this.aroundNode===_660){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_650.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_643.forEach(node.children,function(_661){this._setAutoTextDir(_661);},this);},_setTextDirAttr:function(_662){this._set("textDir",_662);if(_662=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_64f.showTooltip=function(_663,_664,_665,rtl,_666){if(_665){_665=_643.map(_665,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_655._masterTT){_64f._masterTT=_655._masterTT=new _650();}return _655._masterTT.show(_663,_664,_665,rtl,_666);};_64f.hideTooltip=function(_667){return _655._masterTT&&_655._masterTT.hide(_667);};var _655=_644("dijit.Tooltip",_64b,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_668){_643.forEach(this._connections||[],function(_669){_643.forEach(_669,function(_66a){_66a.remove();});},this);this._connectIds=_643.filter(lang.isArrayLike(_668)?_668:(_668?[_668]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_643.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_66b=this.selector,_66c=_66b?function(_66d){return on.selector(_66b,_66d);}:function(_66e){return _66e;},self=this;return [on(node,_66c(_648.enter),function(){self._onHover(this);}),on(node,_66c("focusin"),function(){self._onHover(this);}),on(node,_66c(_648.leave),lang.hitch(self,"_onUnHover")),on(node,_66c("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_668);},addTarget:function(node){var id=node.id||node;if(_643.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_643.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_645.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_643.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_66f){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_66f);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_670){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _671=this.getContent(_670);if(!_671){return;}_655.show(_671,_670,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_670;this.onShow(_670,this.position);},close:function(){if(this._connectNode){_655.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_643.forEach(this._connections||[],function(_672){_643.forEach(_672,function(_673){_673.remove();});},this);this.inherited(arguments);}});_655._MasterTooltip=_650;_655.show=_64f.showTooltip;_655.hide=_64f.hideTooltip;_655.defaultPosition=["after-centered","before-centered"];return _655;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_674,_675,gfx,_676){return _675("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_677){this.chart=_677;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _678=this.getGroup().children;if(_676.dispose){for(var i=0;i<_678.length;++i){_676.dispose(_678[i],true);}}if(this.getGroup().rawNode){_674.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_676.dispose){_676.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_674.empty(this.group.rawNode);}this.group.clear();if(_676.dispose){_676.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_679){this.destroyHtmlElements();if(!_679){_679=this.chart.surface;}if(this.group){var _67a;var _67b=this.getGroup().children;if(_676.dispose){for(var i=0;i<_67b.length;++i){_676.dispose(_67b[i],true);}}if(this.getGroup().rawNode){_67a=this.getGroup().bgNode;_674.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_67a){this.getGroup().rawNode.appendChild(_67a);}}else{this.group=_679.createGroup();}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_674.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_67c,_67d){if(!s||s.length<=0){return {text:"",truncated:_67d||false};}if(!_67c||_67c<=0){return {text:s,truncated:_67d||false};}var _67e=2,_67f=0.618,_680=s.substring(0,1)+this.trailingSymbol,_681=this.getTextWidth(_680,font);if(_67c<=_681){return {text:_680,truncated:true};}var _682=this.getTextWidth(s,font);if(_682<=_67c){return {text:s,truncated:_67d||false};}else{var _683=0,end=s.length;while(_683<end){if(end-_683<=_67e){while(this.getTextWidth(s.substring(0,_683)+this.trailingSymbol,font)>_67c){_683-=1;}return {text:(s.substring(0,_683)+this.trailingSymbol),truncated:true};}var _684=_683+Math.round((end-_683)*_67f),_685=this.getTextWidth(s.substring(0,_684),font);if(_685<_67c){_683=_684;end=end;}else{_683=_683;end=_684;}}}},getTextWithLimitCharCount:function(s,font,_686,_687){if(!s||s.length<=0){return {text:"",truncated:_687||false};}if(!_686||_686<=0||s.length<=_686){return {text:s,truncated:_687||false};}return {text:s.substring(0,_686)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_688){if(!fill||!fill.type||!fill.space){return fill;}var _689=fill.space,span;switch(fill.type){case "linear":if(_689==="plot"||_689==="shapeX"||_689==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_689;if(_689==="plot"||_689==="shapeX"){span=dim.height-_688.t-_688.b;fill.y1=_688.t+span*fill.y1/100;fill.y2=_688.t+span*fill.y2/100;}if(_689==="plot"||_689==="shapeY"){span=dim.width-_688.l-_688.r;fill.x1=_688.l+span*fill.x1/100;fill.x2=_688.l+span*fill.x2/100;}}break;case "radial":if(_689==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_689;var _68a=dim.width-_688.l-_688.r,_68b=dim.height-_688.t-_688.b;fill.cx=_688.l+_68a*fill.cx/100;fill.cy=_688.t+_68b*fill.cy/100;fill.r=fill.r*Math.sqrt(_68a*_68a+_68b*_68b)/200;}break;case "pattern":if(_689==="plot"||_689==="shapeX"||_689==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_689;if(_689==="plot"||_689==="shapeX"){span=dim.height-_688.t-_688.b;fill.y=_688.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_689==="plot"||_689==="shapeY"){span=dim.width-_688.l-_688.r;fill.x=_688.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _68c=fill.space,span;switch(fill.type){case "linear":if(_68c==="shape"||_68c==="shapeX"||_68c==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_68c;if(_68c==="shape"||_68c==="shapeX"){span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_68c==="shape"||_68c==="shapeY"){span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_68c==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_68c;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_68c==="shape"||_68c==="shapeX"||_68c==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_68c;if(_68c==="shape"||_68c==="shapeX"){span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_68c==="shape"||_68c==="shapeY"){span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_68d,_68e,_68f,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _690=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_690;if(arguments.length<4){fill.cx=_68d.x;fill.cy=_68d.y;fill.r=fill.r*_68e/100;return fill;}var _691=arguments.length<5?_68f:(end+_68f)/2;return {type:"linear",x1:_68d.x,y1:_68d.y,x2:_68d.x+fill.r*_68e*Math.cos(_691)/100,y2:_68d.y+fill.r*_68e*Math.sin(_691)/100,colors:fill.colors};}});});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_692,_693,_694,_695,_696,_697,dom,_698,_699,_69a,_69b,_69c,has,_69d,lang,on,_69e,_69f,_6a0,win,_6a1,_6a2,_6a3){has.add("dijit-legacy-requires",!_69d.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_69e(0,function(){var _6a4=["dijit/_base/manager"];_692(_6a4);});}var _6a5={};function _6a6(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _6a7(attr){return function(val){_698[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _6a8(a,b){return a===b||(a!==a&&b!==b);};var _6a9=_697("dijit._WidgetBase",[_69f,_6a1],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_6a7("lang"),dir:"",_setDirAttr:_6a7("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_695.blankGif||_692.toUrl("dojo/resources/blank.gif"),_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _6aa=ctor.prototype,_6ab=ctor._setterAttrs=[],_6ac=(ctor._onMap={});for(var name in _6aa.attributeMap){_6ab.push(name);}for(name in _6aa){if(/^on/.test(name)){_6ac[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_6aa.attributeMap||!(name in _6aa.attributeMap)){_6ab.push(name);}}}}},postscript:function(_6ad,_6ae){this.create(_6ad,_6ae);},create:function(_6af,_6b0){this._introspect();this.srcNodeRef=dom.byId(_6b0);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_6af){this.params=_6af;lang.mixin(this,_6af);}this.postMixInProperties();if(!this.id){this.id=_6a3.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_6a3.add(this);this.buildRendering();var _6b1;if(this.domNode){this._applyAttributes();var _6b2=this.srcNodeRef;if(_6b2&&_6b2.parentNode&&this.domNode!==_6b2){_6b2.parentNode.replaceChild(this.domNode,_6b2);_6b1=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_6b1){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _6b3={};for(var key in this.params||{}){_6b3[key]=this._get(key);}_693.forEach(this.constructor._setterAttrs,function(key){if(!(key in _6b3)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _6b3){this.set(key,_6b3[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _6b4=this.baseClass.split(" ");if(!this.isLeftToRight()){_6b4=_6b4.concat(_693.map(_6b4,function(name){return name+"Rtl";}));}_699.add(this.domNode,_6b4);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_693.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_6b5){this._beingDestroyed=true;this.destroyDescendants(_6b5);this.destroy(_6b5);},destroy:function(_6b6){this._beingDestroyed=true;this.uninitialize();function _6b7(w){if(w.destroyRecursive){w.destroyRecursive(_6b6);}else{if(w.destroy){w.destroy(_6b6);}}};_693.forEach(this._connects,lang.hitch(this,"disconnect"));_693.forEach(this._supportingWidgets,_6b7);if(this.domNode){_693.forEach(_6a3.findWidgets(this.domNode,this.containerNode),_6b7);}this.destroyRendering(_6b6);_6a3.remove(this.id);this._destroyed=true;},destroyRendering:function(_6b8){if(this.bgIframe){this.bgIframe.destroy(_6b8);delete this.bgIframe;}if(this.domNode){if(_6b8){_698.remove(this.domNode,"widgetId");}else{_69a.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_6b8){_69a.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_6b9){_693.forEach(this.getChildren(),function(_6ba){if(_6ba.destroyRecursive){_6ba.destroyRecursive(_6b9);}});},uninitialize:function(){return false;},_setStyleAttr:function(_6bb){var _6bc=this.domNode;if(lang.isObject(_6bb)){_69c.set(_6bc,_6bb);}else{if(_6bc.style.cssText){_6bc.style.cssText+="; "+_6bb;}else{_6bc.style.cssText=_6bb;}}this._set("style",_6bb);},_attrToDom:function(attr,_6bd,_6be){_6be=arguments.length>=3?_6be:this.attributeMap[attr];_693.forEach(lang.isArray(_6be)?_6be:[_6be],function(_6bf){var _6c0=this[_6bf.node||_6bf||"domNode"];var type=_6bf.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_6bd)){_6bd=lang.hitch(this,_6bd);}var _6c1=_6bf.attribute?_6bf.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_6c0.tagName){_698.set(_6c0,_6c1,_6bd);}else{_6c0.set(_6c1,_6bd);}break;case "innerText":_6c0.innerHTML="";_6c0.appendChild(this.ownerDocument.createTextNode(_6bd));break;case "innerHTML":_6c0.innerHTML=_6bd;break;case "class":_699.replace(_6c0,_6bd,this[attr]);break;}},this);},get:function(name){var _6c2=this._getAttrNames(name);return this[_6c2.g]?this[_6c2.g]():this._get(name);},set:function(name,_6c3){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6c4=this._getAttrNames(name),_6c5=this[_6c4.s];if(lang.isFunction(_6c5)){var _6c6=_6c5.apply(this,Array.prototype.slice.call(arguments,1));}else{var _6c7=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_6c7]&&this[_6c7].tagName,_6c8=tag&&(_6a5[tag]||(_6a5[tag]=_6a6(this[_6c7]))),map=name in this.attributeMap?this.attributeMap[name]:_6c4.s in this?this[_6c4.s]:((_6c8&&_6c4.l in _6c8&&typeof _6c3!="function")||/^aria-|^data-|^role$/.test(name))?_6c7:null;if(map!=null){this._attrToDom(name,_6c3,map);}this._set(name,_6c3);}return _6c6||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_6c9){var _6ca=this[name];this[name]=_6c9;if(this._created&&!_6a8(_6ca,_6c9)){if(this._watchCallbacks){this._watchCallbacks(name,_6ca,_6c9);}this.emit("attrmodified-"+name,{detail:{prevValue:_6ca,newValue:_6c9}});}},_get:function(name){return this[name];},emit:function(type,_6cb,_6cc){_6cb=_6cb||{};if(_6cb.bubbles===undefined){_6cb.bubbles=true;}if(_6cb.cancelable===undefined){_6cb.cancelable=true;}if(!_6cb.detail){_6cb.detail={};}_6cb.detail.widget=this;var ret,_6cd=this["on"+type];if(_6cd){ret=_6cd.apply(this,_6cc?_6cc:[_6cb]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_6cb);}return ret;},on:function(type,func){var _6ce=this._onMap(type);if(_6ce){return _694.after(this,_6ce,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_6a3.findWidgets(this.containerNode):[];},getParent:function(){return _6a3.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_6cf,_6d0){return this.own(_696.connect(obj,_6cf,this,_6d0))[0];},disconnect:function(_6d1){_6d1.remove();},subscribe:function(t,_6d2){return this.own(_6a0.subscribe(t,lang.hitch(this,_6d2)))[0];},unsubscribe:function(_6d3){_6d3.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_69b.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_69c.get(this.domNode,"display")!="none");},placeAt:function(_6d4,_6d5){var _6d6=!_6d4.tagName&&_6a3.byId(_6d4);if(_6d6&&_6d6.addChild&&(!_6d5||typeof _6d5==="number")){_6d6.addChild(this,_6d5);}else{var ref=_6d6?(_6d6.containerNode&&!/after|before|replace/.test(_6d5||"")?_6d6.containerNode:_6d6.domNode):dom.byId(_6d4,this.ownerDocument);_69a.place(this.domNode,ref,_6d5);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_6d7){var _6d8=setTimeout(lang.hitch(this,function(){if(!_6d8){return;}_6d8=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_6d7||0);return {remove:function(){if(_6d8){clearTimeout(_6d8);_6d8=null;}return null;}};}});if(has("dojo-bidi")){_6a9.extend(_6a2);}return _6a9;});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","dojo/_base/lang","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(_6d9,lang,_6da){_6d9.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.widget.Chart2D",_6da);});