/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/_editor/plugins/FontChoice":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/i18n","dojo/_base/lang","dojo/store/Memory","../../registry","../../_Widget","../../_TemplatedMixin","../../_WidgetsInTemplateMixin","../../form/FilteringSelect","../_Plugin","../range","dojo/i18n!../nls/FontChoice"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e){var _f=_3("dijit._editor.plugins._FontDropDown",[_9,_a,_b],{label:"",plainText:false,templateString:"<span style='white-space: nowrap' class='dijit dijitReset dijitInline'>"+"<label class='dijitLeft dijitInline' for='${selectId}'>${label}</label>"+"<input data-dojo-type='../../form/FilteringSelect' required='false' "+"data-dojo-props='labelType:\"html\", labelAttr:\"label\", searchAttr:\"name\"' "+"class='${comboClass}' "+"tabIndex='-1' id='${selectId}' data-dojo-attach-point='select' value=''/>"+"</span>",contextRequire:_1,postMixInProperties:function(){this.inherited(arguments);this.strings=_5.getLocalization("dijit._editor","FontChoice");this.label=this.strings[this.command];this.id=_8.getUniqueId(this.declaredClass.replace(/\./g,"_"));this.selectId=this.id+"_select";this.inherited(arguments);},postCreate:function(){this.select.set("store",new _7({idProperty:"value",data:_2.map(this.values,function(_10){var _11=this.strings[_10]||_10;return {label:this.getLabel(_10,_11),name:_11,value:_10};},this)}));this.select.set("value","",false);this.disabled=this.select.get("disabled");},_setValueAttr:function(_12,_13){_13=_13!==false;this.select.set("value",_2.indexOf(this.values,_12)<0?"":_12,_13);if(!_13){this.select._lastValueReported=null;}},_getValueAttr:function(){return this.select.get("value");},focus:function(){this.select.focus();},_setDisabledAttr:function(_14){this._set("disabled",_14);this.select.set("disabled",_14);}});var _15=_3("dijit._editor.plugins._FontNameDropDown",_f,{generic:false,command:"fontName",comboClass:"dijitFontNameCombo",postMixInProperties:function(){if(!this.values){this.values=this.generic?["serif","sans-serif","monospace","cursive","fantasy"]:["Arial","Times New Roman","Comic Sans MS","Courier New"];}this.inherited(arguments);},getLabel:function(_16,_17){if(this.plainText){return _17;}else{return "<div style='font-family: "+_16+"'>"+_17+"</div>";}},_setValueAttr:function(_18,_19){_19=_19!==false;if(this.generic){var map={"Arial":"sans-serif","Helvetica":"sans-serif","Myriad":"sans-serif","Times":"serif","Times New Roman":"serif","Comic Sans MS":"cursive","Apple Chancery":"cursive","Courier":"monospace","Courier New":"monospace","Papyrus":"fantasy","Estrangelo Edessa":"cursive","Gabriola":"fantasy"};_18=map[_18]||_18;}this.inherited(arguments,[_18,_19]);}});var _1a=_3("dijit._editor.plugins._FontSizeDropDown",_f,{command:"fontSize",comboClass:"dijitFontSizeCombo",values:[1,2,3,4,5,6,7],getLabel:function(_1b,_1c){if(this.plainText){return _1c;}else{return "<font size="+_1b+"'>"+_1c+"</font>";}},_setValueAttr:function(_1d,_1e){_1e=_1e!==false;if(_1d.indexOf&&_1d.indexOf("px")!=-1){var _1f=parseInt(_1d,10);_1d={10:1,13:2,16:3,18:4,24:5,32:6,48:7}[_1f]||_1d;}this.inherited(arguments,[_1d,_1e]);}});var _20=_3("dijit._editor.plugins._FormatBlockDropDown",_f,{command:"formatBlock",comboClass:"dijitFormatBlockCombo",values:["noFormat","p","h1","h2","h3","pre"],postCreate:function(){this.inherited(arguments);this.set("value","noFormat",false);},getLabel:function(_21,_22){if(this.plainText||_21=="noFormat"){return _22;}else{return "<"+_21+">"+_22+"</"+_21+">";}},_execCommand:function(_23,_24,_25){if(_25==="noFormat"){var _26;var end;var sel=_e.getSelection(_23.window);if(sel&&sel.rangeCount>0){var _27=sel.getRangeAt(0);var _28,tag;if(_27){_26=_27.startContainer;end=_27.endContainer;while(_26&&_26!==_23.editNode&&_26!==_23.document.body&&_26.nodeType!==1){_26=_26.parentNode;}while(end&&end!==_23.editNode&&end!==_23.document.body&&end.nodeType!==1){end=end.parentNode;}var _29=_6.hitch(this,function(_2a,ary){if(_2a.childNodes&&_2a.childNodes.length){var i;for(i=0;i<_2a.childNodes.length;i++){var c=_2a.childNodes[i];if(c.nodeType==1){if(_23.selection.inSelection(c)){var tag=c.tagName?c.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){ary.push(c);}_29(c,ary);}}}}});var _2b=_6.hitch(this,function(_2c){if(_2c&&_2c.length){_23.beginEditing();while(_2c.length){this._removeFormat(_23,_2c.pop());}_23.endEditing();}});var _2d=[];if(_26==end){var _2e;_28=_26;while(_28&&_28!==_23.editNode&&_28!==_23.document.body){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2e=_28;break;}}_28=_28.parentNode;}_29(_26,_2d);if(_2e){_2d=[_2e].concat(_2d);}_2b(_2d);}else{_28=_26;while(_23.selection.inSelection(_28)){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2d.push(_28);}_29(_28,_2d);}_28=_28.nextSibling;}_2b(_2d);}_23.onDisplayChanged();}}}else{_23.execCommand(_24,_25);}},_removeFormat:function(_2f,_30){if(_2f.customUndo){while(_30.firstChild){_4.place(_30.firstChild,_30,"before");}_30.parentNode.removeChild(_30);}else{_2f.selection.selectElementChildren(_30);var _31=_2f.selection.getSelectedHtml();_2f.selection.selectElement(_30);_2f.execCommand("inserthtml",_31||"");}}});var _32=_3("dijit._editor.plugins.FontChoice",_d,{useDefaultCommand:false,_initButton:function(){var _33={fontName:_15,fontSize:_1a,formatBlock:_20}[this.command],_34=this.params;if(this.params.custom){_34.values=this.params.custom;}var _35=this.editor;this.button=new _33(_6.delegate({dir:_35.dir,lang:_35.lang},_34));this.own(this.button.select.on("change",_6.hitch(this,function(_36){if(this.editor.focused){this.editor.focus();}if(this.command=="fontName"&&_36.indexOf(" ")!=-1){_36="'"+_36+"'";}if(this.button._execCommand){this.button._execCommand(this.editor,this.command,_36);}else{this.editor.execCommand(this.command,_36);}})));},updateState:function(){var _37=this.editor;var _38=this.command;if(!_37||!_37.isLoaded||!_38.length){return;}if(this.button){var _39=this.get("disabled");this.button.set("disabled",_39);if(_39){return;}var _3a;try{_3a=_37.queryCommandValue(_38)||"";}catch(e){_3a="";}var _3b=_6.isString(_3a)&&_3a.match(/'([^']*)'/);if(_3b){_3a=_3b[1];}if(_38==="formatBlock"){if(!_3a||_3a=="p"){_3a=null;var _3c;var sel=_e.getSelection(this.editor.window);if(sel&&sel.rangeCount>0){var _3d=sel.getRangeAt(0);if(_3d){_3c=_3d.endContainer;}}while(_3c&&_3c!==_37.editNode&&_3c!==_37.document){var tg=_3c.tagName?_3c.tagName.toLowerCase():"";if(tg&&_2.indexOf(this.button.values,tg)>-1){_3a=tg;break;}_3c=_3c.parentNode;}if(!_3a){_3a="noFormat";}}else{if(_2.indexOf(this.button.values,_3a)<0){_3a="noFormat";}}}if(_3a!==this.button.get("value")){this.button.set("value",_3a,false);}}}});_2.forEach(["fontName","fontSize","formatBlock"],function(_3e){_d.registry[_3e]=function(_3f){return new _32({command:_3e,plainText:_3f.plainText});};});_32._FontDropDown=_f;_32._FontNameDropDown=_15;_32._FontSizeDropDown=_1a;_32._FormatBlockDropDown=_20;return _32;});},"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_40,_41,_42,_43,_44,on,has,_45,_46,_47,_48){var _49=_40("dijit.form.TextBox"+(has("dojo-bidi")?"_NoBidi":""),[_45,_46],{templateString:_47,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var _4a=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((_4a=="hidden"||_4a=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(has("ie")<9){this.defer(function(){try{var s=_42.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _4b=this.domNode.getElementsByTagName("INPUT");if(_4b){for(var i=0;i<_4b.length;i++){_4b[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_41.create("span",{onmousedown:function(e){e.preventDefault();},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"touchend, pointerup, MSPointerUp",_44.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(evt){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_4c,_4d,_4e){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_43.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_4f){_43.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_4f);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(has("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")<9){_49.prototype._isTextSelected=function(){var _50=this.ownerDocument.selection.createRange();var _51=_50.parentElement();return _51==this.textbox&&_50.text.length>0;};_48._setSelectionRange=_46._setSelectionRange=function(_52,_53,_54){if(_52.createTextRange){var r=_52.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_53);r.moveEnd("character",_54-_53);r.select();}};}if(has("dojo-bidi")){_49=_40("dijit.form.TextBox",_49,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _49;});},"dojo/currency":function(){define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_55,_56,_57,_58,_59,_5a){var _5b={};_56.setObject("dojo.currency",_5b);_5b._mixInDefaults=function(_5c){_5c=_5c||{};_5c.type="currency";var _5d=_58.getLocalization("dojo.cldr","currency",_5c.locale)||{};var iso=_5c.currency;var _5e=_5a.getData(iso);_55.forEach(["displayName","symbol","group","decimal"],function(_5f){_5e[_5f]=_5d[iso+"_"+_5f];});_5e.fractional=[true,false];return _56.mixin(_5e,_5c);};_5b.format=function(_60,_61){return _57.format(_60,_5b._mixInDefaults(_61));};_5b.regexp=function(_62){return _57.regexp(_5b._mixInDefaults(_62));};_5b.parse=function(_63,_64){return _57.parse(_63,_5b._mixInDefaults(_64));};return _5b;});},"dijit/layout/ScrollingTabController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom","../a11yclick"],function(_65,_66,_67,_68,_69,fx,_6a,on,_6b,has,_6c,_6d,_6e,_6f,_70,_71,_72,_73,_74,_75){var _76=_66("dijit.layout.ScrollingTabController",[_6f,_71],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_6d,useMenu:true,useSlider:true,tabStripClass:"",_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_67.add(n,"tabStrip-disabled");}_67.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_69.set(this.domNode,"visibility","");this._postStartup=true;this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_6a.hitch(this,function(evt){if(this._dim){this.resize(this._dim);}})));},onAddChild:function(_77,_78){this.inherited(arguments);_69.set(this.containerNode,"width",(_69.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(_79,_7a){var _7b=this.pane2button(_79.id);if(this._selectedTab===_7b.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_6b("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_68.getMarginSize(btn).w;return true;}else{_69.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _7c=this.getChildren();if(_7c.length){var _7d=_7c[this.isLeftToRight()?0:_7c.length-1].domNode,_7e=_7c[this.isLeftToRight()?_7c.length-1:0].domNode;return _7e.offsetLeft+_7e.offsetWidth-_7d.offsetLeft;}else{return 0;}},_enableBtn:function(_7f){var _80=this._getTabsWidth();_7f=_7f||_69.get(this.scrollNode,"width");return _80>0&&_7f<_80;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_70.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_68.setContentSize(this.domNode,cb);var _81=this._enableBtn(this._contentBox.w);this._buttons.style("display",_81?"":"none");this._leftBtn.region="left";this._rightBtn.region="right";this._menuBtn.region=this.isLeftToRight()?"right":"left";_70.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,region:"center"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){return val;}else{var _82=_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width");return (has("ie")>=8?-1:1)*(val-_82);}},onSelectChild:function(_83){var tab=this.pane2button(_83.id);if(!tab){return;}var _84=tab.domNode;if(_84!=this._selectedTab){this._selectedTab=_84;if(this._postResize){var sl=this._getScroll();if(sl>_84.offsetLeft||sl+_69.get(this.scrollNode,"width")<_84.offsetLeft+_69.get(_84,"width")){this.createSmoothScroll().play();}}}this.inherited(arguments);},_getScrollBounds:function(){var _85=this.getChildren(),_86=_69.get(this.scrollNode,"width"),_87=_69.get(this.containerNode,"width"),_88=_87-_86,_89=this._getTabsWidth();if(_85.length&&_89>_86){return {min:this.isLeftToRight()?0:_85[_85.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_85[_85.length-1].domNode.offsetLeft+_85[_85.length-1].domNode.offsetWidth)-_86:_88};}else{var _8a=this.isLeftToRight()?0:_88;return {min:_8a,max:_8a};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_8b=_69.get(this.scrollNode,"width"),_8c=this._getScrollBounds();var pos=(n.offsetLeft+_69.get(n,"width")/2)-_8b/2;pos=Math.min(Math.max(pos,_8c.min),_8c.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _8d=this._getScrollBounds();x=Math.min(Math.max(x,_8d.min),_8d.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var _8e=this,w=this.scrollNode,_8f=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var _90=w.scrollLeft,_91=_8e._convertToScrollLeft(x);_8f.curve=new fx._Line(_90,_91);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=_8f;this._setButtonClass(x);return _8f;},_getBtnNode:function(e){var n=e.target;while(n&&!_67.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_92,_93){if(_93&&_67.contains(_93,"dijitTabDisabled")){return;}var _94=_69.get(this.scrollNode,"width");var d=(_94*0.75)*_92;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_95){var _96=this._getScrollBounds();this._leftBtn.set("disabled",_95<=_96.min);this._rightBtn.set("disabled",_95>=_96.max);}});var _97=_66("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_6e,tabIndex:"",isFocusable:function(){return false;}});_66("dijit.layout._ScrollingTabControllerButton",[_74,_97]);_66("dijit.layout._ScrollingTabControllerMenuButton",[_74,_75,_97],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_98){this.dropDown=new _72({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});var _99=_6c.byId(this.containerId);_65.forEach(_99.getChildren(),function(_9a){var _9b=new _73({id:_9a.id+"_stcMi",label:_9a.title,iconClass:_9a.iconClass,disabled:_9a.disabled,ownerDocument:this.ownerDocument,dir:_9a.dir,lang:_9a.lang,textDir:_9a.textDir||_99.textDir,onClick:function(){_99.selectChild(_9a);}});this.dropDown.addChild(_9b);},this);_98();},closeDropDown:function(_9c){this.inherited(arguments);if(this.dropDown){this._popupStateNode.removeAttribute("aria-owns");this.dropDown.destroyRecursive();delete this.dropDown;}}});return _76;});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_9d,_9e,_9f,_a0,_a1,on,_a2,_a3,_a4,_a5,_a6,_a7){var _a8=_9d("dijit.DialogUnderlay",[_a3,_a4],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_a0.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_a9){this.node.className="dijitDialogUnderlay "+_a9;this._set("class",_a9);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",_9e.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _aa=_a2.getBox(this.ownerDocument);os.top=_aa.t+"px";os.left=_aa.l+"px";is.width=_aa.w+"px";is.height=_aa.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _a5(this.domNode);var win=_a2.get(this.ownerDocument);this._modalConnects=[_a6.on("resize",_9e.hitch(this,"layout")),on(win,"scroll",_9e.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_a8.show=function(_ab,_ac){var _ad=_a8._singleton;if(!_ad||_ad._destroyed){_ad=_a7._underlay=_a8._singleton=new _a8(_ab);}else{if(_ab){_ad.set(_ab);}}_a1.set(_ad.domNode,"zIndex",_ac);if(!_ad.open){_ad.show();}};_a8.hide=function(){var _ae=_a8._singleton;if(_ae&&!_ae._destroyed){_ae.hide();}};return _a8;});},"dijit/_editor/html":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(_af,_b0,has){var _b1={};_b0.setObject("dijit._editor.html",_b1);var _b2=_b1.escapeXml=function(str,_b3){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_b3){str=str.replace(/'/gm,"&#39;");}return str;};_b1.getNodeHtml=function(_b4){var _b5=[];_b1.getNodeHtmlHelper(_b4,_b5);return _b5.join("");};_b1.getNodeHtmlHelper=function(_b6,_b7){switch(_b6.nodeType){case 1:var _b8=_b6.nodeName.toLowerCase();if(!_b8||_b8.charAt(0)=="/"){return "";}_b7.push("<",_b8);var _b9=[],_ba={};var _bb;if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){var i=0;while((_bb=_b6.attributes[i++])){var n=_bb.name;if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||_bb.specified)&&!(n in _ba)){var v=_bb.value;if(n=="src"||n=="href"){if(_b6.getAttribute("_djrealurl")){v=_b6.getAttribute("_djrealurl");}}if(has("ie")===8&&n==="style"){v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");}_b9.push([n,v]);_ba[n]=v;}}}else{var _bc=/^input$|^img$/i.test(_b6.nodeName)?_b6:_b6.cloneNode(false);var s=_bc.outerHTML;var _bd=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;var _be=s.match(_bd);s=s.substr(0,s.indexOf(">"));_af.forEach(_be,function(_bf){if(_bf){var idx=_bf.indexOf("=");if(idx>0){var key=_bf.substring(0,idx);if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(_b6.getAttribute("_djrealurl")){_b9.push([key,_b6.getAttribute("_djrealurl")]);return;}}var val,_c0;switch(key){case "style":val=_b6.style.cssText.toLowerCase();break;case "class":val=_b6.className;break;case "width":if(_b8==="img"){_c0=/width=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}case "height":if(_b8==="img"){_c0=/height=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}default:val=_b6.getAttribute(key);}if(val!=null){_b9.push([key,val.toString()]);}}}}},this);}_b9.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((_bb=_b9[j++])){_b7.push(" ",_bb[0],"=\"",(typeof _bb[1]==="string"?_b2(_bb[1],true):_bb[1]),"\"");}switch(_b8){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_b7.push(" />");break;case "script":_b7.push(">",_b6.innerHTML,"</",_b8,">");break;default:_b7.push(">");if(_b6.hasChildNodes()){_b1.getChildrenHtmlHelper(_b6,_b7);}_b7.push("</",_b8,">");}break;case 4:case 3:_b7.push(_b2(_b6.nodeValue,true));break;case 8:_b7.push("<!--",_b2(_b6.nodeValue,true),"-->");break;default:_b7.push("<!-- Element not recognized - Type: ",_b6.nodeType," Name: ",_b6.nodeName,"-->");}};_b1.getChildrenHtml=function(_c1){var _c2=[];_b1.getChildrenHtmlHelper(_c1,_c2);return _c2.join("");};_b1.getChildrenHtmlHelper=function(dom,_c3){if(!dom){return;}var _c4=dom["childNodes"]||dom;var _c5=!has("ie")||_c4!==dom;var _c6,i=0;while((_c6=_c4[i++])){if(!_c5||_c6.parentNode==dom){_b1.getNodeHtmlHelper(_c6,_c3);}}};return _b1;});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_c7,_c8,dom,_c9,_ca,_cb,_cc,has,_cd,_ce,on,_cf,_d0,_d1,_d2,_d3){return _c7("dijit._HasDropDown",_d3,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}if(e.type!="MSPointerDown"&&e.type!="pointerdown"){e.preventDefault();}this._docHandler=this.own(on(this.ownerDocument,_cf.release,_ce.hitch(this,"_onDropDownMouseUp")))[0];this.toggleDropDown();},_onDropDownMouseUp:function(e){if(e&&this._docHandler){this._docHandler.remove();this._docHandler=null;}var _d4=this.dropDown,_d5=false;if(e&&this._opened){var c=_cb.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_d5){if(_ca.contains(t,"dijitPopup")){_d5=true;}else{t=t.parentNode;}}if(_d5){t=e.target;if(_d4.onItemClick){var _d6;while(t&&!(_d6=_d0.byNode(t))){t=t.parentNode;}if(_d6&&_d6.onClick&&_d6.getParent){_d6.getParent().onItemClick(_d6,e);}}return;}}}if(this._opened){if(_d4.focus&&(_d4.autoFocus!==false||(e.type=="mouseup"&&!this.hovering))){this._focusDropDownTimer=this.defer(function(){_d4.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _d7={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_ca.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_d7+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _d8=this.focusNode||this.domNode;this.own(on(this._buttonNode,_cf.press,_ce.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_ce.hitch(this,"_onDropDownClick")),on(_d8,"keydown",_ce.hitch(this,"_onKey")),on(_d8,"keyup",_ce.hitch(this,"_onKeyUp")));},destroy:function(){if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_d9=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==_cd.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==_cd.DOWN_ARROW||((e.keyCode==_cd.ENTER||(e.keyCode==_cd.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_d9.tagName||"").toLowerCase()!=="input"||(_d9.type&&_d9.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(_ce.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_da){_da();},loadAndOpenDropDown:function(){var d=new _c8(),_db=_ce.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_db);}else{_db();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _dc=this.dropDown,_dd=_dc.domNode,_de=this._aroundNode||this.domNode,_df=this;var _e0=_d2.open({parent:this,popup:_dc,around:_de,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){_df.closeDropDown(true);},onCancel:function(){_df.closeDropDown(true);},onClose:function(){_c9.set(_df._popupStateNode,"popupActive",false);_ca.remove(_df._popupStateNode,"dijitHasDropDownOpen");_df._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_de.offsetWidth>_dc._popupWrapper.offsetWidth)){var _e1=_de.offsetWidth-_dc._popupWrapper.offsetWidth;var _e2={w:_dc.domNode.offsetWidth+_e1};if(_ce.isFunction(_dc.resize)){_dc.resize(_e2);}else{_cb.setMarginBox(_dd,_e2);}if(_e0.corner[1]=="R"){_dc._popupWrapper.style.left=(_dc._popupWrapper.style.left.replace("px","")-_e1)+"px";}}_c9.set(this._popupStateNode,"popupActive","true");_ca.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_dc.id);if(_dd.getAttribute("role")!=="presentation"&&!_dd.getAttribute("aria-labelledby")){_dd.setAttribute("aria-labelledby",this.id);}return _e0;},closeDropDown:function(_e3){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_e3){this.focus();}_d2.close(this.dropDown);this._opened=false;}}});});},"dijit/tree/TreeStoreModel":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_e4,_e5,_e6,_e7){return _e6("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_e8){_e7.mixin(this,_e8);this.connects=[];var _e9=this.store;if(!_e9.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");}if(_e9.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_e5.after(_e9,"onNew",_e7.hitch(this,"onNewItem"),true),_e5.after(_e9,"onDelete",_e7.hitch(this,"onDeleteItem"),true),_e5.after(_e9,"onSet",_e7.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_ea,_eb){if(this.root){_ea(this.root);}else{this.store.fetch({query:this.query,onComplete:_e7.hitch(this,function(_ec){if(_ec.length!=1){throw new Error("dijit.tree.TreeStoreModel: root query returned "+_ec.length+" items, but must return exactly one");}this.root=_ec[0];_ea(this.root);}),onError:_eb});}},mayHaveChildren:function(_ed){return _e4.some(this.childrenAttrs,function(_ee){return this.store.hasAttribute(_ed,_ee);},this);},getChildren:function(_ef,_f0,_f1){var _f2=this.store;if(!_f2.isItemLoaded(_ef)){var _f3=_e7.hitch(this,arguments.callee);_f2.loadItem({item:_ef,onItem:function(_f4){_f3(_f4,_f0,_f1);},onError:_f1});return;}var _f5=[];for(var i=0;i<this.childrenAttrs.length;i++){var _f6=_f2.getValues(_ef,this.childrenAttrs[i]);_f5=_f5.concat(_f6);}var _f7=0;if(!this.deferItemLoadingUntilExpand){_e4.forEach(_f5,function(_f8){if(!_f2.isItemLoaded(_f8)){_f7++;}});}if(_f7==0){_f0(_f5);}else{_e4.forEach(_f5,function(_f9,idx){if(!_f2.isItemLoaded(_f9)){_f2.loadItem({item:_f9,onItem:function(_fa){_f5[idx]=_fa;if(--_f7==0){_f0(_f5);}},onError:_f1});}});}},isItem:function(_fb){return this.store.isItem(_fb);},fetchItemByIdentity:function(_fc){this.store.fetchItemByIdentity(_fc);},getIdentity:function(_fd){return this.store.getIdentity(_fd);},getLabel:function(_fe){if(this.labelAttr){return this.store.getValue(_fe,this.labelAttr);}else{return this.store.getLabel(_fe);}},newItem:function(_ff,_100,_101){var _102={parent:_100,attribute:this.childrenAttrs[0]},_103;if(this.newItemIdAttr&&_ff[this.newItemIdAttr]){this.fetchItemByIdentity({identity:_ff[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_100,true,_101);}else{_103=this.store.newItem(_ff,_102);if(_103&&(_101!=undefined)){this.pasteItem(_103,_100,_100,false,_101);}}}});}else{_103=this.store.newItem(_ff,_102);if(_103&&(_101!=undefined)){this.pasteItem(_103,_100,_100,false,_101);}}},pasteItem:function(_104,_105,_106,_107,_108){var _109=this.store,_10a=this.childrenAttrs[0];if(_105){_e4.forEach(this.childrenAttrs,function(attr){if(_109.containsValue(_105,attr,_104)){if(!_107){var _10b=_e4.filter(_109.getValues(_105,attr),function(x){return x!=_104;});_109.setValues(_105,attr,_10b);}_10a=attr;}});}if(_106){if(typeof _108=="number"){var _10c=_109.getValues(_106,_10a).slice();_10c.splice(_108,0,_104);_109.setValues(_106,_10a,_10c);}else{_109.setValues(_106,_10a,_109.getValues(_106,_10a).concat(_104));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_10d){if(!_10d){return;}this.getChildren(_10d.item,_e7.hitch(this,function(_10e){this.onChildrenChange(_10d.item,_10e);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_10f){if(_e4.indexOf(this.childrenAttrs,_10f)!=-1){this.getChildren(item,_e7.hitch(this,function(_110){this.onChildrenChange(item,_110);}));}else{this.onChange(item);}}});});},"dijit/_editor/plugins/EnterKeyHandling":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range","../../_base/focus"],function(_111,_112,keys,lang,on,has,win,_113,_114,_115,_116,_117){return _111("dijit._editor.plugins.EnterKeyHandling",_114,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_118){if(this.editor===_118){return;}this.editor=_118;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_118.onLoadDeferred.then(lang.hitch(this,function(d){this.own(on(_118.document,"keydown",lang.hitch(this,function(e){if(e.keyCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){e.stopPropagation();e.preventDefault();}}})));if(has("ie")>=9&&has("ie")<=10){this.own(on(_118.document,"paste",lang.hitch(this,function(e){setTimeout(lang.hitch(this,function(){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();r.move("character",1);r.select();}),0);})));}return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,"handleEnterKey");_118.addKeyHandler(13,0,0,h);_118.addKeyHandler(13,0,1,h);this.own(this.editor.on("KeyPressed",lang.hitch(this,"onKeyPressed")));}}},onKeyPressed:function(){if(this._checkListLater){if(win.withGlobal(this.editor.window,"isCollapsed",_117)){var _119=this.editor.selection.getAncestorElement("LI");if(!_119){_115.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var _11a=this.editor.selection.getAncestorElement(this.blockNodeForEnter);if(_11a){_11a.innerHTML=this.bogusHtmlContent;if(has("ie")<=9){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_119.parentNode.parentNode.nodeName=="LI"){_119=_119.parentNode.parentNode;}}var fc=_119.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_119.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _11b=_116.create(this.editor.window);_11b.setStart(_119.firstChild,0);var _11c=_116.getSelection(this.editor.window,true);_11c.removeAllRanges();_11c.addRange(_11b);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _11d,_11e,_11f,_120,_121,_122,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _123=this.editor.selection.getParentElement();var _124=_116.getAncestor(_123,this.blockNodes);if(_124){if(_124.tagName=="LI"){return true;}_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);if(!_11e.collapsed){_11e.deleteContents();_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);}if(_116.atBeginningOfContainer(_124,_11e.startContainer,_11e.startOffset)){br=doc.createElement("br");_11f=_116.create(this.editor.window);_124.insertBefore(br,_124.firstChild);_11f.setStartAfter(br);_11d.removeAllRanges();_11d.addRange(_11f);}else{if(_116.atEndOfContainer(_124,_11e.startContainer,_11e.startOffset)){_11f=_116.create(this.editor.window);br=doc.createElement("br");_124.appendChild(br);_124.appendChild(doc.createTextNode(" "));_11f.setStart(_124.lastChild,0);_11d.removeAllRanges();_11d.addRange(_11f);}else{rs=_11e.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;_120=doc.createTextNode(txt.substring(0,_11e.startOffset));_121=doc.createTextNode(txt.substring(_11e.startOffset));_122=doc.createElement("br");if(_121.nodeValue==""&&has("webkit")){_121=doc.createTextNode(" ");}_112.place(_120,rs,"after");_112.place(_122,_120,"after");_112.place(_121,_122,"after");_112.destroy(rs);_11f=_116.create(this.editor.window);_11f.setStart(_121,0);_11d.removeAllRanges();_11d.addRange(_11f);return false;}return true;}}}else{_11d=_116.getSelection(this.editor.window);if(_11d.rangeCount){_11e=_11d.getRangeAt(0);if(_11e&&_11e.startContainer){if(!_11e.collapsed){_11e.deleteContents();_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);}rs=_11e.startContainer;if(rs&&rs.nodeType==3){var _125=_11e.startOffset;if(rs.length<_125){ret=this._adjustNodeAndOffset(rs,_125);rs=ret.node;_125=ret.offset;}txt=rs.nodeValue;_120=doc.createTextNode(txt.substring(0,_125));_121=doc.createTextNode(txt.substring(_125));_122=doc.createElement("br");if(!_121.length){_121=doc.createTextNode(" ");}if(_120.length){_112.place(_120,rs,"after");}else{_120=rs;}_112.place(_122,_120,"after");_112.place(_121,_122,"after");_112.destroy(rs);_11f=_116.create(this.editor.window);_11f.setStart(_121,0);_11f.setEnd(_121,_121.length);_11d.removeAllRanges();_11d.addRange(_11f);this.editor.selection.collapse(true);}else{var _126;if(_11e.startOffset>=0){_126=rs.childNodes[_11e.startOffset];}var _122=doc.createElement("br");var _121=doc.createTextNode(" ");if(!_126){rs.appendChild(_122);rs.appendChild(_121);}else{_112.place(_122,_126,"before");_112.place(_121,_122,"after");}_11f=_116.create(this.editor.window);_11f.setStart(_121,0);_11f.setEnd(_121,_121.length);_11d.removeAllRanges();_11d.addRange(_11f);this.editor.selection.collapse(true);}}}else{_115.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _127=true;_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);if(!_11e.collapsed){_11e.deleteContents();_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);}var _128=_116.getBlockAncestor(_11e.endContainer,null,this.editor.editNode);var _129=_128.blockNode;if((this._checkListLater=(_129&&(_129.nodeName=="LI"||_129.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_129;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_129.innerHTML)){_129.innerHTML="";if(has("webkit")){_11f=_116.create(this.editor.window);_11f.setStart(_129,0);_11d.removeAllRanges();_11d.addRange(_11f);}this._checkListLater=false;}return true;}if(!_128.blockNode||_128.blockNode===this.editor.editNode){try{_115.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}_128={blockNode:this.editor.selection.getAncestorElement(this.blockNodeForEnter),blockContainer:this.editor.editNode};if(_128.blockNode){if(_128.blockNode!=this.editor.editNode&&(!(_128.blockNode.textContent||_128.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(_128.blockNode);return false;}}else{_128.blockNode=this.editor.editNode;}_11d=_116.getSelection(this.editor.window);_11e=_11d.getRangeAt(0);}var _12a=doc.createElement(this.blockNodeForEnter);_12a.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(_128.blockNode);var _12b=_11e.endOffset;var node=_11e.endContainer;if(node.length<_12b){var ret=this._adjustNodeAndOffset(node,_12b);node=ret.node;_12b=ret.offset;}if(_116.atEndOfContainer(_128.blockNode,node,_12b)){if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_112.place(_12a,_128.blockNode,"after");}_127=false;_11f=_116.create(this.editor.window);_11f.setStart(_12a,0);_11d.removeAllRanges();_11d.addRange(_11f);if(this.editor.height){_113.scrollIntoView(_12a);}}else{if(_116.atBeginningOfContainer(_128.blockNode,_11e.startContainer,_11e.startOffset)){_112.place(_12a,_128.blockNode,_128.blockNode===_128.blockContainer?"first":"before");if(_12a.nextSibling&&this.editor.height){_11f=_116.create(this.editor.window);_11f.setStart(_12a.nextSibling,0);_11d.removeAllRanges();_11d.addRange(_11f);_113.scrollIntoView(_12a.nextSibling);}_127=false;}else{if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_112.place(_12a,_128.blockNode,"after");}_127=false;if(_128.blockNode.style){if(_12a.style){if(_128.blockNode.style.cssText){_12a.style.cssText=_128.blockNode.style.cssText;}}}rs=_11e.startContainer;var _12c;if(rs&&rs.nodeType==3){var _12d,_12e;_12b=_11e.endOffset;if(rs.length<_12b){ret=this._adjustNodeAndOffset(rs,_12b);rs=ret.node;_12b=ret.offset;}txt=rs.nodeValue;_120=doc.createTextNode(txt.substring(0,_12b));_121=doc.createTextNode(txt.substring(_12b,txt.length));_112.place(_120,rs,"before");_112.place(_121,rs,"after");_112.destroy(rs);var _12f=_120.parentNode;while(_12f!==_128.blockNode){var tg=_12f.tagName;var _130=doc.createElement(tg);if(_12f.style){if(_130.style){if(_12f.style.cssText){_130.style.cssText=_12f.style.cssText;}}}if(_12f.tagName==="FONT"){if(_12f.color){_130.color=_12f.color;}if(_12f.face){_130.face=_12f.face;}if(_12f.size){_130.size=_12f.size;}}_12d=_121;while(_12d){_12e=_12d.nextSibling;_130.appendChild(_12d);_12d=_12e;}_112.place(_130,_12f,"after");_120=_12f;_121=_130;_12f=_12f.parentNode;}_12d=_121;if(_12d.nodeType==1||(_12d.nodeType==3&&_12d.nodeValue)){_12a.innerHTML="";}_12c=_12d;while(_12d){_12e=_12d.nextSibling;_12a.appendChild(_12d);_12d=_12e;}}_11f=_116.create(this.editor.window);var _131;var _132=_12c;if(this.blockNodeForEnter!=="BR"){while(_132){_131=_132;_12e=_132.firstChild;_132=_12e;}if(_131&&_131.parentNode){_12a=_131.parentNode;_11f.setStart(_12a,0);_11d.removeAllRanges();_11d.addRange(_11f);if(this.editor.height){_113.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}else{_127=true;}}else{_11f.setStart(_12a,0);_11d.removeAllRanges();_11d.addRange(_11f);if(this.editor.height){_113.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}}}return _127;},_adjustNodeAndOffset:function(node,_133){while(node.length<_133&&node.nextSibling&&node.nextSibling.nodeType==3){_133=_133-node.length;node=node.nextSibling;}return {"node":node,"offset":_133};},removeTrailingBr:function(_134){var para=/P|DIV|LI/i.test(_134.tagName)?_134:this.editor.selection.getParentOfType(_134,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_112.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_135,_136,dom,_137,_138,lang,_139,on,_13a,_13b,_13c,_13d,_13e,_13f,_140){return _136("dijit._MenuBase",[_13d,_140,_13f,_13e],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_138.toggle(this.domNode,"dijitMenuActive",val);_138.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _141=_13c.byNode(node);return node.parentNode==this.containerNode&&_141&&_141.focus;},postCreate:function(){var self=this,_142=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_142,_139.enter),function(){self.onItemHover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_139.leave),function(){self.onItemUnhover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_13b),function(evt){self.onItemClick(_13c.byNode(this),evt);evt.stopPropagation();evt.preventDefault();}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_143,_144){this.inherited(arguments);if(!!item&&(_144==-1||(!!item.popup&&_144==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_145){if(!!item.shortcutKey){return _145==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _146=this._getTopMenu();if(_146&&_146._isMenuBar){_146.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);var _147=/^key/.test(evt._origType||evt.type)||(evt.clientX==0&&evt.clientY==0);this._openItemPopup(item,_147);}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_148,_149){if(_148==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _14a=_148.popup;_14a.parentMenu=this;this.own(this._mouseoverHandle=on.once(_14a.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_148._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_149){self.focusChild(_148);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_149);this.currentPopupItem=_148;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_137.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_14b){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_14b){this.set("selected",null);}}});});},"dijit/tree/ForestStoreModel":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_14c,_14d,_14e,lang,_14f){return _14d("dijit.tree.ForestStoreModel",_14f,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_150){this.root={store:this,root:true,id:_150.rootId,label:_150.rootLabel,children:_150.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_151,_152,_153){if(_151===this.root){if(this.root.children){_152(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_154){this.root.children=_154;_152(_154);}),onError:_153});}}else{this.inherited(arguments);}},isItem:function(_155){return (_155===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_156){if(_156.identity==this.root.id){var _157=_156.scope||_14e.global;if(_156.onItem){_156.onItem.call(_157,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_158,_159){if(_158===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_15a,_15b,_15c,_15d,_15e){if(_15b===this.root){if(!_15d){this.onLeaveRoot(_15a);}}this.inherited(arguments,[_15a,_15b===this.root?null:_15b,_15c===this.root?null:_15c,_15d,_15e]);if(_15c===this.root){this.onAddToRoot(_15a);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _15f=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_160){this.root.children=_160;if(_15f.length!=_160.length||_14c.some(_15f,function(item,idx){return _160[idx]!=item;})){this.onChildrenChange(this.root,_160);}})});},onNewItem:function(item,_161){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_14c.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_162,_163,_164){this._requeryTop();this.inherited(arguments);}});});},"dijit/PopupMenuBarItem":function(){define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_165,_166,_167){var _168=_167._MenuBarItemMixin;return _165("dijit.PopupMenuBarItem",[_166,_168],{});});},"dijit/TitlePane":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager","./a11yclick"],function(_169,_16a,dom,_16b,_16c,_16d,_16e,has,_16f,keys,_170,_171,_172,_173,_174){var _175=_16a("dijit.TitlePane",[_172,_171,_170],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_174.defaultDuration,baseClass:"dijitTitlePane",templateString:_173,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.titleNode,false);},postCreate:function(){this.inherited(arguments);if(this.toggleable){this._trackMouseState(this.titleBarNode,this.baseClass+"Title");}var _176=this.hideNode,_177=this.wipeNode;this._wipeIn=_16e.wipeIn({node:_177,duration:this.duration,beforeBegin:function(){_176.style.display="";}});this._wipeOut=_16e.wipeOut({node:_177,duration:this.duration,onEnd:function(){_176.style.display="none";}});},_setOpenAttr:function(open,_178){_169.forEach([this._wipeIn,this._wipeOut],function(_179){if(_179&&_179.status()=="playing"){_179.stop();}});if(_178){var anim=this[open?"_wipeIn":"_wipeOut"];anim.play();}else{this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";}if(this._started){if(open){this._onShow();}else{this.onHide();}}this.containerNode.setAttribute("aria-hidden",open?"false":"true");this.focusNode.setAttribute("aria-pressed",open?"true":"false");this._set("open",open);this._setCss();},_setToggleableAttr:function(_17a){this.focusNode.setAttribute("role",_17a?"button":"heading");if(_17a){this.focusNode.setAttribute("aria-controls",this.id+"_pane");this.focusNode.setAttribute("tabIndex",this.tabIndex);this.focusNode.setAttribute("aria-pressed",this.open);}else{_16b.remove(this.focusNode,"aria-controls");_16b.remove(this.focusNode,"tabIndex");_16b.remove(this.focusNode,"aria-pressed");}this._set("toggleable",_17a);this._setCss();},_setContentAttr:function(_17b){if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){this.inherited(arguments);}else{if(this._wipeIn&&this._wipeIn.status()=="playing"){this._wipeIn.stop();}_16d.setMarginBox(this.wipeNode,{h:_16d.getMarginBox(this.wipeNode).h});this.inherited(arguments);if(this._wipeIn){this._wipeIn.play();}else{this.hideNode.style.display="";}}},toggle:function(){this._setOpenAttr(!this.open,true);},_setCss:function(){var node=this.titleBarNode||this.focusNode;var _17c=this._titleBarClass;this._titleBarClass=this.baseClass+"Title"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");_16c.replace(node,this._titleBarClass,_17c||"");_16c.replace(node,this._titleBarClass.replace("TitlePaneTitle",""),(_17c||"").replace("TitlePaneTitle",""));this.arrowNodeInner.innerHTML=this.open?"-":"+";},_onTitleKey:function(e){if(e.keyCode==keys.DOWN_ARROW&&this.open){this.containerNode.focus();e.preventDefault();}},_onTitleClick:function(){if(this.toggleable){this.toggle();}},setTitle:function(_17d){_16f.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");this.set("title",_17d);}});if(has("dojo-bidi")){_175.extend({_setTitleAttr:function(_17e){this._set("title",_17e);this.titleNode.innerHTML=_17e;this.applyTextDir(this.titleNode);},_setTooltipAttr:function(_17f){this._set("tooltip",_17f);if(this.textDir){_17f=this.enforceTextDirWithUcc(null,_17f);}_16b.set(this.focusNode,"title",_17f);},_setTextDirAttr:function(_180){if(this._created&&this.textDir!=_180){this._set("textDir",_180);this.set("title",this.title);this.set("tooltip",this.tooltip);}}});}return _175;});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_181,_182,_183,has,i18n){var _184=_182("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_185){this._set("value",_185);this.onChange(_185);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_186){var _187=this._createMenuItem();var _188=_186(item);if(_188.html){_187.innerHTML=_188.label;}else{_187.appendChild(_187.ownerDocument.createTextNode(_188.label));}if(_187.innerHTML==""){_187.innerHTML="&#160;";}return _187;},createOptions:function(_189,_18a,_18b){this.items=_189;this.previousButton.style.display=(_18a.start==0)?"none":"";_183.set(this.previousButton,"id",this.id+"_prev");_181.forEach(_189,function(item,i){var _18c=this._createOption(item,_18b);_18c.setAttribute("item",i);_183.set(_18c,"id",this.id+i);this.nextButton.parentNode.insertBefore(_18c,this.nextButton);},this);var _18d=false;if(_189.total&&!_189.total.then&&_189.total!=-1){if((_18a.start+_18a.count)<_189.total){_18d=true;}else{if((_18a.start+_18a.count)>_189.total&&_18a.count==_189.length){_18d=true;}}}else{if(_18a.count==_189.length){_18d=true;}}this.nextButton.style.display=_18d?"":"none";_183.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _18e=this.containerNode;while(_18e.childNodes.length>2){_18e.removeChild(_18e.childNodes[_18e.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_184=_182("dijit.form._ComboBoxMenuMixin",_184,{_createOption:function(){var _18f=this.inherited(arguments);this.applyTextDir(_18f);return _18f;}});}return _184;});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_190,keys,lang,_191,_192,when,_193){return _190("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_194){return new RegExp("^"+_194.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_195,star,_196){return star?".*":_196?".":_195?_195:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;if("type" in evt&&evt.type.substring(0,3)=="key"&&(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT)){return;}var _197=false;this._prev_key_backspace=false;switch(key){case keys.DELETE:case keys.BACKSPACE:this._prev_key_backspace=true;this._maskValidSubsetError=true;_197=true;break;default:_197=typeof key=="string"||key==229;}if(_197){if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value);},_startSearch:function(text){this._abortQuery();var _198=this,_191=lang.clone(this.query),_199={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_192.substitute(this.queryExpr,[text.replace(/([\\\*\?])/g,"\\$1")]),q,_19a=function(){var _19b=_198._fetchHandle=_198.store.query(_191,_199);if(_198.disabled||_198.readOnly||(q!==_198._lastQuery)){return;}when(_19b,function(res){_198._fetchHandle=null;if(!_198.disabled&&!_198.readOnly&&(q===_198._lastQuery)){when(_19b.total,function(_19c){res.total=_19c;var _19d=_198.pageSize;if(isNaN(_19d)||_19d>res.total){_19d=res.total;}res.nextPage=function(_19e){_199.direction=_19e=_19e!==false;_199.count=_19d;if(_19e){_199.start+=res.length;if(_199.start>=res.total){_199.count=0;}}else{_199.start-=_19d;if(_199.start<0){_199.count=Math.max(_19d+_199.start,0);_199.start=0;}}if(_199.count<=0){res.length=0;_198.onSearch(res,_191,_199);}else{_19a();}};_198.onSearch(res,_191,_199);});}},function(err){_198._fetchHandle=null;if(!_198._cancelingQuery){console.error(_198.declaredClass+" "+err.toString());}});};lang.mixin(_199,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_191[this.searchAttr]=q;this._queryDeferHandle=this.defer(_19a,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_193.byId(list);}}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_19f,_1a0,_1a1,_1a2){return _19f("dijit.form.ToggleButton",[_1a1,_1a2],{baseClass:"dijitToggleButton",setChecked:function(_1a3){_1a0.deprecated("setChecked("+_1a3+") is deprecated. Use set('checked',"+_1a3+") instead.","","2.0");this.set("checked",_1a3);}});});},"dijit/form/NumberSpinner":function(){define(["dojo/_base/declare","dojo/keys","./_Spinner","./NumberTextBox"],function(_1a4,keys,_1a5,_1a6){return _1a4("dijit.form.NumberSpinner",[_1a5,_1a6.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,_1a7){var tc=this.constraints,v=isNaN(val),_1a8=!isNaN(tc.max),_1a9=!isNaN(tc.min);if(v&&_1a7!=0){val=(_1a7>0)?_1a9?tc.min:_1a8?tc.max:0:_1a8?this.constraints.max:_1a9?tc.min:0;}var _1aa=val+_1a7;if(v||isNaN(_1aa)){return val;}if(_1a8&&(_1aa>tc.max)){_1aa=tc.max;}if(_1a9&&(_1aa<tc.min)){_1aa=tc.min;}return _1aa;},_onKeyDown:function(e){if(this.disabled||this.readOnly){return;}if((e.keyCode==keys.HOME||e.keyCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){var _1ab=this.constraints[(e.keyCode==keys.HOME?"min":"max")];if(typeof _1ab=="number"){this._setValueAttr(_1ab,false);}e.stopPropagation();e.preventDefault();}}});});},"dijit/form/Textarea":function(){define(["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_1ac,_1ad,_1ae,_1af){return _1ac("dijit.form.Textarea",[_1af,_1ae],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){this.inherited(arguments);_1ad.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});}});});},"dijit/form/DateTextBox":function(){define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_1b0,_1b1,_1b2){return _1b0("dijit.form.DateTextBox",_1b2,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_1b1,_selector:"date",maxHeight:Infinity,value:new Date("")});});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_1b3,_1b4,_1b5,fx,dom,_1b6,_1b7,_1b8,_1b9,keys,lang,has,_1ba,_1bb,_1bc,_1bd,_1be,_1bf,_1c0,_1c1,_1c2,_1c3,_1c4){var _1c5=_1b5("dijit.layout._AccordionButton",[_1be,_1c0,_1c1],{templateString:_1c4,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _1c6=this.id.replace(" ","_");_1b6.set(this.titleTextNode,"id",_1c6+"_title");this.focusNode.setAttribute("aria-labelledby",_1b6.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _1b9.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _1c7=this.getParent();_1c7.selectChild(this.contentWidget,true);_1bb.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_1c8){this._set("selected",_1c8);this.focusNode.setAttribute("aria-expanded",_1c8?"true":"false");this.focusNode.setAttribute("aria-selected",_1c8?"true":"false");this.focusNode.setAttribute("tabIndex",_1c8?"0":"-1");}});if(has("dojo-bidi")){_1c5.extend({_setLabelAttr:function(_1c9){this._set("label",_1c9);_1b6.set(this.titleTextNode,"innerHTML",_1c9);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_1ca){this._set("title",_1ca);_1b6.set(this.titleTextNode,"title",_1ca);this.applyTextDir(this.titleTextNode);}});}var _1cb=_1b5("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_1be,_1c1],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_1b8.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _1cc=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_1cc._buttonWidget=(new cls({contentWidget:_1cc,label:_1cc.title,title:_1cc.tooltip,dir:_1cc.dir,lang:_1cc.lang,textDir:_1cc.textDir||this.textDir,iconClass:_1cc.iconClass,id:_1cc.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_1b8.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_1b8.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _1cd=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_1ce,_1cf){_1cd.set("label",_1cf);})),cw.watch("tooltip",lang.hitch(this,function(name,_1d0,_1d1){_1cd.set("title",_1d1);})),cw.watch("iconClass",lang.hitch(this,function(name,_1d2,_1d3){_1cd.set("iconClass",_1d3);}))];},_setSelectedAttr:function(_1d4){this._set("selected",_1d4);this.button.set("selected",_1d4);if(_1d4){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_1b4.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_1d5){this.contentWidget.destroyRecursive(_1d5);}});if(has("dojo-bidi")){_1cb=_1b5("dijit.layout._AccordionInnerContainer",_1cb,{postCreate:function(){this.inherited(arguments);var _1d6=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_1d7,_1d8){_1d6.set("textDir",_1d8);}));}});}var _1d9=_1b5("dijit.layout.AccordionContainer",_1c2,{duration:_1bc.defaultDuration,buttonWidget:_1c5,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _1da=this.selectedChildWidget;if(!_1da){return;}var _1db=_1da._wrapperWidget.domNode,_1dc=_1b9.getMarginExtents(_1db),_1dd=_1b9.getPadBorderExtents(_1db),_1de=_1da._wrapperWidget.containerNode,_1df=_1b9.getMarginExtents(_1de),_1e0=_1b9.getPadBorderExtents(_1de),_1e1=this._contentBox;var _1e2=0;_1b4.forEach(this.getChildren(),function(_1e3){if(_1e3!=_1da){_1e2+=_1b9.getMarginSize(_1e3._wrapperWidget.domNode).h;}});this._verticalSpace=_1e1.h-_1e2-_1dc.h-_1dd.h-_1df.h-_1e0.h-_1da._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_1dc.w-_1dd.w-_1df.w-_1e0.w};if(_1da){_1da.resize(this._containerContentBox);}},_setupChild:function(_1e4){_1e4._wrapperWidget=_1cb({contentWidget:_1e4,buttonWidget:this.buttonWidget,id:_1e4.id+"_wrapper",dir:_1e4.dir,lang:_1e4.lang,textDir:_1e4.textDir||this.textDir,parent:this});this.inherited(arguments);_1b8.place(_1e4.domNode,_1e4._wrapper,"replace");},removeChild:function(_1e5){if(_1e5._wrapperWidget){_1b8.place(_1e5.domNode,_1e5._wrapperWidget.domNode,"after");_1e5._wrapperWidget.destroy();delete _1e5._wrapperWidget;}_1b7.remove(_1e5.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _1b4.map(this.inherited(arguments),function(_1e6){return _1e6.declaredClass=="dijit.layout._AccordionInnerContainer"?_1e6.contentWidget:_1e6;},this);},destroy:function(){if(this._animation){this._animation.stop();}_1b4.forEach(this.getChildren(),function(_1e7){if(_1e7._wrapperWidget){_1e7._wrapperWidget.destroy();}else{_1e7.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_1e8){_1e8._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_1e9){_1e9._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_1ea,_1eb,_1ec){if(has("ie")<8){_1ec=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_1ea){_1ea._wrapperWidget.set("selected",true);var d=this._showChild(_1ea);if(this.doLayout&&_1ea.resize){_1ea.resize(this._containerContentBox);}}if(_1eb){_1eb._wrapperWidget.set("selected",false);if(!_1ec){this._hideChild(_1eb);}}if(_1ec){var _1ed=_1ea._wrapperWidget.containerNode,_1ee=_1eb._wrapperWidget.containerNode;var _1ef=_1ea._wrapperWidget.containerNode,_1f0=_1b9.getMarginExtents(_1ef),_1f1=_1b9.getPadBorderExtents(_1ef),_1f2=_1f0.h+_1f1.h;_1ee.style.height=(self._verticalSpace-_1f2)+"px";this._animation=new fx.Animation({node:_1ed,duration:this.duration,curve:[1,this._verticalSpace-_1f2-1],onAnimate:function(_1f3){_1f3=Math.floor(_1f3);_1ed.style.height=_1f3+"px";_1ee.style.height=(self._verticalSpace-_1f2-_1f3)+"px";},onEnd:function(){delete self._animation;_1ed.style.height="auto";_1eb._wrapperWidget.containerNode.style.display="none";_1ee.style.height="auto";self._hideChild(_1eb);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_1f4){if(this.disabled||e.altKey||!(_1f4||e.ctrlKey)){return;}var c=e.keyCode;if((_1f4&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_1f4&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_1bd(0,function(){var _1f5=["dijit/layout/AccordionPane"];_1b3(_1f5);});}_1d9._InnerContainer=_1cb;_1d9._Button=_1c5;return _1d9;});},"dijit/form/ComboButton":function(){define(["dojo/_base/declare","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_1f6,keys,_1f7,_1f8,_1f9){return _1f6("dijit.form.ComboButton",_1f8,{templateString:_1f9,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_1f7.focus(this._popupStateNode);evt.stopPropagation();evt.preventDefault();}},_onArrowKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_1f7.focus(this.titleNode);evt.stopPropagation();evt.preventDefault();}},focus:function(_1fa){if(!this.disabled){_1f7.focus(_1fa=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/layout/SplitContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","../registry","../_WidgetBase","./_LayoutWidget"],function(_1fb,_1fc,_1fd,dom,_1fe,_1ff,_200,_201,_202,_203,lang,on,has,_204,_205,_206){var _207=_1fd("dijit.layout.SplitContainer",_206,{constructor:function(){_203.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){this.inherited("postMixInProperties",arguments);this.isHorizontal=(this.orientation=="horizontal");},postCreate:function(){this.inherited(arguments);this.sizers=[];if(has("mozilla")){this.domNode.style.overflow="-moz-scrollbars-none";}if(typeof this.sizerWidth=="object"){try{this.sizerWidth=parseInt(this.sizerWidth.toString());}catch(e){this.sizerWidth=7;}}var _208=this.ownerDocument.createElement("div");this.virtualSizer=_208;_208.style.position="relative";_208.style.zIndex=10;_208.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";this.domNode.appendChild(_208);dom.setSelectable(_208,false);},destroy:function(){delete this.virtualSizer;if(this._ownconnects){var h;while(h=this._ownconnects.pop()){h.remove();}}this.inherited(arguments);},startup:function(){if(this._started){return;}_1fb.forEach(this.getChildren(),function(_209,i,_20a){this._setupChild(_209);if(i<_20a.length-1){this._addSizer();}},this);if(this.persist){this._restoreState();}this.inherited(arguments);},_setupChild:function(_20b){this.inherited(arguments);_20b.domNode.style.position="absolute";_1fe.add(_20b.domNode,"dijitSplitPane");},_onSizerMouseDown:function(e){if(e.target.id){for(var i=0;i<this.sizers.length;i++){if(this.sizers[i].id==e.target.id){break;}}if(i<this.sizers.length){this.beginSizing(e,i);}}},_addSizer:function(_20c){_20c=_20c===undefined?this.sizers.length:_20c;var _20d=this.ownerDocument.createElement("div");_20d.id=_204.getUniqueId("dijit_layout_SplitterContainer_Splitter");this.sizers.splice(_20c,0,_20d);this.domNode.appendChild(_20d);_20d.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";var _20e=this.ownerDocument.createElement("div");_20e.className="thumb";_20d.appendChild(_20e);this.connect(_20d,"onmousedown","_onSizerMouseDown");dom.setSelectable(_20d,false);},removeChild:function(_20f){if(this.sizers.length){var i=_1fb.indexOf(this.getChildren(),_20f);if(i!=-1){if(i==this.sizers.length){i--;}_1ff.destroy(this.sizers[i]);this.sizers.splice(i,1);}}this.inherited(arguments);if(this._started){this.layout();}},addChild:function(_210,_211){if(typeof _211=="undefined"||_211=="last"){_211=this.getChildren().length;}this.inherited(arguments,[_210,_211]);if(this._started){var _212=this.getChildren();if(_212.length>1){this._addSizer(_211);}this.layout();}},layout:function(){this.paneWidth=this._contentBox.w;this.paneHeight=this._contentBox.h;var _213=this.getChildren();if(!_213.length){return;}var _214=this.isHorizontal?this.paneWidth:this.paneHeight;if(_213.length>1){_214-=this.sizerWidth*(_213.length-1);}var _215=0;_1fb.forEach(_213,function(_216){_215+=_216.sizeShare;});var _217=_214/_215;var _218=0;_1fb.forEach(_213.slice(0,_213.length-1),function(_219){var size=Math.round(_217*_219.sizeShare);_219.sizeActual=size;_218+=size;});_213[_213.length-1].sizeActual=_214-_218;this._checkSizes();var pos=0;var size=_213[0].sizeActual;this._movePanel(_213[0],pos,size);_213[0].position=pos;pos+=size;if(!this.sizers){return;}_1fb.some(_213.slice(1),function(_21a,i){if(!this.sizers[i]){return true;}this._moveSlider(this.sizers[i],pos,this.sizerWidth);this.sizers[i].position=pos;pos+=this.sizerWidth;size=_21a.sizeActual;this._movePanel(_21a,pos,size);_21a.position=pos;pos+=size;},this);},_movePanel:function(_21b,pos,size){var box;if(this.isHorizontal){_21b.domNode.style.left=pos+"px";_21b.domNode.style.top=0;box={w:size,h:this.paneHeight};if(_21b.resize){_21b.resize(box);}else{_200.setMarginBox(_21b.domNode,box);}}else{_21b.domNode.style.left=0;_21b.domNode.style.top=pos+"px";box={w:this.paneWidth,h:size};if(_21b.resize){_21b.resize(box);}else{_200.setMarginBox(_21b.domNode,box);}}},_moveSlider:function(_21c,pos,size){if(this.isHorizontal){_21c.style.left=pos+"px";_21c.style.top=0;_200.setMarginBox(_21c,{w:size,h:this.paneHeight});}else{_21c.style.left=0;_21c.style.top=pos+"px";_200.setMarginBox(_21c,{w:this.paneWidth,h:size});}},_growPane:function(_21d,pane){if(_21d>0){if(pane.sizeActual>pane.sizeMin){if((pane.sizeActual-pane.sizeMin)>_21d){pane.sizeActual=pane.sizeActual-_21d;_21d=0;}else{_21d-=pane.sizeActual-pane.sizeMin;pane.sizeActual=pane.sizeMin;}}}return _21d;},_checkSizes:function(){var _21e=0;var _21f=0;var _220=this.getChildren();_1fb.forEach(_220,function(_221){_21f+=_221.sizeActual;_21e+=_221.sizeMin;});if(_21e<=_21f){var _222=0;_1fb.forEach(_220,function(_223){if(_223.sizeActual<_223.sizeMin){_222+=_223.sizeMin-_223.sizeActual;_223.sizeActual=_223.sizeMin;}});if(_222>0){var list=this.isDraggingLeft?_220.reverse():_220;_1fb.forEach(list,function(_224){_222=this._growPane(_222,_224);},this);}}else{_1fb.forEach(_220,function(_225){_225.sizeActual=Math.round(_21f*(_225.sizeMin/_21e));});}},beginSizing:function(e,i){var _226=this.getChildren();this.paneBefore=_226[i];this.paneAfter=_226[i+1];this.paneBefore.sizeBeforeDrag=this.paneBefore.sizeActual;this.paneAfter.sizeBeforeDrag=this.paneAfter.sizeActual;this.paneAfter.positionBeforeDrag=this.paneAfter.position;this.isSizing=true;this.sizingSplitter=this.sizers[i];this.sizingSplitter.positionBeforeDrag=_201.get(this.sizingSplitter,(this.isHorizontal?"left":"top"));if(!this.cover){this.cover=_1ff.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);}else{this.cover.style.zIndex=5;}this.sizingSplitter.style.zIndex=6;this.startPoint=this.lastPoint=(this.isHorizontal?e.pageX:e.pageY);this.maxDelta=this.paneAfter.sizeActual-this.paneAfter.sizeMin;this.minDelta=-1*(this.paneBefore.sizeActual-this.paneBefore.sizeMin);if(!this.activeSizing){this._showSizingLine();}this._ownconnects=[on(this.ownerDocument.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(this.ownerDocument.documentElement,"mouseup",lang.hitch(this,"endSizing"))];_202.stop(e);},changeSizing:function(e){if(!this.isSizing){return;}this.lastPoint=this.isHorizontal?e.pageX:e.pageY;var _227=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);if(this.activeSizing){this._updateSize(_227);}else{this._moveSizingLine(_227);}_202.stop(e);},endSizing:function(){if(!this.isSizing){return;}if(this.cover){this.cover.style.zIndex=-1;}if(!this.activeSizing){this._hideSizingLine();}var _228=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);this._updateSize(_228);this.isSizing=false;if(this.persist){this._saveState(this);}var h;while(h=this._ownconnects.pop()){h.remove();}},_updateSize:function(_229){this.paneBefore.sizeActual=this.paneBefore.sizeBeforeDrag+_229;this.paneAfter.position=this.paneAfter.positionBeforeDrag+_229;this.paneAfter.sizeActual=this.paneAfter.sizeBeforeDrag-_229;_1fb.forEach(this.getChildren(),function(_22a){_22a.sizeShare=_22a.sizeActual;});if(this._started){this.layout();}},_showSizingLine:function(){this._moveSizingLine(0);_200.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});this.virtualSizer.style.display="block";},_hideSizingLine:function(){this.virtualSizer.style.display="none";},_moveSizingLine:function(_22b){var pos=_22b+this.sizingSplitter.positionBeforeDrag;_201.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");},_getCookieName:function(i){return this.id+"_"+i;},_restoreState:function(){_1fb.forEach(this.getChildren(),function(_22c,i){var _22d=this._getCookieName(i);var _22e=_1fc(_22d);if(_22e){var pos=parseInt(_22e);if(typeof pos=="number"){_22c.sizeShare=pos;}}},this);},_saveState:function(){if(!this.persist){return;}_1fb.forEach(this.getChildren(),function(_22f,i){_1fc(this._getCookieName(i),_22f.sizeShare,{expires:365});},this);}});_207.ChildWidgetProperties={sizeMin:10,sizeShare:10};lang.extend(_205,_207.ChildWidgetProperties);return _207;});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_230,_231,_232,keys,lang,_233,_234,has,_235,_236,_237){var _238=_231("dijit.form._AutoCompleterMixin",_237,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_239){var pos=0;if(typeof (_239.selectionStart)=="number"){pos=_239.selectionStart;}else{if(has("ie")){var tr=_239.ownerDocument.selection.createRange().duplicate();var ntr=_239.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_23a,_23b){_23b=parseInt(_23b);_236.selectInputText(_23a,_23b,_23b);},_setDisabledAttr:function(_23c){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_23c?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _23d=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_23d=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_23d);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_23d){if(_23d==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_23d==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _23e=this.get("displayedValue");if(pw&&(_23e==pw._messages["previousMessage"]||_23e==pw._messages["nextMessage"])){break;}if(_23d){this._selectOption(_23d);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_236.selectInputText(fn,fn.value.length);var _23f=this.ignoreCase?"toLowerCase":"substr";if(text[_23f](0).indexOf(this.focusNode.value[_23f](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_236.selectInputText(fn,cpos);}}else{fn.value=text;_236.selectInputText(fn);}},_openResultList:function(_240,_241,_242){var _243=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_240.length&&_242.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_244){_240.nextPage(_244!==-1);this.focus();});this.dropDown.createOptions(_240,_242,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _242){if(_242.direction){this.dropDown.highlightFirstOption();}else{if(!_242.direction){this.dropDown.highlightLastOption();}}if(_243){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_241[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _245=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_245==pw._messages["previousMessage"]||_245==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_245);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_246,_247){var _248="";if(item){if(!_247){_247=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_248=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_247;}this.set("value",_248,_246,_247,item);},_announceOption:function(node){if(!node){return;}var _249;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_249=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_249=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_249);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_232.get(node,"id"));this._autoCompleteText(_249);},_selectOption:function(_24a){this.closeDropDown();if(_24a){this._announceOption(_24a);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _24b=this.id+"_popup",_24c=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _24c({onChange:lang.hitch(this,this._selectOption),id:_24b,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store){var _24d=this.srcNodeRef;this.store=new _235({},_24d);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _24e=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_24e):item[_24e];}}}},postCreate:function(){var _24f=_233("label[for=\""+this.id+"\"]");if(_24f.length){if(!_24f[0].id){_24f[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_24f[0].id);}this.inherited(arguments);_230.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _250=this.labelFunc(item,this.store),_251=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_250=this.doHighlight(_250,this._lastInput);_251="html";}return {html:_251=="html",label:_250};},doHighlight:function(_252,find){var _253=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_234.escapeString(find);return this._escapeHtml(_252.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_253),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_254){return (_254._oldAPI?_254.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_255,_256,_257,item){this._set("item",item||null);if(_255==null){_255="";}this.inherited(arguments);}});if(has("dojo-bidi")){_238.extend({_setTextDirAttr:function(_258){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_258);}}});}return _238;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_259,has,_25a,_25b){return _259("dijit.form.MappedTextBox",_25b,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_25a.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_25c,_25d,_25e,lang,_25f,_260,_261,_262,_263){return _25c("dijit.form.ComboBoxMixin",[_262,_260],{dropDownClass:_261,hasDownArrow:true,templateString:_263,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_264){if(!_264.get){lang.mixin(_264,{_oldAPI:true,get:function(id){var _265=new _25d();this.fetchItemByIdentity({identity:id,onItem:function(_266){_265.resolve(_266);},onError:function(_267){_265.reject(_267);}});return _265.promise;},query:function(_268,_269){var _26a=new _25d(function(){_26b.abort&&_26b.abort();});_26a.total=new _25d();var _26b=this.fetch(lang.mixin({query:_268,onBegin:function(_26c){_26a.total.resolve(_26c);},onComplete:function(_26d){_26a.resolve(_26d);},onError:function(_26e){_26a.reject(_26e);}},_269));return _25f(_26a);}});}this._set("store",_264);},postMixInProperties:function(){var _26f=this.params.store||this.store;if(_26f){this._setStoreAttr(_26f);}this.inherited(arguments);if(!this.params.store&&!this.store._oldAPI){var _270=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_25e.deprecated(_270+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_25e.deprecated(_270+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_25e.deprecated(_270+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_271){new _271({objectStore:this}).fetch(args);}));}});}}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_272,_273,dom,has,keys,lang,on,_274){var _275=_273("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_276,_277,_278){var _279;if(_276!==undefined){_279=this.filter(_276);if(typeof _278!="string"){if(_279!==null&&((typeof _279!="number")||!isNaN(_279))){_278=this.filter(this.format(_279,this.constraints));}else{_278="";}}}if(_278!=null&&((typeof _278)!="number"||!isNaN(_278))&&this.textbox.value!=_278){this.textbox.value=_278;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_279,_277]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_27a){if(_27a==null){_27a="";}else{if(typeof _27a!="string"){_27a=String(_27a);}}this.textbox.value=_27a;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_27b){return _27b==null?"":(_27b.toString?_27b.toString():_27b);},parse:function(_27c){return _27c;},_refreshState:function(){},onInput:function(){},__skipInputEvent:false,_onInput:function(evt){this._processInput(evt);if(this.intermediateChanges){this.defer(function(){this._handleOnChange(this.get("value"),false);});}},_processInput:function(evt){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);var _27d=function(e){var _27e;if(e.type=="keydown"){_27e=e.keyCode;switch(_27e){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_27e){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_27e>=65&&_27e<=90)||(_27e>=48&&_27e<=57)||_27e==keys.SPACE){return;}var _27f=false;for(var i in keys){if(keys[i]===e.keyCode){_27f=true;break;}}if(!_27f){return;}}}_27e=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_27e){_27e=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_27e){_27e=229;}if(e.type=="keypress"){if(typeof _27e!="string"){return;}if((_27e>="a"&&_27e<="z")||(_27e>="A"&&_27e<="Z")||(_27e>="0"&&_27e<="9")||(_27e===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}if(e.type=="input"){if(this.__skipInputEvent){this.__skipInputEvent=false;return;}}else{this.__skipInputEvent=true;}var faux={faux:true},attr;for(attr in e){if(attr!="layerX"&&attr!="layerY"){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_27e,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}this.defer(function(){this._onInput(faux);});if(e.type=="keypress"){e.stopPropagation();}};this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_27d)));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_275.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_275=_273("dijit.form._TextBoxMixin",_275,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_275._setSelectionRange=_274._setSelectionRange=function(_280,_281,stop){if(_280.setSelectionRange){_280.setSelectionRange(_281,stop);}};_275.selectInputText=_274.selectInputText=function(_282,_283,stop){_282=dom.byId(_282);if(isNaN(_283)){_283=0;}if(isNaN(stop)){stop=_282.value?_282.value.length:0;}try{_282.focus();_275._setSelectionRange(_282,_283,stop);}catch(e){}};return _275;});},"dijit/form/SimpleTextarea":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_284,_285,has,_286){return _284("dijit.form.SimpleTextarea",_286,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_285.add(this.textbox,"dijitTextAreaCols");}},filter:function(_287){if(_287){_287=_287.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _288=parseInt(this.maxLength);var _289=this.textbox.value.replace(/\r/g,"");var _28a=_289.length-_288;if(_28a>0){var _28b=this.textbox;if(_28b.selectionStart){var pos=_28b.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_289.substring(0,pos-_28a-cr)+_289.substring(pos-cr);_28b.setSelectionRange(pos-_28a,pos-_28a);}else{if(this.ownerDocument.selection){_28b.focus();var _28c=this.ownerDocument.selection.createRange();_28c.moveStart("character",-_28a);_28c.text="";_28c.select();}}}}this.inherited(arguments);}});});},"dijit/PopupMenuItem":function(){define(["dojo/_base/declare","dojo/dom-style","dojo/_base/lang","dojo/query","./popup","./registry","./MenuItem","./hccss"],function(_28d,_28e,lang,_28f,pm,_290,_291){return _28d("dijit.PopupMenuItem",_291,{_fillContent:function(){if(this.srcNodeRef){var _292=_28f("*",this.srcNodeRef);this.inherited(arguments,[_292[0]]);this.dropDownContainer=this.srcNodeRef;}},_openPopup:function(_293,_294){var _295=this.popup;pm.open(lang.delegate(_293,{popup:this.popup,around:this.domNode}));if(_294&&_295.focus){_295.focus();}},_closePopup:function(){pm.close(this.popup);this.popup.parentMenu=null;},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=_28f("[widgetId]",this.dropDownContainer)[0];this.popup=_290.byNode(node);}this.ownerDocumentBody.appendChild(this.popup.domNode);this.popup.domNode.setAttribute("aria-labelledby",this.containerNode.id);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_28e.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_296){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_296);}delete this.popup;}this.inherited(arguments);}});});},"dijit/_TimePicker":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","dojo/on","./_WidgetBase","./form/_ListMouseMixin"],function(_297,_298,_299,_29a,_29b,_29c,_29d,_29e,keys,lang,has,_29f,_2a0,on,_2a1,_2a2){var _2a3=_29b("dijit._TimePicker",[_2a1,_2a2],{baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_29a.toISOString,buildRendering:function(){this.inherited(arguments);this.containerNode=this.domNode;this.timeMenu=this.domNode;},setValue:function(_2a4){_29e.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_2a4);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_2a5,_2a6,_2a7,_2a8){var _2a9=[];for(var i=0;i<this._maxIncrement;i++){var n=this._createOption(i);if(n){_2a9.push(n);}}return _2a9;},_showText:function(){var _2aa=_29a.fromISOString;this.domNode.innerHTML="";this._clickableIncrementDate=_2aa(this.clickableIncrement);this._visibleIncrementDate=_2aa(this.visibleIncrement);var _2ab=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_2ac=_2ab(this._clickableIncrementDate),_2ad=_2ab(this._visibleIncrementDate),time=(this.value||this.currentFocus).getTime();this._refDate=_2aa("T00:00:00");this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._visibleIncrement=_2ad/_2ac;this._maxIncrement=(60*60*24)/_2ac;var _2ae=this._getFilteredNodes();_297.forEach(_2ae,function(n){this.domNode.appendChild(n);},this);if(!_2ae.length&&this.filterString){this.filterString="";this._showText();}},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_2af){for(var key in {clickableIncrement:1,visibleIncrement:1}){if(key in _2af){this[key]=_2af[key];}}if(!_2af.locale){_2af.locale=this.lang;}},_createOption:function(_2b0){var date=new Date(this._refDate);var _2b1=this._clickableIncrementDate;date.setHours(date.getHours()+_2b1.getHours()*_2b0,date.getMinutes()+_2b1.getMinutes()*_2b0,date.getSeconds()+_2b1.getSeconds()*_2b0);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _2b2=_299.format(date,this.constraints);if(this.filterString&&_2b2.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=this.ownerDocument.createElement("div");div.className=this.baseClass+"Item";div.date=date;div.idx=_2b0;_29d.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_2b2},div);if(_2b0%this._visibleIncrement<1&&_2b0%this._visibleIncrement>-1){_29c.add(div,this.baseClass+"Marker");}else{if(!(_2b0%this._clickableIncrement)){_29c.add(div,this.baseClass+"Tick");}}if(this.isDisabledDate(date)){_29c.add(div,this.baseClass+"ItemDisabled");}if(this.value&&!_298.compare(this.value,date,this.constraints.selector)){div.selected=true;_29c.add(div,this.baseClass+"ItemSelected");this._selectedDiv=div;if(_29c.contains(div,this.baseClass+"Marker")){_29c.add(div,this.baseClass+"MarkerSelected");}else{_29c.add(div,this.baseClass+"TickSelected");}this._highlightOption(div,true);}return div;},onOpen:function(){this.inherited(arguments);this.set("selected",this._selectedDiv);},_onOptionSelected:function(tgt){var _2b3=tgt.target.date||tgt.target.parentNode.date;if(!_2b3||this.isDisabledDate(_2b3)){return;}this._highlighted_option=null;this.set("value",_2b3);this.onChange(_2b3);},onChange:function(){},_highlightOption:function(node,_2b4){if(!node){return;}if(_2b4){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_29c.toggle(node,this.baseClass+"ItemHover",_2b4);if(_29c.contains(node,this.baseClass+"Marker")){_29c.toggle(node,this.baseClass+"MarkerHover",_2b4);}else{_29c.toggle(node,this.baseClass+"TickHover",_2b4);}},handleKey:function(e){if(e.keyCode==keys.DOWN_ARROW){this.selectNextNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.UP_ARROW){this.selectPreviousNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){if(!this._keyboardSelected&&e.keyCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option});}return e.keyCode===keys.TAB;}}}return undefined;},onHover:function(node){this._highlightOption(node,true);},onUnhover:function(node){this._highlightOption(node,false);},onSelect:function(node){this._highlightOption(node,true);},onDeselect:function(node){this._highlightOption(node,false);},onClick:function(node){this._onOptionSelected({target:node});}});return _2a3;});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_2b5,_2b6,_2b7){return _2b5("dijit.form.RadioButton",[_2b6,_2b7],{baseClass:"dijitRadio"});});},"dijit/InlineEditBox":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/when","./a11yclick","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be,_2bf,i18n,_2c0,keys,lang,on,has,when,_2c1,fm,_2c2,_2c3,_2c4,_2c5,_2c6,_2c7,_2c8,_2c9){var _2ca=_2bb("dijit._InlineEditor",[_2c2,_2c3,_2c4],{templateString:_2c9,contextRequire:_2b8,postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit","common",this.lang);_2b9.forEach(["buttonSave","buttonCancel"],function(prop){if(!this[prop]){this[prop]=this.messages[prop];}},this);},buildRendering:function(){this.inherited(arguments);var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_2b8(this.editor)):this.editor;var _2cb=this.sourceStyle,_2cc="line-height:"+_2cb.lineHeight+";",_2cd=_2bf.getComputedStyle(this.domNode);_2b9.forEach(["Weight","Family","Size","Style"],function(prop){var _2ce=_2cb["font"+prop],_2cf=_2cd["font"+prop];if(_2cf!=_2ce){_2cc+="font-"+prop+":"+_2cb["font"+prop]+";";}},this);_2b9.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){this.domNode.style[prop]=_2cb[prop];},this);var _2d0=this.inlineEditBox.width;if(_2d0=="100%"){_2cc+="width:100%;";this.domNode.style.display="block";}else{_2cc+="width:"+(_2d0+(Number(_2d0)==_2d0?"px":""))+";";}var _2d1=lang.delegate(this.inlineEditBox.editorParams,{style:_2cc,dir:this.dir,lang:this.lang,textDir:this.textDir});this.editWidget=new Cls(_2d1,this.editorPlaceholder);if(this.inlineEditBox.autoSave){_2be.destroy(this.buttonContainer);}},postCreate:function(){this.inherited(arguments);var ew=this.editWidget;if(this.inlineEditBox.autoSave){this.own(_2ba.after(ew,"onChange",lang.hitch(this,"_onChange"),true),on(ew,"keydown",lang.hitch(this,"_onKeyDown")));}else{if("intermediateChanges" in ew){ew.set("intermediateChanges",true);this.own(_2ba.after(ew,"onChange",lang.hitch(this,"_onIntermediateChange"),true));this.saveButton.set("disabled",true);}}},startup:function(){this.editWidget.startup();this.inherited(arguments);},_onIntermediateChange:function(){this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());},destroy:function(){this.editWidget.destroy(true);this.inherited(arguments);},getValue:function(){var ew=this.editWidget;return String(ew.get(("displayedValue" in ew||"_getDisplayedValueAttr" in ew)?"displayedValue":"value"));},_onKeyDown:function(e){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(e.altKey||e.ctrlKey){return;}if(e.keyCode==keys.ESCAPE){e.stopPropagation();e.preventDefault();this.cancel(true);}else{if(e.keyCode==keys.ENTER&&e.target.tagName=="INPUT"){e.stopPropagation();e.preventDefault();this._onChange();}}}},_onBlur:function(){this.inherited(arguments);if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(this.getValue()==this._resetValue){this.cancel(false);}else{if(this.enableSave()){this.save(false);}}}},_onChange:function(){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){fm.focus(this.inlineEditBox.displayNode);}},enableSave:function(){return this.editWidget.isValid?this.editWidget.isValid():true;},focus:function(){this.editWidget.focus();if(this.editWidget.focusNode){fm._onFocusNode(this.editWidget.focusNode);if(this.editWidget.focusNode.tagName=="INPUT"){this.defer(function(){_2c7.selectInputText(this.editWidget.focusNode);});}}}});var _2d2=_2bb("dijit.InlineEditBox"+(has("dojo-bidi")?"_NoBidi":""),_2c2,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_2c8,editorWrapper:_2ca,editorParams:{},disabled:false,onChange:function(){},onCancel:function(){},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){this.editorParams={};},postMixInProperties:function(){this.inherited(arguments);this.displayNode=this.srcNodeRef;this.own(on(this.displayNode,_2c1,lang.hitch(this,"_onClick")),on(this.displayNode,"mouseover, focus",lang.hitch(this,"_onMouseOver")),on(this.displayNode,"mouseout, blur",lang.hitch(this,"_onMouseOut")));this.displayNode.setAttribute("role","button");if(!this.displayNode.getAttribute("tabIndex")){this.displayNode.setAttribute("tabIndex",0);}if(!this.value&&!("value" in this.params)){this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));}if(!this.value){this.displayNode.innerHTML=this.noValueIndicator;}_2bd.add(this.displayNode,"dijitInlineEditBoxDisplayMode");},setDisabled:function(_2d3){_2c0.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_2d3);},_setDisabledAttr:function(_2d4){this.domNode.setAttribute("aria-disabled",_2d4?"true":"false");if(_2d4){this.displayNode.removeAttribute("tabIndex");}else{this.displayNode.setAttribute("tabIndex",0);}_2bd.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_2d4);this._set("disabled",_2d4);},_onMouseOver:function(){if(!this.disabled){_2bd.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");}},_onMouseOut:function(){_2bd.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");},_onClick:function(e){if(this.disabled){return;}if(e){e.stopPropagation();e.preventDefault();}this._onMouseOut();this.defer("edit");},edit:function(){if(this.disabled||this.editing){return;}this._set("editing",true);this._savedTabIndex=_2bc.get(this.displayNode,"tabIndex")||"0";if(!this.wrapperWidget){var _2d5=_2be.create("span",null,this.domNode,"before");var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_2bf.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_2d5);if(!this.wrapperWidget._started){this.wrapperWidget.startup();}if(!this._started){this.startup();}}var ww=this.wrapperWidget;_2bd.add(this.displayNode,"dijitOffScreen");_2bd.remove(ww.domNode,"dijitOffScreen");_2bf.set(ww.domNode,{visibility:"visible"});_2bc.set(this.displayNode,"tabIndex","-1");var ew=ww.editWidget;var self=this;when(ew.onLoadDeferred,lang.hitch(ww,function(){ew.set(("displayedValue" in ew||"_setDisplayedValueAttr" in ew)?"displayedValue":"value",self.value);this.defer(function(){ww.saveButton.set("disabled","intermediateChanges" in ew);this.focus();this._resetValue=this.getValue();});}));},_onBlur:function(){this.inherited(arguments);if(!this.editing){}},destroy:function(){if(this.wrapperWidget&&!this.wrapperWidget._destroyed){this.wrapperWidget.destroy();delete this.wrapperWidget;}this.inherited(arguments);},_showText:function(_2d6){var ww=this.wrapperWidget;_2bf.set(ww.domNode,{visibility:"hidden"});_2bd.add(ww.domNode,"dijitOffScreen");_2bd.remove(this.displayNode,"dijitOffScreen");_2bc.set(this.displayNode,"tabIndex",this._savedTabIndex);if(_2d6){fm.focus(this.displayNode);}},save:function(_2d7){if(this.disabled||!this.editing){return;}this._set("editing",false);var ww=this.wrapperWidget;var _2d8=ww.getValue();this.set("value",_2d8);this._showText(_2d7);},setValue:function(val){_2c0.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(val){val=lang.trim(val);var _2d9=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");this.displayNode.innerHTML=_2d9||this.noValueIndicator;this._set("value",val);if(this._started){this.defer(function(){this.onChange(val);});}},getValue:function(){_2c0.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");return this.get("value");},cancel:function(_2da){if(this.disabled||!this.editing){return;}this._set("editing",false);this.defer("onCancel");this._showText(_2da);}});if(has("dojo-bidi")){_2d2=_2bb("dijit.InlineEditBox",_2d2,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.displayNode);}});}_2d2._InlineEditor=_2ca;return _2d2;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_2db,_2dc,_2dd){var _2de={};lang.setObject("dojo.dnd.autoscroll",_2de);_2de.getViewport=_2dd.getBox;_2de.V_TRIGGER_AUTOSCROLL=32;_2de.H_TRIGGER_AUTOSCROLL=32;_2de.V_AUTOSCROLL_VALUE=16;_2de.H_AUTOSCROLL_VALUE=16;var _2df,doc=win.doc,_2e0=Infinity,_2e1=Infinity;_2de.autoScrollStart=function(d){doc=d;_2df=_2dd.getBox(doc);var html=win.body(doc).parentNode;_2e0=Math.max(html.scrollHeight-_2df.h,0);_2e1=Math.max(html.scrollWidth-_2df.w,0);};_2de.autoScroll=function(e){var v=_2df||_2dd.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_2de.H_TRIGGER_AUTOSCROLL){dx=-_2de.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_2de.H_TRIGGER_AUTOSCROLL){dx=Math.min(_2de.H_AUTOSCROLL_VALUE,_2e1-html.scrollLeft);}}if(e.clientY<_2de.V_TRIGGER_AUTOSCROLL){dy=-_2de.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_2de.V_TRIGGER_AUTOSCROLL){dy=Math.min(_2de.V_AUTOSCROLL_VALUE,_2e0-html.scrollTop);}}window.scrollBy(dx,dy);};_2de._validNodes={"div":1,"p":1,"td":1};_2de._validOverflow={"auto":1,"scroll":1};_2de.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_2e2,_2e3;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _2de._validNodes)){var s=_2dc.getComputedStyle(n),_2e4=(s.overflow.toLowerCase() in _2de._validOverflow),_2e5=(s.overflowX.toLowerCase() in _2de._validOverflow),_2e6=(s.overflowY.toLowerCase() in _2de._validOverflow);if(_2e4||_2e5||_2e6){b=_2db.getContentBox(n,s);t=_2db.position(n,true);}if(_2e4||_2e5){w=Math.min(_2de.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_2e2=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_2e4||_2e6){h=Math.min(_2de.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_2e3=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_2de.autoScroll(e);};return _2de;});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query","../registry"],function(_2e7,_2e8,_2e9,lang,_2ea,_2eb){return _2e8("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_2ea("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_2ec){if(_2ec.name==this.name&&_2ec.form==this.focusNode.form){var _2ed=_2eb.getEnclosingWidget(_2ec);if(_2ed){ary.push(_2ed);}}}));return ary;},_setCheckedAttr:function(_2ee){this.inherited(arguments);if(!this._created){return;}if(_2ee){_2e7.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2ef){if(_2ef!=this&&_2ef.checked){_2ef.set("checked",false);}}));}},_getSubmitValue:function(_2f0){return _2f0==null?"on":_2f0;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_2e7.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2f1){_2e9.set(this.focusNode||this.domNode,"checked",_2f1.checked);}));return false;}return this.inherited(arguments);}});});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_2f2,_2f3){var _2f4=_2f3.prototype.onMove;return _2f2("dojo.dnd.TimedMoveable",_2f3,{timeout:40,constructor:function(node,_2f5){if(!_2f5){_2f5={};}if(_2f5.timeout&&typeof _2f5.timeout=="number"&&_2f5.timeout>=0){this.timeout=_2f5.timeout;}},onMoveStop:function(_2f6){if(_2f6._timer){clearTimeout(_2f6._timer);_2f4.call(this,_2f6,_2f6._leftTop);}_2f3.prototype.onMoveStop.apply(this,arguments);},onMove:function(_2f7,_2f8){_2f7._leftTop=_2f8;if(!_2f7._timer){var _2f9=this;_2f7._timer=setTimeout(function(){_2f7._timer=null;_2f4.call(_2f9,_2f7,_2f7._leftTop);},this.timeout);}}});});},"dijit/layout/LinkPane":function(){define(["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_2fa,_2fb,_2fc){return _2fc("dijit.layout.LinkPane",[_2fa,_2fb],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){if(this.srcNodeRef){this.title+=this.srcNodeRef.innerHTML;}this.inherited(arguments);},_fillContent:function(){}});});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_2fd,on,_2fe,_2ff){return _2fd("dijit.form._ListMouseMixin",_2ff,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this.own(on(this.domNode,"mousedown",function(evt){evt.preventDefault();}));this._listConnect("click","_onClick");this._listConnect("mousedown","_onMouseDown");this._listConnect("mouseup","_onMouseUp");this._listConnect("mouseover","_onMouseOver");this._listConnect("mouseout","_onMouseOut");},_onClick:function(evt,_300){this._setSelectedAttr(_300,false);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_300);});},_onMouseDown:function(evt,_301){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_301,false);},_onMouseUp:function(evt,_302){this._isDragging=false;var _303=this.selected;var _304=this._hoveredNode;if(_303&&_302==_303){this.defer(function(){this._onClick(evt,_303);});}else{if(_304){this.defer(function(){this._onClick(evt,_304);});}}},_onMouseOut:function(evt,_305){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_306){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_306;this.onHover(_306);if(this._isDragging){this._setSelectedAttr(_306,false);}}});});},"dojo/cldr/monetary":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _307={};lang.setObject("dojo.cldr.monetary",_307);_307.getData=function(code){var _308={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _309={};var _30a=_308[code],_30b=_309[code];if(typeof _30a=="undefined"){_30a=2;}if(typeof _30b=="undefined"){_30b=0;}return {places:_30a,round:_30b};};return _307;});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_30c){dojo.cookie=function(name,_30d,_30e){var c=document.cookie,ret;if(arguments.length==1){var _30f=c.match(new RegExp("(?:^|; )"+_30c.escapeString(name)+"=([^;]*)"));ret=_30f?decodeURIComponent(_30f[1]):undefined;}else{_30e=_30e||{};var exp=_30e.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_30e.expires=d;}if(exp&&exp.toUTCString){_30e.expires=exp.toUTCString();}_30d=encodeURIComponent(_30d);var _310=name+"="+_30d,_311;for(_311 in _30e){_310+="; "+_311;var _312=_30e[_311];if(_312!==true){_310+="="+_312;}}document.cookie=_310;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dijit/ProgressBar":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_313,_314,_315,lang,_316,_317,_318,_319){return _314("dijit.ProgressBar",[_317,_318],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_319,_indeterminateHighContrastImagePath:_313.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!(this.params&&"value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},_setDirAttr:function(val){_315.toggle(this.domNode,"dijitProgressBarRtl",val=="rtl");this.inherited(arguments);},update:function(_31a){lang.mixin(this,_31a||{});var tip=this.internalProgress,ap=this.domNode;var _31b=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");}else{if(String(this.progress).indexOf("%")!=-1){_31b=Math.min(parseFloat(this.progress)/100,1);this.progress=_31b*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_31b=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-valuenow",this.progress);}ap.setAttribute("aria-labelledby",this.labelNode.id);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);this.labelNode.innerHTML=this.report(_31b);_315.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);tip.style.width=(_31b*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(_31c){this._set("label",_31c);this.update();},_setIndeterminateAttr:function(_31d){this._set("indeterminate",_31d);this.update();},report:function(_31e){return this.label?this.label:(this.indeterminate?"&#160;":_316.format(_31e,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dijit/form/NumberTextBox":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_31f,lang,_320,_321){var _322=_31f("dijit.form.NumberTextBoxMixin",null,{pattern:function(_323){return "("+(this.focused&&this.editOptions?this._regExpGenerator(lang.delegate(_323,this.editOptions))+"|":"")+this._regExpGenerator(_323)+")";},value:NaN,editOptions:{pattern:"#.######"},_formatter:_320.format,_regExpGenerator:_320.regexp,postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_324){var _325=typeof _324.places=="number"?_324.places:0;if(_325){_325++;}if(typeof _324.max!="number"){_324.max=9*Math.pow(10,15-_325);}if(typeof _324.min!="number"){_324.min=-9*Math.pow(10,15-_325);}this.inherited(arguments,[_324]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}},_onFocus:function(){if(this.disabled||this.readOnly){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _326=this.format(val,this.constraints);if(_326!==undefined){this.textbox.value=_326;}}this.inherited(arguments);},format:function(_327,_328){var _329=String(_327);if(typeof _327!="number"){return _329;}if(isNaN(_327)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(_327,_328))&&_328.exponent!==false&&/\de[-+]?\d/i.test(_329)){return _329;}if(this.editOptions&&this.focused){_328=lang.mixin({},_328,this.editOptions);}return this._formatter(_327,_328);},_parser:_320.parse,parse:function(_32a,_32b){var v=this._parser(_32a,lang.mixin({},_32b,(this.editOptions&&this.focused)?this.editOptions:{}));if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(_32a,_32b);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(_32c){return (_32c==null||_32c==="")?NaN:this.inherited(arguments);},serialize:function(_32d,_32e){return (typeof _32d!="number"||isNaN(_32d))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.delegate(this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(_32f,_330,_331){if(_32f!==undefined&&_331===undefined){_331=String(_32f);if(typeof _32f=="number"){if(isNaN(_32f)){_331="";}else{if(("rangeCheck" in this&&this.rangeCheck(_32f,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_331)){_331=undefined;}}}else{if(!_32f){_331="";_32f=NaN;}else{_32f=undefined;}}}this.inherited(arguments,[_32f,_330,_331]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_320._realNumberRegexp(lang.delegate(this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_332){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}}});var _333=_31f("dijit.form.NumberTextBox",[_321,_322],{baseClass:"dijitTextBox dijitNumberTextBox"});_333.Mixin=_322;return _333;});},"dijit/form/TimeTextBox":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_334,keys,lang,_335,_336){return _334("dijit.form.TimeTextBox",_336,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_335,_selector:"time",value:new Date(""),maxHeight:-1,_onKey:function(evt){if(this.disabled||this.readOnly){return;}this.inherited(arguments);switch(evt.keyCode){case keys.ENTER:case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:break;default:this.defer(function(){var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();});}}});});},"dijit/ColorPalette":function(){define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_337,_338,_339,_33a,_33b,has,i18n,_33c,_33d,_33e,_33f){var _340=_33d("dijit.ColorPalette",[_339,_33a,_33b],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_338,baseClass:"dijitColorPalette",_dyeFactory:function(_341,row,col,_342){return new this._dyeClass(_341,row,col,_342);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_33d(_340._Color,{palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_340._Color=_33d("dijit._Color",_33c,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_337.toUrl("./themes/a11y/colors7x10.png"),"3x4":_337.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_343,row,col,_344){this._title=_344;this._row=row;this._col=col;this.setColor(_33c.named[_343]);},getValue:function(){return this.toHex();},fillCell:function(cell,_345){var html=_33f.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_345,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_33e.place(html,cell);}});return _340;});},"dijit/form/CurrencyTextBox":function(){define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_346,_347,lang,_348){return _347("dijit.form.CurrencyTextBox",_348,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",_formatter:_346.format,_parser:_346.parse,_regExpGenerator:_346.regexp,parse:function(_349,_34a){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(_349)){v=lang.hitch(lang.delegate(this,{_parser:_348.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_34b){if(!_34b.currency&&this.currency){_34b.currency=this.currency;}this.inherited(arguments,[_346._mixInDefaults(lang.mixin(_34b,{exponent:false}))]);}});});},"dijit/layout/LayoutContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/_base/lang","../_WidgetBase","./_LayoutWidget","./utils"],function(_34c,_34d,_34e,_34f,lang,_350,_351,_352){var _353=_34d("dijit.layout.LayoutContainer",_351,{design:"headline",baseClass:"dijitLayoutContainer",startup:function(){if(this._started){return;}_34c.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_354){this.inherited(arguments);var _355=_354.region;if(_355){_34e.add(_354.domNode,this.baseClass+"Pane");}},_getOrderedChildren:function(){var _356=_34c.map(this.getChildren(),function(_357,idx){return {pane:_357,weight:[_357.region=="center"?Infinity:0,_357.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_357.region)?1:-1),idx]};},this);_356.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});return _34c.map(_356,function(w){return w.pane;});},layout:function(){_352.layoutChildren(this.domNode,this._contentBox,this._getOrderedChildren());},addChild:function(_358,_359){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_35a){this.inherited(arguments);if(this._started){this.layout();}_34e.remove(_35a.domNode,this.baseClass+"Pane");_34f.set(_35a.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_34f.set(_35a.domNode,/top|bottom/.test(_35a.region)?"width":"height","auto");}});_353.ChildWidgetProperties={region:"",layoutAlign:"",layoutPriority:0};lang.extend(_350,_353.ChildWidgetProperties);return _353;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_35b,_35c,fx,dom,_35d,_35e,_35f,lang,_360,on,has,_361,_362,_363,_364,_365,_366,_367){var _368=_35c("dijit._MasterTooltip",[_363,_364],{duration:_361.defaultDuration,templateString:_366,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _365(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_369,_36a,_36b,rtl,_36c){if(this.aroundNode&&this.aroundNode===_36a&&this.containerNode.innerHTML==_369){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_369;if(_36c){this.set("textDir",_36c);}this.containerNode.align=rtl?"right":"left";var pos=_362.around(this.domNode,_36a,_36b&&_36b.length?_36b:_36d.defaultPosition,!rtl,lang.hitch(this,"orient"));var _36e=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_36e.y+((_36e.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_36e.x+((_36e.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_35f.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_36a;},orient:function(node,_36f,_370,_371,_372){this.connectorNode.style.top="";var _373=_371.h,_374=_371.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_36f+"-"+_370];this.domNode.style.width="auto";var size=_35e.position(this.domNode);if(has("ie")==9){size.w+=2;}var _375=Math.min((Math.max(_374,1)),size.w);_35e.setMarginBox(this.domNode,{w:_375});if(_370.charAt(0)=="B"&&_36f.charAt(0)=="B"){var bb=_35e.position(node);var _376=this.connectorNode.offsetHeight;if(bb.h>_373){var _377=_373-((_372.h+_376)>>1);this.connectorNode.style.top=_377+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_372.h/2-_376/2,0),bb.h-_376)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_374);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_378){if(this._onDeck&&this._onDeck[1]==_378){this._onDeck=null;}else{if(this.aroundNode===_378){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_368.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_35b.forEach(node.children,function(_379){this._setAutoTextDir(_379);},this);},_setTextDirAttr:function(_37a){this._set("textDir",_37a);if(_37a=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_367.showTooltip=function(_37b,_37c,_37d,rtl,_37e){if(_37d){_37d=_35b.map(_37d,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_36d._masterTT){_367._masterTT=_36d._masterTT=new _368();}return _36d._masterTT.show(_37b,_37c,_37d,rtl,_37e);};_367.hideTooltip=function(_37f){return _36d._masterTT&&_36d._masterTT.hide(_37f);};var _36d=_35c("dijit.Tooltip",_363,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_380){_35b.forEach(this._connections||[],function(_381){_35b.forEach(_381,function(_382){_382.remove();});},this);this._connectIds=_35b.filter(lang.isArrayLike(_380)?_380:(_380?[_380]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_35b.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_383=this.selector,_384=_383?function(_385){return on.selector(_383,_385);}:function(_386){return _386;},self=this;return [on(node,_384(_360.enter),function(){self._onHover(this);}),on(node,_384("focusin"),function(){self._onHover(this);}),on(node,_384(_360.leave),lang.hitch(self,"_onUnHover")),on(node,_384("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_380);},addTarget:function(node){var id=node.id||node;if(_35b.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_35b.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_35d.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_35b.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_387){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_387);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_388){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _389=this.getContent(_388);if(!_389){return;}_36d.show(_389,_388,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_388;this.onShow(_388,this.position);},close:function(){if(this._connectNode){_36d.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_35b.forEach(this._connections||[],function(_38a){_35b.forEach(_38a,function(_38b){_38b.remove();});},this);this.inherited(arguments);}});_36d._MasterTooltip=_368;_36d.show=_367.showTooltip;_36d.hide=_367.hideTooltip;_36d.defaultPosition=["after-centered","before-centered"];return _36d;});},"dijit/form/VerticalSlider":function(){define(["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_38c,_38d,_38e){return _38c("dijit.form.VerticalSlider",_38d,{templateString:_38e,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){return this._descending;}});});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_38f,lang,_390,_391,_392,_393,_394,_395,_396){return _38f("dijit.form.DropDownButton",[_393,_394,_395],{baseClass:"dijitDropDownButton",templateString:_396,_fillContent:function(){if(this.srcNodeRef){var _397=_390("*",this.srcNodeRef);this.inherited(arguments,[_397[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){var _398=_390("[widgetId]",this.dropDownContainer)[0];if(_398){this.dropDown=_391.byNode(_398);}delete this.dropDownContainer;}if(this.dropDown){_392.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _399=this.dropDown;return (!!_399&&(!_399.href||_399.isLoaded));},loadDropDown:function(_39a){var _39b=this.dropDown;var _39c=_39b.on("load",lang.hitch(this,function(){_39c.remove();_39a();}));_39b.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_39d){var _39e=_39d.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_39e==1&&date.isLeapYear(_39d)){return 29;}return days[_39e];};date.isLeapYear=function(_39f){var year=_39f.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_3a0){var str=_3a0.toString();var tz="";var _3a1;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_3a1=str.match(pat))){tz=_3a1[1];}else{str=_3a0.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_3a1=str.match(pat))){tz=_3a1[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_3a2,_3a3,_3a4){_3a2=new Date(+_3a2);_3a3=new Date(+(_3a3||new Date()));if(_3a4=="date"){_3a2.setHours(0,0,0,0);_3a3.setHours(0,0,0,0);}else{if(_3a4=="time"){_3a2.setFullYear(0,0,0);_3a3.setFullYear(0,0,0);}}if(_3a2>_3a3){return 1;}if(_3a2<_3a3){return -1;}return 0;};date.add=function(date,_3a5,_3a6){var sum=new Date(+date);var _3a7=false;var _3a8="Date";switch(_3a5){case "day":break;case "weekday":var days,_3a9;var mod=_3a6%5;if(!mod){days=(_3a6>0)?5:-5;_3a9=(_3a6>0)?((_3a6-5)/5):((_3a6+5)/5);}else{days=mod;_3a9=parseInt(_3a6/5);}var strt=date.getDay();var adj=0;if(strt==6&&_3a6>0){adj=1;}else{if(strt==0&&_3a6<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_3a6>0)?2:-2;}_3a6=(7*_3a9)+days+adj;break;case "year":_3a8="FullYear";_3a7=true;break;case "week":_3a6*=7;break;case "quarter":_3a6*=3;case "month":_3a7=true;_3a8="Month";break;default:_3a8="UTC"+_3a5.charAt(0).toUpperCase()+_3a5.substring(1)+"s";}if(_3a8){sum["set"+_3a8](sum["get"+_3a8]()+_3a6);}if(_3a7&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_3aa,_3ab,_3ac){_3ab=_3ab||new Date();_3ac=_3ac||"day";var _3ad=_3ab.getFullYear()-_3aa.getFullYear();var _3ae=1;switch(_3ac){case "quarter":var m1=_3aa.getMonth();var m2=_3ab.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_3ad*4);_3ae=q2-q1;break;case "weekday":var days=Math.round(date.difference(_3aa,_3ab,"day"));var _3af=parseInt(date.difference(_3aa,_3ab,"week"));var mod=days%7;if(mod==0){days=_3af*5;}else{var adj=0;var aDay=_3aa.getDay();var bDay=_3ab.getDay();_3af=parseInt(days/7);mod=days%7;var _3b0=new Date(_3aa);_3b0.setDate(_3b0.getDate()+(_3af*7));var _3b1=_3b0.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_3b1+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_3b1+mod)<0:adj=2;}}}days+=adj;days-=(_3af*2);}_3ae=days;break;case "year":_3ae=_3ad;break;case "month":_3ae=(_3ab.getMonth()-_3aa.getMonth())+(_3ad*12);break;case "week":_3ae=parseInt(date.difference(_3aa,_3ab,"day")/7);break;case "day":_3ae/=24;case "hour":_3ae/=60;case "minute":_3ae/=60;case "second":_3ae/=1000;case "millisecond":_3ae*=_3ab.getTime()-_3aa.getTime();}return Math.round(_3ae);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_3b2,_3b3,_3b4,_3b5,_3b6,lang,_3b7,has,_3b8,_3b9,_3ba){return _3b3("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _3bb=this.getParent();this._childOfLayoutWidget=_3bb&&_3bb.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_3b9.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){var _3bc=[],_3bd=false;_3b7("> *",this.containerNode).some(function(node){var _3be=_3b8.byNode(node);if(_3be&&_3be.resize){_3bc.push(_3be);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_3bd=true;}}});this._singleChild=_3bc.length==1&&!_3bd?_3bc[0]:null;_3b4.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_3bf,_3c0){this._resizeCalled=true;this._scheduleLayout(_3bf,_3c0);},_scheduleLayout:function(_3c1,_3c2){if(this._isShown()){this._layout(_3c1,_3c2);}else{this._needLayout=true;this._changeSize=_3c1;this._resultSize=_3c2;}},_layout:function(_3c3,_3c4){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_3c3){_3b5.setMarginBox(this.domNode,_3c3);}var cn=this.containerNode;if(cn===this.domNode){var mb=_3c4||{};lang.mixin(mb,_3c3||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_3b5.getMarginBox(cn),mb);}this._contentBox=_3ba.marginBox2contentBox(cn,mb);}else{this._contentBox=_3b5.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){if(this.doLayout){this._checkIfSingleChild();}if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_3b5.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _3c5=this.getChildren(),_3c6,i=0;while(_3c6=_3c5[i++]){if(_3c6.resize){_3c6.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_3c7=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_3b4.contains(node,"dijitHidden")&&_3c7&&_3c7.style&&(_3c7.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/form/RangeBoundTextBox":function(){define(["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_3c8,i18n,_3c9){var _3ca=_3c8("dijit.form.RangeBoundTextBox",_3c9,{rangeMessage:"",rangeCheck:function(_3cb,_3cc){return ("min" in _3cc?(this.compare(_3cb,_3cc.min)>=0):true)&&("max" in _3cc?(this.compare(_3cb,_3cc.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");if(val==null){return false;}var _3cd=false;if("min" in this.constraints){var min=this.constraints.min;_3cd=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;}if(!_3cd&&("max" in this.constraints)){var max=this.constraints.max;_3cd=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;}return _3cd;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_3ce){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_3ce));},getErrorMessage:function(_3cf){var v=this.get("value");if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_3cf)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}}});return _3ca;});},"dijit/_editor/RichText":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/domReady","dojo/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/window","../_Widget","../_CssStateMixin","../selection","./range","./html","../focus","../main"],function(_3d0,_3d1,_3d2,_3d3,dom,_3d4,_3d5,_3d6,_3d7,_3d8,_3d9,keys,lang,on,_3da,_3db,has,_3dc,_3dd,_3de,_3df,_3e0,_3e1,_3e2,_3e3,_3e4,_3e5,_3e6){var _3e7=_3d2("dijit._editor.RichText",[_3e0,_3e1],{constructor:function(_3e8){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_3e8&&lang.isString(_3e8.value)){this.value=_3e8.value;}this.onLoadDeferred=new _3d3();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.trim,lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")||has("trident")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,"_stripBreakerNodes")].concat(this.contentDomPostFilters);}this.contentDomPostFilters=[lang.hitch(this,"_stripTrailingEmptyNodes")].concat(this.contentDomPostFilters);this.inherited(arguments);_3dc.publish(_3e6._scopeName+"._editor.RichText::init",this);},startup:function(){this.inherited(arguments);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _3e9={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_3e9.Z=exec("redo");}var key;for(key in _3e9){this.addKeyHandler(key,true,false,_3e9[key]);}},events:["onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_3e7._editorCommandsLocalized){this._local2NativeFormatNames=_3e7._local2NativeFormatNames;this._native2LocalFormatNames=_3e7._native2LocalFormatNames;return;}_3e7._editorCommandsLocalized=true;_3e7._local2NativeFormatNames={};_3e7._native2LocalFormatNames={};this._local2NativeFormatNames=_3e7._local2NativeFormatNames;this._native2LocalFormatNames=_3e7._native2LocalFormatNames;var _3ea=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _3eb="",_3ec,i=0;while((_3ec=_3ea[i++])){if(_3ec.charAt(1)!=="l"){_3eb+="<"+_3ec+"><span>content</span></"+_3ec+"><br/>";}else{_3eb+="<"+_3ec+"><li>content</li></"+_3ec+"><br/>";}}var _3ed={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_3d6.create("div",{style:_3ed,innerHTML:_3eb});this.ownerDocumentBody.appendChild(div);var _3ee=lang.hitch(this,function(){var node=div.firstChild;while(node){try{this.selection.selectElement(node.firstChild);var _3ef=node.tagName.toLowerCase();this._local2NativeFormatNames[_3ef]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_3ef]]=_3ef;node=node.nextSibling.nextSibling;}catch(e){}}_3d6.destroy(div);});this.defer(_3ee);},open:function(_3f0){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _3d3();}if(!this.isClosed){this.close();}_3dc.publish(_3e6._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_3f0.nodeName){this.domNode=_3f0;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=this.ownerDocument.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_3d6.place(dn,ta,"before");var _3f1=lang.hitch(this,function(){_3d8.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){this.defer(_3f1,10);}else{_3f1();}if(ta.form){var _3f2=ta.value;this.reset=function(){var _3f3=this.getValue();if(_3f3!==_3f2){this.replaceValue(_3f2);}};on(ta.form,"submit",lang.hitch(this,function(){_3d4.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_3e4.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_3d1["useXDomain"]||_3d1["allowXdRichTextSave"])){var _3f4=dom.byId(_3e6._scopeName+"._editor.RichText.value");if(_3f4&&_3f4.value!==""){var _3f5=_3f4.value.split(this._SEPARATOR),i=0,dat;while((dat=_3f5[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){html=data[1];_3f5=_3f5.splice(i,1);_3f4.value=_3f5.join(this._SEPARATOR);break;}}}if(!_3e7._globalSaveHandler){_3e7._globalSaveHandler={};_3dd.addOnUnload(function(){var id;for(id in _3e7._globalSaveHandler){var f=_3e7._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_3e7._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));ifr.id=this.id+"_iframe";ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=w.document;this.selection=new _3e2.SelectionManager(w);if(has("ie")){this._localizeEditorCommands();}this.onLoad(html);});var src=this._getIframeDocTxt().replace(/\\/g,"\\\\").replace(/'/g,"\\'"),s;if(has("ie")<11){s="javascript:document.open();try{parent.window;}catch(e){document.domain=\""+document.domain+"\";}"+"document.write('"+src+"');document.close()";}else{s="javascript: '"+src+"'";}if(has("ie")==9){this.editingArea.appendChild(ifr);ifr.src=s;}else{ifr.setAttribute("src",s);this.editingArea.appendChild(ifr);}if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_3d5.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _3f6=_3d8.getComputedStyle(this.domNode);var html="<div id='dijitEditorBody'></div>";var font=[_3f6.fontWeight,_3f6.fontSize,_3f6.fontFamily].join(" ");var _3f7=_3f6.lineHeight;if(_3f7.indexOf("px")>=0){_3f7=parseFloat(_3f7)/parseFloat(_3f6.fontSize);}else{if(_3f7.indexOf("em")>=0){_3f7=parseFloat(_3f7);}else{_3f7="normal";}}var _3f8="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_3f9){_3f9=_3f9.replace(/^;/ig,"")+";";var s=_3f9.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_3d8.set(self.domNode,sC,"");}_3f8+=_3f9+";";});var _3fa=_3da("label[for=\""+this.id+"\"]");var _3fb="";if(_3fa.length){_3fb=_3fa[0].innerHTML;}else{if(this["aria-label"]){_3fb=this["aria-label"];}else{if(this["aria-labelledby"]){_3fb=dom.byId(this["aria-labelledby"]).innerHTML;}}}this.iframe.setAttribute("title",_3fb);return ["<!DOCTYPE html>",this.isLeftToRight()?"<html lang='"+this.lang+"'>\n<head>\n":"<html dir='rtl' lang='"+this.lang+"'>\n<head>\n",_3fb?"<title>"+_3fb+"</title>":"","<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n","\t}\n","\tbody,html,#dijitEditorBody { outline: none; }","html { height: 100%; width: 100%; overflow: hidden; }\n",this.height?"\tbody,#dijitEditorBody { height: 100%; width: 100%; overflow: auto; }\n":"\tbody,#dijitEditorBody { min-height: "+this.minHeight+"; width: 100%; overflow-x: auto; overflow-y: hidden; }\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tline-height:",_3f7,";\n","\t}\n","\tp{ margin: 1em 0; }\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body role='main' ","onload='frameElement && frameElement._loadFunc(window,document)' ","style='"+_3f8+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var _3fc=[];if(this.styleSheets){_3fc=this.styleSheets.split(";");this.styleSheets="";}_3fc=_3fc.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url,_3fd=_3df.get(this.ownerDocument);while((url=_3fc[i++])){var _3fe=(new _3de(_3fd.location,url)).toString();this.editingAreaStyleSheets.push(_3fe);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_3fe+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString(),_3ff=_3df.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3de(_3ff.location,url)).toString();}if(_3d0.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.then(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _400=this.document.createElement("link");_400.rel="stylesheet";_400.type="text/css";_400.href=url;head.appendChild(_400);}}));},removeStyleSheet:function(uri){var url=uri.toString(),_401=_3df.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3de(_401.location,url)).toString();}var _402=_3d0.indexOf(this.editingAreaStyleSheets,url);if(_402===-1){return;}delete this.editingAreaStyleSheets[_402];_3da("link[href=\""+url+"\"]",this.window.document).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_403){_403=!!_403;this._set("disabled",_403);if(!this.isLoaded){return;}var _404=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_404){this.editNode.unselectable="on";}this.editNode.contentEditable=!_403;this.editNode.tabIndex=_403?"-1":this.tabIndex;if(_404){this.defer(function(){if(this.editNode){this.editNode.unselectable="off";}});}if(has("mozilla")&&!_403&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=_3e5.registerIframe(this.iframe);}this.editNode=this.document.body.firstChild;var _405=this;this.beforeIframeNode=_3d6.place("<div tabIndex=-1></div>",this.iframe,"before");this.afterIframeNode=_3d6.place("<div tabIndex=-1></div>",this.iframe,"after");this.iframe.onfocus=this.document.onfocus=function(){_405.editNode.focus();};this.focusNode=this.editNode;var _406=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;this.own(_3d0.map(_406,function(item){var type=item.toLowerCase().replace(/^on/,"");on(ap,type,lang.hitch(this,item));},this));this.own(on(ap,"mouseup",lang.hitch(this,"onClick")));if(has("ie")){this.own(on(this.document,"mousedown",lang.hitch(this,"_onIEMouseDown")));this.editNode.style.zoom=1;}else{this.own(on(this.document,"mousedown",lang.hitch(this,function(){delete this._cursorToStart;})));}if(has("webkit")){this._webkitListener=this.own(on(this.document,"mouseup",lang.hitch(this,"onDisplayChanged")))[0];this.own(on(this.document,"mousedown",lang.hitch(this,function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){this.defer("placeCursorAtEnd");}})));}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _407=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred){this.onLoadDeferred.resolve(true);}this.onDisplayChanged();if(this.focusOnLoad){_3db(lang.hitch(this,"defer","focus",this.updateInterval));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.then(_407);}else{_407();}},onKeyDown:function(e){if(e.keyCode===keys.SHIFT||e.keyCode===keys.ALT||e.keyCode===keys.META||e.keyCode===keys.CTRL){return true;}if(e.keyCode===keys.TAB&&this.isTabIndent){e.stopPropagation();e.preventDefault();if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(e.keyCode==keys.TAB&&!this.isTabIndent&&!e.ctrlKey&&!e.altKey){if(e.shiftKey){this.beforeIframeNode.focus();}else{this.afterIframeNode.focus();}return true;}if(has("ie")<9&&e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){e.stopPropagation();e.preventDefault();this.execCommand("delete");}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}var _408=this._keyHandlers[e.keyCode],args=arguments;if(_408&&!e.altKey){_3d0.some(_408,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}this.defer("onKeyPressed",1);return true;},onKeyUp:function(){},setDisabled:function(_409){_3d9.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_409);},_setValueAttr:function(_40a){this.setValue(_40a);},_setDisableSpellCheckAttr:function(_40b){if(this.document){_3d4.set(this.document.body,"spellcheck",!_40b);}else{this.onLoadDeferred.then(lang.hitch(this,function(){_3d4.set(this.document.body,"spellcheck",!_40b);}));}this._set("disableSpellCheck",_40b);},addKeyHandler:function(key,ctrl,_40c,_40d){if(typeof key=="string"){key=key.toUpperCase().charCodeAt(0);}if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:_40c||false,ctrl:ctrl||false,handler:_40d});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){if(has("ie")||has("trident")){this.defer(function(){if(!_3e5.curNode){this.ownerDocumentBody.focus();}});}this.inherited(arguments);var _40e=this.getValue(true);if(_40e!==this.value){this.onChange(_40e);}this._set("value",_40e);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(this.ownerDocumentBody.focus){this.ownerDocumentBody.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(this._cursorToStart){delete this._cursorToStart;if(this.editNode.childNodes){this.placeCursorAtStart();return;}}if(has("ie")<9){this.iframe.fireEvent("onfocus",document.createEventObject());}else{this.editNode.focus();}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){this._updateTimer.remove();}this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_40f){var _410=cmd.toLowerCase();if(_410==="formatblock"){if(has("safari")&&_40f===undefined){_410="heading";}}else{if(_410==="hilitecolor"&&!has("mozilla")){_410="backcolor";}}return _410;},_qcaCache:{},queryCommandAvailable:function(_411){var ca=this._qcaCache[_411];if(ca!==undefined){return ca;}return (this._qcaCache[_411]=this._queryCommandAvailable(_411));},_queryCommandAvailable:function(_412){var ie=1;var _413=1<<1;var _414=1<<2;var _415=1<<3;function _416(_417){return {ie:Boolean(_417&ie),mozilla:Boolean(_417&_413),webkit:Boolean(_417&_414),opera:Boolean(_417&_415)};};var _418=null;switch(_412.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":_418=_416(_413|ie|_414|_415);break;case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":_418=_416(_413|ie|_415|_414);break;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":_418=_416(ie);break;case "cut":case "copy":case "paste":_418=_416(ie|_413|_414|_415);break;case "inserttable":_418=_416(_413|ie);break;case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":_418=_416(ie|_413);break;default:return false;}return ((has("ie")||has("trident"))&&_418.ie)||(has("mozilla")&&_418.mozilla)||(has("webkit")&&_418.webkit)||(has("opera")&&_418.opera);},execCommand:function(_419,_41a){var _41b;if(this.focused){this.focus();}_419=this._normalizeCommand(_419,_41a);if(_41a!==undefined){if(_419==="heading"){throw new Error("unimplemented");}else{if(_419==="formatblock"&&(has("ie")||has("trident"))){_41a="<"+_41a+">";}}}var _41c="_"+_419+"Impl";if(this[_41c]){_41b=this[_41c](_41a);}else{_41a=arguments.length>1?_41a:null;if(_41a||_419!=="createlink"){_41b=this.document.execCommand(_419,false,_41a);}}this.onDisplayChanged();return _41b;},queryCommandEnabled:function(_41d){if(this.disabled||!this._disabledOK){return false;}_41d=this._normalizeCommand(_41d);var _41e="_"+_41d+"EnabledImpl";if(this[_41e]){return this[_41e](_41d);}else{return this._browserQueryCommandEnabled(_41d);}},queryCommandState:function(_41f){if(this.disabled||!this._disabledOK){return false;}_41f=this._normalizeCommand(_41f);try{return this.document.queryCommandState(_41f);}catch(e){return false;}},queryCommandValue:function(_420){if(this.disabled||!this._disabledOK){return false;}var r;_420=this._normalizeCommand(_420);if((has("ie")||has("trident"))&&_420==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_420)];}else{if(has("mozilla")&&_420==="hilitecolor"){var _421;try{_421=this.document.queryCommandValue("styleWithCSS");}catch(e){_421=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_420);this.document.execCommand("styleWithCSS",false,_421);}else{r=this.document.queryCommandValue(_420);}}return r;},_sCall:function(name,args){return this.selection[name].apply(this.selection,args);},placeCursorAtStart:function(){this.focus();var _422=false;if(has("mozilla")){var _423=this.editNode.firstChild;while(_423){if(_423.nodeType===3){if(_423.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_422=true;this.selection.selectElement(_423);break;}}else{if(_423.nodeType===1){_422=true;var tg=_423.tagName?_423.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this.selection.selectElement(_423);}else{this.selection.selectElementChildren(_423);}break;}}_423=_423.nextSibling;}}else{_422=true;this.selection.selectElementChildren(this.editNode);}if(_422){this.selection.collapse(true);}},placeCursorAtEnd:function(){this.focus();var _424=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_424=true;this.selection.selectElement(last);break;}}else{if(last.nodeType===1){_424=true;this.selection.selectElement(last.lastChild||last);break;}}last=last.previousSibling;}}else{_424=true;this.selection.selectElementChildren(this.editNode);}if(_424){this.selection.collapse(false);}},getValue:function(_425){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this.isLoaded?this._postFilterContent(null,_425):this.value;},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.then(lang.hitch(this,function(){this.setValue(html);}));return;}this._cursorToStart=true;if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;_3d0.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;_3d0.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_426){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_426){dom=lang.clone(dom);}_3d0.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_3e4.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}_3d0.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _427=dom.byId(_3e6._scopeName+"._editor.RichText.value");if(_427){if(_427.value){_427.value+=this._SEPARATOR;}_427.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_428){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_428){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_3d9.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _3e4.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_3d9.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _3e4.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this._webkitListener.remove();delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_3d6.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_3d5.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){this._updateTimer.remove();}this.inherited(arguments);if(_3e7._globalSaveHandler){delete _3e7._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_429){if(!_429){return false;}var elem=has("ie")<9?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_429);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _42a=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_42a=true;}else{_42a=this.document.queryCommandEnabled("createlink");}}else{_42a=this._browserQueryCommandEnabled("createlink");}return _42a;},_unlinkEnabledImpl:function(){var _42b=true;if(has("mozilla")||has("webkit")){_42b=this.selection.hasAncestorElement("a");}else{_42b=this._browserQueryCommandEnabled("unlink");}return _42b;},_inserttableEnabledImpl:function(){var _42c=true;if(has("mozilla")||has("webkit")){_42c=true;}else{_42c=this._browserQueryCommandEnabled("inserttable");}return _42c;},_cutEnabledImpl:function(){var _42d=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42d=!!sel;}else{_42d=this._browserQueryCommandEnabled("cut");}return _42d;},_copyEnabledImpl:function(){var _42e=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42e=!!sel;}else{_42e=this._browserQueryCommandEnabled("copy");}return _42e;},_pasteEnabledImpl:function(){var _42f=true;if(has("webkit")){return true;}else{_42f=this._browserQueryCommandEnabled("paste");}return _42f;},_inserthorizontalruleImpl:function(_430){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_430);},_unlinkImpl:function(_431){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this.selection.getAncestorElement("a");this.selection.selectElement(a);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_431);},_hilitecolorImpl:function(_432){var _433;var _434=this._handleTextColorOrProperties("hilitecolor",_432);if(!_434){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_433=this.document.execCommand("hilitecolor",false,_432);this.document.execCommand("styleWithCSS",false,false);}else{_433=this.document.execCommand("hilitecolor",false,_432);}}return _433;},_backcolorImpl:function(_435){if(has("ie")){_435=_435?_435:null;}var _436=this._handleTextColorOrProperties("backcolor",_435);if(!_436){_436=this.document.execCommand("backcolor",false,_435);}return _436;},_forecolorImpl:function(_437){if(has("ie")){_437=_437?_437:null;}var _438=false;_438=this._handleTextColorOrProperties("forecolor",_437);if(!_438){_438=this.document.execCommand("forecolor",false,_437);}return _438;},_inserthtmlImpl:function(_439){_439=this._preFilterContent(_439);var rv=true;if(has("ie")<9){var _43a=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_43a.item(0);while(_43a.length){_43a.remove(_43a.item(0));}n.outerHTML=_439;}else{_43a.pasteHTML(_439);}_43a.select();}else{if(has("trident")<8){var _43a;var _43b=_3e3.getSelection(this.window);if(_43b&&_43b.rangeCount&&_43b.getRangeAt){_43a=_43b.getRangeAt(0);_43a.deleteContents();var div=_3d6.create("div");div.innerHTML=_439;var node,_43c;var n=this.document.createDocumentFragment();while((node=div.firstChild)){_43c=n.appendChild(node);}_43a.insertNode(n);if(_43c){_43a=_43a.cloneRange();_43a.setStartAfter(_43c);_43a.collapse(false);_43b.removeAllRanges();_43b.addRange(_43a);}}}else{if(has("mozilla")&&!_439.length){this.selection.remove();}else{rv=this.document.execCommand("inserthtml",false,_439);}}}return rv;},_boldImpl:function(_43d){var _43e=false;if(has("ie")){this._adaptIESelection();_43e=this._adaptIEFormatAreaAndExec("bold");}if(!_43e){_43e=this.document.execCommand("bold",false,_43d);}return _43e;},_italicImpl:function(_43f){var _440=false;if(has("ie")){this._adaptIESelection();_440=this._adaptIEFormatAreaAndExec("italic");}if(!_440){_440=this.document.execCommand("italic",false,_43f);}return _440;},_underlineImpl:function(_441){var _442=false;if(has("ie")){this._adaptIESelection();_442=this._adaptIEFormatAreaAndExec("underline");}if(!_442){_442=this.document.execCommand("underline",false,_441);}return _442;},_strikethroughImpl:function(_443){var _444=false;if(has("ie")){this._adaptIESelection();_444=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_444){_444=this.document.execCommand("strikethrough",false,_443);}return _444;},_superscriptImpl:function(_445){var _446=false;if(has("ie")){this._adaptIESelection();_446=this._adaptIEFormatAreaAndExec("superscript");}if(!_446){_446=this.document.execCommand("superscript",false,_445);}return _446;},_subscriptImpl:function(_447){var _448=false;if(has("ie")){this._adaptIESelection();_448=this._adaptIEFormatAreaAndExec("subscript");}if(!_448){_448=this.document.execCommand("subscript",false,_447);}return _448;},_fontnameImpl:function(_449){var _44a;if(has("ie")){_44a=this._handleTextColorOrProperties("fontname",_449);}if(!_44a){_44a=this.document.execCommand("fontname",false,_449);}return _44a;},_fontsizeImpl:function(_44b){var _44c;if(has("ie")){_44c=this._handleTextColorOrProperties("fontsize",_44b);}if(!_44c){_44c=this.document.execCommand("fontsize",false,_44b);}return _44c;},_insertorderedlistImpl:function(_44d){var _44e=false;if(has("ie")){_44e=this._adaptIEList("insertorderedlist",_44d);}if(!_44e){_44e=this.document.execCommand("insertorderedlist",false,_44d);}return _44e;},_insertunorderedlistImpl:function(_44f){var _450=false;if(has("ie")){_450=this._adaptIEList("insertunorderedlist",_44f);}if(!_450){_450=this.document.execCommand("insertunorderedlist",false,_44f);}return _450;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_3d7.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_451){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_451);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_451)==="");}}return false;},_removeStartingRangeFromRange:function(node,_452){if(node.nextSibling){_452.setStart(node.nextSibling,0);}else{var _453=node.parentNode;while(_453&&_453.nextSibling==null){_453=_453.parentNode;}if(_453){_452.setStart(_453.nextSibling,0);}}return _452;},_adaptIESelection:function(){var _454=_3e3.getSelection(this.window);if(_454&&_454.rangeCount&&!_454.isCollapsed){var _455=_454.getRangeAt(0);var _456=_455.startContainer;var _457=_455.startOffset;while(_456.nodeType===3&&_457>=_456.length&&_456.nextSibling){_457=_457-_456.length;_456=_456.nextSibling;}var _458=null;while(this._isNodeEmpty(_456,_457)&&_456!==_458){_458=_456;_455=this._removeStartingRangeFromRange(_456,_455);_456=_455.startContainer;_457=0;}_454.removeAllRanges();_454.addRange(_455);}},_adaptIEFormatAreaAndExec:function(_459){var _45a=_3e3.getSelection(this.window);var doc=this.document;var rs,ret,_45b,txt,_45c,_45d,_45e,_45f;if(_459&&_45a&&_45a.isCollapsed){var _460=this.queryCommandValue(_459);if(_460){var _461=this._tagNamesForCommand(_459);_45b=_45a.getRangeAt(0);var fs=_45b.startContainer;if(fs.nodeType===3){var _462=_45b.endOffset;if(fs.length<_462){ret=this._adjustNodeAndOffset(rs,_462);fs=ret.node;_462=ret.offset;}}var _463;while(fs&&fs!==this.editNode){var _464=fs.tagName?fs.tagName.toLowerCase():"";if(_3d0.indexOf(_461,_464)>-1){_463=fs;break;}fs=fs.parentNode;}if(_463){rs=_45b.startContainer;var _465=doc.createElement(_463.tagName);_3d6.place(_465,_463,"after");if(rs&&rs.nodeType===3){var _466,_467;var _468=_45b.endOffset;if(rs.length<_468){ret=this._adjustNodeAndOffset(rs,_468);rs=ret.node;_468=ret.offset;}txt=rs.nodeValue;_45c=doc.createTextNode(txt.substring(0,_468));var _469=txt.substring(_468,txt.length);if(_469){_45d=doc.createTextNode(_469);}_3d6.place(_45c,rs,"before");if(_45d){_45e=doc.createElement("span");_45e.className="ieFormatBreakerSpan";_3d6.place(_45e,rs,"after");_3d6.place(_45d,_45e,"after");_45d=_45e;}_3d6.destroy(rs);var _46a=_45c.parentNode;var _46b=[];var _46c;while(_46a!==_463){var tg=_46a.tagName;_46c={tagName:tg};_46b.push(_46c);var _46d=doc.createElement(tg);if(_46a.style){if(_46d.style){if(_46a.style.cssText){_46d.style.cssText=_46a.style.cssText;_46c.cssText=_46a.style.cssText;}}}if(_46a.tagName==="FONT"){if(_46a.color){_46d.color=_46a.color;_46c.color=_46a.color;}if(_46a.face){_46d.face=_46a.face;_46c.face=_46a.face;}if(_46a.size){_46d.size=_46a.size;_46c.size=_46a.size;}}if(_46a.className){_46d.className=_46a.className;_46c.className=_46a.className;}if(_45d){_466=_45d;while(_466){_467=_466.nextSibling;_46d.appendChild(_466);_466=_467;}}if(_46d.tagName==_46a.tagName){_45e=doc.createElement("span");_45e.className="ieFormatBreakerSpan";_3d6.place(_45e,_46a,"after");_3d6.place(_46d,_45e,"after");}else{_3d6.place(_46d,_46a,"after");}_45c=_46a;_45d=_46d;_46a=_46a.parentNode;}if(_45d){_466=_45d;if(_466.nodeType===1||(_466.nodeType===3&&_466.nodeValue)){_465.innerHTML="";}while(_466){_467=_466.nextSibling;_465.appendChild(_466);_466=_467;}}var _46e;if(_46b.length){_46c=_46b.pop();var _46f=doc.createElement(_46c.tagName);if(_46c.cssText&&_46f.style){_46f.style.cssText=_46c.cssText;}if(_46c.className){_46f.className=_46c.className;}if(_46c.tagName==="FONT"){if(_46c.color){_46f.color=_46c.color;}if(_46c.face){_46f.face=_46c.face;}if(_46c.size){_46f.size=_46c.size;}}_3d6.place(_46f,_465,"before");while(_46b.length){_46c=_46b.pop();var _470=doc.createElement(_46c.tagName);if(_46c.cssText&&_470.style){_470.style.cssText=_46c.cssText;}if(_46c.className){_470.className=_46c.className;}if(_46c.tagName==="FONT"){if(_46c.color){_470.color=_46c.color;}if(_46c.face){_470.face=_46c.face;}if(_46c.size){_470.size=_46c.size;}}_46f.appendChild(_470);_46f=_470;}_45f=doc.createTextNode(".");_45e.appendChild(_45f);_46f.appendChild(_45f);_46e=_3e3.create(this.window);_46e.setStart(_45f,0);_46e.setEnd(_45f,_45f.length);_45a.removeAllRanges();_45a.addRange(_46e);this.selection.collapse(false);_45f.parentNode.innerHTML="";}else{_45e=doc.createElement("span");_45e.className="ieFormatBreakerSpan";_45f=doc.createTextNode(".");_45e.appendChild(_45f);_3d6.place(_45e,_465,"before");_46e=_3e3.create(this.window);_46e.setStart(_45f,0);_46e.setEnd(_45f,_45f.length);_45a.removeAllRanges();_45a.addRange(_46e);this.selection.collapse(false);_45f.parentNode.innerHTML="";}if(!_465.firstChild){_3d6.destroy(_465);}return true;}}return false;}else{_45b=_45a.getRangeAt(0);rs=_45b.startContainer;if(rs&&rs.nodeType===3){var _462=_45b.startOffset;if(rs.length<_462){ret=this._adjustNodeAndOffset(rs,_462);rs=ret.node;_462=ret.offset;}txt=rs.nodeValue;_45c=doc.createTextNode(txt.substring(0,_462));var _469=txt.substring(_462);if(_469!==""){_45d=doc.createTextNode(txt.substring(_462));}_45e=doc.createElement("span");_45f=doc.createTextNode(".");_45e.appendChild(_45f);if(_45c.length){_3d6.place(_45c,rs,"after");}else{_45c=rs;}_3d6.place(_45e,_45c,"after");if(_45d){_3d6.place(_45d,_45e,"after");}_3d6.destroy(rs);var _46e=_3e3.create(this.window);_46e.setStart(_45f,0);_46e.setEnd(_45f,_45f.length);_45a.removeAllRanges();_45a.addRange(_46e);doc.execCommand(_459);_3d6.place(_45e.firstChild,_45e,"before");_3d6.destroy(_45e);_46e.setStart(_45f,0);_46e.setEnd(_45f,_45f.length);_45a.removeAllRanges();_45a.addRange(_46e);this.selection.collapse(false);_45f.parentNode.innerHTML="";return true;}}}else{return false;}},_adaptIEList:function(_471){var _472=_3e3.getSelection(this.window);if(_472.isCollapsed){if(_472.rangeCount&&!this.queryCommandValue(_471)){var _473=_472.getRangeAt(0);var sc=_473.startContainer;if(sc&&sc.nodeType==3){if(!_473.startOffset){var _474="ul";if(_471==="insertorderedlist"){_474="ol";}var list=this.document.createElement(_474);var li=_3d6.create("li",null,list);_3d6.place(list,sc,"before");li.appendChild(sc);_3d6.create("br",null,list,"after");var _475=_3e3.create(this.window);_475.setStart(sc,0);_475.setEnd(sc,sc.length);_472.removeAllRanges();_472.addRange(_475);this.selection.collapse(true);return true;}}}}return false;},_handleTextColorOrProperties:function(_476,_477){var _478=_3e3.getSelection(this.window);var doc=this.document;var rs,ret,_479,txt,_47a,_47b,_47c,_47d;_477=_477||null;if(_476&&_478&&_478.isCollapsed){if(_478.rangeCount){_479=_478.getRangeAt(0);rs=_479.startContainer;if(rs&&rs.nodeType===3){var _47e=_479.startOffset;if(rs.length<_47e){ret=this._adjustNodeAndOffset(rs,_47e);rs=ret.node;_47e=ret.offset;}txt=rs.nodeValue;_47a=doc.createTextNode(txt.substring(0,_47e));var _47f=txt.substring(_47e);if(_47f!==""){_47b=doc.createTextNode(txt.substring(_47e));}_47c=doc.createElement("span");_47d=doc.createTextNode(".");_47c.appendChild(_47d);var _480=doc.createElement("span");_47c.appendChild(_480);if(_47a.length){_3d6.place(_47a,rs,"after");}else{_47a=rs;}_3d6.place(_47c,_47a,"after");if(_47b){_3d6.place(_47b,_47c,"after");}_3d6.destroy(rs);var _481=_3e3.create(this.window);_481.setStart(_47d,0);_481.setEnd(_47d,_47d.length);_478.removeAllRanges();_478.addRange(_481);if(has("webkit")){var _482="color";if(_476==="hilitecolor"||_476==="backcolor"){_482="backgroundColor";}_3d8.set(_47c,_482,_477);this.selection.remove();_3d6.destroy(_480);_47c.innerHTML="&#160;";this.selection.selectElement(_47c);this.focus();}else{this.execCommand(_476,_477);_3d6.place(_47c.firstChild,_47c,"before");_3d6.destroy(_47c);_481.setStart(_47d,0);_481.setEnd(_47d,_47d.length);_478.removeAllRanges();_478.addRange(_481);this.selection.collapse(false);_47d.parentNode.removeChild(_47d);}return true;}}}return false;},_adjustNodeAndOffset:function(node,_483){while(node.length<_483&&node.nextSibling&&node.nextSibling.nodeType===3){_483=_483-node.length;node=node.nextSibling;}return {"node":node,"offset":_483};},_tagNamesForCommand:function(_484){if(_484==="bold"){return ["b","strong"];}else{if(_484==="italic"){return ["i","em"];}else{if(_484==="strikethrough"){return ["s","strike"];}else{if(_484==="superscript"){return ["sup"];}else{if(_484==="subscript"){return ["sub"];}else{if(_484==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){if(!this.isLoaded){return;}_3da(".ieFormatBreakerSpan",node).forEach(function(b){while(b.firstChild){_3d6.place(b.firstChild,b,"before");}_3d6.destroy(b);});return node;},_stripTrailingEmptyNodes:function(node){function _485(node){return (/^(p|div|br)$/i.test(node.nodeName)&&node.children.length==0&&/^[\s\xA0]*$/.test(node.textContent||node.innerText||""))||(node.nodeType===3&&/^[\s\xA0]*$/.test(node.nodeValue));};while(node.lastChild&&_485(node.lastChild)){_3d6.destroy(node.lastChild);}return node;}});return _3e7;});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_486,_487,lang,dom,_488,_489,on,_48a,_48b,dnd,_48c,win){var _48d=_487("dojo.dnd.Moveable",[_489],{handle:"",delay:0,skip:false,constructor:function(node,_48e){this.node=dom.byId(node);if(!_48e){_48e={};}this.handle=_48e.handle?dom.byId(_48e.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_48e.delay>0?_48e.delay:0;this.skip=_48e.skip;this.mover=_48e.mover?_48e.mover:_48c;this.events=[on(this.handle,_48b.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_48f,node,Ctor){return new Ctor(node,_48f);},destroy:function(){_486.forEach(this.events,function(_490){_490.remove();});this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_48b.move,lang.hitch(this,"onMouseMove")),on(this.handle,_48b.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_491){_48a.publish("/dnd/move/start",_491);_488.add(win.body(),"dojoMove");_488.add(this.node,"dojoMoveItem");},onMoveStop:function(_492){_48a.publish("/dnd/move/stop",_492);_488.remove(win.body(),"dojoMove");_488.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_493,_494){this.onMoving(_493,_494);var s=_493.node.style;s.left=_494.l+"px";s.top=_494.t+"px";this.onMoved(_493,_494);},onMoving:function(){},onMoved:function(){}});return _48d;});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_495,_496,has,keys,lang,on,_497,_498,_499,_49a,_49b,_49c,_49d){var _49e=_495("dijit.TooltipDialog",[_498,_49b,_49a,_499],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_49c,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.containerNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_49f,_4a0){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_49f+"-"+_4a0];_496.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems(this.containerNode);_497.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _4a1=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_4a1.y+((_4a1.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_4a1.x+((_4a1.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems(this.containerNode);if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_497.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_497.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_49e.extend({_setTitleAttr:function(_4a2){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,_4a2):_4a2;this._set("title",_4a2);},_setTextDirAttr:function(_4a3){if(!this._created||this.textDir!=_4a3){this._set("textDir",_4a3);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _49e;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_4a4){return function(_4a5,_4a6){switch(typeof _4a5){default:throw new Error("Can not query with a "+typeof _4a5);case "object":case "undefined":var _4a7=_4a5;_4a5=function(_4a8){for(var key in _4a7){var _4a9=_4a7[key];if(_4a9&&_4a9.test){if(!_4a9.test(_4a8[key],_4a8)){return false;}}else{if(_4a9!=_4a8[key]){return false;}}}return true;};break;case "string":if(!this[_4a5]){throw new Error("No filter function "+_4a5+" was found in store");}_4a5=this[_4a5];case "function":}function _4aa(_4ab){var _4ac=_4a4.filter(_4ab,_4a5);var _4ad=_4a6&&_4a6.sort;if(_4ad){_4ac.sort(typeof _4ad=="function"?_4ad:function(a,b){for(var sort,i=0;sort=_4ad[i];i++){var _4ae=a[sort.attribute];var _4af=b[sort.attribute];_4ae=_4ae!=null?_4ae.valueOf():_4ae;_4af=_4af!=null?_4af.valueOf():_4af;if(_4ae!=_4af){return !!sort.descending==(_4ae==null||_4ae>_4af)?-1:1;}}return 0;});}if(_4a6&&(_4a6.start||_4a6.count)){var _4b0=_4ac.length;_4ac=_4ac.slice(_4a6.start||0,(_4a6.start||0)+(_4a6.count||Infinity));_4ac.total=_4b0;}return _4ac;};_4aa.matches=_4a5;return _4aa;};});},"dijit/form/_ExpandingTextAreaMixin":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/_base/window","../Viewport"],function(_4b1,_4b2,has,lang,on,win,_4b3){has.add("textarea-needs-help-shrinking",function(){var body=win.body(),te=_4b2.create("textarea",{rows:"5",cols:"20",value:" ",style:{zoom:1,fontSize:"12px",height:"96px",overflow:"hidden",visibility:"hidden",position:"absolute",border:"5px solid white",margin:"0",padding:"0",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"}},body,"last");var _4b4=te.scrollHeight>=te.clientHeight;body.removeChild(te);return _4b4;});return _4b1("dijit.form._ExpandingTextAreaMixin",null,{_setValueAttr:function(){this.inherited(arguments);this.resize();},postCreate:function(){this.inherited(arguments);var _4b5=this.textbox;_4b5.style.overflowY="hidden";this.own(on(_4b5,"focus, resize",lang.hitch(this,"_resizeLater")));},startup:function(){this.inherited(arguments);this.own(_4b3.on("resize",lang.hitch(this,"_resizeLater")));this._resizeLater();},_onInput:function(e){this.inherited(arguments);this.resize();},_estimateHeight:function(){var _4b6=this.textbox;_4b6.rows=(_4b6.value.match(/\n/g)||[]).length+1;},_resizeLater:function(){this.defer("resize");},resize:function(){var _4b7=this.textbox;function _4b8(){var _4b9=false;if(_4b7.value===""){_4b7.value=" ";_4b9=true;}var sh=_4b7.scrollHeight;if(_4b9){_4b7.value="";}return sh;};if(_4b7.style.overflowY=="hidden"){_4b7.scrollTop=0;}if(this.busyResizing){return;}this.busyResizing=true;if(_4b8()||_4b7.offsetHeight){var newH=_4b8()+Math.max(_4b7.offsetHeight-_4b7.clientHeight,0);var _4ba=newH+"px";if(_4ba!=_4b7.style.height){_4b7.style.height=_4ba;_4b7.rows=1;}if(has("textarea-needs-help-shrinking")){var _4bb=_4b8(),_4bc=_4bb,_4bd=_4b7.style.minHeight,_4be=4,_4bf,_4c0=_4b7.scrollTop;_4b7.style.minHeight=_4ba;_4b7.style.height="auto";while(newH>0){_4b7.style.minHeight=Math.max(newH-_4be,4)+"px";_4bf=_4b8();var _4c1=_4bc-_4bf;newH-=_4c1;if(_4c1<_4be){break;}_4bc=_4bf;_4be<<=1;}_4b7.style.height=newH+"px";_4b7.style.minHeight=_4bd;_4b7.scrollTop=_4c0;}_4b7.style.overflowY=_4b8()>_4b7.clientHeight?"auto":"hidden";if(_4b7.style.overflowY=="hidden"){_4b7.scrollTop=0;}}else{this._estimateHeight();}this.busyResizing=false;}});});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_4c2,dom,_4c3,_4c4,_4c5,has,lang,_4c6,_4c7,_4c8,_4c9,_4ca){var _4cb=_4c2("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_4c6,_4c7,_4c8,_4c9],{templateString:_4ca,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _4cc="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_4cc=val.charAt(ndx+1);var _4cd=val.substr(0,ndx);var _4ce=val.substr(ndx+3);text=_4cd+_4cc+_4ce;val=_4cd+"<span class=\"dijitMenuItemShortcutKey\">"+_4cc+"</span>"+_4ce;}else{text=val;}this.domNode.setAttribute("aria-label",text+" "+this.accelKey);this.containerNode.innerHTML=val;this._set("shortcutKey",_4cc);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_4cf){if(_4cf&&!("label" in this.params)){this._set("label",_4cf.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _4d0=this.id+"_text";_4c3.set(this.containerNode,"id",_4d0);if(this.accelKeyNode){_4c3.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_onFocus:function(){this.getParent()._onItemFocus(this);this.inherited(arguments);},_setSelected:function(_4d1){_4c4.toggle(this.domNode,"dijitMenuItemSelected",_4d1);},setLabel:function(_4d2){_4c5.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_4d2);},setDisabled:function(_4d3){_4c5.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_4d3);},_setDisabledAttr:function(_4d4){this.focusNode.setAttribute("aria-disabled",_4d4?"true":"false");this._set("disabled",_4d4);},_setAccelKeyAttr:function(_4d5){if(this.accelKeyNode){this.accelKeyNode.style.display=_4d5?"":"none";this.accelKeyNode.innerHTML=_4d5;_4c3.set(this.containerNode,"colSpan",_4d5?"1":"2");}this._set("accelKey",_4d5);}});if(has("dojo-bidi")){_4cb=_4c2("dijit.MenuItem",_4cb,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _4cb;});},"dijit/MenuBarItem":function(){define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_4d6,_4d7,_4d8){var _4d9=_4d6("dijit._MenuBarItemMixin",null,{templateString:_4d8,_setIconClassAttr:null});var _4da=_4d6("dijit.MenuBarItem",[_4d7,_4d9],{});_4da._MenuBarItemMixin=_4d9;return _4da;});},"dijit/layout/TabController":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/has","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_4db,dom,_4dc,_4dd,has,i18n,lang,_4de,_4df,Menu,_4e0,_4e1){var _4e2=_4db("dijit.layout._TabButton"+(has("dojo-bidi")?"_NoBidi":""),_4de.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_4e1,_setNameAttr:"focusNode",scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;this.defer(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_4dd.toggle(this.domNode,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _4e3=i18n.getLocalization("dijit","common");if(this.closeNode){_4dc.set(this.closeNode,"title",_4e3.itemClose);}}},_setDisabledAttr:function(_4e4){this.inherited(arguments);if(this.closeNode){if(_4e4){_4dc.remove(this.closeNode,"title");}else{var _4e5=i18n.getLocalization("dijit","common");_4dc.set(this.closeNode,"title",_4e5.itemClose);}}},_setLabelAttr:function(_4e6){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_4e2=_4db("dijit.layout._TabButton",_4e2,{_setLabelAttr:function(_4e7){this.inherited(arguments);this.applyTextDir(this.iconNode,this.iconNode.alt);}});}var _4e8=_4db("dijit.layout.TabController",_4de,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'></div>",tabPosition:"top",buttonWidget:_4e2,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){this.inherited(arguments);var _4e9=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){return _4dd.contains(node,"dijitClosable")&&!_4dd.contains(node,"dijitTabDisabled");}});this.own(_4e9);var _4ea=i18n.getLocalization("dijit","common"),_4eb=this;_4e9.addChild(new _4e0({label:_4ea.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){var _4ec=_4df.byNode(this.getParent().currentTarget);_4eb.onCloseButtonClick(_4ec.page);}}));}});_4e8.TabButton=_4e2;return _4e8;});},"dojo/cldr/supplemental":function(){define(["../_base/lang","../i18n"],function(lang,i18n){var _4ed={};lang.setObject("dojo.cldr.supplemental",_4ed);_4ed.getFirstDayOfWeek=function(_4ee){var _4ef={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};var _4f0=_4ed._region(_4ee);var dow=_4ef[_4f0];return (dow===undefined)?1:dow;};_4ed._region=function(_4f1){_4f1=i18n.normalizeLocale(_4f1);var tags=_4f1.split("-");var _4f2=tags[1];if(!_4f2){_4f2={aa:"et",ab:"ge",af:"za",ak:"gh",am:"et",ar:"eg",as:"in",av:"ru",ay:"bo",az:"az",ba:"ru",be:"by",bg:"bg",bi:"vu",bm:"ml",bn:"bd",bo:"cn",br:"fr",bs:"ba",ca:"es",ce:"ru",ch:"gu",co:"fr",cr:"ca",cs:"cz",cv:"ru",cy:"gb",da:"dk",de:"de",dv:"mv",dz:"bt",ee:"gh",el:"gr",en:"us",es:"es",et:"ee",eu:"es",fa:"ir",ff:"sn",fi:"fi",fj:"fj",fo:"fo",fr:"fr",fy:"nl",ga:"ie",gd:"gb",gl:"es",gn:"py",gu:"in",gv:"gb",ha:"ng",he:"il",hi:"in",ho:"pg",hr:"hr",ht:"ht",hu:"hu",hy:"am",ia:"fr",id:"id",ig:"ng",ii:"cn",ik:"us","in":"id",is:"is",it:"it",iu:"ca",iw:"il",ja:"jp",ji:"ua",jv:"id",jw:"id",ka:"ge",kg:"cd",ki:"ke",kj:"na",kk:"kz",kl:"gl",km:"kh",kn:"in",ko:"kr",ks:"in",ku:"tr",kv:"ru",kw:"gb",ky:"kg",la:"va",lb:"lu",lg:"ug",li:"nl",ln:"cd",lo:"la",lt:"lt",lu:"cd",lv:"lv",mg:"mg",mh:"mh",mi:"nz",mk:"mk",ml:"in",mn:"mn",mo:"ro",mr:"in",ms:"my",mt:"mt",my:"mm",na:"nr",nb:"no",nd:"zw",ne:"np",ng:"na",nl:"nl",nn:"no",no:"no",nr:"za",nv:"us",ny:"mw",oc:"fr",om:"et",or:"in",os:"ge",pa:"in",pl:"pl",ps:"af",pt:"br",qu:"pe",rm:"ch",rn:"bi",ro:"ro",ru:"ru",rw:"rw",sa:"in",sd:"in",se:"no",sg:"cf",si:"lk",sk:"sk",sl:"si",sm:"ws",sn:"zw",so:"so",sq:"al",sr:"rs",ss:"za",st:"za",su:"id",sv:"se",sw:"tz",ta:"in",te:"in",tg:"tj",th:"th",ti:"et",tk:"tm",tl:"ph",tn:"za",to:"to",tr:"tr",ts:"za",tt:"ru",ty:"pf",ug:"cn",uk:"ua",ur:"pk",uz:"uz",ve:"za",vi:"vn",wa:"be",wo:"sn",xh:"za",yi:"il",yo:"ng",za:"cn",zh:"cn",zu:"za",ace:"id",ady:"ru",agq:"cm",alt:"ru",amo:"ng",asa:"tz",ast:"es",awa:"in",bal:"pk",ban:"id",bas:"cm",bax:"cm",bbc:"id",bem:"zm",bez:"tz",bfq:"in",bft:"pk",bfy:"in",bhb:"in",bho:"in",bik:"ph",bin:"ng",bjj:"in",bku:"ph",bqv:"ci",bra:"in",brx:"in",bss:"cm",btv:"pk",bua:"ru",buc:"yt",bug:"id",bya:"id",byn:"er",cch:"ng",ccp:"in",ceb:"ph",cgg:"ug",chk:"fm",chm:"ru",chp:"ca",chr:"us",cja:"kh",cjm:"vn",ckb:"iq",crk:"ca",csb:"pl",dar:"ru",dav:"ke",den:"ca",dgr:"ca",dje:"ne",doi:"in",dsb:"de",dua:"cm",dyo:"sn",dyu:"bf",ebu:"ke",efi:"ng",ewo:"cm",fan:"gq",fil:"ph",fon:"bj",fur:"it",gaa:"gh",gag:"md",gbm:"in",gcr:"gf",gez:"et",gil:"ki",gon:"in",gor:"id",grt:"in",gsw:"ch",guz:"ke",gwi:"ca",haw:"us",hil:"ph",hne:"in",hnn:"ph",hoc:"in",hoj:"in",ibb:"ng",ilo:"ph",inh:"ru",jgo:"cm",jmc:"tz",kaa:"uz",kab:"dz",kaj:"ng",kam:"ke",kbd:"ru",kcg:"ng",kde:"tz",kdt:"th",kea:"cv",ken:"cm",kfo:"ci",kfr:"in",kha:"in",khb:"cn",khq:"ml",kht:"in",kkj:"cm",kln:"ke",kmb:"ao",koi:"ru",kok:"in",kos:"fm",kpe:"lr",krc:"ru",kri:"sl",krl:"ru",kru:"in",ksb:"tz",ksf:"cm",ksh:"de",kum:"ru",lag:"tz",lah:"pk",lbe:"ru",lcp:"cn",lep:"in",lez:"ru",lif:"np",lis:"cn",lki:"ir",lmn:"in",lol:"cd",lua:"cd",luo:"ke",luy:"ke",lwl:"th",mad:"id",mag:"in",mai:"in",mak:"id",man:"gn",mas:"ke",mdf:"ru",mdh:"ph",mdr:"id",men:"sl",mer:"ke",mfe:"mu",mgh:"mz",mgo:"cm",min:"id",mni:"in",mnk:"gm",mnw:"mm",mos:"bf",mua:"cm",mwr:"in",myv:"ru",nap:"it",naq:"na",nds:"de","new":"np",niu:"nu",nmg:"cm",nnh:"cm",nod:"th",nso:"za",nus:"sd",nym:"tz",nyn:"ug",pag:"ph",pam:"ph",pap:"bq",pau:"pw",pon:"fm",prd:"ir",raj:"in",rcf:"re",rej:"id",rjs:"np",rkt:"in",rof:"tz",rwk:"tz",saf:"gh",sah:"ru",saq:"ke",sas:"id",sat:"in",saz:"in",sbp:"tz",scn:"it",sco:"gb",sdh:"ir",seh:"mz",ses:"ml",shi:"ma",shn:"mm",sid:"et",sma:"se",smj:"se",smn:"fi",sms:"fi",snk:"ml",srn:"sr",srr:"sn",ssy:"er",suk:"tz",sus:"gn",swb:"yt",swc:"cd",syl:"bd",syr:"sy",tbw:"ph",tcy:"in",tdd:"cn",tem:"sl",teo:"ug",tet:"tl",tig:"er",tiv:"ng",tkl:"tk",tmh:"ne",tpi:"pg",trv:"tw",tsg:"ph",tts:"th",tum:"mw",tvl:"tv",twq:"ne",tyv:"ru",tzm:"ma",udm:"ru",uli:"fm",umb:"ao",unr:"in",unx:"in",vai:"lr",vun:"tz",wae:"ch",wal:"et",war:"ph",xog:"ug",xsr:"np",yao:"mz",yap:"fm",yav:"cm",zza:"tr"}[tags[0]];}else{if(_4f2.length==4){_4f2=tags[2];}}return _4f2;};_4ed.getWeekend=function(_4f3){var _4f4={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_4f5={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_4f6=_4ed._region(_4f3),_4f7=_4f4[_4f6],end=_4f5[_4f6];if(_4f7===undefined){_4f7=6;}if(end===undefined){end=0;}return {start:_4f7,end:end};};return _4ed;});},"dijit/MenuBar":function(){define(["dojo/_base/declare","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_4f8,keys,_4f9,_4fa){return _4f8("dijit.MenuBar",_4f9,{templateString:_4fa,baseClass:"dijitMenuBar",popupDelay:0,_isMenuBar:true,_orient:["below"],_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}},focusChild:function(item){this.inherited(arguments);if(this.activated&&item.popup&&!item.disabled){this._openItemPopup(item,true);}},_onChildDeselect:function(item){if(this.currentPopupItem==item){this.currentPopupItem=null;item._closePopup();}this.inherited(arguments);},_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();},_onDownArrow:function(evt){this._moveToPopup(evt);},_onUpArrow:function(){},onItemClick:function(item,evt){if(item.popup&&item.popup.isShowingNow&&(!/^key/.test(evt.type)||evt.keyCode!==keys.DOWN_ARROW)){item.focusNode.focus();this._cleanUp(true);}else{this.inherited(arguments);}}});});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_4fb,dom,_4fc,_4fd){return _4fb("dijit.ToolbarSeparator",[_4fc,_4fd],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/layout/StackController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/touch","dojo/i18n!../nls/common"],function(_4fe,_4ff,_500,_501,keys,lang,on,_502,_503,_504,_505,_506,_507,_508){var _509=_4ff("dijit.layout._StackButton",_508,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");}});var _50a=_4ff("dijit.layout.StackController",[_505,_506,_507],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeydown'></span>",containerId:"",buttonWidget:_509,buttonWidgetCloseClass:"dijitStackCloseButton",pane2button:function(id){return _504.byId(this.id+"_"+id);},postCreate:function(){this.inherited(arguments);this.own(_502.subscribe(this.containerId+"-startup",lang.hitch(this,"onStartup")),_502.subscribe(this.containerId+"-addChild",lang.hitch(this,"onAddChild")),_502.subscribe(this.containerId+"-removeChild",lang.hitch(this,"onRemoveChild")),_502.subscribe(this.containerId+"-selectChild",lang.hitch(this,"onSelectChild")),_502.subscribe(this.containerId+"-containerKeyDown",lang.hitch(this,"onContainerKeyDown")));this.containerNode.dojoClick=true;this.own(on(this.containerNode,"click",lang.hitch(this,function(evt){var _50b=_504.getEnclosingWidget(evt.target);if(_50b!=this.containerNode&&!_50b.disabled&&_50b.page){for(var _50c=evt.target;_50c!==this.containerNode;_50c=_50c.parentNode){if(_500.contains(_50c,this.buttonWidgetCloseClass)){this.onCloseButtonClick(_50b.page);break;}else{if(_50c==_50b.domNode){this.onButtonClick(_50b.page);break;}}}}})));},onStartup:function(info){this.textDir=info.textDir;_4fe.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}var _50d=_504.byId(this.containerId).containerNode,_50e=lang.hitch(this,"pane2button"),_50f={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled","textdir":"textdir"},_510=function(attr,_511){return on(_50d,"attrmodified-"+attr,function(evt){var _512=_50e(evt.detail&&evt.detail.widget&&evt.detail.widget.id);if(_512){_512.set(_511,evt.detail.newValue);}});};for(var attr in _50f){this.own(_510(attr,_50f[attr]));}},destroy:function(_513){this.destroyDescendants(_513);this.inherited(arguments);},onAddChild:function(page,_514){var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _515=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir||this.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});this.addChild(_515,_514);page.controlButton=_515;if(!this._currentChild){this.onSelectChild(page);}var _516=page._wrapper.getAttribute("aria-labelledby")?page._wrapper.getAttribute("aria-labelledby")+" "+_515.id:_515.id;page._wrapper.removeAttribute("aria-label");page._wrapper.setAttribute("aria-labelledby",_516);},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}var _517=this.pane2button(page.id);if(_517){this.removeChild(_517);_517.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _518=this.pane2button(this._currentChild.id);_518.set("checked",false);_518.focusNode.setAttribute("tabIndex","-1");}var _519=this.pane2button(page.id);_519.set("checked",true);this._currentChild=page;_519.focusNode.setAttribute("tabIndex","0");var _51a=_504.byId(this.containerId);},onButtonClick:function(page){var _51b=this.pane2button(page.id);_503.focus(_51b.focusNode);if(this._currentChild&&this._currentChild.id===page.id){_51b.set("checked",true);}var _51c=_504.byId(this.containerId);_51c.selectChild(page);},onCloseButtonClick:function(page){var _51d=_504.byId(this.containerId);_51d.closeChild(page);if(this._currentChild){var b=this.pane2button(this._currentChild.id);if(b){_503.focus(b.focusNode||b.domNode);}}},adjacent:function(_51e){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_51e=!_51e;}var _51f=this.getChildren();var idx=_4fe.indexOf(_51f,this.pane2button(this._currentChild.id)),_520=_51f[idx];var _521;do{idx=(idx+(_51e?1:_51f.length-1))%_51f.length;_521=_51f[idx];}while(_521.disabled&&_521!=_520);return _521;},onkeydown:function(e,_522){if(this.disabled||e.altKey){return;}var _523=null;if(e.ctrlKey||!e._djpage){switch(e.keyCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_523=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_523=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_523=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_523=true;}break;case keys.HOME:var _524=this.getChildren();for(var idx=0;idx<_524.length;idx++){var _525=_524[idx];if(!_525.disabled){this.onButtonClick(_525.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.END:var _524=this.getChildren();for(var idx=_524.length-1;idx>=0;idx--){var _525=_524[idx];if(!_525.disabled){this.onButtonClick(_525.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.DELETE:case "W".charCodeAt(0):if(this._currentChild.closable&&(e.keyCode==keys.DELETE||e.ctrlKey)){this.onCloseButtonClick(this._currentChild);e.stopPropagation();e.preventDefault();}break;case keys.TAB:if(e.ctrlKey){this.onButtonClick(this.adjacent(!e.shiftKey).page);e.stopPropagation();e.preventDefault();}break;}if(_523!==null){this.onButtonClick(this.adjacent(_523).page);e.stopPropagation();e.preventDefault();}}},onContainerKeyDown:function(info){info.e._djpage=info.page;this.onkeydown(info.e);}});_50a.StackButton=_509;return _50a;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_526,_527,lang,has,win,dom,_528,_529,_52a,on,_52b,dnd,_52c){return _527("dojo.dnd.Mover",[_52a],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _52d(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_52b.move,lang.hitch(this,"onFirstMove")),on(d,_52b.move,lang.hitch(this,"onMouseMove")),on(d,_52b.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_52d),on(d.body,"selectstart",_52d)];_52c.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_52c.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_528.getMarginBox(this.node);var b=win.doc.body;var bs=_529.getComputedStyle(b);var bm=_528.getMarginBox(b,bs);var bc=_528.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_526.forEach(this.events,function(_52e){_52e.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dijit/form/HorizontalRule":function(){define(["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_52f,_530,_531){return _52f("dijit.form.HorizontalRule",[_530,_531],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;},_isHorizontal:true,buildRendering:function(){this.inherited(arguments);var _532;if(this.count==1){_532=this._genHTML(50,0);}else{var i;var _533=100/(this.count-1);if(!this._isHorizontal||this.isLeftToRight()){_532=this._genHTML(0,0);for(i=1;i<this.count-1;i++){_532+=this._genHTML(_533*i,i);}_532+=this._genHTML(100,this.count-1);}else{_532=this._genHTML(100,0);for(i=1;i<this.count-1;i++){_532+=this._genHTML(100-_533*i,i);}_532+=this._genHTML(0,this.count-1);}}this.domNode.innerHTML=_532;}});});},"dijit/layout/TabContainer":function(){define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_534,_535,_536,_537){return _534("dijit.layout.TabContainer",_535,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_538){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_536=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;return new _536({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_538);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_537:_536;}}});});},"dijit/form/_Spinner":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","dojo/on","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_539,keys,lang,has,_53a,on,_53b,_53c,_53d,_53e){return _539("dijit.form._Spinner",_53c,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_53d,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){return val;},_arrowPressed:function(_53f,_540,_541){if(this.disabled||this.readOnly){return;}this._setValueAttr(this.adjust(this.get("value"),_540*_541),false);_53e.selectInputText(this.textbox,this.textbox.value.length);},_arrowReleased:function(){this._wheelTimer=null;},_typematicCallback:function(_542,node,evt){var inc=this.smallDelta;if(node==this.textbox){var key=evt.keyCode;inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;}if(_542==-1){this._arrowReleased(node);}else{this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);}},_wheelTimer:null,_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();var _543=evt.wheelDelta/120;if(Math.floor(_543)!=_543){_543=evt.wheelDelta>0?1:-1;}var _544=evt.detail?(evt.detail*-1):_543;if(_544!==0){var node=this[(_544>0?"upArrowNode":"downArrowNode")];this._arrowPressed(node,_544,this.smallDelta);if(this._wheelTimer){this._wheelTimer.remove();}this._wheelTimer=this.defer(function(){this._arrowReleased(node);},50);}},_setConstraintsAttr:function(_545){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(_546,_547){this.focusNode.setAttribute("aria-valuenow",_546);this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,_53a.wheel,lang.hitch(this,"_mouseWheeled")),_53b.addListener(this.upArrowNode,this.textbox,{keyCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_53b.addListener(this.downArrowNode,this.textbox,{keyCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_53b.addListener(this.upArrowNode,this.textbox,{keyCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_53b.addListener(this.downArrowNode,this.textbox,{keyCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_548,_549,_54a,has,_54b,lang,_54c,_54d,_54e,_54f){if(has("dijit-legacy-requires")){_54c(0,function(){var _550=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_548(_550);});}var _551=_549("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_54d,_54e],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_54f,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},_fillContent:function(_552){if(_552&&(!this.params||!("label" in this.params))){var _553=lang.trim(_552.innerHTML);if(_553){this.label=_553;}}},_setShowLabelAttr:function(val){if(this.containerNode){_54a.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_554){_54b.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_554);},_setLabelAttr:function(_555){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_551=_549("dijit.form.Button",_551,{_setLabelAttr:function(_556){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_557){if(this._created&&this.textDir!=_557){this._set("textDir",_557);this._setLabelAttr(this.label);}}});}return _551;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_558,_559,_55a,dnd,_55b,_55c){var _55d=_558("dojo.dnd.move.constrainedMoveable",_55c,{constraints:function(){},within:false,constructor:function(node,_55e){if(!_55e){_55e={};}this.constraints=_55e.constraints;this.within=_55e.within;},onFirstMove:function(_55f){var c=this.constraintBox=this.constraints.call(this,_55f);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_559.getMarginSize(_55f.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(_560,_561){var c=this.constraintBox,s=_560.node.style;this.onMoving(_560,_561);_561.l=_561.l<c.l?c.l:c.r<_561.l?c.r:_561.l;_561.t=_561.t<c.t?c.t:c.b<_561.t?c.b:_561.t;s.left=_561.l+"px";s.top=_561.t+"px";this.onMoved(_560,_561);}});var _562=_558("dojo.dnd.move.boxConstrainedMoveable",_55d,{box:{},constructor:function(node,_563){var box=_563&&_563.box;this.constraints=function(){return box;};}});var _564=_558("dojo.dnd.move.parentConstrainedMoveable",_55d,{area:"content",constructor:function(node,_565){var area=_565&&_565.area;this.constraints=function(){var n=this.node.parentNode,s=_55a.getComputedStyle(n),mb=_559.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_559.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_559.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_559.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_55d,boxConstrainedMoveable:_562,parentConstrainedMoveable:_564};});},"dijit/layout/_TabContainerBase":function(){define(["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_566,_567,_568,_569,_56a,_56b,_56c,_56d){return _56a("dijit.layout._TabContainerBase",[_567,_569],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_566,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_56d.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_56b.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_56b.add(this.domNode,"dijitTabContainerNested");_56b.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_56b.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_56b.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_56b.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_56b.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _56e=this.tabPosition.replace(/-h/,"");this.tablist.region=_56e;var _56f=[this.tablist,{domNode:this.tablistSpacer,region:_56e},{domNode:this.containerNode,region:"center"}];_568.layoutChildren(this.domNode,this._contentBox,_56f);this._containerContentBox=_568.marginBox2contentBox(this.containerNode,_56f[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var _570=_56c.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:_570});}if(sc&&sc.resize){sc.resize();}}},destroy:function(_571){if(this.tablist){this.tablist.destroy(_571);}this.inherited(arguments);}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_572,_573,_574,has,_575,_576,_577,_578){return _572("dijit.form.Form",[_575,_576,_577,_578],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_579){_573.set(this.domNode,"encType",_579);if(has("ie")){this.domNode.encoding=_579;}this._set("encType",_579);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_574.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_57a,_57b,_57c){var base=null;return _57a("dojo.store.Memory",base,{constructor:function(_57d){for(var i in _57d){this[i]=_57d[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_57c,get:function(id){return this.data[this.index[id]];},getIdentity:function(_57e){return _57e[this.idProperty];},put:function(_57f,_580){var data=this.data,_581=this.index,_582=this.idProperty;var id=_57f[_582]=(_580&&"id" in _580)?_580.id:_582 in _57f?_57f[_582]:Math.random();if(id in _581){if(_580&&_580.overwrite===false){throw new Error("Object already exists");}data[_581[id]]=_57f;}else{_581[id]=data.push(_57f)-1;}return id;},add:function(_583,_584){(_584=_584||{}).overwrite=false;return this.put(_583,_584);},remove:function(id){var _585=this.index;var data=this.data;if(id in _585){data.splice(_585[id],1);this.setData(data);return true;}},query:function(_586,_587){return _57b(this.queryEngine(_586,_587)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dijit/Editor":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_588,_589,_58a,_58b,i18n,_58c,_58d,_58e,_58f,keys,lang,has,_590,_591,_592,_593,_594,_595,_596,_597,_598,html,_599,_59a,_59b){var _59c=_58a("dijit.Editor",_59a,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_598];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")||has("trident")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _58b();this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(has("webkit")){_58f.set(this.domNode,"KhtmlUserSelect","none");}},startup:function(){this.inherited(arguments);if(!this.toolbar){this.toolbar=new _593({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,"aria-label":this.id});this.header.appendChild(this.toolbar.domNode);}_589.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.resolve(true);_58d.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_58d.add(this.iframe,"dijitEditorIFrame");_58c.set(this.iframe,"allowTransparency",true);this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){_589.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_59d,_59e){var args=lang.isString(_59d)?{name:_59d}:lang.isFunction(_59d)?{ctor:_59d}:_59d;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_597.registry[args.name]){o.plugin=_597.registry[args.name](args);}else{_591.publish(_59b._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){try{var pc=args.ctor||lang.getObject(args.name)||_588(args.name);if(pc){o.plugin=new pc(args);}}catch(e){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}}if(!o.plugin){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}_59d=o.plugin;}if(arguments.length>1){this._plugins[_59e]=_59d;}else{this._plugins.push(_59d);}_59d.setEditor(this);if(lang.isFunction(_59d.setToolbar)){_59d.setToolbar(this.toolbar);}},resize:function(size){if(size){_595.prototype.resize.apply(this,arguments);}},layout:function(){var _59f=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_58e.getPadBorderExtents(this.iframe.parentNode).h+_58e.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_59f+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _5a0;var b=this.document.body;var _5a1=b.clientWidth;var _5a2=b.clientHeight;var _5a3=b.clientLeft;var _5a4=b.offsetWidth;var _5a5=b.offsetHeight;var _5a6=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_5a1<_5a4&&e.x>_5a1&&e.x<_5a4){_5a0=true;}}else{if(e.x<_5a3&&e.x>_5a6){_5a0=true;}}if(!_5a0){if(_5a2<_5a5&&e.y>_5a2&&e.y<_5a5){_5a0=true;}}if(!_5a0){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){this.defer("placeCursorAtEnd");}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){this._editTimer.remove();}this._editTimer=this.defer("endEditing",this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {code:1011};}}catch(e){if(e.code==1011||(e.code==9&&has("opera"))){var sub=_590.substitute,_5a7={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_5a7[cmd]])]));}r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _5a8=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,_5a9,_5aa,sel;if(mark){if(has("ie")<9||(has("ie")===9&&has("quirks"))){if(lang.isArray(mark)){_5a8=[];_589.forEach(mark,function(n){_5a8.push(_599.getNode(n,this.editNode));},this);this.selection.moveToBookmark({mark:_5a8,isCollapsed:col});}else{if(mark.startContainer&&mark.endContainer){sel=_599.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_599.create(this.window);_5a9=_599.getNode(mark.startContainer,this.editNode);_5aa=_599.getNode(mark.endContainer,this.editNode);if(_5a9&&_5aa){r.setStart(_5a9,mark.startOffset);r.setEnd(_5aa,mark.endOffset);sel.addRange(r);}}}}}else{sel=_599.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_599.create(this.window);_5a9=_599.getNode(mark.startContainer,this.editNode);_5aa=_599.getNode(mark.endContainer,this.editNode);if(_5a9&&_5aa){r.setStart(_5a9,mark.startOffset);r.setEnd(_5aa,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_5ab){if(this._editTimer){this._editTimer=this._editTimer.remove();}if(this._inEditing){this._endEditing(_5ab);this._inEditing=false;}},_getBookmark:function(){var b=this.selection.getBookmark();var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9||(has("ie")===9&&has("quirks"))){var sel=_599.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var _5ac;if(sel.rangeCount){_5ac=sel.getRangeAt(0);}if(_5ac){b.mark=_5ac.cloneRange();}else{b.mark=this.selection.getBookmark();}}}else{_589.forEach(b.mark,function(n){tmp.push(_599.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_599.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_599.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.shiftKey&&!e.altKey){if(k==90||k==122){e.stopPropagation();e.preventDefault();this.undo();return;}else{if(k==89||k==121){e.stopPropagation();e.preventDefault();this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");}else{this.beginEditing("paste");}this.defer("endEditing",1);break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(this.selection.isCollapsed()){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(_5ad){this.setValueDeferred.then(lang.hitch(this,function(){if((!this.disabled&&_5ad)||(!this._buttonEnabledPlugins&&_5ad)){_589.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!_5ad){_589.forEach(this._plugins,function(p){p.set("disabled",false);});}}}));this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_58f.set(this.document.body,"color",_58f.get(this.iframe,"color"));}}catch(e){}}});function _5ae(args){return new _597({command:args.name});};function _5af(args){return new _597({buttonClass:_596,command:args.name});};lang.mixin(_597.registry,{"undo":_5ae,"redo":_5ae,"cut":_5ae,"copy":_5ae,"paste":_5ae,"insertOrderedList":_5ae,"insertUnorderedList":_5ae,"indent":_5ae,"outdent":_5ae,"justifyCenter":_5ae,"justifyFull":_5ae,"justifyLeft":_5ae,"justifyRight":_5ae,"delete":_5ae,"selectAll":_5ae,"removeFormat":_5ae,"unlink":_5ae,"insertHorizontalRule":_5ae,"bold":_5af,"italic":_5af,"underline":_5af,"strikethrough":_5af,"subscript":_5af,"superscript":_5af,"|":function(){return new _597({setEditor:function(_5b0){this.editor=_5b0;this.button=new _594({ownerDocument:_5b0.ownerDocument});}});}});return _59c;});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_5b1,_5b2,has,keys,_5b3,_5b4,_5b5,_5b6){if(has("dijit-legacy-requires")){_5b3(0,function(){var _5b7=["dijit/ToolbarSeparator"];_5b1(_5b7);});}return _5b2("dijit.Toolbar",[_5b4,_5b6,_5b5],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_5b8,_5b9,_5ba,_5bb,_5bc,has,lang,on,_5bd,_5be,when,_5bf,_5c0,_5c1){if(has("dijit-legacy-requires")){_5bd(0,function(){var _5c2=["dijit/layout/StackController"];require(_5c2);});}var _5c3=_5ba("dijit.layout.StackContainer",_5c1,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_5bb.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _5c4=this.getChildren();_5b8.forEach(_5c4,this._setupChild,this);if(this.persist){this.selectedChildWidget=_5bf.byId(_5b9(this.id+"_selectedChild"));}else{_5b8.some(_5c4,function(_5c5){if(_5c5.selected){this.selectedChildWidget=_5c5;}return _5c5.selected;},this);}var _5c6=this.selectedChildWidget;if(!_5c6&&_5c4[0]){_5c6=this.selectedChildWidget=_5c4[0];_5c6.selected=true;}_5be.publish(this.id+"-startup",{children:_5c4,selected:_5c6,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _5c7=this.selectedChildWidget;if(_5c7){this._showChild(_5c7);}}this.inherited(arguments);},_setupChild:function(_5c8){var _5c9=_5c8.domNode,_5ca=_5bc.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_5c8.domNode,"replace"),_5cb=_5c8["aria-label"]||_5c8.title||_5c8.label;if(_5cb){_5ca.setAttribute("aria-label",_5cb);}_5bc.place(_5c9,_5ca);_5c8._wrapper=_5ca;this.inherited(arguments);if(_5c9.style.display=="none"){_5c9.style.display="block";}_5c8.domNode.title="";},addChild:function(_5cc,_5cd){this.inherited(arguments);if(this._started){_5be.publish(this.id+"-addChild",_5cc,_5cd);this.layout();if(!this.selectedChildWidget){this.selectChild(_5cc);}}},removeChild:function(page){var idx=_5b8.indexOf(this.getChildren(),page);this.inherited(arguments);_5bc.destroy(page._wrapper);delete page._wrapper;if(this._started){_5be.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _5ce=this.getChildren();if(_5ce.length){this.selectChild(_5ce[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_5cf){var d;page=_5bf.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_5cf);this._set("selectedChildWidget",page);_5be.publish(this.id+"-selectChild",page);if(this.persist){_5b9(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_5d0,_5d1){if(_5d1){this._hideChild(_5d1);}var d=this._showChild(_5d0);if(_5d0.resize){if(this.doLayout){_5d0.resize(this._containerContentBox||this._contentBox);}else{_5d0.resize();}}return d;},_adjacent:function(_5d2){var _5d3=this.getChildren();var _5d4=_5b8.indexOf(_5d3,this.selectedChildWidget);_5d4+=_5d2?1:_5d3.length-1;return _5d3[_5d4%_5d3.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_5be.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _5d5=this.selectedChildWidget;if(_5d5&&_5d5.resize){if(this.doLayout){_5d5.resize(this._containerContentBox||this._contentBox);}else{_5d5.resize();}}},_showChild:function(page){var _5d6=this.getChildren();page.isFirstChild=(page==_5d6[0]);page.isLastChild=(page==_5d6[_5d6.length-1]);page._set("selected",true);if(page._wrapper){_5bb.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_5bb.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _5d7=page.onClose&&page.onClose(this,page);if(_5d7){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_5d8){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_5b8.forEach(this.getChildren(),function(_5d9){if(!_5d8){this.removeChild(_5d9);}_5d9.destroyRecursive(_5d8);},this);this._descendantsBeingDestroyed=false;}});_5c3.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_5c0,_5c3.ChildWidgetProperties);return _5c3;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _5da={};lang.setObject("dojo.regexp",_5da);_5da.escapeString=function(str,_5db){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){if(_5db&&_5db.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_5da.buildGroupRE=function(arr,re,_5dc){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _5da.group(b.join("|"),_5dc);};_5da.group=function(_5dd,_5de){return "("+(_5de?"?:":"")+_5dd+")";};return _5da;});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_5df,_5e0,_5e1){return _5df("dijit.form.ComboBox",[_5e0,_5e1],{});});},"dijit/_editor/plugins/LinkDialog":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/query","dojo/string","../../_Widget","../_Plugin","../../form/DropDownButton","../range"],function(_5e2,_5e3,_5e4,keys,lang,on,has,_5e5,_5e6,_5e7,_5e8,_5e9,_5ea){var _5eb=_5e3("dijit._editor.plugins.LinkDialog",_5e8,{buttonClass:_5e9,useDefaultCommand:false,urlRegExp:"((https?|ftps?|file)\\://|./|../|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]{0,}(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?",emailRegExp:"<?(mailto\\:)([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+"+"@"+"((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)+(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)\\.?)|localhost|^[^-][a-zA-Z0-9_-]*>?",htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\""+" target=\"${targetSelect}\""+">${textInput}</a>",tag:"a",_hostRxp:/^((([^\[:]+):)?([^@]+)@)?(\[([^\]]+)\]|([^\[:]*))(:([0-9]+))?$/,_userAtRxp:/^([!#-'*+\-\/-9=?A-Z^-~]+[.])*[!#-'*+\-\/-9=?A-Z^-~]+@/i,linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' "+"id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_targetSelect'>${target}</label>","</td><td>","<select id='${id}_targetSelect' name='targetSelect' data-dojo-type='dijit.form.Select'>","<option selected='selected' value='_self'>${currentWindow}</option>","<option value='_blank'>${newWindow}</option>","<option value='_top'>${topWindow}</option>","<option value='_parent'>${parentWindow}</option>","</select>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),_initButton:function(){this.inherited(arguments);this.button.loadDropDown=lang.hitch(this,"_loadDropDown");this._connectTagEvents();},_loadDropDown:function(_5ec){_5e2(["dojo/i18n","../../TooltipDialog","../../registry","../../form/Button","../../form/Select","../../form/ValidationTextBox","dojo/i18n!../../nls/common","dojo/i18n!../nls/LinkDialog"],lang.hitch(this,function(i18n,_5ed,_5ee){var _5ef=this;this.tag=this.command=="insertImage"?"img":"a";var _5f0=lang.delegate(i18n.getLocalization("dijit","common",this.lang),i18n.getLocalization("dijit._editor","LinkDialog",this.lang));var _5f1=(this.dropDown=this.button.dropDown=new _5ed({title:_5f0[this.command+"Title"],ownerDocument:this.editor.ownerDocument,dir:this.editor.dir,execute:lang.hitch(this,"setValue"),onOpen:function(){_5ef._onOpenDialog();_5ed.prototype.onOpen.apply(this,arguments);},onCancel:function(){setTimeout(lang.hitch(_5ef,"_onCloseDialog"),0);}}));_5f0.urlRegExp=this.urlRegExp;_5f0.id=_5ee.getUniqueId(this.editor.id);this._uniqueId=_5f0.id;this._setContent(_5f1.title+"<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>"+_5e6.substitute(this.linkDialogTemplate,_5f0));_5f1.startup();this._urlInput=_5ee.byId(this._uniqueId+"_urlInput");this._textInput=_5ee.byId(this._uniqueId+"_textInput");this._setButton=_5ee.byId(this._uniqueId+"_setButton");this.own(_5ee.byId(this._uniqueId+"_cancelButton").on("click",lang.hitch(this.dropDown,"onCancel")));if(this._urlInput){this.own(this._urlInput.on("change",lang.hitch(this,"_checkAndFixInput")));}if(this._textInput){this.own(this._textInput.on("change",lang.hitch(this,"_checkAndFixInput")));}this._urlRegExp=new RegExp("^"+this.urlRegExp+"$","i");this._emailRegExp=new RegExp("^"+this.emailRegExp+"$","i");this._urlInput.isValid=lang.hitch(this,function(){var _5f2=this._urlInput.get("value");return this._urlRegExp.test(_5f2)||this._emailRegExp.test(_5f2);});this.own(on(_5f1.domNode,"keydown",lang.hitch(this,lang.hitch(this,function(e){if(e&&e.keyCode==keys.ENTER&&!e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey){if(!this._setButton.get("disabled")){_5f1.onExecute();_5f1.execute(_5f1.get("value"));}}}))));_5ec();}));},_checkAndFixInput:function(){var self=this;var url=this._urlInput.get("value");var _5f3=function(url){var _5f4=false;var _5f5=false;if(url&&url.length>1){url=lang.trim(url);if(url.indexOf("mailto:")!==0){if(url.indexOf("/")>0){if(url.indexOf("://")===-1){if(url.charAt(0)!=="/"&&url.indexOf("./")&&url.indexOf("../")!==0){if(self._hostRxp.test(url)){_5f4=true;}}}}else{if(self._userAtRxp.test(url)){_5f5=true;}}}}if(_5f4){self._urlInput.set("value","http://"+url);}if(_5f5){self._urlInput.set("value","mailto:"+url);}self._setButton.set("disabled",!self._isValid());};if(this._delayedCheck){clearTimeout(this._delayedCheck);this._delayedCheck=null;}this._delayedCheck=setTimeout(function(){_5f3(url);},250);},_connectTagEvents:function(){this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"dblclick",lang.hitch(this,"_onDblClick")));}));},_isValid:function(){return this._urlInput.isValid()&&this._textInput.isValid();},_setContent:function(_5f6){this.dropDown.set({parserScope:"dojo",content:_5f6});},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}return args;},setValue:function(args){this._onCloseDialog();if(has("ie")<9){var sel=_5ea.getSelection(this.editor.window);var _5f7=sel.getRangeAt(0);var a=_5f7.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(a&&(a.nodeName&&a.nodeName.toLowerCase()===this.tag)){if(this.editor.queryCommandEnabled("unlink")){this.editor.selection.selectElementChildren(a);this.editor.execCommand("unlink");}}}args=this._checkValues(args);this.editor.execCommand("inserthtml",_5e6.substitute(this.htmlTemplate,args));_5e5("a",this.editor.document).forEach(function(a){if(!a.innerHTML&&!_5e4.has(a,"name")){a.parentNode.removeChild(a);}},this);},_onCloseDialog:function(){if(this.editor.focused){this.editor.focus();}},_getCurrentValues:function(a){var url,text,_5f8;if(a&&a.tagName.toLowerCase()===this.tag){url=a.getAttribute("_djrealurl")||a.getAttribute("href");_5f8=a.getAttribute("target")||"_self";text=a.textContent||a.innerText;this.editor.selection.selectElement(a,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||"",targetSelect:_5f8||""};},_onOpenDialog:function(){var a,b,fc;if(has("ie")){var sel=_5ea.getSelection(this.editor.window);if(sel.rangeCount){var _5f9=sel.getRangeAt(0);a=_5f9.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(!a||(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){b=this.editor.selection.getAncestorElement(this.tag);if(b&&(b.nodeName&&b.nodeName.toLowerCase()==this.tag)){a=b;this.editor.selection.selectElement(a);}else{if(_5f9.startContainer===_5f9.endContainer){fc=_5f9.startContainer.firstChild;if(fc&&(fc.nodeName&&fc.nodeName.toLowerCase()==this.tag)){a=fc;this.editor.selection.selectElement(a);}}}}}}else{a=this.editor.selection.getAncestorElement(this.tag);}this.dropDown.reset();this._setButton.set("disabled",true);this.dropDown.set("value",this._getCurrentValues(a));},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e4.get(t,"href")){var _5fa=this.editor;this.editor.selection.selectElement(t);_5fa.onDisplayChanged();if(_5fa._updateTimer){_5fa._updateTimer.remove();delete _5fa._updateTimer;}_5fa.onNormalizedDisplayChanged();var _5fb=this.button;setTimeout(function(){_5fb.set("disabled",false);_5fb.loadAndOpenDropDown().then(function(){if(_5fb.dropDown.focus){_5fb.dropDown.focus();}});},10);}}}});var _5fc=_5e3("dijit._editor.plugins.ImgLinkDialog",[_5eb],{linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' "+"required='true' id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","</td><td>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />",tag:"img",_getCurrentValues:function(img){var url,text;if(img&&img.tagName.toLowerCase()===this.tag){url=img.getAttribute("_djrealurl")||img.getAttribute("src");text=img.getAttribute("alt");this.editor.selection.selectElement(img,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||""};},_isValid:function(){return this._urlInput.isValid();},_connectTagEvents:function(){this.inherited(arguments);this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"mousedown",lang.hitch(this,"_selectTag")));}));},_selectTag:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag){this.editor.selection.selectElement(t);}}},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}if(args&&args.textInput){args.textInput=args.textInput.replace(/"/g,"&quot;");}return args;},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e4.get(t,"src")){var _5fd=this.editor;this.editor.selection.selectElement(t);_5fd.onDisplayChanged();if(_5fd._updateTimer){_5fd._updateTimer.remove();delete _5fd._updateTimer;}_5fd.onNormalizedDisplayChanged();var _5fe=this.button;setTimeout(function(){_5fe.set("disabled",false);_5fe.loadAndOpenDropDown().then(function(){if(_5fe.dropDown.focus){_5fe.dropDown.focus();}});},10);}}}});_5e8.registry["createLink"]=function(){return new _5eb({command:"createLink"});};_5e8.registry["insertImage"]=function(){return new _5fc({command:"insertImage"});};_5eb.ImgLinkDialog=_5fc;return _5eb;});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_5ff,keys,_600,_601,_602){return _5ff("dijit.DropDownMenu",[_602,_601],{templateString:_600,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(evt){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_603,_604,_605,lang,on,_606){return _604("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_607){var res=[];_603.forEach(_607||this.getChildren(),function(_608){if("value" in _608){res.push(_608);}else{res=res.concat(this._getDescendantFormWidgets(_608.getChildren()));}},this);return res;},reset:function(){_603.forEach(this._getDescendantFormWidgets(),function(_609){if(_609.reset){_609.reset();}});},validate:function(){var _60a=false;return _603.every(_603.map(this._getDescendantFormWidgets(),function(_60b){_60b._hasBeenBlurred=true;var _60c=_60b.disabled||!_60b.validate||_60b.validate();if(!_60c&&!_60a){_606.scrollIntoView(_60b.containerNode||_60b.domNode);_60b.focus();_60a=true;}return _60c;}),function(item){return item;});},setValues:function(val){_605.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_603.forEach(this._getDescendantFormWidgets(),function(_60d){if(!_60d.name){return;}var _60e=map[_60d.name]||(map[_60d.name]=[]);_60e.push(_60d);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _60f=map[name],_610=lang.getObject(name,false,obj);if(_610===undefined){continue;}_610=[].concat(_610);if(typeof _60f[0].checked=="boolean"){_603.forEach(_60f,function(w){w.set("value",_603.indexOf(_610,w._get("value"))!=-1);});}else{if(_60f[0].multiple){_60f[0].set("value",_610);}else{_603.forEach(_60f,function(w,i){w.set("value",_610[i]);});}}}},getValues:function(){_605.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_603.forEach(this._getDescendantFormWidgets(),function(_611){var name=_611.name;if(!name||_611.disabled){return;}var _612=_611.get("value");if(typeof _611.checked=="boolean"){if(/Radio/.test(_611.declaredClass)){if(_612!==false){lang.setObject(name,_612,obj);}else{_612=lang.getObject(name,false,obj);if(_612===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_612!==false){ary.push(_612);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_612);}else{lang.setObject(name,[prev,_612],obj);}}else{lang.setObject(name,_612,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _613=_603.map(this._descendants,function(w){return w.get("state")||"";});return _603.indexOf(_613,"Error")>=0?"Error":_603.indexOf(_613,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_614){this._descendants=this._getDescendantFormWidgets();_603.forEach(this._descendants,function(_615){if(!_615._started){_615.startup();}});if(!_614){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_616,_617){this.onValidStateChange(_617=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/Menu":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_618,_619,_61a,dom,_61b,_61c,_61d,keys,lang,on,has,win,_61e,pm,_61f,_620){if(has("dijit-legacy-requires")){_620(0,function(){var _621=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_618(_621);});}return _61a("dijit.Menu",_61f,{constructor:function(){this._bindings=[];},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(this.ownerDocumentBody);}else{_619.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_622){return _61e.get(this._iframeContentDocument(_622))||this._iframeContentDocument(_622)["__parent__"]||(_622.name&&document.frames[_622.name])||null;},_iframeContentDocument:function(_623){return _623.contentDocument||(_623.contentWindow&&_623.contentWindow.document)||(_623.name&&document.frames[_623.name]&&document.frames[_623.name].document)||null;},bindDomNode:function(node){node=dom.byId(node,this.ownerDocument);var cn;if(node.tagName.toLowerCase()=="iframe"){var _624=node,_625=this._iframeContentWindow(_624);cn=win.body(_625.document);}else{cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);}var _626={node:node,iframe:_624};_61b.set(node,"_dijitMenu"+this.id,this._bindings.push(_626));var _627=lang.hitch(this,function(cn){var _628=this.selector,_629=_628?function(_62a){return on.selector(_628,_62a);}:function(_62b){return _62b;},self=this;return [on(cn,_629(this.leftClickToOpen?"click":"contextmenu"),function(evt){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_624,{x:evt.pageX,y:evt.pageY});}),on(cn,_629("keydown"),function(evt){if(evt.shiftKey&&evt.keyCode==keys.F10){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_624);}})];});_626.connects=cn?_627(cn):[];if(_624){_626.onloadHandler=lang.hitch(this,function(){var _62c=this._iframeContentWindow(_624),cn=win.body(_62c.document);_626.connects=_627(cn);});if(_624.addEventListener){_624.addEventListener("load",_626.onloadHandler,false);}else{_624.attachEvent("onload",_626.onloadHandler);}}},unBindDomNode:function(_62d){var node;try{node=dom.byId(_62d,this.ownerDocument);}catch(e){return;}var _62e="_dijitMenu"+this.id;if(node&&_61b.has(node,_62e)){var bid=_61b.get(node,_62e)-1,b=this._bindings[bid],h;while((h=b.connects.pop())){h.remove();}var _62f=b.iframe;if(_62f){if(_62f.removeEventListener){_62f.removeEventListener("load",b.onloadHandler,false);}else{_62f.detachEvent("onload",b.onloadHandler);}}_61b.remove(node,_62e);delete this._bindings[bid];}},_scheduleOpen:function(_630,_631,_632){if(!this._openTimer){this._openTimer=this.defer(function(){delete this._openTimer;this._openMyself({target:_630,iframe:_631,coords:_632});},1);}},_openMyself:function(args){var _633=args.target,_634=args.iframe,_635=args.coords,_636=!_635;this.currentTarget=_633;if(_635){if(_634){var ifc=_61c.position(_634,true),_637=this._iframeContentWindow(_634),_638=_61c.docScroll(_637.document);var cs=_61d.getComputedStyle(_634),tp=_61d.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_634,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_634,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_634,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_634,cs.borderTopWidth):0);_635.x+=ifc.x+left-_638.x;_635.y+=ifc.y+top-_638.y;}}else{_635=_61c.position(_633,true);_635.x+=10;_635.y+=10;}var self=this;var _639=this._focusManager.get("prevNode");var _63a=this._focusManager.get("curNode");var _63b=!_63a||(dom.isDescendant(_63a,this.domNode))?_639:_63a;function _63c(){if(self.refocus&&_63b){_63b.focus();}pm.close(self);};pm.open({popup:this,x:_635.x,y:_635.y,onExecute:_63c,onCancel:_63c,orient:this.isLeftToRight()?"L":"R"});this.focus();if(!_636){this.defer(function(){this._cleanUp(true);});}this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},destroy:function(){_619.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_63d,_63e){return _63d("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_63f){this._set("readOnly",_63f);_63e.set(this.focusNode,"readOnly",_63f);},_setLabelAttr:undefined,_getSubmitValue:function(_640){return (_640==null||_640==="")?"on":_640;},_setValueAttr:function(_641){_641=this._getSubmitValue(_641);this._set("value",_641);_63e.set(this.focusNode,"value",_641);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_63e.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_642,lang,_643,_644,_645,_646,html,_647,_648,_649,_64a,dom,_64b,_64c,xhr,i18n,when){return _649("dijit.layout.ContentPane",[_643,_644,_645],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_642._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_64d,node,ctor){var self=new ctor(_64d,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_64e,_64f){if((!_64e||!_64e.template)&&_64f&&!("href" in _64e)&&!("content" in _64e)){_64f=dom.byId(_64f);var df=_64f.ownerDocument.createDocumentFragment();while(_64f.firstChild){df.appendChild(_64f.firstChild);}_64e=lang.delegate(_64e,{content:df});}this.inherited(arguments,[_64e,_64f]);},postMixInProperties:function(){this.inherited(arguments);var _650=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_646.substitute(this.loadingMessage,_650);this.errorMessage=_646.substitute(this.errorMessage,_650);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_648.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_648.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_648.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_642.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _64a(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_642.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _64a(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_651){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _64a(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _652={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_652,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_652)),_653;hand.then(function(html){_653=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _653;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_654){if(this.isLoaded){this._onUnloadHandler();}var _655=this._contentSetter;_648.forEach(this.getChildren(),function(_656){if(_656.destroyRecursive){_656.destroyRecursive(_654);}else{if(_656.destroy){_656.destroy(_654);}}_656._destroyed=true;});if(_655){_648.forEach(_655.parseResults,function(_657){if(!_657._destroyed){if(_657.destroyRecursive){_657.destroyRecursive(_654);}else{if(_657.destroy){_657.destroy(_654);}}_657._destroyed=true;}});delete _655.parseResults;}if(!_654){_64c.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_658){this.destroyDescendants();var _659=this._contentSetter;if(!(_659&&_659 instanceof html._ContentSetter)){_659=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _65a=this.onContentError(e);try{this.containerNode.innerHTML=_65a;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _65b=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_659.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_65b);var self=this;return when(p&&p.then?p:_659.parseDeferred,function(){delete self._contentSetterParams;if(!_658){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},_onError:function(type,err,_65c){this.onLoadDeferred.reject(err);var _65d=this["on"+type+"Error"].call(this,err);if(_65c){console.error(_65c,err);}else{if(_65d){this._setContent(_65d,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_65e,_65f,_660,_661,keys,lang,_662,_663,_664,_665){return _65f("dijit._KeyNavContainer",[_664,_665,_663],{connectKeyNavHandlers:function(_666,_667){var _668=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_65e.forEach(_666,function(code){_668[code]=prev;});_65e.forEach(_667,function(code){_668[code]=next;});_668[keys.HOME]=lang.hitch(this,"focusFirstChild");_668[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_661.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_65e.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_669,_66a){this.inherited(arguments);this._startupChild(_669);},_startupChild:function(_66b){_66b.set("tabIndex","-1");},_getFirst:function(){var _66c=this.getChildren();return _66c.length?_66c[0]:null;},_getLast:function(){var _66d=this.getChildren();return _66d.length?_66d[_66d.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_662.byNode(node);return node&&node.getParent()==this;}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_66e,_66f,_670,_671,lang){function _672(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_673,dim){var _674=_673.resize?_673.resize(dim):_670.setMarginBox(_673.domNode,dim);if(_674){lang.mixin(_673,_674);}else{lang.mixin(_673,_670.getMarginBox(_673.domNode));lang.mixin(_673,dim);}};var _675={marginBox2contentBox:function(node,mb){var cs=_671.getComputedStyle(node);var me=_670.getMarginExtents(node,cs);var pb=_670.getPadBorderExtents(node,cs);return {l:_671.toPixelValue(node,cs.paddingLeft),t:_671.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_676,dim,_677,_678,_679){dim=lang.mixin({},dim);_66f.add(_676,"dijitLayoutContainer");_677=_66e.filter(_677,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_66e.filter(_677,function(item){return item.region=="center"||item.layoutAlign=="client";}));_66e.forEach(_677,function(_67a){var elm=_67a.domNode,pos=(_67a.region||_67a.layoutAlign);if(!pos){throw new Error("No region setting for "+_67a.id);}var _67b=elm.style;_67b.left=dim.l+"px";_67b.top=dim.t+"px";_67b.position="absolute";_66f.add(elm,"dijitAlign"+_672(pos));var _67c={};if(_678&&_678==_67a.id){_67c[_67a.region=="top"||_67a.region=="bottom"?"h":"w"]=_679;}if(pos=="leading"){pos=_67a.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_67a.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_67c.w=dim.w;size(_67a,_67c);dim.h-=_67a.h;if(pos=="top"){dim.t+=_67a.h;}else{_67b.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_67c.h=dim.h;size(_67a,_67c);dim.w-=_67a.w;if(pos=="left"){dim.l+=_67a.w;}else{_67b.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_67a,dim);}}}});}};lang.setObject("dijit.layout.utils",_675);return _675;});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_67d,dom,lang,_67e,_67f,_680){function _681(_682){return {id:_682.value,value:_682.value,name:lang.trim(_682.innerText||_682.textContent||"")};};return _67d("dijit.form.DataList",_67f,{constructor:function(_683,_684){this.domNode=dom.byId(_684);lang.mixin(this,_683);if(this.id){_680.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_67e("option",this.domNode).map(_681)}]);},destroy:function(){_680.remove(this.id);},fetchSelectedItem:function(){var _685=_67e("> option[selected]",this.domNode)[0]||_67e("> option",this.domNode)[0];return _685&&_681(_685);}});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_686,_687,_688,has,_689,_68a,_68b,_68c,_68d){if(has("dijit-legacy-requires")){_68a(0,function(){var _68e=["dijit/form/RadioButton"];_686(_68e);});}return _687("dijit.form.CheckBox",[_68b,_68c],{templateString:_68d,baseClass:"dijitCheckBox",_setValueAttr:function(_68f,_690){if(typeof _68f=="string"){this.inherited(arguments);_68f=true;}if(this._created){this.set("checked",_68f,_690);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_689("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_689("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/_editor/_Plugin":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../Destroyable","../form/Button"],function(_691,_692,lang,_693,_694){var _695=_692("dijit._editor._Plugin",_693,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_694,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var _696=this.getLabel(this.command),_697=this.editor,_698=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var _699=lang.mixin({label:_696,ownerDocument:_697.ownerDocument,dir:_697.dir,lang:_697.lang,showLabel:false,iconClass:_698,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});this.button=new this.buttonClass(_699);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){if(this.dropDown){this.dropDown.destroyRecursive();}this.inherited(arguments);},connect:function(o,f,tf){this.own(_691.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_69a,_69b;if(!e||!e.isLoaded||!c.length){return;}var _69c=this.get("disabled");if(this.button){try{_69b=!_69c&&e.queryCommandEnabled(c);if(this.enabled!==_69b){this.enabled=_69b;this.button.set("disabled",!_69b);}if(_69b){if(typeof this.button.checked=="boolean"){_69a=e.queryCommandState(c);if(this.checked!==_69a){this.checked=_69a;this.button.set("checked",e.queryCommandState(c));}}}}catch(e){}}},setEditor:function(_69d){this.editor=_69d;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.own(this.button.on("click",lang.hitch(this.editor,"execCommand",this.command,this.commandArg)));}else{this.button.domNode.style.display="none";}}this.own(this.editor.on("NormalizedDisplayChanged",lang.hitch(this,"updateState")));},setToolbar:function(_69e){if(this.button){_69e.addChild(this.button);}},set:function(name,_69f){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6a0=this._getAttrNames(name);if(this[_6a0.s]){var _6a1=this[_6a0.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,_69f);}return _6a1||this;},get:function(name){var _6a2=this._getAttrNames(name);return this[_6a2.g]?this[_6a2.g]():this[name];},_setDisabledAttr:function(_6a3){this._set("disabled",_6a3);this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,_6a4){this[name]=_6a4;}});_695.registry={};return _695;});},"dijit/tree/_dndSelector":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/dom","dojo/mouse","dojo/on","dojo/touch","../a11yclick","./_dndContainer"],function(_6a5,_6a6,_6a7,_6a8,lang,dom,_6a9,on,_6aa,_6ab,_6ac){return _6a7("dijit.tree._dndSelector",_6ac,{constructor:function(){this.selection={};this.anchor=null;this.events.push(on(this.tree.domNode,_6aa.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_6aa.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_6aa.move,lang.hitch(this,"onMouseMove")),on(this.tree.domNode,_6ab.press,lang.hitch(this,"onClickPress")),on(this.tree.domNode,_6ab.release,lang.hitch(this,"onClickRelease")));},singular:false,getSelectedTreeNodes:function(){var _6ad=[],sel=this.selection;for(var i in sel){_6ad.push(sel[i]);}return _6ad;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_6ae){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_6ae){this.anchor=node;}return node;},removeTreeNode:function(node){var _6af=_6a5.filter(this.getSelectedTreeNodes(),function(_6b0){return !dom.isDescendant(_6b0.domNode,node.domNode);});this.setSelection(_6af);return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_6b1){var _6b2=this.getSelectedTreeNodes();_6a5.forEach(this._setDifference(_6b2,_6b1),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_6a5.forEach(this._setDifference(_6b1,_6b2),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_6a5.forEach(ys,function(y){y.__exclude__=true;});var ret=_6a5.filter(xs,function(x){return !x.__exclude__;});_6a5.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _6b3=this.getSelectedTreeNodes();var _6b4=[],_6b5=[],_6b6=[];_6a5.forEach(_6b3,function(node){var ary=node.getTreePath(),_6b7=this.tree.model;_6b5.push(node);_6b4.push(ary);ary=_6a5.map(ary,function(item){return _6b7.getIdentity(item);},this);_6b6.push(ary.join("/"));},this);var _6b8=_6a5.map(_6b5,function(node){return node.item;});this.tree._set("paths",_6b4);this.tree._set("path",_6b4[0]||[]);this.tree._set("selectedNodes",_6b5);this.tree._set("selectedNode",_6b5[0]||null);this.tree._set("selectedItems",_6b8);this.tree._set("selectedItem",_6b8[0]||null);},onClickPress:function(e){if(this.current&&this.current.isExpandable&&this.tree.isExpandoNode(e.target,this.current)){return;}if(_6a9.isLeft(e)){e.preventDefault();}var _6b9=e.type=="keydown"?this.tree.focusedChild:this.current;if(!_6b9){return;}var copy=_6a6.isCopyKey(e),id=_6b9.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_6b9,copy,e.shiftKey);},onClickRelease:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(e.type=="keyup"?this.tree.focusedChild:this.current,_6a6.isCopyKey(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},onMouseDown:function(){},onMouseUp:function(){},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_6ba,_6bb){if(this.singular){if(this.anchor==node&&_6ba){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_6bb&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_6bc,end,_6bd=this.anchor;if(cr<0){_6bc=_6bd;end=node;}else{_6bc=node;end=_6bd;}var _6be=[];while(_6bc!=end){_6be.push(_6bc);_6bc=this.tree._getNext(_6bc);}_6be.push(end);this.setSelection(_6be);}else{if(this.selection[node.id]&&_6ba){this.removeTreeNode(node);}else{if(_6ba){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _6bf=this.selection[key];return {data:_6bf,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||_6a8.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_6c0,lang,_6c1,_6c2,dom,_6c3,_6c4){var _6c5=0;var html={_secureForInnerHtml:function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");},_emptyNode:_6c3.empty,_setNodeContent:function(node,cont){_6c3.empty(node);if(cont){if(typeof cont=="string"){cont=_6c3.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _6c6=cont.length,i=0;i<cont.length;i=_6c6==cont.length?i+1:0){_6c3.place(cont[i],node,"last");}}else{_6c3.place(cont,node,"last");}}return node;},_ContentSetter:_6c2("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_6c0._scopeName,startup:true,constructor:function(_6c7,node){lang.mixin(this,_6c7||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_6c5++].join("_");}},set:function(cont,_6c8){if(undefined!==cont){this.content=cont;}if(_6c8){this._mixin(_6c8);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _6c9=this.onContentError(e);try{node.innerHTML=_6c9;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_6c1.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_6c3.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _6ca=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_6ca){cont=_6ca[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_6cb){var _6cc={},key;for(key in _6cb){if(key in _6cc){continue;}this[key]=_6cb[key];}},_parse:function(){var _6cd=this.node;try{var _6ce={};_6c1.forEach(["dir","lang","textDir"],function(name){if(this[name]){_6ce[name]=this[name];}},this);var self=this;this.parseDeferred=_6c4.parse({rootNode:_6cd,noStart:!this.startup,inherited:_6ce,scope:this.parserScope}).then(function(_6cf){return self.parseResults=_6cf;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_6d0){var _6d1=this["on"+type+"Error"].call(this,err);if(_6d0){console.error(_6d0,err);}else{if(_6d1){html._setNodeContent(this.node,_6d1,true);}}}}),set:function(node,cont,_6d2){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(!_6d2){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_6d2,{content:cont,node:node}));return op.set();}}};lang.setObject("dojo.html",html);return html;});},"dijit/_PaletteMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","./_CssStateMixin","./a11yclick","./focus","./typematic"],function(_6d3,_6d4,_6d5,_6d6,keys,lang,on,_6d7,_6d8,_6d9,_6da){var _6db=_6d3("dijit._PaletteMixin",_6d7,{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,_dyeFactory:function(_6dc){var _6dd=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;return new _6dd(_6dc);},_preparePalette:function(_6de,_6df){this._cells=[];var url=this._blankGif;this.own(on(this.gridNode,_6d8,lang.hitch(this,"_onCellClick")));for(var row=0;row<_6de.length;row++){var _6e0=_6d6.create("tr",{tabIndex:"-1",role:"row"},this.gridNode);for(var col=0;col<_6de[row].length;col++){var _6e1=_6de[row][col];if(_6e1){var _6e2=this._dyeFactory(_6e1,row,col,_6df[_6e1]);var _6e3=_6d6.create("td",{"class":this.cellClass,tabIndex:"-1",title:_6df[_6e1],role:"gridcell"},_6e0);_6e2.fillCell(_6e3,url);_6e3.idx=this._cells.length;this._cells.push({node:_6e3,dye:_6e2});}}}this._xDim=_6de[0].length;this._yDim=_6de.length;var _6e4={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _6e4){this.own(_6da.addKeyListener(this.domNode,{keyCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _6e5=_6e4[key];return function(_6e6){this._navigateByKey(_6e5,_6e6);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){_6d9.focus(this._currentFocus);},_onCellClick:function(evt){var _6e7=evt.target;while(_6e7.tagName!="TD"){if(!_6e7.parentNode||_6e7==this.gridNode){return;}_6e7=_6e7.parentNode;}var _6e8=this._getDye(_6e7).getValue();this._setCurrent(_6e7);_6d9.focus(_6e7);this._setValueAttr(_6e8,true);evt.stopPropagation();evt.preventDefault();},_setCurrent:function(node){if("_currentFocus" in this){_6d4.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_6d4.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(_6e9,_6ea){if(this._selectedCell>=0){_6d5.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(_6e9){for(var i=0;i<this._cells.length;i++){if(_6e9==this._cells[i].dye.getValue()){this._selectedCell=i;_6d5.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?_6e9:null);if(_6ea||_6ea===undefined){this.onChange(_6e9);}},onChange:function(){},_navigateByKey:function(_6eb,_6ec){if(_6ec==-1){return;}var _6ed=this._currentFocus.idx+_6eb;if(_6ed<this._cells.length&&_6ed>-1){var _6ee=this._cells[_6ed].node;this._setCurrent(_6ee);this.defer(lang.hitch(_6d9,"focus",_6ee));}},_getDye:function(cell){return this._cells[cell.idx].dye;}});return _6db;});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_6ef,_6f0,i18n,_6f1,_6f2,_6f3){var _6f4;return _6f4=_6ef("dijit.form.ValidationTextBox",_6f1,{templateString:_6f3,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_6f5){if(_6f5!=_6f4.prototype[attr]){_6f0.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_6f5);}},_setRegExpGenAttr:function(_6f6){this._deprecateRegExp("regExpGen",_6f6);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_6f7){this._deprecateRegExp("regExp",_6f7);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_6f8,_6f9){return (new RegExp("^(?:"+this._computeRegexp(_6f9)+")"+(this.required?"":"?")+"$")).test(_6f8)&&(!this.required||!this._isEmpty(_6f8))&&(this._isEmpty(_6f8)||this.parse(_6f8,_6f9)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_6fa){return (this.trim?/^\s*$/:/^$/).test(_6fa);},getErrorMessage:function(){var _6fb=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _6fc=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_6fb:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_6fc:_6fb;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_6fd){var _6fe="";var _6ff=this.disabled||this.isValid(_6fd);if(_6ff){this._maskValidSubsetError=true;}var _700=this._isEmpty(this.textbox.value);var _701=!_6ff&&_6fd&&this._isValidSubset();this._set("state",_6ff?"":(((((!this._hasBeenBlurred||_6fd)&&_700)||_701)&&(this._maskValidSubsetError||(_701&&!this._hasBeenBlurred&&_6fd)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",_6ff?"false":"true");if(this.state=="Error"){this._maskValidSubsetError=_6fd&&_701;_6fe=this.getErrorMessage(_6fd);}else{if(this.state=="Incomplete"){_6fe=this.getPromptMessage(_6fd);this._maskValidSubsetError=!this._hasBeenBlurred||_6fd;}else{if(_700){_6fe=this.getPromptMessage(_6fd);}}}this.set("message",_6fe);return _6ff;},displayMessage:function(_702){if(_702&&this.focused){_6f2.show(_702,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_6f2.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_703){this.constraints={};this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_704){if(!_704.locale&&this.lang){_704.locale=this.lang;}this._set("constraints",_704);this._refreshState();},_setPatternAttr:function(_705){this._set("pattern",_705);this._refreshState();},_computeRegexp:function(_706){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_706);}if(p!=this._lastRegExp){var _707="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_707+=re;break;case ")":_707+="|$)";break;default:_707+="(?:"+re+"|$)";break;}});}try{"".search(_707);}catch(e){_707=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_707+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_708){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_709){this._set("required",_709);this.focusNode.setAttribute("aria-required",_709);this._refreshState();},_setMessageAttr:function(_70a){this._set("message",_70a);this.displayMessage(_70a);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);}});});},"dijit/layout/BorderContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./LayoutContainer","./utils"],function(_70b,_70c,_70d,_70e,_70f,_710,_711,keys,lang,on,_712,_713,_714,_715,_716,_717){var _718=_70d("dijit.layout._Splitter",[_714,_715],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeydown:_onKeyDown,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_70e.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _719=_70c(this._cookieName);if(_719){this.child.domNode.style[this.horizontal?"height":"width"]=_719;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_71a=_710.getMarginBox(this.child.domNode)[dim],_71b=_70b.filter(this.container.getChildren(),function(_71c){return _71c.region=="center";})[0];var _71d=_710.getContentBox(_71b.domNode)[dim]-10;return Math.min(this.child.maxSize,_71a+_71d);},_startDrag:function(e){if(!this.cover){this.cover=_70f.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");}_70e.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_70f.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_70e.add(this.domNode,"dijitSplitterShadow");_70f.place(this.fake,this.domNode,"after");}_70e.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_70e.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _71e=this._factor,_71f=this.horizontal,axis=_71f?"pageY":"pageX",_720=e[axis],_721=this.domNode.style,dim=_71f?"h":"w",_722=_711.getComputedStyle(this.child.domNode),_723=_710.getMarginBox(this.child.domNode,_722)[dim],max=this._computeMaxSize(),min=Math.max(this.child.minSize,_710.getPadBorderExtents(this.child.domNode,_722)[dim]+10),_724=this.region,_725=_724=="top"||_724=="bottom"?"top":"left",_726=parseInt(_721[_725],10),_727=this._resize,_728=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;this._handlers=this._handlers.concat([on(de,_712.move,this._drag=function(e,_729){var _72a=e[axis]-_720,_72b=_71e*_72a+_723,_72c=Math.max(Math.min(_72b,max),min);if(_727||_729){_728(_72c);}_721[_725]=_72a+_726+_71e*(_72c-_72b)+"px";}),on(de,"dragstart",function(e){e.stopPropagation();e.preventDefault();}),on(this.ownerDocumentBody,"selectstart",function(e){e.stopPropagation();e.preventDefault();}),on(de,_712.release,lang.hitch(this,"_stopDrag"))]);e.stopPropagation();e.preventDefault();},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_70e.toggle(this.domNode,"dijitSplitterHover",o);_70e.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_70e.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_70f.destroy(this.fake);}_70e.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_70c(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyDown:function(e){this._resize=true;var _72d=this.horizontal;var tick=1;switch(e.keyCode){case _72d?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _72d?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _72e=_710.getMarginSize(this.child.domNode)[_72d?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_72e,this._computeMaxSize()),this.child.minSize));e.stopPropagation();e.preventDefault();},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _72f=_70d("dijit.layout._Gutter",[_714,_715],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_70e.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _730=_70d("dijit.layout.BorderContainer",_716,{gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_718,postMixInProperties:function(){if(!this.gutters){this.baseClass+="NoGutter";}this.inherited(arguments);},_setupChild:function(_731){this.inherited(arguments);var _732=_731.region,ltr=_731.isLeftToRight();if(_732=="leading"){_732=ltr?"left":"right";}if(_732=="trailing"){_732=ltr?"right":"left";}if(_732){if(_732!="center"&&(_731.splitter||this.gutters)&&!_731._splitterWidget){var _733=_731.splitter?this._splitterClass:_72f;if(lang.isString(_733)){_733=lang.getObject(_733);}var _734=new _733({id:_731.id+"_splitter",container:this,child:_731,region:_732,live:this.liveSplitters});_734.isSplitter=true;_731._splitterWidget=_734;var _735=_732=="bottom"||_732==(this.isLeftToRight()?"right":"left");_70f.place(_734.domNode,_731.domNode,_735?"before":"after");_734.startup();}}},layout:function(){this._layoutChildren();},removeChild:function(_736){var _737=_736._splitterWidget;if(_737){_737.destroy();delete _736._splitterWidget;}this.inherited(arguments);},getChildren:function(){return _70b.filter(this.inherited(arguments),function(_738){return !_738.isSplitter;});},getSplitter:function(_739){return _70b.filter(this.getChildren(),function(_73a){return _73a.region==_739;})[0]._splitterWidget;},resize:function(_73b,_73c){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_711.getComputedStyle(node);this.pe=_710.getPadExtents(node,this.cs);this.pe.r=_711.toPixelValue(node,this.cs.paddingRight);this.pe.b=_711.toPixelValue(node,this.cs.paddingBottom);_711.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_73d,_73e){if(!this._borderBox||!this._borderBox.h){return;}var _73f=[];_70b.forEach(this._getOrderedChildren(),function(pane){_73f.push(pane);if(pane._splitterWidget){_73f.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_717.layoutChildren(this.domNode,dim,_73f,_73d,_73e);},destroyRecursive:function(){_70b.forEach(this.getChildren(),function(_740){var _741=_740._splitterWidget;if(_741){_741.destroy();}delete _740._splitterWidget;});this.inherited(arguments);}});_730.ChildWidgetProperties={splitter:false,minSize:0,maxSize:Infinity};lang.mixin(_730.ChildWidgetProperties,_716.ChildWidgetProperties);lang.extend(_713,_730.ChildWidgetProperties);_730._Splitter=_718;_730._Gutter=_72f;return _730;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_742,_743,_744){var _745={};lang.setObject("dojo.number",_745);_745.format=function(_746,_747){_747=lang.mixin({},_747||{});var _748=i18n.normalizeLocale(_747.locale),_749=i18n.getLocalization("dojo.cldr","number",_748);_747.customs=_749;var _74a=_747.pattern||_749[(_747.type||"decimal")+"Format"];if(isNaN(_746)||Math.abs(_746)==Infinity){return null;}return _745._applyPattern(_746,_74a,_747);};_745._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_745._applyPattern=function(_74b,_74c,_74d){_74d=_74d||{};var _74e=_74d.customs.group,_74f=_74d.customs.decimal,_750=_74c.split(";"),_751=_750[0];_74c=_750[(_74b<0)?1:0]||("-"+_751);if(_74c.indexOf("%")!=-1){_74b*=100;}else{if(_74c.indexOf("‰")!=-1){_74b*=1000;}else{if(_74c.indexOf("¤")!=-1){_74e=_74d.customs.currencyGroup||_74e;_74f=_74d.customs.currencyDecimal||_74f;_74c=_74c.replace(/\u00a4{1,3}/,function(_752){var prop=["symbol","currency","displayName"][_752.length-1];return _74d[prop]||_74d.currency||"";});}else{if(_74c.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _753=_745._numberPatternRE;var _754=_751.match(_753);if(!_754){throw new Error("unable to find a number expression in pattern: "+_74c);}if(_74d.fractional===false){_74d.places=0;}return _74c.replace(_753,_745._formatAbsolute(_74b,_754[0],{decimal:_74f,group:_74e,places:_74d.places,round:_74d.round}));};_745.round=function(_755,_756,_757){var _758=10/(_757||10);return (_758*+_755).toFixed(_756)/_758;};if((0.9).toFixed()==0){var _759=_745.round;_745.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _759(v,p,m)+(v>0?d:-d);};}_745._formatAbsolute=function(_75a,_75b,_75c){_75c=_75c||{};if(_75c.places===true){_75c.places=0;}if(_75c.places===Infinity){_75c.places=6;}var _75d=_75b.split("."),_75e=typeof _75c.places=="string"&&_75c.places.indexOf(","),_75f=_75c.places;if(_75e){_75f=_75c.places.substring(_75e+1);}else{if(!(_75f>=0)){_75f=(_75d[1]||[]).length;}}if(!(_75c.round<0)){_75a=_745.round(_75a,_75f,_75c.round);}var _760=String(Math.abs(_75a)).split("."),_761=_760[1]||"";if(_75d[1]||_75c.places){if(_75e){_75c.places=_75c.places.substring(0,_75e);}var pad=_75c.places!==undefined?_75c.places:(_75d[1]&&_75d[1].lastIndexOf("0")+1);if(pad>_761.length){_760[1]=_743.pad(_761,pad,"0",true);}if(_75f<_761.length){_760[1]=_761.substr(0,_75f);}}else{if(_760[1]){_760.pop();}}var _762=_75d[0].replace(",","");pad=_762.indexOf("0");if(pad!=-1){pad=_762.length-pad;if(pad>_760[0].length){_760[0]=_743.pad(_760[0],pad);}if(_762.indexOf("#")==-1){_760[0]=_760[0].substr(_760[0].length-pad);}}var _763=_75d[0].lastIndexOf(","),_764,_765;if(_763!=-1){_764=_75d[0].length-_763-1;var _766=_75d[0].substr(0,_763);_763=_766.lastIndexOf(",");if(_763!=-1){_765=_766.length-_763-1;}}var _767=[];for(var _768=_760[0];_768;){var off=_768.length-_764;_767.push((off>0)?_768.substr(off):_768);_768=(off>0)?_768.slice(0,off):"";if(_765){_764=_765;delete _765;}}_760[0]=_767.reverse().join(_75c.group||",");return _760.join(_75c.decimal||".");};_745.regexp=function(_769){return _745._parseInfo(_769).regexp;};_745._parseInfo=function(_76a){_76a=_76a||{};var _76b=i18n.normalizeLocale(_76a.locale),_76c=i18n.getLocalization("dojo.cldr","number",_76b),_76d=_76a.pattern||_76c[(_76a.type||"decimal")+"Format"],_76e=_76c.group,_76f=_76c.decimal,_770=1;if(_76d.indexOf("%")!=-1){_770/=100;}else{if(_76d.indexOf("‰")!=-1){_770/=1000;}else{var _771=_76d.indexOf("¤")!=-1;if(_771){_76e=_76c.currencyGroup||_76e;_76f=_76c.currencyDecimal||_76f;}}}var _772=_76d.split(";");if(_772.length==1){_772.push("-"+_772[0]);}var re=_744.buildGroupRE(_772,function(_773){_773="(?:"+_744.escapeString(_773,".")+")";return _773.replace(_745._numberPatternRE,function(_774){var _775={signed:false,separator:_76a.strict?_76e:[_76e,""],fractional:_76a.fractional,decimal:_76f,exponent:false},_776=_774.split("."),_777=_76a.places;if(_776.length==1&&_770!=1){_776[1]="###";}if(_776.length==1||_777===0){_775.fractional=false;}else{if(_777===undefined){_777=_76a.pattern?_776[1].lastIndexOf("0")+1:Infinity;}if(_777&&_76a.fractional==undefined){_775.fractional=true;}if(!_76a.places&&(_777<_776[1].length)){_777+=","+_776[1].length;}_775.places=_777;}var _778=_776[0].split(",");if(_778.length>1){_775.groupSize=_778.pop().length;if(_778.length>1){_775.groupSize2=_778.pop().length;}}return "("+_745._realNumberRegexp(_775)+")";});},true);if(_771){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_779,_77a,_77b,_77c){var prop=["symbol","currency","displayName"][_77b.length-1],_77d=_744.escapeString(_76a[prop]||_76a.currency||"");_77a=_77a?"[\\s\\xa0]":"";_77c=_77c?"[\\s\\xa0]":"";if(!_76a.strict){if(_77a){_77a+="*";}if(_77c){_77c+="*";}return "(?:"+_77a+_77d+_77c+")?";}return _77a+_77d+_77c;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_76e,decimal:_76f,factor:_770};};_745.parse=function(_77e,_77f){var info=_745._parseInfo(_77f),_780=(new RegExp("^"+info.regexp+"$")).exec(_77e);if(!_780){return NaN;}var _781=_780[1];if(!_780[1]){if(!_780[2]){return NaN;}_781=_780[2];info.factor*=-1;}_781=_781.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _781*info.factor;};_745._realNumberRegexp=function(_782){_782=_782||{};if(!("places" in _782)){_782.places=Infinity;}if(typeof _782.decimal!="string"){_782.decimal=".";}if(!("fractional" in _782)||/^0/.test(_782.places)){_782.fractional=[true,false];}if(!("exponent" in _782)){_782.exponent=[true,false];}if(!("eSigned" in _782)){_782.eSigned=[true,false];}var _783=_745._integerRegexp(_782),_784=_744.buildGroupRE(_782.fractional,function(q){var re="";if(q&&(_782.places!==0)){re="\\"+_782.decimal;if(_782.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_782.places+"}";}}return re;},true);var _785=_744.buildGroupRE(_782.exponent,function(q){if(q){return "([eE]"+_745._integerRegexp({signed:_782.eSigned})+")";}return "";});var _786=_783+_784;if(_784){_786="(?:(?:"+_786+")|(?:"+_784+"))";}return _786+_785;};_745._integerRegexp=function(_787){_787=_787||{};if(!("signed" in _787)){_787.signed=[true,false];}if(!("separator" in _787)){_787.separator="";}else{if(!("groupSize" in _787)){_787.groupSize=3;}}var _788=_744.buildGroupRE(_787.signed,function(q){return q?"[-+]":"";},true);var _789=_744.buildGroupRE(_787.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_744.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_787.groupSize,grp2=_787.groupSize2;if(grp2){var _78a="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_78a+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_78a;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _788+_789;};return _745;});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_78b,_78c,_78d,lang,_78e){return _78d("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,contextRequire:null,_beforeFillContent:function(){if(this.widgetsInTemplate){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_78e.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_78f){this._startupWidgets=_78f;for(var i=0;i<_78f.length;i++){this._processTemplateNode(_78f[i],function(n,p){return n[p];},function(_790,type,_791){if(type in _790){return _790.connect(_790,type,_791);}else{return _790.on(type,_791,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_792,_793,_794){if(_793(_792,"dojoType")||_793(_792,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_78b.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dijit/form/HorizontalRuleLabels":function(){define(["dojo/_base/declare","dojo/has","dojo/number","dojo/query","dojo/_base/lang","./HorizontalRule"],function(_795,has,_796,_797,lang,_798){var _799=_795("dijit.form.HorizontalRuleLabels",_798,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){return pos;},_genHTML:function(pos,ndx){var _79a=this.labels[ndx];return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._genDirectionHTML(_79a)+this._labelPrefix+_79a+this._suffix;},_genDirectionHTML:function(_79b){return "";},getLabels:function(){var _79c=this.labels;if(!_79c.length&&this.srcNodeRef){_79c=_797("> li",this.srcNodeRef).map(function(node){return String(node.innerHTML);});}if(!_79c.length&&this.count>1){var _79d=this.minimum;var inc=(this.maximum-_79d)/(this.count-1);for(var i=0;i<this.count;i++){_79c.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_796.format(_79d,this.constraints));_79d+=inc;}}return _79c;},postMixInProperties:function(){this.inherited(arguments);this.labels=this.getLabels();this.count=this.labels.length;}});if(has("dojo-bidi")){_799.extend({_setTextDirAttr:function(_79e){if(this.textDir!=_79e){this._set("textDir",_79e);_797(".dijitRuleLabelContainer",this.domNode).forEach(lang.hitch(this,function(_79f){_79f.style.direction=this.getTextDir(_79f.innerText||_79f.textContent||"");}));}},_genDirectionHTML:function(_7a0){return (this.textDir?("direction:"+this.getTextDir(_7a0)+";"):"");}});}return _799;});},"dijit/form/FilteringSelect":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_7a1,lang,when,_7a2,_7a3){return _7a1("dijit.form.FilteringSelect",[_7a2,_7a3],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){return this._opened;},isValid:function(){return !!this.item||(!this.required&&this.get("displayedValue")=="");},_refreshState:function(){if(!this.searchTimer){this.inherited(arguments);}},_callbackSetLabel:function(_7a4,_7a5,_7a6,_7a7){if((_7a5&&_7a5[this.searchAttr]!==this._lastQuery)||(!_7a5&&_7a4.length&&this.store.getIdentity(_7a4[0])!=this._lastQuery)){return;}if(!_7a4.length){this.set("value","",_7a7||(_7a7===undefined&&!this.focused),this.textbox.value,null);}else{this.set("item",_7a4[0],_7a7);}},_openResultList:function(_7a8,_7a9,_7aa){if(_7a9[this.searchAttr]!==this._lastQuery){return;}this.inherited(arguments);if(this.item===undefined){this.validate(true);}},_getValueAttr:function(){return this.valueNode.value;},_getValueField:function(){return "value";},_setValueAttr:function(_7ab,_7ac,_7ad,item){if(!this._onChangeActive){_7ac=null;}if(item===undefined){if(_7ab===null||_7ab===""){_7ab="";if(!lang.isString(_7ad)){this._setDisplayedValueAttr(_7ad||"",_7ac);return;}}var self=this;this._lastQuery=_7ab;when(this.store.get(_7ab),function(item){self._callbackSetLabel(item?[item]:[],undefined,undefined,_7ac);});}else{this.valueNode.value=_7ab;this.inherited(arguments);}},_setItemAttr:function(item,_7ae,_7af){this.inherited(arguments);this._lastDisplayedValue=this.textbox.value;},_getDisplayQueryString:function(text){return text.replace(/([\\\*\?])/g,"\\$1");},_setDisplayedValueAttr:function(_7b0,_7b1){if(_7b0==null){_7b0="";}if(!this._created){if(!("displayedValue" in this.params)){return;}_7b1=false;}if(this.store){this.closeDropDown();var _7b2=lang.clone(this.query);var qs=this._getDisplayQueryString(_7b0),q;if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_7b2[this.searchAttr]=q;this.textbox.value=_7b0;this._lastDisplayedValue=_7b0;this._set("displayedValue",_7b0);var _7b3=this;var _7b4={queryOptions:{ignoreCase:this.ignoreCase,deep:true}};lang.mixin(_7b4,this.fetchProperties);this._fetchHandle=this.store.query(_7b2,_7b4);when(this._fetchHandle,function(_7b5){_7b3._fetchHandle=null;_7b3._callbackSetLabel(_7b5||[],_7b2,_7b4,_7b1);},function(err){_7b3._fetchHandle=null;if(!_7b3._cancelingQuery){console.error("dijit.form.FilteringSelect: "+err.toString());}});}},undo:function(){this.set("displayedValue",this._lastDisplayedValue);}});});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _7b6={};lang.setObject("dojo.data.util.sorter",_7b6);_7b6.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_7b6.createSortFunction=function(_7b7,_7b8){var _7b9=[];function _7ba(attr,dir,comp,s){return function(_7bb,_7bc){var a=s.getValue(_7bb,attr);var b=s.getValue(_7bc,attr);return dir*comp(a,b);};};var _7bd;var map=_7b8.comparatorMap;var bc=_7b6.basicComparator;for(var i=0;i<_7b7.length;i++){_7bd=_7b7[i];var attr=_7bd.attribute;if(attr){var dir=(_7bd.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_7b9.push(_7ba(attr,dir,comp,_7b8));}}return function(rowA,rowB){var i=0;while(i<_7b9.length){var ret=_7b9[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _7b6;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_7be,dom,has,_7bf){var _7c0=_7be("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}var _7c1=e.defaultPrevented;if(!_7c1&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _7c2=_7bf.byNode(node);if(_7c2&&typeof _7c2._onSubmit=="function"){_7c2._onSubmit(e);e.preventDefault();_7c1=true;break;}}}return !_7c1;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_7c3){this._set("label",_7c3);var _7c4=this.containerNode||this.focusNode;_7c4.innerHTML=_7c3;}});if(has("dojo-bidi")){_7c0=_7be("dijit.form._ButtonMixin",_7c0,{_setLabelAttr:function(){this.inherited(arguments);var _7c5=this.containerNode||this.focusNode;this.applyTextDir(_7c5);}});}return _7c0;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_7c6,_7c7){var _7c8={};lang.setObject("dojo.colors",_7c8);var _7c9=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_7c6.fromRgb=function(_7ca,obj){var m=_7ca.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_7c7.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _7c6.fromArray(a,obj);}return _7c6.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_7c9(m1,m2,H+1/3)*256,_7c9(m1,m2,H)*256,_7c9(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _7c6.fromArray(a,obj);}}return null;};var _7cb=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_7c6.prototype.sanitize=function(){var t=this;t.r=Math.round(_7cb(t.r,0,255));t.g=Math.round(_7cb(t.g,0,255));t.b=Math.round(_7cb(t.b,0,255));t.a=_7cb(t.a,0,1);return this;};_7c8.makeGrey=_7c6.makeGrey=function(g,a){return _7c6.fromArray([g,g,g,a]);};lang.mixin(_7c6.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _7c6;});},"dijit/tree/_dndContainer":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/touch"],function(_7cc,_7cd,_7ce,lang,on,_7cf){return _7cd("dijit.tree._dndContainer",null,{constructor:function(tree,_7d0){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_7d0);this.containerState="";_7ce.add(this.node,"dojoDndContainer");this.events=[on(this.node,_7cf.enter,lang.hitch(this,"onOverEvent")),on(this.node,_7cf.leave,lang.hitch(this,"onOutEvent")),_7cc.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_7cc.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart, selectstart",function(evt){evt.preventDefault();})];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_7d1){this.current=_7d1;},onMouseOut:function(){this.current=null;},_changeState:function(type,_7d2){var _7d3="dojoDnd"+type;var _7d4=type.toLowerCase()+"State";_7ce.replace(this.node,_7d3+_7d2,_7d3+this[_7d4]);this[_7d4]=_7d2;},_addItemClass:function(node,type){_7ce.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_7ce.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dojo/date/locale":function(){define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_7d5,date,_7d6,i18n,_7d7,_7d8,_7d9,_7da){var _7db={};lang.setObject(_7da.id.replace(/\//g,"."),_7db);function _7dc(_7dd,_7de,_7df,_7e0){return _7e0.replace(/([a-z])\1*/ig,function(_7e1){var s,pad,c=_7e1.charAt(0),l=_7e1.length,_7e2=["abbr","wide","narrow"];switch(c){case "G":s=_7de[(l<4)?"eraAbbr":"eraNames"][_7dd.getFullYear()<0?0:1];break;case "y":s=_7dd.getFullYear();switch(l){case 1:break;case 2:if(!_7df.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_7dd.getMonth()+1)/3);pad=true;break;case "M":case "L":var m=_7dd.getMonth();if(l<3){s=m+1;pad=true;}else{var _7e3=["months",c=="L"?"standAlone":"format",_7e2[l-3]].join("-");s=_7de[_7e3][m];}break;case "w":var _7e4=0;s=_7db._getWeekOfYear(_7dd,_7e4);pad=true;break;case "d":s=_7dd.getDate();pad=true;break;case "D":s=_7db._getDayOfYear(_7dd);pad=true;break;case "e":case "c":var d=_7dd.getDay();if(l<2){s=(d-_7d6.getFirstDayOfWeek(_7df.locale)+8)%7;break;}case "E":d=_7dd.getDay();if(l<3){s=d+1;pad=true;}else{var _7e5=["days",c=="c"?"standAlone":"format",_7e2[l-3]].join("-");s=_7de[_7e5][d];}break;case "a":var _7e6=_7dd.getHours()<12?"am":"pm";s=_7df[_7e6]||_7de["dayPeriods-format-wide-"+_7e6];break;case "h":case "H":case "K":case "k":var h=_7dd.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_7dd.getMinutes();pad=true;break;case "s":s=_7dd.getSeconds();pad=true;break;case "S":s=Math.round(_7dd.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=_7db._getZone(_7dd,true,_7df);if(s){break;}l=4;case "Z":var _7e7=_7db._getZone(_7dd,false,_7df);var tz=[(_7e7<=0?"+":"-"),_7d8.pad(Math.floor(Math.abs(_7e7)/60),2),_7d8.pad(Math.abs(_7e7)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_7e0);}if(pad){s=_7d8.pad(s,l);}return s;});};_7db._getZone=function(_7e8,_7e9,_7ea){if(_7e9){return date.getTimezoneName(_7e8);}else{return _7e8.getTimezoneOffset();}};_7db.format=function(_7eb,_7ec){_7ec=_7ec||{};var _7ed=i18n.normalizeLocale(_7ec.locale),_7ee=_7ec.formatLength||"short",_7ef=_7db._getGregorianBundle(_7ed),str=[],_7f0=lang.hitch(this,_7dc,_7eb,_7ef,_7ec);if(_7ec.selector=="year"){return _7f1(_7ef["dateFormatItem-yyyy"]||"yyyy",_7f0);}var _7f2;if(_7ec.selector!="date"){_7f2=_7ec.timePattern||_7ef["timeFormat-"+_7ee];if(_7f2){str.push(_7f1(_7f2,_7f0));}}if(_7ec.selector!="time"){_7f2=_7ec.datePattern||_7ef["dateFormat-"+_7ee];if(_7f2){str.push(_7f1(_7f2,_7f0));}}return str.length==1?str[0]:_7ef["dateTimeFormat-"+_7ee].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_7f3,key){return str[key];});};_7db.regexp=function(_7f4){return _7db._parseInfo(_7f4).regexp;};_7db._parseInfo=function(_7f5){_7f5=_7f5||{};var _7f6=i18n.normalizeLocale(_7f5.locale),_7f7=_7db._getGregorianBundle(_7f6),_7f8=_7f5.formatLength||"short",_7f9=_7f5.datePattern||_7f7["dateFormat-"+_7f8],_7fa=_7f5.timePattern||_7f7["timeFormat-"+_7f8],_7fb;if(_7f5.selector=="date"){_7fb=_7f9;}else{if(_7f5.selector=="time"){_7fb=_7fa;}else{_7fb=_7f7["dateTimeFormat-"+_7f8].replace(/\{(\d+)\}/g,function(_7fc,key){return [_7fa,_7f9][key];});}}var _7fd=[],re=_7f1(_7fb,lang.hitch(this,_7fe,_7fd,_7f7,_7f5));return {regexp:re,tokens:_7fd,bundle:_7f7};};_7db.parse=function(_7ff,_800){var _801=/[\u200E\u200F\u202A\u202E]/g,info=_7db._parseInfo(_800),_802=info.tokens,_803=info.bundle,re=new RegExp("^"+info.regexp.replace(_801,"")+"$",info.strict?"":"i"),_804=re.exec(_7ff&&_7ff.replace(_801,""));if(!_804){return null;}var _805=["abbr","wide","narrow"],_806=[1970,0,1,0,0,0,0],amPm="",_807=_7d5.every(_804,function(v,i){if(!i){return true;}var _808=_802[i-1],l=_808.length,c=_808.charAt(0);switch(c){case "y":if(l!=2&&_800.strict){_806[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_809=year.substring(0,2)*100,_80a=Math.min(Number(year.substring(2,4))+20,99);_806[0]=(v<_80a)?_809+v:_809-100+v;}else{if(_800.strict){return false;}_806[0]=v;}}break;case "M":case "L":if(l>2){var _80b=_803["months-"+(c=="L"?"standAlone":"format")+"-"+_805[l-3]].concat();if(!_800.strict){v=v.replace(".","").toLowerCase();_80b=_7d5.map(_80b,function(s){return s.replace(".","").toLowerCase();});}v=_7d5.indexOf(_80b,v);if(v==-1){return false;}}else{v--;}_806[1]=v;break;case "E":case "e":case "c":var days=_803["days-"+(c=="c"?"standAlone":"format")+"-"+_805[l-3]].concat();if(!_800.strict){v=v.toLowerCase();days=_7d5.map(days,function(d){return d.toLowerCase();});}v=_7d5.indexOf(days,v);if(v==-1){return false;}break;case "D":_806[1]=0;case "d":_806[2]=v;break;case "a":var am=_800.am||_803["dayPeriods-format-wide-am"],pm=_800.pm||_803["dayPeriods-format-wide-pm"];if(!_800.strict){var _80c=/\./g;v=v.replace(_80c,"").toLowerCase();am=am.replace(_80c,"").toLowerCase();pm=pm.replace(_80c,"").toLowerCase();}if(_800.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_806[3]=v;break;case "m":_806[4]=v;break;case "s":_806[5]=v;break;case "S":_806[6]=v;}return true;});var _80d=+_806[3];if(amPm==="p"&&_80d<12){_806[3]=_80d+12;}else{if(amPm==="a"&&_80d==12){_806[3]=0;}}var _80e=new Date(_806[0],_806[1],_806[2],_806[3],_806[4],_806[5],_806[6]);if(_800.strict){_80e.setFullYear(_806[0]);}var _80f=_802.join(""),_810=_80f.indexOf("d")!=-1,_811=_80f.indexOf("M")!=-1;if(!_807||(_811&&_80e.getMonth()>_806[1])||(_810&&_80e.getDate()>_806[2])){return null;}if((_811&&_80e.getMonth()<_806[1])||(_810&&_80e.getDate()<_806[2])){_80e=date.add(_80e,"hour",1);}return _80e;};function _7f1(_812,_813,_814,_815){var _816=function(x){return x;};_813=_813||_816;_814=_814||_816;_815=_815||_816;var _817=_812.match(/(''|[^'])+/g),_818=_812.charAt(0)=="'";_7d5.forEach(_817,function(_819,i){if(!_819){_817[i]="";}else{_817[i]=(_818?_814:_813)(_819.replace(/''/g,"'"));_818=!_818;}});return _815(_817.join(""));};function _7fe(_81a,_81b,_81c,_81d){_81d=_7d7.escapeString(_81d);if(!_81c.strict){_81d=_81d.replace(" a"," ?a");}return _81d.replace(/([a-z])\1*/ig,function(_81e){var s,c=_81e.charAt(0),l=_81e.length,p2="",p3="";if(_81c.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":case "L":s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":case "e":case "c":s=".+?";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_81c.am||_81b["dayPeriods-format-wide-am"],pm=_81c.pm||_81b["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_81c.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_81a){_81a.push(_81e);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _81f=[];_7db.addCustomFormats=function(_820,_821){_81f.push({pkg:_820,name:_821});};_7db._getGregorianBundle=function(_822){var _823={};_7d5.forEach(_81f,function(desc){var _824=i18n.getLocalization(desc.pkg,desc.name,_822);_823=lang.mixin(_823,_824);},this);return _823;};_7db.addCustomFormats(_7da.id.replace(/\/date\/locale$/,".cldr"),"gregorian");_7db.getNames=function(item,type,_825,_826){var _827,_828=_7db._getGregorianBundle(_826),_829=[item,_825,type];if(_825=="standAlone"){var key=_829.join("-");_827=_828[key];if(_827[0]==1){_827=undefined;}}_829[1]="format";return (_827||_828[_829.join("-")]).concat();};_7db.isWeekend=function(_82a,_82b){var _82c=_7d6.getWeekend(_82b),day=(_82a||new Date()).getDay();if(_82c.end<_82c.start){_82c.end+=7;if(day<_82c.start){day+=7;}}return day>=_82c.start&&day<=_82c.end;};_7db._getDayOfYear=function(_82d){return date.difference(new Date(_82d.getFullYear(),0,1,_82d.getHours()),_82d)+1;};_7db._getWeekOfYear=function(_82e,_82f){if(arguments.length==1){_82f=0;}var _830=new Date(_82e.getFullYear(),0,1).getDay(),adj=(_830-_82f+7)%7,week=Math.floor((_7db._getDayOfYear(_82e)+adj-1)/7);if(_830==_82f){week++;}return week;};return _7db;});},"dijit/form/VerticalRule":function(){define(["dojo/_base/declare","./HorizontalRule"],function(_831,_832){return _831("dijit.form.VerticalRule",_832,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_833,_834,_835,_836,_837,dom,_838,_839,lang,_83a,when,_83b,_83c){var _83d=_837("dijit.form._FormSelectWidget",_83c,{multiple:false,options:null,store:null,query:null,queryOptions:null,labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_83e){var opts=this.options||[];if(_83e==null){return opts;}if(lang.isArray(_83e)){return _833.map(_83e,"return this.getOptions(item);",this);}if(lang.isString(_83e)){_83e={value:_83e};}if(lang.isObject(_83e)){if(!_833.some(opts,function(_83f,idx){for(var a in _83e){if(!(a in _83f)||_83f[a]!=_83e[a]){return false;}}_83e=idx;return true;})){_83e=-1;}}if(_83e>=0&&_83e<opts.length){return opts[_83e];}return null;},addOption:function(_840){_833.forEach(lang.isArray(_840)?_840:[_840],function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_841){var _842=this.getOptions(lang.isArray(_841)?_841:[_841]);_833.forEach(_842,function(_843){if(_843){this.options=_833.filter(this.options,function(node){return (node.value!==_843.value||node.label!==_843.label);});this._removeOptionItem(_843);}},this);this._loadChildren();},updateOption:function(_844){_833.forEach(lang.isArray(_844)?_844:[_844],function(i){var _845=this.getOptions({value:i.value}),k;if(_845){for(k in i){_845[k]=i[k];}}},this);this._loadChildren();},setStore:function(_846,_847,_848){var _849=this.store;_848=_848||{};if(_849!==_846){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_846.get){lang.mixin(_846,{_oldAPI:true,get:function(id){var _84a=new _834();this.fetchItemByIdentity({identity:id,onItem:function(_84b){_84a.resolve(_84b);},onError:function(_84c){_84a.reject(_84c);}});return _84a.promise;},query:function(_84d,_84e){var _84f=new _834(function(){if(_850.abort){_850.abort();}});_84f.total=new _834();var _850=this.fetch(lang.mixin({query:_84d,onBegin:function(_851){_84f.total.resolve(_851);},onComplete:function(_852){_84f.resolve(_852);},onError:function(_853){_84f.reject(_853);}},_84e));return new _83b(_84f);}});if(_846.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_835.after(_846,"onNew",lang.hitch(this,"_onNewItem"),true),_835.after(_846,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_835.after(_846,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_846);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}if(_848.query){this._set("query",_848.query);this._set("queryOptions",_848.queryOptions);}if(_846){this._loadingStore=true;this.onLoadDeferred=new _834();this._queryRes=_846.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_854){if(this.sortByLabel&&!_848.sort&&_854.length){if(_846.getValue){_854.sort(_836.createSortFunction([{attribute:_846.getLabelAttributes(_854[0])[0]}],_846));}else{var _855=this.labelAttr;_854.sort(function(a,b){return a[_855]>b[_855]?1:b[_855]>a[_855]?-1:0;});}}if(_848.onFetch){_854=_848.onFetch.call(this,_854,_848);}_833.forEach(_854,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._observeHandle=this._queryRes.observe(lang.hitch(this,function(_856,_857,_858){if(_857==_858){this._onSetItem(_856);}else{if(_857!=-1){this._onDeleteItem(_856);}if(_858!=-1){this._onNewItem(_856);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_847);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_854);}this.onLoadDeferred.resolve(true);this.onSetStore();}),function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);});}return _849;},_setValueAttr:function(_859,_85a){if(!this._onChangeActive){_85a=null;}if(this._loadingStore){this._pendingValue=_859;return;}if(_859==null){return;}if(lang.isArray(_859)){_859=_833.map(_859,function(_85b){return lang.isObject(_85b)?_85b:{value:_85b};});}else{if(lang.isObject(_859)){_859=[_859];}else{_859=[{value:_859}];}}_859=_833.filter(this.getOptions(_859),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_859[0]||!_859[0].value)&&!!opts.length){_859[0]=opts[0];}_833.forEach(opts,function(opt){opt.selected=_833.some(_859,function(v){return v.value===opt.value;});});var val=_833.map(_859,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_833.map(_859,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_85a]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_833.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_85c){this.set("value",this.getOptions(typeof _85c=="string"?{label:_85c}:_85c));},_loadChildren:function(){if(this._loadingStore){return;}_833.forEach(this._getChildren(),function(_85d){_85d.destroyRecursive();});_833.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_833.forEach(this._getChildren(),function(_85e){var _85f=_833.some(val,function(v){return _85e.option&&(v===_85e.option.value);});if(_85f&&!self.multiple){self.focusedChild=_85e;}_838.toggle(_85e.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_85f);_85e.domNode.setAttribute("aria-selected",_85f?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_833.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _833.map(_833.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_860){if(!_860||!_860.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _861=this.store;this.removeOption({value:_861.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _862=this.store,_863=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_862.getLabel(item),_864=(_863?_862.getIdentity(item):null);return {value:_864,label:_863,item:item};},_addOptionForItem:function(item){var _865=this.store;if(_865.isItemLoaded&&!_865.isItemLoaded(item)){_865.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _866=this._getOptionObjForItem(item);this.addOption(_866);},constructor:function(_867){this._oValue=(_867||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_83a("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_839._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_835.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _868=this.store;if(_868&&(_868.getIdentity||_868.getFeatures()["dojo.data.api.Identity"])){this.store=null;this.setStore(_868,this._oValue);}},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _83d;});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_869,_86a,_86b,_86c,_86d,i18n,lang,on,has,_86e,_86f,_870,_871,_872,_873,_874,_875,_876){var _877=_86a("dijit.form._SelectMenu",_870,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _878=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_869.forEach(this.parentWidget._getChildren(),function(_879){if(_879.option&&(val===_879.option.value)){_878=true;this.focusChild(_879,false);}},this);}if(!_878){this.inherited(arguments);}}});var _87a=_86a("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_86e,_86f,_874],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_876,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _877({id:this.id+"_menu",parentWidget:this});_86c.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_87b){if(!_87b.value&&!_87b.label){return new _872({ownerDocument:this.ownerDocument});}else{var _87c=lang.hitch(this,"_setValueAttr",_87b);var item=new _871({option:_87b,label:_87b.label||this.emptyLabel,onClick:_87c,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_87b.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_87d){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_87d));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_87e){if(_87e){this.set("value",_87e.option);}},_getFirst:function(){var _87f=this._getChildren();return _87f.length?_87f[0]:null;},_getLast:function(){var _880=this._getChildren();return _880.length?_880[_880.length-1]:null;},childSelector:function(node){var node=_875.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_881,_882){if(item){this.focusChild(item);}},_loadChildren:function(_883){if(_883===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_869.forEach(this._getChildren(),function(_884){_884.destroyRecursive();});var item=new _871({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_885){this.inherited(arguments);_86b.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_886){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_887){this._set("required",_887);this.focusNode.setAttribute("aria-required",_887);this._refreshState();},_setOptionsAttr:function(_888){this._isLoaded=false;this._set("options",_888);},_setDisplay:function(_889){var lbl=_889||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_88a){var _88b=this.disabled||this.isValid(_88a);this._set("state",_88b?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_88b?"false":"true");var _88c=_88b?"":this._missingMsg;if(_88c&&this.focused&&this._hasBeenBlurred){_873.show(_88c,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_873.hide(this.domNode);}this._set("message",_88c);return _88b;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_873.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");if(has("ie")<9){this.defer(function(){try{var s=domStyle.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _88d=this.domNode.getElementsByTagName("INPUT");if(_88d){for(var i=0;i<_88d.length;i++){_88d[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setStyleAttr:function(_88e){this.inherited(arguments);_86c.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_88f){this._loadChildren(true);this._isLoaded=true;_88f();},destroy:function(_890){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_890);delete this.dropDown;}this.inherited(arguments);},_onFocus:function(){this.validate(true);},_onBlur:function(){_873.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_87a=_86a("dijit.form.Select",_87a,{_setDisplay:function(_891){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_87a._Menu=_877;function _892(_893){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_893,evt));}else{this.inherited(_893,arguments);}};};_87a.prototype._onContainerKeydown=_892("_onContainerKeydown");_87a.prototype._onContainerKeypress=_892("_onContainerKeypress");return _87a;});},"dijit/_editor/range":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang"],function(_894,_895,lang){var _896={getIndex:function(node,_897){var ret=[],retR=[];var _898=node;var _899,n;while(node!=_897){var i=0;_899=node.parentNode;while((n=_899.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-_899.childNodes.length);node=_899;}if(ret.length>0&&_898.nodeType==3){n=_898.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=_898.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};},getNode:function(_89a,_89b){if(!lang.isArray(_89a)||_89a.length==0){return _89b;}var node=_89b;_894.every(_89a,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;},getCommonAncestor:function(n1,n2,root){root=root||n1.ownerDocument.body;var _89c=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_89c(n1);var n2as=_89c(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;},getAncestor:function(node,_89d,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(_89d.test(name)){return node;}node=node.parentNode;}return null;},BlockTagNames:/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/,getBlockAncestor:function(node,_89e,root){root=root||node.ownerDocument.body;_89e=_89e||_896.BlockTagNames;var _89f=null,_8a0;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!_89f&&_89e.test(name)){_89f=node;}if(!_8a0&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_8a0=node;}node=node.parentNode;}return {blockNode:_89f,blockContainer:_8a0||node.ownerDocument.body};},atBeginningOfContainer:function(_8a1,node,_8a2){var _8a3=false;var _8a4=(_8a2==0);if(!_8a4&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_8a2))){_8a4=true;}}if(_8a4){var _8a5=node;_8a3=true;while(_8a5&&_8a5!==_8a1){if(_8a5.previousSibling){_8a3=false;break;}_8a5=_8a5.parentNode;}}return _8a3;},atEndOfContainer:function(_8a6,node,_8a7){var _8a8=false;var _8a9=(_8a7==(node.length||node.childNodes.length));if(!_8a9&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_8a7))){_8a9=true;}}if(_8a9){var _8aa=node;_8a8=true;while(_8aa&&_8aa!==_8a6){if(_8aa.nextSibling){_8a8=false;break;}_8aa=_8aa.parentNode;}}return _8a8;},adjacentNoneTextNode:function(_8ab,next){var node=_8ab;var len=(0-_8ab.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];},create:function(win){win=win||window;if(win.getSelection){return win.document.createRange();}else{return new _8ac();}},getSelection:function(_8ad,_8ae){if(_8ad.getSelection){return _8ad.getSelection();}else{var s=new ie.selection(_8ad);if(!_8ae){s._getCurrentSelection();}return s;}}};if(!window.getSelection){var ie=_896.ie={cachedSelection:{},selection:function(_8af){this._ranges=[];this.addRange=function(r,_8b0){this._ranges.push(r);if(!_8b0){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _8b1=function(){var r=_8af.document.selection.createRange();var type=_8af.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _8ac(ie.decomposeControlRange(r));}else{return new _8ac(ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_8b1();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(_8b2){var _8b3=_8b2.item(0),_8b4=_8b2.item(_8b2.length-1);var _8b5=_8b3.parentNode,_8b6=_8b4.parentNode;var _8b7=_896.getIndex(_8b3,_8b5).o[0];var _8b8=_896.getIndex(_8b4,_8b6).o[0]+1;return [_8b5,_8b7,_8b6,_8b8];},getEndPoint:function(_8b9,end){var _8ba=_8b9.duplicate();_8ba.collapse(!end);var _8bb="EndTo"+(end?"End":"Start");var _8bc=_8ba.parentElement();var _8bd,_8be,_8bf;if(_8bc.childNodes.length>0){_894.every(_8bc.childNodes,function(node,i){var _8c0;if(node.nodeType!=3){_8ba.moveToElementText(node);if(_8ba.compareEndPoints(_8bb,_8b9)>0){if(_8bf&&_8bf.nodeType==3){_8bd=_8bf;_8c0=true;}else{_8bd=_8bc;_8be=i;return false;}}else{if(i==_8bc.childNodes.length-1){_8bd=_8bc;_8be=_8bc.childNodes.length;return false;}}}else{if(i==_8bc.childNodes.length-1){_8bd=node;_8c0=true;}}if(_8c0&&_8bd){var _8c1=_896.adjacentNoneTextNode(_8bd)[0];if(_8c1){_8bd=_8c1.nextSibling;}else{_8bd=_8bc.firstChild;}var _8c2=_896.adjacentNoneTextNode(_8bd);_8c1=_8c2[0];var _8c3=_8c2[1];if(_8c1){_8ba.moveToElementText(_8c1);_8ba.collapse(false);}else{_8ba.moveToElementText(_8bc);}_8ba.setEndPoint(_8bb,_8b9);_8be=_8ba.text.length-_8c3;return false;}_8bf=node;return true;});}else{_8bd=_8bc;_8be=0;}if(!end&&_8bd.nodeType==1&&_8be==_8bd.childNodes.length){var _8c4=_8bd.nextSibling;if(_8c4&&_8c4.nodeType==3){_8bd=_8c4;_8be=0;}}return [_8bd,_8be];},setEndPoint:function(_8c5,_8c6,_8c7){var _8c8=_8c5.duplicate(),node,len;if(_8c6.nodeType!=3){if(_8c7>0){node=_8c6.childNodes[_8c7-1];if(node){if(node.nodeType==3){_8c6=node;_8c7=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_8c6=node.nextSibling;_8c7=0;}else{_8c8.moveToElementText(node.nextSibling?node:_8c6);var _8c9=node.parentNode;var _8ca=_8c9.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_8c8.collapse(false);_8c9.removeChild(_8ca);}}}}else{_8c8.moveToElementText(_8c6);_8c8.collapse(true);}}if(_8c6.nodeType==3){var _8cb=_896.adjacentNoneTextNode(_8c6);var _8cc=_8cb[0];len=_8cb[1];if(_8cc){_8c8.moveToElementText(_8cc);_8c8.collapse(false);if(_8cc.contentEditable!="inherit"){len++;}}else{_8c8.moveToElementText(_8c6.parentNode);_8c8.collapse(true);_8c8.move("character",1);_8c8.move("character",-1);}_8c7+=len;if(_8c7>0){if(_8c8.move("character",_8c7)!=_8c7){console.error("Error when moving!");}}}return _8c8;},decomposeTextRange:function(_8cd){var _8ce=ie.getEndPoint(_8cd);var _8cf=_8ce[0],_8d0=_8ce[1];var _8d1=_8ce[0],_8d2=_8ce[1];if(_8cd.htmlText.length){if(_8cd.htmlText==_8cd.text){_8d2=_8d0+_8cd.text.length;}else{_8ce=ie.getEndPoint(_8cd,true);_8d1=_8ce[0],_8d2=_8ce[1];}}return [_8cf,_8d0,_8d1,_8d2];},setRange:function(_8d3,_8d4,_8d5,_8d6,_8d7,_8d8){var _8d9=ie.setEndPoint(_8d3,_8d4,_8d5);_8d3.setEndPoint("StartToStart",_8d9);if(!_8d8){var end=ie.setEndPoint(_8d3,_8d6,_8d7);}_8d3.setEndPoint("EndToEnd",end||_8d9);return _8d3;}};var _8ac=_896.W3CRange=_895(null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_896.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_8da){_8da=parseInt(_8da);if(this.startContainer===node&&this.startOffset==_8da){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_8da;if(!this.endContainer){this.setEnd(node,_8da);}else{this._updateInternal();}},setEnd:function(node,_8db){_8db=parseInt(_8db);if(this.endContainer===node&&this.endOffset==_8db){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_8db;if(!this.startContainer){this.setStart(node,_8db);}else{this._updateInternal();}},setStartAfter:function(node,_8dc){this._setPoint("setStart",node,_8dc,1);},setStartBefore:function(node,_8dd){this._setPoint("setStart",node,_8dd,0);},setEndAfter:function(node,_8de){this._setPoint("setEnd",node,_8de,1);},setEndBefore:function(node,_8df){this._setPoint("setEnd",node,_8df,0);},_setPoint:function(what,node,_8e0,ext){var _8e1=_896.getIndex(node,node.parentNode).o;this[what](node.parentNode,_8e1.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _8ac([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}lang.setObject("dijit.range",_896);return _896;});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_8e2,_8e3,_8e4,keys,lang,on,_8e5,_8e6){return _8e3("dijit._KeyNavMixin",_8e6,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_8e4.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _8e7=this._keyNavCodes={};_8e7[keys.HOME]=lang.hitch(this,"focusFirstChild");_8e7[keys.END]=lang.hitch(this,"focusLastChild");_8e7[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_8e7[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_8e7[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_8e7[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_8e8=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_8e8,"focusin"),function(evt){self._onChildFocus(_8e5.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_8e9,last){if(!_8e9){return;}if(this.focusedChild&&_8e9!==this.focusedChild){this._onChildBlur(this.focusedChild);}_8e9.set("tabIndex",this.tabIndex);_8e9.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_8e4.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_8e4.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_8ea){if(_8ea&&_8ea!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_8ea.set("tabIndex",this.tabIndex);this.lastFocused=_8ea;this._set("focusedChild",_8ea);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_8eb,_8ec){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_8ed){var _8ee=item.domNode,text=item.label||(_8ee.focusNode?_8ee.focusNode.label:"")||_8ee.innerText||_8ee.textContent||"",_8ef=text.replace(/^\s+/,"").substr(0,_8ed.length).toLowerCase();return (!!_8ed.length&&_8ef==_8ed)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey||evt.metaKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<keys.SPACE||evt.ctrlKey||evt.altKey||evt.metaKey||(evt.charCode==keys.SPACE&&this._searchTimer)){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_8f0){var _8f1=null,_8f2,_8f3=0,_8f4=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_8f0;var _8f5=/^(.)\1*$/.test(this._searchString);var _8f6=_8f5?1:this._searchString.length;_8f2=this._searchString.substr(0,_8f6);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _8f7=this.focusedChild||null;if(_8f6==1||!_8f7){_8f7=this._getNextFocusableChild(_8f7,1);if(!_8f7){return;}}var stop=_8f7;do{var rc=this._keyboardSearchCompare(_8f7,_8f2);if(!!rc&&_8f3++==0){_8f1=_8f7;}if(rc==-1){_8f3=-1;break;}_8f7=this._getNextFocusableChild(_8f7,1);}while(_8f7!=stop);});_8f4();this.onKeyboardSearch(_8f1,evt,_8f2,_8f3);},_onChildBlur:function(){},_getNextFocusableChild:function(_8f8,dir){var _8f9=_8f8;do{if(!_8f8){_8f8=this[dir>0?"_getFirst":"_getLast"]();if(!_8f8){break;}}else{_8f8=this._getNext(_8f8,dir);}if(_8f8!=null&&_8f8!=_8f9&&_8f8.isFocusable()){return _8f8;}}while(_8f8!=_8f9);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_8fa,dir){if(_8fa){_8fa=_8fa.domNode;while(_8fa){_8fa=_8fa[dir<0?"previousSibling":"nextSibling"];if(_8fa&&"getAttribute" in _8fa){var w=_8e5.byNode(_8fa);if(w){return w;}}}}return null;}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_8fb,lang,when){var _8fc=function(_8fd){if(!_8fd){return _8fd;}var _8fe=!!_8fd.then;if(_8fe){_8fd=lang.delegate(_8fd);}function _8ff(_900){_8fd[_900]=function(){var args=arguments;var _901=when(_8fd,function(_902){Array.prototype.unshift.call(args,_902);return _8fc(_8fb[_900].apply(_8fb,args));});if(_900!=="forEach"||_8fe){return _901;}};};_8ff("forEach");_8ff("filter");_8ff("map");if(_8fd.total==null){_8fd.total=when(_8fd,function(_903){return _903.length;});}return _8fd;};lang.setObject("dojo.store.util.QueryResults",_8fc);return _8fc;});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_904,on,_905){return _904("dijit.form._ListBase",null,{selected:null,_listConnect:function(_906,_907){var self=this;return self.own(on(self.containerNode,on.selector(function(_908,_909,_90a){return _908.parentNode==_90a;},_906),function(evt){if(!/^touch/.test(evt.type)){evt.preventDefault();}self[_907](evt,this);}));},selectFirstNode:function(){var _90b=this.containerNode.firstChild;while(_90b&&_90b.style.display=="none"){_90b=_90b.nextSibling;}this._setSelectedAttr(_90b,true);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last,true);},selectNextNode:function(){var _90c=this.selected;if(!_90c){this.selectFirstNode();}else{var next=_90c.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next,true);}}},selectPreviousNode:function(){var _90d=this.selected;if(!_90d){this.selectLastNode();}else{var prev=_90d.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev,true);}}},_setSelectedAttr:function(node,_90e){if(this.selected!=node){var _90f=this.selected;if(_90f){this.onDeselect(_90f);}if(node){if(_90e){_905.scrollIntoView(node);}this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_910,lang,dom){var _911=lang.getObject("dojo.dnd",true);_911.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_911._uniqueId=0;_911.getUniqueId=function(){var id;do{id=_910._scopeName+"Unique"+(++_911._uniqueId);}while(dom.byId(id));return id;};_911._empty={};_911.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " a button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _911;});},"dijit/CalendarLite":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./a11yclick","./hccss"],function(_912,_913,_914,date,_915,_916,dom,_917,lang,on,has,_918,_919,_91a,_91b){var _91c=_913("dijit.CalendarLite",[_919,_91a],{templateString:_91b,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\" scope=\"col\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),_setSummaryAttr:"gridNode",baseClass:"dijitCalendar",_isValidDate:function(_91d){return _91d&&!isNaN(_91d)&&typeof _91d=="object"&&_91d.toString()!=this.constructor.prototype.value.toString();},_getValueAttr:function(){var _91e=this._get("value");if(_91e&&!isNaN(_91e)){var _91f=new this.dateClassObj(_91e);_91f.setHours(0,0,0,0);if(_91f.getDate()<_91e.getDate()){_91f=this.dateModule.add(_91f,"hour",1);}return _91f;}else{return null;}},_setValueAttr:function(_920,_921){if(typeof _920=="string"){_920=_916.fromISOString(_920);}_920=this._patchDate(_920);if(this._isValidDate(_920)&&!this.isDisabledDate(_920,this.lang)){this._set("value",_920);this.set("currentFocus",_920);this._markSelectedDates([_920]);if(this._created&&(_921||typeof _921=="undefined")){this.onChange(this.get("value"));}}else{this._set("value",null);this._markSelectedDates([]);}},_patchDate:function(_922){if(_922){_922=new this.dateClassObj(_922);_922.setHours(1,0,0,0);}return _922;},_setText:function(node,text){while(node.firstChild){node.removeChild(node.firstChild);}node.appendChild(node.ownerDocument.createTextNode(text));},_populateGrid:function(){var _923=new this.dateClassObj(this.currentFocus);_923.setDate(1);var _924=_923.getDay(),_925=this.dateModule.getDaysInMonth(_923),_926=this.dateModule.getDaysInMonth(this.dateModule.add(_923,"month",-1)),_927=new this.dateClassObj(),_928=_914.getFirstDayOfWeek(this.lang);if(_928>_924){_928-=7;}if(!this.summary){var _929=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_923);this.gridNode.setAttribute("summary",_929[_923.getMonth()]);}this._date2cell={};_912.forEach(this.dateCells,function(_92a,idx){var i=idx+_928;var date=new this.dateClassObj(_923),_92b,_92c="dijitCalendar",adj=0;if(i<_924){_92b=_926-_924+i+1;adj=-1;_92c+="Previous";}else{if(i>=(_924+_925)){_92b=i-_924-_925+1;adj=1;_92c+="Next";}else{_92b=i-_924+1;_92c+="Current";}}if(adj){date=this.dateModule.add(date,"month",adj);}date.setDate(_92b);if(!this.dateModule.compare(date,_927,"date")){_92c="dijitCalendarCurrentDate "+_92c;}if(this.isDisabledDate(date,this.lang)){_92c="dijitCalendarDisabledDate "+_92c;_92a.setAttribute("aria-disabled","true");}else{_92c="dijitCalendarEnabledDate "+_92c;_92a.removeAttribute("aria-disabled");_92a.setAttribute("aria-selected","false");}var _92d=this.getClassForDate(date,this.lang);if(_92d){_92c=_92d+" "+_92c;}_92a.className=_92c+"Month dijitCalendarDateTemplate";var _92e=date.valueOf();this._date2cell[_92e]=_92a;_92a.dijitDateValue=_92e;this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());},this);},_populateControls:function(){var _92f=new this.dateClassObj(this.currentFocus);_92f.setDate(1);this.monthWidget.set("month",_92f);var y=_92f.getFullYear()-1;var d=new this.dateClassObj();_912.forEach(["previous","current","next"],function(name){d.setFullYear(y++);this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));},this);},goToToday:function(){this.set("value",new this.dateClassObj());},constructor:function(_930){this.dateModule=_930.datePackage?lang.getObject(_930.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_930.datePackage?lang.getObject(_930.datePackage+".locale",false):_915;},_createMonthWidget:function(){return _91c._MonthWidget({id:this.id+"_mddb",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){var d=this.dowTemplateString,_931=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_932=_914.getFirstDayOfWeek(this.lang);this.dayCellsHtml=_918.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){return _931[_932++%7];});var r=_918.substitute(this.weekTemplateString,{d:this.dateTemplateString});this.dateRowsHtml=[r,r,r,r,r,r].join("");this.dateCells=[];this.dateLabels=[];this.inherited(arguments);dom.setSelectable(this.domNode,false);var _933=new this.dateClassObj(this.currentFocus);this.monthWidget=this._createMonthWidget();this.set("currentFocus",_933,false);},postCreate:function(){this.inherited(arguments);this._connectControls();},_connectControls:function(){var _934=lang.hitch(this,function(_935,part,_936){return on(this[_935],"click",lang.hitch(this,function(){this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_936));}));});this.own(_934("incrementMonth","month",1),_934("decrementMonth","month",-1),_934("nextYearLabelNode","year",1),_934("previousYearLabelNode","year",-1));},_setCurrentFocusAttr:function(date,_937){var _938=this.currentFocus,_939=this._getNodeByDate(_938);date=this._patchDate(date);this._set("currentFocus",date);if(!this._date2cell||this.dateModule.difference(_938,date,"month")!=0){this._populateGrid();this._populateControls();this._markSelectedDates([this.value]);}var _93a=this._getNodeByDate(date);_93a.setAttribute("tabIndex",this.tabIndex);if(this.focused||_937){_93a.focus();}if(_939&&_939!=_93a){if(has("webkit")){_939.setAttribute("tabIndex","-1");}else{_939.removeAttribute("tabIndex");}}},focus:function(){this._setCurrentFocusAttr(this.currentFocus,true);},_onDayClick:function(evt){evt.stopPropagation();evt.preventDefault();for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){}if(node&&!_917.contains(node,"dijitCalendarDisabledDate")){this.set("value",node.dijitDateValue);}},_getNodeByDate:function(_93b){_93b=this._patchDate(_93b);return _93b&&this._date2cell?this._date2cell[_93b.valueOf()]:null;},_markSelectedDates:function(_93c){function mark(_93d,cell){_917.toggle(cell,"dijitCalendarSelectedDate",_93d);cell.setAttribute("aria-selected",_93d?"true":"false");};_912.forEach(this._selectedCells||[],lang.partial(mark,false));this._selectedCells=_912.filter(_912.map(_93c,this._getNodeByDate,this),function(n){return n;});_912.forEach(this._selectedCells,lang.partial(mark,true));},onChange:function(){},isDisabledDate:function(){},getClassForDate:function(){}});_91c._MonthWidget=_913("dijit.CalendarLite._MonthWidget",_919,{_setMonthAttr:function(_93e){var _93f=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_93e),_940=(has("ie")==6?"":"<div class='dijitSpacer'>"+_912.map(_93f,function(s){return "<div>"+s+"</div>";}).join("")+"</div>");this.domNode.innerHTML=_940+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_93f[_93e.getMonth()]+"</div>";}});return _91c;});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_941,_942,_943,_944){return _941("dijit.CheckedMenuItem",_943,{baseClass:"dijitMenuItem dijitCheckedMenuItem",templateString:_944,checked:false,_setCheckedAttr:function(_945){this.domNode.setAttribute("aria-checked",_945?"true":"false");this._set("checked",_945);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/form/VerticalRuleLabels":function(){define(["dojo/_base/declare","./HorizontalRuleLabels"],function(_946,_947){return _946("dijit.form.VerticalRuleLabels",_947,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){return 100-pos;},_isHorizontal:false});});},"dijit/Declaration":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser","dojo/query","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/NodeList-dom"],function(_948,_949,_94a,lang,_94b,_94c,_94d,_94e,_94f){return _94a("dijit.Declaration",_94d,{_noScript:true,stopParser:true,widgetClass:"",defaults:null,mixins:[],buildRendering:function(){var src=this.srcNodeRef.parentNode.removeChild(this.srcNodeRef),_950=_94c("> script[type='dojo/method']",src).orphan(),_951=_94c("> script[type='dojo/connect']",src).orphan(),_952=_94c("> script[type='dojo/aspect']",src).orphan(),_953=src.nodeName;var _954=this.defaults||{};_948.forEach(_950,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_94b._functionFromScript(s,"data-dojo-");if(evt){_954[evt]=func;}else{_952.push(s);}});if(this.mixins.length){this.mixins=_948.map(this.mixins,function(name){return lang.getObject(name);});}else{this.mixins=[_94d,_94e,_94f];}_954._skipNodeCache=true;_954.templateString="<"+_953+" class='"+src.className+"'"+" data-dojo-attach-point='"+(src.getAttribute("data-dojo-attach-point")||src.getAttribute("dojoAttachPoint")||"")+"' data-dojo-attach-event='"+(src.getAttribute("data-dojo-attach-event")||src.getAttribute("dojoAttachEvent")||"")+"' >"+src.innerHTML.replace(/\%7B/g,"{").replace(/\%7D/g,"}")+"</"+_953+">";var wc=_94a(this.widgetClass,this.mixins,_954);_948.forEach(_952,function(s){var _955=s.getAttribute("data-dojo-advice")||"after",_956=s.getAttribute("data-dojo-method")||"postscript",func=_94b._functionFromScript(s);_949.after(wc.prototype,_956,func,true);});_948.forEach(_951,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_94b._functionFromScript(s);_949.after(wc.prototype,evt,func,true);});}});});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_957,dom,_958,_959,_95a,_95b){return _957("dijit.MenuSeparator",[_958,_959,_95a],{templateString:_95b,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_95c,_95d,_95e,keys,_95f,_960,_961,_962){return _95c("dijit.form._ComboBoxMenu",[_95f,_960,_962,_961],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_95d.add(this.previousButton,"dijitMenuItemRtl");_95d.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_95d.add(node,"dijitMenuItemHover");},onUnhover:function(node){_95d.remove(node,"dijitMenuItemHover");},onSelect:function(node){_95d.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_95d.remove(node,"dijitMenuItemSelected");},_page:function(up){var _963=0;var _964=this.domNode.scrollTop;var _965=_95e.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_963<_965){var _966=this.getHighlightedOption();if(up){if(!_966.previousSibling||_966.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_966.nextSibling||_966.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _967=this.domNode.scrollTop;_963+=(_967-_964)*(up?-1:1);_964=_967;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","dojo/i18n!./nls/common"],function(_968,_969,_96a,_96b,_96c,dom,_96d,_96e,_96f,fx,i18n,keys,lang,on,_970,has,_971,_972,_973,_974,_975,_976,_977,_978,_979,_97a,_97b,_97c,_97d){var _97e=_96b("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_977,_979,_97a,_978],{templateString:_97d,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_975.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _97f=i18n.getLocalization("dijit","common");lang.mixin(this,_97f);this.inherited(arguments);},postCreate:function(){_96f.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_96a.after(this,"onExecute",lang.hitch(this,"hide"),true);_96a.after(this,"onCancel",lang.hitch(this,"hide"),true);this._modalconnects=[];},onLoad:function(){this._size();this._position();if(this.autofocus&&_980.isTop(this)){this._getFocusItems(this.domNode);_974.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems(this.domNode);_974.focus(this._firstFocusItem);},_endDrag:function(){var _981=_96e.position(this.domNode),_982=_971.getBox(this.ownerDocument);_981.y=Math.min(Math.max(_981.y,0),(_982.h-_981.h));_981.x=Math.min(Math.max(_981.x,0),(_982.w-_981.w));this._relativePosition=_981;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_973:_972)(node,{handle:this.titleBar});_96a.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_96d.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_969.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this._checkIfSingleChild();if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}else{_96f.set(this.containerNode,{width:"auto",height:"auto"});}var bb=_96e.position(this.domNode);var _983=_971.getBox(this.ownerDocument);_983.w*=this.maxRatio;_983.h*=this.maxRatio;if(bb.w>=_983.w||bb.h>=_983.h){var _984=_96e.position(this.containerNode),w=Math.min(bb.w,_983.w)-(bb.w-_984.w),h=Math.min(bb.h,_983.h)-(bb.h-_984.h);if(this._singleChild&&this._singleChild.resize){if(typeof this._singleChildOriginalStyle=="undefined"){this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;}this._singleChild.resize({w:w,h:h});}else{_96f.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});}}else{if(this._singleChild&&this._singleChild.resize){this._singleChild.resize();}}},_position:function(){if(!_96d.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_985=_971.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_96e.position(node),l=Math.floor(_985.l+(p?p.x:(_985.w-bb.w)/2)),t=Math.floor(_985.t+(p?p.y:(_985.h-bb.h)/2));_96f.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems(this.domNode);var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_974.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_974.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_980.hide(this);}var win=_971.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_96f.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this._size();this._position();var _986;this._fadeInDeferred=new _96c(lang.hitch(this,function(){_986.stop();delete this._fadeInDeferred;}));var _987=this._fadeInDeferred.promise;_986=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_980.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_980.isTop(this)){this._getFocusItems(this.domNode);_974.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _987;},hide:function(){if(!this._alreadyInitialized||!this.open){return;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _988;this._fadeOutDeferred=new _96c(lang.hitch(this,function(){_988.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _989=this._fadeOutDeferred.promise;_988=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_980.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _989;},resize:function(){if(this.domNode.style.display!="none"){this._size();if(!has("touch")){this._position();}}},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_980.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_97e=_96b("dijit._DialogBase",_97e,{_setTitleAttr:function(_98a){this._set("title",_98a);this.titleNode.innerHTML=_98a;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_98b){if(this._created&&this.textDir!=_98b){this._set("textDir",_98b);this.set("title",this.title);}}});}var _98c=_96b("dijit.Dialog",[_97c,_97e],{});_98c._DialogBase=_97e;var _980=_98c._DialogLevelManager={_beginZIndex:950,show:function(_98d,_98e){ds[ds.length-1].focus=_974.curNode;var _98f=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_98c._DialogLevelManager._beginZIndex;_96f.set(_98d.domNode,"zIndex",_98f);_97b.show(_98e,_98f-1);ds.push({dialog:_98d,underlayAttrs:_98e,zIndex:_98f});},hide:function(_990){if(ds[ds.length-1].dialog==_990){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_97b.hide();}else{_97b.show(pd.underlayAttrs,pd.zIndex-1);}if(_990.refocus){var _991=pd.focus;if(pd.dialog&&(!_991||!dom.isDescendant(_991,pd.dialog.domNode))){pd.dialog._getFocusItems(pd.dialog.domNode);_991=pd.dialog._firstFocusItem;}if(_991){try{_991.focus();}catch(e){}}}}else{var idx=_969.indexOf(_969.map(ds,function(elem){return elem.dialog;}),_990);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_992){return ds[ds.length-1].dialog==_992;}};var ds=_98c._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_974.watch("curNode",function(attr,_993,node){var _994=ds[ds.length-1].dialog;if(node&&_994&&!_994._fadeOutDeferred&&node.ownerDocument==_994.ownerDocument){do{if(node==_994.domNode||_96d.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_994.focus();}});if(has("dijit-legacy-requires")){_970(0,function(){var _995=["dijit/TooltipDialog"];_968(_995);});}return _98c;});},"dijit/form/MultiSelect":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/has","dojo/query","./_FormValueWidget"],function(_996,_997,_998,has,_999,_99a){var _99b=_997("dijit.form.MultiSelect"+(has("dojo-bidi")?"_NoBidi":""),_99a,{size:7,baseClass:"dijitMultiSelect",templateString:"<select multiple='true' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_99c){_99c.getSelected().forEach(function(n){this.containerNode.appendChild(n);this.domNode.scrollTop=this.domNode.offsetHeight;var _99d=_99c.domNode.scrollTop;_99c.domNode.scrollTop=0;_99c.domNode.scrollTop=_99d;},this);this._set("value",this.get("value"));},getSelected:function(){return _999("option",this.containerNode).filter(function(n){return n.selected;});},_getValueAttr:function(){return _996.map(this.getSelected(),function(n){return n.value;});},multiple:true,_setValueAttr:function(_99e,_99f){_999("option",this.containerNode).forEach(function(n){n.selected=(_996.indexOf(_99e,n.value)!=-1);});this.inherited(arguments);},invertSelection:function(_9a0){var val=[];_999("option",this.containerNode).forEach(function(n){if(!n.selected){val.push(n.value);}});this._setValueAttr(val,!(_9a0===false||_9a0==null));},_onChange:function(){this._handleOnChange(this.get("value"),true);},resize:function(size){if(size){_998.setMarginBox(this.domNode,size);}},postCreate:function(){this._set("value",this.get("value"));this.inherited(arguments);}});if(has("dojo-bidi")){_99b=_997("dijit.form.MultiSelect",_99b,{addSelected:function(_9a1){_9a1.getSelected().forEach(function(n){n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);},this);this.inherited(arguments);},_setTextDirAttr:function(_9a2){if((this.textDir!=_9a2||!this._created)&&this.enforceTextDirWithUcc){this._set("textDir",_9a2);_999("option",this.containerNode).forEach(function(_9a3){if(!this._created&&_9a3.value===_9a3.text){_9a3.value=_9a3.text;}_9a3.text=this.enforceTextDirWithUcc(_9a3,_9a3.originalText||_9a3.text);},this);}}});}return _99b;});},"dijit/form/_DateTimeTextBox":function(){define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_9a4,_9a5,_9a6,lang,_9a7,_9a8,_9a9){new Date("X");var _9aa=_9a6("dijit.form._DateTimeTextBox",[_9a7,_9a8],{templateString:_9a9,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_9a4.regexp,datePackage:"",postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _9ab=this._isInvalidDate(val1);var _9ac=this._isInvalidDate(val2);return _9ab?(_9ac?0:-1):(_9ac?1:date.compare(val1,val2,this._selector));},autoWidth:true,format:function(_9ad,_9ae){if(!_9ad){return "";}return this.dateLocaleModule.format(_9ad,_9ae);},"parse":function(_9af,_9b0){return this.dateLocaleModule.parse(_9af,_9b0)||(this._isEmpty(_9af)?null:undefined);},serialize:function(val,_9b1){if(val.toGregorian){val=val.toGregorian();}return _9a5.toISOString(val,_9b1);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_9b2){this.dateModule=_9b2.datePackage?lang.getObject(_9b2.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_9b2.datePackage?lang.getObject(_9b2.datePackage+".locale",false):_9a4;this._set("pattern",this.dateLocaleModule.regexp);this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_9b3){_9b3.selector=this._selector;_9b3.fullYear=true;var _9b4=_9a5.fromISOString;if(typeof _9b3.min=="string"){_9b3.min=_9b4(_9b3.min);}if(typeof _9b3.max=="string"){_9b3.max=_9b4(_9b3.max);}this.inherited(arguments);},_isInvalidDate:function(_9b5){return !_9b5||isNaN(_9b5)||typeof _9b5!="object"||_9b5.toString()==this._invalidDate;},_setValueAttr:function(_9b6,_9b7,_9b8){if(_9b6!==undefined){if(typeof _9b6=="string"){_9b6=_9a5.fromISOString(_9b6);}if(this._isInvalidDate(_9b6)){_9b6=null;}if(_9b6 instanceof Date&&!(this.dateClassObj instanceof Date)){_9b6=new this.dateClassObj(_9b6);}}this.inherited(arguments);if(this.value instanceof Date){this.filterString="";}if(this.dropDown){this.dropDown.set("value",_9b6,false);}},_set:function(attr,_9b9){var _9ba=this._get("value");if(attr=="value"&&_9ba instanceof Date&&this.compare(_9b9,_9ba)==0){return;}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this._set("dropDownDefaultValue",val);},openDropDown:function(_9bb){if(this.dropDown){this.dropDown.destroy();}var _9bc=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9bd=this,_9be=this.get("value");this.dropDown=new _9bc({onChange:function(_9bf){_9bd.set("value",_9bf,true);},id:this.id+"_popup",dir:_9bd.dir,lang:_9bd.lang,value:_9be,textDir:_9bd.textDir,currentFocus:!this._isInvalidDate(_9be)?_9be:this.dropDownDefaultValue,constraints:_9bd.constraints,filterString:_9bd.filterString,datePackage:_9bd.params.datePackage,isDisabledDate:function(date){return !_9bd.rangeCheck(date,_9bd.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_9c0,_9c1){this._setValueAttr(this.parse(_9c0,this.constraints),_9c1,_9c0);}});return _9aa;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_9c2,_9c3){return _9c2("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _9c4=this.checked;this._set("checked",!_9c4);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_9c4);return ret;},_setCheckedAttr:function(_9c5,_9c6){this._set("checked",_9c5);var node=this.focusNode||this.domNode;if(this._created){if(_9c3.get(node,"checked")!=!!_9c5){_9c3.set(node,"checked",!!_9c5);}}node.setAttribute(this._aria_attr,String(_9c5));this._handleOnChange(_9c5,_9c6);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/Calendar":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_9c7,date,_9c8,_9c9,_9ca,_9cb,_9cc,keys,lang,on,has,_9cd,_9ce,_9cf,_9d0,_9d1){var _9d2=_9c9("dijit.Calendar",[_9cd,_9ce,_9cf],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_9d3){_9cc.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_9d3);},_createMonthWidget:function(){return new _9d2._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")),on(this.dateRowsNode,"mouseover",lang.hitch(this,"_onDayMouseOver")),on(this.dateRowsNode,"mouseout",lang.hitch(this,"_onDayMouseOut")),on(this.dateRowsNode,"mousedown",lang.hitch(this,"_onDayMouseDown")),on(this.dateRowsNode,"mouseup",lang.hitch(this,"_onDayMouseUp")));},_onMonthSelect:function(_9d4){var date=new this.dateClassObj(this.currentFocus);date.setDate(1);date.setMonth(_9d4);var _9d5=this.dateModule.getDaysInMonth(date);var _9d6=this.currentFocus.getDate();date.setDate(Math.min(_9d6,_9d5));this._setCurrentFocusAttr(date);},_onDayMouseOver:function(evt){var node=_9cb.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_9cb.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_9cb.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_9cb.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_9cb.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_9cb.contains(node,"dijitCalendarDisabledDate")){_9cb.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_9cb.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _9d7=-1,_9d8,_9d9=this.currentFocus;switch(evt.keyCode){case keys.RIGHT_ARROW:_9d7=1;case keys.LEFT_ARROW:_9d8="day";if(!this.isLeftToRight()){_9d7*=-1;}break;case keys.DOWN_ARROW:_9d7=1;case keys.UP_ARROW:_9d8="week";break;case keys.PAGE_DOWN:_9d7=1;case keys.PAGE_UP:_9d8=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_9d9=this.dateModule.add(_9d9,"month",1);_9d8="day";case keys.HOME:_9d9=new this.dateClassObj(_9d9);_9d9.setDate(1);break;default:return true;}if(_9d8){_9d9=this.dateModule.add(_9d9,_9d8,_9d7);}this._setCurrentFocusAttr(_9d9);return false;},_onKeyDown:function(evt){if(!this.handleKey(evt)){evt.stopPropagation();evt.preventDefault();}},onValueSelected:function(){},onChange:function(_9da){this.onValueSelected(_9da);},getClassForDate:function(){}});_9d2._MonthDropDownButton=_9c9("dijit.Calendar._MonthDropDownButton",_9d1,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _9d2._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_9db){var _9dc=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_9db);this.dropDown.set("months",_9dc);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_9dc[_9db.getMonth()]+"</div>";}});_9d2._MonthDropDown=_9c9("dijit.Calendar._MonthDropDown",[_9ce,_9d0],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_9dd){this.domNode.innerHTML=_9c7.map(_9dd,function(_9de,idx){return _9de?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+_9de+"</div>":"";}).join("");},_onClick:function(evt){this.onChange(_9ca.get(evt.target,"month"));},onChange:function(){},_onMenuHover:function(evt){_9cb.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");}});return _9d2;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_9df,dojo,_9e0,_9e1,_9e2,dom,_9e3,geom,_9e4,_9e5){if(!dojo.isAsync){_9e4(0,function(){var _9e6=["./fx/Toggler"];_9e5(_9e6);});}var _9e7=dojo.fx={};var _9e8={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _9e9=function(_9ea){this._index=-1;this._animations=_9ea||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_9e0.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_9e9.prototype=new _9df();lang.extend(_9e9,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_9e1.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_9e1.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_9eb,_9ec){if(!this._current){this._current=this._animations[this._index=0];}if(!_9ec&&this._current.status()=="playing"){return this;}var _9ed=_9e1.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_9ee=_9e1.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_9ef=_9e1.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_9ed.remove();_9ee.remove();_9ef.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_9e1.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_9e1.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_9e1.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_9f0,_9f1){this.pause();var _9f2=this.duration*_9f0;this._current=null;_9e0.some(this._animations,function(a){if(a.duration<=_9f2){this._current=a;return true;}_9f2-=a.duration;return false;});if(this._current){this._current.gotoPercent(_9f2/this._current.duration,_9f1);}return this;},stop:function(_9f3){if(this._current){if(_9f3){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_9e1.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_9e9,_9e8);_9e7.chain=function(_9f4){return new _9e9(_9f4);};var _9f5=function(_9f6){this._animations=_9f6||[];this._connects=[];this._finished=0;this.duration=0;_9e0.forEach(_9f6,function(a){var _9f7=a.duration;if(a.delay){_9f7+=a.delay;}if(this.duration<_9f7){this.duration=_9f7;}this._connects.push(_9e1.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _9e2.Animation({curve:[0,1],duration:this.duration});var self=this;_9e0.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_9e1.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_9f5,{_doAction:function(_9f8,args){_9e0.forEach(this._animations,function(a){a[_9f8].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_9f9,args){var t=this._pseudoAnimation;t[_9f9].apply(t,args);},play:function(_9fa,_9fb){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_9fc,_9fd){var ms=this.duration*_9fc;_9e0.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_9fd);});this._call("gotoPercent",arguments);return this;},stop:function(_9fe){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_9e0.forEach(this._connects,function(_9ff){_9ff.remove();});}});lang.extend(_9f5,_9e8);_9e7.combine=function(_a00){return new _9f5(_a00);};_9e7.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9e2.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _a01=_9e3.get(node,"height");return Math.max(_a01,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_9e1.after(anim,"onStop",fini,true);_9e1.after(anim,"onEnd",fini,true);return anim;};_9e7.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9e2.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_9e1.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_9e1.after(anim,"onStop",fini,true);_9e1.after(anim,"onEnd",fini,true);return anim;};_9e7.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_9e3.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_9e2.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_9e1.after(anim,"beforeBegin",init,true);return anim;};return _9e7;});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_a02,a11y){return _a02("dijit._DialogMixin",null,{execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _a03=a11y._getTabNavigable(this.containerNode);this._firstFocusItem=_a03.lowest||_a03.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_a03.last||_a03.highest||this._firstFocusItem;}});});},"dijit/Tree":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/promise/all","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/errors/create","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./a11yclick","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","./_KeyNavMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector","dojo/query!css2"],function(_a04,_a05,_a06,_a07,_a08,_a09,all,dom,_a0a,_a0b,_a0c,_a0d,_a0e,has,_a0f,keys,lang,on,_a10,_a11,when,_a12,_a13,_a14,_a15,_a16,_a17,_a18,_a19,_a1a,_a1b,_a1c,_a1d,_a1e,_a1f,_a20){function _a21(d){return lang.delegate(d.promise||d,{addCallback:function(_a22){this.then(_a22);},addErrback:function(_a23){this.otherwise(_a23);}});};var _a24=_a08("dijit._TreeNode",[_a16,_a17,_a18,_a19,_a1a],{item:null,isTreeNode:true,label:"",_setLabelAttr:function(val){this.labelNode[this.labelType=="html"?"innerHTML":"innerText" in this.labelNode?"innerText":"textContent"]=val;this._set("label",val);},labelType:"text",isExpandable:null,isExpanded:false,state:"NotLoaded",templateString:_a1c,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_a25){var _a26=(Math.max(_a25,0)*this.tree._nodePixelIndent)+"px";_a0c.set(this.domNode,"backgroundPosition",_a26+" 0px");_a0c.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_a26);_a04.forEach(this.getChildren(),function(_a27){_a27.set("indent",_a25+1);});this._set("indent",_a25);},markProcessing:function(){this.state="Loading";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,_a28=tree.model;if(tree._v10Compat&&item===_a28.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");this.tree._startPaint(true);},_applyClassAndStyle:function(item,_a29,_a2a){var _a2b="_"+_a29+"Class";var _a2c=_a29+"Node";var _a2d=this[_a2b];this[_a2b]=this.tree["get"+_a2a+"Class"](item,this.isExpanded);_a0a.replace(this[_a2c],this[_a2b]||"",_a2d||"");_a0c.set(this[_a2c],this.tree["get"+_a2a+"Style"](item,this.isExpanded)||{});},_updateLayout:function(){var _a2e=this.getParent();if(!_a2e||!_a2e.rowNode||_a2e.rowNode.style.display=="none"){_a0a.add(this.domNode,"dijitTreeIsRoot");}else{_a0a.toggle(this.domNode,"dijitTreeIsLast",!this.getNextSibling());}},_setExpando:function(_a2f){var _a30=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_a31=["*","-","+","*"],idx=_a2f?0:(this.isExpandable?(this.isExpanded?1:2):3);_a0a.replace(this.expandoNode,_a30[idx],_a30);this.expandoNodeText.innerHTML=_a31[idx];},expand:function(){if(this._expandDeferred){return _a21(this._expandDeferred);}if(this._collapseDeferred){this._collapseDeferred.cancel();delete this._collapseDeferred;}this.isExpanded=true;this.labelNode.setAttribute("aria-expanded","true");if(this.tree.showRoot||this!==this.tree.rootNode){this.containerNode.setAttribute("role","group");}_a0a.add(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","true");}var _a32=_a0e.wipeIn({node:this.containerNode,duration:_a15.defaultDuration});var def=(this._expandDeferred=new _a09(function(){_a32.stop();}));_a05.after(_a32,"onEnd",function(){def.resolve(true);},true);_a32.play();return _a21(def);},collapse:function(){if(this._collapseDeferred){return _a21(this._collapseDeferred);}if(this._expandDeferred){this._expandDeferred.cancel();delete this._expandDeferred;}this.isExpanded=false;this.labelNode.setAttribute("aria-expanded","false");if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","false");}_a0a.remove(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);var _a33=_a0e.wipeOut({node:this.containerNode,duration:_a15.defaultDuration});var def=(this._collapseDeferred=new _a09(function(){_a33.stop();}));_a05.after(_a33,"onEnd",function(){def.resolve(true);},true);_a33.play();return _a21(def);},indent:0,setChildItems:function(_a34){var tree=this.tree,_a35=tree.model,defs=[];var _a36=this.getChildren();_a04.forEach(_a36,function(_a37){_a18.prototype.removeChild.call(this,_a37);},this);this.defer(function(){_a04.forEach(_a36,function(node){if(!node._destroyed&&!node.getParent()){tree.dndController.removeTreeNode(node);function _a38(node){var id=_a35.getIdentity(node.item),ary=tree._itemNodesMap[id];if(ary.length==1){delete tree._itemNodesMap[id];}else{var _a39=_a04.indexOf(ary,node);if(_a39!=-1){ary.splice(_a39,1);}}_a04.forEach(node.getChildren(),_a38);};_a38(node);if(tree.persist){var _a3a=_a04.map(node.getTreePath(),function(item){return tree.model.getIdentity(item);}).join("/");for(var path in tree._openedNodes){if(path.substr(0,_a3a.length)==_a3a){delete tree._openedNodes[path];}}tree._saveExpandedNodes();}node.destroyRecursive();}});});this.state="Loaded";if(_a34&&_a34.length>0){this.isExpandable=true;_a04.forEach(_a34,function(item){var id=_a35.getIdentity(item),_a3b=tree._itemNodesMap[id],node;if(_a3b){for(var i=0;i<_a3b.length;i++){if(_a3b[i]&&!_a3b[i].getParent()){node=_a3b[i];node.set("indent",this.indent+1);break;}}}if(!node){node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_a35.mayHaveChildren(item),label:tree.getLabel(item),labelType:(tree.model&&tree.model.labelType)||"text",tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});if(_a3b){_a3b.push(node);}else{tree._itemNodesMap[id]=[node];}}this.addChild(node);if(this.tree.autoExpand||this.tree._state(node)){defs.push(tree._expandNode(node));}},this);_a04.forEach(this.getChildren(),function(_a3c){_a3c._updateLayout();});}else{this.isExpandable=false;}if(this._setExpando){this._setExpando(false);}this._updateItemClasses(this.item);var def=all(defs);this.tree._startPaint(def);return _a21(def);},getTreePath:function(){var node=this;var path=[];while(node&&node!==this.tree.rootNode){path.unshift(node.item);node=node.getParent();}path.unshift(this.tree.rootNode.item);return path;},getIdentity:function(){return this.tree.model.getIdentity(this.item);},removeChild:function(node){this.inherited(arguments);var _a3d=this.getChildren();if(_a3d.length==0){this.isExpandable=false;this.collapse();}_a04.forEach(_a3d,function(_a3e){_a3e._updateLayout();});},makeExpandable:function(){this.isExpandable=true;this._setExpando(false);},setSelected:function(_a3f){this.labelNode.setAttribute("aria-selected",_a3f?"true":"false");_a0a.toggle(this.rowNode,"dijitTreeRowSelected",_a3f);},focus:function(){_a13.focus(this.focusNode);}});if(has("dojo-bidi")){_a24.extend({_setTextDirAttr:function(_a40){if(_a40&&((this.textDir!=_a40)||!this._created)){this._set("textDir",_a40);this.applyTextDir(this.labelNode);_a04.forEach(this.getChildren(),function(_a41){_a41.set("textDir",_a40);},this);}}});}var Tree=_a08("dijit.Tree",[_a16,_a1b,_a17,_a1a],{baseClass:"dijitTree",store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_a1d,persist:false,autoExpand:false,dndController:_a20,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_a42,_a43){_a10.publish(this.id,lang.mixin({tree:this,event:_a42},_a43||{}));},postMixInProperties:function(){this.tree=this;if(this.autoExpand){this.persist=false;}this._itemNodesMap={};if(!this.cookieName&&this.id){this.cookieName=this.id+"SaveStateCookie";}this.expandChildrenDeferred=new _a09();this.pendingCommandsPromise=this.expandChildrenDeferred.promise;this.inherited(arguments);},postCreate:function(){this._initState();var self=this;this.own(on(this.containerNode,on.selector(".dijitTreeNode",_a11.enter),function(evt){self._onNodeMouseEnter(_a14.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeNode",_a11.leave),function(evt){self._onNodeMouseLeave(_a14.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_a12.press),function(evt){self._onNodePress(_a14.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_a12),function(evt){self._onClick(_a14.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow","dblclick"),function(evt){self._onDblClick(_a14.getEnclosingWidget(this),evt);}));if(!this.model){this._store2model();}this.own(_a05.after(this.model,"onChange",lang.hitch(this,"_onItemChange"),true),_a05.after(this.model,"onChildrenChange",lang.hitch(this,"_onItemChildrenChange"),true),_a05.after(this.model,"onDelete",lang.hitch(this,"_onItemDelete"),true));this.inherited(arguments);if(this.dndController){if(lang.isString(this.dndController)){this.dndController=lang.getObject(this.dndController);}var _a44={};for(var i=0;i<this.dndParams.length;i++){if(this[this.dndParams[i]]){_a44[this.dndParams[i]]=this[this.dndParams[i]];}}this.dndController=new this.dndController(this,_a44);}this._load();this.onLoadDeferred=_a21(this.pendingCommandsPromise);this.onLoadDeferred.then(lang.hitch(this,"onLoad"));},_store2model:function(){this._v10Compat=true;_a0f.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");var _a45={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};if(this.params.mayHaveChildren){_a45.mayHaveChildren=lang.hitch(this,"mayHaveChildren");}if(this.params.getItemChildren){_a45.getChildren=lang.hitch(this,function(item,_a46,_a47){this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_a46,_a47);});}this.model=new _a1f(_a45);this.showRoot=Boolean(this.label);},onLoad:function(){},_load:function(){this.model.getRoot(lang.hitch(this,function(item){var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),labelType:this.model.labelType||"text",textDir:this.textDir,indent:this.showRoot?0:-1}));if(!this.showRoot){rn.rowNode.style.display="none";this.domNode.setAttribute("role","presentation");this.domNode.removeAttribute("aria-expanded");this.domNode.removeAttribute("aria-multiselectable");if(this["aria-label"]){rn.containerNode.setAttribute("aria-label",this["aria-label"]);this.domNode.removeAttribute("aria-label");}else{if(this["aria-labelledby"]){rn.containerNode.setAttribute("aria-labelledby",this["aria-labelledby"]);this.domNode.removeAttribute("aria-labelledby");}}rn.labelNode.setAttribute("role","presentation");rn.containerNode.setAttribute("role","tree");rn.containerNode.setAttribute("aria-expanded","true");rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);}else{this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);this.rootLoadingIndicator.style.display="none";}this.containerNode.appendChild(rn.domNode);var _a48=this.model.getIdentity(item);if(this._itemNodesMap[_a48]){this._itemNodesMap[_a48].push(rn);}else{this._itemNodesMap[_a48]=[rn];}rn._updateLayout();this._expandNode(rn).then(lang.hitch(this,function(){this.rootLoadingIndicator.style.display="none";this.expandChildrenDeferred.resolve(true);}));}),lang.hitch(this,function(err){console.error(this,": error loading root: ",err);}));},getNodesByItem:function(item){if(!item){return [];}var _a49=lang.isString(item)?item:this.model.getIdentity(item);return [].concat(this._itemNodesMap[_a49]);},_setSelectedItemAttr:function(item){this.set("selectedItems",[item]);},_setSelectedItemsAttr:function(_a4a){var tree=this;return this.pendingCommandsPromise=this.pendingCommandsPromise.always(lang.hitch(this,function(){var _a4b=_a04.map(_a4a,function(item){return (!item||lang.isString(item))?item:tree.model.getIdentity(item);});var _a4c=[];_a04.forEach(_a4b,function(id){_a4c=_a4c.concat(tree._itemNodesMap[id]||[]);});this.set("selectedNodes",_a4c);}));},_setPathAttr:function(path){if(path.length){return _a21(this.set("paths",[path]).then(function(_a4d){return _a4d[0];}));}else{return _a21(this.set("paths",[]).then(function(_a4e){return _a4e[0];}));}},_setPathsAttr:function(_a4f){var tree=this;function _a50(path,_a51){var _a52=path.shift();var _a53=_a04.filter(_a51,function(node){return node.getIdentity()==_a52;})[0];if(!!_a53){if(path.length){return tree._expandNode(_a53).then(function(){return _a50(path,_a53.getChildren());});}else{return _a53;}}else{throw new Tree.PathError("Could not expand path at "+_a52);}};return _a21(this.pendingCommandsPromise=this.pendingCommandsPromise.always(function(){return all(_a04.map(_a4f,function(path){path=_a04.map(path,function(item){return lang.isString(item)?item:tree.model.getIdentity(item);});if(path.length){return _a50(path,[tree.rootNode]);}else{throw new Tree.PathError("Empty path");}}));}).then(function setNodes(_a54){tree.set("selectedNodes",_a54);return tree.paths;}));},_setSelectedNodeAttr:function(node){this.set("selectedNodes",[node]);},_setSelectedNodesAttr:function(_a55){this.dndController.setSelection(_a55);},expandAll:function(){var _a56=this;function _a57(node){return _a56._expandNode(node).then(function(){var _a58=_a04.filter(node.getChildren()||[],function(node){return node.isExpandable;});return all(_a04.map(_a58,_a57));});};return _a21(_a57(this.rootNode));},collapseAll:function(){var _a59=this;function _a5a(node){var _a5b=_a04.filter(node.getChildren()||[],function(node){return node.isExpandable;}),defs=all(_a04.map(_a5b,_a5a));if(!node.isExpanded||(node==_a59.rootNode&&!_a59.showRoot)){return defs;}else{return defs.then(function(){return _a59._collapseNode(node);});}};return _a21(_a5a(this.rootNode));},mayHaveChildren:function(){},getItemChildren:function(){},getLabel:function(item){return this.model.getLabel(item);},getIconClass:function(item,_a5c){return (!item||this.model.mayHaveChildren(item))?(_a5c?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";},getLabelClass:function(){},getRowClass:function(){},getIconStyle:function(){},getLabelStyle:function(){},getRowStyle:function(){},getTooltip:function(){return "";},_onDownArrow:function(evt,node){var _a5d=this._getNext(node);if(_a5d&&_a5d.isTreeNode){this.focusNode(_a5d);}},_onUpArrow:function(evt,node){var _a5e=node.getPreviousSibling();if(_a5e){node=_a5e;while(node.isExpandable&&node.isExpanded&&node.hasChildren()){var _a5f=node.getChildren();node=_a5f[_a5f.length-1];}}else{var _a60=node.getParent();if(!(!this.showRoot&&_a60===this.rootNode)){node=_a60;}}if(node&&node.isTreeNode){this.focusNode(node);}},_onRightArrow:function(evt,node){if(node.isExpandable&&!node.isExpanded){this._expandNode(node);}else{if(node.hasChildren()){node=node.getChildren()[0];if(node&&node.isTreeNode){this.focusNode(node);}}}},_onLeftArrow:function(evt,node){if(node.isExpandable&&node.isExpanded){this._collapseNode(node);}else{var _a61=node.getParent();if(_a61&&_a61.isTreeNode&&!(!this.showRoot&&_a61===this.rootNode)){this.focusNode(_a61);}}},focusLastChild:function(){var node=this._getLast();if(node&&node.isTreeNode){this.focusNode(node);}},_getFirst:function(){return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];},_getLast:function(){var node=this.rootNode;while(node.isExpanded){var c=node.getChildren();if(!c.length){break;}node=c[c.length-1];}return node;},_getNext:function(node){if(node.isExpandable&&node.isExpanded&&node.hasChildren()){return node.getChildren()[0];}else{while(node&&node.isTreeNode){var _a62=node.getNextSibling();if(_a62){return _a62;}node=node.getParent();}return null;}},childSelector:".dijitTreeRow",isExpandoNode:function(node,_a63){return dom.isDescendant(node,_a63.expandoNode)||dom.isDescendant(node,_a63.expandoNodeText);},_onNodePress:function(_a64,e){_a64.focus();},__click:function(_a65,e,_a66,func){var _a67=e.target,_a68=this.isExpandoNode(_a67,_a65);if(_a65.isExpandable&&(_a66||_a68)){this._onExpandoClick({node:_a65});}else{this._publish("execute",{item:_a65.item,node:_a65,evt:e});this[func](_a65.item,_a65,e);this.focusNode(_a65);}e.stopPropagation();e.preventDefault();},_onClick:function(_a69,e){this.__click(_a69,e,this.openOnClick,"onClick");},_onDblClick:function(_a6a,e){this.__click(_a6a,e,this.openOnDblClick,"onDblClick");},_onExpandoClick:function(_a6b){var node=_a6b.node;this.focusNode(node);if(node.isExpanded){this._collapseNode(node);}else{this._expandNode(node);}},onClick:function(){},onDblClick:function(){},onOpen:function(){},onClose:function(){},_getNextNode:function(node){_a0f.deprecated(this.declaredClass+"::_getNextNode(node) is deprecated. Use _getNext(node) instead.","","2.0");return this._getNext(node);},_getRootOrFirstNode:function(){_a0f.deprecated(this.declaredClass+"::_getRootOrFirstNode() is deprecated. Use _getFirst() instead.","","2.0");return this._getFirst();},_collapseNode:function(node){if(node._expandNodeDeferred){delete node._expandNodeDeferred;}if(node.state=="Loading"){return;}if(node.isExpanded){var ret=node.collapse();this.onClose(node.item,node);this._state(node,false);this._startPaint(ret);return ret;}},_expandNode:function(node){if(node._expandNodeDeferred){return node._expandNodeDeferred;}var _a6c=this.model,item=node.item,_a6d=this;if(!node._loadDeferred){node.markProcessing();node._loadDeferred=new _a09();_a6c.getChildren(item,function(_a6e){node.unmarkProcessing();node.setChildItems(_a6e).then(function(){node._loadDeferred.resolve(_a6e);});},function(err){console.error(_a6d,": error loading "+node.label+" children: ",err);node._loadDeferred.reject(err);});}var def=node._loadDeferred.then(lang.hitch(this,function(){var def2=node.expand();this.onOpen(node.item,node);this._state(node,true);return def2;}));this._startPaint(def);return def;},focusNode:function(node){this.focusChild(node);},_onNodeMouseEnter:function(){},_onNodeMouseLeave:function(){},_onItemChange:function(item){var _a6f=this.model,_a70=_a6f.getIdentity(item),_a71=this._itemNodesMap[_a70];if(_a71){var _a72=this.getLabel(item),_a73=this.getTooltip(item);_a04.forEach(_a71,function(node){node.set({item:item,label:_a72,tooltip:_a73});node._updateItemClasses(item);});}},_onItemChildrenChange:function(_a74,_a75){var _a76=this.model,_a77=_a76.getIdentity(_a74),_a78=this._itemNodesMap[_a77];if(_a78){_a04.forEach(_a78,function(_a79){_a79.setChildItems(_a75);});}},_onItemDelete:function(item){var _a7a=this.model,_a7b=_a7a.getIdentity(item),_a7c=this._itemNodesMap[_a7b];if(_a7c){_a04.forEach(_a7c,function(node){this.dndController.removeTreeNode(node);var _a7d=node.getParent();if(_a7d){_a7d.removeChild(node);}node.destroyRecursive();},this);delete this._itemNodesMap[_a7b];}},_initState:function(){this._openedNodes={};if(this.persist&&this.cookieName){var oreo=_a07(this.cookieName);if(oreo){_a04.forEach(oreo.split(","),function(item){this._openedNodes[item]=true;},this);}}},_state:function(node,_a7e){if(!this.persist){return false;}var path=_a04.map(node.getTreePath(),function(item){return this.model.getIdentity(item);},this).join("/");if(arguments.length===1){return this._openedNodes[path];}else{if(_a7e){this._openedNodes[path]=true;}else{delete this._openedNodes[path];}this._saveExpandedNodes();}},_saveExpandedNodes:function(){if(this.persist&&this.cookieName){var ary=[];for(var id in this._openedNodes){ary.push(id);}_a07(this.cookieName,ary.join(","),{expires:365});}},destroy:function(){if(this._curSearch){this._curSearch.timer.remove();delete this._curSearch;}if(this.rootNode){this.rootNode.destroyRecursive();}if(this.dndController&&!lang.isString(this.dndController)){this.dndController.destroy();}this.rootNode=null;this.inherited(arguments);},destroyRecursive:function(){this.destroy();},resize:function(_a7f){if(_a7f){_a0b.setMarginBox(this.domNode,_a7f);}this._nodePixelIndent=_a0b.position(this.tree.indentDetector).w||this._nodePixelIndent;this.expandChildrenDeferred.then(lang.hitch(this,function(){this.rootNode.set("indent",this.showRoot?0:-1);this._adjustWidths();}));},_outstandingPaintOperations:0,_startPaint:function(p){this._outstandingPaintOperations++;if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}var oc=lang.hitch(this,function(){this._outstandingPaintOperations--;if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){this._adjustWidthsTimer=this.defer("_adjustWidths");}});when(p,oc,oc);},_adjustWidths:function(){if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}this.containerNode.style.width="auto";this.containerNode.style.width=this.domNode.scrollWidth>this.domNode.offsetWidth?"auto":"100%";},_createTreeNode:function(args){return new _a24(args);},focus:function(){if(this.lastFocusedChild){this.focusNode(this.lastFocusedChild);}else{this.focusFirstChild();}}});if(has("dojo-bidi")){Tree.extend({_setTextDirAttr:function(_a80){if(_a80&&this.textDir!=_a80){this._set("textDir",_a80);this.rootNode.set("textDir",_a80);}}});}Tree.PathError=_a0d("TreePathError");Tree._TreeNode=_a24;return Tree;});},"dijit/form/HorizontalSlider":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","dojo/on","../_base/manager","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_a81,_a82,move,fx,_a83,_a84,keys,lang,has,_a85,_a86,_a87,_a88,on,_a89,_a8a,_a8b,_a8c,_a8d,_a8e,_a8f){var _a90=_a82("dijit.form._SliderMover",_a86,{onMouseMove:function(e){var _a91=this.widget;var _a92=_a91._abspos;if(!_a92){_a92=_a91._abspos=_a83.position(_a91.sliderBarContainer,true);_a91._setPixelValue_=lang.hitch(_a91,"_setPixelValue");_a91._isReversed_=_a91._isReversed();}var _a93=e[_a91._mousePixelCoord]-_a92[_a91._startingPixelCoord];_a91._setPixelValue_(_a91._isReversed_?(_a92[_a91._pixelCount]-_a93):_a93,_a92[_a91._pixelCount],false);},destroy:function(e){_a86.prototype.destroy.apply(this,arguments);var _a94=this.widget;_a94._abspos=null;_a94._setValueAttr(_a94.value,true);}});var _a95=_a82("dijit.form.HorizontalSlider",[_a8d,_a8e],{templateString:_a8f,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_a89.defaultDuration,_setIdAttr:"",_setNameAttr:"valueNode",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyDown:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.keyCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}e.stopPropagation();e.preventDefault();},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){_a8a.focus(this.sliderHandle);}e.stopPropagation();e.preventDefault();},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}_a8a.focus(this.sliderHandle);e.stopPropagation();e.preventDefault();var _a96=_a83.position(this.sliderBarContainer,true);var _a97=e[this._mousePixelCoord]-_a96[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_a96[this._pixelCount]-_a97):_a97,_a96[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_a98,_a99,_a9a){if(this.disabled||this.readOnly){return;}var _a9b=this.discreteValues;if(_a9b<=1||_a9b==Infinity){_a9b=_a99;}_a9b--;var _a9c=_a99/_a9b;var _a9d=Math.round(_a98/_a9c);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_a9d/_a9b+this.minimum,this.maximum),this.minimum),_a9a);},_setValueAttr:function(_a9e,_a9f){this._set("value",_a9e);this.valueNode.value=_a9e;this.focusNode.setAttribute("aria-valuenow",_a9e);this.inherited(arguments);var _aa0=(_a9e-this.minimum)/(this.maximum-this.minimum);var _aa1=(this._descending===false)?this.remainingBar:this.progressBar;var _aa2=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_a9f&&this.slideDuration>0&&_aa1.style[this._progressPixelSize]){var _aa3=this;var _aa4={};var _aa5=parseFloat(_aa1.style[this._progressPixelSize]);var _aa6=this.slideDuration*(_aa0-_aa5/100);if(_aa6==0){return;}if(_aa6<0){_aa6=0-_aa6;}_aa4[this._progressPixelSize]={start:_aa5,end:_aa0*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_aa1,duration:_aa6,onAnimate:function(v){_aa2.style[_aa3._progressPixelSize]=(100-parseFloat(v[_aa3._progressPixelSize]))+"%";},onEnd:function(){delete _aa3._inProgressAnim;},properties:_aa4});this._inProgressAnim.play();}else{_aa1.style[this._progressPixelSize]=(_aa0*100)+"%";_aa2.style[this._progressPixelSize]=((1-_aa0)*100)+"%";}},_bumpValue:function(_aa7,_aa8){if(this.disabled||this.readOnly){return;}var s=_a84.getComputedStyle(this.sliderBarContainer);var c=_a83.getContentBox(this.sliderBarContainer,s);var _aa9=this.discreteValues;if(_aa9<=1||_aa9==Infinity){_aa9=c[this._pixelCount];}_aa9--;var _aaa=(this.value-this.minimum)*_aa9/(this.maximum-this.minimum)+_aa7;if(_aaa<0){_aaa=0;}if(_aaa>_aa9){_aaa=_aa9;}_aaa=_aaa*(this.maximum-this.minimum)/_aa9+this.minimum;this._setValueAttr(_aaa,_aa8);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.keyCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.keyCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();this._bumpValue(evt.wheelDelta<0?-1:1,true);},startup:function(){if(this._started){return;}_a81.forEach(this.getChildren(),function(_aab){if(this[_aab.container]!=this.containerNode){this[_aab.container].appendChild(_aab.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(_aac,_aad,e){if(_aac==-1){this._setValueAttr(this.value,true);}else{this[(_aad==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var _aae=_a87("label[for=\""+this.id+"\"]");if(_aae.length){if(!_aae[0].id){_aae[0].id=this.id+"_label";}this.focusNode.setAttribute("aria-labelledby",_aae[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this.own(_a8b.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_a8b.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.own(on(this.domNode,_a88.wheel,lang.hitch(this,"_mouseWheeled")));var _aaf=_a82(_a90,{widget:this});this._movable=new _a85(this.sliderHandle,{mover:_aaf});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this.inherited(arguments);}});_a95._Mover=_a90;return _a95;});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNode\" class=\"dijitInline dijitTreeExpando\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTreeIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span data-dojo-attach-point=\"labelNode,focusNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeNodeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeydown:_onKeyDown\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\" role=\"menubar\" tabIndex=\"${tabIndex}\"\n\t ></div>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"ondijitclick:_onTitleClick, onkeydown:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\" id=\"${id}_titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<span data-dojo-attach-point=\"arrowNode\" class=\"dijitInline dijitArrowNode\" role=\"presentation\"></span\n\t\t\t><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\" aria-labelledby=\"${id}_titleBarNode\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><span data-dojo-attach-point=\"indeterminateHighContrastImage\"\n\t\t   class=\"dijitInline dijitProgressBarIndeterminateHighContrastImage\"></span\n></div>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\" aria-hidden=\"true\"\n/></span>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"./form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"./form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\" role=\"grid\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"presentation\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"ondijitclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\" role=\"button\">\n\t<span role=\"presentation\" class=\"dijitInline dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:__onClick,onkeydown:_onButtonKeyDown\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeydown:_onArrowKeyDown\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\"\n\t\t\t\trole=\"presentation\" aria-hidden=\"true\"\n\t\t\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\t/></td></tr></tbody\n></table>\n","url:dijit/templates/Tree.html":"<div role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n\t<div class=\"dijitTreeExpando dijitTreeExpandoLoading\" data-dojo-attach-point=\"rootLoadingIndicator\"></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\">\n\t</div>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"0\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"\n\t\trole=\"presentation\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode,textDirNode\"></span>\n</div>\n","url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTabButtonIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown, onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\" data-dojo-attach-point=\"gridNode\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\" scope=\"col\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\" scope=\"col\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' scope=\"col\" data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"ondijitclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_menuBtn\"\n\t\t data-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t data-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_leftBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_rightBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'\n\t\t\t data-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" role=\"presentation\" aria-hidden=\"true\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div class=\"dijitTooltipContents dijitTooltipFocusNode\" data-dojo-attach-point=\"containerNode\"></div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","*now":function(r){r(["dojo/i18n!*preload*dijit/nls/dijit-all*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dijit/dijit-all",["./main","./dijit","./ColorPalette","./Declaration","./Dialog","./DialogUnderlay","./TooltipDialog","./Editor","./_editor/plugins/FontChoice","./_editor/plugins/LinkDialog","./Menu","./MenuItem","./PopupMenuItem","./CheckedMenuItem","./MenuBar","./MenuBarItem","./PopupMenuBarItem","./MenuSeparator","./ProgressBar","./TitlePane","./Toolbar","./Tooltip","./Tree","./InlineEditBox","./form/Form","./form/Button","./form/DropDownButton","./form/ComboButton","./form/ToggleButton","./form/CheckBox","./form/RadioButton","./form/TextBox","./form/ValidationTextBox","./form/CurrencyTextBox","./form/DateTextBox","./form/TimeTextBox","./form/NumberSpinner","./form/NumberTextBox","./form/ComboBox","./form/FilteringSelect","./form/MultiSelect","./form/Select","./form/HorizontalSlider","./form/VerticalSlider","./form/HorizontalRule","./form/VerticalRule","./form/HorizontalRuleLabels","./form/VerticalRuleLabels","./form/SimpleTextarea","./form/Textarea","./layout/AccordionContainer","./layout/ContentPane","./layout/BorderContainer","./layout/LayoutContainer","./layout/LinkPane","./layout/SplitContainer","./layout/StackContainer","./layout/TabContainer"],function(_ab0){console.warn("dijit-all may include much more code than your application actually requires. We strongly recommend that you investigate a custom build or the web build tool");return _ab0;});