/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define("dojox/charting/plot2d/_PlotEvents",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./_base/sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_ie":ie,"dj_ie6":maj(ie)==6,"dj_ie7":maj(ie)==7,"dj_ie8":maj(ie)==8,"dj_ie9":maj(ie)==9,"dj_quirks":has("quirks"),"dj_iequirks":ie&&has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ff3":maj(ff)==3};_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(90,function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/string"],function(_19,_1a,_1b,lin,g,du,df,_1c){var _1d=du.merge,_1e=4,_1f=45;return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null},constructor:function(_20,_21){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_21);du.updateWithPattern(this.opt,_21,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_22,_23){this.scale=_22;this.offset=_23;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},_groupLabelWidth:function(_24,_25,_26){if(!_24.length){return 0;}if(_19.isObject(_24[0])){_24=df.map(_24,function(_27){return _27.text;});}if(_26){_24=df.map(_24,function(_28){return _19.trim(_28).length==0?"":_28.substring(0,_26)+this.trailingSymbol;},this);}var s=_24.join("<br>");return g._base._getTextBox(s,{font:_25}).w||0;},calculate:function(min,max,_29,_2a){if(this.initialized()){return this;}var o=this.opt;this.labels="labels" in o?o.labels:_2a;this.scaler=lin.buildScaler(min,max,_29,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_29,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var ta=this.chart.theme.axis,_2b=0,_2c=o.rotation%360,_2d=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_2e=_2d?g.normalizedLength(g.splitFontString(_2d).size):0,_2f=Math.abs(Math.cos(_2c*Math.PI/180)),_30=Math.abs(Math.sin(_2c*Math.PI/180));if(_2c<0){_2c+=360;}if(_2e){if(this.vertical?_2c!=0&&_2c!=180:_2c!=90&&_2c!=270){if(this.labels){_2b=this._groupLabelWidth(this.labels,_2d,o.maxLabelCharCount);}else{var _31=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}t.push(_1c.rep("9",_31));var _32=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(_32>0){t.push(".");t.push(_1c.rep("9",_32));}_2b=g._base._getTextBox(t.join(""),{font:_2d}).w;}_2b=o.maxLabelSize?Math.min(o.maxLabelSize,_2b):_2b;}else{_2b=_2e;}switch(_2c){case 0:case 90:case 180:case 270:break;default:var _33=Math.sqrt(_2b*_2b+_2e*_2e),_34=this.vertical?_2e*_2f+_2b*_30:_2b*_2f+_2e*_30;_2b=Math.min(_33,_34);break;}}this.scaler.minMinorStep=_2b+_1e;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojo/text":function(){define(["./_base/kernel","require","./has","./_base/xhr"],function(_35,_36,has,xhr){var _37;if(1){_37=function(url,_38,_39){xhr("GET",{url:url,sync:!!_38,load:_39});};}else{if(_36.getText){_37=_36.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _3a={},_3b=function(_3c){if(_3c){_3c=_3c.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _3d=_3c.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_3d){_3c=_3d[1];}}else{_3c="";}return _3c;},_3e={},_3f={},_40={dynamic:true,normalize:function(id,_41){var _42=id.split("!"),url=_42[0];return (/^\./.test(url)?_41(url):url)+(_42[1]?"!"+_42[1]:"");},load:function(id,_43,_44){var _45=id.split("!"),_46=_45.length>1,_47=_45[0],url=_43.toUrl(_45[0]),_48=_3e,_49=function(_4a){_44(_46?_3b(_4a):_4a);};if(_47 in _3a){_48=_3a[_47];}else{if(url in _43.cache){_48=_43.cache[url];}else{if(url in _3a){_48=_3a[url];}}}if(_48===_3e){if(_3f[url]){_3f[url].push(_49);}else{var _4b=_3f[url]=[_49];_37(url,!_43.async,function(_4c){_3a[_47]=_3a[url]=_4c;for(var i=0;i<_4b.length;){_4b[i++](_4c);}delete _3f[url];});}}else{_49(_48);}}};_35.cache=function(_4d,url,_4e){var key;if(typeof _4d=="string"){if(/\//.test(_4d)){key=_4d;_4e=url;}else{key=_36.toUrl(_4d.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_4d+"";_4e=url;}var val=(_4e!=undefined&&typeof _4e!="string")?_4e.value:_4e,_4f=_4e&&_4e.sanitize;if(typeof val=="string"){_3a[key]=val;return _4f?_3b(val):val;}else{if(val===null){delete _3a[key];return null;}else{if(!(key in _3a)){_37(key,true,function(_50){_3a[key]=_50;});}return _4f?_3b(_3a[key]):_3a[key];}}};return _40;});},"dojox/lang/utils":function(){define("dojox/lang/utils",["..","dojo/_base/lang"],function(_51,_52){var du=_52.getObject("lang.utils",true,_51);var _53={},_54=Object.prototype.toString;var _55=function(o){if(o){switch(_54.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _52.delegate(o);}}return o;};_52.mixin(du,{coerceType:function(_56,_57){switch(typeof _56){case "number":return Number(eval("("+_57+")"));case "string":return String(_57);case "boolean":return Boolean(eval("("+_57+")"));}return eval("("+_57+")");},updateWithObject:function(_58,_59,_5a){if(!_59){return _58;}for(var x in _58){if(x in _59&&!(x in _53)){var t=_58[x];if(t&&typeof t=="object"){du.updateWithObject(t,_59[x],_5a);}else{_58[x]=_5a?du.coerceType(t,_59[x]):_55(_59[x]);}}}return _58;},updateWithPattern:function(_5b,_5c,_5d,_5e){if(!_5c||!_5d){return _5b;}for(var x in _5d){if(x in _5c&&!(x in _53)){_5b[x]=_5e?du.coerceType(_5d[x],_5c[x]):_55(_5c[x]);}}return _5b;},merge:function(_5f,_60){if(_60){var _61=_54.call(_5f),_62=_54.call(_60),t,i,l,m;switch(_62){case "[object Array]":if(_62==_61){t=new Array(Math.max(_5f.length,_60.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_5f[i],_60[i]);}return t;}return _60.slice(0);case "[object Object]":if(_62==_61&&_5f){t=_52.delegate(_5f);for(i in _60){if(i in _5f){l=_5f[i];m=_60[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_52.clone(_60[i]);}}return t;}return _52.clone(_60);}}return _60;}});return du;});},"dojox/charting/plot2d/Pie":function(){define("dojox/charting/plot2d/Pie",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","../Element","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils"],function(_63,arr,_64,_65,_66,dc,da,g,m,df,du){var _67=0.2;return _64("dojox.charting.plot2d.Pie",[_65,_66],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",labelWiring:{}},constructor:function(_68,_69){this.opt=_63.clone(this.defaultParams);du.updateWithObject(this.opt,_69);du.updateWithPattern(this.opt,_69,this.optionalParams);this.run=null;this.dyn=[];},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(_6a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _63.delegate(dc.defaultStats);},initializeScalers:function(){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_6b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_6b.l-_6b.r)/2,ry=(dim.height-_6b.t-_6b.b)/2,r=Math.min(rx,ry),_6c="font" in this.opt?this.opt.font:t.axis.font,_6d=_6c?g.normalizedLength(g.splitFontString(_6c).size):0,_6e="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_6f=m._degToRad(this.opt.startAngle),_70=_6f,_71,_72,_73,_74,_75,_76,run=this.run.data,_77=this.events();if(typeof run[0]=="number"){_72=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_72,"<= 0")){return this;}_73=df.map(_72,"/this",df.foldl(_72,"+",0));if(this.opt.labels){_74=arr.map(_73,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_72=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_72,"<= 0")){return this;}_73=df.map(_72,"/this",df.foldl(_72,"+",0));if(this.opt.labels){_74=arr.map(_73,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}var _78=df.map(run,function(v,i){if(v===null||typeof v=="number"){return t.next("slice",[this.opt,this.run],true);}return t.next("slice",[this.opt,this.run,v],true);},this);if(this.opt.labels){_75=df.foldl1(df.map(_74,function(_79,i){var _7a=_78[i].series.font;return g._base._getTextBox(_79,{font:_7a}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_75,ry-_6d)+this.opt.labelOffset;}_76=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_76=r-this.opt.labelOffset;}var _7b={cx:_6b.l+rx,cy:_6b.t+ry,r:r};this.dyn=[];var _7c=new Array(_73.length);arr.some(_73,function(_7d,i){if(_7d<0){return false;}if(_7d==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_7e=_78[i],_7f;if(_7d>=1){_7f=this._plotFill(_7e.series.fill,dim,_6b);_7f=this._shapeFill(_7f,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});_7f=this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},_7b.r);var _80=s.createCircle(_7b).setFill(_7f).setStroke(_7e.series.stroke);this.dyn.push({fill:_7f,stroke:_7e.series.stroke});if(_77){var o={element:"slice",index:i,run:this.run,shape:_80,x:i,y:typeof v=="number"?v:v.y,cx:_7b.cx,cy:_7b.cy,cr:r};this._connectEvents(o);_7c[i]=o;}return true;}var end=_70+_7d*2*Math.PI;if(i+1==_73.length){end=_6f+2*Math.PI;}var _81=end-_70,x1=_7b.cx+r*Math.cos(_70),y1=_7b.cy+r*Math.sin(_70),x2=_7b.cx+r*Math.cos(end),y2=_7b.cy+r*Math.sin(end);var _82=m._degToRad(this.opt.fanSize);if(_7e.series.fill&&_7e.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_81>_82){var _83=s.createGroup(),_84=Math.ceil(_81/_82),_85=_81/_84;_7f=this._shapeFill(_7e.series.fill,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});for(var j=0;j<_84;++j){var _86=j==0?x1:_7b.cx+r*Math.cos(_70+(j-_67)*_85),_87=j==0?y1:_7b.cy+r*Math.sin(_70+(j-_67)*_85),_88=j==_84-1?x2:_7b.cx+r*Math.cos(_70+(j+1+_67)*_85),_89=j==_84-1?y2:_7b.cy+r*Math.sin(_70+(j+1+_67)*_85),fan=_83.createPath().moveTo(_7b.cx,_7b.cy).lineTo(_86,_87).arcTo(r,r,0,_85>Math.PI,true,_88,_89).lineTo(_7b.cx,_7b.cy).closePath().setFill(this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},r,_70+(j+0.5)*_85,_70+(j+0.5)*_85));}_83.createPath().moveTo(_7b.cx,_7b.cy).lineTo(x1,y1).arcTo(r,r,0,_81>Math.PI,true,x2,y2).lineTo(_7b.cx,_7b.cy).closePath().setStroke(_7e.series.stroke);_80=_83;}else{_80=s.createPath().moveTo(_7b.cx,_7b.cy).lineTo(x1,y1).arcTo(r,r,0,_81>Math.PI,true,x2,y2).lineTo(_7b.cx,_7b.cy).closePath().setStroke(_7e.series.stroke);var _7f=_7e.series.fill;if(_7f&&_7f.type==="radial"){_7f=this._shapeFill(_7f,{x:_7b.cx-_7b.r,y:_7b.cy-_7b.r,width:2*_7b.r,height:2*_7b.r});if(this.opt.radGrad==="linear"){_7f=this._pseudoRadialFill(_7f,{x:_7b.cx,y:_7b.cy},r,_70,end);}}else{if(_7f&&_7f.type==="linear"){_7f=this._plotFill(_7f,dim,_6b);_7f=this._shapeFill(_7f,_80.getBoundingBox());}}_80.setFill(_7f);}this.dyn.push({fill:_7f,stroke:_7e.series.stroke});if(_77){var o={element:"slice",index:i,run:this.run,shape:_80,x:i,y:typeof v=="number"?v:v.y,cx:_7b.cx,cy:_7b.cy,cr:r};this._connectEvents(o);_7c[i]=o;}_70=end;return false;},this);if(this.opt.labels){if(this.opt.labelStyle=="default"){_70=_6f;arr.some(_73,function(_8a,i){if(_8a<=0){return false;}var _8b=_78[i];if(_8a>=1){var v=run[i],_8c=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_7b.cx,_7b.cy+_6d/2,"middle",_74[i],_8b.series.font,_8b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_8c);}return true;}var end=_70+_8a*2*Math.PI,v=run[i];if(i+1==_73.length){end=_6f+2*Math.PI;}var _8d=(_70+end)/2,x=_7b.cx+_76*Math.cos(_8d),y=_7b.cy+_76*Math.sin(_8d)+_6d/2;var _8c=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_74[i],_8b.series.font,_8b.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_8c);}_70=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_70=_6f;var _8e=[];arr.forEach(_73,function(_8f,i){var end=_70+_8f*2*Math.PI;if(i+1==_73.length){end=_6f+2*Math.PI;}var _90=(_70+end)/2;_8e.push({angle:_90,left:Math.cos(_90)<0,theme:_78[i],index:i,omit:end-_70<0.001});_70=end;});var _91=g._base._getTextBox("a",{font:_6c}).h;this._getProperLabelRadius(_8e,_91,_7b.r*1.1);arr.forEach(_8e,function(_92,i){if(!_92.omit){var _93=_7b.cx-_7b.r*2,_94=_7b.cx+_7b.r*2,_95=g._base._getTextBox(_74[i],{font:_6c}).w,x=_7b.cx+_92.labelR*Math.cos(_92.angle),y=_7b.cy+_92.labelR*Math.sin(_92.angle),_96=(_92.left)?(_93+_95):(_94-_95),_97=(_92.left)?_93:_96;var _98=s.createPath().moveTo(_7b.cx+_7b.r*Math.cos(_92.angle),_7b.cy+_7b.r*Math.sin(_92.angle));if(Math.abs(_92.labelR*Math.cos(_92.angle))<_7b.r*2-_95){_98.lineTo(x,y);}_98.lineTo(_96,y).setStroke(_92.theme.series.labelWiring);var _99=da.createText[this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx"](this.chart,s,_97,y,"left",_74[i],_92.theme.series.font,_92.theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(_99);}}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_7c[esi++];});return this;},_getProperLabelRadius:function(_9a,_9b,_9c){var _9d={},_9e={},_9f=1,_a0=1;if(_9a.length==1){_9a[0].labelR=_9c;return;}for(var i=0;i<_9a.length;i++){var _a1=Math.abs(Math.sin(_9a[i].angle));if(_9a[i].left){if(_9f>_a1){_9f=_a1;_9d=_9a[i];}}else{if(_a0>_a1){_a0=_a1;_9e=_9a[i];}}}_9d.labelR=_9e.labelR=_9c;this._calculateLabelR(_9d,_9a,_9b);this._calculateLabelR(_9e,_9a,_9b);},_calculateLabelR:function(_a2,_a3,_a4){var i=_a2.index,_a5=_a3.length,_a6=_a2.labelR;while(!(_a3[i%_a5].left^_a3[(i+1)%_a5].left)){if(!_a3[(i+1)%_a5].omit){var _a7=(Math.sin(_a3[i%_a5].angle)*_a6+((_a3[i%_a5].left)?(-_a4):_a4))/Math.sin(_a3[(i+1)%_a5].angle);_a6=(_a7<_a2.labelR)?_a2.labelR:_a7;_a3[(i+1)%_a5].labelR=_a6;}i++;}i=_a2.index;var j=(i==0)?_a5-1:i-1;while(!(_a3[i].left^_a3[j].left)){if(!_a3[j].omit){var _a7=(Math.sin(_a3[i].angle)*_a6+((_a3[i].left)?_a4:(-_a4)))/Math.sin(_a3[j].angle);_a6=(_a7<_a2.labelR)?_a2.labelR:_a7;_a3[j].labelR=_a6;}i--;j--;i=(i<0)?i+_a3.length:i;j=(j<0)?j+_a3.length:j;}},_getLabel:function(_a8){return dc.getLabel(_a8,this.opt.fixed,this.opt.precision);}});});},"dijit/hccss":function(){define("dijit/hccss",["require","dojo/_base/config","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/ready","dojo/_base/sniff","dojo/_base/window"],function(_a9,_aa,_ab,_ac,_ad,_ae,has,win){if(has("ie")||has("mozilla")){_ae(90,function(){var div=_ac.create("div",{id:"a11yTestNode",style:{cssText:"border: 1px solid;"+"border-color:red green;"+"position: absolute;"+"height: 5px;"+"top: -999px;"+"background-image: url(\""+(_aa.blankGif||_a9.toUrl("dojo/resources/blank.gif"))+"\");"}},win.body());var cs=_ad.getComputedStyle(div);if(cs){var _af=cs.backgroundImage;var _b0=(cs.borderTopColor==cs.borderRightColor)||(_af!=null&&(_af=="none"||_af=="url(invalid-url:)"));if(_b0){_ab.add(win.body(),"dijit_a11y");}if(has("ie")){div.outerHTML="";}else{win.body().removeChild(div);}}});}});},"dojox/charting/action2d/Shake":function(){define("dojox/charting/action2d/Shake",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_b1,_b2,df,dfe,m,gf){var _b3=3;return _b1("dojox.charting.action2d.Shake",_b2,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_b3,shiftY:_b3},optionalParams:{},constructor:function(_b4,_b5,_b6){if(!_b6){_b6={};}this.shiftX=typeof _b6.shiftX=="number"?_b6.shiftX:_b3;this.shiftY=typeof _b6.shiftY=="number"?_b6.shiftY:_b3;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _b7=o.run.name,_b8=o.index,_b9=[],_ba,_bb=o.type=="onmouseover"?this.shiftX:-this.shiftX,_bc=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_b7 in this.anim){_ba=this.anim[_b7][_b8];}else{this.anim[_b7]={};}if(_ba){_ba.action.stop(true);}else{this.anim[_b7][_b8]=_ba={};}var _bd={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_b9.push(gf.animateTransform(_bd));}if(o.oultine){_bd.shape=o.outline;_b9.push(gf.animateTransform(_bd));}if(o.shadow){_bd.shape=o.shadow;_b9.push(gf.animateTransform(_bd));}if(!_b9.length){delete this.anim[_b7][_b8];return;}_ba.action=df.combine(_b9);if(o.type=="onmouseout"){hub.connect(_ba.action,"onEnd",this,function(){if(this.anim[_b7]){delete this.anim[_b7][_b8];}});}_ba.action.play();}});});},"dojox/lang/functional/lambda":function(){define("dojox/lang/functional/lambda",["../..","dojo/_base/kernel","dojo/_base/lang","dojo/_base/array"],function(_be,_bf,_c0,arr){var df=_c0.getObject("lang.functional",true,_be);var _c1={};var _c2="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _c3=function(s){var _c4=[],_c5=_c2.call(s,/\s*->\s*/m);if(_c5.length>1){while(_c5.length){s=_c5.pop();_c4=_c5.pop().split(/\s*,\s*|\s+/m);if(_c5.length){_c5.push("(function("+_c4+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_c4=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_c4.push("$1");s="$1"+s;}if(r){_c4.push("$2");s=s+"$2";}}else{var _c6=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_c6,function(v){if(!(v in t)){_c4.push(v);t[v]=1;}});}}}return {args:_c4,body:s};};var _c7=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_c0.mixin(df,{rawLambda:function(s){return _c3(s);},buildLambda:function(s){s=_c3(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _c7(s);}if(s in _c1){return _c1[s];}s=_c3(s);return _c1[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_c1={};}});return df;});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/window","./lambda"],function(_c8,win,df){_c8.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define("dojox/charting/scaler/primitive",["dojo/_base/lang"],function(_c9){var _ca=_c9.getObject("dojox.charting.scaler.primitive",true);return _c9.mixin(_ca,{buildScaler:function(min,max,_cb,_cc){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_cb/(max-min),span:_cb},scaler:_ca};},buildTicks:function(_cd,_ce){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_cf){var _d0=_cf.bounds.from,_d1=_cf.bounds.scale;return function(x){return (x-_d0)*_d1;};},getTransformerFromPlot:function(_d2){var _d3=_d2.bounds.from,_d4=_d2.bounds.scale;return function(x){return x/_d4+_d3;};}});});},"dojox/charting/plot2d/Candlesticks":function(){define("dojox/charting/plot2d/Candlesticks",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_d5,_d6,arr,_d7,dc,df,dfr,du,fx){var _d8=dfr.lambda("item.purgeGroup()");return _d6("dojox.charting.plot2d.Candlesticks",_d7,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_d9,_da){this.opt=_d5.clone(this.defaultParams);du.updateWithObject(this.opt,_da);du.updateWithPattern(this.opt,_da,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_db){var _dc=_d5.delegate(dc.defaultStats);for(var i=0;i<_db.length;i++){var run=_db[i];if(!run.data.length){continue;}var _dd=_dc.vmin,_de=_dc.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_dc.hmin=Math.min(_dc.hmin,x);_dc.hmax=Math.max(_dc.hmax,x);_dc.vmin=Math.min(_dc.vmin,val.open,val.close,val.high,val.low);_dc.vmax=Math.max(_dc.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_dc.vmin=Math.min(_dd,run.ymin);}if("ymax" in run){_dc.vmax=Math.max(_de,run.ymax);}}return _dc;},getSeriesStats:function(){var _df=this.collectStats(this.series);_df.hmin-=0.5;_df.hmax+=0.5;return _df;},render:function(dim,_e0){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_e0);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_d8);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(_e1){_e1.cleanGroup(s);});}var t=this.chart.theme,f,gap,_e2,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_e3=Math.max(0,this._vScaler.bounds.lower),_e4=vt(_e3),_e5=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_e2=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _e6=t.next("candlestick",[this.opt,run]),s=run.group,_e7=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _e8=t.addMixin(_e6,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_e0.l+gap,y=dim.height-_e0.b,_e9=vt(v.open),_ea=vt(v.close),_eb=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_eb){var tmp=_eb;_eb=low;low=tmp;}if(_e2>=1){var _ec=_e9>_ea;var _ed={x1:_e2/2,x2:_e2/2,y1:y-_eb,y2:y-low},_ee={x:0,y:y-Math.max(_e9,_ea),width:_e2,height:Math.max(_ec?_e9-_ea:_ea-_e9,1)};var _ef=s.createGroup();_ef.setTransform({dx:x,dy:0});var _f0=_ef.createGroup();_f0.createLine(_ed).setStroke(_e8.series.stroke);_f0.createRect(_ee).setStroke(_e8.series.stroke).setFill(_ec?_e8.series.fill:"white");if("mid" in v){_f0.createLine({x1:(_e8.series.stroke.width||1),x2:_e2-(_e8.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_ec?"white":_e8.series.stroke);}run.dyn.fill=_e8.series.fill;run.dyn.stroke=_e8.series.stroke;if(_e5){var o={element:"candlestick",index:j,run:run,shape:_f0,x:x,y:y-Math.max(_e9,_ea),cx:_e2/2,cy:(y-Math.max(_e9,_ea))+(Math.max(_ec?_e9-_ea:_ea-_e9,1)/2),width:_e2,height:Math.max(_ec?_e9-_ea:_ea-_e9,1),data:v};this._connectEvents(o);_e7[j]=o;}}if(this.animate){this._animateCandlesticks(_ef,y-low,_eb-low);}}}this._eventSeries[run.name]=_e7;run.dirty=false;}this.dirty=false;return this;},_animateCandlesticks:function(_f1,_f2,_f3){fx.animateTransform(_d5.delegate({shape:_f1,duration:1200,transform:[{name:"translate",start:[0,_f2-(_f2/_f3)],end:[0,0]},{name:"scale",start:[1,1/_f3],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/widget/Sparkline":function(){define("dojox/charting/widget/Sparkline",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_f4,_f5,_f6,_f7,_f8,_f9,_fa,_fb,_fc){_f6("dojox.charting.widget.Sparkline",_f9,{theme:_fa,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_f8("> .axis, > .plot, > .action, > .series",n).length){var _fd=document.createElement("div");_fc.set(_fd,{"class":"plot","name":"default","type":this.type});n.appendChild(_fd);var _fe=document.createElement("div");_fc.set(_fe,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_f5.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_fc.set(_fe,i,this[i]);}},this);n.appendChild(_fe);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define("dojox/gfx/matrix",["./_base","dojo/_base/lang"],function(g,_ff){var m=g.matrix={};var _100={};m._degToRad=function(_101){return _100[_101]||(_100[_101]=(Math.PI*_101/180));};m._radToDeg=function(_102){return _102/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _103=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_103,r=m.normalize(arg[i]);_103=new m.Matrix2D();_103.xx=l.xx*r.xx+l.xy*r.yx;_103.xy=l.xx*r.xy+l.xy*r.yy;_103.yx=l.yx*r.xx+l.yy*r.yx;_103.yy=l.yx*r.xy+l.yy*r.yy;_103.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_103.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_ff.mixin(this,_103);}}else{_ff.mixin(this,arg);}}}};_ff.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_ff.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_104){var c=Math.cos(_104);var s=Math.sin(_104);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_105){return m.rotate(m._degToRad(_105));},skewX:function(_106){return new m.Matrix2D({xy:Math.tan(_106)});},skewXg:function(_107){return m.skewX(m._degToRad(_107));},skewY:function(_108){return new m.Matrix2D({yx:Math.tan(_108)});},skewYg:function(_109){return m.skewY(m._degToRad(_109));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_10a){return (_10a instanceof m.Matrix2D)?_10a:new m.Matrix2D(_10a);},clone:function(_10b){var obj=new m.Matrix2D();for(var i in _10b){if(typeof (_10b[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_10b[i]){obj[i]=_10b[i];}}return obj;},invert:function(_10c){var M=m.normalize(_10c),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_10d,x,y){return {x:_10d.xx*x+_10d.xy*y+_10d.dx,y:_10d.yx*x+_10d.yy*y+_10d.dy};},multiplyPoint:function(_10e,a,b){var M=m.normalize(_10e);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_10f){var M=m.normalize(_10f);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_110,x,y){return m.multiply(m.translate(x,y),_110,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_111,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_111),a,b);}return m._sandwich(m.rotate(_111),a.x,a.y);},rotategAt:function(_112,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_112),a,b);}return m._sandwich(m.rotateg(_112),a.x,a.y);},skewXAt:function(_113,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_113),a,b);}return m._sandwich(m.skewX(_113),a.x,a.y);},skewXgAt:function(_114,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_114),a,b);}return m._sandwich(m.skewXg(_114),a.x,a.y);},skewYAt:function(_115,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_115),a,b);}return m._sandwich(m.skewY(_115),a.x,a.y);},skewYgAt:function(_116,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_116),a,b);}return m._sandwich(m.skewYg(_116),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define("dojox/charting/plot2d/Scatter",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(lang,arr,_117,Base,dc,df,dfr,du,fx,_118){var _119=dfr.lambda("item.purgeGroup()");return _117("dojox.charting.plot2d.Scatter",Base,{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_11a,_11b){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_11b);du.updateWithPattern(this.opt,_11b,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_11c){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_11c);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_119);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_11d=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _11e=t.next("marker",[this.opt,run]),s=run.group,_11f,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_11f=arr.map(run.data,function(v,i){return {x:ht(i+1)+_11c.l,y:dim.height-_11c.b-vt(v)};},this);}else{_11f=arr.map(run.data,function(v,i){return {x:ht(v.x)+_11c.l,y:dim.height-_11c.b-vt(v.y)};},this);}var _120=new Array(_11f.length),_121=new Array(_11f.length),_122=new Array(_11f.length);arr.forEach(_11f,function(c,i){var _123=typeof run.data[i]=="number"?t.post(_11e,"marker"):t.addMixin(_11e,"marker",run.data[i],true),path="M"+c.x+" "+c.y+" "+_123.symbol;if(_123.marker.shadow){_120[i]=s.createPath("M"+(c.x+_123.marker.shadow.dx)+" "+(c.y+_123.marker.shadow.dy)+" "+_123.symbol).setStroke(_123.marker.shadow).setFill(_123.marker.shadow.color);if(this.animate){this._animateScatter(_120[i],dim.height-_11c.b);}}if(_123.marker.outline){var _124=dc.makeStroke(_123.marker.outline);_124.width=2*_124.width+_123.marker.stroke.width;_122[i]=s.createPath(path).setStroke(_124);if(this.animate){this._animateScatter(_122[i],dim.height-_11c.b);}}var _125=dc.makeStroke(_123.marker.stroke),fill=this._plotFill(_123.marker.fill,dim,_11c);if(fill&&(fill.type==="linear"||fill.type=="radial")){var _126=_118.getColor(fill,{x:c.x,y:c.y});if(_125){_125.color=_126;}_121[i]=s.createPath(path).setStroke(_125).setFill(_126);}else{_121[i]=s.createPath(path).setStroke(_125).setFill(fill);}if(this.animate){this._animateScatter(_121[i],dim.height-_11c.b);}},this);if(_121.length){run.dyn.stroke=_121[_121.length-1].getStroke();run.dyn.fill=_121[_121.length-1].getFill();}if(_11d){var _127=new Array(_121.length);arr.forEach(_121,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_122&&_122[i]||null,shadow:_120&&_120[i]||null,cx:_11f[i].x,cy:_11f[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_127[i]=o;},this);this._eventSeries[run.name]=_127;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateScatter:function(_128,_129){fx.animateTransform(lang.delegate({shape:_128,duration:1200,transform:[{name:"translate",start:[0,_129],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define("dojox/lang/functional/scan",["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(d,_12a,df){var _12b={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _12b)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_12c=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _12b)){if(_12c){t=[z=a[i]];_12c=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/color/_base":function(){define("dojox/color/_base",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(dojo,_12d,lang,_12e,_12f){var cx=lang.getObject("dojox.color",true);cx.Color=_12e;cx.blend=_12e.blendColors;cx.fromRgb=_12e.fromRgb;cx.fromHex=_12e.fromHex;cx.fromArray=_12e.fromArray;cx.fromString=_12e.fromString;cx.greyscale=_12f.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_130,_131){if(lang.isArray(cyan)){_130=cyan[1],_131=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_130=cyan.m,_131=cyan.y,cyan=cyan.c;}}cyan/=100,_130/=100,_131/=100;var r=1-cyan,g=1-_130,b=1-_131;return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_132,_133,_134){if(lang.isArray(cyan)){_132=cyan[1],_133=cyan[2],_134=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_132=cyan.m,_133=cyan.y,_134=cyan.b,cyan=cyan.c;}}cyan/=100,_132/=100,_133/=100,_134/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_134)+_134);g=1-Math.min(1,_132*(1-_134)+_134);b=1-Math.min(1,_133*(1-_134)+_134);return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_135,_136){if(lang.isArray(hue)){_135=hue[1],_136=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_135=hue.s,_136=hue.l,hue=hue.h;}}_135/=100;_136/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_135*Math.min(r,1)+(1-_135);g=2*_135*Math.min(g,1)+(1-_135);b=2*_135*Math.min(b,1)+(1-_135);if(_136<0.5){r*=_136,g*=_136,b*=_136;}else{r=(1-_136)*r+2*_136-1;g=(1-_136)*g+2*_136-1;b=(1-_136)*b+2*_136-1;}return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_137,_138){if(lang.isArray(hue)){_137=hue[1],_138=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_137=hue.s,_138=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_137/=100;_138/=100;var r,g,b;if(_137==0){r=_138,b=_138,g=_138;}else{var _139=hue/60,i=Math.floor(_139),f=_139-i;var p=_138*(1-_137);var q=_138*(1-(_137*f));var t=_138*(1-(_137*(1-f)));switch(i){case 0:r=_138,g=t,b=p;break;case 1:r=q,g=_138,b=p;break;case 2:r=p,g=_138,b=t;break;case 3:r=p,g=q,b=_138;break;case 4:r=t,g=p,b=_138;break;case 5:r=_138,g=p,b=q;break;}}return new _12e({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_12e,{toCmy:function(){var cyan=1-(this.r/255),_13a=1-(this.g/255),_13b=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_13a*100),y:Math.round(_13b*100)};},toCmyk:function(){var cyan,_13c,_13d,_13e;var r=this.r/255,g=this.g/255,b=this.b/255;_13e=Math.min(1-r,1-g,1-b);cyan=(1-r-_13e)/(1-_13e);_13c=(1-g-_13e)/(1-_13e);_13d=(1-b-_13e)/(1-_13e);return {c:Math.round(cyan*100),m:Math.round(_13c*100),y:Math.round(_13d*100),b:Math.round(_13e*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _13f=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_13f/((l<0.5)?(2*l):(2-2*l));}if(_13f>0){if(max==r&&max!=g){h+=(g-b)/_13f;}if(max==g&&max!=b){h+=(2+(b-r)/_13f);}if(max==b&&max!=r){h+=(4+(r-g)/_13f);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _140=max-min;var h=null,s=(max==0)?0:(_140/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_140;}else{if(g==max){h=120+60*(b-r)/_140;}else{h=240+60*(r-g)/_140;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_141,Base,dc,df,dfr,du,fx){var _142=dfr.lambda("item.purgeGroup()");return _141("dojox.charting.plot2d.OHLC",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_143,_144){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_144);du.updateWithPattern(this.opt,_144,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(_145){var _146=lang.delegate(dc.defaultStats);for(var i=0;i<_145.length;i++){var run=_145[i];if(!run.data.length){continue;}var _147=_146.vmin,_148=_146.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_146.hmin=Math.min(_146.hmin,x);_146.hmax=Math.max(_146.hmax,x);_146.vmin=Math.min(_146.vmin,val.open,val.close,val.high,val.low);_146.vmax=Math.max(_146.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_146.vmin=Math.min(_147,run.ymin);}if("ymax" in run){_146.vmax=Math.max(_148,run.ymax);}}return _146;},getSeriesStats:function(){var _149=this.collectStats(this.series);_149.hmin-=0.5;_149.hmax+=0.5;return _149;},render:function(dim,_14a){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_14a);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_142);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_14b,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_14c=Math.max(0,this._vScaler.bounds.lower),_14d=vt(_14c),_14e=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_14b=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _14f=t.next("candlestick",[this.opt,run]),s=run.group,_150=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _151=t.addMixin(_14f,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_14a.l+gap,y=dim.height-_14a.b,open=vt(v.open),_152=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_14b>=1){var hl={x1:_14b/2,x2:_14b/2,y1:y-high,y2:y-low},op={x1:0,x2:((_14b/2)+((_151.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_14b/2)-((_151.series.stroke.width||1)/2)),x2:_14b,y1:y-_152,y2:y-_152};var _153=s.createGroup();_153.setTransform({dx:x,dy:0});var _154=_153.createGroup();_154.createLine(hl).setStroke(_151.series.stroke);_154.createLine(op).setStroke(_151.series.stroke);_154.createLine(cl).setStroke(_151.series.stroke);run.dyn.stroke=_151.series.stroke;if(_14e){var o={element:"candlestick",index:j,run:run,shape:_154,x:x,y:y-Math.max(open,_152),cx:_14b/2,cy:(y-Math.max(open,_152))+(Math.max(open>_152?open-_152:_152-open,1)/2),width:_14b,height:Math.max(open>_152?open-_152:_152-open,1),data:v};this._connectEvents(o);_150[j]=o;}}if(this.animate){this._animateOHLC(_153,y-low,high-low);}}}this._eventSeries[run.name]=_150;run.dirty=false;}this.dirty=false;return this;},_animateOHLC:function(_155,_156,_157){fx.animateTransform(lang.delegate({shape:_155,duration:1200,transform:[{name:"translate",start:[0,_156-(_156/_157)],end:[0,0]},{name:"scale",start:[1,1/_157],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/ClusteredColumns":function(){define("dojox/charting/plot2d/ClusteredColumns",["dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(arr,_158,_159,dc,df,dfr,du){var _15a=dfr.lambda("item.purgeGroup()");return _158("dojox.charting.plot2d.ClusteredColumns",_159,{render:function(dim,_15b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_15b);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_15a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_15c,_15d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_15e=Math.max(0,this._vScaler.bounds.lower),_15f=vt(_15e),_160=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_15c=_15d=f.size;for(var i=0;i<this.series.length;++i){var run=this.series[i],_161=_15d*i;if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _162=t.next("column",[this.opt,run]),s=run.group,_163=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _164=run.data[j];if(_164!==null){var v=typeof _164=="number"?_164:_164.y,vv=vt(v),_165=vv-_15f,h=Math.abs(_165),_166=typeof _164!="number"?t.addMixin(_162,"column",_164,true):t.post(_162,"column");if(_15c>=1&&h>=0){var rect={x:_15b.l+ht(j+0.5)+gap+_161,y:dim.height-_15b.b-(v>_15e?vv:_15f),width:_15c,height:h};var _167=this._plotFill(_166.series.fill,dim,_15b);_167=this._shapeFill(_167,rect);var _168=s.createRect(rect).setFill(_167).setStroke(_166.series.stroke);run.dyn.fill=_168.getFill();run.dyn.stroke=_168.getStroke();if(_160){var o={element:"column",index:j,run:run,shape:_168,x:j+0.5,y:v};this._connectEvents(o);_163[j]=o;}if(this.animate){this._animateColumn(_168,dim.height-_15b.b-_15f,h);}}}}this._eventSeries[run.name]=_163;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/charting/Chart":function(){define("dojox/charting/Chart",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/html","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/_base/sniff","./Element","./Theme","./Series","./axis2d/common","dojox/gfx","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(lang,arr,_169,html,dom,_16a,_16b,_16c,has,_16d,_16e,_16f,_170,g,func,_171,_172){var dc=dojox.charting,_173=func.lambda("item.clear()"),_174=func.lambda("item.purgeGroup()"),_175=func.lambda("item.destroy()"),_176=func.lambda("item.dirty = false"),_177=func.lambda("item.dirty = true"),_178=func.lambda("item.name");_169("dojox.charting.Chart",null,{constructor:function(node,_179){if(!_179){_179={};}this.margins=_179.margins?_179.margins:{l:10,t:10,r:10,b:10};this.stroke=_179.stroke;this.fill=_179.fill;this.delayInMs=_179.delayInMs||200;this.title=_179.title;this.titleGap=_179.titleGap;this.titlePos=_179.titlePos;this.titleFont=_179.titleFont;this.titleFontColor=_179.titleFontColor;this.chartTitle=null;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dom.byId(node);var box=_16a.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);},destroy:function(){arr.forEach(this.series,_175);arr.forEach(this.stack,_175);func.forIn(this.axes,_175);if(this.chartTitle&&this.chartTitle.tagName){_16b.destroy(this.chartTitle);}this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=html.coords(this.node,true);}return this.coords;},setTheme:function(_17a){this.theme=_17a.clone();this.dirty=true;return this;},addAxis:function(name,_17b){var axis,_17c=_17b&&_17b.type||"Default";if(typeof _17c=="string"){if(!dc.axis2d||!dc.axis2d[_17c]){throw Error("Can't find axis: "+_17c+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_17c](this,_17b);}else{axis=new _17c(this,_17b);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_17d){var plot,_17e=_17d&&_17d.type||"Default";if(typeof _17e=="string"){if(!dc.plot2d||!dc.plot2d[_17e]){throw Error("Can't find plot: "+_17e+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_17e](this,_17d);}else{plot=new _17e(this,_17d);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _17f=this.plots[name];delete this.plots[name];this.stack[_17f].destroy();this.stack.splice(_17f,1);func.forIn(this.plots,function(idx,name,_180){if(idx>_17f){_180[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_181){this.runs[run.plot]=_181;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_178);},setPlotOrder:function(_182){var _183={},_184=func.filter(_182,function(name){if(!(name in this.plots)||(name in _183)){return false;}_183[name]=1;return true;},this);if(_184.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _183)){_184.push(name);}});}var _185=func.map(_184,function(name){return this.stack[this.plots[name]];},this);func.forEach(_185,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_185;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _186=this.plots[name];if(_186){var _187=this.getPlotOrder();_187.splice(_186,1);_187.unshift(name);return this.setPlotOrder(_187);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _188=this.plots[name];if(_188<this.stack.length-1){var _189=this.getPlotOrder();_189.splice(_188,1);_189.push(name);return this.setPlotOrder(_189);}}return this;},addSeries:function(name,data,_18a){var run=new _16f(this,data,_18a);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _18b=this.runs[name];delete this.runs[name];this.series[_18b].destroy();this.series.splice(_18b,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_18b){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},getSeriesOrder:function(_18c){return func.map(func.filter(this.series,function(run){return run.plot==_18c;}),_178);},setSeriesOrder:function(_18d){var _18e,_18f={},_190=func.filter(_18d,function(name){if(!(name in this.runs)||(name in _18f)){return false;}var run=this.series[this.runs[name]];if(_18e){if(run.plot!=_18e){return false;}}else{_18e=run.plot;}_18f[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _18f)&&run.plot==_18e){_190.push(name);}});var _191=func.map(_190,function(name){return this.series[this.runs[name]];},this);this.series=_191.concat(func.filter(this.series,function(run){return run.plot!=_18e;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _192=this.runs[name],_193=this.getSeriesOrder(this.series[_192].plot);if(name!=_193[0]){_193.splice(_192,1);_193.unshift(name);return this.setSeriesOrder(_193);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _194=this.runs[name],_195=this.getSeriesOrder(this.series[_194].plot);if(name!=_195[_195.length-1]){_195.splice(_194,1);_195.push(name);return this.setSeriesOrder(_195);}}return this;},resize:function(_196,_197){var box;switch(arguments.length){case 1:box=lang.mixin({},_196);_16a.setMarginBox(this.node,box);break;case 2:box={w:_196,h:_197};_16a.setMarginBox(this.node,box);break;}box=_16a.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_198,_199,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_198,_199);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _19a,_19b,_19c=axis.getScaler().bounds,s=_19c.span/(_19c.upper-_19c.lower);if(axis.vertical){_19a=sy;_19b=dy/s/_19a;}else{_19a=sx;_19b=dx/s/_19a;}axis.setWindow(_19a,_19b);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_19d){var axis=this.axes[name];if(axis){var _19e,_19f,_1a0=axis.getScaler().bounds;var _1a1=Math.min(_19d[0],_19d[1]);var _1a2=Math.max(_19d[0],_19d[1]);_1a1=_19d[0]<_1a0.lower?_1a0.lower:_1a1;_1a2=_19d[1]>_1a0.upper?_1a0.upper:_1a2;_19e=(_1a0.upper-_1a0.lower)/(_1a2-_1a1);_19f=_1a1-_1a0.lower;this.setAxisWindow(name,_19e,_19f);this.render();}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _1a3=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_1a4(_1a3,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_173);if(!this.theme){this.setTheme(new _16e(dojox.charting._def));}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_173);_1a4(this.stack,dim);var _1a5=this.offsets={l:0,r:0,t:0,b:0};func.forIn(this.axes,function(axis){func.forIn(axis.getOffsets(),function(o,i){_1a5[i]+=o;});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _1a6=g.normalizedLength(g.splitFontString(this.titleFont).size);_1a5[this.titlePos=="top"?"t":"b"]+=(_1a6+this.titleGap);}func.forIn(this.margins,function(o,i){_1a5[i]+=o;});this.plotArea={width:dim.width-_1a5.l-_1a5.r,height:dim.height-_1a5.t-_1a5.b};func.forIn(this.axes,_173);_1a4(this.stack,this.plotArea);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _1a7=this.offsets,dim=this.dim,rect;arr.forEach(this.series,_174);func.forIn(this.axes,_174);arr.forEach(this.stack,_174);if(this.chartTitle&&this.chartTitle.tagName){_16b.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_1a8=t.plotarea&&t.plotarea.stroke,w=Math.max(0,dim.width-_1a7.l-_1a7.r),h=Math.max(0,dim.height-_1a7.t-_1a7.b),rect={x:_1a7.l-1,y:_1a7.t-1,width:w+2,height:h+2};if(fill){fill=_16d.prototype._shapeFill(_16d.prototype._plotFill(fill,dim,_1a7),rect);this.surface.createRect(rect).setFill(fill);}if(_1a8){this.surface.createRect({x:_1a7.l,y:_1a7.t,width:w+1,height:h+1}).setStroke(_1a8);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_1a7),0;},0);fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);_1a8=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new _16c(html.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _16c(html.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){fill=_16d.prototype._plotFill(fill,dim,_1a7);if(_1a7.l){rect={width:_1a7.l,height:dim.height+1};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.r){rect={x:dim.width-_1a7.r,width:_1a7.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.t){rect={width:dim.width+1,height:_1a7.t};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}if(_1a7.b){rect={y:dim.height-_1a7.b,width:dim.width+1,height:_1a7.b+2};this.surface.createRect(rect).setFill(_16d.prototype._shapeFill(fill,rect));}}if(_1a8){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_1a8);}if(this.title){var _1a9=(g.renderer=="canvas"),_1aa=_1a9||!has("ie")&&!has("opera")?"html":"gfx",_1ab=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_170.createText[_1aa](this,this.surface,dim.width/2,this.titlePos=="top"?_1ab+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_1a7);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_1ac,_1ad){return name in this.plots?this.stack[this.plots[name]].connect(_1ac,_1ad):null;},fireEvent:function(_1ae,_1af,_1b0){if(_1ae in this.runs){var _1b1=this.series[this.runs[_1ae]].plot;if(_1b1 in this.plots){var plot=this.stack[this.plots[_1b1]];if(plot){plot.fireEvent(_1ae,_1af,_1b0);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_176);arr.forEach(this.stack,_176);arr.forEach(this.series,_176);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_177);arr.forEach(this.stack,_177);arr.forEach(this.series,_177);this.dirty=true;},_invalidateDependentPlots:function(_1b2,_1b3){if(_1b2 in this.plots){var plot=this.stack[this.plots[_1b2]],axis,_1b4=_1b3?"vAxis":"hAxis";if(plot[_1b4]){axis=this.axes[plot[_1b4]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_1b4]&&p[_1b4]==plot[_1b4]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function _1b5(_1b6){return {min:_1b6.hmin,max:_1b6.hmax};};function _1b7(_1b8){return {min:_1b8.vmin,max:_1b8.vmax};};function _1b9(_1ba,h){_1ba.hmin=h.min;_1ba.hmax=h.max;};function _1bb(_1bc,v){_1bc.vmin=v.min;_1bc.vmax=v.max;};function _1bd(_1be,_1bf){if(_1be&&_1bf){_1be.min=Math.min(_1be.min,_1bf.min);_1be.max=Math.max(_1be.max,_1bf.max);}return _1be||_1bf;};function _1a4(_1c0,_1c1){var _1c2={},axes={};arr.forEach(_1c0,function(plot){var _1c3=_1c2[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1bd(axes[plot.hAxis],_1b5(_1c3));}if(plot.vAxis){axes[plot.vAxis]=_1bd(axes[plot.vAxis],_1b7(_1c3));}});arr.forEach(_1c0,function(plot){var _1c4=_1c2[plot.name];if(plot.hAxis){_1b9(_1c4,axes[plot.hAxis]);}if(plot.vAxis){_1bb(_1c4,axes[plot.vAxis]);}plot.initializeScalers(_1c1,_1c4);});};return dojox.charting.Chart;});},"dojox/lang/functional/sequence":function(){define("dojox/lang/functional/sequence",["./lambda"],function(df){dojo.mixin(df,{repeat:function(n,f,z,o){o=o||dojo.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||dojo.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});});},"dojox/charting/plot2d/MarkersOnly":function(){define("dojox/charting/plot2d/MarkersOnly",["dojo/_base/declare","./Default"],function(_1c5,_1c6){return _1c5("dojox.charting.plot2d.MarkersOnly",_1c6,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define("dojox/charting/plot2d/Areas",["dojo/_base/declare","./Default"],function(_1c7,_1c8){return _1c7("dojox.charting.plot2d.Areas",_1c8,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define("dojox/charting/action2d/Base",["dojo/_base/lang","dojo/_base/declare"],function(lang,_1c9){return _1c9("dojox.charting.action2d.Base",null,{constructor:function(_1ca,plot){this.chart=_1ca;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1cb,dojo,_1cc,_1cd,_1ce,dom,_1cf,geom,_1d0,_1d1){if(!dojo.isAsync){_1d0(0,function(){var _1d2=["./fx/Toggler"];_1d1(_1d2);});}var _1d3={};dojo.fx=_1ce;var _1d4={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1d5=function(_1d6){this._index=-1;this._animations=_1d6||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1cc.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1d5.prototype=new _1cb();lang.extend(_1d5,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){_1cd.disconnect(this._onAnimateCtx);_1cd.disconnect(this._onEndCtx);this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1cd.connect(this._current,"onAnimate",this,"_onAnimate");this._onEndCtx=_1cd.connect(this._current,"onEnd",this,"_onEnd");this._current.play(0,true);}},play:function(_1d7,_1d8){if(!this._current){this._current=this._animations[this._index=0];}if(!_1d8&&this._current.status()=="playing"){return this;}var _1d9=_1cd.connect(this._current,"beforeBegin",this,function(){this._fire("beforeBegin");}),_1da=_1cd.connect(this._current,"onBegin",this,function(arg){this._fire("onBegin",arguments);}),_1db=_1cd.connect(this._current,"onPlay",this,function(arg){this._fire("onPlay",arguments);_1cd.disconnect(_1d9);_1cd.disconnect(_1da);_1cd.disconnect(_1db);});if(this._onAnimateCtx){_1cd.disconnect(this._onAnimateCtx);}this._onAnimateCtx=_1cd.connect(this._current,"onAnimate",this,"_onAnimate");if(this._onEndCtx){_1cd.disconnect(this._onEndCtx);}this._onEndCtx=_1cd.connect(this._current,"onEnd",this,"_onEnd");this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1cd.connect(this._current,"onPause",this,function(arg){this._fire("onPause",arguments);_1cd.disconnect(e);});this._current.pause();}return this;},gotoPercent:function(_1dc,_1dd){this.pause();var _1de=this.duration*_1dc;this._current=null;_1cc.some(this._animations,function(a){if(a.duration<=_1de){this._current=a;return true;}_1de-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1de/this._current.duration,_1dd);}return this;},stop:function(_1df){if(this._current){if(_1df){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1cd.connect(this._current,"onStop",this,function(arg){this._fire("onStop",arguments);_1cd.disconnect(e);});this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){_1cd.disconnect(this._onAnimateCtx);}if(this._onEndCtx){_1cd.disconnect(this._onEndCtx);}}});lang.extend(_1d5,_1d4);_1d3.chain=dojo.fx.chain=function(_1e0){return new _1d5(_1e0);};var _1e1=function(_1e2){this._animations=_1e2||[];this._connects=[];this._finished=0;this.duration=0;_1cc.forEach(_1e2,function(a){var _1e3=a.duration;if(a.delay){_1e3+=a.delay;}if(this.duration<_1e3){this.duration=_1e3;}this._connects.push(_1cd.connect(a,"onEnd",this,"_onEnd"));},this);this._pseudoAnimation=new _1ce.Animation({curve:[0,1],duration:this.duration});var self=this;_1cc.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1cd.connect(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);}));});};lang.extend(_1e1,{_doAction:function(_1e4,args){_1cc.forEach(this._animations,function(a){a[_1e4].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1e5,args){var t=this._pseudoAnimation;t[_1e5].apply(t,args);},play:function(_1e6,_1e7){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1e8,_1e9){var ms=this.duration*_1e8;_1cc.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1e9);});this._call("gotoPercent",arguments);return this;},stop:function(_1ea){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1cc.forEach(this._connects,_1cd.disconnect);}});lang.extend(_1e1,_1d4);_1d3.combine=dojo.fx.combine=function(_1eb){return new _1e1(_1eb);};_1d3.wipeIn=dojo.fx.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1ce.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1ec=_1cf.get(node,"height");return Math.max(_1ec,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1cd.connect(anim,"onStop",fini);_1cd.connect(anim,"onEnd",fini);return anim;};_1d3.wipeOut=dojo.fx.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1ce.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1cd.connect(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";});var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1cd.connect(anim,"onStop",fini);_1cd.connect(anim,"onEnd",fini);return anim;};_1d3.slideTo=dojo.fx.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1cf.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1ce.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1cd.connect(anim,"beforeBegin",anim,init);return anim;};lang.mixin(dojo.fx,_1d3);return _1d3;});},"dojox/gfx/fx":function(){define("dojox/gfx/fx",["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect"],function(lang,g,m,_1ed,arr,fx,Hub){var fxg=g.fx={};function _1ee(_1ef,end){this.start=_1ef,this.end=end;};_1ee.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1f0(_1f1,end,_1f2){this.start=_1f1,this.end=end;this.units=_1f2;};_1f0.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1f3(_1f4,end){this.start=_1f4,this.end=end;this.temp=new _1ed();};_1f3.prototype.getValue=function(r){return _1ed.blendColors(this.start,this.end,r,this.temp);};function _1f5(_1f6){this.values=_1f6;this.length=_1f6.length;};_1f5.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f7(_1f8,def){this.values=_1f8;this.def=def?def:{};};_1f7.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f9(_1fa,_1fb){this.stack=_1fa;this.original=_1fb;};_1f9.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1fc=f.apply(m,val);if(_1fc instanceof m.Matrix2D){ret.push(_1fc);}},this);return ret;};var _1fd=new _1ed(0,0,0,0);function _1fe(prop,obj,name,def){if(prop.values){return new _1f5(prop.values);}var _1ff,_200,end;if(prop.start){_200=g.normalizeColor(prop.start);}else{_200=_1ff=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1ff){_1ff=obj?(name?obj[name]:obj):def;}end=_1ff;}return new _1f3(_200,end);};function _201(prop,obj,name,def){if(prop.values){return new _1f5(prop.values);}var _202,_203,end;if(prop.start){_203=prop.start;}else{_203=_202=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _202!="number"){_202=obj?obj[name]:def;}end=_202;}return new _1ee(_203,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_204=args.shape,_205;Hub.connect(anim,"beforeBegin",anim,function(){_205=_204.getStroke();var prop=args.color,_206={},_207,_208,end;if(prop){_206.color=_1fe(prop,_205,"color",_1fd);}prop=args.style;if(prop&&prop.values){_206.style=new _1f5(prop.values);}prop=args.width;if(prop){_206.width=_201(prop,_205,"width",1);}prop=args.cap;if(prop&&prop.values){_206.cap=new _1f5(prop.values);}prop=args.join;if(prop){if(prop.values){_206.join=new _1f5(prop.values);}else{_208=prop.start?prop.start:(_205&&_205.join||0);end=prop.end?prop.end:(_205&&_205.join||0);if(typeof _208=="number"&&typeof end=="number"){_206.join=new _1ee(_208,end);}}}this.curve=new _1f7(_206,_205);});Hub.connect(anim,"onAnimate",_204,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_209.getFill();var prop=args.color,_20a={};if(prop){this.curve=_1fe(prop,fill,"",_1fd);}});Hub.connect(anim,"onAnimate",_209,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20b=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_20b.getFont();var prop=args.style,_20c={},_20d,_20e,end;if(prop&&prop.values){_20c.style=new _1f5(prop.values);}prop=args.variant;if(prop&&prop.values){_20c.variant=new _1f5(prop.values);}prop=args.weight;if(prop&&prop.values){_20c.weight=new _1f5(prop.values);}prop=args.family;if(prop&&prop.values){_20c.family=new _1f5(prop.values);}prop=args.size;if(prop&&prop.units){_20e=parseFloat(prop.start?prop.start:(_20b.font&&_20b.font.size||"0"));end=parseFloat(prop.end?prop.end:(_20b.font&&_20b.font.size||"0"));_20c.size=new _1f0(_20e,end,prop.units);}this.curve=new _1f7(_20c,font);});Hub.connect(anim,"onAnimate",_20b,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20f=args.shape,_210;Hub.connect(anim,"beforeBegin",anim,function(){_210=_20f.getTransform();this.curve=new _1f9(args.transform,_210);});Hub.connect(anim,"onAnimate",_20f,"setTransform");return anim;};return fxg;});},"dojox/charting/action2d/PlotAction":function(){define("dojox/charting/action2d/PlotAction",["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional","dojox/lang/functional/object"],function(hub,_211,Base,dfe,df,dlfo){var _212=400,_213=dfe.backOut;return _211("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_214,plot,_215){this.anim={};if(!_215){_215={};}this.duration=_215.duration?_215.duration:_212;this.easing=_215.easing?_215.easing:_213;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dijit/BackgroundIframe":function(){define("dijit/BackgroundIframe",["require",".","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/_base/sniff","dojo/_base/window"],function(_216,_217,_218,_219,_21a,lang,on,has,win){var _21b=new function(){var _21c=[];this.pop=function(){var _21d;if(_21c.length){_21d=_21c.pop();_21d.style.display="";}else{if(has("ie")<9){var burl=_218["dojoBlankHtmlUrl"]||_216.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_21d=win.doc.createElement(html);}else{_21d=_219.create("iframe");_21d.src="javascript:\"\"";_21d.className="dijitBackgroundIframe";_21d.setAttribute("role","presentation");_21a.set(_21d,"opacity",0.1);}_21d.tabIndex=-1;}return _21d;};this.push=function(_21e){_21e.style.display="none";_21c.push(_21e);};}();_217.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("ie")||has("mozilla")){var _21f=(this.iframe=_21b.pop());node.appendChild(_21f);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,function(){this.resize(node);}));}else{_21a.set(_21f,{width:"100%",height:"100%"});}}};lang.extend(_217.BackgroundIframe,{resize:function(node){if(this.iframe){_21a.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_21b.push(this.iframe);delete this.iframe;}}});return _217.BackgroundIframe;});},"dojox/main":function(){define("dojox/main",["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define("dojox/charting/action2d/Magnify",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_220,_221,m,gf,df,dfe){var _222=2;return _220("dojox.charting.action2d.Magnify",_221,{defaultParams:{duration:400,easing:dfe.backOut,scale:_222},optionalParams:{},constructor:function(_223,plot,_224){this.scale=_224&&typeof _224.scale=="number"?_224.scale:_222;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _225=o.run.name,_226=o.index,_227=[],anim,init,_228;if(_225 in this.anim){anim=this.anim[_225][_226];}else{this.anim[_225]={};}if(anim){anim.action.stop(true);}else{this.anim[_225][_226]=anim={};}if(o.type=="onmouseover"){init=m.identity;_228=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_228=1/this.scale;}var _229={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_228,o.cx,o.cy]},init]};if(o.shape){_227.push(gf.animateTransform(_229));}if(o.oultine){_229.shape=o.outline;_227.push(gf.animateTransform(_229));}if(o.shadow){_229.shape=o.shadow;_227.push(gf.animateTransform(_229));}if(!_227.length){delete this.anim[_225][_226];return;}anim.action=df.combine(_227);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_225]){delete this.anim[_225][_226];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/kernel","./_base/declare","./_base/lang","./_base/array"],function(dojo,_22a,lang,_22b){return dojo.declare("dojo.Stateful",null,{postscript:function(_22c){if(_22c){lang.mixin(this,_22c);}},get:function(name){return this[name];},set:function(name,_22d){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _22e=this[name];this[name]=_22d;if(this._watchCallbacks){this._watchCallbacks(name,_22e,_22d);}return this;},watch:function(name,_22f){var _230=this._watchCallbacks;if(!_230){var self=this;_230=this._watchCallbacks=function(name,_231,_232,_233){var _234=function(_235){if(_235){_235=_235.slice();for(var i=0,l=_235.length;i<l;i++){try{_235[i].call(self,name,_231,_232);}catch(e){console.error(e);}}}};_234(_230["_"+name]);if(!_233){_234(_230["*"]);}};}if(!_22f&&typeof name==="function"){_22f=name;name="*";}else{name="_"+name;}var _236=_230[name];if(typeof _236!=="object"){_236=_230[name]=[];}_236.push(_22f);return {unwatch:function(){_236.splice(_22b.indexOf(_236,_22f),1);}};}});});},"dojox/charting/plot2d/Markers":function(){define("dojox/charting/plot2d/Markers",["dojo/_base/declare","./Default"],function(_237,_238){return _237("dojox.charting.plot2d.Markers",_238,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define("dojox/charting/plot2d/Bubble",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_239,arr,Base,dc,df,dfr,du,fx){var _23a=dfr.lambda("item.purgeGroup()");return _239("dojox.charting.plot2d.Bubble",Base,{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_23b,_23c){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_23c);du.updateWithPattern(this.opt,_23c,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,_23d){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_23d);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_23a);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_23e=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _23f=t.next("circle",[this.opt,run]),s=run.group,_240=arr.map(run.data,function(v,i){return v?{x:ht(v.x)+_23d.l,y:dim.height-_23d.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _241=null,_242=null,_243=null;if(_23f.series.shadow){_243=arr.map(_240,function(item){if(item!==null){var _244=t.addMixin(_23f,"circle",item,true),_245=_244.series.shadow;var _246=s.createCircle({cx:item.x+_245.dx,cy:item.y+_245.dy,r:item.radius}).setStroke(_245).setFill(_245.color);if(this.animate){this._animateBubble(_246,dim.height-_23d.b,item.radius);}return _246;}return null;},this);if(_243.length){run.dyn.shadow=_243[_243.length-1].getStroke();}}if(_23f.series.outline){_242=arr.map(_240,function(item){if(item!==null){var _247=t.addMixin(_23f,"circle",item,true),_248=dc.makeStroke(_247.series.outline);_248.width=2*_248.width+_23f.series.stroke.width;var _249=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_248);if(this.animate){this._animateBubble(_249,dim.height-_23d.b,item.radius);}return _249;}return null;},this);if(_242.length){run.dyn.outline=_242[_242.length-1].getStroke();}}_241=arr.map(_240,function(item){if(item!==null){var _24a=t.addMixin(_23f,"circle",item,true),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _24b=this._plotFill(_24a.series.fill,dim,_23d);_24b=this._shapeFill(_24b,rect);var _24c=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_24b).setStroke(_24a.series.stroke);if(this.animate){this._animateBubble(_24c,dim.height-_23d.b,item.radius);}return _24c;}return null;},this);if(_241.length){run.dyn.fill=_241[_241.length-1].getFill();run.dyn.stroke=_241[_241.length-1].getStroke();}if(_23e){var _24d=new Array(_241.length);arr.forEach(_241,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_242&&_242[i]||null,shadow:_243&&_243[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_240[i].x,cy:_240[i].y,cr:_240[i].radius};this._connectEvents(o);_24d[i]=o;}},this);this._eventSeries[run.name]=_24d;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;return this;},_animateBubble:function(_24e,_24f,size){fx.animateTransform(lang.delegate({shape:_24e,duration:1200,transform:[{name:"translate",start:[0,_24f],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./on","./has","./mouse"],function(dojo,on,has,_250){function _251(type){return function(node,_252){return on(node,type,_252);};};var _253=has("touch");dojo.touch={press:_251(_253?"touchstart":"mousedown"),move:_251(_253?"touchmove":"mousemove"),release:_251(_253?"touchend":"mouseup"),cancel:_253?_251("touchcancel"):_250.leave};return dojo.touch;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_254){var _255=g.gradutils={};function _256(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _254.blendColors(new _254(prev.color),new _254(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_255.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _257=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_258=m.rotate(-_257),_259=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_259,pt),pf1=m.multiplyPoint(_259,fill.x1,fill.y1),pf2=m.multiplyPoint(_259,fill.x2,fill.y2),_25a=m.multiplyPoint(_258,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_258,p.x-pf1.x,p.y-pf1.y).x/_25a;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _256(o,fill.colors);}return new _254(fill||[0,0,0,0]);};_255.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _255;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){lang.getObject("string",true,dojo);dojo.string.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};dojo.string.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=dojo.string.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};dojo.string.substitute=function(_25b,map,_25c,_25d){_25d=_25d||dojo.global;_25c=_25c?lang.hitch(_25d,_25c):function(v){return v;};return _25b.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_25e,key,_25f){var _260=lang.getObject(key,false,map);if(_25f){_260=lang.getObject(_25f,false,_25d).call(_25d,_260,key);}return _25c(_260,key).toString();});};dojo.string.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return dojo.string;});},"dijit/registry":function(){define("dijit/registry",["dojo/_base/array","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window","."],function(_261,has,_262,win,_263){var _264={},hash={};var _265={length:0,add:function(_266){if(hash[_266.id]){throw new Error("Tried to register widget with id=="+_266.id+" but that id is already registered");}hash[_266.id]=_266;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_267){var id;do{id=_267+"_"+(_267 in _264?++_264[_267]:_264[_267]=0);}while(hash[id]);return _263._scopeName=="dijit"?id:_263._scopeName+"_"+id;},findWidgets:function(root){var _268=[];function _269(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _26a=node.getAttribute("widgetId");if(_26a){var _26b=hash[_26a];if(_26b){_268.push(_26b);}}else{_269(node);}}}};_269(root);return _268;},_destroyAll:function(){_263._curFocus=null;_263._prevFocus=null;_263._activeStack=[];_261.forEach(_265.findWidgets(win.body()),function(_26c){if(!_26c._destroyed){if(_26c.destroyRecursive){_26c.destroyRecursive();}else{if(_26c.destroy){_26c.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.getAttribute&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};if(has("ie")){_262.addOnWindowUnload(function(){_265._destroyAll();});}_263.registry=_265;return _265;});},"dojox/charting/plot2d/Lines":function(){define("dojox/charting/plot2d/Lines",["dojo/_base/declare","./Default"],function(_26d,_26e){return _26d("dojox.charting.plot2d.Lines",_26e,{constructor:function(){this.opt.lines=true;}});});},"dijit/_base/manager":function(){define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","../registry",".."],function(_26f,_270,_271,_272){_26f.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_272[name]=_271[name];});_272.defaultDuration=_270["defaultDuration"]||200;return _272;});},"dojox/charting/plot2d/StackedAreas":function(){define("dojox/charting/plot2d/StackedAreas",["dojo/_base/declare","./Stacked"],function(_273,_274){return _273("dojox.charting.plot2d.StackedAreas",_274,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/plot2d/Stacked":function(){define("dojox/charting/plot2d/Stacked",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Default","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,_275,arr,_276,dc,df,dfr,dfs){var _277=dfr.lambda("item.purgeGroup()");return _275("dojox.charting.plot2d.Stacked",_276,{getSeriesStats:function(){var _278=dc.collectStackedStats(this.series);this._maxRunLength=_278.hmax;return _278;},render:function(dim,_279){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_279);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_277);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_27a=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _27b=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_27c,_27d=arr.map(acc,function(v,i){return {x:ht(i+1)+_279.l,y:dim.height-_279.b-vt(v)};},this);var _27e=this.opt.tension?dc.curve(_27d,this.opt.tension):"";if(this.opt.areas){var _27f=lang.clone(_27d);if(this.opt.tension){var p=dc.curve(_27f,this.opt.tension);p+=" L"+_27d[_27d.length-1].x+","+(dim.height-_279.b)+" L"+_27d[0].x+","+(dim.height-_279.b)+" L"+_27d[0].x+","+_27d[0].y;run.dyn.fill=s.createPath(p).setFill(_27b.series.fill).getFill();}else{_27f.push({x:_27d[_27d.length-1].x,y:dim.height-_279.b});_27f.push({x:_27d[0].x,y:dim.height-_279.b});_27f.push(_27d[0]);run.dyn.fill=s.createPolyline(_27f).setFill(_27b.series.fill).getFill();}}if(this.opt.lines||this.opt.markers){if(_27b.series.outline){_27c=dc.makeStroke(_27b.series.outline);_27c.width=2*_27c.width+_27b.series.stroke.width;}}if(this.opt.markers){run.dyn.marker=_27b.symbol;}var _280,_281,_282;if(_27b.series.shadow&&_27b.series.stroke){var _283=_27b.series.shadow,_284=arr.map(_27d,function(c){return {x:c.x+_283.dx,y:c.y+_283.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_284,this.opt.tension)).setStroke(_283).getStroke();}else{run.dyn.shadow=s.createPolyline(_284).setStroke(_283).getStroke();}}if(this.opt.markers){_283=_27b.marker.shadow;_282=arr.map(_284,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_27b.symbol).setStroke(_283).setFill(_283.color);},this);}}if(this.opt.lines){if(_27c){if(this.opt.tension){run.dyn.outline=s.createPath(_27e).setStroke(_27c).getStroke();}else{run.dyn.outline=s.createPolyline(_27d).setStroke(_27c).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_27e).setStroke(_27b.series.stroke).getStroke();}else{run.dyn.stroke=s.createPolyline(_27d).setStroke(_27b.series.stroke).getStroke();}}if(this.opt.markers){_280=new Array(_27d.length);_281=new Array(_27d.length);_27c=null;if(_27b.marker.outline){_27c=dc.makeStroke(_27b.marker.outline);_27c.width=2*_27c.width+(_27b.marker.stroke?_27b.marker.stroke.width:0);}arr.forEach(_27d,function(c,i){var path="M"+c.x+" "+c.y+" "+_27b.symbol;if(_27c){_281[i]=s.createPath(path).setStroke(_27c);}_280[i]=s.createPath(path).setStroke(_27b.marker.stroke).setFill(_27b.marker.fill);},this);if(_27a){var _285=new Array(_280.length);arr.forEach(_280,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_281[i]||null,shadow:_282&&_282[i]||null,cx:_27d[i].x,cy:_27d[i].y,x:i+1,y:run.data[i]};this._connectEvents(o);_285[i]=o;},this);this._eventSeries[run.name]=_285;}else{delete this._eventSeries[run.name];}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojo/fx/easing":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _286=lang.getObject("dojo.fx.easing",true);var _287={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_287.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _287.bounceIn(n*2)/2;}return (_287.bounceOut(n*2-1)/2)+0.5;}};lang.mixin(_286,_287);return _287;});},"dojox/charting/action2d/Highlight":function(){define("dojox/charting/action2d/Highlight",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(dojo,lang,_288,_289,hub,c,_28a,dfe,dgf){var _28b=100,_28c=75,_28d=50,cc=function(_28e){return function(){return _28e;};},hl=function(_28f){var a=new c.Color(_28f),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_28b;if(x.l<_28d){x.l=_28c;}else{if(x.l>_28c){x.l=_28d;}else{x.l=x.l-_28d>_28c-x.l?_28d:_28c;}}}return c.fromHsl(x);};return _288("dojox.charting.action2d.Highlight",_28a,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_290,plot,_291){var a=_291&&_291.highlight;this.colorFun=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _292=o.run.name,_293=o.index,anim,_294,_295;if(_292 in this.anim){anim=this.anim[_292][_293];}else{this.anim[_292]={};}if(anim){anim.action.stop(true);}else{var _296=o.shape.getFill();if(!_296||!(_296 instanceof _289)){return;}this.anim[_292][_293]=anim={start:_296,end:this.colorFun(_296)};}var _297=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_297;_297=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_297,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_292]){delete this.anim[_292][_293];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define("dojox/charting/axis2d/Base",["dojo/_base/declare","../Element"],function(_298,_299){return _298("dojox.charting.axis2d.Base",_299,{constructor:function(_29a,_29b){this.vertical=_29b&&_29b.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_29c){this.dirty=false;return this;}});});},"dojox/color/Palette":function(){define("dojox/color/Palette",["dojo/_base/kernel","../main","dojo/_base/lang","dojo/_base/array","./_base"],function(dojo,_29d,lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function _29e(p,_29f,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(_29f=="dr")?item.r+val:item.r,g=(_29f=="dg")?item.g+val:item.g,b=(_29f=="db")?item.b+val:item.b,a=(_29f=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_2a0,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(_2a0=="dc")?o.c+val:o.c,m=(_2a0=="dm")?o.m+val:o.m,y=(_2a0=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _2a1(p,_2a2,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_2a2=="dc")?o.c+val:o.c,m=(_2a2=="dm")?o.m+val:o.m,y=(_2a2=="dy")?o.y+val:o.y,k=(_2a2=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_2a3,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(_2a3=="dh")?o.h+val:o.h,s=(_2a3=="ds")?o.s+val:o.s,l=(_2a3=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_2a4,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(_2a4=="dh")?o.h+val:o.h,s=(_2a4=="ds")?o.s+val:o.s,v=(_2a4=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _2a5(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_2a6){var fn=_29e;if(_2a6.use){var use=_2a6.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_2a1;}else{fn=tCMY;}}}}else{if("dc" in _2a6||"dm" in _2a6||"dy" in _2a6){if("dk" in _2a6){fn=_2a1;}else{fn=tCMY;}}else{if("dh" in _2a6||"ds" in _2a6){if("dv" in _2a6){fn=tHSV;}else{fn=tHSL;}}}}var _2a7=this;for(var p in _2a6){if(p=="use"){continue;}_2a7=fn(_2a7,p,_2a6[p]);}return _2a7;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_2a5(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_2a5(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_2a8=args.da||30,hsv=base.toHsv();var _2a9=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_2a9-_2a8+360)%360,h2=(_2a9+_2a8)%360,s1=Math.max(hsv.s-10,0),s2=_2a5(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/sniff","./_base/manager","."],function(_2aa,_2ab,_2ac,dom,_2ad,_2ae,has,_2af,_2b0){var _2b1=(_2b0._isElementShown=function(elem){var s=_2ae.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_2ad.get(elem,"type")!="hidden");});_2b0.hasDefaultTabStop=function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _2ad.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _2b2=elem.contentDocument;if("designMode" in _2b2&&_2b2.designMode=="on"){return true;}body=_2b2.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}};var _2b3=(_2b0.isTabNavigable=function(elem){if(_2ad.get(elem,"disabled")){return false;}else{if(_2ad.has(elem,"tabIndex")){return _2ad.get(elem,"tabIndex")>=0;}else{return _2b0.hasDefaultTabStop(elem);}}});_2b0._getTabNavigable=function(root){var _2b4,last,_2b5,_2b6,_2b7,_2b8,_2b9={};function _2ba(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _2bb=function(_2bc){for(var _2bd=_2bc.firstChild;_2bd;_2bd=_2bd.nextSibling){if(_2bd.nodeType!=1||(has("ie")&&_2bd.scopeName!=="HTML")||!_2b1(_2bd)){continue;}if(_2b3(_2bd)){var _2be=_2ad.get(_2bd,"tabIndex");if(!_2ad.has(_2bd,"tabIndex")||_2be==0){if(!_2b4){_2b4=_2bd;}last=_2bd;}else{if(_2be>0){if(!_2b5||_2be<_2b6){_2b6=_2be;_2b5=_2bd;}if(!_2b7||_2be>=_2b8){_2b8=_2be;_2b7=_2bd;}}}var rn=_2ba(_2bd);if(_2ad.get(_2bd,"checked")&&rn){_2b9[rn]=_2bd;}}if(_2bd.nodeName.toUpperCase()!="SELECT"){_2bb(_2bd);}}};if(_2b1(root)){_2bb(root);}function rs(node){return _2b9[_2ba(node)]||node;};return {first:rs(_2b4),last:rs(last),lowest:rs(_2b5),highest:rs(_2b7)};};_2b0.getFirstInTabbingOrder=function(root){var _2bf=_2b0._getTabNavigable(dom.byId(root));return _2bf.lowest?_2bf.lowest:_2bf.first;};_2b0.getLastInTabbingOrder=function(root){var _2c0=_2b0._getTabNavigable(dom.byId(root));return _2c0.last?_2c0.last:_2c0.highest;};return {hasDefaultTabStop:_2b0.hasDefaultTabStop,isTabNavigable:_2b0.isTabNavigable,_getTabNavigable:_2b0._getTabNavigable,getFirstInTabbingOrder:_2b0.getFirstInTabbingOrder,getLastInTabbingOrder:_2b0.getLastInTabbingOrder};});},"dojox/charting/plot2d/Grid":function(){define("dojox/charting/plot2d/Grid",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","../Element","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2c1,hub,arr,_2c2,dc,du,fx){return _2c1("dojox.charting.plot2d.Grid",_2c2,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none",animate:null,enableCache:false},optionalParams:{},constructor:function(_2c3,_2c4){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2c4);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;this.animate=this.opt.animate;this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];}},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},initializeScalers:function(){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,_2c5){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_2c6=dim.height-_2c5.b,_2c7=this._hAxis.getScaler().bounds,_2c8=(_2c7.from-_2c7.lower)*_2c7.scale,_2c9=this._vAxis.getScaler().bounds,_2ca=(_2c9.from-_2c9.lower)*_2c9.scale,_2cb=vs/this.lastWindow.vscale,_2cc=hs/this.lastWindow.hscale,_2cd=(this.lastWindow.xoffset-_2c8)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_2ce=(_2ca-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_2cf=this.group,anim=fx.animateTransform(lang.delegate({shape:_2cf,duration:1200,transform:[{name:"translate",start:[0,0],end:[_2c5.l*(1-_2cc),_2c6*(1-_2cb)]},{name:"scale",start:[1,1],end:[_2cc,_2cb]},{name:"original"},{name:"translate",start:[0,0],end:[_2cd,_2ce]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_2c8,yoffset:_2ca});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},getRequiredColors:function(){return 0;},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];}},createLine:function(_2d0,_2d1){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2d1);_2d0.add(line);}else{line=_2d0.createLine(_2d1);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_2d2){if(this.zoom){return this.performZoom(dim,_2d2);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _2d3=this._vAxis.getScaler(),vt=_2d3.scaler.getTransformerFromModel(_2d3),_2d4=this._vAxis.getTicks();if(_2d4!=null){if(this.opt.hMinorLines){arr.forEach(_2d4.minor,function(tick){var y=dim.height-_2d2.b-vt(tick.value);var _2d5=this.createLine(s,{x1:_2d2.l,y1:y,x2:dim.width-_2d2.r,y2:y}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_2d5,"h",_2d2.l,_2d2.r+_2d2.l-dim.width);}},this);}if(this.opt.hMajorLines){arr.forEach(_2d4.major,function(tick){var y=dim.height-_2d2.b-vt(tick.value);var _2d6=this.createLine(s,{x1:_2d2.l,y1:y,x2:dim.width-_2d2.r,y2:y}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_2d6,"h",_2d2.l,_2d2.r+_2d2.l-dim.width);}},this);}}}catch(e){}try{var _2d7=this._hAxis.getScaler(),ht=_2d7.scaler.getTransformerFromModel(_2d7),_2d4=this._hAxis.getTicks();if(this!=null){if(_2d4&&this.opt.vMinorLines){arr.forEach(_2d4.minor,function(tick){var x=_2d2.l+ht(tick.value);var _2d8=this.createLine(s,{x1:x,y1:_2d2.t,x2:x,y2:dim.height-_2d2.b}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(_2d8,"v",dim.height-_2d2.b,dim.height-_2d2.b-_2d2.t);}},this);}if(_2d4&&this.opt.vMajorLines){arr.forEach(_2d4.major,function(tick){var x=_2d2.l+ht(tick.value);var _2d9=this.createLine(s,{x1:x,y1:_2d2.t,x2:x,y2:dim.height-_2d2.b}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(_2d9,"v",dim.height-_2d2.b,dim.height-_2d2.b-_2d2.t);}},this);}}}catch(e){}this.dirty=false;return this;},_animateGrid:function(_2da,type,_2db,size){var _2dc=type=="h"?[_2db,0]:[0,_2db];var _2dd=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_2da,duration:1200,transform:[{name:"translate",start:_2dc,end:[0,0]},{name:"scale",start:_2dd,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/fold":function(){define("dojox/lang/functional/fold",["dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(lang,arr,win,df){var _2de={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _2de)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _2df=true;for(i in a){if(!(i in _2de)){if(_2df){z=a[i];_2df=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||win.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dojox/charting/plot2d/Spider":function(){define("dojox/charting/plot2d/Spider",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/_base/sniff","../Element","./_PlotEvents","dojo/_base/Color","dojox/color/_base","./common","../axis2d/common","../scaler/primitive","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_2e0,hub,html,arr,_2e1,_2e2,_2e3,has,_2e4,_2e5,_2e6,_2e7,dc,da,_2e8,g,m,_2e9,df,du,_2ea){var _2eb=0.2;var _2ec=_2e0("dojox.charting.plot2d.Spider",[_2e4,_2e5],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_2ea.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_2ed,_2ee){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2ee);du.updateWithPattern(this.opt,_2ee,this.optionalParams);this.series=[];this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.dirty=true;this.dyn=[];this.series=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){return this;},addSeries:function(run){var _2ef=false;this.series.push(run);for(var key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(var key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_2f0){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_2f0.hmin,_2f0.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_2e8.buildScaler(_2f0.hmin,_2f0.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_2f0.vmin,_2f0.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_2e8.buildScaler(_2f0.vmin,_2f0.vmax,dim.height);}return this;},render:function(dim,_2f1){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_2f1.l-_2f1.r)/2,ry=(dim.height-_2f1.t-_2f1.b)/2,r=Math.min(rx,ry),_2f2=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_2f3=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_2f4=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_2f5=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_2f6=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_2f7=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_2f8=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_2f9=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_2fa=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_2fb=g.normalizedLength(g.splitFontString(_2f3).size),_2fc=m._degToRad(o.startAngle),_2fd=_2fc,step,_2fe,_2ff,_300,_301,_302,_303,_304,_305,_306,_307,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_308=o.labelOffset<-10?o.labelOffset:-10,_309=0.2;if(o.labels){_300=arr.map(this.series,function(s){return s.name;},this);_301=df.foldl1(df.map(_300,function(_30a,i){var font=t.series.font;return g._base._getTextBox(_30a,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_301,ry-_2fb)+_308;_302=r-_308;}if("radius" in o){r=o.radius;_302=r-_308;}r/=(1+_309);var _30b={cx:_2f1.l+rx,cy:_2f1.t+ry,r:r};for(var i=this.series.length-1;i>=0;i--){var _30c=this.series[i];if(!this.dirty&&!_30c.dirty){t.skip();continue;}_30c.cleanGroup();var run=_30c.data;if(run!==null){var len=this._getObjectLength(run);if(!_303||_303.length<=0){_303=[],_304=[],_307=[];this._buildPoints(_303,len,_30b,r,_2fd,true);this._buildPoints(_304,len,_30b,r*ro,_2fd,true);this._buildPoints(_307,len,_30b,_302,_2fd);if(dv>2){_305=[],_306=[];for(var j=0;j<dv-2;j++){_305[j]=[];this._buildPoints(_305[j],len,_30b,r*(ro+(1-ro)*(j+1)/(dv-1)),_2fd,true);_306[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _30d=s.createGroup(),_30e={color:_2f6,width:_2f8},_30f={color:_2f7,width:_2f9};for(var j=_303.length-1;j>=0;--j){var _310=_303[j],st={x:_310.x+(_310.x-_30b.cx)*_309,y:_310.y+(_310.y-_30b.cy)*_309},nd={x:_310.x+(_310.x-_30b.cx)*_309/2,y:_310.y+(_310.y-_30b.cy)*_309/2};_30d.createLine({x1:_30b.cx,y1:_30b.cy,x2:st.x,y2:st.y}).setStroke(_30e);this._drawArrow(_30d,st,nd,_30e);}var _311=s.createGroup();for(var j=_307.length-1;j>=0;--j){var _310=_307[j],_312=g._base._getTextBox(this.labelKey[j],{font:_2f3}).w||0,_313=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx",elem=da.createText[_313](this.chart,_311,(!_2e1.isBodyLtr()&&_313=="html")?(_310.x+_312-dim.width):_310.x,_310.y,"middle",this.labelKey[j],_2f3,_2f5);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _314=s.createGroup();if(spt=="polygon"){_314.createPolyline(_303).setStroke(_30f);_314.createPolyline(_304).setStroke(_30f);if(_305.length>0){for(var j=_305.length-1;j>=0;--j){_314.createPolyline(_305[j]).setStroke(_30f);}}}else{var _315=this._getObjectLength(this.datas);_314.createCircle({cx:_30b.cx,cy:_30b.cy,r:r}).setStroke(_30f);_314.createCircle({cx:_30b.cx,cy:_30b.cy,r:r*ro}).setStroke(_30f);if(_306.length>0){for(var j=_306.length-1;j>=0;--j){_314.createCircle({cx:_30b.cx,cy:_30b.cy,r:_306[j]}).setStroke(_30f);}}}var _316=s.createGroup(),len=this._getObjectLength(this.datas),k=0;for(var key in this.datas){var data=this.datas[key],min=data.min,max=data.max,_317=max-min,end=_2fd+2*Math.PI*k/len;for(var i=0;i<dv;i++){var text=min+_317*i/(dv-1),_310=this._getCoordinate(_30b,r*(ro+(1-ro)*i/(dv-1)),end);text=this._getLabel(text);var _312=g._base._getTextBox(text,{font:_2f2}).w||0,_313=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_313](this.chart,_316,(!_2e1.isBodyLtr()&&_313=="html")?(_310.x+_312-dim.width):_310.x,_310.y,"start",text,_2f2,_2f4));}}k++;}this.chart.seriesShapes={};var _318=[];for(var i=this.series.length-1;i>=0;i--){var _30c=this.series[i],run=_30c.data;if(run!==null){var _319=[],k=0,_31a=[];for(var key in run){var data=this.datas[key],min=data.min,max=data.max,_317=max-min,_31b=run[key],end=_2fd+2*Math.PI*k/len,_310=this._getCoordinate(_30b,r*(ro+(1-ro)*(_31b-min)/_317),end);_319.push(_310);_31a.push({sname:_30c.name,key:key,data:_31b});k++;}_319[_319.length]=_319[0];_31a[_31a.length]=_31a[0];var _31c=this._getBoundary(_319),_31d=t.next("spider",[o,_30c]),ts=_30c.group,f=g.normalizeColor(_31d.series.fill),sk={color:_31d.series.fill,width:_2fa};f.a=o.seriesFillAlpha;_30c.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_30c.name];var cs=this._createSeriesEntry(ts,(osps||_304),_319,f,sk,r,ro,ms,at);this.chart.seriesShapes[_30c.name]=cs;this.oldSeriePoints[_30c.name]=_319;var po={element:"spider_poly",index:i,id:"spider_poly_"+_30c.name,run:_30c,plot:this,shape:cs.poly,parent:ts,brect:_31c,cx:_30b.cx,cy:_30b.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_30c.name,run:_30c,plot:this,shape:_30c.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var _31e=c.getShape(),co={element:"spider_circle",index:i,id:"spider_circle_"+_30c.name+i,run:_30c,plot:this,shape:c,parent:ts,tdata:_31a[i],cx:_319[i].x,cy:_319[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _31f=ts.createPolyline(osps).setFill(f).setStroke(sk),_320=[];for(var j=0;j<osps.length;j++){var _321=osps[j],cr=ms;var _322=ts.createCircle({cx:_321.x,cy:_321.y,r:cr}).setFill(f).setStroke(sk);_320.push(_322);}var _323=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2e2.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_31f,sc=_320[j];hub.connect(anim,"onAnimate",function(y){var _324=spl.getShape();_324.points[j].y=y;spl.setShape(_324);var _325=sc.getShape();_325.cy=y;sc.setShape(_325);});return anim;});var _326=arr.map(sps,function(np,j){var sp=osps[j],anim=new _2e2.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_31f,sc=_320[j];hub.connect(anim,"onAnimate",function(x){var _327=spl.getShape();_327.points[j].x=x;spl.setShape(_327);var _328=sc.getShape();_328.cx=x;sc.setShape(_328);});return anim;});var _329=_2e3.combine(_323.concat(_326));_329.play();return {group:ts,poly:_31f,circles:_320};},plotEvent:function(o){var _32a=o.id?o.id:"default",a;if(_32a in this.animations){a=this.animations[_32a];a.anim&&a.anim.stop(true);}else{a=this.animations[_32a]={};}if(o.element=="spider_poly"){if(!a.color){var _32b=o.shape.getFill();if(!_32b||!(_32b instanceof Color)){return;}a.color={start:_32b,end:_32c(_32b)};}var _32d=a.color.start,end=a.color.end;if(o.type=="onmouseout"){var t=_32d;_32d=end;end=t;}a.anim=_2e9.animateFill({shape:o.shape,duration:800,easing:_2e3.easing.backOut,color:{start:_32d,end:end}});a.anim.play();}else{if(o.element=="spider_circle"){var init,_32e,_32f=1.5;if(o.type=="onmouseover"){init=m.identity;_32e=_32f;var _330={type:"rect"};_330.x=o.cx;_330.y=o.cy;_330.width=_330.height=1;var lt=html.coords(this.chart.node,true);_330.x+=lt.x;_330.y+=lt.y;_330.x=Math.round(_330.x);_330.y=Math.round(_330.y);_330.width=Math.ceil(_330.width);_330.height=Math.ceil(_330.height);this.aroundRect=_330;var _331=["after","before"];dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_332){_332.show(o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data,this.aroundRect,_331);}));}else{init=m.scaleAt(_32f,o.cx,o.cy);_32e=1/_32f;dc.doIfLoaded("dijit/Tooltip",dojo.hitch(this,function(_333){this.aroundRect&&_333.hide(this.aroundRect);}));}var cs=o.shape.getShape(),init=m.scaleAt(_32f,cs.cx,cs.cy),_334={shape:o.shape,duration:200,easing:_2ea.backOut,transform:[{name:"scaleAt",start:[1,cs.cx,cs.cy],end:[_32e,cs.cx,cs.cy]},init]};a.anim=_2e9.animateTransform(_334);a.anim.play();}else{if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}}}},_getBoundary:function(_335){var xmax=_335[0].x,xmin=_335[0].x,ymax=_335[0].y,ymin=_335[0].y;for(var i=0;i<_335.length;i++){var _336=_335[i];xmax=Math.max(_336.x,xmax);ymax=Math.max(_336.y,ymax);xmin=Math.min(_336.x,xmin);ymin=Math.min(_336.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_337,end,_338){var len=Math.sqrt(Math.pow(end.x-_337.x,2)+Math.pow(end.y-_337.y,2)),sin=(end.y-_337.y)/len,cos=(end.x-_337.x)/len,_339={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_33a={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_337,_339,_33a]).setFill(_338.color).setStroke(_338);},_buildPoints:function(_33b,_33c,_33d,_33e,_33f,_340){for(var i=0;i<_33c;i++){var end=_33f+2*Math.PI*i/_33c;_33b.push(this._getCoordinate(_33d,_33e,end));}if(_340){_33b.push(this._getCoordinate(_33d,_33e,_33f+2*Math.PI));}},_getCoordinate:function(_341,_342,_343){return {x:_341.cx+_342*Math.cos(_343),y:_341.cy+_342*Math.sin(_343)};},_getObjectLength:function(obj){var _344=0;if(lang.isObject(obj)){for(var key in obj){_344++;}}return _344;},_getLabel:function(_345){return dc.getLabel(_345,this.opt.fixed,this.opt.precision);}});function _32c(_346){var a=new _2e7.Color(_346),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=100;if(x.l<50){x.l=75;}else{if(x.l>75){x.l=50;}else{x.l=x.l-50>75-x.l?50:75;}}}var _346=_2e7.fromHsl(x);_346.a=0.7;return _346;};return _2ec;});},"dojox/charting/plot2d/StackedBars":function(){define("dojox/charting/plot2d/StackedBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_347,Bars,dc,df,dfr,dfs){var _348=dfr.lambda("item.purgeGroup()");return _347("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _349=dc.collectStackedStats(this.series),t;this._maxRunLength=_349.hmax;_349.hmin-=0.5;_349.hmax+=0.5;t=_349.hmin,_349.hmin=_349.vmin,_349.vmin=t;t=_349.hmax,_349.hmax=_349.vmax,_349.vmax=t;return _349;},render:function(dim,_34a){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _34b=run.data[j];if(_34b!==null){var v=typeof _34b=="number"?_34b:_34b.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_34a);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_348);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_34c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_34d=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_34c=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _34e=t.next("bar",[this.opt,run]),s=run.group,_34f=new Array(acc.length);for(var j=0;j<acc.length;++j){var _34b=run.data[j];if(_34b!==null){var v=acc[j],_350=ht(v),_351=typeof _34b!="number"?t.addMixin(_34e,"bar",_34b,true):t.post(_34e,"bar");if(_350>=0&&_34c>=1){var rect={x:_34a.l,y:dim.height-_34a.b-vt(j+1.5)+gap,width:_350,height:_34c};var _352=this._plotFill(_351.series.fill,dim,_34a);_352=this._shapeFill(_352,rect);var _353=s.createRect(rect).setFill(_352).setStroke(_351.series.stroke);run.dyn.fill=_353.getFill();run.dyn.stroke=_353.getStroke();if(_34d){var o={element:"bar",index:j,run:run,shape:_353,x:v,y:j+1.5};this._connectEvents(o);_34f[j]=o;}if(this.animate){this._animateBar(_353,_34a.l,-_350);}}}}this._eventSeries[run.name]=_34f;run.dirty=false;for(var j=0;j<run.data.length;++j){var _34b=run.data[j];if(_34b!==null){var v=typeof _34b=="number"?_34b:_34b.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojox/charting/themes/GreySkies":function(){define("dojox/charting/themes/GreySkies",["../Theme","./common"],function(_354,_355){_355.GreySkies=new _354(_354._def);return _355.GreySkies;});},"dojox/charting/plot2d/Columns":function(){define("dojox/charting/plot2d/Columns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_356,Base,dc,df,dfr,du,fx){var _357=dfr.lambda("item.purgeGroup()");return _356("dojox.charting.plot2d.Columns",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_358,_359){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_359);du.updateWithPattern(this.opt,_359,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _35a=dc.collectSimpleStats(this.series);_35a.hmin-=0.5;_35a.hmax+=0.5;return _35a;},createRect:function(run,_35b,_35c){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_35c);_35b.add(rect);}else{rect=_35b.createRect(_35c);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_35d){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_35d);}var t=this.getSeriesStats();this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_357);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_35e,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_35f=Math.max(0,this._vScaler.bounds.lower),_360=vt(_35f),min=Math.max(0,Math.floor(this._hScaler.bounds.from-1)),max=Math.ceil(this._hScaler.bounds.to),_361=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_35e=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _362=t.next("column",[this.opt,run]),s=run.group,_363=new Array(run.data.length);var l=Math.min(run.data.length,max);for(var j=min;j<l;++j){var _364=run.data[j];if(_364!==null){var v=typeof _364=="number"?_364:_364.y,vv=vt(v),_365=vv-_360,h=Math.abs(_365),_366=typeof _364!="number"?t.addMixin(_362,"column",_364,true):t.post(_362,"column");if(_35e>=1&&h>=0){var rect={x:_35d.l+ht(j+0.5)+gap,y:dim.height-_35d.b-(v>_35f?vv:_360),width:_35e,height:h};var _367=this._plotFill(_366.series.fill,dim,_35d);_367=this._shapeFill(_367,rect);var _368=this.createRect(run,s,rect).setFill(_367).setStroke(_366.series.stroke);run.dyn.fill=_368.getFill();run.dyn.stroke=_368.getStroke();if(_361){var o={element:"column",index:j,run:run,shape:_368,x:j+0.5,y:v};this._connectEvents(o);_363[j]=o;}if(this.animate){this._animateColumn(_368,dim.height-_35d.b-_360,h);}}}}this._eventSeries[run.name]=_363;run.dirty=false;}this.dirty=false;return this;},_animateColumn:function(_369,_36a,_36b){fx.animateTransform(lang.delegate({shape:_369,duration:1200,transform:[{name:"translate",start:[0,_36a-(_36a/_36b)],end:[0,0]},{name:"scale",start:[1,1/_36b],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/place":function(){define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","."],function(_36c,_36d,_36e,_36f,win,_370,_371){function _372(node,_373,_374,_375){var view=_370.getBox();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body().appendChild(node);}var best=null;_36c.some(_373,function(_376){var _377=_376.corner;var pos=_376.pos;var _378=0;var _379={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_377.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_377.charAt(0)]};if(_374){var res=_374(node,_376.aroundCorner,_377,_379,_375);_378=typeof res=="undefined"?0:res;}var _37a=node.style;var _37b=_37a.display;var _37c=_37a.visibility;if(_37a.display=="none"){_37a.visibility="hidden";_37a.display="";}var mb=_36d.getMarginBox(node);_37a.display=_37b;_37a.visibility=_37c;var _37d={"L":pos.x,"R":pos.x-mb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(mb.w>>1))-mb.w)}[_377.charAt(1)],_37e={"T":pos.y,"B":pos.y-mb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(mb.h>>1))-mb.h)}[_377.charAt(0)],_37f=Math.max(view.l,_37d),_380=Math.max(view.t,_37e),endX=Math.min(view.l+view.w,_37d+mb.w),endY=Math.min(view.t+view.h,_37e+mb.h),_381=endX-_37f,_382=endY-_380;_378+=(mb.w-_381)+(mb.h-_382);if(best==null||_378<best.overflow){best={corner:_377,aroundCorner:_376.aroundCorner,x:_37f,y:_380,w:_381,h:_382,overflow:_378,spaceAvailable:_379};}return !_378;});if(best.overflow&&_374){_374(node,best.aroundCorner,best.corner,best.spaceAvailable,_375);}var l=_36d.isBodyLtr(),s=node.style;s.top=best.y+"px";s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";s[l?"right":"left"]="auto";return best;};return (_371.place={at:function(node,pos,_383,_384){var _385=_36c.map(_383,function(_386){var c={corner:_386,pos:{x:pos.x,y:pos.y}};if(_384){c.pos.x+=_386.charAt(1)=="L"?_384.x:-_384.x;c.pos.y+=_386.charAt(0)=="T"?_384.y:-_384.y;}return c;});return _372(node,_385);},around:function(node,_387,_388,_389,_38a){var _38b=(typeof _387=="string"||"offsetWidth" in _387)?_36d.position(_387,true):_387;if(_387.parentNode){var _38c=_387.parentNode;while(_38c&&_38c.nodeType==1&&_38c.nodeName!="BODY"){var _38d=_36d.position(_38c,true);var _38e=_36e.getComputedStyle(_38c).overflow;if(_38e=="hidden"||_38e=="auto"||_38e=="scroll"){var _38f=Math.min(_38b.y+_38b.h,_38d.y+_38d.h);var _390=Math.min(_38b.x+_38b.w,_38d.x+_38d.w);_38b.x=Math.max(_38b.x,_38d.x);_38b.y=Math.max(_38b.y,_38d.y);_38b.h=_38f-_38b.y;_38b.w=_390-_38b.x;}_38c=_38c.parentNode;}}var x=_38b.x,y=_38b.y,_391="w" in _38b?_38b.w:(_38b.w=_38b.width),_392="h" in _38b?_38b.h:(_36f.deprecated("place.around: dijit.place.__Rectangle: { x:"+x+", y:"+y+", height:"+_38b.height+", width:"+_391+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_38b.height+", w:"+_391+" }","","2.0"),_38b.h=_38b.height);var _393=[];function push(_394,_395){_393.push({aroundCorner:_394,corner:_395,pos:{x:{"L":x,"R":x+_391,"M":x+(_391>>1)}[_394.charAt(1)],y:{"T":y,"B":y+_392,"M":y+(_392>>1)}[_394.charAt(0)]}});};_36c.forEach(_388,function(pos){var ltr=_389;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after":ltr=!ltr;case "before":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _396=_372(node,_393,_38a,{w:_391,h:_392});_396.aroundNodePos=_38b;return _396;}});});},"dojox/lang/functional/array":function(){define("dojox/lang/functional/array",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/window","./lambda"],function(dojo,lang,arr,win,df){var _397={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _397)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _397)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _397)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _397)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||win.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _397)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/Theme":function(){define("dojox/charting/Theme",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/color/_base","dojox/color/Palette","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_398,_399,_39a,_39b,dlu,dgg){var _39c=_398("dojox.charting.Theme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_39d){_39d=_39d||{};var def=_39c.defaultTheme;arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_39d[name]);},this);if(_39d.seriesThemes&&_39d.seriesThemes.length){this.colors=null;this.seriesThemes=_39d.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_39d.colors||_39c.defaultColors).slice(0);}this.markerThemes=null;if(_39d.markerThemes&&_39d.markerThemes.length){this.markerThemes=_39d.markerThemes.slice(0);}this.markers=_39d.markers?lang.clone(_39d.markers):lang.delegate(_39c.defaultMarkers);this.noGradConv=_39d.noGradConv;this.noRadialConv=_39d.noRadialConv;if(_39d.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _39e=new _39c({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_39e[name]=this[name];}},this);return _39e;},clear:function(){this._current=0;},next:function(_39f,_3a0,_3a1){var _3a2=dlu.merge,_3a3,_3a4;if(this.colors){_3a3=lang.delegate(this.series);_3a4=lang.delegate(this.marker);var _3a5=new _399(this.colors[this._current%this.colors.length]),old;if(_3a3.stroke&&_3a3.stroke.color){_3a3.stroke=lang.delegate(_3a3.stroke);old=new _399(_3a3.stroke.color);_3a3.stroke.color=new _399(_3a5);_3a3.stroke.color.a=old.a;}else{_3a3.stroke={color:_3a5};}if(_3a4.stroke&&_3a4.stroke.color){_3a4.stroke=lang.delegate(_3a4.stroke);old=new _399(_3a4.stroke.color);_3a4.stroke.color=new _399(_3a5);_3a4.stroke.color.a=old.a;}else{_3a4.stroke={color:_3a5};}if(!_3a3.fill||_3a3.fill.type){_3a3.fill=_3a5;}else{old=new _399(_3a3.fill);_3a3.fill=new _399(_3a5);_3a3.fill.a=old.a;}if(!_3a4.fill||_3a4.fill.type){_3a4.fill=_3a5;}else{old=new _399(_3a4.fill);_3a4.fill=new _399(_3a5);_3a4.fill.a=old.a;}}else{_3a3=this.seriesThemes?_3a2(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_3a4=this.markerThemes?_3a2(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_3a3;}var _3a6=_3a4&&_3a4.symbol||this._markers[this._current%this._markers.length];var _3a7={series:_3a3,marker:_3a4,symbol:_3a6};++this._current;if(_3a0){_3a7=this.addMixin(_3a7,_39f,_3a0);}if(_3a1){_3a7=this.post(_3a7,_39f);}return _3a7;},skip:function(){++this._current;},addMixin:function(_3a8,_3a9,_3aa,_3ab){if(lang.isArray(_3aa)){arr.forEach(_3aa,function(m){_3a8=this.addMixin(_3a8,_3a9,m);},this);}else{var t={};if("color" in _3aa){if(_3a9=="line"||_3a9=="area"){lang.setObject("series.stroke.color",_3aa.color,t);lang.setObject("marker.stroke.color",_3aa.color,t);}else{lang.setObject("series.fill",_3aa.color,t);}}arr.forEach(["stroke","outline","shadow","fill","font","fontColor","labelWiring"],function(name){var _3ac="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_3ac in _3aa;if(name in _3aa){lang.setObject("series."+name,_3aa[name],t);if(!b){lang.setObject("marker."+name,_3aa[name],t);}}if(b){lang.setObject("marker."+name,_3aa[_3ac],t);}});if("marker" in _3aa){t.symbol=_3aa.marker;}_3a8=dlu.merge(_3a8,t);}if(_3ab){_3a8=this.post(_3a8,_3a9);}return _3a8;},post:function(_3ad,_3ae){var fill=_3ad.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_3ae=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_3ae=="slice"||_3ae=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_3ad,{series:{fill:t}});}}return _3ad;},getTick:function(name,_3af){var tick=this.axis.tick,_3b0=name+"Tick",_3b1=dlu.merge;if(tick){if(this.axis[_3b0]){tick=_3b1(tick,this.axis[_3b0]);}}else{tick=this.axis[_3b0];}if(_3af){if(tick){if(_3af[_3b0]){tick=_3b1(tick,_3af[_3b0]);}}else{tick=_3af[_3b0];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_3b2){this.markers[name]=_3b2;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_39c,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",titleGap:15,titleFont:"normal normal normal 11pt Tahoma",titleFontColor:"#333",titleOrientation:"axis"},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}},defineColors:function(_3b3){_3b3=_3b3||{};var l,c=[],n=_3b3.num||5;if(_3b3.colors){l=_3b3.colors.length;for(var i=0;i<n;i++){c.push(_3b3.colors[i%l]);}return c;}if(_3b3.hue){var s=_3b3.saturation||100,st=_3b3.low||30,end=_3b3.high||90;l=(end+st)/2;return _39a.Palette.generate(_39a.fromHsv(_3b3.hue,s,l),"monochromatic").colors;}if(_3b3.generator){return _39a.Palette.generate(_3b3.base,_3b3.generator).colors;}return c;},generateGradient:function(_3b4,_3b5,_3b6){var fill=lang.delegate(_3b4);fill.colors=[{offset:0,color:_3b5},{offset:1,color:_3b6}];return fill;},generateHslColor:function(_3b7,_3b8){_3b7=new _399(_3b7);var hsl=_3b7.toHsl(),_3b9=_39a.fromHsl(hsl.h,hsl.s,_3b8);_3b9.a=_3b7.a;return _3b9;},generateHslGradient:function(_3ba,_3bb,_3bc,_3bd){_3ba=new _399(_3ba);var hsl=_3ba.toHsl(),_3be=_39a.fromHsl(hsl.h,hsl.s,_3bc),_3bf=_39a.fromHsl(hsl.h,hsl.s,_3bd);_3be.a=_3bf.a=_3ba.a;return _39c.generateGradient(_3bb,_3be,_3bf);}});return _39c;});},"dojox/charting/themes/common":function(){define("dojox/charting/themes/common",["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define("dojox/charting/plot2d/common",["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3c0,g,df,sc){var _3c1=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3c1,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3c2){if(!_3c2){return _3c2;}if(typeof _3c2=="string"||_3c2 instanceof _3c0){_3c2={color:_3c2};}return g.makeParameters(g.defaultStroke,_3c2);},augmentColor:function(_3c3,_3c4){var t=new _3c0(_3c3),c=new _3c0(_3c4);c.a=t.a;return c;},augmentStroke:function(_3c5,_3c6){var s=_3c1.makeStroke(_3c5);if(s){s.color=_3c1.augmentColor(s.color,_3c6);}return s;},augmentFill:function(fill,_3c7){var fc,c=new _3c0(_3c7);if(typeof fill=="string"||fill instanceof _3c0){return _3c1.augmentColor(fill,_3c7);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3c8){var _3c9=lang.delegate(_3c1.defaultStats);for(var i=0;i<_3c8.length;++i){var run=_3c8[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3ca=_3c9.vmin,_3cb=_3c9.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3c9.hmin=Math.min(_3c9.hmin,x);_3c9.hmax=Math.max(_3c9.hmax,x);_3c9.vmin=Math.min(_3c9.vmin,y);_3c9.vmax=Math.max(_3c9.vmax,y);}});}if("ymin" in run){_3c9.vmin=Math.min(_3ca,run.ymin);}if("ymax" in run){_3c9.vmax=Math.max(_3cb,run.ymax);}}else{var _3cc=_3c9.hmin,_3cd=_3c9.hmax,_3ca=_3c9.vmin,_3cb=_3c9.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3c9.hmin=Math.min(_3c9.hmin,x);_3c9.hmax=Math.max(_3c9.hmax,x);_3c9.vmin=Math.min(_3c9.vmin,y);_3c9.vmax=Math.max(_3c9.vmax,y);}});}if("xmin" in run){_3c9.hmin=Math.min(_3cc,run.xmin);}if("xmax" in run){_3c9.hmax=Math.max(_3cd,run.xmax);}if("ymin" in run){_3c9.vmin=Math.min(_3ca,run.ymin);}if("ymax" in run){_3c9.vmax=Math.max(_3cb,run.ymax);}}break;}}}return _3c9;},calculateBarSize:function(_3ce,opt,_3cf){if(!_3cf){_3cf=1;}var gap=opt.gap,size=(_3ce-2*gap)/_3cf;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3ce-size*_3cf)/2;return {size:size,gap:gap};},collectStackedStats:function(_3d0){var _3d1=lang.clone(_3c1.defaultStats);if(_3d0.length){_3d1.hmin=Math.min(_3d1.hmin,1);_3d1.hmax=df.foldl(_3d0,"seed, run -> Math.max(seed, run.data.length)",_3d1.hmax);for(var i=0;i<_3d1.hmax;++i){var v=_3d0[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3d1.vmin=Math.min(_3d1.vmin,v);for(var j=1;j<_3d0.length;++j){var t=_3d0[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3d1.vmax=Math.max(_3d1.vmax,v);}}return _3d1;},curve:function(a,_3d2){var _3d3=a.slice(0);if(_3d2=="x"){_3d3[_3d3.length]=arr[0];}var p=arr.map(_3d3,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3d2)){var dx=item.x-_3d3[i-1].x,dy=_3d3[i-1].y;return "C"+(item.x-(_3d2-1)*(dx/_3d2))+","+dy+" "+(item.x-(dx/_3d2))+","+item.y+" "+item.x+","+item.y;}else{if(_3d2=="X"||_3d2=="x"||_3d2=="S"){var p0,p1=_3d3[i-1],p2=_3d3[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3d2=="x"){p0=_3d3[_3d3.length-2];}else{p0=p1;}f=1/3;}else{p0=_3d3[i-2];}if(i==(_3d3.length-1)){if(_3d2=="x"){p3=_3d3[1];}else{p3=p2;}f=1/3;}else{p3=_3d3[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3d4=p0p2*f;var _3d5=p1p3*f;if(_3d4>p1p2/2&&_3d5>p1p2/2){_3d4=p1p2/2;_3d5=p1p2/2;}else{if(_3d4>p1p2/2){_3d4=p1p2/2;_3d5=p1p2/2*p1p3/p0p2;}else{if(_3d5>p1p2/2){_3d5=p1p2/2;_3d4=p1p2/2*p0p2/p1p3;}}}if(_3d2=="S"){if(p0==p1){_3d4=0;}if(p2==p3){_3d5=0;}}bz1x=p1.x+_3d4*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3d4*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3d5*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3d5*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3d6,_3d7,_3d8){return sc.doIfLoaded("dojo/number",function(_3d9){return (_3d7?_3d9.format(_3d6,{places:_3d8}):_3d9.format(_3d6))||"";},function(){return _3d7?_3d6.toFixed(_3d8):_3d6.toString();});}});});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3da,_3db,_3dc,_3dd,_3de,lang,_3df,_3e0,_3e1,_3e2,_3e3,_3e4){function _3e5(){};function _3e6(_3e7){return function(obj,_3e8,_3e9,_3ea){if(obj&&typeof _3e8=="string"&&obj[_3e8]==_3e5){return obj.on(_3e8.substring(2).toLowerCase(),lang.hitch(_3e9,_3ea));}return _3e7.apply(_3dc,arguments);};};_3da.around(_3dc,"connect",_3e6);if(_3de.connect){_3da.around(_3de,"connect",_3e6);}var _3eb=_3dd("dijit._Widget",[_3e2,_3e3,_3e4],{onClick:_3e5,onDblClick:_3e5,onKeyDown:_3e5,onKeyPress:_3e5,onKeyUp:_3e5,onMouseDown:_3e5,onMouseMove:_3e5,onMouseOut:_3e5,onMouseOver:_3e5,onMouseLeave:_3e5,onMouseEnter:_3e5,onMouseUp:_3e5,constructor:function(_3ec){this._toConnect={};for(var name in _3ec){if(this[name]===_3e5){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3ec[name];delete _3ec[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3e5){return _3dc.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3ed){_3de.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3ed);},attr:function(name,_3ee){if(_3db.isDebug){var _3ef=arguments.callee._ach||(arguments.callee._ach={}),_3f0=(arguments.callee.caller||"unknown caller").toString();if(!_3ef[_3f0]){_3de.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_3f0,"","2.0");_3ef[_3f0]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3de.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3df("[widgetId]",this.containerNode).map(_3e1.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(!_3de.isAsync){_3e0(0,function(){var _3f1=["dijit/_base"];require(_3f1);});}return _3eb;});},"dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_3f2,_3f3,_3f4,lang){lang.extend(_3f3,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _3f4("dijit._FocusMixin",null,{_focusManager:_3f2});});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(on,_3f5,keys,_3f6,has,_3f7,win){var _3f8=null;if(has("ie")){(function(){var _3f9=function(evt){_3f8=evt.srcElement;};win.doc.attachEvent("onkeydown",_3f9);_3f7.addOnWindowUnload(function(){win.doc.detachEvent("onkeydown",_3f9);});})();}else{win.doc.addEventListener("keydown",function(evt){_3f8=evt.target;},true);}var _3fa=function(node,_3fb){if(/input|button/i.test(node.nodeName)){return on(node,"click",_3fb);}else{function _3fc(e){return (e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;};var _3fd=[on(node,"keypress",function(e){if(_3fc(e)){_3f8=e.target;e.preventDefault();}}),on(node,"keyup",function(e){if(_3fc(e)&&e.target==_3f8){_3f8=null;_3fb.call(this,e);}}),on(node,"click",function(e){_3fb.call(this,e);})];return {remove:function(){_3f5.forEach(_3fd,function(h){h.remove();});}};}};return _3f6("dijit._OnDijitClickMixin",null,{connect:function(obj,_3fe,_3ff){return this.inherited(arguments,[obj,_3fe=="ondijitclick"?_3fa:_3fe,_3ff]);}});});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo,text){return dojo.cache;});},"dojox/charting/plot2d/Bars":function(){define("dojox/charting/plot2d/Bars",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(dojo,lang,arr,_400,Base,dc,fx,du,df,dfr){var _401=dfr.lambda("item.purgeGroup()");return _400("dojox.charting.plot2d.Bars",Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_402,_403){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_403);du.updateWithPattern(this.opt,_403,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var _404=dc.collectSimpleStats(this.series),t;_404.hmin-=0.5;_404.hmax+=0.5;t=_404.hmin,_404.hmin=_404.vmin,_404.vmin=t;t=_404.hmax,_404.hmax=_404.vmax,_404.vmax=t;return _404;},createRect:function(run,_405,_406){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_406);_405.add(rect);}else{rect=_405.createRect(_406);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_407){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_407);}this.dirty=this.isDirty();this.resetEvents();if(this.dirty){arr.forEach(this.series,_401);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_408,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_409=Math.max(0,this._hScaler.bounds.lower),_40a=ht(_409),_40b=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_408=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _40c=t.next("bar",[this.opt,run]),s=run.group,_40d=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _40e=run.data[j];if(_40e!==null){var v=typeof _40e=="number"?_40e:_40e.y,hv=ht(v),_40f=hv-_40a,w=Math.abs(_40f),_410=typeof _40e!="number"?t.addMixin(_40c,"bar",_40e,true):t.post(_40c,"bar");if(w>=0&&_408>=1){var rect={x:_407.l+(v<_409?hv:_40a),y:dim.height-_407.b-vt(j+1.5)+gap,width:w,height:_408};var _411=this._plotFill(_410.series.fill,dim,_407);_411=this._shapeFill(_411,rect);var _412=this.createRect(run,s,rect).setFill(_411).setStroke(_410.series.stroke);run.dyn.fill=_412.getFill();run.dyn.stroke=_412.getStroke();if(_40b){var o={element:"bar",index:j,run:run,shape:_412,x:v,y:j+1.5};this._connectEvents(o);_40d[j]=o;}if(this.animate){this._animateBar(_412,_407.l+_40a,-w);}}}}this._eventSeries[run.name]=_40d;run.dirty=false;}this.dirty=false;return this;},_animateBar:function(_413,_414,_415){fx.animateTransform(lang.delegate({shape:_413,duration:1200,transform:[{name:"translate",start:[_414-(_414/_415),0],end:[0,0]},{name:"scale",start:[1/_415,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define("dojox/gfx/_base",["dojo/_base/lang","dojo/_base/html","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(lang,html,_416,has,win,arr,dom,_417,_418){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_419){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_419+" ")>=0;};g._addClass=function(node,_41a){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_41a+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_41a);}};g._removeClass=function(node,_41b){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_41b+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _41c={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_417.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _41c){div.style.fontSize=p;_41c[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _41c;};var _41d=null;b._getCachedFontMeasurements=function(_41e){if(_41e||!_41d){_41d=b._getFontMeasurements();}return _41d;};var _41f=null,_420={};b._getTextBox=function(text,_421,_422){var m,s,al=arguments.length;var i;if(!_41f){_41f=_417.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_41f;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_421){for(i in _421){if(i in _420){continue;}s[i]=_421[i];}}if(al>2&&_422){m.className=_422;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _418.getMarginBox(m);}};var _423=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"xUnique"+(++_423);}while(dom.byId(id));return id;};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _424={};return function(type){var t=_424[type];if(t){return new t();}t=_424[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_425){return (_425 instanceof _416)?_425:new _416(_425);},normalizeParameters:function(_426,_427){var x;if(_427){var _428={};for(x in _426){if(x in _427&&!(x in _428)){_426[x]=_427[x];}}}return _426;},makeParameters:function(_429,_42a){var i=null;if(!_42a){return lang.delegate(_429);}var _42b={};for(i in _429){if(!(i in _42b)){_42b[i]=lang.clone((i in _42a)?_42a[i]:_429[i]);}}return _42b;},formatNumber:function(x,_42c){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _42d=val.indexOf(".");if(_42d>=0&&val.length-_42d>5){val=x.toFixed(4);}}if(x<0){return val;}return _42c?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _42e=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_42e;case "in":return val*72*_42e;case "pc":return val*12*_42e;case "mm":return val*g.mm_in_pt*_42e;case "cm":return val*g.cm_in_pt*_42e;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_42f){var ns=typeof _42f=="string"?g[_42f]:_42f;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});}}});return g;});},"dijit/focus":function(){define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","."],function(_430,_431,dom,_432,_433,_434,lang,on,_435,has,_436,_437,win,_438,a11y,_439,_43a){var _43b=_431([_436,_434],{curNode:null,activeStack:[],constructor:function(){var _43c=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_430.before(_433,"empty",_43c);_430.before(_433,"destroy",_43c);},registerIframe:function(_43d){return this.registerWin(_43d.contentWindow,_43d);},registerWin:function(_43e,_43f){var _440=this;var _441=function(evt){_440._justMouseDowned=true;setTimeout(function(){_440._justMouseDowned=false;},0);if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){return;}_440._onTouchNode(_43f||evt.target||evt.srcElement,"mouse");};var doc=has("ie")?_43e.document.documentElement:_43e.document;if(doc){if(has("ie")){_43e.document.body.attachEvent("onmousedown",_441);var _442=function(evt){var tag=evt.srcElement.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.srcElement)){_440._onFocusNode(_43f||evt.srcElement);}else{_440._onTouchNode(_43f||evt.srcElement);}};doc.attachEvent("onactivate",_442);var _443=function(evt){_440._onBlurNode(_43f||evt.srcElement);};doc.attachEvent("ondeactivate",_443);return {remove:function(){_43e.document.detachEvent("onmousedown",_441);doc.detachEvent("onactivate",_442);doc.detachEvent("ondeactivate",_443);doc=null;}};}else{doc.body.addEventListener("mousedown",_441,true);doc.body.addEventListener("touchstart",_441,true);var _444=function(evt){_440._onFocusNode(_43f||evt.target);};doc.addEventListener("focus",_444,true);var _445=function(evt){_440._onBlurNode(_43f||evt.target);};doc.addEventListener("blur",_445,true);return {remove:function(){doc.body.removeEventListener("mousedown",_441,true);doc.body.removeEventListener("touchstart",_441,true);doc.removeEventListener("focus",_444,true);doc.removeEventListener("blur",_445,true);doc=null;}};}}},_onBlurNode:function(){this.set("prevNode",this.curNode);this.set("curNode",null);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);this.prevNode=null;}),100);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _446=[];try{while(node){var _447=_432.get(node,"dijitPopupParent");if(_447){node=_439.byId(_447).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_438.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_448=id&&_439.byId(id);if(_448&&!(by=="mouse"&&_448.get("disabled"))){_446.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_446,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("curNode",node);},_setStack:function(_449,by){var _44a=this.activeStack;this.set("activeStack",_449);for(var _44b=0;_44b<Math.min(_44a.length,_449.length);_44b++){if(_44a[_44b]!=_449[_44b]){break;}}var _44c;for(var i=_44a.length-1;i>=_44b;i--){_44c=_439.byId(_44a[i]);if(_44c){_44c._hasBeenBlurred=true;_44c.set("focused",false);if(_44c._focusManager==this){_44c._onBlur(by);}this.emit("widget-blur",_44c,by);}}for(i=_44b;i<_449.length;i++){_44c=_439.byId(_449[i]);if(_44c){_44c.set("focused",true);if(_44c._focusManager==this){_44c._onFocus(by);}this.emit("widget-focus",_44c,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _44d=new _43b();_435(function(){var _44e=_44d.registerWin(win.doc.parentWindow||win.doc.defaultView);if(has("ie")){_437.addOnWindowUnload(function(){_44e.remove();_44e=null;});}});_43a.focus=function(node){_44d.focus(node);};for(var attr in _44d){if(!/^_/.test(attr)){_43a.focus[attr]=typeof _44d[attr]=="function"?lang.hitch(_44d,attr):_44d[attr];}}_44d.watch(function(attr,_44f,_450){_43a.focus[attr]=_450;});return _44d;});},"dojox/charting/widget/Legend":function(){define("dojox/charting/widget/Legend",["dojo/_base/lang","dojo/_base/html","dojo/_base/declare","dijit/_Widget","dojox/gfx","dojo/_base/array","dojox/lang/functional","dojox/lang/functional/array","dojox/lang/functional/fold","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/_base/manager"],function(lang,html,_451,_452,gfx,_453,df,dfa,dff,dom,_454,_455,_456){var _457=/\.(StackedColumns|StackedAreas|ClusteredBars)$/;return _451("dojox.charting.widget.Legend",_452,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=_456.byId(this.chartRef);if(!this.chart){var node=dom.byId(this.chartRef);if(node){this.chart=_456.byNode(node);}else{return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},buildRendering:function(){this.domNode=_454.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_454.create("tbody",null,this.domNode);this.inherited(arguments);},refresh:function(){if(this._surfaces){_453.forEach(this._surfaces,function(_458){_458.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_454.destroy(this.legendBody.lastChild);}if(this.horizontal){_455.add(this.domNode,"dojoxLegendHorizontal");this._tr=_454.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _459=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_459,"<= 0")){return;}var _45a=df.map(_459,"/this",df.foldl(_459,"+",0));_453.forEach(_45a,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{_453.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{if(this._isReversal()){s=s.slice(0).reverse();}_453.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_45b){var _45c=_454.create("td"),icon=_454.create("div",null,_45c),text=_454.create("label",null,_45c),div=_454.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_455.add(icon,"dojoxLegendIcon dijitInline");_455.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_45c);if(++this._inrow===this.horizontal){this._tr=_454.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_454.create("tr",null,this.legendBody);tr.appendChild(_45c);}this._makeIcon(div,dyn);text.innerHTML=String(_45b);text.dir=this.getTextDir(_45b,text.dir);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _45d=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_45d);if(dyn.fill){_45d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_45d.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_45d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_45d.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_45d.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_45d.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_45d.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}},_isReversal:function(){return (!this.horizontal)&&_453.some(this.chart.stack,function(item){return _457.test(item.declaredClass);});}});});},"dojox/charting/plot2d/StackedLines":function(){define("dojox/charting/plot2d/StackedLines",["dojo/_base/declare","./Stacked"],function(_45e,_45f){return _45e("dojox.charting.plot2d.StackedLines",_45f,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define("dojox/charting/plot2d/StackedColumns",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Columns","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/functional/sequence"],function(lang,arr,_460,_461,dc,df,dfr,dfs){var _462=dfr.lambda("item.purgeGroup()");return _460("dojox.charting.plot2d.StackedColumns",_461,{getSeriesStats:function(){var _463=dc.collectStackedStats(this.series);this._maxRunLength=_463.hmax;_463.hmin-=0.5;_463.hmax+=0.5;return _463;},render:function(dim,_464){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var _465=run.data[j];if(_465!==null){var v=typeof _465=="number"?_465:_465.y;if(isNaN(v)){v=0;}acc[j]+=v;}}}if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_464);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_462);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_466,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_467=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_466=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _468=t.next("column",[this.opt,run]),s=run.group,_469=new Array(acc.length);for(var j=0;j<acc.length;++j){var _465=run.data[j];if(_465!==null){var v=acc[j],_46a=vt(v),_46b=typeof _465!="number"?t.addMixin(_468,"column",_465,true):t.post(_468,"column");if(_466>=1&&_46a>=0){var rect={x:_464.l+ht(j+0.5)+gap,y:dim.height-_464.b-vt(v),width:_466,height:_46a};var _46c=this._plotFill(_46b.series.fill,dim,_464);_46c=this._shapeFill(_46c,rect);var _46d=s.createRect(rect).setFill(_46c).setStroke(_46b.series.stroke);run.dyn.fill=_46d.getFill();run.dyn.stroke=_46d.getStroke();if(_467){var o={element:"column",index:j,run:run,shape:_46d,x:j+0.5,y:v};this._connectEvents(o);_469[j]=o;}if(this.animate){this._animateColumn(_46d,dim.height-_464.b,_46a);}}}}this._eventSeries[run.name]=_469;run.dirty=false;for(var j=0;j<run.data.length;++j){var _465=run.data[j];if(_465!==null){var v=typeof _465=="number"?_465:_465.y;if(isNaN(v)){v=0;}acc[j]-=v;}}}this.dirty=false;return this;}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_46e,_46f){return _46e("dojox.charting.Series",_46f,{constructor:function(_470,data,_471){lang.mixin(this,_471);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define("dojox/charting/plot2d/Default",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","./Base","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_472,arr,Base,dc,df,dfr,du,fx){var _473=dfr.lambda("item.purgeGroup()");var _474=1200;return _472("dojox.charting.plot2d.Default",Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_475,_476){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_476);du.updateWithPattern(this.opt,_476,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},createPath:function(run,_477,_478){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_478);_477.add(path);}else{path=_477.createPath(_478);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},render:function(dim,_479){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_479);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_473);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_47a,_47b,_47c,_47d=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _47e=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,_47f=[],_480=[],rseg=null,_481,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_482=this._eventSeries[run.name]=new Array(run.data.length);var _483=typeof run.data[0]=="number";var min=_483?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_483?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;j++){if(run.data[j]!=null){if(!rseg){rseg=[];_480.push(j);_47f.push(rseg);}rseg.push(run.data[j]);}else{rseg=null;}}for(var seg=0;seg<_47f.length;seg++){if(typeof _47f[seg][0]=="number"){_481=arr.map(_47f[seg],function(v,i){return {x:ht(i+_480[seg]+1)+_479.l,y:dim.height-_479.b-vt(v)};},this);}else{_481=arr.map(_47f[seg],function(v,i){return {x:ht(v.x)+_479.l,y:dim.height-_479.b-vt(v.y)};},this);}var _484=this.opt.tension?dc.curve(_481,this.opt.tension):"";if(this.opt.areas&&_481.length>1){var fill=_47e.series.fill;var _485=lang.clone(_481);if(this.opt.tension){var _486="L"+_485[_485.length-1].x+","+(dim.height-_479.b)+" L"+_485[0].x+","+(dim.height-_479.b)+" L"+_485[0].x+","+_485[0].y;run.dyn.fill=s.createPath(_484+" "+_486).setFill(fill).getFill();}else{_485.push({x:_481[_481.length-1].x,y:dim.height-_479.b});_485.push({x:_481[0].x,y:dim.height-_479.b});_485.push(_481[0]);run.dyn.fill=s.createPolyline(_485).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_47a=_47e.series.stroke;if(_47e.series.outline){_47b=run.dyn.outline=dc.makeStroke(_47e.series.outline);_47b.width=2*_47b.width+_47a.width;}}if(this.opt.markers){run.dyn.marker=_47e.symbol;}var _487=null,_488=null,_489=null;if(_47a&&_47e.series.shadow&&_481.length>1){var _48a=_47e.series.shadow,_48b=arr.map(_481,function(c){return {x:c.x+_48a.dx,y:c.y+_48a.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_48b,this.opt.tension)).setStroke(_48a).getStroke();}else{run.dyn.shadow=s.createPolyline(_48b).setStroke(_48a).getStroke();}}if(this.opt.markers&&_47e.marker.shadow){_48a=_47e.marker.shadow;_489=arr.map(_48b,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_47e.symbol).setStroke(_48a).setFill(_48a.color);},this);}}if(this.opt.lines&&_481.length>1){if(_47b){if(this.opt.tension){run.dyn.outline=s.createPath(_484).setStroke(_47b).getStroke();}else{run.dyn.outline=s.createPolyline(_481).setStroke(_47b).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_484).setStroke(_47a).getStroke();}else{run.dyn.stroke=s.createPolyline(_481).setStroke(_47a).getStroke();}}if(this.opt.markers){_487=new Array(_481.length);_488=new Array(_481.length);_47b=null;if(_47e.marker.outline){_47b=dc.makeStroke(_47e.marker.outline);_47b.width=2*_47b.width+(_47e.marker.stroke?_47e.marker.stroke.width:0);}arr.forEach(_481,function(c,i){var path="M"+c.x+" "+c.y+" "+_47e.symbol;if(_47b){_488[i]=this.createPath(run,s,path).setStroke(_47b);}_487[i]=this.createPath(run,s,path).setStroke(_47e.marker.stroke).setFill(_47e.marker.fill);},this);run.dyn.markerFill=_47e.marker.fill;run.dyn.markerStroke=_47e.marker.stroke;if(_47d){arr.forEach(_487,function(s,i){var o={element:"marker",index:i+_480[seg],run:run,shape:s,outline:_488[i]||null,shadow:_489&&_489[i]||null,cx:_481[i].x,cy:_481[i].y};if(typeof _47f[seg][0]=="number"){o.x=i+_480[seg]+1;o.y=_47f[seg][i];}else{o.x=_47f[seg][i].x;o.y=_47f[seg][i].y;}this._connectEvents(o);_482[i+_480[seg]]=o;},this);}else{delete this._eventSeries[run.name];}}}run.dirty=false;}if(this.animate){var _48c=this.group;fx.animateTransform(lang.delegate({shape:_48c,duration:_474,transform:[{name:"translate",start:[0,dim.height-_479.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define("dijit/main",["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define("dojox/charting/plot2d/Base",["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","../Element","./_PlotEvents","dojo/_base/array","../scaler/primitive","./common","dojox/gfx/fx"],function(lang,_48d,hub,_48e,_48f,arr,_490,_491,fx){return _48d("dojox.charting.plot2d.Base",[_48e,_48f],{constructor:function(_492,_493){this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_494){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_495){var r={};r.x=th(_495[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_495[av.name]);return r;};return _494?t(_494):t;},toData:function(_496){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_497){var r={};r[ah.name]=th(_497.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_497.y-o.b);return r;};return _496?t(_496):t;},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _491.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},performZoom:function(dim,_498){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_499=dim.height-_498.b,_49a=this._hScaler.bounds,_49b=(_49a.from-_49a.lower)*_49a.scale,_49c=this._vScaler.bounds,_49d=(_49c.from-_49c.lower)*_49c.scale,_49e=vs/this.lastWindow.vscale,_49f=hs/this.lastWindow.hscale,_4a0=(this.lastWindow.xoffset-_49b)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_4a1=(_49d-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_4a2=this.group,anim=fx.animateTransform(lang.delegate({shape:_4a2,duration:1200,transform:[{name:"translate",start:[0,0],end:[_498.l*(1-_49f),_499*(1-_49e)]},{name:"scale",start:[1,1],end:[_49f,_49e]},{name:"original"},{name:"translate",start:[0,0],end:[_4a0,_4a1]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_49b,yoffset:_49d});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},render:function(dim,_4a3){return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,_4a4){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_4a4.hmin,_4a4.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_490.buildScaler(_4a4.hmin,_4a4.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_4a4.vmin,_4a4.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_490.buildScaler(_4a4.vmin,_4a4.vmax,dim.height);}return this;}});});},"dojox/charting/action2d/Tooltip":function(){define("dojox/charting/action2d/Tooltip",["dojo/_base/kernel","dijit/Tooltip","dojo/_base/lang","dojo/_base/html","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(dojo,_4a5,lang,html,_4a6,_4a7,m,df,dfs,dff){var _4a8=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(o.element=="candlestick"){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";}return o.element=="bar"?o.x:o.y;};var pi4=Math.PI/4,pi2=Math.PI/2;return _4a6("dojox.charting.action2d.Tooltip",_4a7,{defaultParams:{text:_4a8},optionalParams:{},constructor:function(_4a9,plot,_4aa){this.text=_4aa&&_4aa.text?_4aa.text:_4a8;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4a5.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||o.type!=="onmouseover"){return;}var _4ab={type:"rect"},_4ac=["after","before"];switch(o.element){case "marker":_4ab.x=o.cx;_4ab.y=o.cy;_4ab.w=_4ab.h=1;break;case "circle":_4ab.x=o.cx-o.cr;_4ab.y=o.cy-o.cr;_4ab.w=_4ab.h=2*o.cr;break;case "column":_4ac=["above","below"];case "bar":_4ab=lang.clone(o.shape.getShape());break;case "candlestick":_4ab.x=o.x;_4ab.y=o.y;_4ab.w=o.width;_4ab.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _4ad=m._degToRad(o.plot.opt.startAngle),_4ae=(this.angles[o.index]+this.angles[o.index+1])/2+_4ad;_4ab.x=o.cx+o.cr*Math.cos(_4ae);_4ab.y=o.cy+o.cr*Math.sin(_4ae);_4ab.w=_4ab.h=1;if(_4ae<pi4){}else{if(_4ae<pi2+pi4){_4ac=["below","above"];}else{if(_4ae<Math.PI+pi4){_4ac=["before","after"];}else{if(_4ae<2*Math.PI-pi4){_4ac=["above","below"];}}}}break;}var lt=this.chart.getCoords();_4ab.x+=lt.x;_4ab.y+=lt.y;_4ab.x=Math.round(_4ab.x);_4ab.y=Math.round(_4ab.y);_4ab.w=Math.ceil(_4ab.w);_4ab.h=Math.ceil(_4ab.h);this.aroundRect=_4ab;var _4af=this.text(o);if(this.chart.getTextDir){var _4b0=(html.style(this.chart.node,"direction")=="rtl");var _4b1=(this.chart.getTextDir(_4af)=="rtl");}if(_4af){if(_4b1&&!_4b0){_4a5.show("<span dir = 'rtl'>"+_4af+"</span>",this.aroundRect,_4ac);}else{if(!_4b1&&_4b0){_4a5.show("<span dir = 'ltr'>"+_4af+"</span>",this.aroundRect,_4ac);}else{_4a5.show(_4af,this.aroundRect,_4ac);}}}}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4b2,_4b3){_4b2.switchTo(_4b3);return _4b2;});},"dojox/charting/Chart2D":function(){define("dojox/charting/Chart2D",["dojo/_base/kernel","dojox","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(dojo,_4b4,_4b5){dojo.deprecated("dojox.charting.Chart2D","Use dojo.charting.Chart instead and require all other components explicitly","2.0");return _4b4.charting.Chart2D=_4b5;});},"dojox/charting/scaler/linear":function(){define("dojox/charting/scaler/linear",["dojo/_base/lang","./common"],function(lang,_4b6){var _4b7=lang.getObject("dojox.charting.scaler.linear",true);var _4b8=3,_4b9=_4b6.findString,_4ba=_4b6.getNumericLabel;var _4bb=function(min,max,_4bc,_4bd,_4be,_4bf,span){_4bc=lang.delegate(_4bc);if(!_4bd){if(_4bc.fixUpper=="major"){_4bc.fixUpper="minor";}if(_4bc.fixLower=="major"){_4bc.fixLower="minor";}}if(!_4be){if(_4bc.fixUpper=="minor"){_4bc.fixUpper="micro";}if(_4bc.fixLower=="minor"){_4bc.fixLower="micro";}}if(!_4bf){if(_4bc.fixUpper=="micro"){_4bc.fixUpper="none";}if(_4bc.fixLower=="micro"){_4bc.fixLower="none";}}var _4c0=_4b9(_4bc.fixLower,["major"])?Math.floor(_4bc.min/_4bd)*_4bd:_4b9(_4bc.fixLower,["minor"])?Math.floor(_4bc.min/_4be)*_4be:_4b9(_4bc.fixLower,["micro"])?Math.floor(_4bc.min/_4bf)*_4bf:_4bc.min,_4c1=_4b9(_4bc.fixUpper,["major"])?Math.ceil(_4bc.max/_4bd)*_4bd:_4b9(_4bc.fixUpper,["minor"])?Math.ceil(_4bc.max/_4be)*_4be:_4b9(_4bc.fixUpper,["micro"])?Math.ceil(_4bc.max/_4bf)*_4bf:_4bc.max;if(_4bc.useMin){min=_4c0;}if(_4bc.useMax){max=_4c1;}var _4c2=(!_4bd||_4bc.useMin&&_4b9(_4bc.fixLower,["major"]))?min:Math.ceil(min/_4bd)*_4bd,_4c3=(!_4be||_4bc.useMin&&_4b9(_4bc.fixLower,["major","minor"]))?min:Math.ceil(min/_4be)*_4be,_4c4=(!_4bf||_4bc.useMin&&_4b9(_4bc.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_4bf)*_4bf,_4c5=!_4bd?0:(_4bc.useMax&&_4b9(_4bc.fixUpper,["major"])?Math.round((max-_4c2)/_4bd):Math.floor((max-_4c2)/_4bd))+1,_4c6=!_4be?0:(_4bc.useMax&&_4b9(_4bc.fixUpper,["major","minor"])?Math.round((max-_4c3)/_4be):Math.floor((max-_4c3)/_4be))+1,_4c7=!_4bf?0:(_4bc.useMax&&_4b9(_4bc.fixUpper,["major","minor","micro"])?Math.round((max-_4c4)/_4bf):Math.floor((max-_4c4)/_4bf))+1,_4c8=_4be?Math.round(_4bd/_4be):0,_4c9=_4bf?Math.round(_4be/_4bf):0,_4ca=_4bd?Math.floor(Math.log(_4bd)/Math.LN10):0,_4cb=_4be?Math.floor(Math.log(_4be)/Math.LN10):0,_4cc=span/(max-min);if(!isFinite(_4cc)){_4cc=1;}return {bounds:{lower:_4c0,upper:_4c1,from:min,to:max,scale:_4cc,span:span},major:{tick:_4bd,start:_4c2,count:_4c5,prec:_4ca},minor:{tick:_4be,start:_4c3,count:_4c6,prec:_4cb},micro:{tick:_4bf,start:_4c4,count:_4c7,prec:0},minorPerMajor:_4c8,microPerMinor:_4c9,scaler:_4b7};};return lang.mixin(_4b7,{buildScaler:function(min,max,span,_4cd){var h={fixUpper:"none",fixLower:"none",natural:false};if(_4cd){if("fixUpper" in _4cd){h.fixUpper=String(_4cd.fixUpper);}if("fixLower" in _4cd){h.fixLower=String(_4cd.fixLower);}if("natural" in _4cd){h.natural=Boolean(_4cd.natural);}}if("min" in _4cd){min=_4cd.min;}if("max" in _4cd){max=_4cd.max;}if(_4cd.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _4cd){min=_4cd.from;h.useMin=false;}if("to" in _4cd){max=_4cd.to;h.useMax=false;}if(max<=min){return _4bb(min,max,h,0,0,0,span);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_4ce=_4cd&&("majorTickStep" in _4cd)?_4cd.majorTickStep:Math.pow(10,mag),_4cf=0,_4d0=0,_4d1;if(_4cd&&("minorTickStep" in _4cd)){_4cf=_4cd.minorTickStep;}else{do{_4cf=_4ce/10;if(!h.natural||_4cf>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,0,span);if(_4d1.bounds.scale*_4d1.minor.tick>_4b8){break;}}_4cf=_4ce/5;if(!h.natural||_4cf>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,0,span);if(_4d1.bounds.scale*_4d1.minor.tick>_4b8){break;}}_4cf=_4ce/2;if(!h.natural||_4cf>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,0,span);if(_4d1.bounds.scale*_4d1.minor.tick>_4b8){break;}}return _4bb(min,max,h,_4ce,0,0,span);}while(false);}if(_4cd&&("microTickStep" in _4cd)){_4d0=_4cd.microTickStep;_4d1=_4bb(min,max,h,_4ce,_4cf,_4d0,span);}else{do{_4d0=_4cf/10;if(!h.natural||_4d0>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,_4d0,span);if(_4d1.bounds.scale*_4d1.micro.tick>_4b8){break;}}_4d0=_4cf/5;if(!h.natural||_4d0>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,_4d0,span);if(_4d1.bounds.scale*_4d1.micro.tick>_4b8){break;}}_4d0=_4cf/2;if(!h.natural||_4d0>0.9){_4d1=_4bb(min,max,h,_4ce,_4cf,_4d0,span);if(_4d1.bounds.scale*_4d1.micro.tick>_4b8){break;}}_4d0=0;}while(false);}return _4d0?_4d1:_4bb(min,max,h,_4ce,_4cf,0,span);},buildTicks:function(_4d2,_4d3){var step,next,tick,_4d4=_4d2.major.start,_4d5=_4d2.minor.start,_4d6=_4d2.micro.start;if(_4d3.microTicks&&_4d2.micro.tick){step=_4d2.micro.tick,next=_4d6;}else{if(_4d3.minorTicks&&_4d2.minor.tick){step=_4d2.minor.tick,next=_4d5;}else{if(_4d2.major.tick){step=_4d2.major.tick,next=_4d4;}else{return null;}}}var _4d7=1/_4d2.bounds.scale;if(_4d2.bounds.to<=_4d2.bounds.from||isNaN(_4d7)||!isFinite(_4d7)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _4d8=[],_4d9=[],_4da=[];while(next<=_4d2.bounds.to+_4d7){if(Math.abs(_4d4-next)<step/2){tick={value:_4d4};if(_4d3.majorLabels){tick.label=_4ba(_4d4,_4d2.major.prec,_4d3);}_4d8.push(tick);_4d4+=_4d2.major.tick;_4d5+=_4d2.minor.tick;_4d6+=_4d2.micro.tick;}else{if(Math.abs(_4d5-next)<step/2){if(_4d3.minorTicks){tick={value:_4d5};if(_4d3.minorLabels&&(_4d2.minMinorStep<=_4d2.minor.tick*_4d2.bounds.scale)){tick.label=_4ba(_4d5,_4d2.minor.prec,_4d3);}_4d9.push(tick);}_4d5+=_4d2.minor.tick;_4d6+=_4d2.micro.tick;}else{if(_4d3.microTicks){_4da.push({value:_4d6});}_4d6+=_4d2.micro.tick;}}next+=step;}return {major:_4d8,minor:_4d9,micro:_4da};},getTransformerFromModel:function(_4db){var _4dc=_4db.bounds.from,_4dd=_4db.bounds.scale;return function(x){return (x-_4dc)*_4dd;};},getTransformerFromPlot:function(_4de){var _4df=_4de.bounds.from,_4e0=_4de.bounds.scale;return function(x){return x/_4e0+_4df;};}});});},"dojox/gfx/renderer":function(){define("dojox/gfx/renderer",["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_4e1){var _4e2=null;return {load:function(id,_4e3,load){if(_4e2&&id!="force"){load(_4e2);return;}var _4e4=_4e1.forceGfxRenderer,_4e5=!_4e4&&(lang.isString(_4e1.gfxRenderer)?_4e1.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_4e6,_4e7;while(!_4e4&&_4e5.length){switch(_4e5.shift()){case "svg":if("SVGAngle" in win.global){_4e4="svg";}break;case "vml":if(has("ie")){_4e4="vml";}break;case "silverlight":try{if(has("ie")){_4e6=new ActiveXObject("AgControl.AgControl");if(_4e6&&_4e6.IsVersionSupported("1.0")){_4e7=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_4e7=true;}}}catch(e){_4e7=false;}finally{_4e6=null;}if(_4e7){_4e4="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_4e4="canvas";}break;}}if(_4e4==="canvas"&&_4e1.canvasEvents!==false){_4e4="canvasWithEvents";}if(_4e1.isDebug){}function _4e8(){_4e3(["dojox/gfx/"+_4e4],function(_4e9){g.renderer=_4e4;_4e2=_4e9;load(_4e9);});};if(_4e4=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_4e8);}else{_4e8();}}};});},"dojox/charting/widget/Chart":function(){define("dojox/charting/widget/Chart",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/_base/html","dojo/_base/declare","dojo/query","dijit/_Widget","../Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda","dijit/_base/manager"],function(_4ea,lang,arr,html,_4eb,_4ec,_4ed,_4ee,du,df,dfl){var _4ef,_4f0,_4f1,_4f2,_4f3,_4f4=function(o){return o;},dc=lang.getObject("dojox.charting");var _4f5=_4eb("dojox.charting.widget.Chart",_4ed,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);n=this.domNode;var axes=_4ec("> .axis",n).map(_4f0).filter(_4f4),_4f6=_4ec("> .plot",n).map(_4f1).filter(_4f4),_4f7=_4ec("> .action",n).map(_4f2).filter(_4f4),_4f8=_4ec("> .series",n).map(_4f3).filter(_4f4);n.innerHTML="";var c=this.chart=new _4ee(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_4f6.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_4f7.map(function(_4f9){return new _4f9.action(c,_4f9.plot,_4f9.kwArgs);});var _4fa=df.foldl(_4f8,function(_4fb,_4fc){if(_4fc.type=="data"){c.addSeries(_4fc.name,_4fc.data,_4fc.kwArgs);_4fb=true;}else{c.addSeries(_4fc.name,[0],_4fc.kwArgs);var kw={};du.updateWithPattern(kw,_4fc.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_4fc.kwArgs.sort){kw.sort=lang.clone(_4fc.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _4fd;if("valueFn" in _4fc.kwArgs){var fn=_4fc.kwArgs.valueFn;_4fd=arr.map(data,function(x){return fn(_4fc.data.getValue(x,_4fc.field,0));});}else{_4fd=arr.map(data,function(x){return _4fc.data.getValue(x,_4fc.field,0);});}c.addSeries(_4fc.name,_4fd,_4fc.kwArgs).render();}});_4fc.data.fetch(kw);}return _4fb;},false);if(_4fa){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize(box);}});_4ef=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_4f0=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=dojo._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=dojo._scopeName+"x.charting.axis2d.Default";}_4ef(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_4f1=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=dojo._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=dojo._scopeName+"x.charting.plot2d.Default";}_4ef(node,type,kw);return o;};_4f2=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=dojo._scopeName+"x.charting.action2d."+type;}var _4fe=eval("("+type+")");if(!_4fe){return null;}o.action=_4fe;}else{return null;}_4ef(node,type,kw);return o;};_4f3=function(node){var ga=lang.partial(html.attr,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};return _4f5;});},"dojox/lang/functional":function(){define("dojox/lang/functional",["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define("dojox/charting/scaler/common",["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _4ff=lang.getObject("dojox.charting.scaler.common",true);var _500={};return lang.mixin(_4ff,{doIfLoaded:function(_501,_502,_503){if(_500[_501]==undefined){try{_500[_501]=require(_501);}catch(e){_500[_501]=null;}}if(_500[_501]){return _502(_500[_501]);}else{return _503();}},findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}return false;},getNumericLabel:function(_504,_505,_506){var def="";_4ff.doIfLoaded("dojo/number",function(_507){def=(_506.fixed?_507.format(_504,{places:_505<0?-_505:0}):_507.format(_504))||"";},function(){def=_506.fixed?_504.toFixed(_505<0?-_505:0):_504.toString();});if(_506.labelFunc){var r=_506.labelFunc(def,_504,_505);if(r){return r;}}if(_506.labels){var l=_506.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_504){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_504)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_504)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_504)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define("dojox/charting/axis2d/common",["dojo/_base/lang","dojo/_base/html","dojo/_base/window","dojo/dom-geometry","dojox/gfx"],function(lang,html,win,_508,g){var _509=lang.getObject("dojox.charting.axis2d.common",true);var _50a=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _50b=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _508.getMarginBox(n).w;}};return lang.mixin(_509,{createText:{gfx:function(_50c,_50d,x,y,_50e,text,font,_50f){return _50d.createText({x:x,y:y,text:text,align:_50e}).setFont(font).setFill(_50f);},html:function(_510,_511,x,y,_512,text,font,_513,_514){var p=win.doc.createElement("div"),s=p.style,_515;if(_510.getTextDir){p.dir=_510.getTextDir(text);}_50a(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_513;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_514){_515=_50b(p);}if(p.dir=="rtl"){x+=_514?_514:_515;}win.body().removeChild(p);s.position="relative";if(_514){s.width=_514+"px";switch(_512){case "middle":s.textAlign="center";s.left=(x-_514/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_514)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_512){case "middle":s.left=Math.floor(x-_515/2)+"px";break;case "end":s.left=Math.floor(x-_515)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_50a(w);w.width="0px";w.height="0px";wrap.appendChild(p);_510.node.insertBefore(wrap,_510.node.firstChild);return wrap;}}});});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/sniff","dojo/_base/unload","dojo/_base/window"],function(lang,_516,_517,_518,_519,_51a,_51b,_51c,has,_51d,win){var _51e=_51b("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _51f=this.declaredClass,_520=this;return _518.substitute(tmpl,this,function(_521,key){if(key.charAt(0)=="!"){_521=lang.getObject(key.substr(1),false,_520);}if(typeof _521=="undefined"){throw new Error(_51f+" template:"+key);}if(_521==null){return "";}return key.charAt(0)=="!"?_521:_521.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_519(this.templatePath,{sanitize:true});}var _522=_51e.getCachedTemplate(this.templateString,this._skipNodeCache);var node;if(lang.isString(_522)){node=_51c.toDom(this._stringRepl(_522));if(node.nodeType!=1){throw new Error("Invalid template: "+_522);}}else{node=_522.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_523){var dest=this.containerNode;if(_523&&dest){while(_523.hasChildNodes()){dest.appendChild(_523.firstChild);}}},_attachTemplateNodes:function(_524,_525){var _526=lang.isArray(_524)?_524:(_524.all||_524.getElementsByTagName("*"));var x=lang.isArray(_524)?0:-1;for(;x<_526.length;x++){var _527=(x==-1)?_524:_526[x];if(this.widgetsInTemplate&&(_525(_527,"dojoType")||_525(_527,"data-dojo-type"))){continue;}var _528=_525(_527,"dojoAttachPoint")||_525(_527,"data-dojo-attach-point");if(_528){var _529,_52a=_528.split(/\s*,\s*/);while((_529=_52a.shift())){if(lang.isArray(this[_529])){this[_529].push(_527);}else{this[_529]=_527;}this._attachPoints.push(_529);}}var _52b=_525(_527,"dojoAttachEvent")||_525(_527,"data-dojo-attach-event");if(_52b){var _52c,_52d=_52b.split(/\s*,\s*/);var trim=lang.trim;while((_52c=_52d.shift())){if(_52c){var _52e=null;if(_52c.indexOf(":")!=-1){var _52f=_52c.split(":");_52c=trim(_52f[0]);_52e=trim(_52f[1]);}else{_52c=trim(_52c);}if(!_52e){_52e=_52c;}this._attachEvents.push(this.connect(_527,_516[_52c]||_52c,_52e));}}}}},destroyRendering:function(){_51a.forEach(this._attachPoints,function(_530){delete this[_530];},this);this._attachPoints=[];_51a.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_51e._templateCache={};_51e.getCachedTemplate=function(_531,_532){var _533=_51e._templateCache;var key=_531;var _534=_533[key];if(_534){try{if(!_534.ownerDocument||_534.ownerDocument==win.doc){return _534;}}catch(e){}_51c.destroy(_534);}_531=_518.trim(_531);if(_532||_531.match(/\$\{([^\}]+)\}/g)){return (_533[key]=_531);}else{var node=_51c.toDom(_531);if(node.nodeType!=1){throw new Error("Invalid template: "+_531);}return (_533[key]=node);}};if(has("ie")){_51d.addOnWindowUnload(function(){var _535=_51e._templateCache;for(var key in _535){var _536=_535[key];if(typeof _536=="object"){_51c.destroy(_536);}delete _535[key];}});}lang.extend(_517,{dojoAttachEvent:"",dojoAttachPoint:""});return _51e;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/window","./lambda"],function(dojo,lang,win,df){var _537={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _537)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _537)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _537)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);for(var i in obj){if(!(i in _537)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||win.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _537)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/kernel","./_base/lang","./_base/sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(dojo,lang,has,_538,dom,geom,_539){lang.getObject("window",true,dojo);dojo.window.getBox=function(){var _53a=(_538.doc.compatMode=="BackCompat")?_538.body():_538.doc.documentElement;var _53b=geom.docScroll();var _53c=_538.doc.parentWindow||_538.doc.defaultView;return {l:_53b.x,t:_53b.y,w:_53c.innerWidth||_53a.clientWidth,h:_53c.innerHeight||_53a.clientHeight};};dojo.window.get=function(doc){if(has("ie")&&window!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;};dojo.window.scrollIntoView=function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_538.doc,body=doc.body||_538.body(),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){node.scrollIntoView(false);return;}var _53d=doc.compatMode=="BackCompat",_53e=(isIE>=9&&node.ownerDocument.parentWindow.frameElement)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_53d?body:html),_53f=isWK?body:_53e,_540=_53e.clientWidth,_541=_53e.clientHeight,rtl=!geom.isBodyLtr(),_542=pos||geom.position(node),el=node.parentNode,_543=function(el){return ((isIE<=6||(isIE&&_53d))?false:(_539.get(el,"position").toLowerCase()=="fixed"));};if(_543(node)){return;}while(el){if(el==body){el=_53f;}var _544=geom.position(el),_545=_543(el);if(el==_53f){_544.w=_540;_544.h=_541;if(_53f==html&&isIE&&rtl){_544.x+=_53f.offsetWidth-_544.w;}if(_544.x<0||!isIE){_544.x=0;}if(_544.y<0||!isIE){_544.y=0;}}else{var pb=geom.getPadBorderExtents(el);_544.w-=pb.w;_544.h-=pb.h;_544.x+=pb.l;_544.y+=pb.t;var _546=el.clientWidth,_547=_544.w-_546;if(_546>0&&_547>0){_544.w=_546;_544.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_547:0;}_546=el.clientHeight;_547=_544.h-_546;if(_546>0&&_547>0){_544.h=_546;}}if(_545){if(_544.y<0){_544.h+=_544.y;_544.y=0;}if(_544.x<0){_544.w+=_544.x;_544.x=0;}if(_544.y+_544.h>_541){_544.h=_541-_544.y;}if(_544.x+_544.w>_540){_544.w=_540-_544.x;}}var l=_542.x-_544.x,t=_542.y-Math.max(_544.y,0),r=l+_542.w-_544.w,bot=t+_542.h-_544.h;if(r*l>0){var s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_53d)||isIE>=9)){s=-s;}_542.x+=el.scrollLeft;el.scrollLeft+=s;_542.x-=el.scrollLeft;}if(bot*t>0){_542.y+=el.scrollTop;el.scrollTop+=Math[t<0?"max":"min"](t,bot);_542.y-=el.scrollTop;}el=(el!=_53f)&&!_545&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}};return dojo.window;});},"dojox/charting/axis2d/Default":function(){define("dojox/charting/axis2d/Default",["dojo/_base/lang","dojo/_base/array","dojo/_base/sniff","dojo/_base/declare","dojo/_base/connect","dojo/_base/html","dojo/dom-geometry","./Invisible","../scaler/common","../scaler/linear","./common","dojox/gfx","dojox/lang/utils"],function(lang,arr,has,_548,_549,html,_54a,_54b,_54c,lin,_54d,g,du){var _54e=4,_54f=45;return _548("dojox.charting.axis2d.Default",_54b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_550,_551){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_551);du.updateWithPattern(this.opt,_551,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}},getOffsets:function(){var s=this.scaler,_552={l:0,r:0,t:0,b:0};if(!s){return _552;}var o=this.opt,_553=0,a,b,c,d,gl=_54c.getNumericLabel,_554=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,_555=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_556=o.titleFont||(ta.tick&&ta.tick.titleFont),_557=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_558=this.chart.theme.getTick("major",o),_559=this.chart.theme.getTick("minor",o),size=_555?g.normalizedLength(g.splitFontString(_555).size):0,_55a=_556?g.normalizedLength(g.splitFontString(_556).size):0,_55b=o.rotation%360,_55c=o.leftBottom,cosr=Math.abs(Math.cos(_55b*Math.PI/180)),sinr=Math.abs(Math.sin(_55b*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(_55b<0){_55b+=360;}if(size){if(this.labels){_553=this._groupLabelWidth(this.labels,_555,o.maxLabelCharCount);}else{_553=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],_555,o.maxLabelCharCount);}_553=o.maxLabelSize?Math.min(o.maxLabelSize,_553):_553;if(this.vertical){var side=_55c?"l":"r";switch(_55b){case 0:case 180:_552[side]=_553;_552.t=_552.b=size/2;break;case 90:case 270:_552[side]=size;_552.t=_552.b=_553/2;break;default:if(_55b<=_54f||(180<_55b&&_55b<=(180+_54f))){_552[side]=size*sinr/2+_553*cosr;_552[_55c?"t":"b"]=size*cosr/2+_553*sinr;_552[_55c?"b":"t"]=size*cosr/2;}else{if(_55b>(360-_54f)||(180>_55b&&_55b>(180-_54f))){_552[side]=size*sinr/2+_553*cosr;_552[_55c?"b":"t"]=size*cosr/2+_553*sinr;_552[_55c?"t":"b"]=size*cosr/2;}else{if(_55b<90||(180<_55b&&_55b<270)){_552[side]=size*sinr+_553*cosr;_552[_55c?"t":"b"]=size*cosr+_553*sinr;}else{_552[side]=size*sinr+_553*cosr;_552[_55c?"b":"t"]=size*cosr+_553*sinr;}}}break;}_552[side]+=_54e+Math.max(_558.length,_559.length)+(o.title?(_55a+_557):0);}else{var side=_55c?"b":"t";switch(_55b){case 0:case 180:_552[side]=size;_552.l=_552.r=_553/2;break;case 90:case 270:_552[side]=_553;_552.l=_552.r=size/2;break;default:if((90-_54f)<=_55b&&_55b<=90||(270-_54f)<=_55b&&_55b<=270){_552[side]=size*sinr/2+_553*cosr;_552[_55c?"r":"l"]=size*cosr/2+_553*sinr;_552[_55c?"l":"r"]=size*cosr/2;}else{if(90<=_55b&&_55b<=(90+_54f)||270<=_55b&&_55b<=(270+_54f)){_552[side]=size*sinr/2+_553*cosr;_552[_55c?"l":"r"]=size*cosr/2+_553*sinr;_552[_55c?"r":"l"]=size*cosr/2;}else{if(_55b<_54f||(180<_55b&&_55b<(180-_54f))){_552[side]=size*sinr+_553*cosr;_552[_55c?"r":"l"]=size*cosr+_553*sinr;}else{_552[side]=size*sinr+_553*cosr;_552[_55c?"l":"r"]=size*cosr+_553*sinr;}}}break;}_552[side]+=_54e+Math.max(_558.length,_559.length)+(o.title?(_55a+_557):0);}}if(_553){this._cachedLabelWidth=_553;}return _552;},cleanGroup:function(_55d){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_55e,_55f,x,y,_560,_561,font,_562,_563){if(!this.opt.enableCache||_55e=="html"){return _54d.createText[_55e](this.chart,_55f,x,y,_560,_561,font,_562,_563);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_561,align:_560});_55f.add(text);}else{text=_54d.createText[_55e](this.chart,_55f,x,y,_560,_561,font,_562,_563);}this._textUsePool.push(text);return text;},createLine:function(_564,_565){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_565);_564.add(line);}else{line=_564.createLine(_565);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_566){if(!this.dirty){return this;}var o=this.opt,ta=this.chart.theme.axis,_567=o.leftBottom,_568=o.rotation%360,_569,stop,_56a,_56b=0,_56c,_56d,_56e,_56f,_570,_571,_572=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_573=o.titleFont||(ta.tick&&ta.tick.titleFont),_574=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_575=o.titleFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_576=(o.titleGap==0)?0:o.titleGap||(ta.tick&&ta.tick.titleGap)||15,_577=o.titleOrientation||(ta.tick&&ta.tick.titleOrientation)||"axis",_578=this.chart.theme.getTick("major",o),_579=this.chart.theme.getTick("minor",o),_57a=this.chart.theme.getTick("micro",o),_57b=Math.max(_578.length,_579.length,_57a.length),_57c="stroke" in o?o.stroke:ta.stroke,size=_572?g.normalizedLength(g.splitFontString(_572).size):0,cosr=Math.abs(Math.cos(_568*Math.PI/180)),sinr=Math.abs(Math.sin(_568*Math.PI/180)),_57d=_573?g.normalizedLength(g.splitFontString(_573).size):0;if(_568<0){_568+=360;}if(this.vertical){_569={y:dim.height-_566.b};stop={y:_566.t};_56a={y:(dim.height-_566.b+_566.t)/2};_56c=size*sinr+(this._cachedLabelWidth||0)*cosr+_54e+Math.max(_578.length,_579.length)+_57d+_576;_56d={x:0,y:-1};_570={x:0,y:0};_56e={x:1,y:0};_56f={x:_54e,y:0};switch(_568){case 0:_571="end";_570.y=size*0.4;break;case 90:_571="middle";_570.x=-size;break;case 180:_571="start";_570.y=-size*0.4;break;case 270:_571="middle";break;default:if(_568<_54f){_571="end";_570.y=size*0.4;}else{if(_568<90){_571="end";_570.y=size*0.4;}else{if(_568<(180-_54f)){_571="start";}else{if(_568<(180+_54f)){_571="start";_570.y=-size*0.4;}else{if(_568<270){_571="start";_570.x=_567?0:size*0.4;}else{if(_568<(360-_54f)){_571="end";_570.x=_567?0:size*0.4;}else{_571="end";_570.y=size*0.4;}}}}}}}if(_567){_569.x=stop.x=_566.l;_56b=(_577&&_577=="away")?90:270;_56a.x=_566.l-_56c+(_56b==270?_57d:0);_56e.x=-1;_56f.x=-_56f.x;}else{_569.x=stop.x=dim.width-_566.r;_56b=(_577&&_577=="axis")?90:270;_56a.x=dim.width-_566.r+_56c-(_56b==270?0:_57d);switch(_571){case "start":_571="end";break;case "end":_571="start";break;case "middle":_570.x+=size;break;}}}else{_569={x:_566.l};stop={x:dim.width-_566.r};_56a={x:(dim.width-_566.r+_566.l)/2};_56c=size*cosr+(this._cachedLabelWidth||0)*sinr+_54e+Math.max(_578.length,_579.length)+_57d+_576;_56d={x:1,y:0};_570={x:0,y:0};_56e={x:0,y:1};_56f={x:0,y:_54e};switch(_568){case 0:_571="middle";_570.y=size;break;case 90:_571="start";_570.x=-size*0.4;break;case 180:_571="middle";break;case 270:_571="end";_570.x=size*0.4;break;default:if(_568<(90-_54f)){_571="start";_570.y=_567?size:0;}else{if(_568<(90+_54f)){_571="start";_570.x=-size*0.4;}else{if(_568<180){_571="start";_570.y=_567?0:-size;}else{if(_568<(270-_54f)){_571="end";_570.y=_567?0:-size;}else{if(_568<(270+_54f)){_571="end";_570.y=_567?size*0.4:0;}else{_571="end";_570.y=_567?size:0;}}}}}}if(_567){_569.y=stop.y=dim.height-_566.b;_56b=(_577&&_577=="axis")?180:0;_56a.y=dim.height-_566.b+_56c-(_56b?_57d:0);}else{_569.y=stop.y=_566.t;_56b=(_577&&_577=="away")?180:0;_56a.y=_566.t-_56c+(_56b?0:_57d);_56e.y=-1;_56f.y=-_56f.y;switch(_571){case "start":_571="end";break;case "end":_571="start";break;case "middle":_570.y-=size;break;}}}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_57e,f=lin.getTransformerFromModel(this.scaler),_57f=(!o.title||!_56b)&&!_568&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_56e.x*_578.length,dy=_56e.y*_578.length;s.createLine({x1:_569.x,y1:_569.y,x2:stop.x,y2:stop.y}).setStroke(_57c);if(o.title){var _580=_54d.createText[_57f](this.chart,s,_56a.x,_56a.y,"middle",o.title,_573,_575);if(_57f=="html"){this.htmlElements.push(_580);}else{_580.setTransform(g.matrix.rotategAt(_56b,_56a.x,_56a.y));}}if(t==null){this.dirty=false;return this;}arr.forEach(t.major,function(tick){var _581=f(tick.value),elem,x=_569.x+_56d.x*_581,y=_569.y+_56d.y*_581;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_578);if(tick.label){var _582=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_572,o.maxLabelCharCount):{text:tick.label,truncated:false};_582=o.maxLabelSize?this.getTextWithLimitLength(_582.text,_572,o.maxLabelSize,_582.truncated):_582;elem=this.createText(_57f,s,x+dx+_56f.x+(_568?0:_570.x),y+dy+_56f.y+(_568?0:_570.y),_571,_582.text,_572,_574);if(this.chart.truncateBidi&&_582.truncated){this.chart.truncateBidi(elem,tick.label,_57f);}_582.truncated&&this.labelTooltip(elem,this.chart,tick.label,_582.text,_572,_57f);if(_57f=="html"){this.htmlElements.push(elem);}else{if(_568){elem.setTransform([{dx:_570.x,dy:_570.y},g.matrix.rotategAt(_568,x+dx+_56f.x,y+dy+_56f.y)]);}}}},this);dx=_56e.x*_579.length;dy=_56e.y*_579.length;_57e=c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _583=f(tick.value),elem,x=_569.x+_56d.x*_583,y=_569.y+_56d.y*_583;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_579);if(_57e&&tick.label){var _584=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_572,o.maxLabelCharCount):{text:tick.label,truncated:false};_584=o.maxLabelSize?this.getTextWithLimitLength(_584.text,_572,o.maxLabelSize,_584.truncated):_584;elem=this.createText(_57f,s,x+dx+_56f.x+(_568?0:_570.x),y+dy+_56f.y+(_568?0:_570.y),_571,_584.text,_572,_574);if(this.chart.getTextDir&&_584.truncated){this.chart.truncateBidi(elem,tick.label,_57f);}_584.truncated&&this.labelTooltip(elem,this.chart,tick.label,_584.text,_572,_57f);if(_57f=="html"){this.htmlElements.push(elem);}else{if(_568){elem.setTransform([{dx:_570.x,dy:_570.y},g.matrix.rotategAt(_568,x+dx+_56f.x,y+dy+_56f.y)]);}}}},this);dx=_56e.x*_57a.length;dy=_56e.y*_57a.length;arr.forEach(t.micro,function(tick){var _585=f(tick.value),elem,x=_569.x+_56d.x*_585,y=_569.y+_56d.y*_585;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_57a);},this);}catch(e){}this.dirty=false;return this;},labelTooltip:function(elem,_586,_587,_588,font,_589){var _58a=["dijit/Tooltip"];var _58b={type:"rect"},_58c=["above","below"],_58d=g._base._getTextBox(_588,{font:font}).w||0,_58e=font?g.normalizedLength(g.splitFontString(font).size):0;if(_589=="html"){lang.mixin(_58b,html.coords(elem.firstChild,true));_58b.width=Math.ceil(_58d);_58b.height=Math.ceil(_58e);this._events.push({shape:dojo,handle:_549.connect(elem.firstChild,"onmouseover",this,function(e){require(_58a,function(_58f){_58f.show(_587,_58b,_58c);});})});this._events.push({shape:dojo,handle:_549.connect(elem.firstChild,"onmouseout",this,function(e){require(_58a,function(_590){_590.hide(_58b);});})});}else{var shp=elem.getShape(),lt=html.coords(_586.node,true);_58b=lang.mixin(_58b,{x:shp.x-_58d/2,y:shp.y});_58b.x+=lt.x;_58b.y+=lt.y;_58b.x=Math.round(_58b.x);_58b.y=Math.round(_58b.y);_58b.width=Math.ceil(_58d);_58b.height=Math.ceil(_58e);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_58a,function(_591){_591.show(_587,_58b,_58c);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_58a,function(_592){_592.hide(_58b);});})});}}});});},"dojox/charting/plot2d/ClusteredBars":function(){define("dojox/charting/plot2d/ClusteredBars",["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Bars","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils"],function(lang,arr,_593,Bars,dc,df,dfr,du){var _594=dfr.lambda("item.purgeGroup()");return _593("dojox.charting.plot2d.ClusteredBars",Bars,{render:function(dim,_595){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_595);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_594);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_596,_597,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_598=Math.max(0,this._hScaler.bounds.lower),_599=ht(_598),_59a=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_596=_597=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_59b=_597*(this.series.length-i-1);if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _59c=t.next("bar",[this.opt,run]),s=run.group,_59d=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var _59e=run.data[j];if(_59e!==null){var v=typeof _59e=="number"?_59e:_59e.y,hv=ht(v),_59f=hv-_599,w=Math.abs(_59f),_5a0=typeof _59e!="number"?t.addMixin(_59c,"bar",_59e,true):t.post(_59c,"bar");if(w>=0&&_596>=1){var rect={x:_595.l+(v<_598?hv:_599),y:dim.height-_595.b-vt(j+1.5)+gap+_59b,width:w,height:_596};var _5a1=this._plotFill(_5a0.series.fill,dim,_595);_5a1=this._shapeFill(_5a1,rect);var _5a2=s.createRect(rect).setFill(_5a1).setStroke(_5a0.series.stroke);run.dyn.fill=_5a2.getFill();run.dyn.stroke=_5a2.getStroke();if(_59a){var o={element:"bar",index:j,run:run,shape:_5a2,x:v,y:j+1.5};this._connectEvents(o);_59d[j]=o;}if(this.animate){this._animateBar(_5a2,_595.l+_599,-_59f);}}}}this._eventSeries[run.name]=_59d;run.dirty=false;}this.dirty=false;return this;}});});},"dojox/charting/action2d/MoveSlice":function(){define("dojox/charting/action2d/MoveSlice",["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_5a3,_5a4,dfe,m,gf,df,dfs,dff){var _5a5=1.05,_5a6=7;return _5a3("dojox.charting.action2d.MoveSlice",_5a4,{defaultParams:{duration:400,easing:dfe.backOut,scale:_5a5,shift:_5a6},optionalParams:{},constructor:function(_5a7,plot,_5a8){if(!_5a8){_5a8={};}this.scale=typeof _5a8.scale=="number"?_5a8.scale:_5a5;this.shift=typeof _5a8.shift=="number"?_5a8.shift:_5a6;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _5a9=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",_5a9),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",_5a9),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _5aa=o.index,anim,_5ab,_5ac,_5ad,_5ae,_5af=(this.angles[_5aa]+this.angles[_5aa+1])/2,_5b0=m.rotateAt(-_5af,o.cx,o.cy),_5b1=m.rotateAt(_5af,o.cx,o.cy);anim=this.anim[_5aa];if(anim){anim.action.stop(true);}else{this.anim[_5aa]=anim={};}if(o.type=="onmouseover"){_5ad=0;_5ae=this.shift;_5ab=1;_5ac=this.scale;}else{_5ad=this.shift;_5ae=0;_5ab=this.scale;_5ac=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_5b1,{name:"translate",start:[_5ad,0],end:[_5ae,0]},{name:"scaleAt",start:[_5ab,o.cx,o.cy],end:[_5ac,o.cx,o.cy]},_5b0]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_5aa];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_5b2,_5b3){var _5b4=lang.getObject("dojo.colors",true);var _5b5=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_5b2.fromRgb=function(_5b6,obj){var m=_5b6.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_5b3.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _5b2.fromArray(a,obj);}return _5b2.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_5b5(m1,m2,H+1/3)*256,_5b5(m1,m2,H)*256,_5b5(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _5b2.fromArray(a,obj);}}return null;};var _5b7=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_5b2.prototype.sanitize=function(){var t=this;t.r=Math.round(_5b7(t.r,0,255));t.g=Math.round(_5b7(t.g,0,255));t.b=Math.round(_5b7(t.b,0,255));t.a=_5b7(t.a,0,1);return this;};_5b4.makeGrey=_5b2.makeGrey=function(g,a){return _5b2.fromArray([g,g,g,a]);};lang.mixin(_5b2.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _5b2;});},"dijit/Tooltip":function(){require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","."],function(_5b8,_5b9,fx,dom,_5ba,_5bb,_5bc,lang,has,win,_5bd,_5be,_5bf,_5c0,_5c1,_5c2,_5c3){var _5c4=_5b9("dijit._MasterTooltip",[_5bf,_5c0],{duration:_5bd.defaultDuration,templateString:_5c2,postCreate:function(){win.body().appendChild(this.domNode);this.bgIframe=new _5c1(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_5c5,_5c6,_5c7,rtl,_5c8){if(this.aroundNode&&this.aroundNode===_5c6&&this.containerNode.innerHTML==_5c5){return;}this.domNode.width="auto";if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_5c5;this.set("textDir",_5c8);this.containerNode.align=rtl?"right":"left";var pos=_5be.around(this.domNode,_5c6,_5c7&&_5c7.length?_5c7:_5c9.defaultPosition,!rtl,lang.hitch(this,"orient"));var _5ca=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_5ca.y+((_5ca.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_5ca.x+((_5ca.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}_5bc.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_5c6;},orient:function(node,_5cb,_5cc,_5cd,_5ce){this.connectorNode.style.top="";var _5cf=_5cd.w-this.connectorNode.offsetWidth;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_5cb+"-"+_5cc];this.domNode.style.width="auto";var size=_5bb.getContentBox(this.domNode);var _5d0=Math.min((Math.max(_5cf,1)),size.w);var _5d1=_5d0<size.w;this.domNode.style.width=_5d0+"px";if(_5d1){this.containerNode.style.overflow="auto";var _5d2=this.containerNode.scrollWidth;this.containerNode.style.overflow="visible";if(_5d2>_5d0){_5d2=_5d2+_5bc.get(this.domNode,"paddingLeft")+_5bc.get(this.domNode,"paddingRight");this.domNode.style.width=_5d2+"px";}}if(_5cc.charAt(0)=="B"&&_5cb.charAt(0)=="B"){var mb=_5bb.getMarginBox(node);var _5d3=this.connectorNode.offsetHeight;if(mb.h>_5cd.h){var _5d4=_5cd.h-((_5ce.h+_5d3)>>1);this.connectorNode.style.top=_5d4+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_5ce.h/2-_5d3/2,0),mb.h-_5d3)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_5cf);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_5d5){if(this._onDeck&&this._onDeck[1]==_5d5){this._onDeck=null;}else{if(this.aroundNode===_5d5){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}},_setAutoTextDir:function(node){this.applyTextDir(node,has("ie")?node.outerText:node.textContent);_5b8.forEach(node.children,function(_5d6){this._setAutoTextDir(_5d6);},this);},_setTextDirAttr:function(_5d7){this._set("textDir",typeof _5d7!="undefined"?_5d7:"");if(_5d7=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});_5c3.showTooltip=function(_5d8,_5d9,_5da,rtl,_5db){if(!_5c9._masterTT){_5c3._masterTT=_5c9._masterTT=new _5c4();}return _5c9._masterTT.show(_5d8,_5d9,_5da,rtl,_5db);};_5c3.hideTooltip=function(_5dc){return _5c9._masterTT&&_5c9._masterTT.hide(_5dc);};var _5c9=_5b9("dijit.Tooltip",_5bf,{label:"",showDelay:400,connectId:[],position:[],_setConnectIdAttr:function(_5dd){_5b8.forEach(this._connections||[],function(_5de){_5b8.forEach(_5de,lang.hitch(this,"disconnect"));},this);this._connectIds=_5b8.filter(lang.isArrayLike(_5dd)?_5dd:(_5dd?[_5dd]:[]),function(id){return dom.byId(id);});this._connections=_5b8.map(this._connectIds,function(id){var node=dom.byId(id);return [this.connect(node,"onmouseenter","_onHover"),this.connect(node,"onmouseleave","_onUnHover"),this.connect(node,"onfocus","_onHover"),this.connect(node,"onblur","_onUnHover")];},this);this._set("connectId",_5dd);},addTarget:function(node){var id=node.id||node;if(_5b8.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_5b8.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_5ba.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_5b8.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},_onHover:function(e){if(!this._showTimer){var _5df=e.target;this._showTimer=setTimeout(lang.hitch(this,function(){this.open(_5df);}),this.showDelay);}},_onUnHover:function(){if(this._focus){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}this.close();},open:function(_5e0){if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}_5c9.show(this.label||this.domNode.innerHTML,_5e0,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_5e0;this.onShow(_5e0,this.position);},close:function(){if(this._connectNode){_5c9.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},onShow:function(){},onHide:function(){},uninitialize:function(){this.close();this.inherited(arguments);}});_5c9._MasterTooltip=_5c4;_5c9.show=_5c3.showTooltip;_5c9.hide=_5c3.hideTooltip;_5c9.defaultPosition=["after","before"];return _5c9;});},"dojox/charting/Element":function(){define("dojox/charting/Element",["dojo/_base/lang","dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx"],function(lang,arr,_5e1,_5e2,gfx){return _5e2("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_5e3){this.chart=_5e3;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},createGroup:function(_5e4){if(!_5e4){_5e4=this.chart.surface;}if(!this.group){this.group=_5e4.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_5e5){this.destroyHtmlElements();if(!_5e5){_5e5=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_5e5.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_5e1.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_5e6,_5e7){if(!s||s.length<=0){return {text:"",truncated:_5e7||false};}if(!_5e6||_5e6<=0){return {text:s,truncated:_5e7||false};}var _5e8=2,_5e9=0.618,_5ea=s.substring(0,1)+this.trailingSymbol,_5eb=this.getTextWidth(_5ea,font);if(_5e6<=_5eb){return {text:_5ea,truncated:true};}var _5ec=this.getTextWidth(s,font);if(_5ec<=_5e6){return {text:s,truncated:_5e7||false};}else{var _5ed=0,end=s.length;while(_5ed<end){if(end-_5ed<=_5e8){while(this.getTextWidth(s.substring(0,_5ed)+this.trailingSymbol,font)>_5e6){_5ed-=1;}return {text:(s.substring(0,_5ed)+this.trailingSymbol),truncated:true};}var _5ee=_5ed+Math.round((end-_5ed)*_5e9),_5ef=this.getTextWidth(s.substring(0,_5ee),font);if(_5ef<_5e6){_5ed=_5ee;end=end;}else{_5ed=_5ed;end=_5ee;}}}},getTextWithLimitCharCount:function(s,font,_5f0,_5f1){if(!s||s.length<=0){return {text:"",truncated:_5f1||false};}if(!_5f0||_5f0<=0||s.length<=_5f0){return {text:s,truncated:_5f1||false};}return {text:s.substring(0,_5f0)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_5f2){if(!fill||!fill.type||!fill.space){return fill;}var _5f3=fill.space;switch(fill.type){case "linear":if(_5f3==="plot"||_5f3==="shapeX"||_5f3==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_5f3;if(_5f3==="plot"||_5f3==="shapeX"){var span=dim.height-_5f2.t-_5f2.b;fill.y1=_5f2.t+span*fill.y1/100;fill.y2=_5f2.t+span*fill.y2/100;}if(_5f3==="plot"||_5f3==="shapeY"){var span=dim.width-_5f2.l-_5f2.r;fill.x1=_5f2.l+span*fill.x1/100;fill.x2=_5f2.l+span*fill.x2/100;}}break;case "radial":if(_5f3==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5f3;var _5f4=dim.width-_5f2.l-_5f2.r,_5f5=dim.height-_5f2.t-_5f2.b;fill.cx=_5f2.l+_5f4*fill.cx/100;fill.cy=_5f2.t+_5f5*fill.cy/100;fill.r=fill.r*Math.sqrt(_5f4*_5f4+_5f5*_5f5)/200;}break;case "pattern":if(_5f3==="plot"||_5f3==="shapeX"||_5f3==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_5f3;if(_5f3==="plot"||_5f3==="shapeX"){var span=dim.height-_5f2.t-_5f2.b;fill.y=_5f2.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_5f3==="plot"||_5f3==="shapeY"){var span=dim.width-_5f2.l-_5f2.r;fill.x=_5f2.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _5f6=fill.space;switch(fill.type){case "linear":if(_5f6==="shape"||_5f6==="shapeX"||_5f6==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_5f6;if(_5f6==="shape"||_5f6==="shapeX"){var span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_5f6==="shape"||_5f6==="shapeY"){var span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_5f6==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5f6;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_5f6==="shape"||_5f6==="shapeX"||_5f6==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_5f6;if(_5f6==="shape"||_5f6==="shapeX"){var span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_5f6==="shape"||_5f6==="shapeY"){var span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_5f7,_5f8,_5f9,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _5fa=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_5fa;if(arguments.length<4){fill.cx=_5f7.x;fill.cy=_5f7.y;fill.r=fill.r*_5f8/100;return fill;}var _5fb=arguments.length<5?_5f9:(end+_5f9)/2;return {type:"linear",x1:_5f7.x,y1:_5f7.y,x2:_5f7.x+fill.r*_5f8*Math.cos(_5fb)/100,y2:_5f7.y+fill.r*_5f8*Math.sin(_5fb)/100,colors:fill.colors};return fill;}});});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./registry"],function(_5fc,_5fd,_5fe,_5ff,_600,_601,dom,_602,_603,_604,_605,_606,_607,lang,on,_608,_609,_60a,win,_60b){if(!_607.isAsync){_608(0,function(){var _60c=["dijit/_base/manager"];_5fc(_60c);});}var _60d={};function _60e(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _60f(attr){return function(val){_602[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};return _601("dijit._WidgetBase",_609,{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_60f("lang"),dir:"",_setDirAttr:_60f("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,attributeMap:{},_blankGif:_5ff.blankGif||_5fc.toUrl("dojo/resources/blank.gif"),postscript:function(_610,_611){this.create(_610,_611);},create:function(_612,_613){this.srcNodeRef=dom.byId(_613);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_612){this.params=_612;lang.mixin(this,_612);}this.postMixInProperties();if(!this.id){this.id=_60b.getUniqueId(this.declaredClass.replace(/\./g,"_"));}_60b.add(this);this.buildRendering();if(this.domNode){this._applyAttributes();var _614=this.srcNodeRef;if(_614&&_614.parentNode&&this.domNode!==_614){_614.parentNode.replaceChild(this.domNode,_614);}}if(this.domNode){this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(this.srcNodeRef&&!this.srcNodeRef.parentNode){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var _615=ctor.prototype;for(var _616 in _615){if(_616 in this.attributeMap){continue;}var _617="_set"+_616.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_617 in _615){list.push(_616);}}}_5fd.forEach(list,function(attr){if(this.params&&attr in this.params){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(var _618 in this.params){this.set(_618,this[_618]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||_604.create("div");}if(this.baseClass){var _619=this.baseClass.split(" ");if(!this.isLeftToRight()){_619=_619.concat(_5fd.map(_619,function(name){return name+"Rtl";}));}_603.add(this.domNode,_619);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_5fd.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_61a){this._beingDestroyed=true;this.destroyDescendants(_61a);this.destroy(_61a);},destroy:function(_61b){this._beingDestroyed=true;this.uninitialize();var c;while(c=this._connects.pop()){c.remove();}var w;while(w=this._supportingWidgets.pop()){if(w.destroyRecursive){w.destroyRecursive();}else{if(w.destroy){w.destroy();}}}this.destroyRendering(_61b);_60b.remove(this.id);this._destroyed=true;},destroyRendering:function(_61c){if(this.bgIframe){this.bgIframe.destroy(_61c);delete this.bgIframe;}if(this.domNode){if(_61c){_602.remove(this.domNode,"widgetId");}else{_604.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_61c){_604.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_61d){_5fd.forEach(this.getChildren(),function(_61e){if(_61e.destroyRecursive){_61e.destroyRecursive(_61d);}});},uninitialize:function(){return false;},_setStyleAttr:function(_61f){var _620=this.domNode;if(lang.isObject(_61f)){_606.set(_620,_61f);}else{if(_620.style.cssText){_620.style.cssText+="; "+_61f;}else{_620.style.cssText=_61f;}}this._set("style",_61f);},_attrToDom:function(attr,_621,_622){_622=arguments.length>=3?_622:this.attributeMap[attr];_5fd.forEach(lang.isArray(_622)?_622:[_622],function(_623){var _624=this[_623.node||_623||"domNode"];var type=_623.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_621)){_621=lang.hitch(this,_621);}var _625=_623.attribute?_623.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);_602.set(_624,_625,_621);break;case "innerText":_624.innerHTML="";_624.appendChild(win.doc.createTextNode(_621));break;case "innerHTML":_624.innerHTML=_621;break;case "class":_603.replace(_624,_621,this[attr]);break;}},this);},get:function(name){var _626=this._getAttrNames(name);return this[_626.g]?this[_626.g]():this[name];},set:function(name,_627){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _628=this._getAttrNames(name),_629=this[_628.s];if(lang.isFunction(_629)){var _62a=_629.apply(this,Array.prototype.slice.call(arguments,1));}else{var _62b=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_62b].tagName,_62c=_60d[tag]||(_60d[tag]=_60e(this[_62b])),map=name in this.attributeMap?this.attributeMap[name]:_628.s in this?this[_628.s]:((_628.l in _62c&&typeof _627!="function")||/^aria-|^data-|^role$/.test(name))?_62b:null;if(map!=null){this._attrToDom(name,_627,map);}this._set(name,_627);}return _62a||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_62d){var _62e=this[name];this[name]=_62d;if(this._watchCallbacks&&this._created&&_62d!==_62e){this._watchCallbacks(name,_62e,_62d);}},on:function(type,func){return _5fe.after(this,this._onMap(type),func,true);},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_60b.findWidgets(this.containerNode):[];},getParent:function(){return _60b.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_62f,_630){var _631=_600.connect(obj,_62f,this,_630);this._connects.push(_631);return _631;},disconnect:function(_632){var i=_5fd.indexOf(this._connects,_632);if(i!=-1){_632.remove();this._connects.splice(i,1);}},subscribe:function(t,_633){var _634=_60a.subscribe(t,lang.hitch(this,_633));this._connects.push(_634);return _634;},unsubscribe:function(_635){this.disconnect(_635);},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_605.isBodyLtr();},isFocusable:function(){return this.focus&&(_606.get(this.domNode,"display")!="none");},placeAt:function(_636,_637){if(_636.declaredClass&&_636.addChild){_636.addChild(this,_637);}else{_604.place(this.domNode,_636,_637);}return this;},getTextDir:function(text,_638){return _638;},applyTextDir:function(){}});});}}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(dojo,_639){dojo.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return dojox.charting.widget.Chart2D=_639;});