/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.grid.enhanced.plugins.IndirectSelection"]){
dojo._hasResource["dojox.grid.enhanced.plugins.IndirectSelection"]=true;
dojo.provide("dojox.grid.enhanced.plugins.IndirectSelection");
dojo.require("dojox.grid.cells.dijit");
dojo.require("dojox.grid.cells._base");
dojo.require("dojox.grid.enhanced.plugins._Mixin");
dojo.declare("dojox.grid.enhanced.plugins.IndirectSelection",dojox.grid.enhanced.plugins._Mixin,{constructor:function(_1){
this.grid=_1;
this.connect(_1.layout,"setStructure",dojo.hitch(_1.layout,this.addRowSelectCell));
},addRowSelectCell:function(){
if(!this.grid.indirectSelection||this.grid.selectionMode=="none"){
return;
}
var _2=false,_3=["get","formatter","field","fields"],_4={type:dojox.grid.cells.DijitMultipleRowSelector,name:"",editable:true,width:"30px",styles:"text-align: center;"};
if(this.grid.rowSelectCell){
_4["defaultValue"]=this.grid.rowSelectCell["defaultValue"];
this.grid.rowSelectCell.destroy();
}
dojo.forEach(this.structure,dojo.hitch(this,function(_5){
var _6=_5.cells;
if(_6&&_6.length>0&&!_2){
var _7=_6[0];
if(_7[0]&&_7[0]["isRowSelector"]){
_2=true;
return;
}
var _8,_9=this.grid.selectionMode=="single"?dojox.grid.cells.DijitSingleRowSelector:dojox.grid.cells.DijitMultipleRowSelector;
if(!dojo.isObject(this.grid.indirectSelection)){
_8=dojo.mixin(_4,{type:_9});
}else{
_8=dojo.mixin(_4,this.grid.indirectSelection,{type:_9,editable:true});
dojo.forEach(_3,function(_a){
if(_a in _8){
delete _8[_a];
}
});
}
_6.length>1&&(_8["rowSpan"]=_6.length);
dojo.forEach(this.cells,function(_b,i){
if(_b.index>=0){
_b.index+=1;
}else{
}
});
var _c=this.addCellDef(0,0,_8);
_c.index=0;
_7.unshift(_c);
this.cells.unshift(_c);
this.grid.rowSelectCell=_c;
_2=true;
}
}));
this.cellCount=this.cells.length;
},destroy:function(){
this.grid.rowSelectCell.destroy();
delete this.grid.rowSelectCell;
this.inherited(arguments);
}});
dojo.declare("dojox.grid.cells._SingleRowSelectorMixin",null,{alwaysEditing:true,widgetMap:null,disabledMap:null,widget:null,isRowSelector:true,defaultValue:false,constructor:function(){
this.widgetMap={},this.disabledMap={};
},formatEditing:function(_d,_e){
this.needFormatNode(_d,_e);
},_formatNode:function(_f,_10){
this.formatNode(_f,_10);
},setValue:function(_11,_12){
return;
},get:function(_13){
var _14=this.widgetMap[this.view.id]?this.widgetMap[this.view.id][_13]:null;
var _15=_14?_14.attr("checked"):"";
return _15;
},_fireSelectionChanged:function(){
dojo.publish(this.grid.rowSelectionChangedTopic,[this]);
},_selectionChanged:function(obj){
if(!obj||obj==this||obj.grid&&obj.grid!=this.grid){
return;
}
for(var i in this.widgetMap[this.view.id]){
var idx=new Number(i);
var _16=this.widgetMap[this.view.id][idx];
var _17=!!this.grid.selection.selected[idx];
_16.attr("checked",_17);
}
this.defaultValue=false;
this.grid.edit.isEditing()&&this.grid.edit.apply();
},_toggleSingleRow:function(idx,_18){
var _19;
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[_18?"addToSelection":"deselect"])(idx);
if(this.widgetMap[this.view.id]&&(_19=this.widgetMap[this.view.id][idx])){
_19.attr("checked",_18);
}
this._fireSelectionChanged();
},inIndirectSelectionMode:function(){
},toggleAllSelection:function(){
}});
dojo.declare("dojox.grid.cells._MultipleRowSelectorMixin",null,{swipeStartRowIndex:-1,swipeMinRowIndex:-1,swipeMaxRowIndex:-1,toSelect:false,lastClickRowIdx:-1,toggleAllTrigerred:false,_inDndSelection:false,domousedown:function(e){
if(e.target.tagName=="INPUT"){
this._startSelection(e.rowIndex);
}
dojo.stopEvent(e);
},domousemove:function(e){
this._updateSelection(e,0);
},onRowMouseOver:function(e){
this._updateSelection(e,0);
if(this.grid.dnd){
this._inDndSelection=this.grid.select.isInSelectingMode("row");
}
},domouseup:function(e){
dojo.isIE&&this.view.content.decorateEvent(e);
var _1a=e.cellIndex>=0&&(this.inIndirectSelectionMode()||this._inDndSelection)&&!this.grid.edit.isEditRow(e.rowIndex);
_1a&&this._focusEndingCell(e.rowIndex,e.cellIndex);
this._finisheSelect();
},dokeyup:function(e){
if(!e.shiftKey){
this._finisheSelect();
}
},_startSelection:function(_1b){
this.swipeStartRowIndex=this.swipeMinRowIndex=this.swipeMaxRowIndex=_1b;
this.toSelect=!this.widgetMap[this.view.id][_1b].attr("checked");
},_updateSelection:function(e,_1c){
if(this.swipeStartRowIndex<0){
return;
}
var _1d=_1c!=0;
var _1e=e.rowIndex-this.swipeStartRowIndex+_1c;
_1e>0&&(this.swipeMaxRowIndex<e.rowIndex+_1c)&&(this.swipeMaxRowIndex=e.rowIndex+_1c);
_1e<0&&(this.swipeMinRowIndex>e.rowIndex+_1c)&&(this.swipeMinRowIndex=e.rowIndex+_1c);
if(this.swipeMinRowIndex!=this.swipeMaxRowIndex){
for(var i in this.widgetMap[this.view.id]){
var idx=new Number(i);
var _1f=(idx>=(_1e>0?this.swipeStartRowIndex:e.rowIndex+_1c)&&idx<=(_1e>0?e.rowIndex+_1c:this.swipeStartRowIndex));
var _20=(idx>=this.swipeMinRowIndex&&idx<=this.swipeMaxRowIndex);
if(_1f&&!(_1e==0&&!this.toSelect)){
(this.widgetMap[this.view.id][idx]).attr("checked",this.toSelect);
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[this.toSelect?"addToSelection":"deselect"])(idx);
}else{
if(_20&&!_1d){
(this.widgetMap[this.view.id][idx]).attr("checked",!this.toSelect);
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[!this.toSelect?"addToSelection":"deselect"])(idx);
}
}
}
}
this._fireSelectionChanged();
},swipeSelectionByKey:function(e,_21){
if(this.swipeStartRowIndex<0){
this.swipeStartRowIndex=e.rowIndex;
if(_21>0){
this.swipeMaxRowIndex=e.rowIndex+_21;
this.swipeMinRowIndex=e.rowIndex;
}else{
this.swipeMinRowIndex=e.rowIndex+_21;
this.swipeMaxRowIndex=e.rowIndex;
}
this.toSelect=this.widgetMap[this.view.id][e.rowIndex].attr("checked");
}
this._updateSelection(e,_21);
},_finisheSelect:function(){
this.swipeStartRowIndex=-1;
this.swipeMinRowIndex=-1;
this.swipeMaxRowIndex=-1;
this.toSelect=false;
},inIndirectSelectionMode:function(){
return this.swipeStartRowIndex>=0;
},toggleAllSelection:function(_22){
for(var i in this.widgetMap[this.view.id]){
var idx=new Number(i);
var _23=this.widgetMap[this.view.id][idx];
_23.attr("checked",_22);
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[_22?"addToSelection":"deselect"])(idx);
}
!_22&&this.grid.selection.deselectAll();
this.defaultValue=_22;
this.toggleAllTrigerred=true;
this._fireSelectionChanged();
}});
dojo.declare("dojox.grid.cells.DijitSingleRowSelector",[dojox.grid.cells._Widget,dojox.grid.cells._SingleRowSelectorMixin],{widgetClass:dijit.form.RadioButton,_connects:null,_subscribes:null,constructor:function(){
this._connects={"col":[]},this._subscribes={"col":[]};
this._subscribes["col"].push(dojo.subscribe(this.grid.rowSelectionChangedTopic,this,this._selectionChanged));
this._subscribes["col"].push(dojo.subscribe(this.grid.sortRowSelectionChangedTopic,this,this._selectionChanged));
this._connects["col"].push(dojo.connect(this.grid.scroller,"invalidatePageNode",this,"_pageDestroyed"));
this.grid.indirectSelector=this;
},formatNode:function(_24,_25){
if(!this.widgetClass){
return _24;
}
!this.widgetMap[this.view.id]&&(this.widgetMap[this.view.id]={});
var _26=this.widgetMap[this.view.id][_25];
var _27=this.getNode(_25);
if(!_27){
return;
}
var _28=_27.firstChild;
if(!_28){
_28=_27.appendChild(dojo.create("div"));
console.warn("NO first child for cellNode");
}
if(!_26){
var _29=this.getDefaultValue(false,_25);
if(!this.widgetProps){
this.widgetProps={};
}
this.widgetProps.name="select_"+this.grid.id;
this.widgetProps.id=this.grid.id+"_row_"+_25;
this.widgetProps.checked=_29;
_26=this.createWidget(_28,_24,_25);
this.widgetMap[this.view.id][_25]=_26;
var _2a=this._connects[_26.id]=[];
_2a.push(dojo.connect(_26,"_onClick",dojo.hitch(this,function(e){
this._selectRow(e,_25);
})));
_2a.push(dojo.connect(_26.domNode,"onkeyup",dojo.hitch(this,function(e){
e.keyCode==dojo.keys.SPACE&&this._selectRow(e,_25,true);
})));
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[_29?"addToSelection":"deselect"])(_25);
this.disabledMap[_25]&&this.setDisabled(_25,true);
}else{
if(_26.domNode!=_28){
_27.appendChild(_26.domNode);
}
}
if(!this.widget){
this.widget=_26;
}
var _2b=this.grid.views,_2c=this.grid.lastRenderingRows;
_2b.views.length>1&&_2b.renormalizeRow(_25);
var _2d=dojo.some(_2c,function(row,i,_2e){
if(_25==row){
dojo.hitch(this.grid.scroller,"rowHeightChanged")(row);
_2e.splice(i,1);
return true;
}
},this);
_2d&&dojo.removeClass(this.grid.domNode,"dojoxGridSortInProgress");
},getDefaultValue:function(_2f,_30){
var _31=_2f?_2f.attr("checked"):this.defaultValue;
if(!_2f){
if(this.grid.nestedSorting){
_31=_31||this.grid.getStoreSelectedValue(_30);
}
_31=this.grid.selection.isSelected(_30)?true:_31;
}
return _31;
},focus:function(_32){
var _33=this.widgetMap[this.view.id][_32];
if(_33){
setTimeout(dojo.hitch(_33,function(){
dojox.grid.util.fire(this,"focus");
}),0);
}
},_focusEndingCell:function(_34,_35){
var _36=this.grid.getCell(_35);
this.grid.focus.setFocusCell(_36,_34);
this.grid.isDndSelectEnable&&this.grid.focus._blurRowBar();
},_selectRow:function(e,_37,_38){
if(dojo.isMoz&&_38){
return;
}
dojo.stopEvent(e);
this._focusEndingCell(_37,0);
var _39=!this.grid.selection.selected[_37];
this.grid.selection.deselectAll();
this.grid.selection.addToSelection(_37);
if(!dojo.isMoz){
var _3a=this.widgetMap[this.view.id][_37];
_3a.attr("checked",true);
}
this._fireSelectionChanged();
},toggleRow:function(idx,_3b){
var _3c=dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype.getFirstSelected)();
if(idx!=_3c&&!_3b||idx==_3c&&_3b){
return;
}
var _3d;
if(idx!=_3c&&_3b&&this.widgetMap[this.view.id]&&(_3d=this.widgetMap[this.view.id][_3c])){
_3d.attr("checked",false);
}
this.grid.selection.deselectAll();
this._toggleSingleRow(idx,_3b);
},setDisabled:function(idx,_3e){
if(this.widgetMap[this.view.id]){
var _3f=this.widgetMap[this.view.id][idx];
if(_3f){
_3f.attr("disabled",_3e);
}
this.disabledMap[idx]=_3e;
}
},_pageDestroyed:function(_40){
var _41=this.grid.scroller.rowsPerPage;
var _42=_40*_41,end=_42+_41-1;
var r,w,map=this.widgetMap[this.view.id];
if(!map){
return;
}
for(r=_42;r<=end;r++){
w=map[r],rowId=this.grid.id+"_row_"+r;
if(this._connects[rowId]){
dojo.forEach(this._connects[rowId],dojo.disconnect);
delete this._connects[rowId];
}
if(w&&w.destroy){
w.destroy();
delete map[r];
}
}
},destroy:function(){
var w,map=this.widgetMap[this.view.id];
for(w in map){
map[w].destroy&&map[w].destroy();
delete map[w];
}
for(x in this._connects){
dojo.forEach(this._connects[x],dojo.disconnect);
delete this._connects[x];
}
for(x in this._subscribes){
dojo.forEach(this._subscribes[x],dojo.unsubscribe);
delete this._subscribes[x];
}
delete this._connects;
delete this._subscribes;
}});
dojo.declare("dojox.grid.cells.DijitMultipleRowSelector",[dojox.grid.cells.DijitSingleRowSelector,dojox.grid.cells._MultipleRowSelectorMixin],{widgetClass:dijit.form.CheckBox,constructor:function(){
this._connects["col"].push(dojo.connect(dojo.doc,"onmouseup",this,"domouseup"));
this.grid.indirectSelector=this;
},_selectRow:function(e,_43,_44){
dojo.stopEvent(e);
this._focusEndingCell(_43,0);
var _45=_43-this.lastClickRowIdx;
if(this.lastClickRowIdx>=0&&!e.ctrlKey&&!e.altKey&&e.shiftKey){
var _46=this.widgetMap[this.view.id][_43].attr("checked");
_46=_44?!_46:_46;
for(var i in this.widgetMap[this.view.id]){
var idx=new Number(i);
var _47=(idx>=(_45>0?this.lastClickRowIdx:_43)&&idx<=(_45>0?_43:this.lastClickRowIdx));
if(_47){
var _48=this.widgetMap[this.view.id][idx];
_48.attr("checked",_46);
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[_46?"addToSelection":"deselect"])(idx);
}
}
}else{
var _49=!this.grid.selection.selected[_43];
var _48=this.widgetMap[this.view.id][_43];
_48.attr("checked",_49);
dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype[_49?"addToSelection":"deselect"])(_43);
}
this.lastClickRowIdx=_43;
this._fireSelectionChanged();
},toggleRow:function(idx,_4a){
this._toggleSingleRow(idx,_4a);
}});
}
