/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.grid.enhanced.dnd._DndMovingManager"]){
dojo._hasResource["dojox.grid.enhanced.dnd._DndMovingManager"]=true;
dojo.provide("dojox.grid.enhanced.dnd._DndMovingManager");
dojo.require("dojox.grid.enhanced.dnd._DndSelectingManager");
dojo.require("dojox.grid.enhanced.dnd._DndMover");
dojo.require("dojo.dnd.move");
dojo.declare("dojox.grid.enhanced.dnd._DndMovingManager",dojox.grid.enhanced.dnd._DndSelectingManager,{exceptRowsTo:-1,exceptColumnsTo:-1,coverDIVs:null,movers:null,constructor:function(_1){
if(this.grid.indirectSelection){
this.exceptColumnsTo=this.grid.pluginMgr.getFixedCellNumber()-1;
}
this.coverDIVs=[],this.movers=[];
this.subscribe("CTRL_KEY_DOWN",function(_2,_3){
if(_2==this.grid&&_2!=this){
this.keyboardMove(_3);
}
});
dojo.forEach(this.grid.views.views,function(_4){
this.connect(_4.scrollboxNode,"onscroll",function(){
this.clearDrugDivs();
});
},this);
},getGridWidth:function(){
return dojo.contentBox(this.grid.domNode).w-this.grid.views.views[0].getWidth().replace("px","");
},isColSelected:function(_5){
return this.selectedColumns[_5]&&_5>this.exceptColumnsTo;
},getHScrollBarHeight:function(){
this.scrollbarHeight=0;
dojo.forEach(this.grid.views.views,function(_6,_7){
if(_6.scrollboxNode){
var _8=_6.scrollboxNode.offsetHeight-_6.scrollboxNode.clientHeight;
this.scrollbarHeight=_8>this.scrollbarHeight?_8:this.scrollbarHeight;
}
},this);
return this.scrollbarHeight;
},getExceptionalColOffsetWidth:function(){
if(!this.grid.indirectSelection||!this.grid.rowSelectCell){
return 0;
}
var _9=(normalizedOffsetWidth=0),_a=this.grid.rowSelectCell.view.scrollboxNode;
dojo.forEach(this.getHeaderNodes(),function(_b,_c){
if(_c<=this.exceptColumnsTo){
var _d=dojo.coords(_b);
_9+=_d.w;
}
},this);
normalizedOffsetWidth=_9-_a.scrollLeft*(dojo._isBodyLtr()?1:(dojo.isMoz?-1:1));
return normalizedOffsetWidth>0?normalizedOffsetWidth:0;
},getGridCoords:function(_e){
if(!this.gridCoords||_e){
this.gridCoords=new Object();
if(!this.headerHeight){
this.headerHeight=dojo.coords(this.getHeaderNodes()[0]).h;
}
var _f=dojo.coords(this.grid.views.views[0].domNode);
var _10=dojo.coords(this.grid.domNode);
var _11=dojo.contentBox(this.grid.domNode);
this.gridCoords.h=_11.h-this.headerHeight-this.getHScrollBarHeight();
this.gridCoords.t=_10.y;
this.gridCoords.l=dojo._isBodyLtr()?(_10.x+_f.w):_10.x;
this.gridCoords.w=_11.w-_f.w;
}
return this.gridCoords;
},createAvatar:function(_12,_13,_14,top,_15){
this.gridCoords=null;
var _16=this.getGridCoords();
var _17=dojo.doc.createElement("DIV");
_17.className="dojoxGridSelectedDIV";
_17.id="grid_dnd_cover_div_"+_14+"_"+top;
_17.style.width=_12+"px";
var _18=dojo._docScroll();
var _19=top<_16.t+this.headerHeight?_16.t+this.headerHeight-top:0;
var _1a=_16.t+_16.h+this.headerHeight;
var _1b=0;
if(top<_16.t+this.headerHeight){
_1b=(_16.t+this.headerHeight);
}else{
if(top>_1a){
_1b=10000;
}else{
_1b=top;
}
}
_17.style.top=_1b+_18.y+"px";
_17.style.left=(_14+_18.x)+"px";
var _1c=_1b+_13-_19;
if(_1c>_1a+(_15?this.scrollbarHeight:0)){
_1c=_1a;
}
_17.style.height=((_1c-_1b)>=0?(_1c-_1b):0)+"px";
dojo.doc.body.appendChild(_17);
_17.connections=[];
_17.connections.push(this.connect(_17,"onmouseout",function(){
this.clearDrugDivs();
}));
_17.connections.push(this.connect(_17,"onclick","avataDivClick"));
_17.connections.push(this.connect(_17,"keydown",function(e){
this.handleESC(e,this);
}));
this.coverDIVs.push(_17);
return _17;
},handleESC:function(e,_1d){
var dk=dojo.keys;
switch(e.keyCode){
case dk.ESCAPE:
try{
this.cancelDND();
}
catch(e){
}
break;
}
},cancelDND:function(){
this.cleanAll();
this.clearDrugDivs();
if(this.mover){
this.mover.destroy();
}
this.cleanAll();
},createCoverMover:function(_1e,_1f,_20,top,_21){
var _22=this.getGridCoords(),_23=(_21=="col"?true:false);
var _24={box:{l:(_21=="row"?_20:_22.l)+dojo._docScroll().x,t:(_21=="col"?top:_22.t+this.headerHeight)+dojo._docScroll().y,w:_21=="row"?1:_22.w,h:_21=="col"?1:_22.h},within:true,movingType:_21,mover:dojox.grid.enhanced.dnd._DndMover};
return new dojox.grid.enhanced.dnd._DndBoxConstrainedMoveable(this.createAvatar(_1e,_1f,_20,top,_23),_24);
},getBorderDiv:function(){
if(!this.borderDIV){
this.borderDIV=dojo.create("div",{id:"borderDIV"+this.grid.id,className:"dojoxGridBorderDIV"},dojo.body());
}
return this.borderDIV;
},setBorderDiv:function(_25,_26,_27,top){
var _28=this.getBorderDiv();
dojo.style(_28,{"height":_26+"px","top":top+"px","width":_25+"px","left":_27+"px"});
return _28;
},removeOtherMovers:function(id){
if(!this.coverDIVs.hasRemovedOtherMovers){
var _29;
dojo.forEach(this.coverDIVs,function(div){
if(div.id!=id){
dojo.forEach(div.connections,this.disconnect,this);
dojo.destroy(div);
}else{
_29=div;
}
},this);
this.coverDIVs=[_29];
this.coverDIVs.hasRemovedOtherMovers=true;
}
},addColMovers:function(){
var _2a=-1;
dojo.forEach(this.selectedColumns,function(col,_2b){
if(this.isColSelected(_2b)){
if(_2a==-1){
_2a=_2b;
}
if(this.selectedColumns[_2b+1]==null){
this.addColMover(_2a,_2b);
_2a=-1;
}
}
},this);
},addColMover:function(_2c,_2d){
if(this.lock){
return;
}
var _2e=(rightPosition=0);
var top=null,_2f=null;
if(dojo._isBodyLtr()){
dojo.forEach(this.getHeaderNodes(),function(_30,_31){
var _32=dojo.coords(_30);
if(_31==_2c){
_2e=_32.x;
top=_32.y+_32.h;
_2f=_32.h;
}
if(_31==_2d){
rightPosition=_32.x+_32.w;
}
});
}else{
dojo.forEach(this.getHeaderNodes(),function(_33,_34){
var _35=dojo.coords(_33);
if(_34==_2c){
rightPosition=_35.x+_35.w;
_2f=_35.h;
}
if(_34==_2d){
_2e=_35.x;
top=_35.y+_35.h;
}
});
}
var _36=this.normalizeColMoverCoords(_2e,rightPosition,_2c,_2d);
var _37=_36.h,_38=_36.w;
_2e=_36.l,rightPosition=_36.r;
var _39=this.createCoverMover(_38,_37,_2e,top,"col");
this.movers.push(_39);
var _3a=this.setBorderDiv(3,_37,-1000,top+dojo._docScroll().y);
dojo.attr(_3a,"colH",_36.colH);
_39.connections=[];
_39.connections.push(this.connect(_39,"onMoveStart",function(_3b,_3c){
this.mover=_3b;
this.removeOtherMovers(_3b.node.id);
}));
_39.connections.push(this.connect(_39,"onMove",function(_3d,_3e,_3f){
if(_3d.node==null||_3d.node.parentNode==null){
return;
}
this.isMoving=true;
this.moveColBorder(_3d,_3f,_3a);
}));
_39.connections.push(this.connect(_39,"onMoveStop",function(_40){
if(this.drugDestIndex==null||this.isContinuousSelection(this.selectedColumns)&&(this.drugDestIndex==_2c||this.drugDestIndex==_2d||this.drugDestIndex==(_2d+1)&&this.drugBefore)){
this.movingIgnored=true;
if(this.isMoving){
this.isMoving=false;
this.clearDrugDivs();
}
return;
}
this.isMoving=false;
this.mover=null;
this.startMoveCols();
this.drugDestIndex=null;
}));
},normalizeColMoverCoords:function(_41,_42,_43,_44){
var _45=_42-_41,_46=this.grid.views.views,_47=this.grid.pluginMgr;
var _48={"w":_45,"h":0,"l":_41,"r":_42,"colH":0};
var _49=this.getGridWidth()-_46[_46.length-1].getScrollbarWidth();
var rtl=!dojo._isBodyLtr();
var _4a=_47.getViewByCellIdx(!rtl?_43:_44);
var _4b=_47.getViewByCellIdx(!rtl?_44:_43);
var _4c=(_4a==_4b);
if(!_4a||!_4b){
return _48;
}
var _4d=dojo.coords(_4a.scrollboxNode).x+(rtl&&dojo.isIE?_4a.getScrollbarWidth():0);
var _4e=dojo.coords(_4b.scrollboxNode);
var _4f=_4e.x+_4e.w-((!rtl||!dojo.isIE)?_4b.getScrollbarWidth():0);
if(_48.l<_4d){
_48.w=_48.r-_4d;
_48.l=_4d;
}
if(_48.r>_4f){
_48.w=_4f-_48.l;
}
var i,_50=this.grid.views.views[0],_51=dojo.coords(_50.contentNode).h;
var _52=_4b,_53=_4e.h;
_48.colH=_51;
_53=!_4c?_53:(_53-(_52.scrollboxNode.offsetHeight-_52.scrollboxNode.clientHeight));
_48.h=_51<_53?_51:_53;
return _48;
},moveColBorder:function(_54,_55,_56){
var _57=dojo._docScroll(),rtl=!dojo._isBodyLtr();
_55.x-=_57.x;
var _58=this.grid.views.views,_59=this.getGridCoords();
var _5a=_58[!rtl?1:_58.length-1].scrollboxNode;
var _5b=_58[!rtl?_58.length-1:1].scrollboxNode;
var _5c=(!rtl||!dojo.isIE)?_59.l:(_59.l+_5a.offsetWidth-_5a.clientWidth);
var _5d=(!rtl||dojo.isMoz)?(_59.l+_59.w-(_5b.offsetWidth-_5b.clientWidth)):(_59.l+_59.w);
dojo.forEach(this.getHeaderNodes(),dojo.hitch(this,function(_5e,_5f){
if(_5f>this.exceptColumnsTo){
var x,_60=dojo.coords(_5e);
if(_55.x>=_60.x&&_55.x<=_60.x+_60.w){
if(!this.selectedColumns[_5f]||!this.selectedColumns[_5f-1]){
x=_60.x+_57.x+(rtl?_60.w:0);
if(_55.x<_5c||_55.x>_5d||x<_5c||x>_5d){
return;
}
dojo.style(_56,"left",x+"px");
this.drugDestIndex=_5f;
this.drugBefore=true;
!dojo.isIE&&this.normalizeColBorderHeight(_56,_5f);
}
}else{
if(this.getHeaderNodes()[_5f+1]==null&&(!rtl?(_55.x>_60.x+_60.w):(_55.x<_60.x))){
x=_55.x<_5c?_5c:(_55.x>_5d?_5d:(_60.x+_57.x+(rtl?0:_60.w)));
dojo.style(_56,"left",x+"px");
this.drugDestIndex=_5f;
this.drugBefore=false;
!dojo.isIE&&this.normalizeColBorderHeight(_56,_5f);
}
}
}
}));
},normalizeColBorderHeight:function(_61,_62){
var _63=this.grid.pluginMgr.getViewByCellIdx(_62);
if(!_63){
return;
}
var _64=_63.scrollboxNode,_65=dojo.attr(_61,"colH");
var _66=dojo.coords(_64).h-(_64.offsetHeight-_64.clientHeight);
_66=_65>0&&_65<_66?_65:_66;
dojo.style(_61,"height",_66+"px");
},avataDivClick:function(e){
if(this.movingIgnored){
this.movingIgnored=false;
return;
}
this.cleanAll();
this.clearDrugDivs();
},startMoveCols:function(){
this.changeCursorState("wait");
this.srcIndexdelta=0;
deltaColAmount=0;
dojo.forEach(this.selectedColumns,dojo.hitch(this,function(col,_67){
if(this.isColSelected(_67)){
if(this.drugDestIndex>_67){
_67-=deltaColAmount;
}
deltaColAmount+=1;
var _68=this.grid.layout.cells[_67].view.idx;
var _69=this.grid.layout.cells[this.drugDestIndex].view.idx;
if(_67!=this.drugDestIndex){
this.grid.layout.moveColumn(_68,_69,_67,this.drugDestIndex,this.drugBefore);
}
if(this.drugDestIndex<=_67&&this.drugDestIndex+1<this.grid.layout.cells.length){
this.drugDestIndex+=1;
}
}
}));
var _6a=this.drugDestIndex+(this.drugBefore?0:1);
this.clearDrugDivs();
this.cleanAll();
this.resetCellIdx();
this.drugSelectionStart.colIndex=_6a-deltaColAmount;
this.drugSelectColumn(this.drugSelectionStart.colIndex+deltaColAmount-1);
},changeCursorState:function(_6b){
dojo.forEach(this.coverDIVs,function(div){
div.style.cursor="wait";
});
},addRowMovers:function(){
var _6c=-1;
dojo.forEach(this.grid.selection.selected,function(row,_6d){
var _6e=this.grid.views.views[0];
if(row&&_6e.rowNodes[_6d]){
if(_6c==-1){
_6c=_6d;
}
if(this.grid.selection.selected[_6d+1]==null||!_6e.rowNodes[_6d+1]){
this.addRowMover(_6c,_6d);
_6c=-1;
}
}
},this);
},addRowMover:function(_6f,to){
var _70=0,_71=this.grid.views.views;
dojo.forEach(_71,function(_72,_73){
_70+=_72.getScrollbarWidth();
});
var _74=_71[_71.length-1].getScrollbarWidth();
var _75=!dojo._isBodyLtr()?(dojo.isIE?_70-_74:_70):0;
var _76=this.getGridWidth()-_74;
var _77=this.grid.views.views[0];
var _78=_77.rowNodes[_6f],_79=_77.rowNodes[to];
if(!_78||!_79){
return;
}
var _7a=dojo.coords(_78),_7b=dojo.coords(_79);
var _7c=this.getExceptionalColOffsetWidth();
var _7d=this.createCoverMover(_76-_7c,(_7b.y-_7a.y+_7b.h),dojo._isBodyLtr()?(_7a.x+_7a.w+_7c):(_7a.x-_76-_75),_7a.y,"row");
var _7e=this.setBorderDiv(_76,3,(dojo._isBodyLtr()?(_7b.x+_7b.w):(_7b.x-_76-_75))+dojo._docScroll().x,-100);
this.movers.push(_7d);
_7d.connections=[];
_7d.connections.push(this.connect(_7d,"onMoveStart",function(_7f,_80){
this.mover=_7f;
this.removeOtherMovers(_7f.node.id);
}));
_7d.connections.push(this.connect(_7d,"onMove",function(_81,_82,_83){
if(_81.node==null||_81.node.parentNode==null){
return;
}
this.isMoving=true;
this.moveRowBorder(_81,_82,_7e,_83);
}));
_7d.connections.push(this.connect(_7d,"onMoveStop",function(_84){
if(this.avaOnRowIndex==null||this.isContinuousSelection(this.grid.selection.selected)&&(this.avaOnRowIndex==_6f||this.avaOnRowIndex==(to+1))){
this.movingIgnored=true;
if(this.isMoving){
this.isMoving=false;
this.clearDrugDivs();
}
return;
}
this.isMoving=false;
this.mover=null;
this.grid.select.outRangeY=false;
this.grid.select.moveOutTop=false;
this.grid.scroller.findScrollTop(this.grid.scroller.page*this.grid.scroller.rowsPerPage);
this.startMoveRows();
this.avaOnRowIndex=null;
delete _7d;
}));
},moveRowBorder:function(_85,_86,_87,_88){
var _89=this.getGridCoords(true),_8a=dojo._docScroll();
var _8b=_89.t+this.headerHeight+_89.h;
_86.t-=_8a.y,_88.y-=_8a.y;
if(_88.y>=_8b){
this.grid.select.outRangeY=true;
this.autoMoveToNextRow();
}else{
if(_88.y<=_89.t+this.headerHeight){
this.grid.select.moveOutTop=true;
this.autoMoveToPreRow();
}else{
this.grid.select.outRangeY=this.grid.select.moveOutTop=false;
var _8c=this.grid.views.views[0],_8d=_8c.rowNodes;
var _8e=dojo.coords(_8c.contentNode).h;
var _8f=0,_90=-1;
for(i in _8d){
i=parseInt(i);
++_8f;
if(i>_90){
_90=i;
}
}
var _91=dojo.coords(_8d[_90]);
if(_8e<_89.h&&_88.y>(_91.y+_91.h)){
this.avaOnRowIndex=_8f;
dojo.style(_87,{"top":_91.y+_91.h+_8a.y+"px"});
return;
}
var _92,_93,_94;
for(var _95 in _8d){
_95=parseInt(_95);
if(isNaN(_95)){
continue;
}
_93=_8d[_95];
if(!_93){
continue;
}
_92=dojo.coords(_93),_94=(_92.y<=_8b);
if(_94&&_88.y>_92.y&&_88.y<_92.y+_92.h){
if(!this.grid.selection.selected[_95]||!this.grid.selection.selected[_95-1]){
this.avaOnRowIndex=_95;
dojo.style(_87,{"top":_92.y+_8a.y+"px"});
}
}
}
}
}
},autoMoveToPreRow:function(){
if(this.grid.select.moveOutTop){
if(this.grid.scroller.firstVisibleRow>0){
this.grid.scrollToRow(this.grid.scroller.firstVisibleRow-1);
this.autoMoveBorderDivPre();
setTimeout(dojo.hitch(this,"autoMoveToPreRow"),this.autoScrollRate);
}
}
},autoMoveBorderDivPre:function(){
var _96=dojo._docScroll(),_97=this.getGridCoords();
var _98=_97.t+this.headerHeight+_96.y;
var _99,_9a=this.getBorderDiv();
if(this.avaOnRowIndex-1<=0){
this.avaOnRowIndex=0;
_99=_98;
}else{
this.avaOnRowIndex--;
_99=dojo.coords(this.grid.views.views[0].rowNodes[this.avaOnRowIndex]).y+_96.y;
}
_9a.style.top=(_99<_98?_98:_99)+"px";
},autoMoveToNextRow:function(){
if(this.grid.select.outRangeY){
if(this.avaOnRowIndex+1<=this.grid.scroller.rowCount){
this.grid.scrollToRow(this.grid.scroller.firstVisibleRow+1);
this.autoMoveBorderDiv();
setTimeout(dojo.hitch(this,"autoMoveToNextRow"),this.autoScrollRate);
}
}
},autoMoveBorderDiv:function(){
var _9b=dojo._docScroll(),_9c=this.getGridCoords();
var _9d=_9c.t+this.headerHeight+_9c.h+_9b.y;
var _9e,_9f=this.getBorderDiv();
if(this.avaOnRowIndex+1>=this.grid.scroller.rowCount){
this.avaOnRowIndex=this.grid.scroller.rowCount;
_9e=_9d;
}else{
this.avaOnRowIndex++;
_9e=dojo.coords(this.grid.views.views[0].rowNodes[this.avaOnRowIndex]).y+_9b.y;
}
_9f.style.top=(_9e>_9d?_9d:_9e)+"px";
},startMoveRows:function(){
var _a0=Math.min(this.avaOnRowIndex,this.getFirstSelected());
var end=Math.max(this.avaOnRowIndex-1,this.getLastSelected());
this.moveRows(_a0,end,this.getPageInfo());
},moveRows:function(_a1,end,_a2){
var i,_a3=false,_a4=(selectedRowsAboveBorderDIV=0),_a5=[];
var _a6=this.grid.scroller,_a7=_a6.rowsPerPage;
var _a8=_a2.topPage*_a7,_a9=(_a2.bottomPage+1)*_a7-1;
var _aa=dojo.hitch(this,function(_ab,to){
for(i=_ab;i<to;i++){
if(!this.grid.selection.selected[i]||!this.grid._by_idx[i]){
_a5.push(this.grid._by_idx[i]);
}
}
});
_aa(_a1,this.avaOnRowIndex);
for(i=_a1;i<=end;i++){
if(this.grid.selection.selected[i]&&this.grid._by_idx[i]){
_a5.push(this.grid._by_idx[i]);
_a4++;
if(this.avaOnRowIndex>i){
selectedRowsAboveBorderDIV++;
}
}
}
_aa(this.avaOnRowIndex,end+1);
for(i=_a1,j=0;i<=end;i++){
this.grid._by_idx[i]=_a5[j++];
if(i>=_a8&&i<=_a9){
this.grid.updateRow(i);
_a3=true;
}
}
this.avaOnRowIndex+=_a4-selectedRowsAboveBorderDIV;
try{
this.clearDrugDivs();
this.cleanAll();
this.drugSelectionStart.rowIndex=this.avaOnRowIndex-_a4;
this.drugSelectRow(this.drugSelectionStart.rowIndex+_a4-1);
if(_a3){
var _ac=_a6.stack;
dojo.forEach(_a2.invalidPages,function(_ad){
_a6.destroyPage(_ad);
i=dojo.indexOf(_ac,_ad);
if(i>=0){
_ac.splice(i,1);
}
});
}
this.publishRowMove();
}
catch(e){
}
},clearDrugDivs:function(){
if(!this.isMoving){
var _ae=this.getBorderDiv();
dojo.style(_ae,{"top":-100+"px","height":"0px","left":-100+"px"});
dojo.forEach(this.coverDIVs,function(div){
dojo.forEach(div.connections,this.disconnect,this);
dojo.destroy(div);
},this);
dojo.forEach(this.movers,function(m){
dojo.forEach(m.connections,this.disconnect,this);
m.destroy&&m.destroy();
delete m;
},this);
this.coverDIVs=[],this.movers=[];
}
},setDrugCoverDivs:function(_af,_b0){
if(!this.isMoving){
if(this.isColSelected(_af)){
this.addColMovers();
}else{
if(this.grid.selection.selected[_b0]){
this.addRowMovers();
}else{
this.clearDrugDivs();
}
}
}
},getPageInfo:function(){
var _b1=this.grid.scroller,_b2=(bottomPage=_b1.page);
var _b3=_b1.firstVisibleRow,_b4=_b1.lastVisibleRow;
var _b5=_b1.rowsPerPage,_b6=_b1.pageNodes[0];
var _b7,_b8,_b9=[],_ba;
dojo.forEach(_b6,function(_bb,_bc){
if(!_bb){
return;
}
_ba=false;
_b7=_bc*_b5;
_b8=(_bc+1)*_b5-1;
if(_b3>=_b7&&_b3<=_b8){
_b2=_bc;
_ba=true;
}
if(_b4>=_b7&&_b4<=_b8){
bottomPage=_bc;
_ba=true;
}
if(!_ba&&(_b7>_b4||_b8<_b3)){
_b9.push(_bc);
}
});
return {topPage:_b2,bottomPage:bottomPage,invalidPages:_b9};
},resetCellIdx:function(){
var _bd=0;
var _be=-1;
dojo.forEach(this.grid.views.views,function(_bf,_c0){
if(_c0==0){
return;
}
if(_bf.structure.cells&&_bf.structure.cells[0]){
dojo.forEach(_bf.structure.cells[0],function(_c1,_c2){
var _c3=_c1.markup[2].split(" ");
var idx=_bd+_c2;
_c3[1]="idx=\""+idx+"\"";
_c1.markup[2]=_c3.join(" ");
});
}
for(i in _bf.rowNodes){
if(!_bf.rowNodes[i]){
return;
}
dojo.forEach(_bf.rowNodes[i].firstChild.rows[0].cells,function(_c4,_c5){
if(_c4&&_c4.attributes){
if(_c5+_bd>_be){
_be=_c5+_bd;
}
var idx=document.createAttribute("idx");
idx.value=_c5+_bd;
_c4.attributes.setNamedItem(idx);
}
});
}
_bd=_be+1;
});
},publishRowMove:function(){
dojo.publish(this.grid.rowMovedTopic,[this]);
},keyboardMove:function(_c6){
var _c7=this.selectedColumns.length>0;
var _c8=dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype["getFirstSelected"])()>=0;
var i,_c9,dk=dojo.keys,_ca=_c6.keyCode;
if(!dojo._isBodyLtr()){
_ca=(_c6.keyCode==dk.LEFT_ARROW)?dk.RIGHT_ARROW:(_c6.keyCode==dk.RIGHT_ARROW?dk.LEFT_ARROW:_ca);
}
switch(_ca){
case dk.LEFT_ARROW:
if(!_c7){
return;
}
_c9=this.getHeaderNodes().length;
for(i=0;i<_c9;i++){
if(this.isColSelected(i)){
this.drugDestIndex=i-1;
this.drugBefore=true;
break;
}
}
var _cb=this.grid.indirectSelection?1:0;
(this.drugDestIndex>=_cb)?this.startMoveCols():(this.drugDestIndex=_cb);
break;
case dk.RIGHT_ARROW:
if(!_c7){
return;
}
_c9=this.getHeaderNodes().length;
this.drugBefore=true;
for(i=0;i<_c9;i++){
if(this.isColSelected(i)&&!this.isColSelected(i+1)){
this.drugDestIndex=i+2;
if(this.drugDestIndex==_c9){
this.drugDestIndex--;
this.drugBefore=false;
}
break;
}
}
if(this.drugDestIndex<_c9){
this.startMoveCols();
}
break;
case dk.UP_ARROW:
if(!_c8){
return;
}
this.avaOnRowIndex=dojo.hitch(this.grid.selection,dojox.grid.Selection.prototype["getFirstSelected"])()-1;
if(this.avaOnRowIndex>-1){
this.startMoveRows();
}
break;
case dk.DOWN_ARROW:
if(!_c8){
return;
}
for(i=0;i<this.grid.rowCount;i++){
if(this.grid.selection.selected[i]&&!this.grid.selection.selected[i+1]){
this.avaOnRowIndex=i+2;
break;
}
}
if(this.avaOnRowIndex<=this.grid.rowCount){
this.startMoveRows();
}
}
},destroy:function(){
this.clearDrugDivs();
dojo.destroy(this.borderDIV);
this.inherited(arguments);
}});
}
