/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dojox.grid.enhanced._Plugin"]){
dojo._hasResource["dojox.grid.enhanced._Plugin"]=true;
dojo.provide("dojox.grid.enhanced._Plugin");
dojo.require("dojox.grid.enhanced._Builder");
dojo.require("dojox.grid.enhanced._Events");
dojo.declare("dojox.grid.enhanced._Plugin",null,{fixedCellNum:-1,funcMap:null,_plugins:null,_connects:null,constructor:function(_1){
this.grid=_1;
this.funcMap={},this._plugins=[],this._connects=[];
this._parseProps(this.grid);
},_parseProps:function(_2){
_2.plugins&&dojo.mixin(_2,_2.plugins);
_2.rowSelectCell=null;
_2.dnd&&(_2.nestedSorting=true);
(_2.dnd||_2.indirectSelection)&&(_2.columnReordering=false);
},preInit:function(){
var _3=this.grid;
if(_3.indirectSelection){
this._plugins.push(new (this.getPluginClazz("dojox.grid.enhanced.plugins.IndirectSelection"))(_3));
}
if(_3.dnd&&(!_3.rowSelector||_3.rowSelector=="false")){
_3.rowSelector="20px";
}
},postInit:function(){
var _4=this.grid;
new dojox.grid.enhanced._Events(_4);
if(_4.menus){
this._plugins.push(new (this.getPluginClazz("dojox.grid.enhanced.plugins.Menu"))(_4));
}
if(_4.nestedSorting){
this._plugins.push(new (this.getPluginClazz("dojox.grid.enhanced.plugins.NestedSorting"))(_4));
}
if(_4.dnd){
_4.isDndSelectEnable=_4.dnd;
_4.dndDisabledTypes=["cell"];
this._plugins.push(new (this.getPluginClazz("dojox.grid.enhanced.plugins.DnD"))(_4));
}
this.fixedCellNum=this.getFixedCellNumber();
this.grid.plugins&&this._bindFuncs();
},getPluginClazz:function(_5){
var _6=dojo.getObject(_5);
if(_6){
return _6;
}
throw new Error("Please make sure class \""+_5+"\" is required.");
},isFixedCell:function(_7){
return _7&&(_7.isRowSelector||_7.positionFixed);
},getFixedCellNumber:function(){
if(this.fixedCellNum>=0){
return this.fixedCellNum;
}
var i=0;
dojo.forEach(this.grid.layout.cells,dojo.hitch(this,function(_8){
this.isFixedCell(_8)&&(i++);
}));
return i;
},inSingleSelection:function(){
return this.grid.selectionMode&&this.grid.selectionMode=="single";
},needUpdateRow:function(){
return ((this.grid.indirectSelection||this.grid.isDndSelectEnable)?this.grid.edit.isEditing():true);
},_bindView:function(_9){
if(!_9){
return;
}
dojox.grid.util.funnelEvents(_9.contentNode,_9,"doContentEvent",["mouseup","mousemove"]);
dojox.grid.util.funnelEvents(_9.headerNode,_9,"doHeaderEvent",["mouseup"]);
this.grid.nestedSorting&&(_9._getHeaderContent=this.grid._getNestedSortHeaderContent);
this.grid.dnd&&(_9.setScrollTop=this.setScrollTop);
},_bindFuncs:function(){
dojo.forEach(this.grid.views.views,this._bindView,this);
this._connects.push(dojo.connect(this.grid.views,"addView",dojo.hitch(this,this._bindView)));
this.funcMap["nextKey"]=this.grid.focus.nextKey;
this.grid.focus.nextKey=this.nextKey;
this.funcMap["previousKey"]=this.grid.focus.previousKey;
this.grid.focus.previousKey=this.previousKey;
if(this.grid.indirectSelection){
this.funcMap["renderPage"]=this.grid.scroller.renderPage;
this.grid.scroller.renderPage=this.renderPage;
this.funcMap["measurePage"]=this.grid.scroller.measurePage;
this.grid.scroller.measurePage=this.measurePage;
}
this.funcMap["updateRow"]=this.grid.updateRow;
this.grid.updateRow=this.updateRow;
var _a=this.grid.edit;
_a&&(_a.styleRow=function(_b){
});
},previousKey:function(e){
var _c=this.grid.edit.isEditing();
if(!_c&&!this.isNavHeader()&&!this._isHeaderHidden()){
if(!this.grid.isDndSelectEnable){
this.focusHeader();
}else{
if(!this.isRowBar()){
this.focusRowBar();
}else{
this._blurRowBar();
this.focusHeader();
}
}
dojo.stopEvent(e);
return;
}
dojo.hitch(this,this.grid.pluginMgr.funcMap["previousKey"])(e);
},nextKey:function(e){
var _d=this.grid.rowCount==0;
var _e=(e.target===this.grid.domNode);
if(!_e&&this.grid.isDndSelectEnable&&this.isNavHeader()){
this._colHeadNode=this._colHeadFocusIdx=null;
this.focusRowBar();
return;
}else{
if(!_e&&(!this.grid.isDndSelectEnable&&this.isNavHeader())||(this.grid.isDndSelectEnable&&this.isRowBar())){
this._colHeadNode=this._colHeadFocusIdx=null;
if(this.grid.isDndSelectEnable){
this._blurRowBar();
}
if(this.isNoFocusCell()&&!_d){
this.setFocusIndex(0,0);
}else{
if(this.cell&&!_d){
if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){
this.grid.scrollToRow(this.rowIndex);
}
this.focusGrid();
}else{
if(!this.findAndFocusGridCell()){
this.tabOut(this.grid.lastFocusNode);
}
}
}
return;
}
}
dojo.hitch(this,this.grid.pluginMgr.funcMap["nextKey"])(e);
},renderPage:function(_f){
for(var i=0,j=_f*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){
}
(--j>=0)&&this.grid.lastRenderingRows.push(j);
dojo.addClass(this.grid.domNode,"dojoxGridSortInProgress");
dojo.hitch(this,this.grid.pluginMgr.funcMap["renderPage"])(_f);
},measurePage:function(_10){
var _11=dojo.hitch(this,this.grid.pluginMgr.funcMap["measurePage"])(_10);
return (!dojo.isIE||this.grid.rowHeight||_11>this.rowsPerPage*this.grid.minRowHeight)?_11:undefined;
},updateRow:function(_12){
var _13=arguments.callee.caller;
if(_13.nom=="move"&&!this.pluginMgr.needUpdateRow()){
return;
}
dojo.hitch(this,this.pluginMgr.funcMap["updateRow"])(_12);
},setScrollTop:function(_14){
this.lastTop=_14;
this.scrollboxNode.scrollTop=_14;
return this.scrollboxNode.scrollTop;
},getViewByCellIdx:function(_15){
var _16=function(_17){
var j=0,_18=false;
for(;j<_17.length;j++){
if(dojo.isArray(_17[j])){
if(_16(_17[j])){
return true;
}
}else{
if(_17[j].index==_15){
return true;
}
}
}
};
var i=0,_19=this.grid.views.views;
for(;i<_19.length;i++){
cells=_19[i].structure.cells;
if(_16(cells)){
return _19[i];
}
}
return null;
},destroy:function(){
dojo.forEach(this._connects,dojo.disconnect);
dojo.forEach(this._plugins,function(p){
p.destroy&&p.destroy();
delete p;
});
delete this._connects;
delete this._plugins;
}});
}
