/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/


if(!dojo._hasResource["dijit._HasDropDown"]){
dojo._hasResource["dijit._HasDropDown"]=true;
dojo.provide("dijit._HasDropDown");
dojo.require("dijit._base.place");
dojo.require("dijit._Widget");
dojo.declare("dijit._HasDropDown",null,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){
if(this.disabled||this.readOnly){
return;
}
this._docHandler=this.connect(dojo.doc,"onmouseup","_onDropDownMouseUp");
this.toggleDropDown();
},_onDropDownMouseUp:function(e){
if(e&&this._docHandler){
this.disconnect(this._docHandler);
}
var _1=this.dropDown,_2=false;
if(e&&this._opened){
var c=dojo.position(this._buttonNode,true);
if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){
var t=e.target;
while(t&&!_2){
if(dojo.hasClass(t,"dijitPopup")){
_2=true;
}else{
t=t.parentNode;
}
}
if(_2){
t=e.target;
if(_1.onItemClick){
var _3;
while(t&&!(_3=dijit.byNode(t))){
t=t.parentNode;
}
if(_3&&_3.onClick&&_3.getParent){
_3.getParent().onItemClick(_3,e);
}
}
return;
}
}
}
if(this._opened&&_1.focus&&_1.autoFocus!==false){
window.setTimeout(dojo.hitch(_1,"focus"),1);
}
},_onDropDownClick:function(e){
if(this._stopClickEvents){
dojo.stopEvent(e);
}
},_setupDropdown:function(){
this._buttonNode=this._buttonNode||this.focusNode||this.domNode;
this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;
this._aroundNode=this._aroundNode||this.domNode;
this.connect(this._buttonNode,"onmousedown","_onDropDownMouseDown");
this.connect(this._buttonNode,"onclick","_onDropDownClick");
this.connect(this._buttonNode,"onkeydown","_onDropDownKeydown");
this.connect(this._buttonNode,"onkeyup","_onKey");
if(this._setStateClass){
this.connect(this,"openDropDown","_setStateClass");
this.connect(this,"closeDropDown","_setStateClass");
}
var _4={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";
dojo.addClass(this._arrowWrapperNode||this._buttonNode,"dijit"+_4+"ArrowButton");
},postCreate:function(){
this._setupDropdown();
this.inherited(arguments);
},destroyDescendants:function(){
if(this.dropDown){
if(!this.dropDown._destroyed){
this.dropDown.destroyRecursive();
}
delete this.dropDown;
}
this.inherited(arguments);
},_onDropDownKeydown:function(e){
if(e.keyCode==dojo.keys.DOWN_ARROW||e.keyCode==dojo.keys.ENTER||e.keyCode==dojo.keys.SPACE){
e.preventDefault();
}
},_onKey:function(e){
if(this.disabled||this.readOnly){
return;
}
var d=this.dropDown;
if(d&&this._opened&&d.handleKey){
if(d.handleKey(e)===false){
return;
}
}
if(d&&this._opened&&e.keyCode==dojo.keys.ESCAPE){
this.toggleDropDown();
}else{
if(d&&!this._opened&&(e.keyCode==dojo.keys.DOWN_ARROW||e.keyCode==dojo.keys.ENTER||e.keyCode==dojo.keys.SPACE)){
this.toggleDropDown();
if(d.focus){
setTimeout(dojo.hitch(d,"focus"),1);
}
}
}
},_onBlur:function(){
this.closeDropDown();
this.inherited(arguments);
},isLoaded:function(){
return true;
},loadDropDown:function(_5){
_5();
},toggleDropDown:function(){
if(this.disabled||this.readOnly){
return;
}
this.focus();
if(!this._opened){
if(!this.isLoaded()){
this.loadDropDown(dojo.hitch(this,"openDropDown"));
return;
}else{
this.openDropDown();
}
}else{
this.closeDropDown();
}
},openDropDown:function(){
var _6=this.dropDown;
var _7=_6.domNode;
var _8=this;
if(!this._preparedNode){
dijit.popup.moveOffScreen(_6);
this._preparedNode=true;
if(_7.style.width){
this._explicitDDWidth=true;
}
if(_7.style.height){
this._explicitDDHeight=true;
}
}
if(this.maxHeight||this.forceWidth||this.autoWidth){
var _9={display:"",visibility:"hidden"};
if(!this._explicitDDWidth){
_9.width="";
}
if(!this._explicitDDHeight){
_9.height="";
}
dojo.style(_7,_9);
var mb=dojo.marginBox(_7);
var _a=(this.maxHeight&&mb.h>this.maxHeight);
dojo.style(_7,{overflowX:"hidden",overflowY:_a?"auto":"hidden"});
if(_a){
mb.h=this.maxHeight;
if("w" in mb){
mb.w+=16;
}
}else{
delete mb.h;
}
delete mb.t;
delete mb.l;
if(this.forceWidth){
mb.w=this.domNode.offsetWidth;
}else{
if(this.autoWidth){
mb.w=Math.max(mb.w,this.domNode.offsetWidth);
}else{
delete mb.w;
}
}
if(dojo.isFunction(_6.resize)){
_6.resize(mb);
}else{
dojo.marginBox(_7,mb);
}
}
var _b=dijit.popup.open({parent:this,popup:_6,around:this._aroundNode,orient:dijit.getPopupAroundAlignment((this.dropDownPosition&&this.dropDownPosition.length)?this.dropDownPosition:["below"],this.isLeftToRight()),onExecute:function(){
_8.closeDropDown(true);
},onCancel:function(){
_8.closeDropDown(true);
},onClose:function(){
dojo.attr(_8._popupStateNode,"popupActive",false);
dojo.removeClass(_8._popupStateNode,"dijitHasDropDownOpen");
_8._opened=false;
_8.state="";
}});
dojo.attr(this._popupStateNode,"popupActive","true");
dojo.addClass(_8._popupStateNode,"dijitHasDropDownOpen");
this._opened=true;
this.state="Opened";
return _b;
},closeDropDown:function(_c){
if(this._opened){
if(_c){
this.focus();
}
dijit.popup.close(this.dropDown);
this._opened=false;
this.state="";
}
}});
}
