/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/_editor/plugins/FontChoice":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/i18n","dojo/_base/lang","dojo/store/Memory","../../registry","../../_Widget","../../_TemplatedMixin","../../_WidgetsInTemplateMixin","../../form/FilteringSelect","../_Plugin","../range","dojo/i18n!../nls/FontChoice"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e){var _f=_3("dijit._editor.plugins._FontDropDown",[_9,_a,_b],{label:"",plainText:false,templateString:"<span style='white-space: nowrap' class='dijit dijitReset dijitInline'>"+"<label class='dijitLeft dijitInline' for='${selectId}'>${label}</label>"+"<input data-dojo-type='../../form/FilteringSelect' required='false' "+"data-dojo-props='labelType:\"html\", labelAttr:\"label\", searchAttr:\"name\"' "+"class='${comboClass}' "+"tabIndex='-1' id='${selectId}' data-dojo-attach-point='select' value=''/>"+"</span>",contextRequire:_1,postMixInProperties:function(){this.inherited(arguments);this.strings=_5.getLocalization("dijit._editor","FontChoice");this.label=this.strings[this.command];this.id=_8.getUniqueId(this.declaredClass.replace(/\./g,"_"));this.selectId=this.id+"_select";this.inherited(arguments);},postCreate:function(){this.select.set("store",new _7({idProperty:"value",data:_2.map(this.values,function(_10){var _11=this.strings[_10]||_10;return {label:this.getLabel(_10,_11),name:_11,value:_10};},this)}));this.select.set("value","",false);this.disabled=this.select.get("disabled");},_setValueAttr:function(_12,_13){_13=_13!==false;this.select.set("value",_2.indexOf(this.values,_12)<0?"":_12,_13);if(!_13){this.select._lastValueReported=null;}},_getValueAttr:function(){return this.select.get("value");},focus:function(){this.select.focus();},_setDisabledAttr:function(_14){this._set("disabled",_14);this.select.set("disabled",_14);}});var _15=_3("dijit._editor.plugins._FontNameDropDown",_f,{generic:false,command:"fontName",comboClass:"dijitFontNameCombo",postMixInProperties:function(){if(!this.values){this.values=this.generic?["serif","sans-serif","monospace","cursive","fantasy"]:["Arial","Times New Roman","Comic Sans MS","Courier New"];}this.inherited(arguments);},getLabel:function(_16,_17){if(this.plainText){return _17;}else{return "<div style='font-family: "+_16+"'>"+_17+"</div>";}},_setValueAttr:function(_18,_19){_19=_19!==false;if(this.generic){var map={"Arial":"sans-serif","Helvetica":"sans-serif","Myriad":"sans-serif","Times":"serif","Times New Roman":"serif","Comic Sans MS":"cursive","Apple Chancery":"cursive","Courier":"monospace","Courier New":"monospace","Papyrus":"fantasy","Estrangelo Edessa":"cursive","Gabriola":"fantasy"};_18=map[_18]||_18;}this.inherited(arguments,[_18,_19]);}});var _1a=_3("dijit._editor.plugins._FontSizeDropDown",_f,{command:"fontSize",comboClass:"dijitFontSizeCombo",values:[1,2,3,4,5,6,7],getLabel:function(_1b,_1c){if(this.plainText){return _1c;}else{return "<font size="+_1b+"'>"+_1c+"</font>";}},_setValueAttr:function(_1d,_1e){_1e=_1e!==false;if(_1d.indexOf&&_1d.indexOf("px")!=-1){var _1f=parseInt(_1d,10);_1d={10:1,13:2,16:3,18:4,24:5,32:6,48:7}[_1f]||_1d;}this.inherited(arguments,[_1d,_1e]);}});var _20=_3("dijit._editor.plugins._FormatBlockDropDown",_f,{command:"formatBlock",comboClass:"dijitFormatBlockCombo",values:["noFormat","p","h1","h2","h3","pre"],postCreate:function(){this.inherited(arguments);this.set("value","noFormat",false);},getLabel:function(_21,_22){if(this.plainText||_21=="noFormat"){return _22;}else{return "<"+_21+">"+_22+"</"+_21+">";}},_execCommand:function(_23,_24,_25){if(_25==="noFormat"){var _26;var end;var sel=_e.getSelection(_23.window);if(sel&&sel.rangeCount>0){var _27=sel.getRangeAt(0);var _28,tag;if(_27){_26=_27.startContainer;end=_27.endContainer;while(_26&&_26!==_23.editNode&&_26!==_23.document.body&&_26.nodeType!==1){_26=_26.parentNode;}while(end&&end!==_23.editNode&&end!==_23.document.body&&end.nodeType!==1){end=end.parentNode;}var _29=_6.hitch(this,function(_2a,ary){if(_2a.childNodes&&_2a.childNodes.length){var i;for(i=0;i<_2a.childNodes.length;i++){var c=_2a.childNodes[i];if(c.nodeType==1){if(_23.selection.inSelection(c)){var tag=c.tagName?c.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){ary.push(c);}_29(c,ary);}}}}});var _2b=_6.hitch(this,function(_2c){if(_2c&&_2c.length){_23.beginEditing();while(_2c.length){this._removeFormat(_23,_2c.pop());}_23.endEditing();}});var _2d=[];if(_26==end){var _2e;_28=_26;while(_28&&_28!==_23.editNode&&_28!==_23.document.body){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2e=_28;break;}}_28=_28.parentNode;}_29(_26,_2d);if(_2e){_2d=[_2e].concat(_2d);}_2b(_2d);}else{_28=_26;while(_23.selection.inSelection(_28)){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2d.push(_28);}_29(_28,_2d);}_28=_28.nextSibling;}_2b(_2d);}_23.onDisplayChanged();}}}else{_23.execCommand(_24,_25);}},_removeFormat:function(_2f,_30){if(_2f.customUndo){while(_30.firstChild){_4.place(_30.firstChild,_30,"before");}_30.parentNode.removeChild(_30);}else{_2f.selection.selectElementChildren(_30);var _31=_2f.selection.getSelectedHtml();_2f.selection.selectElement(_30);_2f.execCommand("inserthtml",_31||"");}}});var _32=_3("dijit._editor.plugins.FontChoice",_d,{useDefaultCommand:false,_initButton:function(){var _33={fontName:_15,fontSize:_1a,formatBlock:_20}[this.command],_34=this.params;if(this.params.custom){_34.values=this.params.custom;}var _35=this.editor;this.button=new _33(_6.delegate({dir:_35.dir,lang:_35.lang},_34));this.own(this.button.select.on("change",_6.hitch(this,function(_36){if(this.editor.focused){this.editor.focus();}if(this.command=="fontName"&&_36.indexOf(" ")!=-1){_36="'"+_36+"'";}if(this.button._execCommand){this.button._execCommand(this.editor,this.command,_36);}else{this.editor.execCommand(this.command,_36);}})));},updateState:function(){var _37=this.editor;var _38=this.command;if(!_37||!_37.isLoaded||!_38.length){return;}if(this.button){var _39=this.get("disabled");this.button.set("disabled",_39);if(_39){return;}var _3a;try{_3a=_37.queryCommandValue(_38)||"";}catch(e){_3a="";}var _3b=_6.isString(_3a)&&_3a.match(/'([^']*)'/);if(_3b){_3a=_3b[1];}if(_38==="formatBlock"){if(!_3a||_3a=="p"){_3a=null;var _3c;var sel=_e.getSelection(this.editor.window);if(sel&&sel.rangeCount>0){var _3d=sel.getRangeAt(0);if(_3d){_3c=_3d.endContainer;}}while(_3c&&_3c!==_37.editNode&&_3c!==_37.document){var tg=_3c.tagName?_3c.tagName.toLowerCase():"";if(tg&&_2.indexOf(this.button.values,tg)>-1){_3a=tg;break;}_3c=_3c.parentNode;}if(!_3a){_3a="noFormat";}}else{if(_2.indexOf(this.button.values,_3a)<0){_3a="noFormat";}}}if(_3a!==this.button.get("value")){this.button.set("value",_3a,false);}}}});_2.forEach(["fontName","fontSize","formatBlock"],function(_3e){_d.registry[_3e]=function(_3f){return new _32({command:_3e,plainText:_3f.plainText});};});_32._FontDropDown=_f;_32._FontNameDropDown=_15;_32._FontSizeDropDown=_1a;_32._FormatBlockDropDown=_20;return _32;});},"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_40,_41,_42,_43,_44,on,has,_45,_46,_47,_48){var _49=_40("dijit.form.TextBox"+(has("dojo-bidi")?"_NoBidi":""),[_45,_46],{templateString:_47,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var _4a=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((_4a=="hidden"||_4a=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(has("ie")<9){this.defer(function(){try{var s=_42.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _4b=this.domNode.getElementsByTagName("INPUT");if(_4b){for(var i=0;i<_4b.length;i++){_4b[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_41.create("span",{className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"mousedown",function(evt){evt.preventDefault();}),on(this._phspan,"touchend, pointerup, MSPointerUp",_44.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(evt){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_4c,_4d,_4e){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_43.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_4f){_43.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_4f);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(has("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")<9){_49.prototype._isTextSelected=function(){var _50=this.ownerDocument.selection.createRange();var _51=_50.parentElement();return _51==this.textbox&&_50.text.length>0;};_48._setSelectionRange=_46._setSelectionRange=function(_52,_53,_54){if(_52.createTextRange){var r=_52.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_53);r.moveEnd("character",_54-_53);r.select();}};}if(has("dojo-bidi")){_49=_40("dijit.form.TextBox",_49,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _49;});},"dojo/currency":function(){define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_55,_56,_57,_58,_59,_5a){var _5b={};_56.setObject("dojo.currency",_5b);_5b._mixInDefaults=function(_5c){_5c=_5c||{};_5c.type="currency";var _5d=_58.getLocalization("dojo.cldr","currency",_5c.locale)||{};var iso=_5c.currency;var _5e=_5a.getData(iso);_55.forEach(["displayName","symbol","group","decimal"],function(_5f){_5e[_5f]=_5d[iso+"_"+_5f];});_5e.fractional=[true,false];return _56.mixin(_5e,_5c);};_5b.format=function(_60,_61){return _57.format(_60,_5b._mixInDefaults(_61));};_5b.regexp=function(_62){return _57.regexp(_5b._mixInDefaults(_62));};_5b.parse=function(_63,_64){return _57.parse(_63,_5b._mixInDefaults(_64));};return _5b;});},"dijit/layout/ScrollingTabController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom","../a11yclick"],function(_65,_66,_67,_68,_69,fx,_6a,on,_6b,has,_6c,_6d,_6e,_6f,_70,_71,_72,_73,_74,_75){var _76=_66("dijit.layout.ScrollingTabController",[_6f,_71],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_6d,useMenu:true,useSlider:true,tabStripClass:"",_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_67.add(n,"tabStrip-disabled");}_67.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_69.set(this.domNode,"visibility","");this._postStartup=true;this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_6a.hitch(this,function(evt){if(this._dim){this.resize(this._dim);}})));},onAddChild:function(_77,_78){this.inherited(arguments);_69.set(this.containerNode,"width",(_69.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(_79,_7a){var _7b=this.pane2button(_79.id);if(this._selectedTab===_7b.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_6b("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_68.getMarginSize(btn).w;return true;}else{_69.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _7c=this.getChildren();if(_7c.length){var _7d=_7c[this.isLeftToRight()?0:_7c.length-1].domNode,_7e=_7c[this.isLeftToRight()?_7c.length-1:0].domNode;return _7e.offsetLeft+_7e.offsetWidth-_7d.offsetLeft;}else{return 0;}},_enableBtn:function(_7f){var _80=this._getTabsWidth();_7f=_7f||_69.get(this.scrollNode,"width");return _80>0&&_7f<_80;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_70.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_68.setContentSize(this.domNode,cb);var _81=this._enableBtn(this._contentBox.w);this._buttons.style("display",_81?"":"none");this._leftBtn.region="left";this._rightBtn.region="right";this._menuBtn.region=this.isLeftToRight()?"right":"left";_70.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,region:"center"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){return val;}else{var _82=_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width");return (has("ie")>=8?-1:1)*(val-_82);}},onSelectChild:function(_83){var tab=this.pane2button(_83.id);if(!tab){return;}var _84=tab.domNode;if(_84!=this._selectedTab){this._selectedTab=_84;if(this._postResize){var sl=this._getScroll();if(sl>_84.offsetLeft||sl+_69.get(this.scrollNode,"width")<_84.offsetLeft+_69.get(_84,"width")){this.createSmoothScroll().play();}}}this.inherited(arguments);},_getScrollBounds:function(){var _85=this.getChildren(),_86=_69.get(this.scrollNode,"width"),_87=_69.get(this.containerNode,"width"),_88=_87-_86,_89=this._getTabsWidth();if(_85.length&&_89>_86){return {min:this.isLeftToRight()?0:_85[_85.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_85[_85.length-1].domNode.offsetLeft+_85[_85.length-1].domNode.offsetWidth)-_86:_88};}else{var _8a=this.isLeftToRight()?0:_88;return {min:_8a,max:_8a};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_8b=_69.get(this.scrollNode,"width"),_8c=this._getScrollBounds();var pos=(n.offsetLeft+_69.get(n,"width")/2)-_8b/2;pos=Math.min(Math.max(pos,_8c.min),_8c.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _8d=this._getScrollBounds();x=Math.min(Math.max(x,_8d.min),_8d.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var _8e=this,w=this.scrollNode,_8f=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var _90=w.scrollLeft,_91=_8e._convertToScrollLeft(x);_8f.curve=new fx._Line(_90,_91);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=_8f;this._setButtonClass(x);return _8f;},_getBtnNode:function(e){var n=e.target;while(n&&!_67.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_92,_93){if(_93&&_67.contains(_93,"dijitTabDisabled")){return;}var _94=_69.get(this.scrollNode,"width");var d=(_94*0.75)*_92;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_95){var _96=this._getScrollBounds();this._leftBtn.set("disabled",_95<=_96.min);this._rightBtn.set("disabled",_95>=_96.max);}});var _97=_66("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_6e,tabIndex:"",isFocusable:function(){return false;}});_66("dijit.layout._ScrollingTabControllerButton",[_74,_97]);_66("dijit.layout._ScrollingTabControllerMenuButton",[_74,_75,_97],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_98){this.dropDown=new _72({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});var _99=_6c.byId(this.containerId);_65.forEach(_99.getChildren(),function(_9a){var _9b=new _73({id:_9a.id+"_stcMi",label:_9a.title,iconClass:_9a.iconClass,disabled:_9a.disabled,ownerDocument:this.ownerDocument,dir:_9a.dir,lang:_9a.lang,textDir:_9a.textDir||_99.textDir,onClick:function(){_99.selectChild(_9a);}});this.dropDown.addChild(_9b);},this);_98();},closeDropDown:function(_9c){this.inherited(arguments);if(this.dropDown){this._popupStateNode.removeAttribute("aria-owns");this.dropDown.destroyRecursive();delete this.dropDown;}}});return _76;});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_9d,_9e,_9f,_a0,_a1,on,_a2,_a3,_a4,_a5,_a6,_a7){var _a8=_9d("dijit.DialogUnderlay",[_a3,_a4],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_a0.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_a9){this.node.className="dijitDialogUnderlay "+_a9;this._set("class",_a9);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",_9e.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _aa=_a2.getBox(this.ownerDocument);os.top=_aa.t+"px";os.left=_aa.l+"px";is.width=_aa.w+"px";is.height=_aa.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _a5(this.domNode);var win=_a2.get(this.ownerDocument);this._modalConnects=[_a6.on("resize",_9e.hitch(this,"layout")),on(win,"scroll",_9e.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_a8.show=function(_ab,_ac){var _ad=_a8._singleton;if(!_ad||_ad._destroyed){_ad=_a7._underlay=_a8._singleton=new _a8(_ab);}else{if(_ab){_ad.set(_ab);}}_a1.set(_ad.domNode,"zIndex",_ac);if(!_ad.open){_ad.show();}};_a8.hide=function(){var _ae=_a8._singleton;if(_ae&&!_ae._destroyed){_ae.hide();}};return _a8;});},"dijit/_editor/html":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(_af,_b0,has){var _b1={};_b0.setObject("dijit._editor.html",_b1);var _b2=_b1.escapeXml=function(str,_b3){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_b3){str=str.replace(/'/gm,"&#39;");}return str;};_b1.getNodeHtml=function(_b4){var _b5=[];_b1.getNodeHtmlHelper(_b4,_b5);return _b5.join("");};_b1.getNodeHtmlHelper=function(_b6,_b7){switch(_b6.nodeType){case 1:var _b8=_b6.nodeName.toLowerCase();if(!_b8||_b8.charAt(0)=="/"){return "";}_b7.push("<",_b8);var _b9=[],_ba={};var _bb;if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){var i=0;while((_bb=_b6.attributes[i++])){var n=_bb.name;if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||_bb.specified)&&!(n in _ba)){var v=_bb.value;if(n=="src"||n=="href"){if(_b6.getAttribute("_djrealurl")){v=_b6.getAttribute("_djrealurl");}}if(has("ie")===8&&n==="style"){v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");}_b9.push([n,v]);_ba[n]=v;}}}else{var _bc=/^input$|^img$/i.test(_b6.nodeName)?_b6:_b6.cloneNode(false);var s=_bc.outerHTML;var _bd=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;var _be=s.match(_bd);s=s.substr(0,s.indexOf(">"));_af.forEach(_be,function(_bf){if(_bf){var idx=_bf.indexOf("=");if(idx>0){var key=_bf.substring(0,idx);if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(_b6.getAttribute("_djrealurl")){_b9.push([key,_b6.getAttribute("_djrealurl")]);return;}}var val,_c0;switch(key){case "style":val=_b6.style.cssText.toLowerCase();break;case "class":val=_b6.className;break;case "width":if(_b8==="img"){_c0=/width=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}case "height":if(_b8==="img"){_c0=/height=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}default:val=_b6.getAttribute(key);}if(val!=null){_b9.push([key,val.toString()]);}}}}},this);}_b9.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((_bb=_b9[j++])){_b7.push(" ",_bb[0],"=\"",(typeof _bb[1]==="string"?_b2(_bb[1],true):_bb[1]),"\"");}switch(_b8){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_b7.push(" />");break;case "script":_b7.push(">",_b6.innerHTML,"</",_b8,">");break;default:_b7.push(">");if(_b6.hasChildNodes()){_b1.getChildrenHtmlHelper(_b6,_b7);}_b7.push("</",_b8,">");}break;case 4:case 3:_b7.push(_b2(_b6.nodeValue,true));break;case 8:_b7.push("<!--",_b2(_b6.nodeValue,true),"-->");break;default:_b7.push("<!-- Element not recognized - Type: ",_b6.nodeType," Name: ",_b6.nodeName,"-->");}};_b1.getChildrenHtml=function(_c1){var _c2=[];_b1.getChildrenHtmlHelper(_c1,_c2);return _c2.join("");};_b1.getChildrenHtmlHelper=function(dom,_c3){if(!dom){return;}var _c4=dom["childNodes"]||dom;var _c5=!has("ie")||_c4!==dom;var _c6,i=0;while((_c6=_c4[i++])){if(!_c5||_c6.parentNode==dom){_b1.getNodeHtmlHelper(_c6,_c3);}}};return _b1;});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_c7,_c8,dom,_c9,_ca,_cb,_cc,has,_cd,_ce,on,_cf,_d0,_d1,_d2,_d3){return _c7("dijit._HasDropDown",_d3,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}if(e.type!="MSPointerDown"&&e.type!="pointerdown"){e.preventDefault();}this._docHandler=this.own(on(this.ownerDocument,_cf.release,_ce.hitch(this,"_onDropDownMouseUp")))[0];this.toggleDropDown();},_onDropDownMouseUp:function(e){if(e&&this._docHandler){this._docHandler.remove();this._docHandler=null;}var _d4=this.dropDown,_d5=false;if(e&&this._opened){var c=_cb.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_d5){if(_ca.contains(t,"dijitPopup")){_d5=true;}else{t=t.parentNode;}}if(_d5){t=e.target;if(_d4.onItemClick){var _d6;while(t&&!(_d6=_d0.byNode(t))){t=t.parentNode;}if(_d6&&_d6.onClick&&_d6.getParent){_d6.getParent().onItemClick(_d6,e);}}return;}}}if(this._opened){if(_d4.focus&&(_d4.autoFocus!==false||(e.type=="mouseup"&&!this.hovering))){this._focusDropDownTimer=this.defer(function(){_d4.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _d7={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_ca.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_d7+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _d8=this.focusNode||this.domNode;this.own(on(this._buttonNode,_cf.press,_ce.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_ce.hitch(this,"_onDropDownClick")),on(_d8,"keydown",_ce.hitch(this,"_onKey")),on(_d8,"keyup",_ce.hitch(this,"_onKeyUp")));},destroy:function(){if(this._opened){this.closeDropDown(true);}if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_d9=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==_cd.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==_cd.DOWN_ARROW||((e.keyCode==_cd.ENTER||(e.keyCode==_cd.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_d9.tagName||"").toLowerCase()!=="input"||(_d9.type&&_d9.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(_ce.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_da){_da();},loadAndOpenDropDown:function(){var d=new _c8(),_db=_ce.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_db);}else{_db();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _dc=this.dropDown,_dd=_dc.domNode,_de=this._aroundNode||this.domNode,_df=this;var _e0=_d2.open({parent:this,popup:_dc,around:_de,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){_df.closeDropDown(true);},onCancel:function(){_df.closeDropDown(true);},onClose:function(){_c9.set(_df._popupStateNode,"popupActive",false);_ca.remove(_df._popupStateNode,"dijitHasDropDownOpen");_df._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_de.offsetWidth>_dc._popupWrapper.offsetWidth)){var _e1=_de.offsetWidth-_dc._popupWrapper.offsetWidth;var _e2={w:_dc.domNode.offsetWidth+_e1};if(_ce.isFunction(_dc.resize)){_dc.resize(_e2);}else{_cb.setMarginBox(_dd,_e2);}if(_e0.corner[1]=="R"){_dc._popupWrapper.style.left=(_dc._popupWrapper.style.left.replace("px","")-_e1)+"px";}}_c9.set(this._popupStateNode,"popupActive","true");_ca.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_dc.id);if(_dd.getAttribute("role")!=="presentation"&&!_dd.getAttribute("aria-labelledby")){_dd.setAttribute("aria-labelledby",this.id);}return _e0;},closeDropDown:function(_e3){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_e3&&this.focus){this.focus();}_d2.close(this.dropDown);this._opened=false;}}});});},"dijit/tree/TreeStoreModel":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_e4,_e5,_e6,_e7){return _e6("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_e8){_e7.mixin(this,_e8);this.connects=[];var _e9=this.store;if(!_e9.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");}if(_e9.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_e5.after(_e9,"onNew",_e7.hitch(this,"onNewItem"),true),_e5.after(_e9,"onDelete",_e7.hitch(this,"onDeleteItem"),true),_e5.after(_e9,"onSet",_e7.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_ea,_eb){if(this.root){_ea(this.root);}else{this.store.fetch({query:this.query,onComplete:_e7.hitch(this,function(_ec){if(_ec.length!=1){throw new Error("dijit.tree.TreeStoreModel: root query returned "+_ec.length+" items, but must return exactly one");}this.root=_ec[0];_ea(this.root);}),onError:_eb});}},mayHaveChildren:function(_ed){return _e4.some(this.childrenAttrs,function(_ee){return this.store.hasAttribute(_ed,_ee);},this);},getChildren:function(_ef,_f0,_f1){var _f2=this.store;if(!_f2.isItemLoaded(_ef)){var _f3=_e7.hitch(this,arguments.callee);_f2.loadItem({item:_ef,onItem:function(_f4){_f3(_f4,_f0,_f1);},onError:_f1});return;}var _f5=[];for(var i=0;i<this.childrenAttrs.length;i++){var _f6=_f2.getValues(_ef,this.childrenAttrs[i]);_f5=_f5.concat(_f6);}var _f7=0;if(!this.deferItemLoadingUntilExpand){_e4.forEach(_f5,function(_f8){if(!_f2.isItemLoaded(_f8)){_f7++;}});}if(_f7==0){_f0(_f5);}else{_e4.forEach(_f5,function(_f9,idx){if(!_f2.isItemLoaded(_f9)){_f2.loadItem({item:_f9,onItem:function(_fa){_f5[idx]=_fa;if(--_f7==0){_f0(_f5);}},onError:_f1});}});}},isItem:function(_fb){return this.store.isItem(_fb);},fetchItemByIdentity:function(_fc){this.store.fetchItemByIdentity(_fc);},getIdentity:function(_fd){return this.store.getIdentity(_fd);},getLabel:function(_fe){if(this.labelAttr){return this.store.getValue(_fe,this.labelAttr);}else{return this.store.getLabel(_fe);}},newItem:function(_ff,_100,_101){var _102={parent:_100,attribute:this.childrenAttrs[0]},_103;if(this.newItemIdAttr&&_ff[this.newItemIdAttr]){this.fetchItemByIdentity({identity:_ff[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_100,true,_101);}else{_103=this.store.newItem(_ff,_102);if(_103&&(_101!=undefined)){this.pasteItem(_103,_100,_100,false,_101);}}}});}else{_103=this.store.newItem(_ff,_102);if(_103&&(_101!=undefined)){this.pasteItem(_103,_100,_100,false,_101);}}},pasteItem:function(_104,_105,_106,_107,_108){var _109=this.store,_10a=this.childrenAttrs[0];if(_105){_e4.forEach(this.childrenAttrs,function(attr){if(_109.containsValue(_105,attr,_104)){if(!_107){var _10b=_e4.filter(_109.getValues(_105,attr),function(x){return x!=_104;});_109.setValues(_105,attr,_10b);}_10a=attr;}});}if(_106){if(typeof _108=="number"){var _10c=_109.getValues(_106,_10a).slice();_10c.splice(_108,0,_104);_109.setValues(_106,_10a,_10c);}else{_109.setValues(_106,_10a,_109.getValues(_106,_10a).concat(_104));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_10d){if(!_10d){return;}this.getChildren(_10d.item,_e7.hitch(this,function(_10e){this.onChildrenChange(_10d.item,_10e);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_10f){if(_e4.indexOf(this.childrenAttrs,_10f)!=-1){this.getChildren(item,_e7.hitch(this,function(_110){this.onChildrenChange(item,_110);}));}else{this.onChange(item);}}});});},"dijit/_editor/plugins/EnterKeyHandling":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range"],function(_111,_112,keys,lang,on,has,win,_113,_114,_115,_116){return _111("dijit._editor.plugins.EnterKeyHandling",_114,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_117){if(this.editor===_117){return;}this.editor=_117;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_117.onLoadDeferred.then(lang.hitch(this,function(d){this.own(on(_117.document,"keydown",lang.hitch(this,function(e){if(e.keyCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){e.stopPropagation();e.preventDefault();}}})));if(has("ie")>=9&&has("ie")<=10){this.own(on(_117.document,"paste",lang.hitch(this,function(e){setTimeout(lang.hitch(this,function(){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();r.move("character",1);r.select();}),0);})));}return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,"handleEnterKey");_117.addKeyHandler(13,0,0,h);_117.addKeyHandler(13,0,1,h);this.own(this.editor.on("KeyPressed",lang.hitch(this,"onKeyPressed")));}}},onKeyPressed:function(){if(this._checkListLater){if(this.editor.selection.isCollapsed()){var _118=this.editor.selection.getAncestorElement("LI");if(!_118){_115.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var _119=this.editor.selection.getAncestorElement(this.blockNodeForEnter);if(_119){_119.innerHTML=this.bogusHtmlContent;if(has("ie")<=9){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_118.parentNode.parentNode.nodeName=="LI"){_118=_118.parentNode.parentNode;}}var fc=_118.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_118.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _11a=_116.create(this.editor.window);_11a.setStart(_118.firstChild,0);var _11b=_116.getSelection(this.editor.window,true);_11b.removeAllRanges();_11b.addRange(_11a);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _11c,_11d,_11e,_11f,_120,_121,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _122=this.editor.selection.getParentElement();var _123=_116.getAncestor(_122,this.blockNodes);if(_123){if(_123.tagName=="LI"){return true;}_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}if(_116.atBeginningOfContainer(_123,_11d.startContainer,_11d.startOffset)){br=doc.createElement("br");_11e=_116.create(this.editor.window);_123.insertBefore(br,_123.firstChild);_11e.setStartAfter(br);_11c.removeAllRanges();_11c.addRange(_11e);}else{if(_116.atEndOfContainer(_123,_11d.startContainer,_11d.startOffset)){_11e=_116.create(this.editor.window);br=doc.createElement("br");_123.appendChild(br);_123.appendChild(doc.createTextNode(" "));_11e.setStart(_123.lastChild,0);_11c.removeAllRanges();_11c.addRange(_11e);}else{rs=_11d.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_11d.startOffset));_120=doc.createTextNode(txt.substring(_11d.startOffset));_121=doc.createElement("br");if(_120.nodeValue==""&&has("webkit")){_120=doc.createTextNode(" ");}_112.place(_11f,rs,"after");_112.place(_121,_11f,"after");_112.place(_120,_121,"after");_112.destroy(rs);_11e=_116.create(this.editor.window);_11e.setStart(_120,0);_11c.removeAllRanges();_11c.addRange(_11e);return false;}return true;}}}else{_11c=_116.getSelection(this.editor.window);if(_11c.rangeCount){_11d=_11c.getRangeAt(0);if(_11d&&_11d.startContainer){if(!_11d.collapsed){_11d.deleteContents();_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}rs=_11d.startContainer;if(rs&&rs.nodeType==3){var _124=_11d.startOffset;if(rs.length<_124){ret=this._adjustNodeAndOffset(rs,_124);rs=ret.node;_124=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_124));_120=doc.createTextNode(txt.substring(_124));_121=doc.createElement("br");if(!_120.length){_120=doc.createTextNode(" ");}if(_11f.length){_112.place(_11f,rs,"after");}else{_11f=rs;}_112.place(_121,_11f,"after");_112.place(_120,_121,"after");_112.destroy(rs);_11e=_116.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);this.editor.selection.collapse(true);}else{var _125;if(_11d.startOffset>=0){_125=rs.childNodes[_11d.startOffset];}var _121=doc.createElement("br");var _120=doc.createTextNode(" ");if(!_125){rs.appendChild(_121);rs.appendChild(_120);}else{_112.place(_121,_125,"before");_112.place(_120,_121,"after");}_11e=_116.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);this.editor.selection.collapse(true);}}}else{_115.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _126=true;_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _127=_116.getBlockAncestor(_11d.endContainer,null,this.editor.editNode);var _128=_127.blockNode;if((this._checkListLater=(_128&&(_128.nodeName=="LI"||_128.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_128;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_128.innerHTML)){_128.innerHTML="";if(has("webkit")){_11e=_116.create(this.editor.window);_11e.setStart(_128,0);_11c.removeAllRanges();_11c.addRange(_11e);}this._checkListLater=false;}return true;}if(!_127.blockNode||_127.blockNode===this.editor.editNode){try{_115.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}_127={blockNode:this.editor.selection.getAncestorElement(this.blockNodeForEnter),blockContainer:this.editor.editNode};if(_127.blockNode){if(_127.blockNode!=this.editor.editNode&&(!(_127.blockNode.textContent||_127.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(_127.blockNode);return false;}}else{_127.blockNode=this.editor.editNode;}_11c=_116.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _129=doc.createElement(this.blockNodeForEnter);_129.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(_127.blockNode);var _12a=_11d.endOffset;var node=_11d.endContainer;if(node.length<_12a){var ret=this._adjustNodeAndOffset(node,_12a);node=ret.node;_12a=ret.offset;}if(_116.atEndOfContainer(_127.blockNode,node,_12a)){if(_127.blockNode===_127.blockContainer){_127.blockNode.appendChild(_129);}else{_112.place(_129,_127.blockNode,"after");}_126=false;_11e=_116.create(this.editor.window);_11e.setStart(_129,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_113.scrollIntoView(_129);}}else{if(_116.atBeginningOfContainer(_127.blockNode,_11d.startContainer,_11d.startOffset)){_112.place(_129,_127.blockNode,_127.blockNode===_127.blockContainer?"first":"before");if(_129.nextSibling&&this.editor.height){_11e=_116.create(this.editor.window);_11e.setStart(_129.nextSibling,0);_11c.removeAllRanges();_11c.addRange(_11e);_113.scrollIntoView(_129.nextSibling);}_126=false;}else{if(_127.blockNode===_127.blockContainer){_127.blockNode.appendChild(_129);}else{_112.place(_129,_127.blockNode,"after");}_126=false;if(_127.blockNode.style){if(_129.style){if(_127.blockNode.style.cssText){_129.style.cssText=_127.blockNode.style.cssText;}}}rs=_11d.startContainer;var _12b;if(rs&&rs.nodeType==3){var _12c,_12d;_12a=_11d.endOffset;if(rs.length<_12a){ret=this._adjustNodeAndOffset(rs,_12a);rs=ret.node;_12a=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_12a));_120=doc.createTextNode(txt.substring(_12a,txt.length));_112.place(_11f,rs,"before");_112.place(_120,rs,"after");_112.destroy(rs);var _12e=_11f.parentNode;while(_12e!==_127.blockNode){var tg=_12e.tagName;var _12f=doc.createElement(tg);if(_12e.style){if(_12f.style){if(_12e.style.cssText){_12f.style.cssText=_12e.style.cssText;}}}if(_12e.tagName==="FONT"){if(_12e.color){_12f.color=_12e.color;}if(_12e.face){_12f.face=_12e.face;}if(_12e.size){_12f.size=_12e.size;}}_12c=_120;while(_12c){_12d=_12c.nextSibling;_12f.appendChild(_12c);_12c=_12d;}_112.place(_12f,_12e,"after");_11f=_12e;_120=_12f;_12e=_12e.parentNode;}_12c=_120;if(_12c.nodeType==1||(_12c.nodeType==3&&_12c.nodeValue)){_129.innerHTML="";}_12b=_12c;while(_12c){_12d=_12c.nextSibling;_129.appendChild(_12c);_12c=_12d;}}_11e=_116.create(this.editor.window);var _130;var _131=_12b;if(this.blockNodeForEnter!=="BR"){while(_131){_130=_131;_12d=_131.firstChild;_131=_12d;}if(_130&&_130.parentNode){_129=_130.parentNode;_11e.setStart(_129,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_113.scrollIntoView(_129);}if(has("mozilla")){this._pressedEnterInBlock=_127.blockNode;}}else{_126=true;}}else{_11e.setStart(_129,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_113.scrollIntoView(_129);}if(has("mozilla")){this._pressedEnterInBlock=_127.blockNode;}}}}return _126;},_adjustNodeAndOffset:function(node,_132){while(node.length<_132&&node.nextSibling&&node.nextSibling.nodeType==3){_132=_132-node.length;node=node.nextSibling;}return {"node":node,"offset":_132};},removeTrailingBr:function(_133){var para=/P|DIV|LI/i.test(_133.tagName)?_133:this.editor.selection.getParentOfType(_133,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_112.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_134,_135,dom,_136,_137,lang,_138,on,_139,_13a,_13b,_13c,_13d,_13e,_13f){return _135("dijit._MenuBase",[_13c,_13f,_13e,_13d],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_137.toggle(this.domNode,"dijitMenuActive",val);_137.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _140=_13b.byNode(node);return node.parentNode==this.containerNode&&_140&&_140.focus;},postCreate:function(){var self=this,_141=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_141,_138.enter),function(){self.onItemHover(_13b.byNode(this));}),on(this.containerNode,on.selector(_141,_138.leave),function(){self.onItemUnhover(_13b.byNode(this));}),on(this.containerNode,on.selector(_141,_13a),function(evt){self.onItemClick(_13b.byNode(this),evt);evt.stopPropagation();}),on(this.containerNode,on.selector(_141,"focusin"),function(){self._onItemFocus(_13b.byNode(this));}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_142,_143){this.inherited(arguments);if(!!item&&(_143==-1||(!!item.popup&&_143==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_144){if(!!item.shortcutKey){return _144==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _145=this._getTopMenu();if(_145&&_145._isMenuBar){_145.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);var _146=/^key/.test(evt._origType||evt.type)||(evt.clientX==0&&evt.clientY==0);this._openItemPopup(item,_146);}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_147,_148){if(_147==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _149=_147.popup;_149.parentMenu=this;this.own(this._mouseoverHandle=on.once(_149.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_147._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_148){self.focusChild(_147);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_148);this.currentPopupItem=_147;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_136.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_14a){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_14a){this.set("selected",null);}}});});},"dijit/tree/ForestStoreModel":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_14b,_14c,_14d,lang,_14e){return _14c("dijit.tree.ForestStoreModel",_14e,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_14f){this.root={store:this,root:true,id:_14f.rootId,label:_14f.rootLabel,children:_14f.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_150,_151,_152){if(_150===this.root){if(this.root.children){_151(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_153){this.root.children=_153;_151(_153);}),onError:_152});}}else{this.inherited(arguments);}},isItem:function(_154){return (_154===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_155){if(_155.identity==this.root.id){var _156=_155.scope||_14d.global;if(_155.onItem){_155.onItem.call(_156,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_157,_158){if(_157===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_159,_15a,_15b,_15c,_15d){if(_15a===this.root){if(!_15c){this.onLeaveRoot(_159);}}this.inherited(arguments,[_159,_15a===this.root?null:_15a,_15b===this.root?null:_15b,_15c,_15d]);if(_15b===this.root){this.onAddToRoot(_159);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _15e=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_15f){this.root.children=_15f;if(_15e.length!=_15f.length||_14b.some(_15e,function(item,idx){return _15f[idx]!=item;})){this.onChildrenChange(this.root,_15f);}})});},onNewItem:function(item,_160){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_14b.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_161,_162,_163){this._requeryTop();this.inherited(arguments);}});});},"dijit/PopupMenuBarItem":function(){define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_164,_165,_166){var _167=_166._MenuBarItemMixin;return _164("dijit.PopupMenuBarItem",[_165,_167],{});});},"dijit/TitlePane":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager","./a11yclick"],function(_168,_169,dom,_16a,_16b,_16c,_16d,has,_16e,keys,_16f,_170,_171,_172,_173){var _174=_169("dijit.TitlePane",[_171,_170,_16f],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_173.defaultDuration,baseClass:"dijitTitlePane",templateString:_172,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.titleNode,false);},postCreate:function(){this.inherited(arguments);if(this.toggleable){this._trackMouseState(this.titleBarNode,this.baseClass+"Title");}var _175=this.hideNode,_176=this.wipeNode;this._wipeIn=_16d.wipeIn({node:_176,duration:this.duration,beforeBegin:function(){_175.style.display="";}});this._wipeOut=_16d.wipeOut({node:_176,duration:this.duration,onEnd:function(){_175.style.display="none";}});},_setOpenAttr:function(open,_177){_168.forEach([this._wipeIn,this._wipeOut],function(_178){if(_178&&_178.status()=="playing"){_178.stop();}});if(_177){var anim=this[open?"_wipeIn":"_wipeOut"];anim.play();}else{this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";}if(this._started){if(open){this._onShow();}else{this.onHide();}}this.containerNode.setAttribute("aria-hidden",open?"false":"true");this.focusNode.setAttribute("aria-pressed",open?"true":"false");this._set("open",open);this._setCss();},_setToggleableAttr:function(_179){this.focusNode.setAttribute("role",_179?"button":"heading");if(_179){this.focusNode.setAttribute("aria-controls",this.id+"_pane");this.focusNode.setAttribute("tabIndex",this.tabIndex);this.focusNode.setAttribute("aria-pressed",this.open);}else{_16a.remove(this.focusNode,"aria-controls");_16a.remove(this.focusNode,"tabIndex");_16a.remove(this.focusNode,"aria-pressed");}this._set("toggleable",_179);this._setCss();},_setContentAttr:function(_17a){if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){this.inherited(arguments);}else{if(this._wipeIn&&this._wipeIn.status()=="playing"){this._wipeIn.stop();}_16c.setMarginBox(this.wipeNode,{h:_16c.getMarginBox(this.wipeNode).h});this.inherited(arguments);if(this._wipeIn){this._wipeIn.play();}else{this.hideNode.style.display="";}}},toggle:function(){this._setOpenAttr(!this.open,true);},_setCss:function(){var node=this.titleBarNode||this.focusNode;var _17b=this._titleBarClass;this._titleBarClass=this.baseClass+"Title"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");_16b.replace(node,this._titleBarClass,_17b||"");_16b.replace(node,this._titleBarClass.replace("TitlePaneTitle",""),(_17b||"").replace("TitlePaneTitle",""));this.arrowNodeInner.innerHTML=this.open?"-":"+";},_onTitleKey:function(e){if(e.keyCode==keys.DOWN_ARROW&&this.open){this.containerNode.focus();e.preventDefault();}},_onTitleClick:function(){if(this.toggleable){this.toggle();}},setTitle:function(_17c){_16e.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");this.set("title",_17c);}});if(has("dojo-bidi")){_174.extend({_setTitleAttr:function(_17d){this._set("title",_17d);this.titleNode.innerHTML=_17d;this.applyTextDir(this.titleNode);},_setTooltipAttr:function(_17e){this._set("tooltip",_17e);if(this.textDir){_17e=this.enforceTextDirWithUcc(null,_17e);}_16a.set(this.focusNode,"title",_17e);},_setTextDirAttr:function(_17f){if(this._created&&this.textDir!=_17f){this._set("textDir",_17f);this.set("title",this.title);this.set("tooltip",this.tooltip);}}});}return _174;});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_180,_181,_182,has,i18n){var _183=_181("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_184){this._set("value",_184);this.onChange(_184);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_185){var _186=this._createMenuItem();var _187=_185(item);if(_187.html){_186.innerHTML=_187.label;}else{_186.appendChild(_186.ownerDocument.createTextNode(_187.label));}if(_186.innerHTML==""){_186.innerHTML="&#160;";}return _186;},createOptions:function(_188,_189,_18a){this.items=_188;this.previousButton.style.display=(_189.start==0)?"none":"";_182.set(this.previousButton,"id",this.id+"_prev");_180.forEach(_188,function(item,i){var _18b=this._createOption(item,_18a);_18b.setAttribute("item",i);_182.set(_18b,"id",this.id+i);this.nextButton.parentNode.insertBefore(_18b,this.nextButton);},this);var _18c=false;if(_188.total&&!_188.total.then&&_188.total!=-1){if((_189.start+_189.count)<_188.total){_18c=true;}else{if((_189.start+_189.count)>_188.total&&_189.count==_188.length){_18c=true;}}}else{if(_189.count==_188.length){_18c=true;}}this.nextButton.style.display=_18c?"":"none";_182.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _18d=this.containerNode;while(_18d.childNodes.length>2){_18d.removeChild(_18d.childNodes[_18d.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_183=_181("dijit.form._ComboBoxMenuMixin",_183,{_createOption:function(){var _18e=this.inherited(arguments);this.applyTextDir(_18e);return _18e;}});}return _183;});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_18f,keys,lang,_190,_191,when,_192){return _18f("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},list:"",_setListAttr:function(list){this._set("list",list);},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_193){return new RegExp("^"+_193.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_194,star,_195){return star?".*":_195?".":_194?_194:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;if("type" in evt&&evt.type.substring(0,3)=="key"&&(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT)){return;}var _196=false;this._prev_key_backspace=false;switch(key){case keys.DELETE:case keys.BACKSPACE:this._prev_key_backspace=true;this._maskValidSubsetError=true;_196=true;break;default:_196=typeof key=="string"||key==229;}if(_196){if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value);},_startSearch:function(text){this._abortQuery();var _197=this,_190=lang.clone(this.query),_198={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_191.substitute(this.queryExpr,[text.replace(/([\\\*\?])/g,"\\$1")]),q,_199=function(){var _19a=_197._fetchHandle=_197.store.query(_190,_198);if(_197.disabled||_197.readOnly||(q!==_197._lastQuery)){return;}when(_19a,function(res){_197._fetchHandle=null;if(!_197.disabled&&!_197.readOnly&&(q===_197._lastQuery)){when(_19a.total,function(_19b){res.total=_19b;var _19c=_197.pageSize;if(isNaN(_19c)||_19c>res.total){_19c=res.total;}res.nextPage=function(_19d){_198.direction=_19d=_19d!==false;_198.count=_19c;if(_19d){_198.start+=res.length;if(_198.start>=res.total){_198.count=0;}}else{_198.start-=_19c;if(_198.start<0){_198.count=Math.max(_19c+_198.start,0);_198.start=0;}}if(_198.count<=0){res.length=0;_197.onSearch(res,_190,_198);}else{_199();}};_197.onSearch(res,_190,_198);});}},function(err){_197._fetchHandle=null;if(!_197._cancelingQuery){console.error(_197.declaredClass+" "+err.toString());}});};lang.mixin(_198,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_190[this.searchAttr]=q;this._queryDeferHandle=this.defer(_199,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_192.byId(list);}}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_19e,_19f,_1a0,_1a1){return _19e("dijit.form.ToggleButton",[_1a0,_1a1],{baseClass:"dijitToggleButton",setChecked:function(_1a2){_19f.deprecated("setChecked("+_1a2+") is deprecated. Use set('checked',"+_1a2+") instead.","","2.0");this.set("checked",_1a2);}});});},"dijit/form/NumberSpinner":function(){define(["dojo/_base/declare","dojo/keys","./_Spinner","./NumberTextBox"],function(_1a3,keys,_1a4,_1a5){return _1a3("dijit.form.NumberSpinner",[_1a4,_1a5.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,_1a6){var tc=this.constraints,v=isNaN(val),_1a7=!isNaN(tc.max),_1a8=!isNaN(tc.min);if(v&&_1a6!=0){val=(_1a6>0)?_1a8?tc.min:_1a7?tc.max:0:_1a7?this.constraints.max:_1a8?tc.min:0;}var _1a9=val+_1a6;if(v||isNaN(_1a9)){return val;}if(_1a7&&(_1a9>tc.max)){_1a9=tc.max;}if(_1a8&&(_1a9<tc.min)){_1a9=tc.min;}return _1a9;},_onKeyDown:function(e){if(this.disabled||this.readOnly){return;}if((e.keyCode==keys.HOME||e.keyCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){var _1aa=this.constraints[(e.keyCode==keys.HOME?"min":"max")];if(typeof _1aa=="number"){this._setValueAttr(_1aa,false);}e.stopPropagation();e.preventDefault();}}});});},"dijit/form/Textarea":function(){define(["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_1ab,_1ac,_1ad,_1ae){return _1ab("dijit.form.Textarea",[_1ae,_1ad],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){this.inherited(arguments);_1ac.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});}});});},"dijit/form/DateTextBox":function(){define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_1af,_1b0,_1b1){return _1af("dijit.form.DateTextBox",_1b1,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_1b0,_selector:"date",maxHeight:Infinity,value:new Date("")});});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_1b2,_1b3,_1b4,fx,dom,_1b5,_1b6,_1b7,_1b8,keys,lang,has,_1b9,_1ba,_1bb,_1bc,_1bd,_1be,_1bf,_1c0,_1c1,_1c2,_1c3){var _1c4=_1b4("dijit.layout._AccordionButton",[_1bd,_1bf,_1c0],{templateString:_1c3,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _1c5=this.id.replace(" ","_");_1b5.set(this.titleTextNode,"id",_1c5+"_title");this.focusNode.setAttribute("aria-labelledby",_1b5.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _1b8.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _1c6=this.getParent();_1c6.selectChild(this.contentWidget,true);_1ba.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_1c7){this._set("selected",_1c7);this.focusNode.setAttribute("aria-expanded",_1c7?"true":"false");this.focusNode.setAttribute("aria-selected",_1c7?"true":"false");this.focusNode.setAttribute("tabIndex",_1c7?"0":"-1");}});if(has("dojo-bidi")){_1c4.extend({_setLabelAttr:function(_1c8){this._set("label",_1c8);_1b5.set(this.titleTextNode,"innerHTML",_1c8);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_1c9){this._set("title",_1c9);_1b5.set(this.titleTextNode,"title",_1c9);this.applyTextDir(this.titleTextNode);}});}var _1ca=_1b4("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_1bd,_1c0],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_1b7.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _1cb=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_1cb._buttonWidget=(new cls({contentWidget:_1cb,label:_1cb.title,title:_1cb.tooltip,dir:_1cb.dir,lang:_1cb.lang,textDir:_1cb.textDir||this.textDir,iconClass:_1cb.iconClass,id:_1cb.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_1b7.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_1b7.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _1cc=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_1cd,_1ce){_1cc.set("label",_1ce);})),cw.watch("tooltip",lang.hitch(this,function(name,_1cf,_1d0){_1cc.set("title",_1d0);})),cw.watch("iconClass",lang.hitch(this,function(name,_1d1,_1d2){_1cc.set("iconClass",_1d2);}))];},_setSelectedAttr:function(_1d3){this._set("selected",_1d3);this.button.set("selected",_1d3);if(_1d3){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_1b3.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_1d4){this.contentWidget.destroyRecursive(_1d4);}});if(has("dojo-bidi")){_1ca=_1b4("dijit.layout._AccordionInnerContainer",_1ca,{postCreate:function(){this.inherited(arguments);var _1d5=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_1d6,_1d7){_1d5.set("textDir",_1d7);}));}});}var _1d8=_1b4("dijit.layout.AccordionContainer",_1c1,{duration:_1bb.defaultDuration,buttonWidget:_1c4,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _1d9=this.selectedChildWidget;if(!_1d9){return;}var _1da=_1d9._wrapperWidget.domNode,_1db=_1b8.getMarginExtents(_1da),_1dc=_1b8.getPadBorderExtents(_1da),_1dd=_1d9._wrapperWidget.containerNode,_1de=_1b8.getMarginExtents(_1dd),_1df=_1b8.getPadBorderExtents(_1dd),_1e0=this._contentBox;var _1e1=0;_1b3.forEach(this.getChildren(),function(_1e2){if(_1e2!=_1d9){_1e1+=_1b8.getMarginSize(_1e2._wrapperWidget.domNode).h;}});this._verticalSpace=_1e0.h-_1e1-_1db.h-_1dc.h-_1de.h-_1df.h-_1d9._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_1db.w-_1dc.w-_1de.w-_1df.w};if(_1d9){_1d9.resize(this._containerContentBox);}},_setupChild:function(_1e3){_1e3._wrapperWidget=_1ca({contentWidget:_1e3,buttonWidget:this.buttonWidget,id:_1e3.id+"_wrapper",dir:_1e3.dir,lang:_1e3.lang,textDir:_1e3.textDir||this.textDir,parent:this});this.inherited(arguments);_1b7.place(_1e3.domNode,_1e3._wrapper,"replace");},removeChild:function(_1e4){if(_1e4._wrapperWidget){_1b7.place(_1e4.domNode,_1e4._wrapperWidget.domNode,"after");_1e4._wrapperWidget.destroy();delete _1e4._wrapperWidget;}_1b6.remove(_1e4.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _1b3.map(this.inherited(arguments),function(_1e5){return _1e5.declaredClass=="dijit.layout._AccordionInnerContainer"?_1e5.contentWidget:_1e5;},this);},destroy:function(){if(this._animation){this._animation.stop();}_1b3.forEach(this.getChildren(),function(_1e6){if(_1e6._wrapperWidget){_1e6._wrapperWidget.destroy();}else{_1e6.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_1e7){_1e7._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_1e8){_1e8._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_1e9,_1ea,_1eb){if(has("ie")<8){_1eb=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_1e9){_1e9._wrapperWidget.set("selected",true);var d=this._showChild(_1e9);if(this.doLayout&&_1e9.resize){_1e9.resize(this._containerContentBox);}}if(_1ea){_1ea._wrapperWidget.set("selected",false);if(!_1eb){this._hideChild(_1ea);}}if(_1eb){var _1ec=_1e9._wrapperWidget.containerNode,_1ed=_1ea._wrapperWidget.containerNode;var _1ee=_1e9._wrapperWidget.containerNode,_1ef=_1b8.getMarginExtents(_1ee),_1f0=_1b8.getPadBorderExtents(_1ee),_1f1=_1ef.h+_1f0.h;_1ed.style.height=(self._verticalSpace-_1f1)+"px";this._animation=new fx.Animation({node:_1ec,duration:this.duration,curve:[1,this._verticalSpace-_1f1-1],onAnimate:function(_1f2){_1f2=Math.floor(_1f2);_1ec.style.height=_1f2+"px";_1ed.style.height=(self._verticalSpace-_1f1-_1f2)+"px";},onEnd:function(){delete self._animation;_1ec.style.height="auto";_1ea._wrapperWidget.containerNode.style.display="none";_1ed.style.height="auto";self._hideChild(_1ea);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_1f3){if(this.disabled||e.altKey||!(_1f3||e.ctrlKey)){return;}var c=e.keyCode;if((_1f3&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_1f3&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_1bc(0,function(){var _1f4=["dijit/layout/AccordionPane"];_1b2(_1f4);});}_1d8._InnerContainer=_1ca;_1d8._Button=_1c4;return _1d8;});},"dijit/form/ComboButton":function(){define(["dojo/_base/declare","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html","../a11yclick"],function(_1f5,keys,_1f6,_1f7,_1f8){return _1f5("dijit.form.ComboButton",_1f7,{templateString:_1f8,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_1f6.focus(this._popupStateNode);evt.stopPropagation();evt.preventDefault();}},_onArrowKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_1f6.focus(this.titleNode);evt.stopPropagation();evt.preventDefault();}},focus:function(_1f9){if(!this.disabled){_1f6.focus(_1f9=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/layout/SplitContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","../registry","../_WidgetBase","./_LayoutWidget"],function(_1fa,_1fb,_1fc,dom,_1fd,_1fe,_1ff,_200,_201,_202,lang,on,has,_203,_204,_205){var _206=_1fc("dijit.layout.SplitContainer",_205,{constructor:function(){_202.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){this.inherited("postMixInProperties",arguments);this.isHorizontal=(this.orientation=="horizontal");},postCreate:function(){this.inherited(arguments);this.sizers=[];if(has("mozilla")){this.domNode.style.overflow="-moz-scrollbars-none";}if(typeof this.sizerWidth=="object"){try{this.sizerWidth=parseInt(this.sizerWidth.toString());}catch(e){this.sizerWidth=7;}}var _207=this.ownerDocument.createElement("div");this.virtualSizer=_207;_207.style.position="relative";_207.style.zIndex=10;_207.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";this.domNode.appendChild(_207);dom.setSelectable(_207,false);},destroy:function(){delete this.virtualSizer;if(this._ownconnects){var h;while(h=this._ownconnects.pop()){h.remove();}}this.inherited(arguments);},startup:function(){if(this._started){return;}_1fa.forEach(this.getChildren(),function(_208,i,_209){this._setupChild(_208);if(i<_209.length-1){this._addSizer();}},this);if(this.persist){this._restoreState();}this.inherited(arguments);},_setupChild:function(_20a){this.inherited(arguments);_20a.domNode.style.position="absolute";_1fd.add(_20a.domNode,"dijitSplitPane");},_onSizerMouseDown:function(e){if(e.target.id){for(var i=0;i<this.sizers.length;i++){if(this.sizers[i].id==e.target.id){break;}}if(i<this.sizers.length){this.beginSizing(e,i);}}},_addSizer:function(_20b){_20b=_20b===undefined?this.sizers.length:_20b;var _20c=this.ownerDocument.createElement("div");_20c.id=_203.getUniqueId("dijit_layout_SplitterContainer_Splitter");this.sizers.splice(_20b,0,_20c);this.domNode.appendChild(_20c);_20c.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";var _20d=this.ownerDocument.createElement("div");_20d.className="thumb";_20c.appendChild(_20d);this.connect(_20c,"onmousedown","_onSizerMouseDown");dom.setSelectable(_20c,false);},removeChild:function(_20e){if(this.sizers.length){var i=_1fa.indexOf(this.getChildren(),_20e);if(i!=-1){if(i==this.sizers.length){i--;}_1fe.destroy(this.sizers[i]);this.sizers.splice(i,1);}}this.inherited(arguments);if(this._started){this.layout();}},addChild:function(_20f,_210){if(typeof _210=="undefined"||_210=="last"){_210=this.getChildren().length;}this.inherited(arguments,[_20f,_210]);if(this._started){var _211=this.getChildren();if(_211.length>1){this._addSizer(_210);}this.layout();}},layout:function(){this.paneWidth=this._contentBox.w;this.paneHeight=this._contentBox.h;var _212=this.getChildren();if(!_212.length){return;}var _213=this.isHorizontal?this.paneWidth:this.paneHeight;if(_212.length>1){_213-=this.sizerWidth*(_212.length-1);}var _214=0;_1fa.forEach(_212,function(_215){_214+=_215.sizeShare;});var _216=_213/_214;var _217=0;_1fa.forEach(_212.slice(0,_212.length-1),function(_218){var size=Math.round(_216*_218.sizeShare);_218.sizeActual=size;_217+=size;});_212[_212.length-1].sizeActual=_213-_217;this._checkSizes();var pos=0;var size=_212[0].sizeActual;this._movePanel(_212[0],pos,size);_212[0].position=pos;pos+=size;if(!this.sizers){return;}_1fa.some(_212.slice(1),function(_219,i){if(!this.sizers[i]){return true;}this._moveSlider(this.sizers[i],pos,this.sizerWidth);this.sizers[i].position=pos;pos+=this.sizerWidth;size=_219.sizeActual;this._movePanel(_219,pos,size);_219.position=pos;pos+=size;},this);},_movePanel:function(_21a,pos,size){var box;if(this.isHorizontal){_21a.domNode.style.left=pos+"px";_21a.domNode.style.top=0;box={w:size,h:this.paneHeight};if(_21a.resize){_21a.resize(box);}else{_1ff.setMarginBox(_21a.domNode,box);}}else{_21a.domNode.style.left=0;_21a.domNode.style.top=pos+"px";box={w:this.paneWidth,h:size};if(_21a.resize){_21a.resize(box);}else{_1ff.setMarginBox(_21a.domNode,box);}}},_moveSlider:function(_21b,pos,size){if(this.isHorizontal){_21b.style.left=pos+"px";_21b.style.top=0;_1ff.setMarginBox(_21b,{w:size,h:this.paneHeight});}else{_21b.style.left=0;_21b.style.top=pos+"px";_1ff.setMarginBox(_21b,{w:this.paneWidth,h:size});}},_growPane:function(_21c,pane){if(_21c>0){if(pane.sizeActual>pane.sizeMin){if((pane.sizeActual-pane.sizeMin)>_21c){pane.sizeActual=pane.sizeActual-_21c;_21c=0;}else{_21c-=pane.sizeActual-pane.sizeMin;pane.sizeActual=pane.sizeMin;}}}return _21c;},_checkSizes:function(){var _21d=0;var _21e=0;var _21f=this.getChildren();_1fa.forEach(_21f,function(_220){_21e+=_220.sizeActual;_21d+=_220.sizeMin;});if(_21d<=_21e){var _221=0;_1fa.forEach(_21f,function(_222){if(_222.sizeActual<_222.sizeMin){_221+=_222.sizeMin-_222.sizeActual;_222.sizeActual=_222.sizeMin;}});if(_221>0){var list=this.isDraggingLeft?_21f.reverse():_21f;_1fa.forEach(list,function(_223){_221=this._growPane(_221,_223);},this);}}else{_1fa.forEach(_21f,function(_224){_224.sizeActual=Math.round(_21e*(_224.sizeMin/_21d));});}},beginSizing:function(e,i){var _225=this.getChildren();this.paneBefore=_225[i];this.paneAfter=_225[i+1];this.paneBefore.sizeBeforeDrag=this.paneBefore.sizeActual;this.paneAfter.sizeBeforeDrag=this.paneAfter.sizeActual;this.paneAfter.positionBeforeDrag=this.paneAfter.position;this.isSizing=true;this.sizingSplitter=this.sizers[i];this.sizingSplitter.positionBeforeDrag=_200.get(this.sizingSplitter,(this.isHorizontal?"left":"top"));if(!this.cover){this.cover=_1fe.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);}else{this.cover.style.zIndex=5;}this.sizingSplitter.style.zIndex=6;this.startPoint=this.lastPoint=(this.isHorizontal?e.pageX:e.pageY);this.maxDelta=this.paneAfter.sizeActual-this.paneAfter.sizeMin;this.minDelta=-1*(this.paneBefore.sizeActual-this.paneBefore.sizeMin);if(!this.activeSizing){this._showSizingLine();}this._ownconnects=[on(this.ownerDocument.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(this.ownerDocument.documentElement,"mouseup",lang.hitch(this,"endSizing"))];_201.stop(e);},changeSizing:function(e){if(!this.isSizing){return;}this.lastPoint=this.isHorizontal?e.pageX:e.pageY;var _226=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);if(this.activeSizing){this._updateSize(_226);}else{this._moveSizingLine(_226);}_201.stop(e);},endSizing:function(){if(!this.isSizing){return;}if(this.cover){this.cover.style.zIndex=-1;}if(!this.activeSizing){this._hideSizingLine();}var _227=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);this._updateSize(_227);this.isSizing=false;if(this.persist){this._saveState(this);}var h;while(h=this._ownconnects.pop()){h.remove();}},_updateSize:function(_228){this.paneBefore.sizeActual=this.paneBefore.sizeBeforeDrag+_228;this.paneAfter.position=this.paneAfter.positionBeforeDrag+_228;this.paneAfter.sizeActual=this.paneAfter.sizeBeforeDrag-_228;_1fa.forEach(this.getChildren(),function(_229){_229.sizeShare=_229.sizeActual;});if(this._started){this.layout();}},_showSizingLine:function(){this._moveSizingLine(0);_1ff.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});this.virtualSizer.style.display="block";},_hideSizingLine:function(){this.virtualSizer.style.display="none";},_moveSizingLine:function(_22a){var pos=_22a+this.sizingSplitter.positionBeforeDrag;_200.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");},_getCookieName:function(i){return this.id+"_"+i;},_restoreState:function(){_1fa.forEach(this.getChildren(),function(_22b,i){var _22c=this._getCookieName(i);var _22d=_1fb(_22c);if(_22d){var pos=parseInt(_22d);if(typeof pos=="number"){_22b.sizeShare=pos;}}},this);},_saveState:function(){if(!this.persist){return;}_1fa.forEach(this.getChildren(),function(_22e,i){_1fb(this._getCookieName(i),_22e.sizeShare,{expires:365});},this);}});_206.ChildWidgetProperties={sizeMin:10,sizeShare:10};lang.extend(_204,_206.ChildWidgetProperties);return _206;});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_22f,_230,_231,keys,lang,_232,_233,has,_234,_235,_236){var _237=_230("dijit.form._AutoCompleterMixin",_236,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_238){var pos=0;if(typeof (_238.selectionStart)=="number"){pos=_238.selectionStart;}else{if(has("ie")){var tr=_238.ownerDocument.selection.createRange().duplicate();var ntr=_238.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_239,_23a){_23a=parseInt(_23a);_235.selectInputText(_239,_23a,_23a);},_setDisabledAttr:function(_23b){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_23b?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _23c=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_23c=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_23c);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_23c){if(_23c==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_23c==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _23d=this.get("displayedValue");if(pw&&(_23d==pw._messages["previousMessage"]||_23d==pw._messages["nextMessage"])){break;}if(_23c){this._selectOption(_23c);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_235.selectInputText(fn,fn.value.length);var _23e=this.ignoreCase?"toLowerCase":"substr";if(text[_23e](0).indexOf(this.focusNode.value[_23e](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_235.selectInputText(fn,cpos);}}else{fn.value=text;_235.selectInputText(fn);}},_openResultList:function(_23f,_240,_241){var _242=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_23f.length&&_241.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_243){_23f.nextPage(_243!==-1);this.focus();});this.dropDown.createOptions(_23f,_241,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _241){if(_241.direction){this.dropDown.highlightFirstOption();}else{if(!_241.direction){this.dropDown.highlightLastOption();}}if(_242){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_240[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _244=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_244==pw._messages["previousMessage"]||_244==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_244);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_245,_246){var _247="";if(item){if(!_246){_246=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_247=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_246;}this.set("value",_247,_245,_246,item);},_announceOption:function(node){if(!node){return;}var _248;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_248=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_248=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_248);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_231.get(node,"id"));this._autoCompleteText(_248);},_selectOption:function(_249){this.closeDropDown();if(_249){this._announceOption(_249);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _24a=this.id+"_popup",_24b=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _24b({onChange:lang.hitch(this,this._selectOption),id:_24a,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store&&this.srcNodeRef){var _24c=this.srcNodeRef;this.store=new _234({},_24c);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _24d=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_24d):item[_24d];}}}},postCreate:function(){var _24e=_232("label[for=\""+this.id+"\"]");if(_24e.length){if(!_24e[0].id){_24e[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_24e[0].id);}this.inherited(arguments);_22f.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _24f=this.labelFunc(item,this.store),_250=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_24f=this.doHighlight(_24f,this._lastInput);_250="html";}return {html:_250=="html",label:_24f};},doHighlight:function(_251,find){var _252=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_233.escapeString(find);return this._escapeHtml(_251.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_252),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_253){return (_253._oldAPI?_253.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_254,_255,_256,item){this._set("item",item||null);if(_254==null){_254="";}this.inherited(arguments);}});if(has("dojo-bidi")){_237.extend({_setTextDirAttr:function(_257){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_257);}}});}return _237;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_258,has,_259,_25a){return _258("dijit.form.MappedTextBox",_25a,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_259.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_25b,_25c,_25d,lang,_25e,_25f,_260,_261,_262){return _25b("dijit.form.ComboBoxMixin",[_261,_25f],{dropDownClass:_260,hasDownArrow:true,templateString:_262,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_263){if(!_263.get){lang.mixin(_263,{_oldAPI:true,get:function(id){var _264=new _25c();this.fetchItemByIdentity({identity:id,onItem:function(_265){_264.resolve(_265);},onError:function(_266){_264.reject(_266);}});return _264.promise;},query:function(_267,_268){var _269=new _25c(function(){_26a.abort&&_26a.abort();});_269.total=new _25c();var _26a=this.fetch(lang.mixin({query:_267,onBegin:function(_26b){_269.total.resolve(_26b);},onComplete:function(_26c){_269.resolve(_26c);},onError:function(_26d){_269.reject(_26d);}},_268));return _25e(_269);}});}this._set("store",_263);},postMixInProperties:function(){var _26e=this.params.store||this.store;if(_26e){this._setStoreAttr(_26e);}this.inherited(arguments);if(!this.params.store&&this.store&&!this.store._oldAPI){var _26f=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_25d.deprecated(_26f+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_25d.deprecated(_26f+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_25d.deprecated(_26f+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_270){new _270({objectStore:this}).fetch(args);}));}});}}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_271,_272,dom,has,keys,lang,on,_273){var _274=_272("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_275,_276,_277){var _278;if(_275!==undefined){_278=this.filter(_275);if(typeof _277!="string"){if(_278!==null&&((typeof _278!="number")||!isNaN(_278))){_277=this.filter(this.format(_278,this.constraints));}else{_277="";}if(this.compare(_278,this.filter(this.parse(_277,this.constraints)))!=0){_277=null;}}}if(_277!=null&&((typeof _277)!="number"||!isNaN(_277))&&this.textbox.value!=_277){this.textbox.value=_277;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_278,_276]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_279){if(_279==null){_279="";}else{if(typeof _279!="string"){_279=String(_279);}}this.textbox.value=_279;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_27a){return _27a==null?"":(_27a.toString?_27a.toString():_27a);},parse:function(_27b){return _27b;},_refreshState:function(){},onInput:function(){},__skipInputEvent:false,_onInput:function(evt){this._processInput(evt);if(this.intermediateChanges){this.defer(function(){this._handleOnChange(this.get("value"),false);});}},_processInput:function(evt){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);function _27c(e){var _27d;if(e.type=="keydown"){_27d=e.keyCode;switch(_27d){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_27d){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_27d>=65&&_27d<=90)||(_27d>=48&&_27d<=57)||_27d==keys.SPACE){return;}var _27e=false;for(var i in keys){if(keys[i]===e.keyCode){_27e=true;break;}}if(!_27e){return;}}}_27d=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_27d){_27d=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_27d){_27d=229;}if(e.type=="keypress"){if(typeof _27d!="string"){return;}if((_27d>="a"&&_27d<="z")||(_27d>="A"&&_27d<="Z")||(_27d>="0"&&_27d<="9")||(_27d===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}if(e.type=="input"){if(this.__skipInputEvent){this.__skipInputEvent=false;return;}}else{this.__skipInputEvent=true;}var faux={faux:true},attr;for(attr in e){if(!/^(layer[XY]|returnValue|keyLocation)$/.test(attr)){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_27d,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}this.defer(function(){this._onInput(faux);});};this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_27c)),on(this.domNode,"keypress",function(e){e.stopPropagation();}));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_274.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_274=_272("dijit.form._TextBoxMixin",_274,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_274._setSelectionRange=_273._setSelectionRange=function(_27f,_280,stop){if(_27f.setSelectionRange){_27f.setSelectionRange(_280,stop);}};_274.selectInputText=_273.selectInputText=function(_281,_282,stop){_281=dom.byId(_281);if(isNaN(_282)){_282=0;}if(isNaN(stop)){stop=_281.value?_281.value.length:0;}try{_281.focus();_274._setSelectionRange(_281,_282,stop);}catch(e){}};return _274;});},"dijit/form/SimpleTextarea":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_283,_284,has,_285){return _283("dijit.form.SimpleTextarea",_285,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_284.add(this.textbox,"dijitTextAreaCols");}},filter:function(_286){if(_286){_286=_286.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _287=parseInt(this.maxLength);var _288=this.textbox.value.replace(/\r/g,"");var _289=_288.length-_287;if(_289>0){var _28a=this.textbox;if(_28a.selectionStart){var pos=_28a.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_288.substring(0,pos-_289-cr)+_288.substring(pos-cr);_28a.setSelectionRange(pos-_289,pos-_289);}else{if(this.ownerDocument.selection){_28a.focus();var _28b=this.ownerDocument.selection.createRange();_28b.moveStart("character",-_289);_28b.text="";_28b.select();}}}}this.inherited(arguments);}});});},"dijit/PopupMenuItem":function(){define(["dojo/_base/declare","dojo/dom-style","dojo/_base/lang","dojo/query","./popup","./registry","./MenuItem","./hccss"],function(_28c,_28d,lang,_28e,pm,_28f,_290){return _28c("dijit.PopupMenuItem",_290,{baseClass:"dijitMenuItem dijitPopupMenuItem",_fillContent:function(){if(this.srcNodeRef){var _291=_28e("*",this.srcNodeRef);this.inherited(arguments,[_291[0]]);this.dropDownContainer=this.srcNodeRef;}},_openPopup:function(_292,_293){var _294=this.popup;pm.open(lang.delegate(_292,{popup:this.popup,around:this.domNode}));if(_293&&_294.focus){_294.focus();}},_closePopup:function(){pm.close(this.popup);this.popup.parentMenu=null;},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=_28e("[widgetId]",this.dropDownContainer)[0];this.popup=_28f.byNode(node);}this.ownerDocumentBody.appendChild(this.popup.domNode);this.popup.domNode.setAttribute("aria-labelledby",this.containerNode.id);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_28d.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_295){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_295);}delete this.popup;}this.inherited(arguments);}});});},"dijit/_TimePicker":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","dojo/on","./_WidgetBase","./form/_ListMouseMixin"],function(_296,_297,_298,_299,_29a,_29b,_29c,_29d,keys,lang,has,_29e,_29f,on,_2a0,_2a1){var _2a2=_29a("dijit._TimePicker",[_2a0,_2a1],{baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_299.toISOString,buildRendering:function(){this.inherited(arguments);this.containerNode=this.domNode;this.timeMenu=this.domNode;},setValue:function(_2a3){_29d.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_2a3);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_2a4,_2a5,_2a6,_2a7){var _2a8=[];for(var i=0;i<this._maxIncrement;i++){var n=this._createOption(i);if(n){_2a8.push(n);}}return _2a8;},_showText:function(){var _2a9=_299.fromISOString;this.domNode.innerHTML="";this._clickableIncrementDate=_2a9(this.clickableIncrement);this._visibleIncrementDate=_2a9(this.visibleIncrement);var _2aa=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_2ab=_2aa(this._clickableIncrementDate),_2ac=_2aa(this._visibleIncrementDate),time=(this.value||this.currentFocus).getTime();this._refDate=_2a9("T00:00:00");this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._visibleIncrement=_2ac/_2ab;this._maxIncrement=(60*60*24)/_2ab;var _2ad=this._getFilteredNodes();_296.forEach(_2ad,function(n){this.domNode.appendChild(n);},this);if(!_2ad.length&&this.filterString){this.filterString="";this._showText();}},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_2ae){for(var key in {clickableIncrement:1,visibleIncrement:1}){if(key in _2ae){this[key]=_2ae[key];}}if(!_2ae.locale){_2ae.locale=this.lang;}},_createOption:function(_2af){var date=new Date(this._refDate);var _2b0=this._clickableIncrementDate;date.setHours(date.getHours()+_2b0.getHours()*_2af,date.getMinutes()+_2b0.getMinutes()*_2af,date.getSeconds()+_2b0.getSeconds()*_2af);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _2b1=_298.format(date,this.constraints);if(this.filterString&&_2b1.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=this.ownerDocument.createElement("div");div.className=this.baseClass+"Item";div.date=date;div.idx=_2af;_29c.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_2b1},div);if(_2af%this._visibleIncrement<1&&_2af%this._visibleIncrement>-1){_29b.add(div,this.baseClass+"Marker");}else{if(!(_2af%this._clickableIncrement)){_29b.add(div,this.baseClass+"Tick");}}if(this.isDisabledDate(date)){_29b.add(div,this.baseClass+"ItemDisabled");}if(this.value&&!_297.compare(this.value,date,this.constraints.selector)){div.selected=true;_29b.add(div,this.baseClass+"ItemSelected");this._selectedDiv=div;if(_29b.contains(div,this.baseClass+"Marker")){_29b.add(div,this.baseClass+"MarkerSelected");}else{_29b.add(div,this.baseClass+"TickSelected");}this._highlightOption(div,true);}return div;},onOpen:function(){this.inherited(arguments);this.set("selected",this._selectedDiv);},_onOptionSelected:function(tgt){var _2b2=tgt.target.date||tgt.target.parentNode.date;if(!_2b2||this.isDisabledDate(_2b2)){return;}this._highlighted_option=null;this.set("value",_2b2);this.onChange(_2b2);},onChange:function(){},_highlightOption:function(node,_2b3){if(!node){return;}if(_2b3){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_29b.toggle(node,this.baseClass+"ItemHover",_2b3);if(_29b.contains(node,this.baseClass+"Marker")){_29b.toggle(node,this.baseClass+"MarkerHover",_2b3);}else{_29b.toggle(node,this.baseClass+"TickHover",_2b3);}},handleKey:function(e){if(e.keyCode==keys.DOWN_ARROW){this.selectNextNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.UP_ARROW){this.selectPreviousNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){if(!this._keyboardSelected&&e.keyCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option});}return e.keyCode===keys.TAB;}}}return undefined;},onHover:function(node){this._highlightOption(node,true);},onUnhover:function(node){this._highlightOption(node,false);},onSelect:function(node){this._highlightOption(node,true);},onDeselect:function(node){this._highlightOption(node,false);},onClick:function(node){this._onOptionSelected({target:node});}});return _2a2;});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_2b4,_2b5,_2b6){return _2b4("dijit.form.RadioButton",[_2b5,_2b6],{baseClass:"dijitRadio"});});},"dijit/InlineEditBox":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/when","./a11yclick","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_2b7,_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be,i18n,_2bf,keys,lang,on,has,when,_2c0,fm,_2c1,_2c2,_2c3,_2c4,_2c5,_2c6,_2c7,_2c8){var _2c9=_2ba("dijit._InlineEditor",[_2c1,_2c2,_2c3],{templateString:_2c8,contextRequire:_2b7,postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit","common",this.lang);_2b8.forEach(["buttonSave","buttonCancel"],function(prop){if(!this[prop]){this[prop]=this.messages[prop];}},this);},buildRendering:function(){this.inherited(arguments);var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_2b7(this.editor)):this.editor;var _2ca=this.sourceStyle,_2cb="line-height:"+_2ca.lineHeight+";",_2cc=_2be.getComputedStyle(this.domNode);_2b8.forEach(["Weight","Family","Size","Style"],function(prop){var _2cd=_2ca["font"+prop],_2ce=_2cc["font"+prop];if(_2ce!=_2cd){_2cb+="font-"+prop+":"+_2ca["font"+prop]+";";}},this);_2b8.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){this.domNode.style[prop]=_2ca[prop];},this);var _2cf=this.inlineEditBox.width;if(_2cf=="100%"){_2cb+="width:100%;";this.domNode.style.display="block";}else{_2cb+="width:"+(_2cf+(Number(_2cf)==_2cf?"px":""))+";";}var _2d0=lang.delegate(this.inlineEditBox.editorParams,{style:_2cb,dir:this.dir,lang:this.lang,textDir:this.textDir});this.editWidget=new Cls(_2d0,this.editorPlaceholder);if(this.inlineEditBox.autoSave){this.saveButton.destroy();this.cancelButton.destroy();this.saveButton=this.cancelButton=null;_2bd.destroy(this.buttonContainer);}},postCreate:function(){this.inherited(arguments);var ew=this.editWidget;if(this.inlineEditBox.autoSave){this.own(_2b9.after(ew,"onChange",lang.hitch(this,"_onChange"),true),on(ew,"keydown",lang.hitch(this,"_onKeyDown")));}else{if("intermediateChanges" in ew){ew.set("intermediateChanges",true);this.own(_2b9.after(ew,"onChange",lang.hitch(this,"_onIntermediateChange"),true));this.saveButton.set("disabled",true);}}},startup:function(){this.editWidget.startup();this.inherited(arguments);},_onIntermediateChange:function(){this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());},destroy:function(){this.editWidget.destroy(true);this.inherited(arguments);},getValue:function(){var ew=this.editWidget;return String(ew.get(("displayedValue" in ew||"_getDisplayedValueAttr" in ew)?"displayedValue":"value"));},_onKeyDown:function(e){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(e.altKey||e.ctrlKey){return;}if(e.keyCode==keys.ESCAPE){e.stopPropagation();e.preventDefault();this.cancel(true);}else{if(e.keyCode==keys.ENTER&&e.target.tagName=="INPUT"){e.stopPropagation();e.preventDefault();this._onChange();}}}},_onBlur:function(){this.inherited(arguments);if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(this.getValue()==this._resetValue){this.cancel(false);}else{if(this.enableSave()){this.save(false);}}}},_onChange:function(){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){fm.focus(this.inlineEditBox.displayNode);}},enableSave:function(){return this.editWidget.isValid?this.editWidget.isValid():true;},focus:function(){this.editWidget.focus();if(this.editWidget.focusNode){fm._onFocusNode(this.editWidget.focusNode);if(this.editWidget.focusNode.tagName=="INPUT"){this.defer(function(){_2c6.selectInputText(this.editWidget.focusNode);});}}}});var _2d1=_2ba("dijit.InlineEditBox"+(has("dojo-bidi")?"_NoBidi":""),_2c1,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_2c7,editorWrapper:_2c9,editorParams:{},disabled:false,onChange:function(){},onCancel:function(){},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){this.editorParams={};},postMixInProperties:function(){this.inherited(arguments);this.displayNode=this.srcNodeRef;this.own(on(this.displayNode,_2c0,lang.hitch(this,"_onClick")),on(this.displayNode,"mouseover, focus",lang.hitch(this,"_onMouseOver")),on(this.displayNode,"mouseout, blur",lang.hitch(this,"_onMouseOut")));this.displayNode.setAttribute("role","button");if(!this.displayNode.getAttribute("tabIndex")){this.displayNode.setAttribute("tabIndex",0);}if(!this.value&&!("value" in this.params)){this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));}if(!this.value){this.displayNode.innerHTML=this.noValueIndicator;}_2bc.add(this.displayNode,"dijitInlineEditBoxDisplayMode");},setDisabled:function(_2d2){_2bf.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_2d2);},_setDisabledAttr:function(_2d3){this.domNode.setAttribute("aria-disabled",_2d3?"true":"false");if(_2d3){this.displayNode.removeAttribute("tabIndex");}else{this.displayNode.setAttribute("tabIndex",0);}_2bc.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_2d3);this._set("disabled",_2d3);},_onMouseOver:function(){if(!this.disabled){_2bc.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");}},_onMouseOut:function(){_2bc.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");},_onClick:function(e){if(this.disabled){return;}if(e){e.stopPropagation();e.preventDefault();}this._onMouseOut();this.defer("edit");},edit:function(){if(this.disabled||this.editing){return;}this._set("editing",true);this._savedTabIndex=_2bb.get(this.displayNode,"tabIndex")||"0";if(!this.wrapperWidget){var _2d4=_2bd.create("span",null,this.domNode,"before");var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_2be.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_2d4);if(!this.wrapperWidget._started){this.wrapperWidget.startup();}if(!this._started){this.startup();}}var ww=this.wrapperWidget;_2bc.add(this.displayNode,"dijitOffScreen");_2bc.remove(ww.domNode,"dijitOffScreen");_2be.set(ww.domNode,{visibility:"visible"});_2bb.set(this.displayNode,"tabIndex","-1");var ew=ww.editWidget;var self=this;when(ew.onLoadDeferred,lang.hitch(ww,function(){ew.set(("displayedValue" in ew||"_setDisplayedValueAttr" in ew)?"displayedValue":"value",self.value);this.defer(function(){if(ww.saveButton){ww.saveButton.set("disabled","intermediateChanges" in ew);}this.focus();this._resetValue=this.getValue();});}));},_onBlur:function(){this.inherited(arguments);if(!this.editing){}},destroy:function(){if(this.wrapperWidget&&!this.wrapperWidget._destroyed){this.wrapperWidget.destroy();delete this.wrapperWidget;}this.inherited(arguments);},_showText:function(_2d5){var ww=this.wrapperWidget;_2be.set(ww.domNode,{visibility:"hidden"});_2bc.add(ww.domNode,"dijitOffScreen");_2bc.remove(this.displayNode,"dijitOffScreen");_2bb.set(this.displayNode,"tabIndex",this._savedTabIndex);if(_2d5){fm.focus(this.displayNode);}},save:function(_2d6){if(this.disabled||!this.editing){return;}this._set("editing",false);var ww=this.wrapperWidget;var _2d7=ww.getValue();this.set("value",_2d7);this._showText(_2d6);},setValue:function(val){_2bf.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(val){val=lang.trim(val);var _2d8=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");this.displayNode.innerHTML=_2d8||this.noValueIndicator;this._set("value",val);if(this._started){this.defer(function(){this.onChange(val);});}},getValue:function(){_2bf.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");return this.get("value");},cancel:function(_2d9){if(this.disabled||!this.editing){return;}this._set("editing",false);this.defer("onCancel");this._showText(_2d9);}});if(has("dojo-bidi")){_2d1=_2ba("dijit.InlineEditBox",_2d1,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.displayNode);}});}_2d1._InlineEditor=_2c9;return _2d1;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_2da,_2db,_2dc){var _2dd={};lang.setObject("dojo.dnd.autoscroll",_2dd);_2dd.getViewport=_2dc.getBox;_2dd.V_TRIGGER_AUTOSCROLL=32;_2dd.H_TRIGGER_AUTOSCROLL=32;_2dd.V_AUTOSCROLL_VALUE=16;_2dd.H_AUTOSCROLL_VALUE=16;var _2de,doc=win.doc,_2df=Infinity,_2e0=Infinity;_2dd.autoScrollStart=function(d){doc=d;_2de=_2dc.getBox(doc);var html=win.body(doc).parentNode;_2df=Math.max(html.scrollHeight-_2de.h,0);_2e0=Math.max(html.scrollWidth-_2de.w,0);};_2dd.autoScroll=function(e){var v=_2de||_2dc.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_2dd.H_TRIGGER_AUTOSCROLL){dx=-_2dd.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_2dd.H_TRIGGER_AUTOSCROLL){dx=Math.min(_2dd.H_AUTOSCROLL_VALUE,_2e0-html.scrollLeft);}}if(e.clientY<_2dd.V_TRIGGER_AUTOSCROLL){dy=-_2dd.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_2dd.V_TRIGGER_AUTOSCROLL){dy=Math.min(_2dd.V_AUTOSCROLL_VALUE,_2df-html.scrollTop);}}window.scrollBy(dx,dy);};_2dd._validNodes={"div":1,"p":1,"td":1};_2dd._validOverflow={"auto":1,"scroll":1};_2dd.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_2e1,_2e2;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _2dd._validNodes)){var s=_2db.getComputedStyle(n),_2e3=(s.overflow.toLowerCase() in _2dd._validOverflow),_2e4=(s.overflowX.toLowerCase() in _2dd._validOverflow),_2e5=(s.overflowY.toLowerCase() in _2dd._validOverflow);if(_2e3||_2e4||_2e5){b=_2da.getContentBox(n,s);t=_2da.position(n,true);}if(_2e3||_2e4){w=Math.min(_2dd.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_2e1=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_2e3||_2e5){h=Math.min(_2dd.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_2e2=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_2dd.autoScroll(e);};return _2dd;});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query!css2","../registry"],function(_2e6,_2e7,_2e8,lang,_2e9,_2ea){return _2e7("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_2e9("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_2eb){if(_2eb.name==this.name&&_2eb.form==this.focusNode.form){var _2ec=_2ea.getEnclosingWidget(_2eb);if(_2ec){ary.push(_2ec);}}}));return ary;},_setCheckedAttr:function(_2ed){this.inherited(arguments);if(!this._created){return;}if(_2ed){_2e6.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2ee){if(_2ee!=this&&_2ee.checked){_2ee.set("checked",false);}}));}},_getSubmitValue:function(_2ef){return _2ef==null?"on":_2ef;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_2e6.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2f0){_2e8.set(this.focusNode||this.domNode,"checked",_2f0.checked);}));return false;}return this.inherited(arguments);}});});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_2f1,_2f2){var _2f3=_2f2.prototype.onMove;return _2f1("dojo.dnd.TimedMoveable",_2f2,{timeout:40,constructor:function(node,_2f4){if(!_2f4){_2f4={};}if(_2f4.timeout&&typeof _2f4.timeout=="number"&&_2f4.timeout>=0){this.timeout=_2f4.timeout;}},onMoveStop:function(_2f5){if(_2f5._timer){clearTimeout(_2f5._timer);_2f3.call(this,_2f5,_2f5._leftTop);}_2f2.prototype.onMoveStop.apply(this,arguments);},onMove:function(_2f6,_2f7){_2f6._leftTop=_2f7;if(!_2f6._timer){var _2f8=this;_2f6._timer=setTimeout(function(){_2f6._timer=null;_2f3.call(_2f8,_2f6,_2f6._leftTop);},this.timeout);}}});});},"dijit/layout/LinkPane":function(){define(["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_2f9,_2fa,_2fb){return _2fb("dijit.layout.LinkPane",[_2f9,_2fa],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){if(this.srcNodeRef){this.title+=this.srcNodeRef.innerHTML;}this.inherited(arguments);},_fillContent:function(){}});});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_2fc,on,_2fd,_2fe){return _2fc("dijit.form._ListMouseMixin",_2fe,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this._listConnect("click","_onClick");this._listConnect("mousedown","_onMouseDown");this._listConnect("mouseup","_onMouseUp");this._listConnect("mouseover","_onMouseOver");this._listConnect("mouseout","_onMouseOut");},_onClick:function(evt,_2ff){this._setSelectedAttr(_2ff,false);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_2ff);});},_onMouseDown:function(evt,_300){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_300,false);},_onMouseUp:function(evt,_301){this._isDragging=false;var _302=this.selected;var _303=this._hoveredNode;if(_302&&_301==_302){this.defer(function(){this._onClick(evt,_302);});}else{if(_303){this.defer(function(){this._onClick(evt,_303);});}}},_onMouseOut:function(evt,_304){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_305){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_305;this.onHover(_305);if(this._isDragging){this._setSelectedAttr(_305,false);}}});});},"dojo/cldr/monetary":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _306={};lang.setObject("dojo.cldr.monetary",_306);_306.getData=function(code){var _307={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _308={};var _309=_307[code],_30a=_308[code];if(typeof _309=="undefined"){_309=2;}if(typeof _30a=="undefined"){_30a=0;}return {places:_309,round:_30a};};return _306;});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_30b){dojo.cookie=function(name,_30c,_30d){var c=document.cookie,ret;if(arguments.length==1){var _30e=c.match(new RegExp("(?:^|; )"+_30b.escapeString(name)+"=([^;]*)"));ret=_30e?decodeURIComponent(_30e[1]):undefined;}else{_30d=_30d||{};var exp=_30d.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_30d.expires=d;}if(exp&&exp.toUTCString){_30d.expires=exp.toUTCString();}_30c=encodeURIComponent(_30c);var _30f=name+"="+_30c,_310;for(_310 in _30d){_30f+="; "+_310;var _311=_30d[_310];if(_311!==true){_30f+="="+_311;}}document.cookie=_30f;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dijit/ProgressBar":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_312,_313,_314,lang,_315,_316,_317,_318){return _313("dijit.ProgressBar",[_316,_317],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_318,_indeterminateHighContrastImagePath:_312.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!(this.params&&"value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},_setDirAttr:function(val){_314.toggle(this.domNode,"dijitProgressBarRtl",val=="rtl");_314.toggle(this.domNode,"dijitProgressBarIndeterminateRtl",this.indeterminate&&val=="rtl");this.inherited(arguments);},update:function(_319){lang.mixin(this,_319||{});var tip=this.internalProgress,ap=this.domNode;var _31a=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");}else{if(String(this.progress).indexOf("%")!=-1){_31a=Math.min(parseFloat(this.progress)/100,1);this.progress=_31a*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_31a=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-valuenow",this.progress);}ap.setAttribute("aria-labelledby",this.labelNode.id);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);this.labelNode.innerHTML=this.report(_31a);_314.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);_314.toggle(this.domNode,"dijitProgressBarIndeterminateRtl",this.indeterminate&&!this.isLeftToRight());tip.style.width=(_31a*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(_31b){this._set("label",_31b);this.update();},_setIndeterminateAttr:function(_31c){this._set("indeterminate",_31c);this.update();},report:function(_31d){return this.label?this.label:(this.indeterminate?"&#160;":_315.format(_31d,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dijit/form/NumberTextBox":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/i18n","dojo/string","dojo/number","./RangeBoundTextBox"],function(_31e,lang,i18n,_31f,_320,_321){var _322=function(_323){var _323=_323||{},_324=i18n.getLocalization("dojo.cldr","number",i18n.normalizeLocale(_323.locale)),_325=_323.pattern?_323.pattern:_324[(_323.type||"decimal")+"Format"],_326=typeof _323.places=="number",_327=_326?_323.places:(_325.indexOf(_324.decimal)!=-1?_325.split(_324.decimal)[1].replace(/[^#0]/g,"").length:0);return {sep:_324.decimal,places:_327};};var _328=_31e("dijit.form.NumberTextBoxMixin",null,{pattern:function(_329){return "("+(this.focused&&this.editOptions?this._regExpGenerator(lang.delegate(_329,this.editOptions))+"|":"")+this._regExpGenerator(_329)+")";},value:NaN,editOptions:{pattern:"#.######"},_formatter:_320.format,_regExpGenerator:_320.regexp,_decimalInfo:_322(),postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_32a){var _32b=typeof _32a.places=="number"?_32a.places:0;if(_32b){_32b++;}if(typeof _32a.max!="number"){_32a.max=9*Math.pow(10,15-_32b);}if(typeof _32a.min!="number"){_32a.min=-9*Math.pow(10,15-_32b);}this.inherited(arguments,[_32a]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}this._decimalInfo=_322(_32a);},_onFocus:function(){if(this.disabled||this.readOnly){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _32c=this.format(val,this.constraints);if(_32c!==undefined){this.textbox.value=_32c;}}this.inherited(arguments);},format:function(_32d,_32e){var _32f=String(_32d);if(typeof _32d!="number"){return _32f;}if(isNaN(_32d)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(_32d,_32e))&&_32e.exponent!==false&&/\de[-+]?\d/i.test(_32f)){return _32f;}if(this.editOptions&&this.focused){_32e=lang.mixin({},_32e,this.editOptions);}return this._formatter(_32d,_32e);},_parser:_320.parse,parse:function(_330,_331){var v=this._parser(_330,lang.mixin({},_331,(this.editOptions&&this.focused)?this.editOptions:{}));if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(_330,_331);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(_332){if(_332==null||typeof _332=="string"&&_332==""){return NaN;}else{if(typeof _332=="number"&&!isNaN(_332)&&_332!=0){_332=_320.round(_332,this._decimalInfo.places);}}return this.inherited(arguments,[_332]);},serialize:function(_333,_334){return (typeof _333!="number"||isNaN(_333))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.delegate(this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(_335,_336,_337){if(_335!==undefined&&_337===undefined){_337=String(_335);if(typeof _335=="number"){if(isNaN(_335)){_337="";}else{if(("rangeCheck" in this&&this.rangeCheck(_335,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_337)){_337=undefined;}}}else{if(!_335){_337="";_335=NaN;}else{_335=undefined;}}}this.inherited(arguments,[_335,_336,_337]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_320._realNumberRegexp(lang.delegate(this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_338){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}},_isValidSubset:function(){var _339=(typeof this.constraints.min=="number"),_33a=(typeof this.constraints.max=="number"),_33b=this.get("value");if(isNaN(_33b)||(!_339&&!_33a)){return this.inherited(arguments);}var _33c=_33b|0,_33d=_33b<0,_33e=this.textbox.value.indexOf(this._decimalInfo.sep)!=-1,_33f=this.maxLength||20,_340=_33f-this.textbox.value.length,_341=_33e?this.textbox.value.split(this._decimalInfo.sep)[1].replace(/[^0-9]/g,""):"";var _342=_33e?_33c+"."+_341:_33c+"";var _343=_31f.rep("9",_340),_344=_33b,_345=_33b;if(_33d){_344=Number(_342+_343);}else{_345=Number(_342+_343);}return !((_339&&_345<this.constraints.min)||(_33a&&_344>this.constraints.max));}});var _346=_31e("dijit.form.NumberTextBox",[_321,_328],{baseClass:"dijitTextBox dijitNumberTextBox"});_346.Mixin=_328;return _346;});},"dijit/form/TimeTextBox":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_347,keys,lang,_348,_349){return _347("dijit.form.TimeTextBox",_349,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_348,_selector:"time",value:new Date(""),maxHeight:-1,_onKey:function(evt){if(this.disabled||this.readOnly){return;}this.inherited(arguments);switch(evt.keyCode){case keys.ENTER:case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:break;default:this.defer(function(){var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();});}}});});},"dijit/ColorPalette":function(){define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_34a,_34b,_34c,_34d,_34e,has,i18n,_34f,_350,_351,_352){var _353=_350("dijit.ColorPalette",[_34c,_34d,_34e],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_34b,baseClass:"dijitColorPalette",_dyeFactory:function(_354,row,col,_355){return new this._dyeClass(_354,row,col,_355);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_350(_353._Color,{palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_353._Color=_350("dijit._Color",_34f,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_34a.toUrl("./themes/a11y/colors7x10.png"),"3x4":_34a.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_356,row,col,_357){this._title=_357;this._row=row;this._col=col;this.setColor(_34f.named[_356]);},getValue:function(){return this.toHex();},fillCell:function(cell,_358){var html=_352.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_358,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_351.place(html,cell);}});return _353;});},"dijit/form/CurrencyTextBox":function(){define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_359,_35a,lang,_35b){return _35a("dijit.form.CurrencyTextBox",_35b,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",_formatter:_359.format,_parser:_359.parse,_regExpGenerator:_359.regexp,parse:function(_35c,_35d){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(_35c)){v=lang.hitch(lang.delegate(this,{_parser:_35b.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_35e){if(!_35e.currency&&this.currency){_35e.currency=this.currency;}this.inherited(arguments,[_359._mixInDefaults(lang.mixin(_35e,{exponent:false}))]);}});});},"dijit/layout/LayoutContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/_base/lang","../_WidgetBase","./_LayoutWidget","./utils"],function(_35f,_360,_361,_362,lang,_363,_364,_365){var _366=_360("dijit.layout.LayoutContainer",_364,{design:"headline",baseClass:"dijitLayoutContainer",startup:function(){if(this._started){return;}_35f.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_367){this.inherited(arguments);var _368=_367.region;if(_368){_361.add(_367.domNode,this.baseClass+"Pane");}},_getOrderedChildren:function(){var _369=_35f.map(this.getChildren(),function(_36a,idx){return {pane:_36a,weight:[_36a.region=="center"?Infinity:0,_36a.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_36a.region)?1:-1),idx]};},this);_369.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});return _35f.map(_369,function(w){return w.pane;});},layout:function(){_365.layoutChildren(this.domNode,this._contentBox,this._getOrderedChildren());},addChild:function(_36b,_36c){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_36d){this.inherited(arguments);if(this._started){this.layout();}_361.remove(_36d.domNode,this.baseClass+"Pane");_362.set(_36d.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_362.set(_36d.domNode,/top|bottom/.test(_36d.region)?"width":"height","auto");}});_366.ChildWidgetProperties={region:"",layoutAlign:"",layoutPriority:0};lang.extend(_363,_366.ChildWidgetProperties);return _366;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_36e,_36f,fx,dom,_370,_371,_372,lang,_373,on,has,_374,_375,_376,_377,_378,_379,_37a){var _37b=_36f("dijit._MasterTooltip",[_376,_377],{duration:_374.defaultDuration,templateString:_379,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _378(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_37c,_37d,_37e,rtl,_37f,_380,_381){if(this.aroundNode&&this.aroundNode===_37d&&this.containerNode.innerHTML==_37c){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_37c;if(_37f){this.set("textDir",_37f);}this.containerNode.align=rtl?"right":"left";var pos=_375.around(this.domNode,_37d,_37e&&_37e.length?_37e:_382.defaultPosition,!rtl,lang.hitch(this,"orient"));var _383=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_383.y+((_383.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_383.x+((_383.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_372.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_37d;this.onMouseEnter=_380||noop;this.onMouseLeave=_381||noop;},orient:function(node,_384,_385,_386,_387){this.connectorNode.style.top="";var _388=_386.h,_389=_386.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_384+"-"+_385];this.domNode.style.width="auto";var size=_371.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _38a=Math.min((Math.max(_389,1)),size.w);_371.setMarginBox(this.domNode,{w:_38a});if(_385.charAt(0)=="B"&&_384.charAt(0)=="B"){var bb=_371.position(node);var _38b=this.connectorNode.offsetHeight;if(bb.h>_388){var _38c=_388-((_387.h+_38b)>>1);this.connectorNode.style.top=_38c+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_387.h/2-_38b/2,0),bb.h-_38b)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_389);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_38d){if(this._onDeck&&this._onDeck[1]==_38d){this._onDeck=null;}else{if(this.aroundNode===_38d){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_37b.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_36e.forEach(node.children,function(_38e){this._setAutoTextDir(_38e);},this);},_setTextDirAttr:function(_38f){this._set("textDir",_38f);if(_38f=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_37a.showTooltip=function(_390,_391,_392,rtl,_393,_394,_395){if(_392){_392=_36e.map(_392,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_382._masterTT){_37a._masterTT=_382._masterTT=new _37b();}return _382._masterTT.show(_390,_391,_392,rtl,_393,_394,_395);};_37a.hideTooltip=function(_396){return _382._masterTT&&_382._masterTT.hide(_396);};var _397="DORMANT",_398="SHOW TIMER",_399="SHOWING",_39a="HIDE TIMER";function noop(){};var _382=_36f("dijit.Tooltip",_376,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_39b){_36e.forEach(this._connections||[],function(_39c){_36e.forEach(_39c,function(_39d){_39d.remove();});},this);this._connectIds=_36e.filter(lang.isArrayLike(_39b)?_39b:(_39b?[_39b]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_36e.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_39e=this.selector,_39f=_39e?function(_3a0){return on.selector(_39e,_3a0);}:function(_3a1){return _3a1;},self=this;return [on(node,_39f(_373.enter),function(){self._onHover(this);}),on(node,_39f("focusin"),function(){self._onHover(this);}),on(node,_39f(_373.leave),lang.hitch(self,"_onUnHover")),on(node,_39f("focusout"),lang.hitch(self,"set","state",_397))];},this);this._set("connectId",_39b);},addTarget:function(node){var id=node.id||node;if(_36e.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_36e.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_370.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_36e.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_397,_setStateAttr:function(val){if(this.state==val||(val==_398&&this.state==_399)||(val==_39a&&this.state==_397)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _397:if(this._connectNode){_382.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _398:if(this.state!=_399){this._showTimer=this.defer(function(){this.set("state",_399);},this.showDelay);}break;case _399:var _3a2=this.getContent(this._connectNode);if(!_3a2){this.set("state",_397);return;}_382.show(_3a2,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_399),lang.hitch(this,"set","state",_39a));this.onShow(this._connectNode,this.position);break;case _39a:this._hideTimer=this.defer(function(){this.set("state",_397);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_3a3){if(this._connectNode&&_3a3!=this._connectNode){this.set("state",_397);}this._connectNode=_3a3;this.set("state",_398);},_onUnHover:function(_3a4){this.set("state",_39a);},open:function(_3a5){this.set("state",_397);this._connectNode=_3a5;this.set("state",_399);},close:function(){this.set("state",_397);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_397);_36e.forEach(this._connections||[],function(_3a6){_36e.forEach(_3a6,function(_3a7){_3a7.remove();});},this);this.inherited(arguments);}});_382._MasterTooltip=_37b;_382.show=_37a.showTooltip;_382.hide=_37a.hideTooltip;_382.defaultPosition=["after-centered","before-centered"];return _382;});},"dijit/form/VerticalSlider":function(){define(["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_3a8,_3a9,_3aa){return _3a8("dijit.form.VerticalSlider",_3a9,{templateString:_3aa,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){return this._descending;}});});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html","../a11yclick"],function(_3ab,lang,_3ac,_3ad,_3ae,_3af,_3b0,_3b1,_3b2){return _3ab("dijit.form.DropDownButton",[_3af,_3b0,_3b1],{baseClass:"dijitDropDownButton",templateString:_3b2,_fillContent:function(){if(this.srcNodeRef){var _3b3=_3ac("*",this.srcNodeRef);this.inherited(arguments,[_3b3[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){var _3b4=_3ac("[widgetId]",this.dropDownContainer)[0];if(_3b4){this.dropDown=_3ad.byNode(_3b4);}delete this.dropDownContainer;}if(this.dropDown){_3ae.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _3b5=this.dropDown;return (!!_3b5&&(!_3b5.href||_3b5.isLoaded));},loadDropDown:function(_3b6){var _3b7=this.dropDown;var _3b8=_3b7.on("load",lang.hitch(this,function(){_3b8.remove();_3b6();}));_3b7.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_3b9){var _3ba=_3b9.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_3ba==1&&date.isLeapYear(_3b9)){return 29;}return days[_3ba];};date.isLeapYear=function(_3bb){var year=_3bb.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_3bc){var str=_3bc.toString();var tz="";var _3bd;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_3bd=str.match(pat))){tz=_3bd[1];}else{str=_3bc.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_3bd=str.match(pat))){tz=_3bd[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_3be,_3bf,_3c0){_3be=new Date(+_3be);_3bf=new Date(+(_3bf||new Date()));if(_3c0=="date"){_3be.setHours(0,0,0,0);_3bf.setHours(0,0,0,0);}else{if(_3c0=="time"){_3be.setFullYear(0,0,0);_3bf.setFullYear(0,0,0);}}if(_3be>_3bf){return 1;}if(_3be<_3bf){return -1;}return 0;};date.add=function(date,_3c1,_3c2){var sum=new Date(+date);var _3c3=false;var _3c4="Date";switch(_3c1){case "day":break;case "weekday":var days,_3c5;var mod=_3c2%5;if(!mod){days=(_3c2>0)?5:-5;_3c5=(_3c2>0)?((_3c2-5)/5):((_3c2+5)/5);}else{days=mod;_3c5=parseInt(_3c2/5);}var strt=date.getDay();var adj=0;if(strt==6&&_3c2>0){adj=1;}else{if(strt==0&&_3c2<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_3c2>0)?2:-2;}_3c2=(7*_3c5)+days+adj;break;case "year":_3c4="FullYear";_3c3=true;break;case "week":_3c2*=7;break;case "quarter":_3c2*=3;case "month":_3c3=true;_3c4="Month";break;default:_3c4="UTC"+_3c1.charAt(0).toUpperCase()+_3c1.substring(1)+"s";}if(_3c4){sum["set"+_3c4](sum["get"+_3c4]()+_3c2);}if(_3c3&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_3c6,_3c7,_3c8){_3c7=_3c7||new Date();_3c8=_3c8||"day";var _3c9=_3c7.getFullYear()-_3c6.getFullYear();var _3ca=1;switch(_3c8){case "quarter":var m1=_3c6.getMonth();var m2=_3c7.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_3c9*4);_3ca=q2-q1;break;case "weekday":var days=Math.round(date.difference(_3c6,_3c7,"day"));var _3cb=parseInt(date.difference(_3c6,_3c7,"week"));var mod=days%7;if(mod==0){days=_3cb*5;}else{var adj=0;var aDay=_3c6.getDay();var bDay=_3c7.getDay();_3cb=parseInt(days/7);mod=days%7;var _3cc=new Date(_3c6);_3cc.setDate(_3cc.getDate()+(_3cb*7));var _3cd=_3cc.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_3cd+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_3cd+mod)<0:adj=2;}}}days+=adj;days-=(_3cb*2);}_3ca=days;break;case "year":_3ca=_3c9;break;case "month":_3ca=(_3c7.getMonth()-_3c6.getMonth())+(_3c9*12);break;case "week":_3ca=parseInt(date.difference(_3c6,_3c7,"day")/7);break;case "day":_3ca/=24;case "hour":_3ca/=60;case "minute":_3ca/=60;case "second":_3ca/=1000;case "millisecond":_3ca*=_3c7.getTime()-_3c6.getTime();}return Math.round(_3ca);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","../registry","../Viewport","./utils"],function(_3ce,_3cf,_3d0,_3d1,_3d2,lang,_3d3,_3d4,_3d5,_3d6){return _3cf("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _3d7=this.getParent();this._childOfLayoutWidget=_3d7&&_3d7.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_3d5.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){if(!this.doLayout){return;}var _3d8=[],_3d9=false;_3d3("> *",this.containerNode).some(function(node){var _3da=_3d4.byNode(node);if(_3da&&_3da.resize){_3d8.push(_3da);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_3d9=true;}}});this._singleChild=_3d8.length==1&&!_3d9?_3d8[0]:null;_3d0.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_3db,_3dc){this._resizeCalled=true;this._scheduleLayout(_3db,_3dc);},_scheduleLayout:function(_3dd,_3de){if(this._isShown()){this._layout(_3dd,_3de);}else{this._needLayout=true;this._changeSize=_3dd;this._resultSize=_3de;}},_layout:function(_3df,_3e0){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_3df){_3d1.setMarginBox(this.domNode,_3df);}var cn=this.containerNode;if(cn===this.domNode){var mb=_3e0||{};lang.mixin(mb,_3df||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_3d1.getMarginBox(cn),mb);}this._contentBox=_3d6.marginBox2contentBox(cn,mb);}else{this._contentBox=_3d1.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){this._checkIfSingleChild();if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_3d1.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _3e1=this.getChildren(),_3e2,i=0;while(_3e2=_3e1[i++]){if(_3e2.resize){_3e2.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_3e3=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_3d0.contains(node,"dijitHidden")&&_3e3&&_3e3.style&&(_3e3.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/form/RangeBoundTextBox":function(){define(["dojo/_base/declare","dojo/i18n","./MappedTextBox","dojo/i18n!./nls/validate"],function(_3e4,i18n,_3e5){var _3e6=_3e4("dijit.form.RangeBoundTextBox",_3e5,{rangeMessage:"",rangeCheck:function(_3e7,_3e8){return ("min" in _3e8?(this.compare(_3e7,_3e8.min)>=0):true)&&("max" in _3e8?(this.compare(_3e7,_3e8.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");if(val==null){return false;}var _3e9=false;if("min" in this.constraints){var min=this.constraints.min;_3e9=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;}if(!_3e9&&("max" in this.constraints)){var max=this.constraints.max;_3e9=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;}return _3e9;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_3ea){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_3ea));},getErrorMessage:function(_3eb){var v=this.get("value");if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_3eb)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}}});return _3e6;});},"dijit/_editor/RichText":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/domReady","dojo/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/window","../_Widget","../_CssStateMixin","../selection","./range","./html","../focus","../main"],function(_3ec,_3ed,_3ee,_3ef,dom,_3f0,_3f1,_3f2,_3f3,_3f4,_3f5,keys,lang,on,_3f6,_3f7,has,_3f8,_3f9,_3fa,_3fb,_3fc,_3fd,_3fe,_3ff,_400,_401,_402){var _403=_3ee("dijit._editor.RichText",[_3fc,_3fd],{constructor:function(_404){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_404&&lang.isString(_404.value)){this.value=_404.value;}this.onLoadDeferred=new _3ef();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.trim,lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")||has("trident")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,"_stripBreakerNodes")].concat(this.contentDomPostFilters);}this.contentDomPostFilters=[lang.hitch(this,"_stripTrailingEmptyNodes")].concat(this.contentDomPostFilters);this.inherited(arguments);_3f8.publish(_402._scopeName+"._editor.RichText::init",this);},startup:function(){this.inherited(arguments);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _405={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_405.Z=exec("redo");}var key;for(key in _405){this.addKeyHandler(key,true,false,_405[key]);}},events:["onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_403._editorCommandsLocalized){this._local2NativeFormatNames=_403._local2NativeFormatNames;this._native2LocalFormatNames=_403._native2LocalFormatNames;return;}_403._editorCommandsLocalized=true;_403._local2NativeFormatNames={};_403._native2LocalFormatNames={};this._local2NativeFormatNames=_403._local2NativeFormatNames;this._native2LocalFormatNames=_403._native2LocalFormatNames;var _406=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _407="",_408,i=0;while((_408=_406[i++])){if(_408.charAt(1)!=="l"){_407+="<"+_408+"><span>content</span></"+_408+"><br/>";}else{_407+="<"+_408+"><li>content</li></"+_408+"><br/>";}}var _409={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_3f2.create("div",{style:_409,innerHTML:_407});this.ownerDocumentBody.appendChild(div);var _40a=lang.hitch(this,function(){var node=div.firstChild;while(node){try{this.selection.selectElement(node.firstChild);var _40b=node.tagName.toLowerCase();this._local2NativeFormatNames[_40b]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_40b]]=_40b;node=node.nextSibling.nextSibling;}catch(e){}}_3f2.destroy(div);});this.defer(_40a);},open:function(_40c){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _3ef();}if(!this.isClosed){this.close();}_3f8.publish(_402._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_40c.nodeName){this.domNode=_40c;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=this.ownerDocument.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_3f2.place(dn,ta,"before");var _40d=lang.hitch(this,function(){_3f4.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){this.defer(_40d,10);}else{_40d();}if(ta.form){var _40e=ta.value;this.reset=function(){var _40f=this.getValue();if(_40f!==_40e){this.replaceValue(_40e);}};on(ta.form,"submit",lang.hitch(this,function(){_3f0.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_400.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_3ed["useXDomain"]||_3ed["allowXdRichTextSave"])){var _410=dom.byId(_402._scopeName+"._editor.RichText.value");if(_410&&_410.value!==""){var _411=_410.value.split(this._SEPARATOR),i=0,dat;while((dat=_411[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){this.value=data[1];_411=_411.splice(i,1);_410.value=_411.join(this._SEPARATOR);break;}}}if(!_403._globalSaveHandler){_403._globalSaveHandler={};_3f9.addOnUnload(function(){var id;for(id in _403._globalSaveHandler){var f=_403._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_403._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));ifr.id=this.id+"_iframe";ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=w.document;this.selection=new _3fe.SelectionManager(w);if(has("ie")){this._localizeEditorCommands();}this.onLoad(this.get("value"));});var src=this._getIframeDocTxt().replace(/\\/g,"\\\\").replace(/'/g,"\\'"),s;if(has("ie")<11){s="javascript:document.open();try{parent.window;}catch(e){document.domain=\""+document.domain+"\";}"+"document.write('"+src+"');document.close()";}else{s="javascript: '"+src+"'";}if(has("ie")==9){this.editingArea.appendChild(ifr);ifr.src=s;}else{ifr.setAttribute("src",s);this.editingArea.appendChild(ifr);}if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_3f1.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _412=_3f4.getComputedStyle(this.domNode);var html="<div id='dijitEditorBody'></div>";var font=[_412.fontWeight,_412.fontSize,_412.fontFamily].join(" ");var _413=_412.lineHeight;if(_413.indexOf("px")>=0){_413=parseFloat(_413)/parseFloat(_412.fontSize);}else{if(_413.indexOf("em")>=0){_413=parseFloat(_413);}else{_413="normal";}}var _414="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_415){_415=_415.replace(/^;/ig,"")+";";var s=_415.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_3f4.set(self.domNode,sC,"");}_414+=_415+";";});var _416=_3f6("label[for=\""+this.id+"\"]");var _417="";if(_416.length){_417=_416[0].innerHTML;}else{if(this["aria-label"]){_417=this["aria-label"];}else{if(this["aria-labelledby"]){_417=dom.byId(this["aria-labelledby"]).innerHTML;}}}this.iframe.setAttribute("title",_417);return ["<!DOCTYPE html>",this.isLeftToRight()?"<html lang='"+this.lang+"'>\n<head>\n":"<html dir='rtl' lang='"+this.lang+"'>\n<head>\n",_417?"<title>"+_417+"</title>":"","<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n","\t}\n","\tbody,html,#dijitEditorBody { outline: none; }","html { height: 100%; width: 100%; overflow: hidden; }\n",this.height?"\tbody,#dijitEditorBody { height: 100%; width: 100%; overflow: auto; }\n":"\tbody,#dijitEditorBody { min-height: "+this.minHeight+"; width: 100%; overflow-x: auto; overflow-y: hidden; }\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tline-height:",_413,";\n","\t}\n","\tp{ margin: 1em 0; }\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body role='main' ","onload='frameElement && frameElement._loadFunc(window,document)' ","style='"+_414+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var _418=[];if(this.styleSheets){_418=this.styleSheets.split(";");this.styleSheets="";}_418=_418.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url,_419=_3fb.get(this.ownerDocument);while((url=_418[i++])){var _41a=(new _3fa(_419.location,url)).toString();this.editingAreaStyleSheets.push(_41a);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_41a+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString(),_41b=_3fb.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3fa(_41b.location,url)).toString();}if(_3ec.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.then(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _41c=this.document.createElement("link");_41c.rel="stylesheet";_41c.type="text/css";_41c.href=url;head.appendChild(_41c);}}));},removeStyleSheet:function(uri){var url=uri.toString(),_41d=_3fb.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3fa(_41d.location,url)).toString();}var _41e=_3ec.indexOf(this.editingAreaStyleSheets,url);if(_41e===-1){return;}delete this.editingAreaStyleSheets[_41e];_3f6("link[href=\""+url+"\"]",this.window.document).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_41f){_41f=!!_41f;this._set("disabled",_41f);if(!this.isLoaded){return;}var _420=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_420){this.editNode.unselectable="on";}this.editNode.contentEditable=!_41f;this.editNode.tabIndex=_41f?"-1":this.tabIndex;if(_420){this.defer(function(){if(this.editNode){this.editNode.unselectable="off";}});}if(has("mozilla")&&!_41f&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=_401.registerIframe(this.iframe);}this.editNode=this.document.body.firstChild;var _421=this;this.beforeIframeNode=_3f2.place("<div tabIndex=-1></div>",this.iframe,"before");this.afterIframeNode=_3f2.place("<div tabIndex=-1></div>",this.iframe,"after");this.iframe.onfocus=this.document.onfocus=function(){_421.editNode.focus();};this.focusNode=this.editNode;var _422=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;this.own.apply(this,_3ec.map(_422,function(item){var type=item.toLowerCase().replace(/^on/,"");return on(ap,type,lang.hitch(this,item));},this));this.own(on(ap,"mouseup",lang.hitch(this,"onClick")));if(has("ie")){this.own(on(this.document,"mousedown",lang.hitch(this,"_onIEMouseDown")));this.editNode.style.zoom=1;}if(has("webkit")){this._webkitListener=this.own(on(this.document,"mouseup",lang.hitch(this,"onDisplayChanged")))[0];this.own(on(this.document,"mousedown",lang.hitch(this,function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){this.defer("placeCursorAtEnd");}})));}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _423=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred&&!this.onLoadDeferred.isFulfilled()){this.onLoadDeferred.resolve(true);}this.onDisplayChanged();if(this.focusOnLoad){_3f7(lang.hitch(this,"defer","focus",this.updateInterval));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.then(_423);}else{_423();}},onKeyDown:function(e){if(e.keyCode===keys.SHIFT||e.keyCode===keys.ALT||e.keyCode===keys.META||e.keyCode===keys.CTRL){return true;}if(e.keyCode===keys.TAB&&this.isTabIndent){e.stopPropagation();e.preventDefault();if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(e.keyCode==keys.TAB&&!this.isTabIndent&&!e.ctrlKey&&!e.altKey){if(e.shiftKey){this.beforeIframeNode.focus();}else{this.afterIframeNode.focus();}return true;}if(has("ie")<9&&e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){e.stopPropagation();e.preventDefault();this.execCommand("delete");}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}var _424=this._keyHandlers[e.keyCode],args=arguments;if(_424&&!e.altKey){_3ec.some(_424,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}this.defer("onKeyPressed",1);return true;},onKeyUp:function(){},setDisabled:function(_425){_3f5.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_425);},_setValueAttr:function(_426){this.setValue(_426);},_setDisableSpellCheckAttr:function(_427){if(this.document){_3f0.set(this.document.body,"spellcheck",!_427);}else{this.onLoadDeferred.then(lang.hitch(this,function(){_3f0.set(this.document.body,"spellcheck",!_427);}));}this._set("disableSpellCheck",_427);},addKeyHandler:function(key,ctrl,_428,_429){if(typeof key=="string"){key=key.toUpperCase().charCodeAt(0);}if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:_428||false,ctrl:ctrl||false,handler:_429});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){if(has("ie")||has("trident")){this.defer(function(){if(!_401.curNode){this.ownerDocumentBody.focus();}});}this.inherited(arguments);var _42a=this.getValue(true);if(_42a!==this.value){this.onChange(_42a);}this._set("value",_42a);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(this.ownerDocumentBody.focus){this.ownerDocumentBody.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(has("ie")<9){this.iframe.fireEvent("onfocus",document.createEventObject());}else{this.editNode.focus();}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){this._updateTimer.remove();}this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_42b){var _42c=cmd.toLowerCase();if(_42c==="formatblock"){if(has("safari")&&_42b===undefined){_42c="heading";}}else{if(_42c==="hilitecolor"&&!has("mozilla")){_42c="backcolor";}}return _42c;},_qcaCache:{},queryCommandAvailable:function(_42d){var ca=this._qcaCache[_42d];if(ca!==undefined){return ca;}return (this._qcaCache[_42d]=this._queryCommandAvailable(_42d));},_queryCommandAvailable:function(_42e){var ie=1;var _42f=1<<1;var _430=1<<2;var _431=1<<3;function _432(_433){return {ie:Boolean(_433&ie),mozilla:Boolean(_433&_42f),webkit:Boolean(_433&_430),opera:Boolean(_433&_431)};};var _434=null;switch(_42e.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":_434=_432(_42f|ie|_430|_431);break;case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":_434=_432(_42f|ie|_431|_430);break;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":_434=_432(ie);break;case "cut":case "copy":case "paste":_434=_432(ie|_42f|_430|_431);break;case "inserttable":_434=_432(_42f|ie);break;case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":_434=_432(ie|_42f);break;default:return false;}return ((has("ie")||has("trident"))&&_434.ie)||(has("mozilla")&&_434.mozilla)||(has("webkit")&&_434.webkit)||(has("opera")&&_434.opera);},execCommand:function(_435,_436){var _437;if(this.focused){this.focus();}_435=this._normalizeCommand(_435,_436);if(_436!==undefined){if(_435==="heading"){throw new Error("unimplemented");}else{if(_435==="formatblock"&&(has("ie")||has("trident"))){_436="<"+_436+">";}}}var _438="_"+_435+"Impl";if(this[_438]){_437=this[_438](_436);}else{_436=arguments.length>1?_436:null;if(_436||_435!=="createlink"){_437=this.document.execCommand(_435,false,_436);}}this.onDisplayChanged();return _437;},queryCommandEnabled:function(_439){if(this.disabled||!this._disabledOK){return false;}_439=this._normalizeCommand(_439);var _43a="_"+_439+"EnabledImpl";if(this[_43a]){return this[_43a](_439);}else{return this._browserQueryCommandEnabled(_439);}},queryCommandState:function(_43b){if(this.disabled||!this._disabledOK){return false;}_43b=this._normalizeCommand(_43b);try{return this.document.queryCommandState(_43b);}catch(e){return false;}},queryCommandValue:function(_43c){if(this.disabled||!this._disabledOK){return false;}var r;_43c=this._normalizeCommand(_43c);if((has("ie")||has("trident"))&&_43c==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_43c)];}else{if(has("mozilla")&&_43c==="hilitecolor"){var _43d;try{_43d=this.document.queryCommandValue("styleWithCSS");}catch(e){_43d=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_43c);this.document.execCommand("styleWithCSS",false,_43d);}else{r=this.document.queryCommandValue(_43c);}}return r;},_sCall:function(name,args){return this.selection[name].apply(this.selection,args);},placeCursorAtStart:function(){this.focus();var _43e=false;if(has("mozilla")){var _43f=this.editNode.firstChild;while(_43f){if(_43f.nodeType===3){if(_43f.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_43e=true;this.selection.selectElement(_43f);break;}}else{if(_43f.nodeType===1){_43e=true;var tg=_43f.tagName?_43f.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this.selection.selectElement(_43f);}else{this.selection.selectElementChildren(_43f);}break;}}_43f=_43f.nextSibling;}}else{_43e=true;this.selection.selectElementChildren(this.editNode);}if(_43e){this.selection.collapse(true);}},placeCursorAtEnd:function(){this.focus();var _440=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_440=true;this.selection.selectElement(last);break;}}else{if(last.nodeType===1){_440=true;this.selection.selectElement(last.lastChild||last);break;}}last=last.previousSibling;}}else{_440=true;this.selection.selectElementChildren(this.editNode);}if(_440){this.selection.collapse(false);}},getValue:function(_441){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this.isLoaded?this._postFilterContent(null,_441):this.value;},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.then(lang.hitch(this,function(){this.setValue(html);}));return;}if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;_3ec.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;_3ec.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_442){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_442){dom=lang.clone(dom);}_3ec.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_400.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}_3ec.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _443=dom.byId(_402._scopeName+"._editor.RichText.value");if(_443){if(_443.value){_443.value+=this._SEPARATOR;}_443.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_444){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_444){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_3f5.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _400.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_3f5.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _400.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this._webkitListener.remove();delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_3f2.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_3f1.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){this._updateTimer.remove();}this.inherited(arguments);if(_403._globalSaveHandler){delete _403._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_445){if(!_445){return false;}var elem=has("ie")<9?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_445);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _446=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_446=true;}else{_446=this.document.queryCommandEnabled("createlink");}}else{_446=this._browserQueryCommandEnabled("createlink");}return _446;},_unlinkEnabledImpl:function(){var _447=true;if(has("mozilla")||has("webkit")){_447=this.selection.hasAncestorElement("a");}else{_447=this._browserQueryCommandEnabled("unlink");}return _447;},_inserttableEnabledImpl:function(){var _448=true;if(has("mozilla")||has("webkit")){_448=true;}else{_448=this._browserQueryCommandEnabled("inserttable");}return _448;},_cutEnabledImpl:function(){var _449=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_449=!!sel;}else{_449=this._browserQueryCommandEnabled("cut");}return _449;},_copyEnabledImpl:function(){var _44a=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_44a=!!sel;}else{_44a=this._browserQueryCommandEnabled("copy");}return _44a;},_pasteEnabledImpl:function(){var _44b=true;if(has("webkit")){return true;}else{_44b=this._browserQueryCommandEnabled("paste");}return _44b;},_inserthorizontalruleImpl:function(_44c){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_44c);},_unlinkImpl:function(_44d){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this.selection.getAncestorElement("a");this.selection.selectElement(a);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_44d);},_hilitecolorImpl:function(_44e){var _44f;var _450=this._handleTextColorOrProperties("hilitecolor",_44e);if(!_450){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_44f=this.document.execCommand("hilitecolor",false,_44e);this.document.execCommand("styleWithCSS",false,false);}else{_44f=this.document.execCommand("hilitecolor",false,_44e);}}return _44f;},_backcolorImpl:function(_451){if(has("ie")){_451=_451?_451:null;}var _452=this._handleTextColorOrProperties("backcolor",_451);if(!_452){_452=this.document.execCommand("backcolor",false,_451);}return _452;},_forecolorImpl:function(_453){if(has("ie")){_453=_453?_453:null;}var _454=false;_454=this._handleTextColorOrProperties("forecolor",_453);if(!_454){_454=this.document.execCommand("forecolor",false,_453);}return _454;},_inserthtmlImpl:function(_455){_455=this._preFilterContent(_455);var rv=true;if(has("ie")<9){var _456=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_456.item(0);while(_456.length){_456.remove(_456.item(0));}n.outerHTML=_455;}else{_456.pasteHTML(_455);}_456.select();}else{if(has("trident")<8){var _456;var _457=_3ff.getSelection(this.window);if(_457&&_457.rangeCount&&_457.getRangeAt){_456=_457.getRangeAt(0);_456.deleteContents();var div=_3f2.create("div");div.innerHTML=_455;var node,_458;var n=this.document.createDocumentFragment();while((node=div.firstChild)){_458=n.appendChild(node);}_456.insertNode(n);if(_458){_456=_456.cloneRange();_456.setStartAfter(_458);_456.collapse(false);_457.removeAllRanges();_457.addRange(_456);}}}else{if(has("mozilla")&&!_455.length){this.selection.remove();}else{rv=this.document.execCommand("inserthtml",false,_455);}}}return rv;},_boldImpl:function(_459){var _45a=false;if(has("ie")){this._adaptIESelection();_45a=this._adaptIEFormatAreaAndExec("bold");}if(!_45a){_45a=this.document.execCommand("bold",false,_459);}return _45a;},_italicImpl:function(_45b){var _45c=false;if(has("ie")){this._adaptIESelection();_45c=this._adaptIEFormatAreaAndExec("italic");}if(!_45c){_45c=this.document.execCommand("italic",false,_45b);}return _45c;},_underlineImpl:function(_45d){var _45e=false;if(has("ie")){this._adaptIESelection();_45e=this._adaptIEFormatAreaAndExec("underline");}if(!_45e){_45e=this.document.execCommand("underline",false,_45d);}return _45e;},_strikethroughImpl:function(_45f){var _460=false;if(has("ie")){this._adaptIESelection();_460=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_460){_460=this.document.execCommand("strikethrough",false,_45f);}return _460;},_superscriptImpl:function(_461){var _462=false;if(has("ie")){this._adaptIESelection();_462=this._adaptIEFormatAreaAndExec("superscript");}if(!_462){_462=this.document.execCommand("superscript",false,_461);}return _462;},_subscriptImpl:function(_463){var _464=false;if(has("ie")){this._adaptIESelection();_464=this._adaptIEFormatAreaAndExec("subscript");}if(!_464){_464=this.document.execCommand("subscript",false,_463);}return _464;},_fontnameImpl:function(_465){var _466;if(has("ie")){_466=this._handleTextColorOrProperties("fontname",_465);}if(!_466){_466=this.document.execCommand("fontname",false,_465);}return _466;},_fontsizeImpl:function(_467){var _468;if(has("ie")){_468=this._handleTextColorOrProperties("fontsize",_467);}if(!_468){_468=this.document.execCommand("fontsize",false,_467);}return _468;},_insertorderedlistImpl:function(_469){var _46a=false;if(has("ie")){_46a=this._adaptIEList("insertorderedlist",_469);}if(!_46a){_46a=this.document.execCommand("insertorderedlist",false,_469);}return _46a;},_insertunorderedlistImpl:function(_46b){var _46c=false;if(has("ie")){_46c=this._adaptIEList("insertunorderedlist",_46b);}if(!_46c){_46c=this.document.execCommand("insertunorderedlist",false,_46b);}return _46c;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_3f3.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_46d){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_46d);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_46d)==="");}}return false;},_removeStartingRangeFromRange:function(node,_46e){if(node.nextSibling){_46e.setStart(node.nextSibling,0);}else{var _46f=node.parentNode;while(_46f&&_46f.nextSibling==null){_46f=_46f.parentNode;}if(_46f){_46e.setStart(_46f.nextSibling,0);}}return _46e;},_adaptIESelection:function(){var _470=_3ff.getSelection(this.window);if(_470&&_470.rangeCount&&!_470.isCollapsed){var _471=_470.getRangeAt(0);var _472=_471.startContainer;var _473=_471.startOffset;while(_472.nodeType===3&&_473>=_472.length&&_472.nextSibling){_473=_473-_472.length;_472=_472.nextSibling;}var _474=null;while(this._isNodeEmpty(_472,_473)&&_472!==_474){_474=_472;_471=this._removeStartingRangeFromRange(_472,_471);_472=_471.startContainer;_473=0;}_470.removeAllRanges();_470.addRange(_471);}},_adaptIEFormatAreaAndExec:function(_475){var _476=_3ff.getSelection(this.window);var doc=this.document;var rs,ret,_477,txt,_478,_479,_47a,_47b;if(_475&&_476&&_476.isCollapsed){var _47c=this.queryCommandValue(_475);if(_47c){var _47d=this._tagNamesForCommand(_475);_477=_476.getRangeAt(0);var fs=_477.startContainer;if(fs.nodeType===3){var _47e=_477.endOffset;if(fs.length<_47e){ret=this._adjustNodeAndOffset(rs,_47e);fs=ret.node;_47e=ret.offset;}}var _47f;while(fs&&fs!==this.editNode){var _480=fs.tagName?fs.tagName.toLowerCase():"";if(_3ec.indexOf(_47d,_480)>-1){_47f=fs;break;}fs=fs.parentNode;}if(_47f){rs=_477.startContainer;var _481=doc.createElement(_47f.tagName);_3f2.place(_481,_47f,"after");if(rs&&rs.nodeType===3){var _482,_483;var _484=_477.endOffset;if(rs.length<_484){ret=this._adjustNodeAndOffset(rs,_484);rs=ret.node;_484=ret.offset;}txt=rs.nodeValue;_478=doc.createTextNode(txt.substring(0,_484));var _485=txt.substring(_484,txt.length);if(_485){_479=doc.createTextNode(_485);}_3f2.place(_478,rs,"before");if(_479){_47a=doc.createElement("span");_47a.className="ieFormatBreakerSpan";_3f2.place(_47a,rs,"after");_3f2.place(_479,_47a,"after");_479=_47a;}_3f2.destroy(rs);var _486=_478.parentNode;var _487=[];var _488;while(_486!==_47f){var tg=_486.tagName;_488={tagName:tg};_487.push(_488);var _489=doc.createElement(tg);if(_486.style){if(_489.style){if(_486.style.cssText){_489.style.cssText=_486.style.cssText;_488.cssText=_486.style.cssText;}}}if(_486.tagName==="FONT"){if(_486.color){_489.color=_486.color;_488.color=_486.color;}if(_486.face){_489.face=_486.face;_488.face=_486.face;}if(_486.size){_489.size=_486.size;_488.size=_486.size;}}if(_486.className){_489.className=_486.className;_488.className=_486.className;}if(_479){_482=_479;while(_482){_483=_482.nextSibling;_489.appendChild(_482);_482=_483;}}if(_489.tagName==_486.tagName){_47a=doc.createElement("span");_47a.className="ieFormatBreakerSpan";_3f2.place(_47a,_486,"after");_3f2.place(_489,_47a,"after");}else{_3f2.place(_489,_486,"after");}_478=_486;_479=_489;_486=_486.parentNode;}if(_479){_482=_479;if(_482.nodeType===1||(_482.nodeType===3&&_482.nodeValue)){_481.innerHTML="";}while(_482){_483=_482.nextSibling;_481.appendChild(_482);_482=_483;}}var _48a;if(_487.length){_488=_487.pop();var _48b=doc.createElement(_488.tagName);if(_488.cssText&&_48b.style){_48b.style.cssText=_488.cssText;}if(_488.className){_48b.className=_488.className;}if(_488.tagName==="FONT"){if(_488.color){_48b.color=_488.color;}if(_488.face){_48b.face=_488.face;}if(_488.size){_48b.size=_488.size;}}_3f2.place(_48b,_481,"before");while(_487.length){_488=_487.pop();var _48c=doc.createElement(_488.tagName);if(_488.cssText&&_48c.style){_48c.style.cssText=_488.cssText;}if(_488.className){_48c.className=_488.className;}if(_488.tagName==="FONT"){if(_488.color){_48c.color=_488.color;}if(_488.face){_48c.face=_488.face;}if(_488.size){_48c.size=_488.size;}}_48b.appendChild(_48c);_48b=_48c;}_47b=doc.createTextNode(".");_47a.appendChild(_47b);_48b.appendChild(_47b);_48a=_3ff.create(this.window);_48a.setStart(_47b,0);_48a.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_48a);this.selection.collapse(false);_47b.parentNode.innerHTML="";}else{_47a=doc.createElement("span");_47a.className="ieFormatBreakerSpan";_47b=doc.createTextNode(".");_47a.appendChild(_47b);_3f2.place(_47a,_481,"before");_48a=_3ff.create(this.window);_48a.setStart(_47b,0);_48a.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_48a);this.selection.collapse(false);_47b.parentNode.innerHTML="";}if(!_481.firstChild){_3f2.destroy(_481);}return true;}}return false;}else{_477=_476.getRangeAt(0);rs=_477.startContainer;if(rs&&rs.nodeType===3){var _47e=_477.startOffset;if(rs.length<_47e){ret=this._adjustNodeAndOffset(rs,_47e);rs=ret.node;_47e=ret.offset;}txt=rs.nodeValue;_478=doc.createTextNode(txt.substring(0,_47e));var _485=txt.substring(_47e);if(_485!==""){_479=doc.createTextNode(txt.substring(_47e));}_47a=doc.createElement("span");_47b=doc.createTextNode(".");_47a.appendChild(_47b);if(_478.length){_3f2.place(_478,rs,"after");}else{_478=rs;}_3f2.place(_47a,_478,"after");if(_479){_3f2.place(_479,_47a,"after");}_3f2.destroy(rs);var _48a=_3ff.create(this.window);_48a.setStart(_47b,0);_48a.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_48a);doc.execCommand(_475);_3f2.place(_47a.firstChild,_47a,"before");_3f2.destroy(_47a);_48a.setStart(_47b,0);_48a.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_48a);this.selection.collapse(false);_47b.parentNode.innerHTML="";return true;}}}else{return false;}},_adaptIEList:function(_48d){var _48e=_3ff.getSelection(this.window);if(_48e.isCollapsed){if(_48e.rangeCount&&!this.queryCommandValue(_48d)){var _48f=_48e.getRangeAt(0);var sc=_48f.startContainer;if(sc&&sc.nodeType==3){if(!_48f.startOffset){var _490="ul";if(_48d==="insertorderedlist"){_490="ol";}var list=this.document.createElement(_490);var li=_3f2.create("li",null,list);_3f2.place(list,sc,"before");li.appendChild(sc);_3f2.create("br",null,list,"after");var _491=_3ff.create(this.window);_491.setStart(sc,0);_491.setEnd(sc,sc.length);_48e.removeAllRanges();_48e.addRange(_491);this.selection.collapse(true);return true;}}}}return false;},_handleTextColorOrProperties:function(_492,_493){var _494=_3ff.getSelection(this.window);var doc=this.document;var rs,ret,_495,txt,_496,_497,_498,_499;_493=_493||null;if(_492&&_494&&_494.isCollapsed){if(_494.rangeCount){_495=_494.getRangeAt(0);rs=_495.startContainer;if(rs&&rs.nodeType===3){var _49a=_495.startOffset;if(rs.length<_49a){ret=this._adjustNodeAndOffset(rs,_49a);rs=ret.node;_49a=ret.offset;}txt=rs.nodeValue;_496=doc.createTextNode(txt.substring(0,_49a));var _49b=txt.substring(_49a);if(_49b!==""){_497=doc.createTextNode(txt.substring(_49a));}_498=doc.createElement("span");_499=doc.createTextNode(".");_498.appendChild(_499);var _49c=doc.createElement("span");_498.appendChild(_49c);if(_496.length){_3f2.place(_496,rs,"after");}else{_496=rs;}_3f2.place(_498,_496,"after");if(_497){_3f2.place(_497,_498,"after");}_3f2.destroy(rs);var _49d=_3ff.create(this.window);_49d.setStart(_499,0);_49d.setEnd(_499,_499.length);_494.removeAllRanges();_494.addRange(_49d);if(has("webkit")){var _49e="color";if(_492==="hilitecolor"||_492==="backcolor"){_49e="backgroundColor";}_3f4.set(_498,_49e,_493);this.selection.remove();_3f2.destroy(_49c);_498.innerHTML="&#160;";this.selection.selectElement(_498);this.focus();}else{this.execCommand(_492,_493);_3f2.place(_498.firstChild,_498,"before");_3f2.destroy(_498);_49d.setStart(_499,0);_49d.setEnd(_499,_499.length);_494.removeAllRanges();_494.addRange(_49d);this.selection.collapse(false);_499.parentNode.removeChild(_499);}return true;}}}return false;},_adjustNodeAndOffset:function(node,_49f){while(node.length<_49f&&node.nextSibling&&node.nextSibling.nodeType===3){_49f=_49f-node.length;node=node.nextSibling;}return {"node":node,"offset":_49f};},_tagNamesForCommand:function(_4a0){if(_4a0==="bold"){return ["b","strong"];}else{if(_4a0==="italic"){return ["i","em"];}else{if(_4a0==="strikethrough"){return ["s","strike"];}else{if(_4a0==="superscript"){return ["sup"];}else{if(_4a0==="subscript"){return ["sub"];}else{if(_4a0==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){if(!this.isLoaded){return;}_3f6(".ieFormatBreakerSpan",node).forEach(function(b){while(b.firstChild){_3f2.place(b.firstChild,b,"before");}_3f2.destroy(b);});return node;},_stripTrailingEmptyNodes:function(node){function _4a1(node){return (/^(p|div|br)$/i.test(node.nodeName)&&node.children.length==0&&/^[\s\xA0]*$/.test(node.textContent||node.innerText||""))||(node.nodeType===3&&/^[\s\xA0]*$/.test(node.nodeValue));};while(node.lastChild&&_4a1(node.lastChild)){_3f2.destroy(node.lastChild);}return node;},_setTextDirAttr:function(_4a2){this._set("textDir",_4a2);this.onLoadDeferred.then(lang.hitch(this,function(){this.editNode.dir=_4a2;}));}});return _403;});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_4a3,_4a4,lang,dom,_4a5,_4a6,on,_4a7,_4a8,dnd,_4a9,win){var _4aa=_4a4("dojo.dnd.Moveable",[_4a6],{handle:"",delay:0,skip:false,constructor:function(node,_4ab){this.node=dom.byId(node);if(!_4ab){_4ab={};}this.handle=_4ab.handle?dom.byId(_4ab.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_4ab.delay>0?_4ab.delay:0;this.skip=_4ab.skip;this.mover=_4ab.mover?_4ab.mover:_4a9;this.events=[on(this.handle,_4a8.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_4ac,node,Ctor){return new Ctor(node,_4ac);},destroy:function(){_4a3.forEach(this.events,function(_4ad){_4ad.remove();});this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_4a8.move,lang.hitch(this,"onMouseMove")),on(this.handle,_4a8.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_4ae){_4a7.publish("/dnd/move/start",_4ae);_4a5.add(win.body(),"dojoMove");_4a5.add(this.node,"dojoMoveItem");},onMoveStop:function(_4af){_4a7.publish("/dnd/move/stop",_4af);_4a5.remove(win.body(),"dojoMove");_4a5.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_4b0,_4b1){this.onMoving(_4b0,_4b1);var s=_4b0.node.style;s.left=_4b1.l+"px";s.top=_4b1.t+"px";this.onMoved(_4b0,_4b1);},onMoving:function(){},onMoved:function(){}});return _4aa;});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_4b2,_4b3,has,keys,lang,on,_4b4,_4b5,_4b6,_4b7,_4b8,_4b9,_4ba){var _4bb=_4b2("dijit.TooltipDialog",[_4b5,_4b8,_4b7,_4b6],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_4b9,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_4bc,_4bd){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_4bc+"-"+_4bd];_4b3.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems();_4b4.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _4be=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_4be.y+((_4be.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_4be.x+((_4be.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems();if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_4b4.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_4b4.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_4bb.extend({_setTitleAttr:function(_4bf){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,_4bf):_4bf;this._set("title",_4bf);},_setTextDirAttr:function(_4c0){if(!this._created||this.textDir!=_4c0){this._set("textDir",_4c0);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _4bb;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_4c1){return function(_4c2,_4c3){switch(typeof _4c2){default:throw new Error("Can not query with a "+typeof _4c2);case "object":case "undefined":var _4c4=_4c2;_4c2=function(_4c5){for(var key in _4c4){var _4c6=_4c4[key];if(_4c6&&_4c6.test){if(!_4c6.test(_4c5[key],_4c5)){return false;}}else{if(_4c6!=_4c5[key]){return false;}}}return true;};break;case "string":if(!this[_4c2]){throw new Error("No filter function "+_4c2+" was found in store");}_4c2=this[_4c2];case "function":}function _4c7(_4c8){var _4c9=_4c1.filter(_4c8,_4c2);var _4ca=_4c3&&_4c3.sort;if(_4ca){_4c9.sort(typeof _4ca=="function"?_4ca:function(a,b){for(var sort,i=0;sort=_4ca[i];i++){var _4cb=a[sort.attribute];var _4cc=b[sort.attribute];_4cb=_4cb!=null?_4cb.valueOf():_4cb;_4cc=_4cc!=null?_4cc.valueOf():_4cc;if(_4cb!=_4cc){return !!sort.descending==(_4cb==null||_4cb>_4cc)?-1:1;}}return 0;});}if(_4c3&&(_4c3.start||_4c3.count)){var _4cd=_4c9.length;_4c9=_4c9.slice(_4c3.start||0,(_4c3.start||0)+(_4c3.count||Infinity));_4c9.total=_4cd;}return _4c9;};_4c7.matches=_4c2;return _4c7;};});},"dijit/form/_ExpandingTextAreaMixin":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/_base/window","../Viewport"],function(_4ce,_4cf,has,lang,on,win,_4d0){has.add("textarea-needs-help-shrinking",function(){var body=win.body(),te=_4cf.create("textarea",{rows:"5",cols:"20",value:" ",style:{zoom:1,fontSize:"12px",height:"96px",overflow:"hidden",visibility:"hidden",position:"absolute",border:"5px solid white",margin:"0",padding:"0",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"}},body,"last");var _4d1=te.scrollHeight>=te.clientHeight;body.removeChild(te);return _4d1;});return _4ce("dijit.form._ExpandingTextAreaMixin",null,{_setValueAttr:function(){this.inherited(arguments);this.resize();},postCreate:function(){this.inherited(arguments);var _4d2=this.textbox;_4d2.style.overflowY="hidden";this.own(on(_4d2,"focus, resize",lang.hitch(this,"_resizeLater")));},startup:function(){this.inherited(arguments);this.own(_4d0.on("resize",lang.hitch(this,"_resizeLater")));this._resizeLater();},_onInput:function(e){this.inherited(arguments);this.resize();},_estimateHeight:function(){var _4d3=this.textbox;_4d3.rows=(_4d3.value.match(/\n/g)||[]).length+1;},_resizeLater:function(){this.defer("resize");},resize:function(){var _4d4=this.textbox;function _4d5(){var _4d6=false;if(_4d4.value===""){_4d4.value=" ";_4d6=true;}var sh=_4d4.scrollHeight;if(_4d6){_4d4.value="";}return sh;};if(_4d4.style.overflowY=="hidden"){_4d4.scrollTop=0;}if(this.busyResizing){return;}this.busyResizing=true;if(_4d5()||_4d4.offsetHeight){var newH=_4d5()+Math.max(_4d4.offsetHeight-_4d4.clientHeight,0);var _4d7=newH+"px";if(_4d7!=_4d4.style.height){_4d4.style.height=_4d7;_4d4.rows=1;}if(has("textarea-needs-help-shrinking")){var _4d8=_4d5(),_4d9=_4d8,_4da=_4d4.style.minHeight,_4db=4,_4dc,_4dd=_4d4.scrollTop;_4d4.style.minHeight=_4d7;_4d4.style.height="auto";while(newH>0){_4d4.style.minHeight=Math.max(newH-_4db,4)+"px";_4dc=_4d5();var _4de=_4d9-_4dc;newH-=_4de;if(_4de<_4db){break;}_4d9=_4dc;_4db<<=1;}_4d4.style.height=newH+"px";_4d4.style.minHeight=_4da;_4d4.scrollTop=_4dd;}_4d4.style.overflowY=_4d5()>_4d4.clientHeight?"auto":"hidden";if(_4d4.style.overflowY=="hidden"){_4d4.scrollTop=0;}}else{this._estimateHeight();}this.busyResizing=false;}});});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_4df,dom,_4e0,_4e1,_4e2,has,lang,_4e3,_4e4,_4e5,_4e6,_4e7){var _4e8=_4df("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_4e3,_4e4,_4e5,_4e6],{templateString:_4e7,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _4e9="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_4e9=val.charAt(ndx+1);var _4ea=val.substr(0,ndx);var _4eb=val.substr(ndx+3);text=_4ea+_4e9+_4eb;val=_4ea+"<span class=\"dijitMenuItemShortcutKey\">"+_4e9+"</span>"+_4eb;}else{text=val;}this.domNode.setAttribute("aria-label",text+" "+this.accelKey);this.containerNode.innerHTML=val;this._set("shortcutKey",_4e9);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_4ec){if(_4ec&&!("label" in this.params)){this._set("label",_4ec.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _4ed=this.id+"_text";_4e0.set(this.containerNode,"id",_4ed);if(this.accelKeyNode){_4e0.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_setSelected:function(_4ee){_4e1.toggle(this.domNode,"dijitMenuItemSelected",_4ee);},setLabel:function(_4ef){_4e2.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_4ef);},setDisabled:function(_4f0){_4e2.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_4f0);},_setDisabledAttr:function(_4f1){this.focusNode.setAttribute("aria-disabled",_4f1?"true":"false");this._set("disabled",_4f1);},_setAccelKeyAttr:function(_4f2){if(this.accelKeyNode){this.accelKeyNode.style.display=_4f2?"":"none";this.accelKeyNode.innerHTML=_4f2;_4e0.set(this.containerNode,"colSpan",_4f2?"1":"2");}this._set("accelKey",_4f2);}});if(has("dojo-bidi")){_4e8=_4df("dijit.MenuItem",_4e8,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _4e8;});},"dijit/MenuBarItem":function(){define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_4f3,_4f4,_4f5){var _4f6=_4f3("dijit._MenuBarItemMixin",null,{templateString:_4f5,_setIconClassAttr:null});var _4f7=_4f3("dijit.MenuBarItem",[_4f4,_4f6],{});_4f7._MenuBarItemMixin=_4f6;return _4f7;});},"dijit/layout/TabController":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/has","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_4f8,dom,_4f9,_4fa,has,i18n,lang,_4fb,_4fc,Menu,_4fd,_4fe){var _4ff=_4f8("dijit.layout._TabButton"+(has("dojo-bidi")?"_NoBidi":""),_4fb.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_4fe,_setNameAttr:"focusNode",scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;this.defer(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_4fa.toggle(this.domNode,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _500=i18n.getLocalization("dijit","common");if(this.closeNode){_4f9.set(this.closeNode,"title",_500.itemClose);}}},_setDisabledAttr:function(_501){this.inherited(arguments);if(this.closeNode){if(_501){_4f9.remove(this.closeNode,"title");}else{var _502=i18n.getLocalization("dijit","common");_4f9.set(this.closeNode,"title",_502.itemClose);}}},_setLabelAttr:function(_503){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_4ff=_4f8("dijit.layout._TabButton",_4ff,{_setLabelAttr:function(_504){this.inherited(arguments);this.applyTextDir(this.iconNode,this.iconNode.alt);}});}var _505=_4f8("dijit.layout.TabController",_4fb,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'></div>",tabPosition:"top",buttonWidget:_4ff,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){this.inherited(arguments);var _506=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){return _4fa.contains(node,"dijitClosable")&&!_4fa.contains(node,"dijitTabDisabled");}});this.own(_506);var _507=i18n.getLocalization("dijit","common"),_508=this;_506.addChild(new _4fd({label:_507.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){var _509=_4fc.byNode(this.getParent().currentTarget);_508.onCloseButtonClick(_509.page);}}));}});_505.TabButton=_4ff;return _505;});},"dojo/cldr/supplemental":function(){define(["../_base/lang","../i18n"],function(lang,i18n){var _50a={};lang.setObject("dojo.cldr.supplemental",_50a);_50a.getFirstDayOfWeek=function(_50b){var _50c={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};var _50d=_50a._region(_50b);var dow=_50c[_50d];return (dow===undefined)?1:dow;};_50a._region=function(_50e){_50e=i18n.normalizeLocale(_50e);var tags=_50e.split("-");var _50f=tags[1];if(!_50f){_50f={aa:"et",ab:"ge",af:"za",ak:"gh",am:"et",ar:"eg",as:"in",av:"ru",ay:"bo",az:"az",ba:"ru",be:"by",bg:"bg",bi:"vu",bm:"ml",bn:"bd",bo:"cn",br:"fr",bs:"ba",ca:"es",ce:"ru",ch:"gu",co:"fr",cr:"ca",cs:"cz",cv:"ru",cy:"gb",da:"dk",de:"de",dv:"mv",dz:"bt",ee:"gh",el:"gr",en:"us",es:"es",et:"ee",eu:"es",fa:"ir",ff:"sn",fi:"fi",fj:"fj",fo:"fo",fr:"fr",fy:"nl",ga:"ie",gd:"gb",gl:"es",gn:"py",gu:"in",gv:"gb",ha:"ng",he:"il",hi:"in",ho:"pg",hr:"hr",ht:"ht",hu:"hu",hy:"am",ia:"fr",id:"id",ig:"ng",ii:"cn",ik:"us","in":"id",is:"is",it:"it",iu:"ca",iw:"il",ja:"jp",ji:"ua",jv:"id",jw:"id",ka:"ge",kg:"cd",ki:"ke",kj:"na",kk:"kz",kl:"gl",km:"kh",kn:"in",ko:"kr",ks:"in",ku:"tr",kv:"ru",kw:"gb",ky:"kg",la:"va",lb:"lu",lg:"ug",li:"nl",ln:"cd",lo:"la",lt:"lt",lu:"cd",lv:"lv",mg:"mg",mh:"mh",mi:"nz",mk:"mk",ml:"in",mn:"mn",mo:"ro",mr:"in",ms:"my",mt:"mt",my:"mm",na:"nr",nb:"no",nd:"zw",ne:"np",ng:"na",nl:"nl",nn:"no",no:"no",nr:"za",nv:"us",ny:"mw",oc:"fr",om:"et",or:"in",os:"ge",pa:"in",pl:"pl",ps:"af",pt:"br",qu:"pe",rm:"ch",rn:"bi",ro:"ro",ru:"ru",rw:"rw",sa:"in",sd:"in",se:"no",sg:"cf",si:"lk",sk:"sk",sl:"si",sm:"ws",sn:"zw",so:"so",sq:"al",sr:"rs",ss:"za",st:"za",su:"id",sv:"se",sw:"tz",ta:"in",te:"in",tg:"tj",th:"th",ti:"et",tk:"tm",tl:"ph",tn:"za",to:"to",tr:"tr",ts:"za",tt:"ru",ty:"pf",ug:"cn",uk:"ua",ur:"pk",uz:"uz",ve:"za",vi:"vn",wa:"be",wo:"sn",xh:"za",yi:"il",yo:"ng",za:"cn",zh:"cn",zu:"za",ace:"id",ady:"ru",agq:"cm",alt:"ru",amo:"ng",asa:"tz",ast:"es",awa:"in",bal:"pk",ban:"id",bas:"cm",bax:"cm",bbc:"id",bem:"zm",bez:"tz",bfq:"in",bft:"pk",bfy:"in",bhb:"in",bho:"in",bik:"ph",bin:"ng",bjj:"in",bku:"ph",bqv:"ci",bra:"in",brx:"in",bss:"cm",btv:"pk",bua:"ru",buc:"yt",bug:"id",bya:"id",byn:"er",cch:"ng",ccp:"in",ceb:"ph",cgg:"ug",chk:"fm",chm:"ru",chp:"ca",chr:"us",cja:"kh",cjm:"vn",ckb:"iq",crk:"ca",csb:"pl",dar:"ru",dav:"ke",den:"ca",dgr:"ca",dje:"ne",doi:"in",dsb:"de",dua:"cm",dyo:"sn",dyu:"bf",ebu:"ke",efi:"ng",ewo:"cm",fan:"gq",fil:"ph",fon:"bj",fur:"it",gaa:"gh",gag:"md",gbm:"in",gcr:"gf",gez:"et",gil:"ki",gon:"in",gor:"id",grt:"in",gsw:"ch",guz:"ke",gwi:"ca",haw:"us",hil:"ph",hne:"in",hnn:"ph",hoc:"in",hoj:"in",ibb:"ng",ilo:"ph",inh:"ru",jgo:"cm",jmc:"tz",kaa:"uz",kab:"dz",kaj:"ng",kam:"ke",kbd:"ru",kcg:"ng",kde:"tz",kdt:"th",kea:"cv",ken:"cm",kfo:"ci",kfr:"in",kha:"in",khb:"cn",khq:"ml",kht:"in",kkj:"cm",kln:"ke",kmb:"ao",koi:"ru",kok:"in",kos:"fm",kpe:"lr",krc:"ru",kri:"sl",krl:"ru",kru:"in",ksb:"tz",ksf:"cm",ksh:"de",kum:"ru",lag:"tz",lah:"pk",lbe:"ru",lcp:"cn",lep:"in",lez:"ru",lif:"np",lis:"cn",lki:"ir",lmn:"in",lol:"cd",lua:"cd",luo:"ke",luy:"ke",lwl:"th",mad:"id",mag:"in",mai:"in",mak:"id",man:"gn",mas:"ke",mdf:"ru",mdh:"ph",mdr:"id",men:"sl",mer:"ke",mfe:"mu",mgh:"mz",mgo:"cm",min:"id",mni:"in",mnk:"gm",mnw:"mm",mos:"bf",mua:"cm",mwr:"in",myv:"ru",nap:"it",naq:"na",nds:"de","new":"np",niu:"nu",nmg:"cm",nnh:"cm",nod:"th",nso:"za",nus:"sd",nym:"tz",nyn:"ug",pag:"ph",pam:"ph",pap:"bq",pau:"pw",pon:"fm",prd:"ir",raj:"in",rcf:"re",rej:"id",rjs:"np",rkt:"in",rof:"tz",rwk:"tz",saf:"gh",sah:"ru",saq:"ke",sas:"id",sat:"in",saz:"in",sbp:"tz",scn:"it",sco:"gb",sdh:"ir",seh:"mz",ses:"ml",shi:"ma",shn:"mm",sid:"et",sma:"se",smj:"se",smn:"fi",sms:"fi",snk:"ml",srn:"sr",srr:"sn",ssy:"er",suk:"tz",sus:"gn",swb:"yt",swc:"cd",syl:"bd",syr:"sy",tbw:"ph",tcy:"in",tdd:"cn",tem:"sl",teo:"ug",tet:"tl",tig:"er",tiv:"ng",tkl:"tk",tmh:"ne",tpi:"pg",trv:"tw",tsg:"ph",tts:"th",tum:"mw",tvl:"tv",twq:"ne",tyv:"ru",tzm:"ma",udm:"ru",uli:"fm",umb:"ao",unr:"in",unx:"in",vai:"lr",vun:"tz",wae:"ch",wal:"et",war:"ph",xog:"ug",xsr:"np",yao:"mz",yap:"fm",yav:"cm",zza:"tr"}[tags[0]];}else{if(_50f.length==4){_50f=tags[2];}}return _50f;};_50a.getWeekend=function(_510){var _511={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_512={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_513=_50a._region(_510),_514=_511[_513],end=_512[_513];if(_514===undefined){_514=6;}if(end===undefined){end=0;}return {start:_514,end:end};};return _50a;});},"dijit/MenuBar":function(){define(["dojo/_base/declare","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_515,keys,_516,_517){return _515("dijit.MenuBar",_516,{templateString:_517,baseClass:"dijitMenuBar",popupDelay:0,_isMenuBar:true,_orient:["below"],_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}},focusChild:function(item){this.inherited(arguments);if(this.activated&&item.popup&&!item.disabled){this._openItemPopup(item,true);}},_onChildDeselect:function(item){if(this.currentPopupItem==item){this.currentPopupItem=null;item._closePopup();}this.inherited(arguments);},_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();},_onDownArrow:function(evt){this._moveToPopup(evt);},_onUpArrow:function(){},onItemClick:function(item,evt){if(item.popup&&item.popup.isShowingNow&&(!/^key/.test(evt.type)||evt.keyCode!==keys.DOWN_ARROW)){item.focusNode.focus();this._cleanUp(true);}else{this.inherited(arguments);}}});});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_518,dom,_519,_51a){return _518("dijit.ToolbarSeparator",[_519,_51a],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/layout/StackController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/touch"],function(_51b,_51c,_51d,_51e,keys,lang,on,_51f,_520,_521,_522,_523,_524,_525){var _526=_51c("dijit.layout._StackButton",_525,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");}});var _527=_51c("dijit.layout.StackController",[_522,_523,_524],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeydown'></span>",containerId:"",buttonWidget:_526,buttonWidgetCloseClass:"dijitStackCloseButton",pane2button:function(id){return _521.byId(this.id+"_"+id);},postCreate:function(){this.inherited(arguments);this.own(_51f.subscribe(this.containerId+"-startup",lang.hitch(this,"onStartup")),_51f.subscribe(this.containerId+"-addChild",lang.hitch(this,"onAddChild")),_51f.subscribe(this.containerId+"-removeChild",lang.hitch(this,"onRemoveChild")),_51f.subscribe(this.containerId+"-selectChild",lang.hitch(this,"onSelectChild")),_51f.subscribe(this.containerId+"-containerKeyDown",lang.hitch(this,"onContainerKeyDown")));this.containerNode.dojoClick=true;this.own(on(this.containerNode,"click",lang.hitch(this,function(evt){var _528=_521.getEnclosingWidget(evt.target);if(_528!=this.containerNode&&!_528.disabled&&_528.page){for(var _529=evt.target;_529!==this.containerNode;_529=_529.parentNode){if(_51d.contains(_529,this.buttonWidgetCloseClass)){this.onCloseButtonClick(_528.page);break;}else{if(_529==_528.domNode){this.onButtonClick(_528.page);break;}}}}})));},onStartup:function(info){this.textDir=info.textDir;_51b.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}var _52a=_521.byId(this.containerId).containerNode,_52b=lang.hitch(this,"pane2button"),_52c={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled","textdir":"textdir"},_52d=function(attr,_52e){return on(_52a,"attrmodified-"+attr,function(evt){var _52f=_52b(evt.detail&&evt.detail.widget&&evt.detail.widget.id);if(_52f){_52f.set(_52e,evt.detail.newValue);}});};for(var attr in _52c){this.own(_52d(attr,_52c[attr]));}},destroy:function(_530){this.destroyDescendants(_530);this.inherited(arguments);},onAddChild:function(page,_531){var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _532=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir||this.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});this.addChild(_532,_531);page.controlButton=_532;if(!this._currentChild){this.onSelectChild(page);}var _533=page._wrapper.getAttribute("aria-labelledby")?page._wrapper.getAttribute("aria-labelledby")+" "+_532.id:_532.id;page._wrapper.removeAttribute("aria-label");page._wrapper.setAttribute("aria-labelledby",_533);},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}var _534=this.pane2button(page.id);if(_534){this.removeChild(_534);_534.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _535=this.pane2button(this._currentChild.id);_535.set("checked",false);_535.focusNode.setAttribute("tabIndex","-1");}var _536=this.pane2button(page.id);_536.set("checked",true);this._currentChild=page;_536.focusNode.setAttribute("tabIndex","0");var _537=_521.byId(this.containerId);},onButtonClick:function(page){var _538=this.pane2button(page.id);_520.focus(_538.focusNode);if(this._currentChild&&this._currentChild.id===page.id){_538.set("checked",true);}var _539=_521.byId(this.containerId);_539.selectChild(page);},onCloseButtonClick:function(page){var _53a=_521.byId(this.containerId);_53a.closeChild(page);if(this._currentChild){var b=this.pane2button(this._currentChild.id);if(b){_520.focus(b.focusNode||b.domNode);}}},adjacent:function(_53b){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_53b=!_53b;}var _53c=this.getChildren();var idx=_51b.indexOf(_53c,this.pane2button(this._currentChild.id)),_53d=_53c[idx];var _53e;do{idx=(idx+(_53b?1:_53c.length-1))%_53c.length;_53e=_53c[idx];}while(_53e.disabled&&_53e!=_53d);return _53e;},onkeydown:function(e,_53f){if(this.disabled||e.altKey){return;}var _540=null;if(e.ctrlKey||!e._djpage){switch(e.keyCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_540=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_540=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_540=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_540=true;}break;case keys.HOME:var _541=this.getChildren();for(var idx=0;idx<_541.length;idx++){var _542=_541[idx];if(!_542.disabled){this.onButtonClick(_542.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.END:var _541=this.getChildren();for(var idx=_541.length-1;idx>=0;idx--){var _542=_541[idx];if(!_542.disabled){this.onButtonClick(_542.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.DELETE:case "W".charCodeAt(0):if(this._currentChild.closable&&(e.keyCode==keys.DELETE||e.ctrlKey)){this.onCloseButtonClick(this._currentChild);e.stopPropagation();e.preventDefault();}break;case keys.TAB:if(e.ctrlKey){this.onButtonClick(this.adjacent(!e.shiftKey).page);e.stopPropagation();e.preventDefault();}break;}if(_540!==null){this.onButtonClick(this.adjacent(_540).page);e.stopPropagation();e.preventDefault();}}},onContainerKeyDown:function(info){info.e._djpage=info.page;this.onkeydown(info.e);}});_527.StackButton=_526;return _527;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_543,_544,lang,has,win,dom,_545,_546,_547,on,_548,dnd,_549){return _544("dojo.dnd.Mover",[_547],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _54a(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_548.move,lang.hitch(this,"onFirstMove")),on(d,_548.move,lang.hitch(this,"onMouseMove")),on(d,_548.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_54a),on(d.body,"selectstart",_54a)];_549.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_549.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_545.getMarginBox(this.node);var b=win.doc.body;var bs=_546.getComputedStyle(b);var bm=_545.getMarginBox(b,bs);var bc=_545.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_543.forEach(this.events,function(_54b){_54b.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dijit/form/HorizontalRule":function(){define(["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_54c,_54d,_54e){return _54c("dijit.form.HorizontalRule",[_54d,_54e],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;},_isHorizontal:true,buildRendering:function(){this.inherited(arguments);var _54f;if(this.count==1){_54f=this._genHTML(50,0);}else{var i;var _550=100/(this.count-1);if(!this._isHorizontal||this.isLeftToRight()){_54f=this._genHTML(0,0);for(i=1;i<this.count-1;i++){_54f+=this._genHTML(_550*i,i);}_54f+=this._genHTML(100,this.count-1);}else{_54f=this._genHTML(100,0);for(i=1;i<this.count-1;i++){_54f+=this._genHTML(100-_550*i,i);}_54f+=this._genHTML(0,this.count-1);}}this.domNode.innerHTML=_54f;}});});},"dijit/layout/TabContainer":function(){define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_551,_552,_553,_554){return _551("dijit.layout.TabContainer",_552,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_555){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_553=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;return new _553({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_555);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_554:_553;}}});});},"dijit/form/_Spinner":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","dojo/on","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_556,keys,lang,has,_557,on,_558,_559,_55a,_55b){return _556("dijit.form._Spinner",_559,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_55a,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){return val;},_arrowPressed:function(_55c,_55d,_55e){if(this.disabled||this.readOnly){return;}this._setValueAttr(this.adjust(this.get("value"),_55d*_55e),false);_55b.selectInputText(this.textbox,this.textbox.value.length);},_arrowReleased:function(){this._wheelTimer=null;},_typematicCallback:function(_55f,node,evt){var inc=this.smallDelta;if(node==this.textbox){var key=evt.keyCode;inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;}if(_55f==-1){this._arrowReleased(node);}else{this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);}},_wheelTimer:null,_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();var _560=evt.wheelDelta/120;if(Math.floor(_560)!=_560){_560=evt.wheelDelta>0?1:-1;}var _561=evt.detail?(evt.detail*-1):_560;if(_561!==0){var node=this[(_561>0?"upArrowNode":"downArrowNode")];this._arrowPressed(node,_561,this.smallDelta);if(this._wheelTimer){this._wheelTimer.remove();}this._wheelTimer=this.defer(function(){this._arrowReleased(node);},50);}},_setConstraintsAttr:function(_562){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(_563,_564){this.focusNode.setAttribute("aria-valuenow",_563);this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,_557.wheel,lang.hitch(this,"_mouseWheeled")),_558.addListener(this.upArrowNode,this.textbox,{keyCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_558.addListener(this.downArrowNode,this.textbox,{keyCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_558.addListener(this.upArrowNode,this.textbox,{keyCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_558.addListener(this.downArrowNode,this.textbox,{keyCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html","../a11yclick"],function(_565,_566,_567,has,_568,lang,_569,_56a,_56b,_56c){if(has("dijit-legacy-requires")){_569(0,function(){var _56d=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_565(_56d);});}var _56e=_566("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_56a,_56b],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_56c,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},_fillContent:function(_56f){if(_56f&&(!this.params||!("label" in this.params))){var _570=lang.trim(_56f.innerHTML);if(_570){this.label=_570;}}},_setShowLabelAttr:function(val){if(this.containerNode){_567.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_571){_568.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_571);},_setLabelAttr:function(_572){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_56e=_566("dijit.form.Button",_56e,{_setLabelAttr:function(_573){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_574){if(this._created&&this.textDir!=_574){this._set("textDir",_574);this._setLabelAttr(this.label);}}});}return _56e;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_575,_576,_577,dnd,_578,_579){var _57a=_575("dojo.dnd.move.constrainedMoveable",_579,{constraints:function(){},within:false,constructor:function(node,_57b){if(!_57b){_57b={};}this.constraints=_57b.constraints;this.within=_57b.within;},onFirstMove:function(_57c){var c=this.constraintBox=this.constraints.call(this,_57c);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_576.getMarginSize(_57c.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(_57d,_57e){var c=this.constraintBox,s=_57d.node.style;this.onMoving(_57d,_57e);_57e.l=_57e.l<c.l?c.l:c.r<_57e.l?c.r:_57e.l;_57e.t=_57e.t<c.t?c.t:c.b<_57e.t?c.b:_57e.t;s.left=_57e.l+"px";s.top=_57e.t+"px";this.onMoved(_57d,_57e);}});var _57f=_575("dojo.dnd.move.boxConstrainedMoveable",_57a,{box:{},constructor:function(node,_580){var box=_580&&_580.box;this.constraints=function(){return box;};}});var _581=_575("dojo.dnd.move.parentConstrainedMoveable",_57a,{area:"content",constructor:function(node,_582){var area=_582&&_582.area;this.constraints=function(){var n=this.node.parentNode,s=_577.getComputedStyle(n),mb=_576.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_576.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_576.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_576.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_57a,boxConstrainedMoveable:_57f,parentConstrainedMoveable:_581};});},"dijit/layout/_TabContainerBase":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","./StackContainer","./utils","../registry","../_TemplatedMixin","dojo/text!./templates/TabContainer.html"],function(_583,_584,_585,_586,_587,_588,_589,_58a,_58b){return _583("dijit.layout._TabContainerBase",[_587,_58a],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_58b,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_586.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_584.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_584.add(this.domNode,"dijitTabContainerNested");_584.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_584.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_584.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_584.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_584.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _58c=this.tabPosition.replace(/-h/,"");this.tablist.region=_58c;var _58d=[this.tablist,{domNode:this.tablistSpacer,region:_58c},{domNode:this.containerNode,region:"center"}];_588.layoutChildren(this.domNode,this._contentBox,_58d);this._containerContentBox=_588.marginBox2contentBox(this.containerNode,_58d[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var _58e=_585.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:_58e});}if(sc&&sc.resize){sc.resize();}}},destroy:function(_58f){if(this.tablist){this.tablist.destroy(_58f);}this.inherited(arguments);},selectChild:function(page,_590){if(this._focused){page=_589.byId(page);this.tablist.pane2button(page.id).focus();}return this.inherited(arguments);}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_591,_592,_593,has,_594,_595,_596,_597){return _591("dijit.form.Form",[_594,_595,_596,_597],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_598){_592.set(this.domNode,"encType",_598);if(has("ie")){this.domNode.encoding=_598;}this._set("encType",_598);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_593.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_599,_59a,_59b){var base=null;return _599("dojo.store.Memory",base,{constructor:function(_59c){for(var i in _59c){this[i]=_59c[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_59b,get:function(id){return this.data[this.index[id]];},getIdentity:function(_59d){return _59d[this.idProperty];},put:function(_59e,_59f){var data=this.data,_5a0=this.index,_5a1=this.idProperty;var id=_59e[_5a1]=(_59f&&"id" in _59f)?_59f.id:_5a1 in _59e?_59e[_5a1]:Math.random();if(id in _5a0){if(_59f&&_59f.overwrite===false){throw new Error("Object already exists");}data[_5a0[id]]=_59e;}else{_5a0[id]=data.push(_59e)-1;}return id;},add:function(_5a2,_5a3){(_5a3=_5a3||{}).overwrite=false;return this.put(_5a2,_5a3);},remove:function(id){var _5a4=this.index;var data=this.data;if(id in _5a4){data.splice(_5a4[id],1);this.setData(data);return true;}},query:function(_5a5,_5a6){return _59a(this.queryEngine(_5a5,_5a6)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier||this.idProperty;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dijit/Editor":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_5a7,_5a8,_5a9,_5aa,i18n,_5ab,_5ac,_5ad,_5ae,keys,lang,has,_5af,_5b0,_5b1,_5b2,_5b3,_5b4,_5b5,_5b6,_5b7,html,_5b8,_5b9,_5ba){var _5bb=_5a9("dijit.Editor",_5b9,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_5b7];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")||has("trident")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _5aa();this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(has("webkit")){_5ae.set(this.domNode,"KhtmlUserSelect","none");}},startup:function(){this.inherited(arguments);if(!this.toolbar){this.toolbar=new _5b2({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,"aria-label":this.id});this.header.appendChild(this.toolbar.domNode);}_5a8.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.resolve(true);_5ac.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_5ac.add(this.iframe,"dijitEditorIFrame");_5ab.set(this.iframe,"allowTransparency",true);this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){_5a8.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_5bc,_5bd){var args=lang.isString(_5bc)?{name:_5bc}:lang.isFunction(_5bc)?{ctor:_5bc}:_5bc;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_5b6.registry[args.name]){o.plugin=_5b6.registry[args.name](args);}else{_5b0.publish(_5ba._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){try{var pc=args.ctor||lang.getObject(args.name)||_5a7(args.name);if(pc){o.plugin=new pc(args);}}catch(e){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}}if(!o.plugin){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}_5bc=o.plugin;}if(arguments.length>1){this._plugins[_5bd]=_5bc;}else{this._plugins.push(_5bc);}_5bc.setEditor(this);if(lang.isFunction(_5bc.setToolbar)){_5bc.setToolbar(this.toolbar);}},resize:function(size){if(size){_5b4.prototype.resize.apply(this,arguments);}},layout:function(){var _5be=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_5ad.getPadBorderExtents(this.iframe.parentNode).h+_5ad.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_5be+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _5bf;var b=this.document.body;var _5c0=b.clientWidth;var _5c1=b.clientHeight;var _5c2=b.clientLeft;var _5c3=b.offsetWidth;var _5c4=b.offsetHeight;var _5c5=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_5c0<_5c3&&e.x>_5c0&&e.x<_5c3){_5bf=true;}}else{if(e.x<_5c2&&e.x>_5c5){_5bf=true;}}if(!_5bf){if(_5c1<_5c4&&e.y>_5c1&&e.y<_5c4){_5bf=true;}}if(!_5bf){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){this.defer("placeCursorAtEnd");}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){this._editTimer.remove();}this._editTimer=this.defer("endEditing",this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {code:1011};}}catch(e){if(e.code==1011||(e.code==9&&has("opera"))){var sub=_5af.substitute,_5c6={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_5c6[cmd]])]));}r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _5c7=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,_5c8,_5c9,sel;if(mark){if(has("ie")<9||(has("ie")===9&&has("quirks"))){if(lang.isArray(mark)){_5c7=[];_5a8.forEach(mark,function(n){_5c7.push(_5b8.getNode(n,this.editNode));},this);this.selection.moveToBookmark({mark:_5c7,isCollapsed:col});}else{if(mark.startContainer&&mark.endContainer){sel=_5b8.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_5b8.create(this.window);_5c8=_5b8.getNode(mark.startContainer,this.editNode);_5c9=_5b8.getNode(mark.endContainer,this.editNode);if(_5c8&&_5c9){r.setStart(_5c8,mark.startOffset);r.setEnd(_5c9,mark.endOffset);sel.addRange(r);}}}}}else{sel=_5b8.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_5b8.create(this.window);_5c8=_5b8.getNode(mark.startContainer,this.editNode);_5c9=_5b8.getNode(mark.endContainer,this.editNode);if(_5c8&&_5c9){r.setStart(_5c8,mark.startOffset);r.setEnd(_5c9,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_5ca){if(this._editTimer){this._editTimer=this._editTimer.remove();}if(this._inEditing){this._endEditing(_5ca);this._inEditing=false;}},_getBookmark:function(){var b=this.selection.getBookmark();var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9||(has("ie")===9&&has("quirks"))){var sel=_5b8.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var _5cb;if(sel.rangeCount){_5cb=sel.getRangeAt(0);}if(_5cb){b.mark=_5cb.cloneRange();}else{b.mark=this.selection.getBookmark();}}}else{_5a8.forEach(b.mark,function(n){tmp.push(_5b8.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_5b8.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_5b8.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.shiftKey&&!e.altKey){if(k==90||k==122){e.stopPropagation();e.preventDefault();this.undo();return;}else{if(k==89||k==121){e.stopPropagation();e.preventDefault();this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");}else{this.beginEditing("paste");}this.defer("endEditing",1);break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(this.selection.isCollapsed()){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(_5cc){this.setValueDeferred.then(lang.hitch(this,function(){if((!this.disabled&&_5cc)||(!this._buttonEnabledPlugins&&_5cc)){_5a8.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!_5cc){_5a8.forEach(this._plugins,function(p){p.set("disabled",false);});}}}));this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_5ae.set(this.document.body,"color",_5ae.get(this.iframe,"color"));}}catch(e){}}});function _5cd(args){return new _5b6({command:args.name});};function _5ce(args){return new _5b6({buttonClass:_5b5,command:args.name});};lang.mixin(_5b6.registry,{"undo":_5cd,"redo":_5cd,"cut":_5cd,"copy":_5cd,"paste":_5cd,"insertOrderedList":_5cd,"insertUnorderedList":_5cd,"indent":_5cd,"outdent":_5cd,"justifyCenter":_5cd,"justifyFull":_5cd,"justifyLeft":_5cd,"justifyRight":_5cd,"delete":_5cd,"selectAll":_5cd,"removeFormat":_5cd,"unlink":_5cd,"insertHorizontalRule":_5cd,"bold":_5ce,"italic":_5ce,"underline":_5ce,"strikethrough":_5ce,"subscript":_5ce,"superscript":_5ce,"|":function(){return new _5b6({setEditor:function(_5cf){this.editor=_5cf;this.button=new _5b3({ownerDocument:_5cf.ownerDocument});}});}});return _5bb;});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_5d0,_5d1,has,keys,_5d2,_5d3,_5d4,_5d5){if(has("dijit-legacy-requires")){_5d2(0,function(){var _5d6=["dijit/ToolbarSeparator"];_5d0(_5d6);});}return _5d1("dijit.Toolbar",[_5d3,_5d5,_5d4],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget"],function(_5d7,_5d8,_5d9,_5da,_5db,has,lang,on,_5dc,_5dd,when,_5de,_5df,_5e0){if(has("dijit-legacy-requires")){_5dc(0,function(){var _5e1=["dijit/layout/StackController"];require(_5e1);});}var _5e2=_5d9("dijit.layout.StackContainer",_5e0,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_5da.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _5e3=this.getChildren();_5d7.forEach(_5e3,this._setupChild,this);if(this.persist){this.selectedChildWidget=_5de.byId(_5d8(this.id+"_selectedChild"));}else{_5d7.some(_5e3,function(_5e4){if(_5e4.selected){this.selectedChildWidget=_5e4;}return _5e4.selected;},this);}var _5e5=this.selectedChildWidget;if(!_5e5&&_5e3[0]){_5e5=this.selectedChildWidget=_5e3[0];_5e5.selected=true;}_5dd.publish(this.id+"-startup",{children:_5e3,selected:_5e5,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _5e6=this.selectedChildWidget;if(_5e6){this._showChild(_5e6);}}this.inherited(arguments);},_setupChild:function(_5e7){var _5e8=_5e7.domNode,_5e9=_5db.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_5e7.domNode,"replace"),_5ea=_5e7["aria-label"]||_5e7.title||_5e7.label;if(_5ea){_5e9.setAttribute("aria-label",_5ea);}_5db.place(_5e8,_5e9);_5e7._wrapper=_5e9;this.inherited(arguments);if(_5e8.style.display=="none"){_5e8.style.display="block";}_5e7.domNode.removeAttribute("title");},addChild:function(_5eb,_5ec){this.inherited(arguments);if(this._started){_5dd.publish(this.id+"-addChild",_5eb,_5ec);this.layout();if(!this.selectedChildWidget){this.selectChild(_5eb);}}},removeChild:function(page){var idx=_5d7.indexOf(this.getChildren(),page);this.inherited(arguments);_5db.destroy(page._wrapper);delete page._wrapper;if(this._started){_5dd.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _5ed=this.getChildren();if(_5ed.length){this.selectChild(_5ed[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_5ee){var d;page=_5de.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_5ee);this._set("selectedChildWidget",page);_5dd.publish(this.id+"-selectChild",page);if(this.persist){_5d8(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_5ef,_5f0){if(_5f0){this._hideChild(_5f0);}var d=this._showChild(_5ef);if(_5ef.resize){if(this.doLayout){_5ef.resize(this._containerContentBox||this._contentBox);}else{_5ef.resize();}}return d;},_adjacent:function(_5f1){var _5f2=this.getChildren();var _5f3=_5d7.indexOf(_5f2,this.selectedChildWidget);_5f3+=_5f1?1:_5f2.length-1;return _5f2[_5f3%_5f2.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_5dd.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _5f4=this.selectedChildWidget;if(_5f4&&_5f4.resize){if(this.doLayout){_5f4.resize(this._containerContentBox||this._contentBox);}else{_5f4.resize();}}},_showChild:function(page){var _5f5=this.getChildren();page.isFirstChild=(page==_5f5[0]);page.isLastChild=(page==_5f5[_5f5.length-1]);page._set("selected",true);if(page._wrapper){_5da.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_5da.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _5f6=page.onClose&&page.onClose(this,page);if(_5f6){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_5f7){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_5d7.forEach(this.getChildren(),function(_5f8){if(!_5f7){this.removeChild(_5f8);}_5f8.destroyRecursive(_5f7);},this);this._descendantsBeingDestroyed=false;}});_5e2.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_5df,_5e2.ChildWidgetProperties);return _5e2;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _5f9={};lang.setObject("dojo.regexp",_5f9);_5f9.escapeString=function(str,_5fa){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+\-^])/g,function(ch){if(_5fa&&_5fa.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_5f9.buildGroupRE=function(arr,re,_5fb){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _5f9.group(b.join("|"),_5fb);};_5f9.group=function(_5fc,_5fd){return "("+(_5fd?"?:":"")+_5fc+")";};return _5f9;});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_5fe,_5ff,_600){return _5fe("dijit.form.ComboBox",[_5ff,_600],{});});},"dijit/_editor/plugins/LinkDialog":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/query","dojo/string","../_Plugin","../../form/DropDownButton","../range"],function(_601,_602,_603,keys,lang,on,has,_604,_605,_606,_607,_608){var _609=_602("dijit._editor.plugins.LinkDialog",_606,{buttonClass:_607,useDefaultCommand:false,urlRegExp:"((https?|ftps?|file)\\://|./|../|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]{0,}(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?",emailRegExp:"<?(mailto\\:)([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+"+"@"+"((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)+(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)\\.?)|localhost|^[^-][a-zA-Z0-9_-]*>?",htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\""+" target=\"${targetSelect}\""+">${textInput}</a>",tag:"a",_hostRxp:/^((([^\[:]+):)?([^@]+)@)?(\[([^\]]+)\]|([^\[:]*))(:([0-9]+))?$/,_userAtRxp:/^([!#-'*+\-\/-9=?A-Z^-~]+[.])*[!#-'*+\-\/-9=?A-Z^-~]+@/i,linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' "+"id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_targetSelect'>${target}</label>","</td><td>","<select id='${id}_targetSelect' name='targetSelect' data-dojo-type='dijit.form.Select'>","<option selected='selected' value='_self'>${currentWindow}</option>","<option value='_blank'>${newWindow}</option>","<option value='_top'>${topWindow}</option>","<option value='_parent'>${parentWindow}</option>","</select>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),_initButton:function(){this.inherited(arguments);this.button.loadDropDown=lang.hitch(this,"_loadDropDown");this._connectTagEvents();},_loadDropDown:function(_60a){_601(["dojo/i18n","../../TooltipDialog","../../registry","../../form/Button","../../form/Select","../../form/ValidationTextBox","dojo/i18n!../../nls/common","dojo/i18n!../nls/LinkDialog"],lang.hitch(this,function(i18n,_60b,_60c){var _60d=this;this.tag=this.command=="insertImage"?"img":"a";var _60e=lang.delegate(i18n.getLocalization("dijit","common",this.lang),i18n.getLocalization("dijit._editor","LinkDialog",this.lang));var _60f=(this.dropDown=this.button.dropDown=new _60b({title:_60e[this.command+"Title"],ownerDocument:this.editor.ownerDocument,dir:this.editor.dir,execute:lang.hitch(this,"setValue"),onOpen:function(){_60d._onOpenDialog();_60b.prototype.onOpen.apply(this,arguments);},onCancel:function(){setTimeout(lang.hitch(_60d,"_onCloseDialog"),0);}}));_60e.urlRegExp=this.urlRegExp;_60e.id=_60c.getUniqueId(this.editor.id);this._uniqueId=_60e.id;this._setContent(_60f.title+"<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>"+_605.substitute(this.linkDialogTemplate,_60e));_60f.startup();this._urlInput=_60c.byId(this._uniqueId+"_urlInput");this._textInput=_60c.byId(this._uniqueId+"_textInput");this._setButton=_60c.byId(this._uniqueId+"_setButton");this.own(_60c.byId(this._uniqueId+"_cancelButton").on("click",lang.hitch(this.dropDown,"onCancel")));if(this._urlInput){this.own(this._urlInput.on("change",lang.hitch(this,"_checkAndFixInput")));}if(this._textInput){this.own(this._textInput.on("change",lang.hitch(this,"_checkAndFixInput")));}this._urlRegExp=new RegExp("^"+this.urlRegExp+"$","i");this._emailRegExp=new RegExp("^"+this.emailRegExp+"$","i");this._urlInput.isValid=lang.hitch(this,function(){var _610=this._urlInput.get("value");return this._urlRegExp.test(_610)||this._emailRegExp.test(_610);});this.own(on(_60f.domNode,"keydown",lang.hitch(this,lang.hitch(this,function(e){if(e&&e.keyCode==keys.ENTER&&!e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey){if(!this._setButton.get("disabled")){_60f.onExecute();_60f.execute(_60f.get("value"));}}}))));_60a();}));},_checkAndFixInput:function(){var self=this;var url=this._urlInput.get("value");var _611=function(url){var _612=false;var _613=false;if(url&&url.length>1){url=lang.trim(url);if(url.indexOf("mailto:")!==0){if(url.indexOf("/")>0){if(url.indexOf("://")===-1){if(url.charAt(0)!=="/"&&url.indexOf("./")&&url.indexOf("../")!==0){if(self._hostRxp.test(url)){_612=true;}}}}else{if(self._userAtRxp.test(url)){_613=true;}}}}if(_612){self._urlInput.set("value","http://"+url);}if(_613){self._urlInput.set("value","mailto:"+url);}self._setButton.set("disabled",!self._isValid());};if(this._delayedCheck){clearTimeout(this._delayedCheck);this._delayedCheck=null;}this._delayedCheck=setTimeout(function(){_611(url);},250);},_connectTagEvents:function(){this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"dblclick",lang.hitch(this,"_onDblClick")));}));},_isValid:function(){return this._urlInput.isValid()&&this._textInput.isValid();},_setContent:function(_614){this.dropDown.set({parserScope:"dojo",content:_614});},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}return args;},setValue:function(args){this._onCloseDialog();if(has("ie")<9){var sel=_608.getSelection(this.editor.window);var _615=sel.getRangeAt(0);var a=_615.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(a&&(a.nodeName&&a.nodeName.toLowerCase()===this.tag)){if(this.editor.queryCommandEnabled("unlink")){this.editor.selection.selectElementChildren(a);this.editor.execCommand("unlink");}}}args=this._checkValues(args);this.editor.execCommand("inserthtml",_605.substitute(this.htmlTemplate,args));_604("a",this.editor.document).forEach(function(a){if(!a.innerHTML&&!_603.has(a,"name")){a.parentNode.removeChild(a);}},this);},_onCloseDialog:function(){if(this.editor.focused){this.editor.focus();}},_getCurrentValues:function(a){var url,text,_616;if(a&&a.tagName.toLowerCase()===this.tag){url=a.getAttribute("_djrealurl")||a.getAttribute("href");_616=a.getAttribute("target")||"_self";text=a.textContent||a.innerText;this.editor.selection.selectElement(a,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||"",targetSelect:_616||""};},_onOpenDialog:function(){var a,b,fc;if(has("ie")){var sel=_608.getSelection(this.editor.window);if(sel.rangeCount){var _617=sel.getRangeAt(0);a=_617.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(!a||(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){b=this.editor.selection.getAncestorElement(this.tag);if(b&&(b.nodeName&&b.nodeName.toLowerCase()==this.tag)){a=b;this.editor.selection.selectElement(a);}else{if(_617.startContainer===_617.endContainer){fc=_617.startContainer.firstChild;if(fc&&(fc.nodeName&&fc.nodeName.toLowerCase()==this.tag)){a=fc;this.editor.selection.selectElement(a);}}}}}}else{a=this.editor.selection.getAncestorElement(this.tag);}this.dropDown.reset();this._setButton.set("disabled",true);this.dropDown.set("value",this._getCurrentValues(a));},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_603.get(t,"href")){var _618=this.editor;this.editor.selection.selectElement(t);_618.onDisplayChanged();if(_618._updateTimer){_618._updateTimer.remove();delete _618._updateTimer;}_618.onNormalizedDisplayChanged();var _619=this.button;setTimeout(function(){_619.set("disabled",false);_619.loadAndOpenDropDown().then(function(){if(_619.dropDown.focus){_619.dropDown.focus();}});},10);}}}});var _61a=_602("dijit._editor.plugins.ImgLinkDialog",[_609],{linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' "+"required='true' id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","</td><td>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />",tag:"img",_getCurrentValues:function(img){var url,text;if(img&&img.tagName.toLowerCase()===this.tag){url=img.getAttribute("_djrealurl")||img.getAttribute("src");text=img.getAttribute("alt");this.editor.selection.selectElement(img,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||""};},_isValid:function(){return this._urlInput.isValid();},_connectTagEvents:function(){this.inherited(arguments);this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"mousedown",lang.hitch(this,"_selectTag")));}));},_selectTag:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag){this.editor.selection.selectElement(t);}}},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}if(args&&args.textInput){args.textInput=args.textInput.replace(/"/g,"&quot;");}return args;},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_603.get(t,"src")){var _61b=this.editor;this.editor.selection.selectElement(t);_61b.onDisplayChanged();if(_61b._updateTimer){_61b._updateTimer.remove();delete _61b._updateTimer;}_61b.onNormalizedDisplayChanged();var _61c=this.button;setTimeout(function(){_61c.set("disabled",false);_61c.loadAndOpenDropDown().then(function(){if(_61c.dropDown.focus){_61c.dropDown.focus();}});},10);}}}});_606.registry["createLink"]=function(){return new _609({command:"createLink"});};_606.registry["insertImage"]=function(){return new _61a({command:"insertImage"});};_609.ImgLinkDialog=_61a;return _609;});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_MenuBase"],function(_61d,keys,_61e,_61f){return _61d("dijit.DropDownMenu",_61f,{templateString:_61e,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(evt){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_620,_621,_622,lang,on,_623){return _621("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_624){var res=[];_620.forEach(_624||this.getChildren(),function(_625){if("value" in _625){res.push(_625);}else{res=res.concat(this._getDescendantFormWidgets(_625.getChildren()));}},this);return res;},reset:function(){_620.forEach(this._getDescendantFormWidgets(),function(_626){if(_626.reset){_626.reset();}});},validate:function(){var _627=false;return _620.every(_620.map(this._getDescendantFormWidgets(),function(_628){_628._hasBeenBlurred=true;var _629=_628.disabled||!_628.validate||_628.validate();if(!_629&&!_627){_623.scrollIntoView(_628.containerNode||_628.domNode);_628.focus();_627=true;}return _629;}),function(item){return item;});},setValues:function(val){_622.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_620.forEach(this._getDescendantFormWidgets(),function(_62a){if(!_62a.name){return;}var _62b=map[_62a.name]||(map[_62a.name]=[]);_62b.push(_62a);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _62c=map[name],_62d=lang.getObject(name,false,obj);if(_62d===undefined){continue;}_62d=[].concat(_62d);if(typeof _62c[0].checked=="boolean"){_620.forEach(_62c,function(w){w.set("value",_620.indexOf(_62d,w._get("value"))!=-1);});}else{if(_62c[0].multiple){_62c[0].set("value",_62d);}else{_620.forEach(_62c,function(w,i){w.set("value",_62d[i]);});}}}},getValues:function(){_622.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_620.forEach(this._getDescendantFormWidgets(),function(_62e){var name=_62e.name;if(!name||_62e.disabled){return;}var _62f=_62e.get("value");if(typeof _62e.checked=="boolean"){if(/Radio/.test(_62e.declaredClass)){if(_62f!==false){lang.setObject(name,_62f,obj);}else{_62f=lang.getObject(name,false,obj);if(_62f===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_62f!==false){ary.push(_62f);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_62f);}else{lang.setObject(name,[prev,_62f],obj);}}else{lang.setObject(name,_62f,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _630=_620.map(this._descendants,function(w){return w.get("state")||"";});return _620.indexOf(_630,"Error")>=0?"Error":_620.indexOf(_630,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_631){this._descendants=this._getDescendantFormWidgets();_620.forEach(this._descendants,function(_632){if(!_632._started){_632.startup();}});if(!_631){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_633,_634){this.onValidStateChange(_634=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/Menu":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_635,_636,_637,dom,_638,_639,_63a,keys,lang,on,has,win,_63b,pm,_63c,_63d){if(has("dijit-legacy-requires")){_63d(0,function(){var _63e=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_635(_63e);});}return _637("dijit.Menu",_63c,{constructor:function(){this._bindings=[];},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(this.ownerDocumentBody);}else{_636.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_63f){return _63b.get(this._iframeContentDocument(_63f))||this._iframeContentDocument(_63f)["__parent__"]||(_63f.name&&document.frames[_63f.name])||null;},_iframeContentDocument:function(_640){return _640.contentDocument||(_640.contentWindow&&_640.contentWindow.document)||(_640.name&&document.frames[_640.name]&&document.frames[_640.name].document)||null;},bindDomNode:function(node){node=dom.byId(node,this.ownerDocument);var cn;if(node.tagName.toLowerCase()=="iframe"){var _641=node,_642=this._iframeContentWindow(_641);cn=win.body(_642.document);}else{cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);}var _643={node:node,iframe:_641};_638.set(node,"_dijitMenu"+this.id,this._bindings.push(_643));var _644=lang.hitch(this,function(cn){var _645=this.selector,_646=_645?function(_647){return on.selector(_645,_647);}:function(_648){return _648;},self=this;return [on(cn,_646(this.leftClickToOpen?"click":"contextmenu"),function(evt){evt.stopPropagation();evt.preventDefault();if((new Date()).getTime()<this._lastKeyDown+500){return;}self._scheduleOpen(this,_641,{x:evt.pageX,y:evt.pageY},evt.target);}),on(cn,_646("keydown"),function(evt){if(evt.keyCode==93||(evt.shiftKey&&evt.keyCode==keys.F10)||(this.leftClickToOpen&&evt.keyCode==keys.SPACE)){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_641,null,evt.target);this._lastKeyDown=(new Date()).getTime();}})];});_643.connects=cn?_644(cn):[];if(_641){_643.onloadHandler=lang.hitch(this,function(){var _649=this._iframeContentWindow(_641),cn=win.body(_649.document);_643.connects=_644(cn);});if(_641.addEventListener){_641.addEventListener("load",_643.onloadHandler,false);}else{_641.attachEvent("onload",_643.onloadHandler);}}},unBindDomNode:function(_64a){var node;try{node=dom.byId(_64a,this.ownerDocument);}catch(e){return;}var _64b="_dijitMenu"+this.id;if(node&&_638.has(node,_64b)){var bid=_638.get(node,_64b)-1,b=this._bindings[bid],h;while((h=b.connects.pop())){h.remove();}var _64c=b.iframe;if(_64c){if(_64c.removeEventListener){_64c.removeEventListener("load",b.onloadHandler,false);}else{_64c.detachEvent("onload",b.onloadHandler);}}_638.remove(node,_64b);delete this._bindings[bid];}},_scheduleOpen:function(_64d,_64e,_64f,_650){if(!this._openTimer){this._openTimer=this.defer(function(){delete this._openTimer;this._openMyself({target:_650,delegatedTarget:_64d,iframe:_64e,coords:_64f});},1);}},_openMyself:function(args){var _651=args.target,_652=args.iframe,_653=args.coords,_654=!_653;this.currentTarget=args.delegatedTarget;if(_653){if(_652){var ifc=_639.position(_652,true),_655=this._iframeContentWindow(_652),_656=_639.docScroll(_655.document);var cs=_63a.getComputedStyle(_652),tp=_63a.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_652,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_652,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_652,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_652,cs.borderTopWidth):0);_653.x+=ifc.x+left-_656.x;_653.y+=ifc.y+top-_656.y;}}else{_653=_639.position(_651,true);_653.x+=10;_653.y+=10;}var self=this;var _657=this._focusManager.get("prevNode");var _658=this._focusManager.get("curNode");var _659=!_658||(dom.isDescendant(_658,this.domNode))?_657:_658;function _65a(){if(self.refocus&&_659){_659.focus();}pm.close(self);};pm.open({popup:this,x:_653.x,y:_653.y,onExecute:_65a,onCancel:_65a,orient:this.isLeftToRight()?"L":"R"});this.focus();if(!_654){this.defer(function(){this._cleanUp(true);});}this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},destroy:function(){_636.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_65b,_65c){return _65b("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_65d){this._set("readOnly",_65d);_65c.set(this.focusNode,"readOnly",_65d);},_setLabelAttr:undefined,_getSubmitValue:function(_65e){return (_65e==null||_65e==="")?"on":_65e;},_setValueAttr:function(_65f){_65f=this._getSubmitValue(_65f);this._set("value",_65f);_65c.set(this.focusNode,"value",_65f);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_65c.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_660,lang,_661,_662,_663,_664,html,_665,_666,_667,_668,dom,_669,_66a,xhr,i18n,when){return _667("dijit.layout.ContentPane",[_661,_662,_663],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_660._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_66b,node,ctor){var self=new ctor(_66b,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_66c,_66d){if((!_66c||!_66c.template)&&_66d&&!("href" in _66c)&&!("content" in _66c)){_66d=dom.byId(_66d);var df=_66d.ownerDocument.createDocumentFragment();while(_66d.firstChild){df.appendChild(_66d.firstChild);}_66c=lang.delegate(_66c,{content:df});}this.inherited(arguments,[_66c,_66d]);},postMixInProperties:function(){this.inherited(arguments);var _66e=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_664.substitute(this.loadingMessage,_66e);this.errorMessage=_664.substitute(this.errorMessage,_66e);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_666.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_666.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_666.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_660.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _668(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_660.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _668(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_66f){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _668(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _670={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_670,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_670)),_671;hand.then(function(html){_671=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _671;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_672){if(this.isLoaded){this._onUnloadHandler();}var _673=this._contentSetter;_666.forEach(this.getChildren(),function(_674){if(_674.destroyRecursive){_674.destroyRecursive(_672);}else{if(_674.destroy){_674.destroy(_672);}}_674._destroyed=true;});if(_673){_666.forEach(_673.parseResults,function(_675){if(!_675._destroyed){if(_675.destroyRecursive){_675.destroyRecursive(_672);}else{if(_675.destroy){_675.destroy(_672);}}_675._destroyed=true;}});delete _673.parseResults;}if(!_672){_66a.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_676){this.destroyDescendants();var _677=this._contentSetter;if(!(_677&&_677 instanceof html._ContentSetter)){_677=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _678=this.onContentError(e);try{this.containerNode.innerHTML=_678;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _679=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_677.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_679);var self=this;return when(p&&p.then?p:_677.parseDeferred,function(){delete self._contentSetterParams;if(!_676){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},_onError:function(type,err,_67a){this.onLoadDeferred.reject(err);var _67b=this["on"+type+"Error"].call(this,err);if(_67a){console.error(_67a,err);}else{if(_67b){this._setContent(_67b,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_67c,_67d,_67e,_67f,keys,lang,_680,_681,_682,_683){return _67d("dijit._KeyNavContainer",[_682,_683,_681],{connectKeyNavHandlers:function(_684,_685){var _686=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_67c.forEach(_684,function(code){_686[code]=prev;});_67c.forEach(_685,function(code){_686[code]=next;});_686[keys.HOME]=lang.hitch(this,"focusFirstChild");_686[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_67f.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_67c.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_687,_688){this.inherited(arguments);this._startupChild(_687);},_startupChild:function(_689){_689.set("tabIndex","-1");},_getFirst:function(){var _68a=this.getChildren();return _68a.length?_68a[0]:null;},_getLast:function(){var _68b=this.getChildren();return _68b.length?_68b[_68b.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_680.byNode(node);return node&&node.getParent()==this;}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_68c,_68d,_68e,_68f,lang){function _690(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_691,dim){var _692=_691.resize?_691.resize(dim):_68e.setMarginBox(_691.domNode,dim);if(_692){lang.mixin(_691,_692);}else{lang.mixin(_691,_68e.getMarginBox(_691.domNode));lang.mixin(_691,dim);}};var _693={marginBox2contentBox:function(node,mb){var cs=_68f.getComputedStyle(node);var me=_68e.getMarginExtents(node,cs);var pb=_68e.getPadBorderExtents(node,cs);return {l:_68f.toPixelValue(node,cs.paddingLeft),t:_68f.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_694,dim,_695,_696,_697){dim=lang.mixin({},dim);_68d.add(_694,"dijitLayoutContainer");_695=_68c.filter(_695,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_68c.filter(_695,function(item){return item.region=="center"||item.layoutAlign=="client";}));_68c.forEach(_695,function(_698){var elm=_698.domNode,pos=(_698.region||_698.layoutAlign);if(!pos){throw new Error("No region setting for "+_698.id);}var _699=elm.style;_699.left=dim.l+"px";_699.top=dim.t+"px";_699.position="absolute";_68d.add(elm,"dijitAlign"+_690(pos));var _69a={};if(_696&&_696==_698.id){_69a[_698.region=="top"||_698.region=="bottom"?"h":"w"]=_697;}if(pos=="leading"){pos=_698.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_698.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_69a.w=dim.w;size(_698,_69a);dim.h-=_698.h;if(pos=="top"){dim.t+=_698.h;}else{_699.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_69a.h=dim.h;size(_698,_69a);dim.w-=_698.w;if(pos=="left"){dim.l+=_698.w;}else{_699.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_698,dim);}}}});}};lang.setObject("dijit.layout.utils",_693);return _693;});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_69b,dom,lang,_69c,_69d,_69e){function _69f(_6a0){return {id:_6a0.value,value:_6a0.value,name:lang.trim(_6a0.innerText||_6a0.textContent||"")};};return _69b("dijit.form.DataList",_69d,{constructor:function(_6a1,_6a2){this.domNode=dom.byId(_6a2);lang.mixin(this,_6a1);if(this.id){_69e.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_69c("option",this.domNode).map(_69f)}]);},destroy:function(){_69e.remove(this.id);},fetchSelectedItem:function(){var _6a3=_69c("> option[selected]",this.domNode)[0]||_69c("> option",this.domNode)[0];return _6a3&&_69f(_6a3);}});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_6a4,_6a5,_6a6,has,_6a7,_6a8,_6a9,_6aa,_6ab){if(has("dijit-legacy-requires")){_6a8(0,function(){var _6ac=["dijit/form/RadioButton"];_6a4(_6ac);});}return _6a5("dijit.form.CheckBox",[_6a9,_6aa],{templateString:_6ab,baseClass:"dijitCheckBox",_setValueAttr:function(_6ad,_6ae){if(typeof _6ad=="string"){this.inherited(arguments);_6ad=true;}if(this._created){this.set("checked",_6ad,_6ae);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_6a7("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_6a7("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/_editor/_Plugin":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../Destroyable","../form/Button"],function(_6af,_6b0,lang,_6b1,_6b2){var _6b3=_6b0("dijit._editor._Plugin",_6b1,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_6b2,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var _6b4=this.getLabel(this.command),_6b5=this.editor,_6b6=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var _6b7=lang.mixin({label:_6b4,ownerDocument:_6b5.ownerDocument,dir:_6b5.dir,lang:_6b5.lang,showLabel:false,iconClass:_6b6,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});delete _6b7.name;this.button=new this.buttonClass(_6b7);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){if(this.dropDown){this.dropDown.destroyRecursive();}this.inherited(arguments);},connect:function(o,f,tf){this.own(_6af.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_6b8,_6b9;if(!e||!e.isLoaded||!c.length){return;}var _6ba=this.get("disabled");if(this.button){try{_6b9=!_6ba&&e.queryCommandEnabled(c);if(this.enabled!==_6b9){this.enabled=_6b9;this.button.set("disabled",!_6b9);}if(_6b9){if(typeof this.button.checked=="boolean"){_6b8=e.queryCommandState(c);if(this.checked!==_6b8){this.checked=_6b8;this.button.set("checked",e.queryCommandState(c));}}}}catch(e){}}},setEditor:function(_6bb){this.editor=_6bb;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.own(this.button.on("click",lang.hitch(this.editor,"execCommand",this.command,this.commandArg)));}else{this.button.domNode.style.display="none";}}this.own(this.editor.on("NormalizedDisplayChanged",lang.hitch(this,"updateState")));},setToolbar:function(_6bc){if(this.button){_6bc.addChild(this.button);}},set:function(name,_6bd){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6be=this._getAttrNames(name);if(this[_6be.s]){var _6bf=this[_6be.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,_6bd);}return _6bf||this;},get:function(name){var _6c0=this._getAttrNames(name);return this[_6c0.g]?this[_6c0.g]():this[name];},_setDisabledAttr:function(_6c1){this._set("disabled",_6c1);this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,_6c2){this[name]=_6c2;}});_6b3.registry={};return _6b3;});},"dijit/tree/_dndSelector":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/dnd/common","dojo/dom","dojo/mouse","dojo/on","dojo/touch","../a11yclick","./_dndContainer"],function(_6c3,_6c4,_6c5,lang,_6c6,dom,_6c7,on,_6c8,_6c9,_6ca){return _6c4("dijit.tree._dndSelector",_6ca,{constructor:function(){this.selection={};this.anchor=null;this.events.push(on(this.tree.domNode,_6c8.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_6c8.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_6c8.move,lang.hitch(this,"onMouseMove")),on(this.tree.domNode,_6c9.press,lang.hitch(this,"onClickPress")),on(this.tree.domNode,_6c9.release,lang.hitch(this,"onClickRelease")));},singular:false,getSelectedTreeNodes:function(){var _6cb=[],sel=this.selection;for(var i in sel){_6cb.push(sel[i]);}return _6cb;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_6cc){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_6cc){this.anchor=node;}return node;},removeTreeNode:function(node){var _6cd=_6c3.filter(this.getSelectedTreeNodes(),function(_6ce){return !dom.isDescendant(_6ce.domNode,node.domNode);});this.setSelection(_6cd);return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_6cf){var _6d0=this.getSelectedTreeNodes();_6c3.forEach(this._setDifference(_6d0,_6cf),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_6c3.forEach(this._setDifference(_6cf,_6d0),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_6c3.forEach(ys,function(y){y.__exclude__=true;});var ret=_6c3.filter(xs,function(x){return !x.__exclude__;});_6c3.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _6d1=this.getSelectedTreeNodes();var _6d2=[],_6d3=[];_6c3.forEach(_6d1,function(node){var ary=node.getTreePath();_6d3.push(node);_6d2.push(ary);},this);var _6d4=_6c3.map(_6d3,function(node){return node.item;});this.tree._set("paths",_6d2);this.tree._set("path",_6d2[0]||[]);this.tree._set("selectedNodes",_6d3);this.tree._set("selectedNode",_6d3[0]||null);this.tree._set("selectedItems",_6d4);this.tree._set("selectedItem",_6d4[0]||null);},onClickPress:function(e){if(this.current&&this.current.isExpandable&&this.tree.isExpandoNode(e.target,this.current)){return;}if(e.type=="mousedown"&&_6c7.isLeft(e)){e.preventDefault();}var _6d5=e.type=="keydown"?this.tree.focusedChild:this.current;if(!_6d5){return;}var copy=_6c6.getCopyKeyState(e),id=_6d5.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_6d5,copy,e.shiftKey);},onClickRelease:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(e.type=="keyup"?this.tree.focusedChild:this.current,_6c6.getCopyKeyState(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},onMouseDown:function(){},onMouseUp:function(){},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_6d6,_6d7){if(this.singular){if(this.anchor==node&&_6d6){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_6d7&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_6d8,end,_6d9=this.anchor;if(cr<0){_6d8=_6d9;end=node;}else{_6d8=node;end=_6d9;}var _6da=[];while(_6d8!=end){_6da.push(_6d8);_6d8=this.tree._getNext(_6d8);}_6da.push(end);this.setSelection(_6da);}else{if(this.selection[node.id]&&_6d6){this.removeTreeNode(node);}else{if(_6d6){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _6db=this.selection[key];return {data:_6db,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||_6c5.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_6dc,lang,_6dd,_6de,dom,_6df,_6e0){var _6e1=0;var html={_secureForInnerHtml:function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");},_emptyNode:_6df.empty,_setNodeContent:function(node,cont){_6df.empty(node);if(cont){if(typeof cont=="string"){cont=_6df.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _6e2=cont.length,i=0;i<cont.length;i=_6e2==cont.length?i+1:0){_6df.place(cont[i],node,"last");}}else{_6df.place(cont,node,"last");}}return node;},_ContentSetter:_6de("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_6dc._scopeName,startup:true,constructor:function(_6e3,node){lang.mixin(this,_6e3||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_6e1++].join("_");}},set:function(cont,_6e4){if(undefined!==cont){this.content=cont;}if(_6e4){this._mixin(_6e4);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _6e5=this.onContentError(e);try{node.innerHTML=_6e5;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_6dd.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_6df.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _6e6=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_6e6){cont=_6e6[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_6e7){var _6e8={},key;for(key in _6e7){if(key in _6e8){continue;}this[key]=_6e7[key];}},_parse:function(){var _6e9=this.node;try{var _6ea={};_6dd.forEach(["dir","lang","textDir"],function(name){if(this[name]){_6ea[name]=this[name];}},this);var self=this;this.parseDeferred=_6e0.parse({rootNode:_6e9,noStart:!this.startup,inherited:_6ea,scope:this.parserScope}).then(function(_6eb){return self.parseResults=_6eb;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_6ec){var _6ed=this["on"+type+"Error"].call(this,err);if(_6ec){console.error(_6ec,err);}else{if(_6ed){html._setNodeContent(this.node,_6ed,true);}}}}),set:function(node,cont,_6ee){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(!_6ee){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_6ee,{content:cont,node:node}));return op.set();}}};lang.setObject("dojo.html",html);return html;});},"dijit/_PaletteMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","./_CssStateMixin","./a11yclick","./focus","./typematic"],function(_6ef,_6f0,_6f1,_6f2,keys,lang,on,_6f3,_6f4,_6f5,_6f6){var _6f7=_6ef("dijit._PaletteMixin",_6f3,{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,_dyeFactory:function(_6f8){var _6f9=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;return new _6f9(_6f8);},_preparePalette:function(_6fa,_6fb){this._cells=[];var url=this._blankGif;this.own(on(this.gridNode,_6f4,lang.hitch(this,"_onCellClick")));for(var row=0;row<_6fa.length;row++){var _6fc=_6f2.create("tr",{tabIndex:"-1",role:"row"},this.gridNode);for(var col=0;col<_6fa[row].length;col++){var _6fd=_6fa[row][col];if(_6fd){var _6fe=this._dyeFactory(_6fd,row,col,_6fb[_6fd]);var _6ff=_6f2.create("td",{"class":this.cellClass,tabIndex:"-1",title:_6fb[_6fd],role:"gridcell"},_6fc);_6fe.fillCell(_6ff,url);_6ff.idx=this._cells.length;this._cells.push({node:_6ff,dye:_6fe});}}}this._xDim=_6fa[0].length;this._yDim=_6fa.length;var _700={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _700){this.own(_6f6.addKeyListener(this.domNode,{keyCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _701=_700[key];return function(_702){this._navigateByKey(_701,_702);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){_6f5.focus(this._currentFocus);},_onCellClick:function(evt){var _703=evt.target;while(_703.tagName!="TD"){if(!_703.parentNode||_703==this.gridNode){return;}_703=_703.parentNode;}var _704=this._getDye(_703).getValue();this._setCurrent(_703);_6f5.focus(_703);this._setValueAttr(_704,true);evt.stopPropagation();evt.preventDefault();},_setCurrent:function(node){if("_currentFocus" in this){_6f0.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_6f0.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(_705,_706){if(this._selectedCell>=0){_6f1.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(_705){for(var i=0;i<this._cells.length;i++){if(_705==this._cells[i].dye.getValue()){this._selectedCell=i;_6f1.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?_705:null);if(_706||_706===undefined){this.onChange(_705);}},onChange:function(){},_navigateByKey:function(_707,_708){if(_708==-1){return;}var _709=this._currentFocus.idx+_707;if(_709<this._cells.length&&_709>-1){var _70a=this._cells[_709].node;this._setCurrent(_70a);this.defer(lang.hitch(_6f5,"focus",_70a));}},_getDye:function(cell){return this._cells[cell.idx].dye;}});return _6f7;});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_70b,_70c,lang,i18n,_70d,_70e,_70f){var _710;return _710=_70b("dijit.form.ValidationTextBox",_70d,{templateString:_70f,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_711){if(_711!=_710.prototype[attr]){_70c.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_711);}},_setRegExpGenAttr:function(_712){this._deprecateRegExp("regExpGen",_712);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_713){this._deprecateRegExp("regExp",_713);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_714,_715){return (new RegExp("^(?:"+this._computeRegexp(_715)+")"+(this.required?"":"?")+"$")).test(_714)&&(!this.required||!this._isEmpty(_714))&&(this._isEmpty(_714)||this.parse(_714,_715)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_716){return (this.trim?/^\s*$/:/^$/).test(_716);},getErrorMessage:function(){var _717=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _718=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_717:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_718:_717;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_719){var _71a="";var _71b=this.disabled||this.isValid(_719);if(_71b){this._maskValidSubsetError=true;}var _71c=this._isEmpty(this.textbox.value);var _71d=!_71b&&_719&&this._isValidSubset();this._set("state",_71b?"":(((((!this._hasBeenBlurred||_719)&&_71c)||_71d)&&(this._maskValidSubsetError||(_71d&&!this._hasBeenBlurred&&_719)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",this.state=="Error"?"true":"false");if(this.state=="Error"){this._maskValidSubsetError=_719&&_71d;_71a=this.getErrorMessage(_719);}else{if(this.state=="Incomplete"){_71a=this.getPromptMessage(_719);this._maskValidSubsetError=!this._hasBeenBlurred||_719;}else{if(_71c){_71a=this.getPromptMessage(_719);}}}this.set("message",_71a);return _71b;},displayMessage:function(_71e){if(_71e&&this.focused){_70e.show(_71e,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_70e.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_71f){this.constraints=lang.clone(this.constraints);this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_720){if(!_720.locale&&this.lang){_720.locale=this.lang;}this._set("constraints",_720);this._refreshState();},_setPatternAttr:function(_721){this._set("pattern",_721);this._refreshState();},_computeRegexp:function(_722){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_722);}if(p!=this._lastRegExp){var _723="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_723+=re;break;case ")":_723+="|$)";break;default:_723+="(?:"+re+"|$)";break;}});}try{"".search(_723);}catch(e){_723=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_723+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_724){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_725){this._set("required",_725);this.focusNode.setAttribute("aria-required",_725);this._refreshState();},_setMessageAttr:function(_726){this._set("message",_726);this.displayMessage(_726);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);},destroy:function(){_70e.hide(this.domNode);this.inherited(arguments);}});});},"dijit/layout/BorderContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./LayoutContainer","./utils"],function(_727,_728,_729,_72a,_72b,_72c,_72d,keys,lang,on,_72e,_72f,_730,_731,_732,_733){var _734=_729("dijit.layout._Splitter",[_730,_731],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeydown:_onKeyDown,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_72a.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _735=_728(this._cookieName);if(_735){this.child.domNode.style[this.horizontal?"height":"width"]=_735;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_736=_72c.getMarginBox(this.child.domNode)[dim],_737=_727.filter(this.container.getChildren(),function(_738){return _738.region=="center";})[0];var _739=_72c.getContentBox(_737.domNode)[dim]-10;return Math.min(this.child.maxSize,_736+_739);},_startDrag:function(e){if(!this.cover){this.cover=_72b.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");}_72a.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_72b.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_72a.add(this.domNode,"dijitSplitterShadow");_72b.place(this.fake,this.domNode,"after");}_72a.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_72a.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _73a=this._factor,_73b=this.horizontal,axis=_73b?"pageY":"pageX",_73c=e[axis],_73d=this.domNode.style,dim=_73b?"h":"w",_73e=_72d.getComputedStyle(this.child.domNode),_73f=_72c.getMarginBox(this.child.domNode,_73e)[dim],max=this._computeMaxSize(),min=Math.max(this.child.minSize,_72c.getPadBorderExtents(this.child.domNode,_73e)[dim]+10),_740=this.region,_741=_740=="top"||_740=="bottom"?"top":"left",_742=parseInt(_73d[_741],10),_743=this._resize,_744=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;this._handlers=this._handlers.concat([on(de,_72e.move,this._drag=function(e,_745){var _746=e[axis]-_73c,_747=_73a*_746+_73f,_748=Math.max(Math.min(_747,max),min);if(_743||_745){_744(_748);}_73d[_741]=_746+_742+_73a*(_748-_747)+"px";}),on(de,"dragstart",function(e){e.stopPropagation();e.preventDefault();}),on(this.ownerDocumentBody,"selectstart",function(e){e.stopPropagation();e.preventDefault();}),on(de,_72e.release,lang.hitch(this,"_stopDrag"))]);e.stopPropagation();e.preventDefault();},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_72a.toggle(this.domNode,"dijitSplitterHover",o);_72a.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_72a.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_72b.destroy(this.fake);}_72a.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_728(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyDown:function(e){this._resize=true;var _749=this.horizontal;var tick=1;switch(e.keyCode){case _749?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _749?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _74a=_72c.getMarginSize(this.child.domNode)[_749?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_74a,this._computeMaxSize()),this.child.minSize));e.stopPropagation();e.preventDefault();},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _74b=_729("dijit.layout._Gutter",[_730,_731],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_72a.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _74c=_729("dijit.layout.BorderContainer",_732,{gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_734,_setupChild:function(_74d){this.inherited(arguments);var _74e=_74d.region,ltr=_74d.isLeftToRight();if(_74e=="leading"){_74e=ltr?"left":"right";}if(_74e=="trailing"){_74e=ltr?"right":"left";}if(_74e){if(_74e!="center"&&(_74d.splitter||this.gutters)&&!_74d._splitterWidget){var _74f=_74d.splitter?this._splitterClass:_74b;if(lang.isString(_74f)){_74f=lang.getObject(_74f);}var _750=new _74f({id:_74d.id+"_splitter",container:this,child:_74d,region:_74e,live:this.liveSplitters});_750.isSplitter=true;_74d._splitterWidget=_750;var _751=_74e=="bottom"||_74e==(this.isLeftToRight()?"right":"left");_72b.place(_750.domNode,_74d.domNode,_751?"before":"after");_750.startup();}}},layout:function(){this._layoutChildren();},removeChild:function(_752){var _753=_752._splitterWidget;if(_753){_753.destroy();delete _752._splitterWidget;}this.inherited(arguments);},getChildren:function(){return _727.filter(this.inherited(arguments),function(_754){return !_754.isSplitter;});},getSplitter:function(_755){return _727.filter(this.getChildren(),function(_756){return _756.region==_755;})[0]._splitterWidget;},resize:function(_757,_758){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_72d.getComputedStyle(node);this.pe=_72c.getPadExtents(node,this.cs);this.pe.r=_72d.toPixelValue(node,this.cs.paddingRight);this.pe.b=_72d.toPixelValue(node,this.cs.paddingBottom);_72d.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_759,_75a){if(!this._borderBox||!this._borderBox.h){return;}var _75b=[];_727.forEach(this._getOrderedChildren(),function(pane){_75b.push(pane);if(pane._splitterWidget){_75b.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_733.layoutChildren(this.domNode,dim,_75b,_759,_75a);},destroyRecursive:function(){_727.forEach(this.getChildren(),function(_75c){var _75d=_75c._splitterWidget;if(_75d){_75d.destroy();}delete _75c._splitterWidget;});this.inherited(arguments);}});_74c.ChildWidgetProperties={splitter:false,minSize:0,maxSize:Infinity};lang.mixin(_74c.ChildWidgetProperties,_732.ChildWidgetProperties);lang.extend(_72f,_74c.ChildWidgetProperties);_74c._Splitter=_734;_74c._Gutter=_74b;return _74c;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_75e,_75f,_760){var _761={};lang.setObject("dojo.number",_761);_761.format=function(_762,_763){_763=lang.mixin({},_763||{});var _764=i18n.normalizeLocale(_763.locale),_765=i18n.getLocalization("dojo.cldr","number",_764);_763.customs=_765;var _766=_763.pattern||_765[(_763.type||"decimal")+"Format"];if(isNaN(_762)||Math.abs(_762)==Infinity){return null;}return _761._applyPattern(_762,_766,_763);};_761._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_761._applyPattern=function(_767,_768,_769){_769=_769||{};var _76a=_769.customs.group,_76b=_769.customs.decimal,_76c=_768.split(";"),_76d=_76c[0];_768=_76c[(_767<0)?1:0]||("-"+_76d);if(_768.indexOf("%")!=-1){_767*=100;}else{if(_768.indexOf("‰")!=-1){_767*=1000;}else{if(_768.indexOf("¤")!=-1){_76a=_769.customs.currencyGroup||_76a;_76b=_769.customs.currencyDecimal||_76b;_768=_768.replace(/\u00a4{1,3}/,function(_76e){var prop=["symbol","currency","displayName"][_76e.length-1];return _769[prop]||_769.currency||"";});}else{if(_768.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _76f=_761._numberPatternRE;var _770=_76d.match(_76f);if(!_770){throw new Error("unable to find a number expression in pattern: "+_768);}if(_769.fractional===false){_769.places=0;}return _768.replace(_76f,_761._formatAbsolute(_767,_770[0],{decimal:_76b,group:_76a,places:_769.places,round:_769.round}));};_761.round=function(_771,_772,_773){var _774=10/(_773||10);return (_774*+_771).toFixed(_772)/_774;};if((0.9).toFixed()==0){var _775=_761.round;_761.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _775(v,p,m)+(v>0?d:-d);};}_761._formatAbsolute=function(_776,_777,_778){_778=_778||{};if(_778.places===true){_778.places=0;}if(_778.places===Infinity){_778.places=6;}var _779=_777.split("."),_77a=typeof _778.places=="string"&&_778.places.indexOf(","),_77b=_778.places;if(_77a){_77b=_778.places.substring(_77a+1);}else{if(!(_77b>=0)){_77b=(_779[1]||[]).length;}}if(!(_778.round<0)){_776=_761.round(_776,_77b,_778.round);}var _77c=String(Math.abs(_776)).split("."),_77d=_77c[1]||"";if(_779[1]||_778.places){if(_77a){_778.places=_778.places.substring(0,_77a);}var pad=_778.places!==undefined?_778.places:(_779[1]&&_779[1].lastIndexOf("0")+1);if(pad>_77d.length){_77c[1]=_75f.pad(_77d,pad,"0",true);}if(_77b<_77d.length){_77c[1]=_77d.substr(0,_77b);}}else{if(_77c[1]){_77c.pop();}}var _77e=_779[0].replace(",","");pad=_77e.indexOf("0");if(pad!=-1){pad=_77e.length-pad;if(pad>_77c[0].length){_77c[0]=_75f.pad(_77c[0],pad);}if(_77e.indexOf("#")==-1){_77c[0]=_77c[0].substr(_77c[0].length-pad);}}var _77f=_779[0].lastIndexOf(","),_780,_781;if(_77f!=-1){_780=_779[0].length-_77f-1;var _782=_779[0].substr(0,_77f);_77f=_782.lastIndexOf(",");if(_77f!=-1){_781=_782.length-_77f-1;}}var _783=[];for(var _784=_77c[0];_784;){var off=_784.length-_780;_783.push((off>0)?_784.substr(off):_784);_784=(off>0)?_784.slice(0,off):"";if(_781){_780=_781;delete _781;}}_77c[0]=_783.reverse().join(_778.group||",");return _77c.join(_778.decimal||".");};_761.regexp=function(_785){return _761._parseInfo(_785).regexp;};_761._parseInfo=function(_786){_786=_786||{};var _787=i18n.normalizeLocale(_786.locale),_788=i18n.getLocalization("dojo.cldr","number",_787),_789=_786.pattern||_788[(_786.type||"decimal")+"Format"],_78a=_788.group,_78b=_788.decimal,_78c=1;if(_789.indexOf("%")!=-1){_78c/=100;}else{if(_789.indexOf("‰")!=-1){_78c/=1000;}else{var _78d=_789.indexOf("¤")!=-1;if(_78d){_78a=_788.currencyGroup||_78a;_78b=_788.currencyDecimal||_78b;}}}var _78e=_789.split(";");if(_78e.length==1){_78e.push("-"+_78e[0]);}var re=_760.buildGroupRE(_78e,function(_78f){_78f="(?:"+_760.escapeString(_78f,".")+")";return _78f.replace(_761._numberPatternRE,function(_790){var _791={signed:false,separator:_786.strict?_78a:[_78a,""],fractional:_786.fractional,decimal:_78b,exponent:false},_792=_790.split("."),_793=_786.places;if(_792.length==1&&_78c!=1){_792[1]="###";}if(_792.length==1||_793===0){_791.fractional=false;}else{if(_793===undefined){_793=_786.pattern?_792[1].lastIndexOf("0")+1:Infinity;}if(_793&&_786.fractional==undefined){_791.fractional=true;}if(!_786.places&&(_793<_792[1].length)){_793+=","+_792[1].length;}_791.places=_793;}var _794=_792[0].split(",");if(_794.length>1){_791.groupSize=_794.pop().length;if(_794.length>1){_791.groupSize2=_794.pop().length;}}return "("+_761._realNumberRegexp(_791)+")";});},true);if(_78d){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_795,_796,_797,_798){var prop=["symbol","currency","displayName"][_797.length-1],_799=_760.escapeString(_786[prop]||_786.currency||"");_796=_796?"[\\s\\xa0]":"";_798=_798?"[\\s\\xa0]":"";if(!_786.strict){if(_796){_796+="*";}if(_798){_798+="*";}return "(?:"+_796+_799+_798+")?";}return _796+_799+_798;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_78a,decimal:_78b,factor:_78c};};_761.parse=function(_79a,_79b){var info=_761._parseInfo(_79b),_79c=(new RegExp("^"+info.regexp+"$")).exec(_79a);if(!_79c){return NaN;}var _79d=_79c[1];if(!_79c[1]){if(!_79c[2]){return NaN;}_79d=_79c[2];info.factor*=-1;}_79d=_79d.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _79d*info.factor;};_761._realNumberRegexp=function(_79e){_79e=_79e||{};if(!("places" in _79e)){_79e.places=Infinity;}if(typeof _79e.decimal!="string"){_79e.decimal=".";}if(!("fractional" in _79e)||/^0/.test(_79e.places)){_79e.fractional=[true,false];}if(!("exponent" in _79e)){_79e.exponent=[true,false];}if(!("eSigned" in _79e)){_79e.eSigned=[true,false];}var _79f=_761._integerRegexp(_79e),_7a0=_760.buildGroupRE(_79e.fractional,function(q){var re="";if(q&&(_79e.places!==0)){re="\\"+_79e.decimal;if(_79e.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_79e.places+"}";}}return re;},true);var _7a1=_760.buildGroupRE(_79e.exponent,function(q){if(q){return "([eE]"+_761._integerRegexp({signed:_79e.eSigned})+")";}return "";});var _7a2=_79f+_7a0;if(_7a0){_7a2="(?:(?:"+_7a2+")|(?:"+_7a0+"))";}return _7a2+_7a1;};_761._integerRegexp=function(_7a3){_7a3=_7a3||{};if(!("signed" in _7a3)){_7a3.signed=[true,false];}if(!("separator" in _7a3)){_7a3.separator="";}else{if(!("groupSize" in _7a3)){_7a3.groupSize=3;}}var _7a4=_760.buildGroupRE(_7a3.signed,function(q){return q?"[-+]":"";},true);var _7a5=_760.buildGroupRE(_7a3.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_760.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_7a3.groupSize,grp2=_7a3.groupSize2;if(grp2){var _7a6="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_7a6+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_7a6;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _7a4+_7a5;};return _761;});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_7a7,_7a8,_7a9,lang,_7aa){return _7a9("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,contextRequire:null,_beforeFillContent:function(){if(this.widgetsInTemplate){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_7aa.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_7ab){this._startupWidgets=_7ab;for(var i=0;i<_7ab.length;i++){this._processTemplateNode(_7ab[i],function(n,p){return n[p];},function(_7ac,type,_7ad){if(type in _7ac){return _7ac.connect(_7ac,type,_7ad);}else{return _7ac.on(type,_7ad,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_7ae,_7af,_7b0){if(_7af(_7ae,"dojoType")||_7af(_7ae,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_7a7.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dijit/form/HorizontalRuleLabels":function(){define(["dojo/_base/declare","dojo/has","dojo/number","dojo/query","dojo/_base/lang","./HorizontalRule"],function(_7b1,has,_7b2,_7b3,lang,_7b4){var _7b5=_7b1("dijit.form.HorizontalRuleLabels",_7b4,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){return pos;},_genHTML:function(pos,ndx){var _7b6=this.labels[ndx];return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._genDirectionHTML(_7b6)+this._labelPrefix+_7b6+this._suffix;},_genDirectionHTML:function(_7b7){return "";},getLabels:function(){var _7b8=this.labels;if(!_7b8.length&&this.srcNodeRef){_7b8=_7b3("> li",this.srcNodeRef).map(function(node){return String(node.innerHTML);});}if(!_7b8.length&&this.count>1){var _7b9=this.minimum;var inc=(this.maximum-_7b9)/(this.count-1);for(var i=0;i<this.count;i++){_7b8.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_7b2.format(_7b9,this.constraints));_7b9+=inc;}}return _7b8;},postMixInProperties:function(){this.inherited(arguments);this.labels=this.getLabels();this.count=this.labels.length;}});if(has("dojo-bidi")){_7b5.extend({_setTextDirAttr:function(_7ba){if(this.textDir!=_7ba){this._set("textDir",_7ba);_7b3(".dijitRuleLabelContainer",this.domNode).forEach(lang.hitch(this,function(_7bb){_7bb.style.direction=this.getTextDir(_7bb.innerText||_7bb.textContent||"");}));}},_genDirectionHTML:function(_7bc){return (this.textDir?("direction:"+this.getTextDir(_7bc)+";"):"");}});}return _7b5;});},"dijit/form/FilteringSelect":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_7bd,lang,when,_7be,_7bf){return _7bd("dijit.form.FilteringSelect",[_7be,_7bf],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){return this._opened;},isValid:function(){return !!this.item||(!this.required&&this.get("displayedValue")=="");},_refreshState:function(){if(!this.searchTimer){this.inherited(arguments);}},_callbackSetLabel:function(_7c0,_7c1,_7c2,_7c3){if((_7c1&&_7c1[this.searchAttr]!==this._lastQuery)||(!_7c1&&_7c0.length&&this.store.getIdentity(_7c0[0])!=this._lastQuery)){return;}if(!_7c0.length){this.set("value","",_7c3||(_7c3===undefined&&!this.focused),this.textbox.value,null);}else{this.set("item",_7c0[0],_7c3);}},_openResultList:function(_7c4,_7c5,_7c6){if(_7c5[this.searchAttr]!==this._lastQuery){return;}this.inherited(arguments);if(this.item===undefined){this.validate(true);}},_getValueAttr:function(){return this.valueNode.value;},_getValueField:function(){return "value";},_setValueAttr:function(_7c7,_7c8,_7c9,item){if(!this._onChangeActive){_7c8=null;}if(item===undefined){if(_7c7===null||_7c7===""){_7c7="";if(!lang.isString(_7c9)){this._setDisplayedValueAttr(_7c9||"",_7c8);return;}}var self=this;this._lastQuery=_7c7;when(this.store.get(_7c7),function(item){self._callbackSetLabel(item?[item]:[],undefined,undefined,_7c8);});}else{this.valueNode.value=_7c7;this.inherited(arguments,[_7c7,_7c8,_7c9,item]);}},_setItemAttr:function(item,_7ca,_7cb){this.inherited(arguments);this._lastDisplayedValue=this.textbox.value;},_getDisplayQueryString:function(text){return text.replace(/([\\\*\?])/g,"\\$1");},_setDisplayedValueAttr:function(_7cc,_7cd){if(_7cc==null){_7cc="";}if(!this._created){if(!("displayedValue" in this.params)){return;}_7cd=false;}if(this.store){this.closeDropDown();var _7ce=lang.clone(this.query);var qs=this._getDisplayQueryString(_7cc),q;if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_7ce[this.searchAttr]=q;this.textbox.value=_7cc;this._lastDisplayedValue=_7cc;this._set("displayedValue",_7cc);var _7cf=this;var _7d0={queryOptions:{ignoreCase:this.ignoreCase,deep:true}};lang.mixin(_7d0,this.fetchProperties);this._fetchHandle=this.store.query(_7ce,_7d0);when(this._fetchHandle,function(_7d1){_7cf._fetchHandle=null;_7cf._callbackSetLabel(_7d1||[],_7ce,_7d0,_7cd);},function(err){_7cf._fetchHandle=null;if(!_7cf._cancelingQuery){console.error("dijit.form.FilteringSelect: "+err.toString());}});}},undo:function(){this.set("displayedValue",this._lastDisplayedValue);}});});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _7d2={};lang.setObject("dojo.data.util.sorter",_7d2);_7d2.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_7d2.createSortFunction=function(_7d3,_7d4){var _7d5=[];function _7d6(attr,dir,comp,s){return function(_7d7,_7d8){var a=s.getValue(_7d7,attr);var b=s.getValue(_7d8,attr);return dir*comp(a,b);};};var _7d9;var map=_7d4.comparatorMap;var bc=_7d2.basicComparator;for(var i=0;i<_7d3.length;i++){_7d9=_7d3[i];var attr=_7d9.attribute;if(attr){var dir=(_7d9.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_7d5.push(_7d6(attr,dir,comp,_7d4));}}return function(rowA,rowB){var i=0;while(i<_7d5.length){var ret=_7d5[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _7d2;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_7da,dom,has,_7db){var _7dc=_7da("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}var _7dd=e.defaultPrevented;if(!_7dd&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _7de=_7db.byNode(node);if(_7de&&typeof _7de._onSubmit=="function"){_7de._onSubmit(e);e.preventDefault();_7dd=true;break;}}}return !_7dd;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_7df){this._set("label",_7df);var _7e0=this.containerNode||this.focusNode;_7e0.innerHTML=_7df;}});if(has("dojo-bidi")){_7dc=_7da("dijit.form._ButtonMixin",_7dc,{_setLabelAttr:function(){this.inherited(arguments);var _7e1=this.containerNode||this.focusNode;this.applyTextDir(_7e1);}});}return _7dc;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_7e2,_7e3){var _7e4={};lang.setObject("dojo.colors",_7e4);var _7e5=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_7e2.fromRgb=function(_7e6,obj){var m=_7e6.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_7e3.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _7e2.fromArray(a,obj);}return _7e2.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_7e5(m1,m2,H+1/3)*256,_7e5(m1,m2,H)*256,_7e5(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _7e2.fromArray(a,obj);}}return null;};var _7e7=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_7e2.prototype.sanitize=function(){var t=this;t.r=Math.round(_7e7(t.r,0,255));t.g=Math.round(_7e7(t.g,0,255));t.b=Math.round(_7e7(t.b,0,255));t.a=_7e7(t.a,0,1);return this;};_7e4.makeGrey=_7e2.makeGrey=function(g,a){return _7e2.fromArray([g,g,g,a]);};lang.mixin(_7e2.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _7e2;});},"dijit/tree/_dndContainer":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/touch"],function(_7e8,_7e9,_7ea,lang,on,_7eb){return _7e9("dijit.tree._dndContainer",null,{constructor:function(tree,_7ec){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_7ec);this.containerState="";_7ea.add(this.node,"dojoDndContainer");this.events=[on(this.node,_7eb.enter,lang.hitch(this,"onOverEvent")),on(this.node,_7eb.leave,lang.hitch(this,"onOutEvent")),_7e8.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_7e8.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart, selectstart",function(evt){evt.preventDefault();})];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_7ed){this.current=_7ed;},onMouseOut:function(){this.current=null;},_changeState:function(type,_7ee){var _7ef="dojoDnd"+type;var _7f0=type.toLowerCase()+"State";_7ea.replace(this.node,_7ef+_7ee,_7ef+this[_7f0]);this[_7f0]=_7ee;},_addItemClass:function(node,type){_7ea.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_7ea.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dojo/date/locale":function(){define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_7f1,date,_7f2,i18n,_7f3,_7f4,_7f5,_7f6){var _7f7={};lang.setObject(_7f6.id.replace(/\//g,"."),_7f7);function _7f8(_7f9,_7fa,_7fb,_7fc){return _7fc.replace(/([a-z])\1*/ig,function(_7fd){var s,pad,c=_7fd.charAt(0),l=_7fd.length,_7fe=["abbr","wide","narrow"];switch(c){case "G":s=_7fa[(l<4)?"eraAbbr":"eraNames"][_7f9.getFullYear()<0?0:1];break;case "y":s=_7f9.getFullYear();switch(l){case 1:break;case 2:if(!_7fb.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_7f9.getMonth()+1)/3);pad=true;break;case "M":case "L":var m=_7f9.getMonth();if(l<3){s=m+1;pad=true;}else{var _7ff=["months",c=="L"?"standAlone":"format",_7fe[l-3]].join("-");s=_7fa[_7ff][m];}break;case "w":var _800=0;s=_7f7._getWeekOfYear(_7f9,_800);pad=true;break;case "d":s=_7f9.getDate();pad=true;break;case "D":s=_7f7._getDayOfYear(_7f9);pad=true;break;case "e":case "c":var d=_7f9.getDay();if(l<2){s=(d-_7f2.getFirstDayOfWeek(_7fb.locale)+8)%7;break;}case "E":d=_7f9.getDay();if(l<3){s=d+1;pad=true;}else{var _801=["days",c=="c"?"standAlone":"format",_7fe[l-3]].join("-");s=_7fa[_801][d];}break;case "a":var _802=_7f9.getHours()<12?"am":"pm";s=_7fb[_802]||_7fa["dayPeriods-format-wide-"+_802];break;case "h":case "H":case "K":case "k":var h=_7f9.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_7f9.getMinutes();pad=true;break;case "s":s=_7f9.getSeconds();pad=true;break;case "S":s=Math.round(_7f9.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=_7f7._getZone(_7f9,true,_7fb);if(s){break;}l=4;case "Z":var _803=_7f7._getZone(_7f9,false,_7fb);var tz=[(_803<=0?"+":"-"),_7f4.pad(Math.floor(Math.abs(_803)/60),2),_7f4.pad(Math.abs(_803)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_7fc);}if(pad){s=_7f4.pad(s,l);}return s;});};_7f7._getZone=function(_804,_805,_806){if(_805){return date.getTimezoneName(_804);}else{return _804.getTimezoneOffset();}};_7f7.format=function(_807,_808){_808=_808||{};var _809=i18n.normalizeLocale(_808.locale),_80a=_808.formatLength||"short",_80b=_7f7._getGregorianBundle(_809),str=[],_80c=lang.hitch(this,_7f8,_807,_80b,_808);if(_808.selector=="year"){return _80d(_80b["dateFormatItem-yyyy"]||"yyyy",_80c);}var _80e;if(_808.selector!="date"){_80e=_808.timePattern||_80b["timeFormat-"+_80a];if(_80e){str.push(_80d(_80e,_80c));}}if(_808.selector!="time"){_80e=_808.datePattern||_80b["dateFormat-"+_80a];if(_80e){str.push(_80d(_80e,_80c));}}return str.length==1?str[0]:_80b["dateTimeFormat-"+_80a].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_80f,key){return str[key];});};_7f7.regexp=function(_810){return _7f7._parseInfo(_810).regexp;};_7f7._parseInfo=function(_811){_811=_811||{};var _812=i18n.normalizeLocale(_811.locale),_813=_7f7._getGregorianBundle(_812),_814=_811.formatLength||"short",_815=_811.datePattern||_813["dateFormat-"+_814],_816=_811.timePattern||_813["timeFormat-"+_814],_817;if(_811.selector=="date"){_817=_815;}else{if(_811.selector=="time"){_817=_816;}else{_817=_813["dateTimeFormat-"+_814].replace(/\{(\d+)\}/g,function(_818,key){return [_816,_815][key];});}}var _819=[],re=_80d(_817,lang.hitch(this,_81a,_819,_813,_811));return {regexp:re,tokens:_819,bundle:_813};};_7f7.parse=function(_81b,_81c){var _81d=/[\u200E\u200F\u202A\u202E]/g,info=_7f7._parseInfo(_81c),_81e=info.tokens,_81f=info.bundle,re=new RegExp("^"+info.regexp.replace(_81d,"")+"$",info.strict?"":"i"),_820=re.exec(_81b&&_81b.replace(_81d,""));if(!_820){return null;}var _821=["abbr","wide","narrow"],_822=[1970,0,1,0,0,0,0],amPm="",_823=_7f1.every(_820,function(v,i){if(!i){return true;}var _824=_81e[i-1],l=_824.length,c=_824.charAt(0);switch(c){case "y":if(l!=2&&_81c.strict){_822[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_825=year.substring(0,2)*100,_826=Math.min(Number(year.substring(2,4))+20,99);_822[0]=(v<_826)?_825+v:_825-100+v;}else{if(_81c.strict){return false;}_822[0]=v;}}break;case "M":case "L":if(l>2){var _827=_81f["months-"+(c=="L"?"standAlone":"format")+"-"+_821[l-3]].concat();if(!_81c.strict){v=v.replace(".","").toLowerCase();_827=_7f1.map(_827,function(s){return s.replace(".","").toLowerCase();});}v=_7f1.indexOf(_827,v);if(v==-1){return false;}}else{v--;}_822[1]=v;break;case "E":case "e":case "c":var days=_81f["days-"+(c=="c"?"standAlone":"format")+"-"+_821[l-3]].concat();if(!_81c.strict){v=v.toLowerCase();days=_7f1.map(days,function(d){return d.toLowerCase();});}v=_7f1.indexOf(days,v);if(v==-1){return false;}break;case "D":_822[1]=0;case "d":_822[2]=v;break;case "a":var am=_81c.am||_81f["dayPeriods-format-wide-am"],pm=_81c.pm||_81f["dayPeriods-format-wide-pm"];if(!_81c.strict){var _828=/\./g;v=v.replace(_828,"").toLowerCase();am=am.replace(_828,"").toLowerCase();pm=pm.replace(_828,"").toLowerCase();}if(_81c.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_822[3]=v;break;case "m":_822[4]=v;break;case "s":_822[5]=v;break;case "S":_822[6]=v;}return true;});var _829=+_822[3];if(amPm==="p"&&_829<12){_822[3]=_829+12;}else{if(amPm==="a"&&_829==12){_822[3]=0;}}var _82a=new Date(_822[0],_822[1],_822[2],_822[3],_822[4],_822[5],_822[6]);if(_81c.strict){_82a.setFullYear(_822[0]);}var _82b=_81e.join(""),_82c=_82b.indexOf("d")!=-1,_82d=_82b.indexOf("M")!=-1;if(!_823||(_82d&&_82a.getMonth()>_822[1])||(_82c&&_82a.getDate()>_822[2])){return null;}if((_82d&&_82a.getMonth()<_822[1])||(_82c&&_82a.getDate()<_822[2])){_82a=date.add(_82a,"hour",1);}return _82a;};function _80d(_82e,_82f,_830,_831){var _832=function(x){return x;};_82f=_82f||_832;_830=_830||_832;_831=_831||_832;var _833=_82e.match(/(''|[^'])+/g),_834=_82e.charAt(0)=="'";_7f1.forEach(_833,function(_835,i){if(!_835){_833[i]="";}else{_833[i]=(_834?_830:_82f)(_835.replace(/''/g,"'"));_834=!_834;}});return _831(_833.join(""));};function _81a(_836,_837,_838,_839){_839=_7f3.escapeString(_839);if(!_838.strict){_839=_839.replace(" a"," ?a");}return _839.replace(/([a-z])\1*/ig,function(_83a){var s,c=_83a.charAt(0),l=_83a.length,p2="",p3="";if(_838.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":case "L":s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":case "e":case "c":s=".+?";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_838.am||_837["dayPeriods-format-wide-am"],pm=_838.pm||_837["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_838.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_836){_836.push(_83a);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _83b=[];_7f7.addCustomFormats=function(_83c,_83d){_83b.push({pkg:_83c,name:_83d});};_7f7._getGregorianBundle=function(_83e){var _83f={};_7f1.forEach(_83b,function(desc){var _840=i18n.getLocalization(desc.pkg,desc.name,_83e);_83f=lang.mixin(_83f,_840);},this);return _83f;};_7f7.addCustomFormats(_7f6.id.replace(/\/date\/locale$/,".cldr"),"gregorian");_7f7.getNames=function(item,type,_841,_842){var _843,_844=_7f7._getGregorianBundle(_842),_845=[item,_841,type];if(_841=="standAlone"){var key=_845.join("-");_843=_844[key];if(_843[0]==1){_843=undefined;}}_845[1]="format";return (_843||_844[_845.join("-")]).concat();};_7f7.isWeekend=function(_846,_847){var _848=_7f2.getWeekend(_847),day=(_846||new Date()).getDay();if(_848.end<_848.start){_848.end+=7;if(day<_848.start){day+=7;}}return day>=_848.start&&day<=_848.end;};_7f7._getDayOfYear=function(_849){return date.difference(new Date(_849.getFullYear(),0,1,_849.getHours()),_849)+1;};_7f7._getWeekOfYear=function(_84a,_84b){if(arguments.length==1){_84b=0;}var _84c=new Date(_84a.getFullYear(),0,1).getDay(),adj=(_84c-_84b+7)%7,week=Math.floor((_7f7._getDayOfYear(_84a)+adj-1)/7);if(_84c==_84b){week++;}return week;};return _7f7;});},"dijit/form/VerticalRule":function(){define(["dojo/_base/declare","./HorizontalRule"],function(_84d,_84e){return _84d("dijit.form.VerticalRule",_84e,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_84f,_850,_851,_852,_853,dom,_854,_855,lang,_856,when,_857,_858){var _859=_853("dijit.form._FormSelectWidget",_858,{multiple:false,options:null,store:null,_setStoreAttr:function(val){if(this._created){this._deprecatedSetStore(val);}},query:null,_setQueryAttr:function(_85a){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{query:_85a});}},queryOptions:null,_setQueryOptionsAttr:function(_85b){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{queryOptions:_85b});}},labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_85c){var opts=this.options||[];if(_85c==null){return opts;}if(lang.isArray(_85c)){return _84f.map(_85c,"return this.getOptions(item);",this);}if(lang.isString(_85c)){_85c={value:_85c};}if(lang.isObject(_85c)){if(!_84f.some(opts,function(_85d,idx){for(var a in _85c){if(!(a in _85d)||_85d[a]!=_85c[a]){return false;}}_85c=idx;return true;})){_85c=-1;}}if(_85c>=0&&_85c<opts.length){return opts[_85c];}return null;},addOption:function(_85e){_84f.forEach(lang.isArray(_85e)?_85e:[_85e],function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_85f){var _860=this.getOptions(lang.isArray(_85f)?_85f:[_85f]);_84f.forEach(_860,function(_861){if(_861){this.options=_84f.filter(this.options,function(node){return (node.value!==_861.value||node.label!==_861.label);});this._removeOptionItem(_861);}},this);this._loadChildren();},updateOption:function(_862){_84f.forEach(lang.isArray(_862)?_862:[_862],function(i){var _863=this.getOptions({value:i.value}),k;if(_863){for(k in i){_863[k]=i[k];}}},this);this._loadChildren();},setStore:function(_864,_865,_866){_855.deprecated(this.declaredClass+"::setStore(store, selectedValue, fetchArgs) is deprecated. Use set('query', fetchArgs.query), set('queryOptions', fetchArgs.queryOptions), set('store', store), or set('value', selectedValue) instead.","","2.0");this._deprecatedSetStore(_864,_865,_866);},_deprecatedSetStore:function(_867,_868,_869){var _86a=this.store;_869=_869||{};if(_86a!==_867){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_867.get){lang.mixin(_867,{_oldAPI:true,get:function(id){var _86b=new _850();this.fetchItemByIdentity({identity:id,onItem:function(_86c){_86b.resolve(_86c);},onError:function(_86d){_86b.reject(_86d);}});return _86b.promise;},query:function(_86e,_86f){var _870=new _850(function(){if(_871.abort){_871.abort();}});_870.total=new _850();var _871=this.fetch(lang.mixin({query:_86e,onBegin:function(_872){_870.total.resolve(_872);},onComplete:function(_873){_870.resolve(_873);},onError:function(_874){_870.reject(_874);}},_86f));return new _857(_870);}});if(_867.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_851.after(_867,"onNew",lang.hitch(this,"_onNewItem"),true),_851.after(_867,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_851.after(_867,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_867);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}if(_869.query){this._set("query",_869.query);}if(_869.queryOptions){this._set("queryOptions",_869.queryOptions);}if(_867&&_867.query){this._loadingStore=true;this.onLoadDeferred=new _850();this._queryRes=_867.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_875){if(this.sortByLabel&&!_869.sort&&_875.length){if(_867.getValue){_875.sort(_852.createSortFunction([{attribute:_867.getLabelAttributes(_875[0])[0]}],_867));}else{var _876=this.labelAttr;_875.sort(function(a,b){return a[_876]>b[_876]?1:b[_876]>a[_876]?-1:0;});}}if(_869.onFetch){_875=_869.onFetch.call(this,_875,_869);}_84f.forEach(_875,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._observeHandle=this._queryRes.observe(lang.hitch(this,function(_877,_878,_879){if(_878==_879){this._onSetItem(_877);}else{if(_878!=-1){this._onDeleteItem(_877);}if(_879!=-1){this._onNewItem(_877);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_868);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_875);}this.onLoadDeferred.resolve(true);this.onSetStore();}),function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);});}return _86a;},_setValueAttr:function(_87a,_87b){if(!this._onChangeActive){_87b=null;}if(this._loadingStore){this._pendingValue=_87a;return;}if(_87a==null){return;}if(lang.isArray(_87a)){_87a=_84f.map(_87a,function(_87c){return lang.isObject(_87c)?_87c:{value:_87c};});}else{if(lang.isObject(_87a)){_87a=[_87a];}else{_87a=[{value:_87a}];}}_87a=_84f.filter(this.getOptions(_87a),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_87a[0]||!_87a[0].value)&&!!opts.length){_87a[0]=opts[0];}_84f.forEach(opts,function(opt){opt.selected=_84f.some(_87a,function(v){return v.value===opt.value;});});var val=_84f.map(_87a,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_84f.map(_87a,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_87b]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_84f.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_87d){this.set("value",this.getOptions(typeof _87d=="string"?{label:_87d}:_87d));},_loadChildren:function(){if(this._loadingStore){return;}_84f.forEach(this._getChildren(),function(_87e){_87e.destroyRecursive();});_84f.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_84f.forEach(this._getChildren(),function(_87f){var _880=_84f.some(val,function(v){return _87f.option&&(v===_87f.option.value);});if(_880&&!self.multiple){self.focusedChild=_87f;}_854.toggle(_87f.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_880);_87f.domNode.setAttribute("aria-selected",_880?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_84f.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _84f.map(_84f.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_881){if(!_881||!_881.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _882=this.store;this.removeOption({value:_882.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _883=this.store,_884=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_883.getLabel(item),_885=(_884?_883.getIdentity(item):null);return {value:_885,label:_884,item:item};},_addOptionForItem:function(item){var _886=this.store;if(_886.isItemLoaded&&!_886.isItemLoaded(item)){_886.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _887=this._getOptionObjForItem(item);this.addOption(_887);},constructor:function(_888){this._oValue=(_888||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_856("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_855._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_851.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _889=this.store;if(_889&&(_889.getIdentity||_889.getFeatures()["dojo.data.api.Identity"])){this.store=null;this._deprecatedSetStore(_889,this._oValue,{query:this.query,queryOptions:this.queryOptions});}this._storeInitialized=true;},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _859;});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_88a,_88b,_88c,_88d,_88e,i18n,keys,lang,on,has,_88f,_890,_891,_892,_893,_894,_895,_896,_897){var _898=_88b("dijit.form._SelectMenu",_891,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _899=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_88a.forEach(this.parentWidget._getChildren(),function(_89a){if(_89a.option&&(val===_89a.option.value)){_899=true;this.focusChild(_89a,false);}},this);}if(!_899){this.inherited(arguments);}}});var _89b=_88b("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_88f,_890,_895],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_897,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,labelType:"html",_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _898({id:this.id+"_menu",parentWidget:this});_88d.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_89c){if(!_89c.value&&!_89c.label){return new _893({ownerDocument:this.ownerDocument});}else{var _89d=lang.hitch(this,"_setValueAttr",_89c);var item=new _892({option:_89c,label:(this.labelType==="text"?(_89c.label||"").toString().replace(/&/g,"&amp;").replace(/</g,"&lt;"):_89c.label)||this.emptyLabel,onClick:_89d,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_89c.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_89e){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_89e));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_89f){if(_89f){this.set("value",_89f.option);}},_getFirst:function(){var _8a0=this._getChildren();return _8a0.length?_8a0[0]:null;},_getLast:function(){var _8a1=this._getChildren();return _8a1.length?_8a1[_8a1.length-1]:null;},childSelector:function(node){var node=_896.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_8a2,_8a3){if(item){this.focusChild(item);}},_loadChildren:function(_8a4){if(_8a4===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_88a.forEach(this._getChildren(),function(_8a5){_8a5.destroyRecursive();});var item=new _892({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_8a6){this.inherited(arguments);_88c.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_8a7){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_8a8){this._set("required",_8a8);this.focusNode.setAttribute("aria-required",_8a8);this._refreshState();},_setOptionsAttr:function(_8a9){this._isLoaded=false;this._set("options",_8a9);},_setDisplay:function(_8aa){var lbl=(this.labelType==="text"?(_8aa||"").replace(/&/g,"&amp;").replace(/</g,"&lt;"):_8aa)||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_8ab){var _8ac=this.disabled||this.isValid(_8ab);this._set("state",_8ac?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_8ac?"false":"true");var _8ad=_8ac?"":this._missingMsg;if(_8ad&&this.focused&&this._hasBeenBlurred){_894.show(_8ad,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_894.hide(this.domNode);}this._set("message",_8ad);return _8ac;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_894.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");var _8ae=this._keyNavCodes;delete _8ae[keys.LEFT_ARROW];delete _8ae[keys.RIGHT_ARROW];},_setStyleAttr:function(_8af){this.inherited(arguments);_88d.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_8b0){this._loadChildren(true);this._isLoaded=true;_8b0();},destroy:function(_8b1){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_8b1);delete this.dropDown;}_894.hide(this.domNode);this.inherited(arguments);},_onFocus:function(){this.validate(true);},_onBlur:function(){_894.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_89b=_88b("dijit.form.Select",_89b,{_setDisplay:function(_8b2){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_89b._Menu=_898;function _8b3(_8b4){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_8b4,evt));}else{this.inherited(_8b4,arguments);}};};_89b.prototype._onContainerKeydown=_8b3("_onContainerKeydown");_89b.prototype._onContainerKeypress=_8b3("_onContainerKeypress");return _89b;});},"dijit/_editor/range":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang"],function(_8b5,_8b6,lang){var _8b7={getIndex:function(node,_8b8){var ret=[],retR=[];var _8b9=node;var _8ba,n;while(node!=_8b8){var i=0;_8ba=node.parentNode;while((n=_8ba.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-_8ba.childNodes.length);node=_8ba;}if(ret.length>0&&_8b9.nodeType==3){n=_8b9.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=_8b9.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};},getNode:function(_8bb,_8bc){if(!lang.isArray(_8bb)||_8bb.length==0){return _8bc;}var node=_8bc;_8b5.every(_8bb,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;},getCommonAncestor:function(n1,n2,root){root=root||n1.ownerDocument.body;var _8bd=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_8bd(n1);var n2as=_8bd(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;},getAncestor:function(node,_8be,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(_8be.test(name)){return node;}node=node.parentNode;}return null;},BlockTagNames:/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/,getBlockAncestor:function(node,_8bf,root){root=root||node.ownerDocument.body;_8bf=_8bf||_8b7.BlockTagNames;var _8c0=null,_8c1;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!_8c0&&_8bf.test(name)){_8c0=node;}if(!_8c1&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_8c1=node;}node=node.parentNode;}return {blockNode:_8c0,blockContainer:_8c1||node.ownerDocument.body};},atBeginningOfContainer:function(_8c2,node,_8c3){var _8c4=false;var _8c5=(_8c3==0);if(!_8c5&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_8c3))){_8c5=true;}}if(_8c5){var _8c6=node;_8c4=true;while(_8c6&&_8c6!==_8c2){if(_8c6.previousSibling){_8c4=false;break;}_8c6=_8c6.parentNode;}}return _8c4;},atEndOfContainer:function(_8c7,node,_8c8){var _8c9=false;var _8ca=(_8c8==(node.length||node.childNodes.length));if(!_8ca&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_8c8))){_8ca=true;}}if(_8ca){var _8cb=node;_8c9=true;while(_8cb&&_8cb!==_8c7){if(_8cb.nextSibling){_8c9=false;break;}_8cb=_8cb.parentNode;}}return _8c9;},adjacentNoneTextNode:function(_8cc,next){var node=_8cc;var len=(0-_8cc.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];},create:function(win){win=win||window;if(win.getSelection){return win.document.createRange();}else{return new _8cd();}},getSelection:function(_8ce,_8cf){if(_8ce.getSelection){return _8ce.getSelection();}else{var s=new ie.selection(_8ce);if(!_8cf){s._getCurrentSelection();}return s;}}};if(!window.getSelection){var ie=_8b7.ie={cachedSelection:{},selection:function(_8d0){this._ranges=[];this.addRange=function(r,_8d1){this._ranges.push(r);if(!_8d1){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _8d2=function(){var r=_8d0.document.selection.createRange();var type=_8d0.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _8cd(ie.decomposeControlRange(r));}else{return new _8cd(ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_8d2();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(_8d3){var _8d4=_8d3.item(0),_8d5=_8d3.item(_8d3.length-1);var _8d6=_8d4.parentNode,_8d7=_8d5.parentNode;var _8d8=_8b7.getIndex(_8d4,_8d6).o[0];var _8d9=_8b7.getIndex(_8d5,_8d7).o[0]+1;return [_8d6,_8d8,_8d7,_8d9];},getEndPoint:function(_8da,end){var _8db=_8da.duplicate();_8db.collapse(!end);var _8dc="EndTo"+(end?"End":"Start");var _8dd=_8db.parentElement();var _8de,_8df,_8e0;if(_8dd.childNodes.length>0){_8b5.every(_8dd.childNodes,function(node,i){var _8e1;if(node.nodeType!=3){_8db.moveToElementText(node);if(_8db.compareEndPoints(_8dc,_8da)>0){if(_8e0&&_8e0.nodeType==3){_8de=_8e0;_8e1=true;}else{_8de=_8dd;_8df=i;return false;}}else{if(i==_8dd.childNodes.length-1){_8de=_8dd;_8df=_8dd.childNodes.length;return false;}}}else{if(i==_8dd.childNodes.length-1){_8de=node;_8e1=true;}}if(_8e1&&_8de){var _8e2=_8b7.adjacentNoneTextNode(_8de)[0];if(_8e2){_8de=_8e2.nextSibling;}else{_8de=_8dd.firstChild;}var _8e3=_8b7.adjacentNoneTextNode(_8de);_8e2=_8e3[0];var _8e4=_8e3[1];if(_8e2){_8db.moveToElementText(_8e2);_8db.collapse(false);}else{_8db.moveToElementText(_8dd);}_8db.setEndPoint(_8dc,_8da);_8df=_8db.text.length-_8e4;return false;}_8e0=node;return true;});}else{_8de=_8dd;_8df=0;}if(!end&&_8de.nodeType==1&&_8df==_8de.childNodes.length){var _8e5=_8de.nextSibling;if(_8e5&&_8e5.nodeType==3){_8de=_8e5;_8df=0;}}return [_8de,_8df];},setEndPoint:function(_8e6,_8e7,_8e8){var _8e9=_8e6.duplicate(),node,len;if(_8e7.nodeType!=3){if(_8e8>0){node=_8e7.childNodes[_8e8-1];if(node){if(node.nodeType==3){_8e7=node;_8e8=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_8e7=node.nextSibling;_8e8=0;}else{_8e9.moveToElementText(node.nextSibling?node:_8e7);var _8ea=node.parentNode;var _8eb=_8ea.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_8e9.collapse(false);_8ea.removeChild(_8eb);}}}}else{_8e9.moveToElementText(_8e7);_8e9.collapse(true);}}if(_8e7.nodeType==3){var _8ec=_8b7.adjacentNoneTextNode(_8e7);var _8ed=_8ec[0];len=_8ec[1];if(_8ed){_8e9.moveToElementText(_8ed);_8e9.collapse(false);if(_8ed.contentEditable!="inherit"){len++;}}else{_8e9.moveToElementText(_8e7.parentNode);_8e9.collapse(true);_8e9.move("character",1);_8e9.move("character",-1);}_8e8+=len;if(_8e8>0){if(_8e9.move("character",_8e8)!=_8e8){console.error("Error when moving!");}}}return _8e9;},decomposeTextRange:function(_8ee){var _8ef=ie.getEndPoint(_8ee);var _8f0=_8ef[0],_8f1=_8ef[1];var _8f2=_8ef[0],_8f3=_8ef[1];if(_8ee.htmlText.length){if(_8ee.htmlText==_8ee.text){_8f3=_8f1+_8ee.text.length;}else{_8ef=ie.getEndPoint(_8ee,true);_8f2=_8ef[0],_8f3=_8ef[1];}}return [_8f0,_8f1,_8f2,_8f3];},setRange:function(_8f4,_8f5,_8f6,_8f7,_8f8,_8f9){var _8fa=ie.setEndPoint(_8f4,_8f5,_8f6);_8f4.setEndPoint("StartToStart",_8fa);if(!_8f9){var end=ie.setEndPoint(_8f4,_8f7,_8f8);}_8f4.setEndPoint("EndToEnd",end||_8fa);return _8f4;}};var _8cd=_8b7.W3CRange=_8b6(null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_8b7.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_8fb){_8fb=parseInt(_8fb);if(this.startContainer===node&&this.startOffset==_8fb){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_8fb;if(!this.endContainer){this.setEnd(node,_8fb);}else{this._updateInternal();}},setEnd:function(node,_8fc){_8fc=parseInt(_8fc);if(this.endContainer===node&&this.endOffset==_8fc){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_8fc;if(!this.startContainer){this.setStart(node,_8fc);}else{this._updateInternal();}},setStartAfter:function(node,_8fd){this._setPoint("setStart",node,_8fd,1);},setStartBefore:function(node,_8fe){this._setPoint("setStart",node,_8fe,0);},setEndAfter:function(node,_8ff){this._setPoint("setEnd",node,_8ff,1);},setEndBefore:function(node,_900){this._setPoint("setEnd",node,_900,0);},_setPoint:function(what,node,_901,ext){var _902=_8b7.getIndex(node,node.parentNode).o;this[what](node.parentNode,_902.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _8cd([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}lang.setObject("dijit.range",_8b7);return _8b7;});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_903,_904,_905,keys,lang,on,_906,_907){return _904("dijit._KeyNavMixin",_907,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_905.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _908=this._keyNavCodes={};_908[keys.HOME]=lang.hitch(this,"focusFirstChild");_908[keys.END]=lang.hitch(this,"focusLastChild");_908[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_908[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_908[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_908[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_909=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_909,"focusin"),function(evt){self._onChildFocus(_906.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_90a,last){if(!_90a){return;}if(this.focusedChild&&_90a!==this.focusedChild){this._onChildBlur(this.focusedChild);}_90a.set("tabIndex",this.tabIndex);_90a.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_905.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_905.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_90b){if(_90b&&_90b!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_90b.set("tabIndex",this.tabIndex);this.lastFocused=_90b;this._set("focusedChild",_90b);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_90c,_90d){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_90e){var _90f=item.domNode,text=item.label||(_90f.focusNode?_90f.focusNode.label:"")||_90f.innerText||_90f.textContent||"",_910=text.replace(/^\s+/,"").substr(0,_90e.length).toLowerCase();return (!!_90e.length&&_910==_90e)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey||evt.metaKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<=keys.SPACE||evt.ctrlKey||evt.altKey||evt.metaKey){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_911){var _912=null,_913,_914=0,_915=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_911;var _916=/^(.)\1*$/.test(this._searchString);var _917=_916?1:this._searchString.length;_913=this._searchString.substr(0,_917);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _918=this.focusedChild||null;if(_917==1||!_918){_918=this._getNextFocusableChild(_918,1);if(!_918){return;}}var stop=_918;do{var rc=this._keyboardSearchCompare(_918,_913);if(!!rc&&_914++==0){_912=_918;}if(rc==-1){_914=-1;break;}_918=this._getNextFocusableChild(_918,1);}while(_918!=stop);});_915();this.onKeyboardSearch(_912,evt,_913,_914);},_onChildBlur:function(){},_getNextFocusableChild:function(_919,dir){var _91a=_919;do{if(!_919){_919=this[dir>0?"_getFirst":"_getLast"]();if(!_919){break;}}else{_919=this._getNext(_919,dir);}if(_919!=null&&_919!=_91a&&_919.isFocusable()){return _919;}}while(_919!=_91a);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_91b,dir){if(_91b){_91b=_91b.domNode;while(_91b){_91b=_91b[dir<0?"previousSibling":"nextSibling"];if(_91b&&"getAttribute" in _91b){var w=_906.byNode(_91b);if(w){return w;}}}}return null;}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_91c,lang,when){var _91d=function(_91e){if(!_91e){return _91e;}var _91f=!!_91e.then;if(_91f){_91e=lang.delegate(_91e);}function _920(_921){_91e[_921]=function(){var args=arguments;var _922=when(_91e,function(_923){Array.prototype.unshift.call(args,_923);return _91d(_91c[_921].apply(_91c,args));});if(_921!=="forEach"||_91f){return _922;}};};_920("forEach");_920("filter");_920("map");if(_91e.total==null){_91e.total=when(_91e,function(_924){return _924.length;});}return _91e;};lang.setObject("dojo.store.util.QueryResults",_91d);return _91d;});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_925,on,_926){return _925("dijit.form._ListBase",null,{selected:null,_listConnect:function(_927,_928){var self=this;return self.own(on(self.containerNode,on.selector(function(_929,_92a,_92b){return _929.parentNode==_92b;},_927),function(evt){self[_928](evt,this);}));},selectFirstNode:function(){var _92c=this.containerNode.firstChild;while(_92c&&_92c.style.display=="none"){_92c=_92c.nextSibling;}this._setSelectedAttr(_92c,true);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last,true);},selectNextNode:function(){var _92d=this.selected;if(!_92d){this.selectFirstNode();}else{var next=_92d.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next,true);}}},selectPreviousNode:function(){var _92e=this.selected;if(!_92e){this.selectLastNode();}else{var prev=_92e.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev,true);}}},_setSelectedAttr:function(node,_92f){if(this.selected!=node){var _930=this.selected;if(_930){this.onDeselect(_930);}if(node){if(_92f){_926.scrollIntoView(node);}this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_931,lang,dom){var _932=lang.getObject("dojo.dnd",true);_932.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_932._uniqueId=0;_932.getUniqueId=function(){var id;do{id=_931._scopeName+"Unique"+(++_932._uniqueId);}while(dom.byId(id));return id;};_932._empty={};_932.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " a button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _932;});},"dijit/CalendarLite":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./a11yclick","./hccss"],function(_933,_934,_935,date,_936,_937,dom,_938,lang,on,has,_939,_93a,_93b,_93c){var _93d=_934("dijit.CalendarLite",[_93a,_93b],{templateString:_93c,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\" scope=\"col\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),_setSummaryAttr:"gridNode",baseClass:"dijitCalendar dijitCalendarLite",_isValidDate:function(_93e){return _93e&&!isNaN(_93e)&&typeof _93e=="object"&&_93e.toString()!=this.constructor.prototype.value.toString();},_getValueAttr:function(){var _93f=this._get("value");if(_93f&&!isNaN(_93f)){var _940=new this.dateClassObj(_93f);_940.setHours(0,0,0,0);if(_940.getDate()<_93f.getDate()){_940=this.dateModule.add(_940,"hour",1);}return _940;}else{return null;}},_setValueAttr:function(_941,_942){if(typeof _941=="string"){_941=_937.fromISOString(_941);}_941=this._patchDate(_941);if(this._isValidDate(_941)&&!this.isDisabledDate(_941,this.lang)){this._set("value",_941);this.set("currentFocus",_941);this._markSelectedDates([_941]);if(this._created&&(_942||typeof _942=="undefined")){this.onChange(this.get("value"));}}else{this._set("value",null);this._markSelectedDates([]);}},_patchDate:function(_943){if(_943){_943=new this.dateClassObj(_943);_943.setHours(1,0,0,0);}return _943;},_setText:function(node,text){while(node.firstChild){node.removeChild(node.firstChild);}node.appendChild(node.ownerDocument.createTextNode(text));},_populateGrid:function(){var _944=new this.dateClassObj(this.currentFocus);_944.setDate(1);_944=this._patchDate(_944);var _945=_944.getDay(),_946=this.dateModule.getDaysInMonth(_944),_947=this.dateModule.getDaysInMonth(this.dateModule.add(_944,"month",-1)),_948=new this.dateClassObj(),_949=_935.getFirstDayOfWeek(this.lang);if(_949>_945){_949-=7;}if(!this.summary){var _94a=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_944);this.gridNode.setAttribute("summary",_94a[_944.getMonth()]);}this._date2cell={};_933.forEach(this.dateCells,function(_94b,idx){var i=idx+_949;var date=new this.dateClassObj(_944),_94c,_94d="dijitCalendar",adj=0;if(i<_945){_94c=_947-_945+i+1;adj=-1;_94d+="Previous";}else{if(i>=(_945+_946)){_94c=i-_945-_946+1;adj=1;_94d+="Next";}else{_94c=i-_945+1;_94d+="Current";}}if(adj){date=this.dateModule.add(date,"month",adj);}date.setDate(_94c);if(!this.dateModule.compare(date,_948,"date")){_94d="dijitCalendarCurrentDate "+_94d;}if(this.isDisabledDate(date,this.lang)){_94d="dijitCalendarDisabledDate "+_94d;_94b.setAttribute("aria-disabled","true");}else{_94d="dijitCalendarEnabledDate "+_94d;_94b.removeAttribute("aria-disabled");_94b.setAttribute("aria-selected","false");}var _94e=this.getClassForDate(date,this.lang);if(_94e){_94d=_94e+" "+_94d;}_94b.className=_94d+"Month dijitCalendarDateTemplate";var _94f=date.valueOf();if(idx==0){}this._date2cell[_94f]=_94b;_94b.dijitDateValue=_94f;this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());},this);},_populateControls:function(){var _950=new this.dateClassObj(this.currentFocus);_950.setDate(1);this.monthWidget.set("month",_950);var y=_950.getFullYear()-1;var d=new this.dateClassObj();_933.forEach(["previous","current","next"],function(name){d.setFullYear(y++);this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));},this);},goToToday:function(){this.set("value",new this.dateClassObj());},constructor:function(_951){this.dateModule=_951.datePackage?lang.getObject(_951.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_951.datePackage?lang.getObject(_951.datePackage+".locale",false):_936;},_createMonthWidget:function(){return _93d._MonthWidget({id:this.id+"_mddb",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){var d=this.dowTemplateString,_952=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_953=_935.getFirstDayOfWeek(this.lang);this.dayCellsHtml=_939.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){return _952[_953++%7];});var r=_939.substitute(this.weekTemplateString,{d:this.dateTemplateString});this.dateRowsHtml=[r,r,r,r,r,r].join("");this.dateCells=[];this.dateLabels=[];this.inherited(arguments);dom.setSelectable(this.domNode,false);var _954=new this.dateClassObj(this.currentFocus);this.monthWidget=this._createMonthWidget();this.set("currentFocus",_954,false);},postCreate:function(){this.inherited(arguments);this._connectControls();},_connectControls:function(){var _955=lang.hitch(this,function(_956,part,_957){return on(this[_956],"click",lang.hitch(this,function(){this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_957));}));});this.own(_955("incrementMonth","month",1),_955("decrementMonth","month",-1),_955("nextYearLabelNode","year",1),_955("previousYearLabelNode","year",-1));},_setCurrentFocusAttr:function(date,_958){var _959=this.currentFocus,_95a=this._getNodeByDate(_959);date=this._patchDate(date);this._set("currentFocus",date);if(!this._date2cell||this.dateModule.difference(_959,date,"month")!=0){this._populateGrid();this._populateControls();this._markSelectedDates([this.value]);}var _95b=this._getNodeByDate(date);_95b.setAttribute("tabIndex",this.tabIndex);if(this.focused||_958){_95b.focus();}if(_95a&&_95a!=_95b){if(has("webkit")){_95a.setAttribute("tabIndex","-1");}else{_95a.removeAttribute("tabIndex");}}},focus:function(){this._setCurrentFocusAttr(this.currentFocus,true);},_onDayClick:function(evt){evt.stopPropagation();evt.preventDefault();for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){}if(node&&!_938.contains(node,"dijitCalendarDisabledDate")){this.set("value",node.dijitDateValue);}},_getNodeByDate:function(_95c){_95c=this._patchDate(_95c);return _95c&&this._date2cell?this._date2cell[_95c.valueOf()]:null;},_markSelectedDates:function(_95d){function mark(_95e,cell){_938.toggle(cell,"dijitCalendarSelectedDate",_95e);cell.setAttribute("aria-selected",_95e?"true":"false");};_933.forEach(this._selectedCells||[],lang.partial(mark,false));this._selectedCells=_933.filter(_933.map(_95d,this._getNodeByDate,this),function(n){return n;});_933.forEach(this._selectedCells,lang.partial(mark,true));},onChange:function(){},isDisabledDate:function(){},getClassForDate:function(){}});_93d._MonthWidget=_934("dijit.CalendarLite._MonthWidget",_93a,{_setMonthAttr:function(_95f){var _960=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_95f),_961=(has("ie")==6?"":"<div class='dijitSpacer'>"+_933.map(_960,function(s){return "<div>"+s+"</div>";}).join("")+"</div>");this.domNode.innerHTML=_961+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_960[_95f.getMonth()]+"</div>";}});return _93d;});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_962,_963,_964,_965){return _962("dijit.CheckedMenuItem",_964,{baseClass:"dijitMenuItem dijitCheckedMenuItem",templateString:_965,checked:false,_setCheckedAttr:function(_966){this.domNode.setAttribute("aria-checked",_966?"true":"false");this._set("checked",_966);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/form/VerticalRuleLabels":function(){define(["dojo/_base/declare","./HorizontalRuleLabels"],function(_967,_968){return _967("dijit.form.VerticalRuleLabels",_968,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){return 100-pos;},_isHorizontal:false});});},"dijit/Declaration":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser","dojo/query","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/NodeList-dom"],function(_969,_96a,_96b,lang,_96c,_96d,_96e,_96f,_970){return _96b("dijit.Declaration",_96e,{_noScript:true,stopParser:true,widgetClass:"",defaults:null,mixins:[],buildRendering:function(){var src=this.srcNodeRef.parentNode.removeChild(this.srcNodeRef),_971=_96d("> script[type='dojo/method']",src).orphan(),_972=_96d("> script[type='dojo/connect']",src).orphan(),_973=_96d("> script[type='dojo/aspect']",src).orphan(),_974=src.nodeName;var _975=this.defaults||{};_969.forEach(_971,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_96c._functionFromScript(s,"data-dojo-");if(evt){_975[evt]=func;}else{_973.push(s);}});if(this.mixins.length){this.mixins=_969.map(this.mixins,function(name){return lang.getObject(name);});}else{this.mixins=[_96e,_96f,_970];}_975._skipNodeCache=true;_975.templateString="<"+_974+" class='"+src.className+"'"+" data-dojo-attach-point='"+(src.getAttribute("data-dojo-attach-point")||src.getAttribute("dojoAttachPoint")||"")+"' data-dojo-attach-event='"+(src.getAttribute("data-dojo-attach-event")||src.getAttribute("dojoAttachEvent")||"")+"' >"+src.innerHTML.replace(/\%7B/g,"{").replace(/\%7D/g,"}")+"</"+_974+">";var wc=_96b(this.widgetClass,this.mixins,_975);_969.forEach(_973,function(s){var _976=s.getAttribute("data-dojo-advice")||"after",_977=s.getAttribute("data-dojo-method")||"postscript",func=_96c._functionFromScript(s);_96a.after(wc.prototype,_977,func,true);});_969.forEach(_972,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_96c._functionFromScript(s);_96a.after(wc.prototype,evt,func,true);});}});});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_978,dom,_979,_97a,_97b,_97c){return _978("dijit.MenuSeparator",[_979,_97a,_97b],{templateString:_97c,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_97d,_97e,_97f,keys,_980,_981,_982,_983){return _97d("dijit.form._ComboBoxMenu",[_980,_981,_983,_982],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_97e.add(this.previousButton,"dijitMenuItemRtl");_97e.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_97e.add(node,"dijitMenuItemHover");},onUnhover:function(node){_97e.remove(node,"dijitMenuItemHover");},onSelect:function(node){_97e.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_97e.remove(node,"dijitMenuItemSelected");},_page:function(up){var _984=0;var _985=this.domNode.scrollTop;var _986=_97f.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_984<_986){var _987=this.getHighlightedOption();if(up){if(!_987.previousSibling||_987.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_987.nextSibling||_987.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _988=this.domNode.scrollTop;_984+=(_988-_985)*(up?-1:1);_985=_988;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","./layout/utils","dojo/text!./templates/Dialog.html","./a11yclick","dojo/i18n!./nls/common"],function(_989,_98a,_98b,_98c,_98d,dom,_98e,_98f,_990,fx,i18n,keys,lang,on,_991,has,_992,_993,_994,_995,_996,_997,_998,_999,_99a,_99b,_99c,_99d,_99e,_99f){var _9a0=new _98d();_9a0.resolve(true);var _9a1=_98c("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_998,_99a,_99b,_999],{templateString:_99f,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_996.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _9a2=i18n.getLocalization("dijit","common");lang.mixin(this,_9a2);this.inherited(arguments);},postCreate:function(){_990.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_98b.after(this,"onExecute",lang.hitch(this,"hide"),true);_98b.after(this,"onCancel",lang.hitch(this,"hide"),true);this._modalconnects=[];},onLoad:function(){this.resize();this._position();if(this.autofocus&&_9a3.isTop(this)){this._getFocusItems();_995.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems();_995.focus(this._firstFocusItem);},_endDrag:function(){var _9a4=_98f.position(this.domNode),_9a5=_992.getBox(this.ownerDocument);_9a4.y=Math.min(Math.max(_9a4.y,0),(_9a5.h-_9a4.h));_9a4.x=Math.min(Math.max(_9a4.x,0),(_9a5.w-_9a4.w));this._relativePosition=_9a4;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_994:_993)(node,{handle:this.titleBar});_98b.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_98e.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_98a.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this.resize();},_position:function(){if(!_98e.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_9a6=_992.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_98f.position(node),l=Math.floor(_9a6.l+(p?p.x:(_9a6.w-bb.w)/2)),t=Math.floor(_9a6.t+(p?p.y:(_9a6.h-bb.h)/2));_990.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems();var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_995.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_995.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return _9a0.promise;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_9a3.hide(this);}var win=_992.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize",null)));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_990.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this.resize();this._position();var _9a7;this._fadeInDeferred=new _98d(lang.hitch(this,function(){_9a7.stop();delete this._fadeInDeferred;}));var _9a8=this._fadeInDeferred.promise;_9a7=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_9a3.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_9a3.isTop(this)){this._getFocusItems();_995.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _9a8;},hide:function(){if(!this._alreadyInitialized||!this.open){return _9a0.promise;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _9a9;this._fadeOutDeferred=new _98d(lang.hitch(this,function(){_9a9.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _9aa=this._fadeOutDeferred.promise;_9a9=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_9a3.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _9aa;},resize:function(dim){if(this.domNode.style.display!="none"){this._checkIfSingleChild();if(!dim){if(this._shrunk){if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}_98a.forEach([this.domNode,this.containerNode,this.titleBar],function(node){_990.set(node,{position:"static",width:"auto",height:"auto"});});this.domNode.style.position="absolute";}var _9ab=_992.getBox(this.ownerDocument);_9ab.w*=this.maxRatio;_9ab.h*=this.maxRatio;var bb=_98f.position(this.domNode);if(bb.w>=_9ab.w||bb.h>=_9ab.h){dim={w:Math.min(bb.w,_9ab.w),h:Math.min(bb.h,_9ab.h)};this._shrunk=true;}else{this._shrunk=false;}}if(dim){_98f.setMarginBox(this.domNode,dim);var _9ac=_99e.marginBox2contentBox(this.domNode,dim),_9ad={domNode:this.containerNode,region:"center"};_99e.layoutChildren(this.domNode,_9ac,[{domNode:this.titleBar,region:"top"},_9ad]);if(this._singleChild){var cb=_99e.marginBox2contentBox(this.containerNode,_9ad);this._singleChild.resize({w:cb.w,h:cb.h});}else{this.containerNode.style.overflow="auto";this._layoutChildren();}}else{this._layoutChildren();}if(!has("touch")&&!dim){this._position();}}},_layoutChildren:function(){_98a.forEach(this.getChildren(),function(_9ae){if(_9ae.resize){_9ae.resize();}});},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_9a3.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_9a1=_98c("dijit._DialogBase",_9a1,{_setTitleAttr:function(_9af){this._set("title",_9af);this.titleNode.innerHTML=_9af;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_9b0){if(this._created&&this.textDir!=_9b0){this._set("textDir",_9b0);this.set("title",this.title);}}});}var _9b1=_98c("dijit.Dialog",[_99d,_9a1],{});_9b1._DialogBase=_9a1;var _9a3=_9b1._DialogLevelManager={_beginZIndex:950,show:function(_9b2,_9b3){ds[ds.length-1].focus=_995.curNode;var _9b4=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_9b1._DialogLevelManager._beginZIndex;_990.set(_9b2.domNode,"zIndex",_9b4);_99c.show(_9b3,_9b4-1);ds.push({dialog:_9b2,underlayAttrs:_9b3,zIndex:_9b4});},hide:function(_9b5){if(ds[ds.length-1].dialog==_9b5){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_99c.hide();}else{_99c.show(pd.underlayAttrs,pd.zIndex-1);}if(_9b5.refocus){var _9b6=pd.focus;if(pd.dialog&&(!_9b6||!dom.isDescendant(_9b6,pd.dialog.domNode))){pd.dialog._getFocusItems();_9b6=pd.dialog._firstFocusItem;}if(_9b6){try{_9b6.focus();}catch(e){}}}}else{var idx=_98a.indexOf(_98a.map(ds,function(elem){return elem.dialog;}),_9b5);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_9b7){return ds[ds.length-1].dialog==_9b7;}};var ds=_9b1._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_995.watch("curNode",function(attr,_9b8,node){var _9b9=ds[ds.length-1].dialog;if(node&&_9b9&&!_9b9._fadeOutDeferred&&node.ownerDocument==_9b9.ownerDocument){do{if(node==_9b9.domNode||_98e.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_9b9.focus();}});if(has("dijit-legacy-requires")){_991(0,function(){var _9ba=["dijit/TooltipDialog"];_989(_9ba);});}return _9b1;});},"dijit/form/MultiSelect":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/sniff","dojo/query","./_FormValueWidget","dojo/NodeList-dom"],function(_9bb,_9bc,_9bd,has,_9be,_9bf){var _9c0=_9bc("dijit.form.MultiSelect"+(has("dojo-bidi")?"_NoBidi":""),_9bf,{size:7,baseClass:"dijitMultiSelect",templateString:"<select multiple='multiple' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_9c1){_9c1.getSelected().forEach(function(n){this.containerNode.appendChild(n);this.domNode.scrollTop=this.domNode.offsetHeight;var _9c2=_9c1.domNode.scrollTop;_9c1.domNode.scrollTop=0;_9c1.domNode.scrollTop=_9c2;},this);this._set("value",this.get("value"));},getSelected:function(){return _9be("option",this.containerNode).filter(function(n){return n.selected;});},_getValueAttr:function(){return _9bb.map(this.getSelected(),function(n){return n.value;});},multiple:true,_setMultipleAttr:function(val){},_setValueAttr:function(_9c3){if(has("android")){_9be("option",this.containerNode).orphan().forEach(function(n){var _9c4=n.ownerDocument.createElement("option");_9c4.value=n.value;_9c4.selected=(_9bb.indexOf(_9c3,n.value)!=-1);_9c4.text=n.text;_9c4.originalText=n.originalText;this.containerNode.appendChild(_9c4);},this);}else{_9be("option",this.containerNode).forEach(function(n){n.selected=(_9bb.indexOf(_9c3,n.value)!=-1);});}this.inherited(arguments);},invertSelection:function(_9c5){var val=[];_9be("option",this.containerNode).forEach(function(n){if(!n.selected){val.push(n.value);}});this._setValueAttr(val,!(_9c5===false||_9c5==null));},_onChange:function(){this._handleOnChange(this.get("value"),true);},resize:function(size){if(size){_9bd.setMarginBox(this.domNode,size);}},postCreate:function(){this._set("value",this.get("value"));this.inherited(arguments);}});if(has("dojo-bidi")){_9c0=_9bc("dijit.form.MultiSelect",_9c0,{addSelected:function(_9c6){_9c6.getSelected().forEach(function(n){n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);},this);this.inherited(arguments);},_setTextDirAttr:function(_9c7){if((this.textDir!=_9c7||!this._created)&&this.enforceTextDirWithUcc){this._set("textDir",_9c7);_9be("option",this.containerNode).forEach(function(_9c8){if(!this._created&&_9c8.value===_9c8.text){_9c8.value=_9c8.text;}_9c8.text=this.enforceTextDirWithUcc(_9c8,_9c8.originalText||_9c8.text);},this);}}});}return _9c0;});},"dijit/form/_DateTimeTextBox":function(){define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_9c9,_9ca,_9cb,lang,_9cc,_9cd,_9ce){new Date("X");var _9cf=_9cb("dijit.form._DateTimeTextBox",[_9cc,_9cd],{templateString:_9ce,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_9c9.regexp,datePackage:"",postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _9d0=this._isInvalidDate(val1);var _9d1=this._isInvalidDate(val2);return _9d0?(_9d1?0:-1):(_9d1?1:date.compare(val1,val2,this._selector));},autoWidth:true,format:function(_9d2,_9d3){if(!_9d2){return "";}return this.dateLocaleModule.format(_9d2,_9d3);},"parse":function(_9d4,_9d5){return this.dateLocaleModule.parse(_9d4,_9d5)||(this._isEmpty(_9d4)?null:undefined);},serialize:function(val,_9d6){if(val.toGregorian){val=val.toGregorian();}return _9ca.toISOString(val,_9d6);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_9d7){this.dateModule=_9d7.datePackage?lang.getObject(_9d7.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_9d7.datePackage?lang.getObject(_9d7.datePackage+".locale",false):_9c9;this._set("pattern",this.dateLocaleModule.regexp);this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_9d8){_9d8.selector=this._selector;_9d8.fullYear=true;var _9d9=_9ca.fromISOString;if(typeof _9d8.min=="string"){_9d8.min=_9d9(_9d8.min);}if(typeof _9d8.max=="string"){_9d8.max=_9d9(_9d8.max);}this.inherited(arguments);},_isInvalidDate:function(_9da){return !_9da||isNaN(_9da)||typeof _9da!="object"||_9da.toString()==this._invalidDate;},_setValueAttr:function(_9db,_9dc,_9dd){if(_9db!==undefined){if(typeof _9db=="string"){_9db=_9ca.fromISOString(_9db);}if(this._isInvalidDate(_9db)){_9db=null;}if(_9db instanceof Date&&!(this.dateClassObj instanceof Date)){_9db=new this.dateClassObj(_9db);}}this.inherited(arguments);if(this.value instanceof Date){this.filterString="";}if(this.dropDown){this.dropDown.set("value",_9db,false);}},_set:function(attr,_9de){var _9df=this._get("value");if(attr=="value"&&_9df instanceof Date&&this.compare(_9de,_9df)==0){return;}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this._set("dropDownDefaultValue",val);},openDropDown:function(_9e0){if(this.dropDown){this.dropDown.destroy();}var _9e1=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9e2=this,_9e3=this.get("value");this.dropDown=new _9e1({onChange:function(_9e4){_9e2.set("value",_9e4,true);},id:this.id+"_popup",dir:_9e2.dir,lang:_9e2.lang,value:_9e3,textDir:_9e2.textDir,currentFocus:!this._isInvalidDate(_9e3)?_9e3:this.dropDownDefaultValue,constraints:_9e2.constraints,filterString:_9e2.filterString,datePackage:_9e2.params.datePackage,isDisabledDate:function(date){return !_9e2.rangeCheck(date,_9e2.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_9e5,_9e6){this._setValueAttr(this.parse(_9e5,this.constraints),_9e6,_9e5);}});return _9cf;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_9e7,_9e8){return _9e7("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _9e9=this.checked;this._set("checked",!_9e9);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_9e9);return ret;},_setCheckedAttr:function(_9ea,_9eb){this._set("checked",_9ea);var node=this.focusNode||this.domNode;if(this._created){if(_9e8.get(node,"checked")!=!!_9ea){_9e8.set(node,"checked",!!_9ea);}}node.setAttribute(this._aria_attr,String(_9ea));this._handleOnChange(_9ea,_9eb);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/Calendar":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_9ec,date,_9ed,_9ee,_9ef,_9f0,_9f1,_9f2,keys,lang,on,has,_9f3,_9f4,_9f5,_9f6,_9f7){var _9f8=_9ee("dijit.Calendar",[_9f3,_9f4,_9f5],{baseClass:"dijitCalendar",cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_9f9){_9f2.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_9f9);},_createMonthWidget:function(){return new _9f8._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")),on(this.dateRowsNode,"mouseover",lang.hitch(this,"_onDayMouseOver")),on(this.dateRowsNode,"mouseout",lang.hitch(this,"_onDayMouseOut")),on(this.dateRowsNode,"mousedown",lang.hitch(this,"_onDayMouseDown")),on(this.dateRowsNode,"mouseup",lang.hitch(this,"_onDayMouseUp")));},_onMonthSelect:function(_9fa){var date=new this.dateClassObj(this.currentFocus);date.setDate(1);date.setMonth(_9fa);var _9fb=this.dateModule.getDaysInMonth(date);var _9fc=this.currentFocus.getDate();date.setDate(Math.min(_9fc,_9fb));this._setCurrentFocusAttr(date);},_onDayMouseOver:function(evt){var node=_9f0.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_9f0.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_9f0.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_9f0.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_9f0.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_9f0.contains(node,"dijitCalendarDisabledDate")){_9f0.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_9f0.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _9fd=-1,_9fe,_9ff=this.currentFocus;switch(evt.keyCode){case keys.RIGHT_ARROW:_9fd=1;case keys.LEFT_ARROW:_9fe="day";if(!this.isLeftToRight()){_9fd*=-1;}break;case keys.DOWN_ARROW:_9fd=1;case keys.UP_ARROW:_9fe="week";break;case keys.PAGE_DOWN:_9fd=1;case keys.PAGE_UP:_9fe=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_9ff=this.dateModule.add(_9ff,"month",1);_9fe="day";case keys.HOME:_9ff=new this.dateClassObj(_9ff);_9ff.setDate(1);break;default:return true;}if(_9fe){_9ff=this.dateModule.add(_9ff,_9fe,_9fd);}this._setCurrentFocusAttr(_9ff);return false;},_onKeyDown:function(evt){if(!this.handleKey(evt)){evt.stopPropagation();evt.preventDefault();}},onValueSelected:function(){},onChange:function(_a00){this.onValueSelected(_a00);},getClassForDate:function(){}});_9f8._MonthDropDownButton=_9ee("dijit.Calendar._MonthDropDownButton",_9f7,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _9f8._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_a01){var _a02=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_a01);this.dropDown.set("months",_a02);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_a02[_a01.getMonth()]+"</div>";}});_9f8._MonthDropDown=_9ee("dijit.Calendar._MonthDropDown",[_9f4,_9f6,_9f5],{months:[],baseClass:"dijitCalendarMonthMenu dijitMenu",templateString:"<div data-dojo-attach-event='onclick:_onClick'></div>",_setMonthsAttr:function(_a03){this.domNode.innerHTML="";_9ec.forEach(_a03,function(_a04,idx){var div=_9f1.create("div",{className:"dijitCalendarMonthLabel",month:idx,innerHTML:_a04},this.domNode);div._cssState="dijitCalendarMonthLabel";},this);},_onClick:function(evt){this.onChange(_9ef.get(evt.target,"month"));},onChange:function(){}});return _9f8;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_a05,dojo,_a06,_a07,_a08,dom,_a09,geom,_a0a,_a0b){if(!dojo.isAsync){_a0a(0,function(){var _a0c=["./fx/Toggler"];_a0b(_a0c);});}var _a0d=dojo.fx={};var _a0e={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _a0f=function(_a10){this._index=-1;this._animations=_a10||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_a06.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_a0f.prototype=new _a05();lang.extend(_a0f,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_a07.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_a07.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_a11,_a12){if(!this._current){this._current=this._animations[this._index=0];}if(!_a12&&this._current.status()=="playing"){return this;}var _a13=_a07.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_a14=_a07.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_a15=_a07.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_a13.remove();_a14.remove();_a15.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_a07.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_a07.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_a07.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_a16,_a17){this.pause();var _a18=this.duration*_a16;this._current=null;_a06.some(this._animations,function(a,_a19){if(_a18<=a.duration){this._current=a;this._index=_a19;return true;}_a18-=a.duration;return false;},this);if(this._current){this._current.gotoPercent(_a18/this._current.duration);}if(_a17){this.play();}return this;},stop:function(_a1a){if(this._current){if(_a1a){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_a07.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){this.stop();if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_a0f,_a0e);_a0d.chain=function(_a1b){return new _a0f(_a1b);};var _a1c=function(_a1d){this._animations=_a1d||[];this._connects=[];this._finished=0;this.duration=0;_a06.forEach(_a1d,function(a){var _a1e=a.duration;if(a.delay){_a1e+=a.delay;}if(this.duration<_a1e){this.duration=_a1e;}this._connects.push(_a07.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _a08.Animation({curve:[0,1],duration:this.duration});var self=this;_a06.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_a07.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_a1c,{_doAction:function(_a1f,args){_a06.forEach(this._animations,function(a){a[_a1f].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_a20,args){var t=this._pseudoAnimation;t[_a20].apply(t,args);},play:function(_a21,_a22){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_a23,_a24){var ms=this.duration*_a23;_a06.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_a24);});this._call("gotoPercent",arguments);return this;},stop:function(_a25){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){this.stop();_a06.forEach(this._connects,function(_a26){_a26.remove();});}});lang.extend(_a1c,_a0e);_a0d.combine=function(_a27){return new _a1c(_a27);};_a0d.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_a08.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _a28=_a09.get(node,"height");return Math.max(_a28,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_a07.after(anim,"onStop",fini,true);_a07.after(anim,"onEnd",fini,true);return anim;};_a0d.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_a08.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_a07.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_a07.after(anim,"onStop",fini,true);_a07.after(anim,"onEnd",fini,true);return anim;};_a0d.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_a09.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_a08.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_a07.after(anim,"beforeBegin",init,true);return anim;};return _a0d;});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_a29,a11y){return _a29("dijit._DialogMixin",null,{actionBarTemplate:"",execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _a2a=a11y._getTabNavigable(this.domNode);this._firstFocusItem=_a2a.lowest||_a2a.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_a2a.last||_a2a.highest||this._firstFocusItem;}});});},"dijit/Tree":function(){define(["dojo/_base/array","dojo/aspect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/promise/all","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/errors/create","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./a11yclick","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","./_KeyNavMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector","dojo/query!css2"],function(_a2b,_a2c,_a2d,_a2e,_a2f,all,dom,_a30,_a31,_a32,_a33,_a34,has,_a35,keys,lang,on,_a36,_a37,when,_a38,_a39,_a3a,_a3b,_a3c,_a3d,_a3e,_a3f,_a40,_a41,_a42,_a43,_a44,_a45,_a46){function _a47(d){return lang.delegate(d.promise||d,{addCallback:function(_a48){this.then(_a48);},addErrback:function(_a49){this.otherwise(_a49);}});};var _a4a=_a2e("dijit._TreeNode",[_a3c,_a3d,_a3e,_a3f,_a40],{item:null,isTreeNode:true,label:"",_setLabelAttr:function(val){this.labelNode[this.labelType=="html"?"innerHTML":"innerText" in this.labelNode?"innerText":"textContent"]=val;this._set("label",val);},labelType:"text",isExpandable:null,isExpanded:false,state:"NotLoaded",templateString:_a42,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_a4b){var _a4c=(Math.max(_a4b,0)*this.tree._nodePixelIndent)+"px";_a32.set(this.domNode,"backgroundPosition",_a4c+" 0px");_a32.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_a4c);_a2b.forEach(this.getChildren(),function(_a4d){_a4d.set("indent",_a4b+1);});this._set("indent",_a4b);},markProcessing:function(){this.state="Loading";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,_a4e=tree.model;if(tree._v10Compat&&item===_a4e.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");this.tree._startPaint(true);},_applyClassAndStyle:function(item,_a4f,_a50){var _a51="_"+_a4f+"Class";var _a52=_a4f+"Node";var _a53=this[_a51];this[_a51]=this.tree["get"+_a50+"Class"](item,this.isExpanded);_a30.replace(this[_a52],this[_a51]||"",_a53||"");_a32.set(this[_a52],this.tree["get"+_a50+"Style"](item,this.isExpanded)||{});},_updateLayout:function(){var _a54=this.getParent(),_a55=!_a54||!_a54.rowNode||_a54.rowNode.style.display=="none";_a30.toggle(this.domNode,"dijitTreeIsRoot",_a55);_a30.toggle(this.domNode,"dijitTreeIsLast",!_a55&&!this.getNextSibling());},_setExpando:function(_a56){var _a57=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_a58=["*","-","+","*"],idx=_a56?0:(this.isExpandable?(this.isExpanded?1:2):3);_a30.replace(this.expandoNode,_a57[idx],_a57);this.expandoNodeText.innerHTML=_a58[idx];},expand:function(){if(this._expandDeferred){return _a47(this._expandDeferred);}if(this._collapseDeferred){this._collapseDeferred.cancel();delete this._collapseDeferred;}this.isExpanded=true;this.labelNode.setAttribute("aria-expanded","true");if(this.tree.showRoot||this!==this.tree.rootNode){this.containerNode.setAttribute("role","group");}_a30.add(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","true");}var _a59=_a34.wipeIn({node:this.containerNode,duration:_a3b.defaultDuration});var def=(this._expandDeferred=new _a2f(function(){_a59.stop();}));_a2c.after(_a59,"onEnd",function(){def.resolve(true);},true);_a59.play();return _a47(def);},collapse:function(){if(this._collapseDeferred){return _a47(this._collapseDeferred);}if(this._expandDeferred){this._expandDeferred.cancel();delete this._expandDeferred;}this.isExpanded=false;this.labelNode.setAttribute("aria-expanded","false");if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","false");}_a30.remove(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);var _a5a=_a34.wipeOut({node:this.containerNode,duration:_a3b.defaultDuration});var def=(this._collapseDeferred=new _a2f(function(){_a5a.stop();}));_a2c.after(_a5a,"onEnd",function(){def.resolve(true);},true);_a5a.play();return _a47(def);},indent:0,setChildItems:function(_a5b){var tree=this.tree,_a5c=tree.model,defs=[];var _a5d=tree.focusedChild;var _a5e=this.getChildren();_a2b.forEach(_a5e,function(_a5f){_a3e.prototype.removeChild.call(this,_a5f);},this);this.defer(function(){_a2b.forEach(_a5e,function(node){if(!node._destroyed&&!node.getParent()){tree.dndController.removeTreeNode(node);function _a60(node){var id=_a5c.getIdentity(node.item),ary=tree._itemNodesMap[id];if(ary.length==1){delete tree._itemNodesMap[id];}else{var _a61=_a2b.indexOf(ary,node);if(_a61!=-1){ary.splice(_a61,1);}}_a2b.forEach(node.getChildren(),_a60);};_a60(node);if(tree.persist){var _a62=_a2b.map(node.getTreePath(),function(item){return tree.model.getIdentity(item);}).join("/");for(var path in tree._openedNodes){if(path.substr(0,_a62.length)==_a62){delete tree._openedNodes[path];}}tree._saveExpandedNodes();}if(tree.lastFocusedChild&&!dom.isDescendant(tree.lastFocusedChild,tree.domNode)){delete tree.lastFocusedChild;}if(_a5d&&!dom.isDescendant(_a5d,tree.domNode)){tree.focus();}node.destroyRecursive();}});});this.state="Loaded";if(_a5b&&_a5b.length>0){this.isExpandable=true;_a2b.forEach(_a5b,function(item){var id=_a5c.getIdentity(item),_a63=tree._itemNodesMap[id],node;if(_a63){for(var i=0;i<_a63.length;i++){if(_a63[i]&&!_a63[i].getParent()){node=_a63[i];node.set("indent",this.indent+1);break;}}}if(!node){node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_a5c.mayHaveChildren(item),label:tree.getLabel(item),labelType:(tree.model&&tree.model.labelType)||"text",tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});if(_a63){_a63.push(node);}else{tree._itemNodesMap[id]=[node];}}this.addChild(node);if(this.tree.autoExpand||this.tree._state(node)){defs.push(tree._expandNode(node));}},this);_a2b.forEach(this.getChildren(),function(_a64){_a64._updateLayout();});}else{this.isExpandable=false;}if(this._setExpando){this._setExpando(false);}this._updateItemClasses(this.item);var def=all(defs);this.tree._startPaint(def);return _a47(def);},getTreePath:function(){var node=this;var path=[];while(node&&node!==this.tree.rootNode){path.unshift(node.item);node=node.getParent();}path.unshift(this.tree.rootNode.item);return path;},getIdentity:function(){return this.tree.model.getIdentity(this.item);},removeChild:function(node){this.inherited(arguments);var _a65=this.getChildren();if(_a65.length==0){this.isExpandable=false;this.collapse();}_a2b.forEach(_a65,function(_a66){_a66._updateLayout();});},makeExpandable:function(){this.isExpandable=true;this._setExpando(false);},setSelected:function(_a67){this.labelNode.setAttribute("aria-selected",_a67?"true":"false");_a30.toggle(this.rowNode,"dijitTreeRowSelected",_a67);},focus:function(){_a39.focus(this.focusNode);}});if(has("dojo-bidi")){_a4a.extend({_setTextDirAttr:function(_a68){if(_a68&&((this.textDir!=_a68)||!this._created)){this._set("textDir",_a68);this.applyTextDir(this.labelNode);_a2b.forEach(this.getChildren(),function(_a69){_a69.set("textDir",_a68);},this);}}});}var Tree=_a2e("dijit.Tree",[_a3c,_a41,_a3d,_a40],{baseClass:"dijitTree",store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_a43,persist:false,autoExpand:false,dndController:_a46,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_a6a,_a6b){_a36.publish(this.id,lang.mixin({tree:this,event:_a6a},_a6b||{}));},postMixInProperties:function(){this.tree=this;if(this.autoExpand){this.persist=false;}this._itemNodesMap={};if(!this.cookieName&&this.id){this.cookieName=this.id+"SaveStateCookie";}this.expandChildrenDeferred=new _a2f();this.pendingCommandsPromise=this.expandChildrenDeferred.promise;this.inherited(arguments);},postCreate:function(){this._initState();var self=this;this.own(on(this.containerNode,on.selector(".dijitTreeNode",_a37.enter),function(evt){self._onNodeMouseEnter(_a3a.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeNode",_a37.leave),function(evt){self._onNodeMouseLeave(_a3a.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_a38.press),function(evt){self._onNodePress(_a3a.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_a38),function(evt){self._onClick(_a3a.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow","dblclick"),function(evt){self._onDblClick(_a3a.getEnclosingWidget(this),evt);}));if(!this.model){this._store2model();}this.own(_a2c.after(this.model,"onChange",lang.hitch(this,"_onItemChange"),true),_a2c.after(this.model,"onChildrenChange",lang.hitch(this,"_onItemChildrenChange"),true),_a2c.after(this.model,"onDelete",lang.hitch(this,"_onItemDelete"),true));this.inherited(arguments);if(this.dndController){if(lang.isString(this.dndController)){this.dndController=lang.getObject(this.dndController);}var _a6c={};for(var i=0;i<this.dndParams.length;i++){if(this[this.dndParams[i]]){_a6c[this.dndParams[i]]=this[this.dndParams[i]];}}this.dndController=new this.dndController(this,_a6c);}this._load();this.onLoadDeferred=_a47(this.pendingCommandsPromise);this.onLoadDeferred.then(lang.hitch(this,"onLoad"));},_store2model:function(){this._v10Compat=true;_a35.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");var _a6d={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};if(this.params.mayHaveChildren){_a6d.mayHaveChildren=lang.hitch(this,"mayHaveChildren");}if(this.params.getItemChildren){_a6d.getChildren=lang.hitch(this,function(item,_a6e,_a6f){this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_a6e,_a6f);});}this.model=new _a45(_a6d);this.showRoot=Boolean(this.label);},onLoad:function(){},_load:function(){this.model.getRoot(lang.hitch(this,function(item){var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),labelType:this.model.labelType||"text",textDir:this.textDir,indent:this.showRoot?0:-1}));if(!this.showRoot){rn.rowNode.style.display="none";this.domNode.setAttribute("role","presentation");this.domNode.removeAttribute("aria-expanded");this.domNode.removeAttribute("aria-multiselectable");if(this["aria-label"]){rn.containerNode.setAttribute("aria-label",this["aria-label"]);this.domNode.removeAttribute("aria-label");}else{if(this["aria-labelledby"]){rn.containerNode.setAttribute("aria-labelledby",this["aria-labelledby"]);this.domNode.removeAttribute("aria-labelledby");}}rn.labelNode.setAttribute("role","presentation");rn.containerNode.setAttribute("role","tree");rn.containerNode.setAttribute("aria-expanded","true");rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);}else{this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);this.rootLoadingIndicator.style.display="none";}this.containerNode.appendChild(rn.domNode);var _a70=this.model.getIdentity(item);if(this._itemNodesMap[_a70]){this._itemNodesMap[_a70].push(rn);}else{this._itemNodesMap[_a70]=[rn];}rn._updateLayout();this._expandNode(rn).then(lang.hitch(this,function(){if(!this._destroyed){this.rootLoadingIndicator.style.display="none";this.expandChildrenDeferred.resolve(true);}}));}),lang.hitch(this,function(err){console.error(this,": error loading root: ",err);}));},getNodesByItem:function(item){if(!item){return [];}var _a71=lang.isString(item)?item:this.model.getIdentity(item);return [].concat(this._itemNodesMap[_a71]);},_setSelectedItemAttr:function(item){this.set("selectedItems",[item]);},_setSelectedItemsAttr:function(_a72){var tree=this;return this.pendingCommandsPromise=this.pendingCommandsPromise.always(lang.hitch(this,function(){var _a73=_a2b.map(_a72,function(item){return (!item||lang.isString(item))?item:tree.model.getIdentity(item);});var _a74=[];_a2b.forEach(_a73,function(id){_a74=_a74.concat(tree._itemNodesMap[id]||[]);});this.set("selectedNodes",_a74);}));},_setPathAttr:function(path){if(path.length){return _a47(this.set("paths",[path]).then(function(_a75){return _a75[0];}));}else{return _a47(this.set("paths",[]).then(function(_a76){return _a76[0];}));}},_setPathsAttr:function(_a77){var tree=this;function _a78(path,_a79){var _a7a=path.shift();var _a7b=_a2b.filter(_a79,function(node){return node.getIdentity()==_a7a;})[0];if(!!_a7b){if(path.length){return tree._expandNode(_a7b).then(function(){return _a78(path,_a7b.getChildren());});}else{return _a7b;}}else{throw new Tree.PathError("Could not expand path at "+_a7a);}};return _a47(this.pendingCommandsPromise=this.pendingCommandsPromise.always(function(){return all(_a2b.map(_a77,function(path){path=_a2b.map(path,function(item){return lang.isString(item)?item:tree.model.getIdentity(item);});if(path.length){return _a78(path,[tree.rootNode]);}else{throw new Tree.PathError("Empty path");}}));}).then(function setNodes(_a7c){tree.set("selectedNodes",_a7c);return tree.paths;}));},_setSelectedNodeAttr:function(node){this.set("selectedNodes",[node]);},_setSelectedNodesAttr:function(_a7d){this.dndController.setSelection(_a7d);},expandAll:function(){var _a7e=this;function _a7f(node){return _a7e._expandNode(node).then(function(){var _a80=_a2b.filter(node.getChildren()||[],function(node){return node.isExpandable;});return all(_a2b.map(_a80,_a7f));});};return _a47(_a7f(this.rootNode));},collapseAll:function(){var _a81=this;function _a82(node){var _a83=_a2b.filter(node.getChildren()||[],function(node){return node.isExpandable;}),defs=all(_a2b.map(_a83,_a82));if(!node.isExpanded||(node==_a81.rootNode&&!_a81.showRoot)){return defs;}else{return defs.then(function(){return _a81._collapseNode(node);});}};return _a47(_a82(this.rootNode));},mayHaveChildren:function(){},getItemChildren:function(){},getLabel:function(item){return this.model.getLabel(item);},getIconClass:function(item,_a84){return (!item||this.model.mayHaveChildren(item))?(_a84?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";},getLabelClass:function(){},getRowClass:function(){},getIconStyle:function(){},getLabelStyle:function(){},getRowStyle:function(){},getTooltip:function(){return "";},_onDownArrow:function(evt,node){var _a85=this._getNext(node);if(_a85&&_a85.isTreeNode){this.focusNode(_a85);}},_onUpArrow:function(evt,node){var _a86=node.getPreviousSibling();if(_a86){node=_a86;while(node.isExpandable&&node.isExpanded&&node.hasChildren()){var _a87=node.getChildren();node=_a87[_a87.length-1];}}else{var _a88=node.getParent();if(!(!this.showRoot&&_a88===this.rootNode)){node=_a88;}}if(node&&node.isTreeNode){this.focusNode(node);}},_onRightArrow:function(evt,node){if(node.isExpandable&&!node.isExpanded){this._expandNode(node);}else{if(node.hasChildren()){node=node.getChildren()[0];if(node&&node.isTreeNode){this.focusNode(node);}}}},_onLeftArrow:function(evt,node){if(node.isExpandable&&node.isExpanded){this._collapseNode(node);}else{var _a89=node.getParent();if(_a89&&_a89.isTreeNode&&!(!this.showRoot&&_a89===this.rootNode)){this.focusNode(_a89);}}},focusLastChild:function(){var node=this._getLast();if(node&&node.isTreeNode){this.focusNode(node);}},_getFirst:function(){return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];},_getLast:function(){var node=this.rootNode;while(node.isExpanded){var c=node.getChildren();if(!c.length){break;}node=c[c.length-1];}return node;},_getNext:function(node){if(node.isExpandable&&node.isExpanded&&node.hasChildren()){return node.getChildren()[0];}else{while(node&&node.isTreeNode){var _a8a=node.getNextSibling();if(_a8a){return _a8a;}node=node.getParent();}return null;}},childSelector:".dijitTreeRow",isExpandoNode:function(node,_a8b){return dom.isDescendant(node,_a8b.expandoNode)||dom.isDescendant(node,_a8b.expandoNodeText);},_onNodePress:function(_a8c,e){this.focusNode(_a8c);},__click:function(_a8d,e,_a8e,func){var _a8f=e.target,_a90=this.isExpandoNode(_a8f,_a8d);if(_a8d.isExpandable&&(_a8e||_a90)){this._onExpandoClick({node:_a8d});}else{this._publish("execute",{item:_a8d.item,node:_a8d,evt:e});this[func](_a8d.item,_a8d,e);this.focusNode(_a8d);}e.stopPropagation();e.preventDefault();},_onClick:function(_a91,e){this.__click(_a91,e,this.openOnClick,"onClick");},_onDblClick:function(_a92,e){this.__click(_a92,e,this.openOnDblClick,"onDblClick");},_onExpandoClick:function(_a93){var node=_a93.node;this.focusNode(node);if(node.isExpanded){this._collapseNode(node);}else{this._expandNode(node);}},onClick:function(){},onDblClick:function(){},onOpen:function(){},onClose:function(){},_getNextNode:function(node){_a35.deprecated(this.declaredClass+"::_getNextNode(node) is deprecated. Use _getNext(node) instead.","","2.0");return this._getNext(node);},_getRootOrFirstNode:function(){_a35.deprecated(this.declaredClass+"::_getRootOrFirstNode() is deprecated. Use _getFirst() instead.","","2.0");return this._getFirst();},_collapseNode:function(node){if(node._expandNodeDeferred){delete node._expandNodeDeferred;}if(node.state=="Loading"){return;}if(node.isExpanded){var ret=node.collapse();this.onClose(node.item,node);this._state(node,false);this._startPaint(ret);return ret;}},_expandNode:function(node){if(node._expandNodeDeferred){return node._expandNodeDeferred;}var _a94=this.model,item=node.item,_a95=this;if(!node._loadDeferred){node.markProcessing();node._loadDeferred=new _a2f();_a94.getChildren(item,function(_a96){node.unmarkProcessing();node.setChildItems(_a96).then(function(){node._loadDeferred.resolve(_a96);});},function(err){console.error(_a95,": error loading "+node.label+" children: ",err);node._loadDeferred.reject(err);});}var def=node._loadDeferred.then(lang.hitch(this,function(){var def2=node.expand();this.onOpen(node.item,node);this._state(node,true);return def2;}));this._startPaint(def);return def;},focusNode:function(node){var _a97=this.domNode.scrollLeft;this.focusChild(node);this.domNode.scrollLeft=_a97;},_onNodeMouseEnter:function(){},_onNodeMouseLeave:function(){},_onItemChange:function(item){var _a98=this.model,_a99=_a98.getIdentity(item),_a9a=this._itemNodesMap[_a99];if(_a9a){var _a9b=this.getLabel(item),_a9c=this.getTooltip(item);_a2b.forEach(_a9a,function(node){node.set({item:item,label:_a9b,tooltip:_a9c});node._updateItemClasses(item);});}},_onItemChildrenChange:function(_a9d,_a9e){var _a9f=this.model,_aa0=_a9f.getIdentity(_a9d),_aa1=this._itemNodesMap[_aa0];if(_aa1){_a2b.forEach(_aa1,function(_aa2){_aa2.setChildItems(_a9e);});}},_onItemDelete:function(item){var _aa3=this.model,_aa4=_aa3.getIdentity(item),_aa5=this._itemNodesMap[_aa4];if(_aa5){_a2b.forEach(_aa5,function(node){this.dndController.removeTreeNode(node);var _aa6=node.getParent();if(_aa6){_aa6.removeChild(node);}if(this.lastFocusedChild&&!dom.isDescendant(this.lastFocusedChild,this.domNode)){delete this.lastFocusedChild;}if(this.focusedChild&&!dom.isDescendant(this.focusedChild,this.domNode)){this.focus();}node.destroyRecursive();},this);delete this._itemNodesMap[_aa4];}},_initState:function(){this._openedNodes={};if(this.persist&&this.cookieName){var oreo=_a2d(this.cookieName);if(oreo){_a2b.forEach(oreo.split(","),function(item){this._openedNodes[item]=true;},this);}}},_state:function(node,_aa7){if(!this.persist){return false;}var path=_a2b.map(node.getTreePath(),function(item){return this.model.getIdentity(item);},this).join("/");if(arguments.length===1){return this._openedNodes[path];}else{if(_aa7){this._openedNodes[path]=true;}else{delete this._openedNodes[path];}this._saveExpandedNodes();}},_saveExpandedNodes:function(){if(this.persist&&this.cookieName){var ary=[];for(var id in this._openedNodes){ary.push(id);}_a2d(this.cookieName,ary.join(","),{expires:365});}},destroy:function(){if(this._curSearch){this._curSearch.timer.remove();delete this._curSearch;}if(this.rootNode){this.rootNode.destroyRecursive();}if(this.dndController&&!lang.isString(this.dndController)){this.dndController.destroy();}this.rootNode=null;this.inherited(arguments);},destroyRecursive:function(){this.destroy();},resize:function(_aa8){if(_aa8){_a31.setMarginBox(this.domNode,_aa8);}this._nodePixelIndent=_a31.position(this.tree.indentDetector).w||this._nodePixelIndent;this.expandChildrenDeferred.then(lang.hitch(this,function(){this.rootNode.set("indent",this.showRoot?0:-1);this._adjustWidths();}));},_outstandingPaintOperations:0,_startPaint:function(p){this._outstandingPaintOperations++;if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}var oc=lang.hitch(this,function(){this._outstandingPaintOperations--;if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){this._adjustWidthsTimer=this.defer("_adjustWidths");}});when(p,oc,oc);},_adjustWidths:function(){if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}this.containerNode.style.width="auto";this.containerNode.style.width=this.domNode.scrollWidth>this.domNode.offsetWidth?"auto":"100%";},_createTreeNode:function(args){return new _a4a(args);},focus:function(){if(this.lastFocusedChild){this.focusNode(this.lastFocusedChild);}else{this.focusFirstChild();}}});if(has("dojo-bidi")){Tree.extend({_setTextDirAttr:function(_aa9){if(_aa9&&this.textDir!=_aa9){this._set("textDir",_aa9);this.rootNode.set("textDir",_aa9);}}});}Tree.PathError=_a33("TreePathError");Tree._TreeNode=_a4a;return Tree;});},"dijit/form/HorizontalSlider":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","dojo/on","../_base/manager","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_aaa,_aab,move,fx,_aac,_aad,keys,lang,has,_aae,_aaf,_ab0,_ab1,on,_ab2,_ab3,_ab4,_ab5,_ab6,_ab7,_ab8){var _ab9=_aab("dijit.form._SliderMover",_aaf,{onMouseMove:function(e){var _aba=this.widget;var _abb=_aba._abspos;if(!_abb){_abb=_aba._abspos=_aac.position(_aba.sliderBarContainer,true);_aba._setPixelValue_=lang.hitch(_aba,"_setPixelValue");_aba._isReversed_=_aba._isReversed();}var _abc=e[_aba._mousePixelCoord]-_abb[_aba._startingPixelCoord];_aba._setPixelValue_(_aba._isReversed_?(_abb[_aba._pixelCount]-_abc):_abc,_abb[_aba._pixelCount],false);},destroy:function(e){_aaf.prototype.destroy.apply(this,arguments);var _abd=this.widget;_abd._abspos=null;_abd._setValueAttr(_abd.value,true);}});var _abe=_aab("dijit.form.HorizontalSlider",[_ab6,_ab7],{templateString:_ab8,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_ab2.defaultDuration,_setIdAttr:"",_setNameAttr:"valueNode",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyDown:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.keyCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}e.stopPropagation();e.preventDefault();},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){_ab3.focus(this.sliderHandle);}e.stopPropagation();e.preventDefault();},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}_ab3.focus(this.sliderHandle);e.stopPropagation();e.preventDefault();var _abf=_aac.position(this.sliderBarContainer,true);var _ac0=e[this._mousePixelCoord]-_abf[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_abf[this._pixelCount]-_ac0):_ac0,_abf[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_ac1,_ac2,_ac3){if(this.disabled||this.readOnly){return;}var _ac4=this.discreteValues;if(_ac4<=1||_ac4==Infinity){_ac4=_ac2;}_ac4--;var _ac5=_ac2/_ac4;var _ac6=Math.round(_ac1/_ac5);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_ac6/_ac4+this.minimum,this.maximum),this.minimum),_ac3);},_setValueAttr:function(_ac7,_ac8){this._set("value",_ac7);this.valueNode.value=_ac7;this.focusNode.setAttribute("aria-valuenow",_ac7);this.inherited(arguments);var _ac9=this.maximum>this.minimum?((_ac7-this.minimum)/(this.maximum-this.minimum)):0;var _aca=(this._descending===false)?this.remainingBar:this.progressBar;var _acb=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_ac8&&this.slideDuration>0&&_aca.style[this._progressPixelSize]){var _acc=this;var _acd={};var _ace=parseFloat(_aca.style[this._progressPixelSize]);var _acf=this.slideDuration*(_ac9-_ace/100);if(_acf==0){return;}if(_acf<0){_acf=0-_acf;}_acd[this._progressPixelSize]={start:_ace,end:_ac9*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_aca,duration:_acf,onAnimate:function(v){_acb.style[_acc._progressPixelSize]=(100-parseFloat(v[_acc._progressPixelSize]))+"%";},onEnd:function(){delete _acc._inProgressAnim;},properties:_acd});this._inProgressAnim.play();}else{_aca.style[this._progressPixelSize]=(_ac9*100)+"%";_acb.style[this._progressPixelSize]=((1-_ac9)*100)+"%";}},_bumpValue:function(_ad0,_ad1){if(this.disabled||this.readOnly||(this.maximum<=this.minimum)){return;}var s=_aad.getComputedStyle(this.sliderBarContainer);var c=_aac.getContentBox(this.sliderBarContainer,s);var _ad2=this.discreteValues;if(_ad2<=1||_ad2==Infinity){_ad2=c[this._pixelCount];}_ad2--;var _ad3=(this.value-this.minimum)*_ad2/(this.maximum-this.minimum)+_ad0;if(_ad3<0){_ad3=0;}if(_ad3>_ad2){_ad3=_ad2;}_ad3=_ad3*(this.maximum-this.minimum)/_ad2+this.minimum;this._setValueAttr(_ad3,_ad1);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.keyCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.keyCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();this._bumpValue(evt.wheelDelta<0?-1:1,true);},startup:function(){if(this._started){return;}_aaa.forEach(this.getChildren(),function(_ad4){if(this[_ad4.container]!=this.containerNode){this[_ad4.container].appendChild(_ad4.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(_ad5,_ad6,e){if(_ad5==-1){this._setValueAttr(this.value,true);}else{this[(_ad6==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var _ad7=_ab0("label[for=\""+this.id+"\"]");if(_ad7.length){if(!_ad7[0].id){_ad7[0].id=this.id+"_label";}this.focusNode.setAttribute("aria-labelledby",_ad7[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this.own(_ab4.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_ab4.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.own(on(this.domNode,_ab1.wheel,lang.hitch(this,"_mouseWheeled")));var _ad8=_aab(_ab9,{widget:this});this._movable=new _aae(this.sliderHandle,{mover:_ad8});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this.inherited(arguments);}});_abe._Mover=_ab9;return _abe;});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNode\" class=\"dijitInline dijitTreeExpando\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTreeIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span data-dojo-attach-point=\"labelNode,focusNode\" class=\"dijitTreeLabel\" role=\"treeitem\"\n\t\t\t\t   tabindex=\"-1\" aria-selected=\"false\" id=\"${id}_label\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeNodeContainer\" role=\"presentation\"\n\t\t style=\"display: none;\" aria-labelledby=\"${id}_label\"></div>\n</div>\n","url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeydown:_onKeyDown\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\" role=\"menubar\" tabIndex=\"${tabIndex}\"\n\t ></div>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"ondijitclick:_onTitleClick, onkeydown:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\" id=\"${id}_titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<span data-dojo-attach-point=\"arrowNode\" class=\"dijitInline dijitArrowNode\" role=\"presentation\"></span\n\t\t\t><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\" aria-labelledby=\"${id}_titleBarNode\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><span data-dojo-attach-point=\"indeterminateHighContrastImage\"\n\t\t   class=\"dijitInline dijitProgressBarIndeterminateHighContrastImage\"></span\n></div>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\" aria-hidden=\"true\"\n/></span>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"./form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"./form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\" role=\"grid\">\n\t<table data-dojo-attach-point=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"presentation\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"ondijitclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\" role=\"button\">\n\t<span role=\"presentation\" class=\"dijitInline dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:__onClick,onkeydown:_onButtonKeyDown\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeydown:_onArrowKeyDown\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\"\n\t\t\t\tclass=\"dijitOffScreen\"\n\t\t\t\trole=\"presentation\" aria-hidden=\"true\"\n\t\t\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\t/></td></tr></tbody\n></table>\n","url:dijit/templates/Tree.html":"<div role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n\t<div class=\"dijitTreeExpando dijitTreeExpandoLoading\" data-dojo-attach-point=\"rootLoadingIndicator\"></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\">\n\t</div>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n\t${!actionBarTemplate}\n</div>\n\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"\n\t\trole=\"presentation\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode,textDirNode\"></span>\n</div>\n","url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTabButtonIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown, onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\" data-dojo-attach-point=\"gridNode\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\" scope=\"col\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\" scope=\"col\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' scope=\"col\" data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"ondijitclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_menuBtn\"\n\t\t data-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t data-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_leftBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_rightBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'\n\t\t\t data-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" role=\"presentation\" aria-hidden=\"true\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"contentsNode\" class=\"dijitTooltipContents dijitTooltipFocusNode\">\n\t\t\t<div data-dojo-attach-point=\"containerNode\"></div>\n\t\t\t${!actionBarTemplate}\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","*now":function(r){r(["dojo/i18n!*preload*dijit/nls/dijit-all*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dijit/dijit-all",["./main","./dijit","./ColorPalette","./Declaration","./Dialog","./DialogUnderlay","./TooltipDialog","./Editor","./_editor/plugins/FontChoice","./_editor/plugins/LinkDialog","./Menu","./MenuItem","./PopupMenuItem","./CheckedMenuItem","./MenuBar","./MenuBarItem","./PopupMenuBarItem","./MenuSeparator","./ProgressBar","./TitlePane","./Toolbar","./Tooltip","./Tree","./InlineEditBox","./form/Form","./form/Button","./form/DropDownButton","./form/ComboButton","./form/ToggleButton","./form/CheckBox","./form/RadioButton","./form/TextBox","./form/ValidationTextBox","./form/CurrencyTextBox","./form/DateTextBox","./form/TimeTextBox","./form/NumberSpinner","./form/NumberTextBox","./form/ComboBox","./form/FilteringSelect","./form/MultiSelect","./form/Select","./form/HorizontalSlider","./form/VerticalSlider","./form/HorizontalRule","./form/VerticalRule","./form/HorizontalRuleLabels","./form/VerticalRuleLabels","./form/SimpleTextarea","./form/Textarea","./layout/AccordionContainer","./layout/ContentPane","./layout/BorderContainer","./layout/LayoutContainer","./layout/LinkPane","./layout/SplitContainer","./layout/StackContainer","./layout/TabContainer"],function(_ad9){console.warn("dijit-all may include much more code than your application actually requires. We strongly recommend that you investigate a custom build or the web build tool");return _ad9;});