/*
 * Decompiled with CFR 0.152.
 */
package org.docbook;

import java.io.IOException;
import java.util.List;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.docbook.XSLT20;

public class Main {
    public static void main(String[] args) throws IOException, SaxonApiException {
        XSLT20 docbook = new XSLT20();
        String usage = "java -jar docbook-xslt2-" + docbook.version() + ".jar [options] dbdoc.xml [param=value [param=value] ...] ";
        Options options = new Options();
        OptionBuilder.withArgName((String)"format");
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The format: (x)html (css)print foprint");
        Option format = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"style");
        OptionBuilder.withLongOpt((String)"style");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Custom final-pass XSL stylesheet");
        Option style = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"postprocess");
        OptionBuilder.withLongOpt((String)"postprocess");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Post-processing stylesheet");
        Option post = OptionBuilder.create();
        OptionBuilder.withArgName((String)"pdf");
        OptionBuilder.withLongOpt((String)"pdf");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Name for the output PDF file (print only)");
        Option pdf = OptionBuilder.create();
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Name for the output file (defaults to stdout)");
        Option output = OptionBuilder.create((String)"o");
        OptionBuilder.withArgName((String)"css");
        OptionBuilder.withLongOpt((String)"css");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A CSS stylesheet (CSS print only)");
        Option css = OptionBuilder.create();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Usage: org.docbook.Main [options] dbdoc.xml");
        Option help = OptionBuilder.create((String)"h");
        OptionBuilder.withArgName((String)"params");
        OptionBuilder.withLongOpt((String)"params");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A file of parameters. The parameter file is expected to be an XML document containing a single XProc c:param-set.");
        Option params = OptionBuilder.create();
        OptionBuilder.withArgName((String)"namespace");
        OptionBuilder.withLongOpt((String)"ns");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Namespace binding");
        Option ns = OptionBuilder.create();
        options.addOption(format);
        options.addOption(style);
        options.addOption(post);
        options.addOption(pdf);
        options.addOption(output);
        options.addOption(css);
        options.addOption(params);
        options.addOption(ns);
        options.addOption(help);
        BasicParser parser = new BasicParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("ns")) {
                String[] nsbindings = cmd.getOptionValues("ns");
                for (int idx = 0; idx < nsbindings.length; idx += 2) {
                    String pfx = nsbindings[idx];
                    String uri = nsbindings[idx + 1];
                    docbook.setNamespace(pfx, uri);
                }
            }
            if (cmd.hasOption("params")) {
                for (String paramfn : cmd.getOptionValues("params")) {
                    docbook.addParameterFile(paramfn);
                }
            }
            for (String opt : new String[]{"postprocess", "pdf", "css", "output", "format", "style"}) {
                if (!cmd.hasOption(opt)) continue;
                docbook.setOption(opt, cmd.getOptionValue(opt));
            }
            List rest = cmd.getArgList();
            String doc = null;
            for (String param : rest) {
                if (param.contains("=")) {
                    int pos = param.indexOf("=");
                    String name = param.substring(0, pos);
                    String value = param.substring(pos + 1);
                    docbook.setParam(name, value);
                    continue;
                }
                doc = param;
            }
            if (doc == null) {
                formatter.printHelp(usage, options);
                System.exit(1);
            }
            docbook.run(doc);
        }
        catch (ParseException pe) {
            System.err.println("Unexpected: " + pe.getMessage());
            formatter.printHelp(usage, options);
            System.exit(1);
        }
    }
}

