/*
 * Decompiled with CFR 0.152.
 */
package org.docbook;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;

public class XSLT20 {
    private static final QName _output = new QName("", "output");
    private static final QName _format = new QName("", "format");
    protected Logger logger = null;
    private String proctype = "he";
    private boolean schemaAware = false;
    private String classLoc = null;
    private String jarLoc = null;
    private Hashtable<String, String> nsbindings = new Hashtable();
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Vector<String> paramFiles = new Vector();
    private String sourcefn = null;
    private Hashtable<QName, RuntimeValue> options = new Hashtable();
    private String version = null;
    private String resourcesVersion = null;
    private String catalogFile = null;
    private Properties configProperties = null;

    public XSLT20() {
        this.logger = LoggerFactory.getLogger(XSLT20.class);
        CodeSource src = XSLT20.class.getProtectionDomain().getCodeSource();
        this.classLoc = src.getLocation().toString();
        this.logger.debug("classLoc=" + this.classLoc);
        if (this.classLoc.endsWith(".jar")) {
            this.jarLoc = "jar:" + this.classLoc + "!";
        } else if (this.classLoc.indexOf("/build/") > 0) {
            this.jarLoc = this.classLoc + "../../../resources/main";
        } else if (this.classLoc.indexOf("/out/production/") > 0) {
            this.jarLoc = this.classLoc + "../resources";
        } else {
            throw new RuntimeException("org.docbook.XSLT20 cannot find root from " + this.classLoc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParam(String param, String value) {
        if (param.contains(":")) {
            int pos = param.indexOf(":");
            String pfx = param.substring(0, pos);
            String local = param.substring(pos + 1);
            if (!this.nsbindings.containsKey(pfx)) throw new RuntimeException("No namespace binding for prefix: " + pfx);
            QName name = new QName(pfx, this.nsbindings.get(pfx), local);
            this.params.put(name, new RuntimeValue(value));
            this.logger.debug("Parameter " + name.getClarkName() + "=" + value);
            return;
        } else {
            this.params.put(new QName("", param), new RuntimeValue(value));
            this.logger.debug("Parameter " + param + "=" + value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String opt, String value) {
        if (opt.contains(":")) {
            int pos = opt.indexOf(":");
            String pfx = opt.substring(0, pos);
            String local = opt.substring(pos + 1);
            if (!this.nsbindings.containsKey(pfx)) throw new RuntimeException("No namespace binding for prefix: " + pfx);
            QName name = new QName(pfx, this.nsbindings.get(pfx), local);
            this.options.put(name, new RuntimeValue(value));
            this.logger.debug("Option " + name.getClarkName() + "=" + value);
            return;
        } else {
            this.options.put(new QName("", opt), new RuntimeValue(value));
            this.logger.debug("Option " + opt + "=" + value);
        }
    }

    public void setNamespace(String prefix, String uri) {
        this.nsbindings.put(prefix, uri);
    }

    public void addParameterFile(String fn) {
        this.paramFiles.add(fn);
        this.logger.debug("Param file=" + fn);
    }

    public String createCatalog() {
        return this.createCatalog(null);
    }

    public String createCatalog(String catalogFilename) {
        if (this.catalogFile != null && (catalogFilename == null || this.catalogFile.equals(catalogFilename))) {
            return this.catalogFile;
        }
        try {
            Processor processor = new Processor(false);
            DocumentBuilder builder = processor.newDocumentBuilder();
            builder.setDTDValidation(false);
            builder.setLineNumbering(true);
            URL uris_url = new URL(this.jarLoc + "/etc/uris.xml");
            URL xsl_url = new URL(this.jarLoc + "/etc/make-catalog.xsl");
            InputSource uris_src = new InputSource(this.getStream(uris_url));
            InputSource xsl_src = new InputSource(this.getStream(xsl_url));
            uris_src.setSystemId(uris_url.toURI().toASCIIString());
            xsl_src.setSystemId(xsl_url.toURI().toASCIIString());
            XdmNode uris = builder.build((Source)new SAXSource(uris_src));
            XdmNode xsl = builder.build((Source)new SAXSource(xsl_src));
            XsltCompiler compiler = processor.newXsltCompiler();
            compiler.setSchemaAware(false);
            XsltExecutable exec = compiler.compile(xsl.asSource());
            XsltTransformer transformer = exec.load();
            transformer.setParameter(new QName("", "jarloc"), (XdmValue)new XdmAtomicValue(this.jarLoc));
            transformer.setParameter(new QName("", "version"), (XdmValue)new XdmAtomicValue(this.version()));
            transformer.setParameter(new QName("", "resourcesVersion"), (XdmValue)new XdmAtomicValue(this.resourcesVersion()));
            transformer.setInitialContextNode(uris);
            XdmDestination xresult = new XdmDestination();
            transformer.setDestination((Destination)xresult);
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.transform();
            XdmNode xformed = xresult.getXdmNode();
            File tempcat = null;
            if (catalogFilename == null) {
                tempcat = File.createTempFile("dbcat", ".xml");
                tempcat.deleteOnExit();
            } else {
                tempcat = new File(catalogFilename);
            }
            PrintStream catstream = new PrintStream(tempcat);
            catstream.print(xformed.toString());
            catstream.close();
            this.catalogFile = tempcat.getAbsolutePath();
            return this.catalogFile;
        }
        catch (IOException | URISyntaxException | SaxonApiException sae) {
            this.logger.info("org.docbook.XSLT20 failed to create catalog: " + sae.getMessage());
            throw new RuntimeException(sae);
        }
    }

    private InputStream getStream(URL url) {
        URLConnection conn = null;
        try {
            try {
                conn = (JarURLConnection)url.openConnection();
            }
            catch (ClassCastException cce) {
                conn = url.openConnection();
            }
            return conn.getInputStream();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot read: " + url.toString());
        }
    }

    public String version() {
        if (this.version != null) {
            return this.version;
        }
        this.loadProperties();
        this.version = this.configProperties.getProperty("version");
        if (this.version == null) {
            throw new UnsupportedOperationException("No version property in version.properties!?");
        }
        return this.version;
    }

    public String resourcesVersion() {
        if (this.resourcesVersion != null) {
            return this.resourcesVersion;
        }
        this.loadProperties();
        this.resourcesVersion = this.configProperties.getProperty("resourcesVersion");
        if (this.resourcesVersion == null) {
            throw new UnsupportedOperationException("No resourcesVersion property in version.properties!?");
        }
        return this.resourcesVersion;
    }

    private void loadProperties() {
        if (this.configProperties != null) {
            return;
        }
        this.configProperties = new Properties();
        InputStream stream = null;
        try {
            URL version_url = new URL(this.jarLoc + "/etc/version.properties");
            stream = this.getStream(version_url);
            this.configProperties.load(stream);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException("Failed to load version.properties file from JAR!?");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(String sourcefn) throws IOException, SaxonApiException {
        XProcConfiguration config = new XProcConfiguration(this.proctype, this.schemaAware);
        XProcRuntime runtime = new XProcRuntime(config);
        String baseURI = "file://" + System.getProperty("user.dir") + "/";
        XdmNode source = runtime.parse(sourcefn, baseURI);
        String format = "html";
        if (this.options.containsKey(_format)) {
            format = this.options.get(_format).getString();
        }
        String xpl = "db2html.xpl";
        if (format.equals("foprint") || format.equals("cssprint")) {
            xpl = "db2pdf.xpl";
        } else if (format.equals("xhtml")) {
            xpl = "db2xhtml.xpl";
        } else if (format.equals("fo")) {
            xpl = "db2fo.xpl";
        }
        xpl = this.jarLoc + "/xslt/base/pipelines/" + xpl;
        String catalogFn = this.createCatalog();
        Catalog catalog = new Catalog(catalogFn);
        XProcURIResolver resolver = runtime.getResolver();
        URIResolver uriResolver = resolver.getUnderlyingURIResolver();
        DocBookResolver myResolver = new DocBookResolver(uriResolver, catalog);
        resolver.setUnderlyingURIResolver((URIResolver)((Object)myResolver));
        this.logger.debug("Pipline=" + xpl);
        XPipeline pipeline = runtime.load(new Input(xpl));
        pipeline.writeTo("source", source);
        for (String string : this.paramFiles) {
            XdmNode pfile = runtime.parse(string, baseURI);
            pipeline.writeTo("parameters", pfile);
        }
        for (QName qName : this.params.keySet()) {
            pipeline.setParameter(qName, this.params.get(qName));
        }
        for (QName qName : this.options.keySet()) {
            pipeline.passOption(qName, this.options.get(qName));
        }
        pipeline.run();
        XdmNode result = pipeline.readFrom("result").read();
        if (result != null) {
            void var15_22;
            Serialization serialization = pipeline.getSerialization("result");
            if (serialization == null) {
                Serialization serialization2 = new Serialization(runtime, pipeline.getNode());
                serialization2.setMethod(new QName("", "xhtml"));
            }
            WritableDocument wd = null;
            if (this.options.containsKey(_output)) {
                String filename = this.options.get(_output).getStringValue().getPrimitiveStringValue().toString();
                FileOutputStream outfile = new FileOutputStream(filename);
                wd = new WritableDocument(runtime, filename, (Serialization)var15_22, (OutputStream)outfile);
                this.logger.info("Writing output to " + filename);
            } else {
                wd = new WritableDocument(runtime, null, (Serialization)var15_22);
            }
            wd.write(result);
        }
    }

    private class DocBookResolver
    extends Resolver {
        URIResolver nextResolver = null;
        Resolver resolver = null;

        DocBookResolver(URIResolver resolver, Catalog catalog) {
            this.nextResolver = resolver;
            this.resolver = new Resolver(catalog);
        }

        public Source resolve(String href, String base) throws TransformerException {
            Source src = this.nextResolver.resolve(href, base);
            if (src == null) {
                return this.resolver.resolve(href, base);
            }
            return src;
        }
    }
}

