/*
 * Decompiled with CFR 0.152.
 */
package org.docbook;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.CodeSource;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.docbook.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;

class DocBook {
    private static final QName _output = new QName("", "output");
    private static final QName _format = new QName("", "format");
    private String proctype = "he";
    private boolean schemaAware = false;
    private String classLoc = null;
    private Hashtable<String, String> nsbindings = new Hashtable();
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Vector<String> paramFiles = new Vector();
    private String sourcefn = null;
    private Hashtable<QName, RuntimeValue> options = new Hashtable();
    protected Logger logger = LoggerFactory.getLogger(DocBook.class);

    public DocBook() {
        CodeSource src = DocBook.class.getProtectionDomain().getCodeSource();
        this.classLoc = src.getLocation().toString();
        this.logger.debug("classLoc=" + this.classLoc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParam(String param, String value) {
        if (param.contains(":")) {
            int pos = param.indexOf(":");
            String pfx = param.substring(0, pos);
            String local = param.substring(pos + 1);
            if (!this.nsbindings.containsKey(pfx)) throw new RuntimeException("No namespace binding for prefix: " + pfx);
            QName name = new QName(pfx, this.nsbindings.get(pfx), local);
            this.params.put(name, new RuntimeValue(value));
            this.logger.debug("Parameter " + name.getClarkName() + "=" + value);
            return;
        } else {
            this.params.put(new QName("", param), new RuntimeValue(value));
            this.logger.debug("Parameter " + param + "=" + value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String opt, String value) {
        if (opt.contains(":")) {
            int pos = opt.indexOf(":");
            String pfx = opt.substring(0, pos);
            String local = opt.substring(pos + 1);
            if (!this.nsbindings.containsKey(pfx)) throw new RuntimeException("No namespace binding for prefix: " + pfx);
            QName name = new QName(pfx, this.nsbindings.get(pfx), local);
            this.options.put(name, new RuntimeValue(value));
            this.logger.debug("Option " + name.getClarkName() + "=" + value);
            return;
        } else {
            this.options.put(new QName("", opt), new RuntimeValue(value));
            this.logger.debug("Option " + opt + "=" + value);
        }
    }

    public void setNamespace(String prefix, String uri) {
        this.nsbindings.put(prefix, uri);
    }

    public void addParameterFile(String fn) {
        this.paramFiles.add(fn);
        this.logger.debug("Param file=" + fn);
    }

    /*
     * WARNING - void declaration
     */
    public void run(String sourcefn) throws IOException, SaxonApiException {
        void var24_32;
        XProcConfiguration config = new XProcConfiguration(this.proctype, this.schemaAware);
        XProcRuntime runtime = new XProcRuntime(config);
        String baseURI = "file://" + System.getProperty("user.dir") + "/";
        XdmNode source = runtime.parse(sourcefn, baseURI);
        String jarloc = "";
        if (this.classLoc.endsWith(".jar")) {
            jarloc = "jar:" + this.classLoc + "!";
        } else {
            int pos = this.classLoc.indexOf("/build/");
            jarloc = this.classLoc.substring(0, pos);
        }
        String format = "html";
        if (this.options.containsKey(_format)) {
            format = this.options.get(_format).getString();
        }
        String xpl = "db2html.xpl";
        if (format.equals("foprint") || format.equals("cssprint")) {
            xpl = "db2pdf.xpl";
        } else if (format.equals("xhtml")) {
            xpl = "db2xhtml.xpl";
        } else if (format.equals("fo")) {
            xpl = "db2fo.xpl";
        }
        xpl = jarloc + "/xslt/base/pipelines/" + xpl;
        XdmNode xcat = runtime.parse(new InputSource(this.getClass().getResourceAsStream("/etc/uris.xml")));
        XdmNode patch = runtime.parse(new InputSource(this.getClass().getResourceAsStream("/etc/make-catalog.xsl")));
        XsltCompiler compiler = runtime.getProcessor().newXsltCompiler();
        compiler.setSchemaAware(false);
        XsltExecutable exec = compiler.compile(patch.asSource());
        XsltTransformer transformer = exec.load();
        transformer.setParameter(new QName("", "jarloc"), (XdmValue)new XdmAtomicValue(jarloc));
        transformer.setParameter(new QName("", "version"), (XdmValue)new XdmAtomicValue(this.version()));
        transformer.setInitialContextNode(xcat);
        XdmDestination xresult = new XdmDestination();
        transformer.setDestination((Destination)xresult);
        transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
        transformer.transform();
        XdmNode xformed = xresult.getXdmNode();
        File tempcat = File.createTempFile("dbcat", ".xml");
        tempcat.deleteOnExit();
        PrintStream catstream = new PrintStream(tempcat);
        catstream.print(xformed.toString());
        catstream.close();
        Catalog catalog = new Catalog(tempcat.getAbsolutePath());
        XProcURIResolver resolver = runtime.getResolver();
        URIResolver uriResolver = resolver.getUnderlyingURIResolver();
        DocBookResolver myResolver = new DocBookResolver(uriResolver, catalog);
        resolver.setUnderlyingURIResolver((URIResolver)((Object)myResolver));
        this.logger.debug("Pipline=" + xpl);
        XPipeline pipeline = runtime.load(new Input(xpl));
        pipeline.writeTo("source", source);
        for (String string : this.paramFiles) {
            XdmNode pfile = runtime.parse(string, baseURI);
            pipeline.writeTo("parameters", pfile);
        }
        for (QName qName : this.params.keySet()) {
            pipeline.setParameter(qName, this.params.get(qName));
        }
        for (QName qName : this.options.keySet()) {
            pipeline.passOption(qName, this.options.get(qName));
        }
        pipeline.run();
        XdmNode result = pipeline.readFrom("result").read();
        Serialization serialization = pipeline.getSerialization("result");
        if (serialization == null) {
            Serialization serialization2 = new Serialization(runtime, pipeline.getNode());
            serialization2.setMethod(new QName("", "xhtml"));
        }
        WritableDocument wd = null;
        if (this.options.containsKey(_output)) {
            String filename = this.options.get(_output).getStringValue().asString();
            FileOutputStream outfile = new FileOutputStream(filename);
            wd = new WritableDocument(runtime, filename, (Serialization)var24_32, (OutputStream)outfile);
            this.logger.info("Writing output to " + filename);
        } else {
            wd = new WritableDocument(runtime, null, (Serialization)var24_32);
        }
        wd.write(result);
    }

    public String version() {
        Properties config = new Properties();
        InputStream stream = null;
        try {
            stream = Main.class.getResourceAsStream("/etc/version.properties");
            if (stream == null) {
                throw new UnsupportedOperationException("JAR file doesn't contain version.properties file!?");
            }
            config.load(stream);
            String version = config.getProperty("version");
            if (version == null) {
                throw new UnsupportedOperationException("Invalid version.properties in JAR file!?");
            }
            return version;
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException("No version.properties in JAR file!?");
        }
    }

    private class DocBookResolver
    extends Resolver {
        URIResolver nextResolver = null;
        Resolver resolver = null;

        public DocBookResolver(URIResolver resolver, Catalog catalog) {
            this.nextResolver = resolver;
            this.resolver = new Resolver(catalog);
        }

        public Source resolve(String href, String base) throws TransformerException {
            Source src = this.nextResolver.resolve(href, base);
            if (src == null) {
                return this.resolver.resolve(href, base);
            }
            return src;
        }
    }
}

