/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.xml.sax.InputSource;
import org.xmlresolver.Resolver;

public class XslTNG {
    protected static String catalogFile = null;
    protected static Properties configProperties = null;
    protected static String version = null;
    protected static String resourcesVersion = null;
    protected String resolverVersion = null;
    protected String classLoc = null;
    protected String jarLoc = null;
    protected DebuggingLogger logger = null;

    public XslTNG() {
        Processor processor = new Processor(false);
        this.logger = new DebuggingLogger(processor.getUnderlyingConfiguration().getLogger());
        CodeSource src = XslTNG.class.getProtectionDomain().getCodeSource();
        this.classLoc = src.getLocation().toString();
        this.logger.debug("xsltng", "classLoc=" + this.classLoc);
        try {
            Method version = Resolver.class.getMethod("version", new Class[0]);
            this.resolverVersion = (String)version.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (this.classLoc.endsWith(".jar")) {
            this.jarLoc = "jar:" + this.classLoc + "!";
        } else if (this.classLoc.indexOf("/build/") > 0) {
            this.jarLoc = this.classLoc + "../../../resources/main";
        } else if (this.classLoc.indexOf("/out/production/") > 0) {
            this.jarLoc = this.classLoc + "../resources";
        } else {
            throw new RuntimeException("org.docbook.XslTNG cannot find root from " + this.classLoc);
        }
    }

    public String createCatalog() {
        return this.createCatalog(null);
    }

    public String createCatalog(String catalogFilename) {
        if (this.resolverVersion != null) {
            return "classpath:org/docbook/xsltng/catalog.xml";
        }
        if (catalogFile != null && (catalogFilename == null || catalogFile.equals(catalogFilename))) {
            return catalogFile;
        }
        try {
            Processor processor = new Processor(false);
            DocumentBuilder builder = processor.newDocumentBuilder();
            builder.setDTDValidation(false);
            builder.setLineNumbering(true);
            URL uris_url = new URL(this.jarLoc + "/org/docbook/xsltng/etc/uris.xml");
            URL xsl_url = new URL(this.jarLoc + "/org/docbook/xsltng/etc/make-catalog.xsl");
            InputSource uris_src = new InputSource(this.getStream(uris_url));
            InputSource xsl_src = new InputSource(this.getStream(xsl_url));
            uris_src.setSystemId(uris_url.toURI().toASCIIString());
            xsl_src.setSystemId(xsl_url.toURI().toASCIIString());
            XdmNode uris = builder.build((Source)new SAXSource(uris_src));
            XdmNode xsl = builder.build((Source)new SAXSource(xsl_src));
            XsltCompiler compiler = processor.newXsltCompiler();
            compiler.setSchemaAware(false);
            XsltExecutable exec = compiler.compile(xsl.asSource());
            XsltTransformer transformer = exec.load();
            transformer.setParameter(new QName("", "jarloc"), (XdmValue)new XdmAtomicValue(this.jarLoc));
            transformer.setParameter(new QName("", "jarpath"), (XdmValue)new XdmAtomicValue("/org/docbook/xsltng/"));
            transformer.setParameter(new QName("", "version"), (XdmValue)new XdmAtomicValue(this.version()));
            transformer.setParameter(new QName("", "resourcesVersion"), (XdmValue)new XdmAtomicValue(this.resourcesVersion()));
            transformer.setInitialContextNode(uris);
            XdmDestination xresult = new XdmDestination();
            transformer.setDestination((Destination)xresult);
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.transform();
            XdmNode xformed = xresult.getXdmNode();
            File tempcat = null;
            if (catalogFilename == null) {
                tempcat = File.createTempFile("dbcat", ".xml");
                tempcat.deleteOnExit();
            } else {
                tempcat = new File(catalogFilename);
            }
            this.logger.debug("xsltng", "Transient catalog file: " + tempcat.getAbsolutePath());
            PrintStream catstream = new PrintStream(tempcat);
            catstream.print(xformed.toString());
            catstream.close();
            catalogFile = tempcat.getAbsolutePath();
            return catalogFile;
        }
        catch (IOException | URISyntaxException | SaxonApiException sae) {
            this.logger.info("org.docbook.XSLT20 failed to create catalog: " + sae.getMessage());
            throw new RuntimeException(sae);
        }
    }

    private InputStream getStream(URL url) {
        URLConnection conn = null;
        try {
            try {
                conn = (JarURLConnection)url.openConnection();
            }
            catch (ClassCastException cce) {
                conn = url.openConnection();
            }
            return conn.getInputStream();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot read: " + url.toString());
        }
    }

    public String version() {
        if (version != null) {
            return version;
        }
        this.loadProperties();
        version = configProperties.getProperty("version");
        if (version == null) {
            throw new UnsupportedOperationException("No version property in version.properties!?");
        }
        return version;
    }

    public String resourcesVersion() {
        if (resourcesVersion != null) {
            return resourcesVersion;
        }
        this.loadProperties();
        resourcesVersion = configProperties.getProperty("resourcesVersion");
        if (resourcesVersion == null) {
            resourcesVersion = this.version();
        }
        return resourcesVersion;
    }

    private void loadProperties() {
        if (configProperties != null) {
            return;
        }
        configProperties = new Properties();
        InputStream stream = null;
        try {
            URL version_url = new URL(this.jarLoc + "/org/docbook/xsltng/etc/version.properties");
            stream = this.getStream(version_url);
            configProperties.load(stream);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException("Failed to load version.properties file from JAR!?");
        }
    }
}

