/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf.param;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.param.Parameter;

public class IntListParameter
extends Parameter<Integer[]> {
    public IntListParameter(String name, String description, Integer[] defaultValue) {
        super(name, description, defaultValue, "integer list");
    }

    @Override
    public String getValueForDescription(Integer[] val) {
        if (val.length == 0) {
            return "empty list";
        }
        StringBuffer sb = new StringBuffer();
        Integer[] arr$ = val;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int v = arr$[i$];
            sb.append(v);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public Integer[] getValue(HttpServletRequest request) throws IllegalArgumentException {
        String s = request.getParameter(this.getName());
        if (s == null) {
            return (Integer[])this.getDefaultValue();
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (String val : s.split("[,;:]")) {
            values.add(Integer.parseInt(val.trim()));
        }
        return values.toArray(new Integer[values.size()]);
    }
}

