/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.Client;
import org.dmilne.xjsf.ClientList;
import org.dmilne.xjsf.Service;
import org.simpleframework.xml.core.Persister;

public class ServiceHub {
    private static ServiceHub instance;
    private ClientList clientList;
    private HashMap<String, Client> clientsByName;
    private HashMap<String, Service> registeredServices;
    private DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    private Gson jsonSerializer;
    private Persister xmlSerializer;

    private ServiceHub(ServletContext context) throws ServletException {
        this.registeredServices = new HashMap();
        try {
            String clientFile = context.getInitParameter("clientFile");
            this.clientList = clientFile != null ? new ClientList(new File(clientFile)) : new ClientList();
            this.clientsByName = this.clientList.getClientsByName();
            this.jsonSerializer = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
            this.xmlSerializer = new Persister();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static ServiceHub getInstance(ServletContext context) throws ServletException {
        if (instance != null) {
            return instance;
        }
        instance = new ServiceHub(context);
        return instance;
    }

    public void registerService(Service service) {
        this.registeredServices.put(service.getServletName(), service);
    }

    public void dropService(Service service) {
        this.registeredServices.remove(service.getServletName());
    }

    public Set<String> getServiceNames() {
        return this.registeredServices.keySet();
    }

    public Service getService(String serviceName) {
        return this.registeredServices.get(serviceName);
    }

    public Persister getXmlSerializer() {
        return this.xmlSerializer;
    }

    public Gson getJsonSerializer() {
        return this.jsonSerializer;
    }

    public String format(double number) {
        return this.decimalFormat.format(number);
    }

    public Client identifyClient(HttpServletRequest request) {
        Client client;
        String username = null;
        String password = null;
        if (this.clientList.getCookieForUsername() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (cookie.getName().equals(this.clientList.getCookieForUsername())) {
                    username = cookie.getValue();
                }
                if (!cookie.getName().equals(this.clientList.getCookieForPassword())) continue;
                password = cookie.getValue();
            }
        }
        if (username != null) {
            client = this.clientsByName.get(username);
            if (client == null) {
                return null;
            }
            if (client.passwordMatches(password)) {
                return null;
            }
            return client;
        }
        username = request.getRemoteHost();
        client = this.clientsByName.get(username);
        if (client != null) {
            return client;
        }
        client = new Client(username, null, this.clientList.getDefaultClient());
        this.clientsByName.put(username, client);
        return client;
    }
}

