/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf.param;

import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.param.Parameter;

public class StringParameter
extends Parameter<String> {
    private boolean caseSensitive;

    public StringParameter(String name, String description, String defaultValue) {
        super(name, description, defaultValue, "string");
        this.caseSensitive = true;
    }

    public StringParameter(String name, String description, String defaultValue, boolean caseSensitive) {
        super(name, description, defaultValue, "string");
        caseSensitive = false;
    }

    @Override
    public String getValue(HttpServletRequest request) throws IllegalArgumentException {
        String val = request.getParameter(this.getName());
        if (!this.caseSensitive && val != null) {
            val = val.toLowerCase();
        }
        return val;
    }

    @Override
    public String getDefaultValue() {
        String val = (String)super.getDefaultValue();
        if (!this.caseSensitive && val != null) {
            val = val.toLowerCase();
        }
        return val;
    }
}

