/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf.param;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.param.Parameter;

public class StringArrayParameter
extends Parameter<String> {
    private HashMap<String, String> valuesByNormalizedValue = new HashMap();

    public StringArrayParameter(String name, String description, String defaultValue, String[] allValues, String[] valueDescriptions) {
        super(name, description, defaultValue, "enum");
        this.valueDescriptionsByName = new HashMap();
        for (int i = 0; i < allValues.length; ++i) {
            String normVal = this.normalizeValue(allValues[i]);
            this.valuesByNormalizedValue.put(normVal, allValues[i]);
            this.valueDescriptionsByName.put(normVal, valueDescriptions[i]);
        }
    }

    @Override
    public String getValue(HttpServletRequest request) throws IllegalArgumentException {
        String s = request.getParameter(this.getName());
        if (s == null) {
            return (String)this.getDefaultValue();
        }
        String val = this.valuesByNormalizedValue.get(this.normalizeValue(s));
        if (val == null) {
            return (String)this.getDefaultValue();
        }
        return val;
    }

    private String normalizeValue(String val) {
        return val.trim().toLowerCase();
    }
}

