/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.Service;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class UtilityMessages {

    public static class ParameterMissingMessage
    extends ErrorMessage {
        public ParameterMissingMessage(HttpServletRequest httpRequest) {
            super(httpRequest, "Parameters missing");
        }
    }

    public static class ErrorMessage
    extends Service.Message {
        @Expose
        @Attribute(required=false)
        private String error;
        @Expose
        @Element(required=false)
        private String trace = null;

        public ErrorMessage(HttpServletRequest httpRequest, String message) {
            super(httpRequest);
            this.error = message;
        }

        public ErrorMessage(HttpServletRequest httpRequest, Exception e) {
            super(httpRequest);
            this.error = e.getMessage();
            ByteArrayOutputStream writer1 = new ByteArrayOutputStream();
            PrintWriter writer2 = new PrintWriter(writer1);
            e.printStackTrace(writer2);
            writer2.flush();
            this.trace = writer1.toString();
        }

        public String getError() {
            return this.error;
        }

        public String getTrace() {
            return this.trace;
        }
    }

    public static class HelpMessage
    extends Service.Message {
        @Expose
        @SerializedName(value="serviceDescription")
        @Element(name="serviceDescription")
        private Service service;

        public HelpMessage(HttpServletRequest httpRequest, Service service) {
            super(httpRequest);
            this.service = service;
        }

        public Service getService() {
            return this.service;
        }
    }
}

