/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dmilne.xjsf.Client;
import org.dmilne.xjsf.ServiceHub;
import org.dmilne.xjsf.UtilityMessages;
import org.dmilne.xjsf.param.BooleanParameter;
import org.dmilne.xjsf.param.EnumParameter;
import org.dmilne.xjsf.param.Parameter;
import org.dmilne.xjsf.param.ParameterGroup;
import org.dmilne.xjsf.param.StringArrayParameter;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;

public abstract class Service
extends HttpServlet {
    private ServiceHub hub;
    @Expose
    @Attribute
    private String groupName;
    @Expose
    @SerializedName(value="description")
    @Attribute(name="description")
    private String shortDescription;
    @Expose
    @SerializedName(value="details")
    @Element(name="details", data=true)
    private String detailsMarkup;
    @Expose
    @ElementList
    private Vector<ParameterGroup> parameterGroups;
    @Expose
    @ElementList
    private Vector<Parameter> globalParameters;
    @Expose
    @ElementList
    private Vector<Parameter> baseParameters;
    @Expose
    @ElementList
    private Vector<Example> examples = new Vector();
    boolean supportsDirectResponse;
    protected EnumParameter<ResponseFormat> prmResponseFormat;
    protected BooleanParameter prmHelp;
    protected StringArrayParameter prmWikipedia;
    private DecimalFormat progressFormat = new DecimalFormat("#0%");

    public Service(String groupName, String shortDescription, String detailsMarkup, boolean supportsDirectResponse) {
        this.groupName = groupName;
        this.shortDescription = shortDescription;
        this.detailsMarkup = detailsMarkup;
        this.parameterGroups = new Vector();
        this.globalParameters = new Vector();
        this.baseParameters = new Vector();
        this.supportsDirectResponse = supportsDirectResponse;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.hub = ServiceHub.getInstance(config.getServletContext());
        String[] descResponseFormat = new String[]{"in XML format", "in JSON format", "directly, without any additional information such as request parameters. This format will not be valid for some services."};
        this.prmResponseFormat = new EnumParameter("responseFormat", "the format in which the response should be returned", (Enum)ResponseFormat.XML, (Enum[])ResponseFormat.values(), descResponseFormat);
        this.baseParameters.add(this.prmResponseFormat);
        this.prmHelp = new BooleanParameter("help", "If <b>true</b>, this will return a description of the service and the parameters available", false);
        this.baseParameters.add(this.prmHelp);
        this.hub.registerService(this);
    }

    public void addBaseParameter(Parameter param) {
        this.baseParameters.add(param);
    }

    public void addParamGroup(ParameterGroup group) {
        this.parameterGroups.add(group);
    }

    public void addExample(Example example) {
        this.examples.add(example);
    }

    public ServiceHub getHub() {
        return this.hub;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Message msg;
        ResponseFormat responseFormat = (ResponseFormat)((Object)this.prmResponseFormat.getValue(request));
        boolean requestingHelp = this.prmHelp.getValue(request);
        response.setCharacterEncoding("UTF8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        switch (responseFormat) {
            case DIRECT: {
                response.setContentType("text/html");
                break;
            }
            case XML: {
                response.setContentType("application/xml");
                break;
            }
            case JSON: {
                response.setContentType("application/json");
            }
        }
        try {
            if (!requestingHelp) {
                if (!this.isReady()) {
                    throw new ProgressException(this.getInitProgress());
                }
                if (this.isUsageLimitExceeded(request)) {
                    throw new UsageLimitException();
                }
            }
            if (responseFormat == ResponseFormat.DIRECT) {
                this.buildUnwrappedResponse(request, response);
                response.getWriter().flush();
                return;
            }
            msg = requestingHelp ? new UtilityMessages.HelpMessage(request, this) : this.buildWrappedResponse(request);
        }
        catch (Exception e) {
            if (responseFormat == ResponseFormat.DIRECT) {
                throw new ServletException((Throwable)e);
            }
            msg = new UtilityMessages.ErrorMessage(request, e);
        }
        try {
            if (responseFormat == ResponseFormat.XML) {
                this.getHub().getXmlSerializer().write((Object)msg, (OutputStream)System.out);
                this.getHub().getXmlSerializer().write((Object)msg, (Writer)response.getWriter());
            } else {
                this.getHub().getJsonSerializer().toJson((Object)msg, (Appendable)response.getWriter());
            }
            response.getWriter().flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.getHub().dropService(this);
    }

    public abstract Message buildWrappedResponse(HttpServletRequest var1) throws Exception;

    public void buildUnwrappedResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new UnsupportedOperationException();
    }

    private boolean isReady() {
        return this.getInitProgress() >= 1.0;
    }

    public double getInitProgress() {
        return 1.0;
    }

    public int getUsageCost(HttpServletRequest request) {
        return 1;
    }

    private boolean isUsageLimitExceeded(HttpServletRequest request) {
        Client client = this.getHub().identifyClient(request);
        if (client == null) {
            return false;
        }
        if (this.getUsageCost(request) == 0) {
            return false;
        }
        return client.update(this.getUsageCost(request));
    }

    public String getBasePath(HttpServletRequest request) {
        StringBuffer path = new StringBuffer();
        path.append(request.getScheme());
        path.append("://");
        path.append(request.getServerName());
        path.append(":");
        path.append(request.getServerPort());
        path.append(request.getContextPath());
        return path.toString();
    }

    public String getGroupName() {
        if (this.groupName != null) {
            return this.groupName;
        }
        return "ungrouped";
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void addParameterGroup(ParameterGroup paramGroup) {
        this.parameterGroups.add(paramGroup);
    }

    public void addGlobalParameter(Parameter param) {
        this.globalParameters.add(param);
    }

    public ParameterGroup getSpecifiedParameterGroup(HttpServletRequest request) {
        for (ParameterGroup paramGroup : this.parameterGroups) {
            if (!paramGroup.isSpecified(request)) continue;
            return paramGroup;
        }
        return null;
    }

    public static class Message {
        @Expose
        @Attribute
        private String service;
        @Expose
        @ElementMap(attribute=true, entry="param", key="name")
        private HashMap<String, String> request = new HashMap();

        public Message(HttpServletRequest httpRequest) {
            this.service = httpRequest.getServletPath();
            Enumeration e = httpRequest.getParameterNames();
            while (e.hasMoreElements()) {
                String paramName = (String)e.nextElement();
                this.request.put(paramName, httpRequest.getParameter(paramName));
            }
        }

        public String getServiceName() {
            return this.service;
        }

        public HashMap<String, String> getRequest() {
            return this.request;
        }
    }

    public static class UsageLimitException
    extends Exception {
        public UsageLimitException() {
            super("You have exceeded your usage limits");
        }
    }

    public class ProgressException
    extends Exception {
        private double _progress;

        public ProgressException(double progress) {
            super("Wikipedia is not yet ready. Current progress is " + Service.this.progressFormat.format(progress));
            this._progress = progress;
        }

        public double getProgress() {
            return this._progress;
        }
    }

    public class ExampleBuilder {
        private String description;
        private LinkedHashMap<String, String> params = new LinkedHashMap();

        public ExampleBuilder(String description) {
            this.description = description;
        }

        public <T> ExampleBuilder addParam(Parameter<T> param, T value) {
            this.params.put(param.getName(), param.getValueForDescription(value));
            return this;
        }

        public Example build() {
            return new Example(this.description, this.params, Service.this.getServletName());
        }
    }

    public static class Example {
        @Expose
        @Element(data=true)
        private String description;
        @Expose
        @ElementMap(attribute=true, entry="parameter", key="name")
        private Map<String, String> parameters;
        @Expose
        @Attribute
        private String url;

        public Example(String description, LinkedHashMap<String, String> params, String servletName) {
            this.description = description;
            this.parameters = params;
            StringBuffer sb = new StringBuffer();
            sb.append(servletName);
            int index = 0;
            for (Map.Entry<String, String> e : this.parameters.entrySet()) {
                if (index == 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                ++index;
            }
            this.url = sb.toString();
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static enum ResponseFormat {
        XML,
        JSON,
        DIRECT;

    }
}

