/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;

public class Client {
    @Expose
    @Attribute
    private String _name;
    private String _password;
    @Expose
    @ElementList(inline=true)
    private ArrayList<Usage> _usage;

    public Client(String name, String password, int minLimit, int hourLimit, int dayLimit) {
        this._name = name;
        this._password = password;
        this._usage = new ArrayList();
        this._usage.add(new Usage(Granularity.day, dayLimit));
        this._usage.add(new Usage(Granularity.hour, hourLimit));
        this._usage.add(new Usage(Granularity.minute, minLimit));
    }

    public Client(String name, String password, Client client) {
        this._name = name;
        this._password = password;
        this._usage = new ArrayList();
        this._usage.add(new Usage(Granularity.day, client.getDayUsage().getLimit()));
        this._usage.add(new Usage(Granularity.hour, client.getHourUsage().getLimit()));
        this._usage.add(new Usage(Granularity.minute, client.getMinuteUsage().getLimit()));
    }

    public String getName() {
        return this._name;
    }

    public boolean passwordMatches(String password) {
        if (this._password == null) {
            return true;
        }
        return this._password.equals(password);
    }

    public boolean update(int usageCost) {
        boolean limitExceeded = false;
        for (Usage u : this._usage) {
            if (!u.update(usageCost)) continue;
            limitExceeded = true;
        }
        return limitExceeded;
    }

    public Usage getMinuteUsage() {
        return this._usage.get(Granularity.minute.ordinal());
    }

    public Usage getHourUsage() {
        return this._usage.get(Granularity.hour.ordinal());
    }

    public Usage getDayUsage() {
        return this._usage.get(Granularity.day.ordinal());
    }

    public class Usage {
        @Expose
        @Attribute(name="granularity")
        private Granularity _granularity;
        @Expose
        @Attribute(name="start")
        private Date _start;
        @Expose
        @Attribute(name="end")
        private Date _end;
        @Expose
        @Attribute(name="unitCount")
        int _count;
        @Expose
        @Attribute(name="unitLimit")
        int _limit;

        public Usage(Granularity granularity, int limit) {
            this._granularity = granularity;
            this._count = 0;
            this.setPeriod();
            this._limit = limit;
        }

        public Date getPeriodStart() {
            return this._start;
        }

        public Date getPeriodEnd() {
            return this._end;
        }

        public int getCount() {
            return this._count;
        }

        public int getLimit() {
            return this._limit;
        }

        public boolean limitExceeded() {
            return this._limit > 0 && this._count > this._limit;
        }

        private int getGranularityInt() {
            switch (this._granularity) {
                case day: {
                    return 5;
                }
                case hour: {
                    return 10;
                }
                case minute: {
                    return 12;
                }
            }
            return -1;
        }

        private void setPeriod() {
            this._start = new Date();
            this._end = new Date();
            DateUtils.truncate((Date)this._start, (int)this.getGranularityInt());
            DateUtils.truncate((Date)this._end, (int)this.getGranularityInt());
            switch (this._granularity) {
                case minute: {
                    this._end = DateUtils.addMinutes((Date)this._end, (int)1);
                    break;
                }
                case hour: {
                    this._end = DateUtils.addHours((Date)this._end, (int)1);
                    break;
                }
                case day: {
                    this._end = DateUtils.addDays((Date)this._end, (int)1);
                }
            }
        }

        protected boolean update(int usageCost) {
            Date now = new Date();
            if (now.after(this._end)) {
                this.setPeriod();
                this._count = usageCost;
            } else {
                this._count += usageCost;
            }
            return this.limitExceeded();
        }
    }

    public static enum Granularity {
        day,
        hour,
        minute;

    }
}

