/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf.param;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.param.Parameter;

public class EnumSetParameter<T extends Enum<T>>
extends Parameter<EnumSet<T>> {
    private HashMap<String, T> valuesByName = new HashMap();

    public EnumSetParameter(String name, String description, EnumSet<T> defaultValue, T[] allValues, String[] valueDescriptions) {
        super(name, description, defaultValue, "enum list");
        this.valueDescriptionsByName = new HashMap();
        for (int i = 0; i < allValues.length; ++i) {
            this.valuesByName.put(((Enum)allValues[i]).name().toLowerCase(), allValues[i]);
            this.valueDescriptionsByName.put(((Enum)allValues[i]).name().toLowerCase(), valueDescriptions[i]);
        }
    }

    @Override
    public EnumSet<T> getValue(HttpServletRequest request) throws IllegalArgumentException {
        String allVals = request.getParameter(this.getName());
        if (allVals == null) {
            return (EnumSet)this.getDefaultValue();
        }
        ArrayList<Enum> _enums = new ArrayList<Enum>();
        for (String val : allVals.split("[,;:]")) {
            Enum _enum = (Enum)this.valuesByName.get(val.trim().toLowerCase());
            if (_enum == null) continue;
            _enums.add(_enum);
        }
        return EnumSet.copyOf(_enums);
    }
}

