/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf.param;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.dmilne.xjsf.param.Parameter;

public class EnumParameter<T extends Enum<T>>
extends Parameter<T> {
    private HashMap<String, T> valuesByName;

    public EnumParameter(String name, String description, T defaultValue, T[] allValues, String[] valueDescriptions) {
        super(name, description, defaultValue, "enum");
        if (allValues.length != valueDescriptions.length) {
            throw new IllegalArgumentException("the number of values and valueDescriptions does not match!");
        }
        this.valuesByName = new HashMap();
        this.valueDescriptionsByName = new HashMap();
        for (int i = 0; i < allValues.length; ++i) {
            this.valuesByName.put(((Enum)allValues[i]).name().toLowerCase(), allValues[i]);
            this.valueDescriptionsByName.put(((Enum)allValues[i]).name().toLowerCase(), valueDescriptions[i]);
        }
    }

    @Override
    public T getValue(HttpServletRequest request) throws IllegalArgumentException {
        String s = request.getParameter(this.getName());
        if (s == null) {
            return (T)((Enum)this.getDefaultValue());
        }
        Enum val = (Enum)this.valuesByName.get(s.trim().toLowerCase());
        if (val == null) {
            throw new IllegalArgumentException("Invalid value for " + this.getName() + " parameter");
        }
        return (T)val;
    }
}

