/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.dmilne.xjsf.Service;
import org.dmilne.xjsf.UtilityMessages;

public class ServiceCaller {
    private URL _wmServer;
    private Gson _gson = new Gson();

    public ServiceCaller(URL wmServer) {
        this._wmServer = wmServer;
    }

    public <M extends Service.Message> M callService(String serviceName, Class<M> messageClass, HashMap<String, String> params) throws IOException, ServiceException {
        String paramData = this.getParamData(params);
        String json = this.getResponse(serviceName, paramData);
        UtilityMessages.ErrorMessage errorMsg = null;
        try {
            errorMsg = (UtilityMessages.ErrorMessage)this._gson.fromJson(json, UtilityMessages.ErrorMessage.class);
        }
        catch (Exception e) {
            errorMsg = null;
        }
        if (errorMsg != null && errorMsg.getError() != null && errorMsg.getError().trim().length() > 0) {
            throw new ServiceException(errorMsg, json);
        }
        return (M)((Service.Message)this._gson.fromJson(json, messageClass));
    }

    private String getParamData(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuffer paramData = new StringBuffer("responseFormat=JSON");
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (param.getKey().equalsIgnoreCase("responseFormat")) continue;
            paramData.append("&");
            paramData.append(param.getKey());
            paramData.append("=");
            paramData.append(URLEncoder.encode(param.getValue(), "UTF-8"));
        }
        return paramData.toString();
    }

    private String getResponse(String serviceName, String paramData) throws IOException {
        String line;
        URL url = new URL(this._wmServer.toString() + "/services/" + serviceName);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(paramData.toString());
        wr.flush();
        StringBuffer response = new StringBuffer();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append("\n");
        }
        wr.close();
        rd.close();
        return response.toString();
    }

    public class ServiceException
    extends Exception {
        private String _json;

        public ServiceException(UtilityMessages.ErrorMessage msg, String json) {
            super(msg.getError());
            this._json = json;
        }

        public String getJson() {
            return this._json;
        }
    }
}

