/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.xjsf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dmilne.xjsf.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientList {
    private static Logger _logger = LoggerFactory.getLogger(ClientList.class);
    private HashMap<String, Client> clients;
    private Client defaultClient = null;
    private String cookieUserName;
    private String cookiePassword;

    public String getCookieForUsername() {
        return this.cookieUserName;
    }

    public String getCookieForPassword() {
        return this.cookiePassword;
    }

    public String[] getClientNames() {
        Set<String> clientNames = this.clients.keySet();
        return clientNames.toArray(new String[clientNames.size()]);
    }

    public Client getClient(String name) {
        return this.clients.get(name);
    }

    public Client getDefaultClient() {
        return this.defaultClient;
    }

    public HashMap<String, Client> getClientsByName() {
        return this.clients;
    }

    public ClientList() {
        this.clients = new HashMap();
        this.defaultClient = new Client("anonymous", null, -1, -1, -1);
    }

    public ClientList(File listFile) throws ParserConfigurationException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(listFile);
        doc.getDocumentElement().normalize();
        this.initFromXml(doc.getDocumentElement());
    }

    private void initFromXml(Element xml) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clients = new HashMap();
        NodeList children = xml.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node xmlChild = children.item(i);
            if (xmlChild.getNodeType() == 1) {
                Element xmlParam = (Element)xmlChild;
                String paramName = xmlParam.getNodeName();
                switch (this.resolveParamName(xmlParam.getNodeName())) {
                    case client: {
                        String clientName = null;
                        if (xmlParam.hasAttribute("name")) {
                            clientName = xmlParam.getAttribute("name");
                        }
                        String password = null;
                        if (xmlParam.hasAttribute("password")) {
                            password = xmlParam.getAttribute("password");
                        }
                        int minLimit = -1;
                        if (xmlParam.hasAttribute("minLimit")) {
                            minLimit = Integer.parseInt(xmlParam.getAttribute("minLimit"));
                        }
                        int hourLimit = -1;
                        if (xmlParam.hasAttribute("hourLimit")) {
                            hourLimit = Integer.parseInt(xmlParam.getAttribute("hourLimit"));
                        }
                        int dayLimit = -1;
                        if (xmlParam.hasAttribute("dayLimit")) {
                            dayLimit = Integer.parseInt(xmlParam.getAttribute("dayLimit"));
                        }
                        if (clientName == null) {
                            this.defaultClient = new Client("anonymous", password, minLimit, hourLimit, dayLimit);
                            break;
                        }
                        this.clients.put(clientName, new Client(clientName, password, minLimit, hourLimit, dayLimit));
                        break;
                    }
                    case authentication: {
                        this.cookieUserName = xmlParam.getAttribute("nameCookie");
                        this.cookiePassword = xmlParam.getAttribute("passwordCookie");
                        break;
                    }
                    default: {
                        _logger.warn("Ignoring unknown parameter: '" + paramName + "'");
                    }
                }
            }
            if (this.defaultClient != null) continue;
            this.defaultClient = new Client("anonymous", null, 0, 0, 0);
        }
    }

    private ParamName resolveParamName(String name) {
        try {
            return ParamName.valueOf(name.trim());
        }
        catch (Exception e) {
            return ParamName.unknown;
        }
    }

    private static enum ParamName {
        client,
        authentication,
        unknown;

    }
}

