/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import weka.core.Attribute;
import weka.core.FastVector;

public class TypedAttribute
extends Attribute {
    Class _classType;

    public TypedAttribute(String name, int index, Class c) {
        super(name, index);
        this._classType = c;
    }

    public TypedAttribute(String name, FastVector values, int index, Class c) {
        super(name, values, index);
        this._classType = c;
    }

    public Class getClassType() {
        return this._classType;
    }

    public static TypedAttribute getNumericAttribute(String name, int index) {
        return new TypedAttribute(name, index, Double.class);
    }

    public static TypedAttribute getBooleanAttribute(String name, int index) {
        FastVector vals = new FastVector();
        vals.addElement((Object)"TRUE");
        vals.addElement((Object)"FALSE");
        return new TypedAttribute(name, vals, index, Boolean.class);
    }

    public static <E extends Enum<E>> TypedAttribute getEnumAttribute(String name, int index, Class<E> enumClass) {
        FastVector vals = new FastVector();
        for (Enum val : (Enum[])enumClass.getEnumConstants()) {
            vals.addElement((Object)val.name());
        }
        return new TypedAttribute(name, vals, index, enumClass);
    }

    public static TypedAttribute getStringAttribute(String name, int index) {
        return new TypedAttribute(name, null, index, String.class);
    }
}

