/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import java.util.HashMap;
import java.util.Vector;
import org.dmilne.weka.wrapper.Decider;
import org.dmilne.weka.wrapper.InstanceBuilder;
import org.dmilne.weka.wrapper.TypedAttribute;
import weka.core.Instance;
import weka.filters.Filter;

public class MulticlassDecider<A extends Enum<A>, C extends Enum<C>>
extends Decider<A, C> {
    private C[] possibleClassValues;

    protected MulticlassDecider(String name, TypedAttribute[] attributesByName, TypedAttribute classAttribute, Vector<Filter> filters) throws Exception {
        super(name, attributesByName, classAttribute, filters);
        this.possibleClassValues = (Enum[])this._classAttribute.getClassType().getEnumConstants();
    }

    @Override
    public C getDecision(Instance instance) throws Exception {
        int predictionOrdinal = (int)this.getRawClassification(instance);
        return this.possibleClassValues[predictionOrdinal];
    }

    @Override
    public HashMap<C, Double> getDecisionDistribution(Instance instance) throws Exception {
        double[] rawDist = this.getRawDistributionForInstance(instance);
        HashMap<C, Double> dist = new HashMap<C, Double>();
        for (int i = 0; i < rawDist.length; ++i) {
            dist.put(this.possibleClassValues[i], rawDist[i]);
        }
        return dist;
    }

    @Override
    public InstanceBuilder<A, C> getInstanceBuilder() {
        return new InstanceBuilder<A, C>(this._attributes, this._classAttribute, this._datasetHeader){

            @Override
            public InstanceBuilder<A, C> setClassAttribute(C value) {
                if (!MulticlassDecider.this._classAttribute.getClassType().equals(value.getClass())) {
                    throw new IllegalArgumentException(MulticlassDecider.this._classAttribute.name() + " is not a " + value.getClass() + " attribute");
                }
                this._instance.setClassValue((double)((Enum)value).ordinal());
                return this;
            }
        };
    }
}

