/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import org.dmilne.weka.wrapper.AttributeMissingException;
import org.dmilne.weka.wrapper.ClassMissingException;
import org.dmilne.weka.wrapper.TypedAttribute;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public abstract class InstanceBuilder<A extends Enum<A>, C> {
    private TypedAttribute[] _attributes;
    private TypedAttribute _classAttribute;
    protected Instance _instance;
    BuildResponse _attrMissingResponse = BuildResponse.IGNORE;
    BuildResponse _classAttrMissingResponse = BuildResponse.IGNORE;

    protected InstanceBuilder(TypedAttribute[] attributes, TypedAttribute classAttribute, Instances dataset) {
        this._attributes = attributes;
        this.setClassAttribute(classAttribute);
        this._instance = new Instance(attributes.length + 1);
        this._instance.setDataset(dataset);
    }

    public InstanceBuilder<A, C> setAttributeMissingResponse(BuildResponse r) {
        this._attrMissingResponse = r;
        return this;
    }

    public InstanceBuilder<A, C> setClassAttributeMissingResponse(BuildResponse r) {
        this._classAttrMissingResponse = r;
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, Double v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(Double.class)) {
            throw new IllegalArgumentException("'" + a + "' is not a numeric attribute");
        }
        if (v == null) {
            this._instance.setValue((Attribute)attr, Instance.missingValue());
        } else {
            this._instance.setValue((Attribute)attr, v.doubleValue());
        }
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, Float v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(Double.class)) {
            throw new IllegalArgumentException("'" + a + "' is not a numeric attribute");
        }
        if (v == null) {
            this._instance.setValue((Attribute)attr, Instance.missingValue());
        } else {
            this._instance.setValue((Attribute)attr, (double)v.floatValue());
        }
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, Integer v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(Double.class)) {
            throw new IllegalArgumentException("'" + a + "' is not a numeric attribute");
        }
        if (v == null) {
            this._instance.setValue((Attribute)attr, Instance.missingValue());
        } else {
            this._instance.setValue((Attribute)attr, (double)v.intValue());
        }
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, Boolean v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(Boolean.class)) {
            throw new IllegalArgumentException("'" + a + "' is not a Boolean attribute");
        }
        if (v == null) {
            this._instance.setValue((Attribute)attr, Instance.missingValue());
        } else if (v.booleanValue()) {
            this._instance.setValue((Attribute)attr, 0.0);
        } else {
            this._instance.setValue((Attribute)attr, 1.0);
        }
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, String v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(v.getClass())) {
            throw new IllegalArgumentException("'" + a + "' is not a " + v.getClass() + " attribute");
        }
        if (v == null) {
            this._instance.setValue((Attribute)attr, Instance.missingValue());
        } else {
            int index = attr.addStringValue(v);
            this._instance.setValue((Attribute)attr, (double)index);
        }
        return this;
    }

    public InstanceBuilder<A, C> setAttribute(A a, Enum v) {
        TypedAttribute attr = this._attributes[((Enum)a).ordinal()];
        if (!attr.getClassType().equals(v.getClass())) {
            throw new IllegalArgumentException("'" + a + "' is not a " + v.getClass() + " attribute");
        }
        this._instance.setValue((Attribute)attr, (double)v.ordinal());
        return this;
    }

    public abstract InstanceBuilder<A, C> setClassAttribute(C var1);

    public InstanceBuilder<A, C> setWeight(Double weight) {
        this._instance.setWeight(weight.doubleValue());
        return this;
    }

    public InstanceBuilder<A, C> replaceAllMissingValuesWith(Double value) {
        int c = this._instance.classIndex();
        for (int i = 0; i < this._instance.numValues(); ++i) {
            if (!this._instance.isMissing(i) || i == c) continue;
            this._instance.setValue(i, value.doubleValue());
        }
        return this;
    }

    public Instance build() throws ClassMissingException, AttributeMissingException {
        switch (this._classAttrMissingResponse) {
            case IGNORE: {
                break;
            }
            case THROW_ERROR: {
                if (!this._instance.classIsMissing()) break;
                throw new ClassMissingException(this._instance.classAttribute());
            }
            case WARN: {
                if (!this._instance.classIsMissing()) break;
                LoggerFactory.getLogger(this.getClass()).warn("Class attribute '" + this._instance.classAttribute().name() + "' is missing");
            }
        }
        Attribute missingAttr = null;
        for (int i = 0; i < this._instance.numAttributes() - 1; ++i) {
            if (!this._instance.isMissing(i)) continue;
            missingAttr = this._instance.attribute(i);
            break;
        }
        switch (this._attrMissingResponse) {
            case IGNORE: {
                break;
            }
            case THROW_ERROR: {
                if (missingAttr == null) break;
                throw new AttributeMissingException(missingAttr);
            }
            case WARN: {
                if (!this._instance.hasMissingValue()) break;
                LoggerFactory.getLogger(this.getClass()).warn("Attribute '" + missingAttr.name() + "' is missing");
            }
        }
        return this._instance;
    }

    public TypedAttribute getClassAttribute() {
        return this._classAttribute;
    }

    public void setClassAttribute(TypedAttribute _classAttribute) {
        this._classAttribute = _classAttribute;
    }

    public static enum BuildResponse {
        IGNORE,
        WARN,
        THROW_ERROR;

    }
}

