/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import java.util.Vector;
import org.dmilne.weka.wrapper.BinaryDecider;
import org.dmilne.weka.wrapper.Decider;
import org.dmilne.weka.wrapper.MulticlassDecider;
import org.dmilne.weka.wrapper.NumericDecider;
import org.dmilne.weka.wrapper.TypedAttribute;
import weka.filters.Filter;

public class DeciderBuilder<A extends Enum<A>> {
    private String _name;
    private Class<A> _attributeClass;
    private TypedAttribute[] _attributes;
    private TypedAttribute _classAttribute;
    private Vector<Filter> _filters;
    private Class _defaultAttributeClass;

    public DeciderBuilder(String name, Class<A> attributeClass) {
        this._name = name;
        this._attributeClass = attributeClass;
        this._attributes = new TypedAttribute[((Enum[])attributeClass.getEnumConstants()).length];
        this._filters = new Vector();
    }

    public DeciderBuilder<A> setDefaultAttributeTypeNumeric() {
        this._defaultAttributeClass = Double.class;
        return this;
    }

    public DeciderBuilder<A> setDefaultAttributeTypeBoolean() {
        this._defaultAttributeClass = Boolean.class;
        return this;
    }

    public <E extends Enum<E>> DeciderBuilder<A> setDefaultAttributeTypeEnum(Class<E> enumClass) {
        this._defaultAttributeClass = enumClass;
        return this;
    }

    public DeciderBuilder<A> setAttributeTypeNumeric(A a) {
        this._attributes[((Enum)a).ordinal()] = TypedAttribute.getNumericAttribute(((Enum)a).name(), ((Enum)a).ordinal());
        return this;
    }

    public DeciderBuilder<A> setAttributeTypeBoolean(A a) {
        this._attributes[((Enum)a).ordinal()] = TypedAttribute.getBooleanAttribute(((Enum)a).name(), ((Enum)a).ordinal());
        return this;
    }

    public <E extends Enum<E>> DeciderBuilder<A> setAttributeTypeEnum(A a, Class<E> enumClass) {
        this._attributes[((Enum)a).ordinal()] = TypedAttribute.getEnumAttribute(((Enum)a).name(), ((Enum)a).ordinal(), enumClass);
        return this;
    }

    public <E extends Enum<E>> DeciderBuilder<A> setAttributeTypeString(A a) {
        this._attributes[((Enum)a).ordinal()] = TypedAttribute.getStringAttribute(((Enum)a).name(), ((Enum)a).ordinal());
        return this;
    }

    public DeciderBuilder<A> setClassAttributeTypeBoolean(String name) {
        this._classAttribute = TypedAttribute.getBooleanAttribute(name, this._attributes.length);
        return this;
    }

    public DeciderBuilder<A> setClassAttributeTypeNumeric(String name) {
        this._classAttribute = TypedAttribute.getNumericAttribute(name, this._attributes.length);
        return this;
    }

    public <E extends Enum<E>> DeciderBuilder setClassAttributeTypeEnum(String name, Class<E> enumClass) {
        this._classAttribute = TypedAttribute.getEnumAttribute(name, this._attributes.length, enumClass);
        return this;
    }

    public DeciderBuilder<A> addFilter(Filter f) {
        this._filters.add(f);
        return this;
    }

    public Decider<A, ?> build() throws Exception {
        if (this._classAttribute == null) {
            throw new Exception("No class attribute set");
        }
        for (int i = 0; i < this._attributes.length; ++i) {
            if (this._attributes[i] != null) continue;
            Enum a = ((Enum[])this._attributeClass.getEnumConstants())[i];
            if (this._defaultAttributeClass == null) {
                throw new Exception("Unknown attribute type for '" + a.name() + "'");
            }
            this._attributes[i] = this._defaultAttributeClass.isEnum() ? TypedAttribute.getEnumAttribute(a.name(), i, this._defaultAttributeClass) : (this._defaultAttributeClass.equals(Boolean.class) ? TypedAttribute.getBooleanAttribute(a.name(), i) : TypedAttribute.getNumericAttribute(a.name(), i));
        }
        if (this._classAttribute.getClassType().equals(Double.class)) {
            return new NumericDecider(this._name, this._attributes, this._classAttribute, this._filters);
        }
        if (this._classAttribute.getClassType().equals(Boolean.class)) {
            return new BinaryDecider(this._name, this._attributes, this._classAttribute, this._filters);
        }
        if (this._classAttribute.getClassType().isEnum()) {
            return new MulticlassDecider(this._name, this._attributes, this._classAttribute, this._filters);
        }
        throw new Exception("No decider available for class attribute type " + this._classAttribute.getClassType());
    }
}

