/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Vector;
import org.dmilne.weka.wrapper.Dataset;
import org.dmilne.weka.wrapper.InstanceBuilder;
import org.dmilne.weka.wrapper.TypedAttribute;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;

public abstract class Decider<A extends Enum<A>, C> {
    private String _name;
    protected TypedAttribute[] _attributes;
    protected TypedAttribute _classAttribute;
    protected Instances _datasetHeader;
    protected Classifier _classifier = null;

    protected Decider(String name, TypedAttribute[] attributes, TypedAttribute classAttribute, Vector<Filter> filters) throws Exception {
        this._name = name;
        this._attributes = attributes;
        this._classAttribute = classAttribute;
        this._datasetHeader = this.createDatasetHeader();
    }

    public String getName() {
        return this._name;
    }

    public boolean isReady() {
        return this._classifier != null;
    }

    public abstract C getDecision(Instance var1) throws Exception;

    public abstract HashMap<C, Double> getDecisionDistribution(Instance var1) throws Exception;

    protected double[] getRawDistributionForInstance(Instance instance) throws Exception {
        this.throwIfCannotClassify(instance);
        return this._classifier.distributionForInstance(instance);
    }

    protected double getRawClassification(Instance instance) throws Exception {
        this.throwIfCannotClassify(instance);
        instance.setDataset(this._datasetHeader);
        return this._classifier.classifyInstance(instance);
    }

    protected void throwIfCannotClassify(Instance instance) throws Exception {
        if (this._classifier == null) {
            throw new Exception("Decider must be trained or loaded");
        }
        if (!instance.dataset().equalHeaders(this._datasetHeader)) {
            throw new Exception("Unexpected attributes");
        }
        if (!instance.classIsMissing()) {
            throw new Exception("Class attribute already known; nothing to decide");
        }
    }

    public Dataset<A, C> createNewDataset() {
        return new Dataset(this);
    }

    public void train(Classifier classifier, Dataset<A, C> trainingData) throws Exception {
        if (trainingData == null || trainingData.numInstances() == 0) {
            throw new Exception("You must load or build training data before building classifier");
        }
        this._classifier = classifier;
        classifier.buildClassifier(trainingData);
    }

    public void test(Dataset<A, C> data) {
    }

    public void load(File file) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        this._classifier = (Classifier)ois.readObject();
        ois.close();
        if (this._classifier == null) {
            throw new Exception(file.getPath() + " does not contain a valid classifier for " + this._name + " decider.");
        }
    }

    public void save(File file) throws IOException {
        LoggerFactory.getLogger(this.getClass()).info("saving classifier");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(this._classifier);
        oos.flush();
        oos.close();
    }

    protected Instances createDatasetHeader() {
        FastVector attrs = new FastVector();
        for (TypedAttribute attr : this._attributes) {
            attrs.addElement((Object)attr);
        }
        attrs.addElement((Object)this._classAttribute);
        Instances header = new Instances(this._name, attrs, 0);
        header.setClass((Attribute)this._classAttribute);
        return header;
    }

    public abstract InstanceBuilder<A, C> getInstanceBuilder();
}

