/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import java.io.File;
import org.dmilne.weka.wrapper.Decider;
import org.dmilne.weka.wrapper.InstanceBuilder;
import org.dmilne.weka.wrapper.TypedAttribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;

public class Dataset<A extends Enum<A>, C>
extends Instances {
    private static final long serialVersionUID = 4144187957200070770L;
    private Decider<A, C> _decider;

    protected Dataset(Decider<A, C> decider) {
        super(decider.createDatasetHeader());
        this._decider = decider;
    }

    public void save(File file) throws Exception {
        if (this.numInstances() == 0) {
            throw new Exception("There is no data to save");
        }
        ArffSaver saver = new ArffSaver();
        saver.setInstances((Instances)this);
        saver.setFile(file);
        saver.writeBatch();
    }

    public void load(File file) throws Exception {
        Instance nextInstance;
        ArffLoader loader = new ArffLoader();
        loader.setFile(file);
        Instances structure = loader.getStructure();
        if (structure.numAttributes() != this._decider._attributes.length + 1) {
            throw new Exception("Expected " + (this._decider._attributes.length + 1) + " attributes but found " + structure.numAttributes() + " instead.");
        }
        int index = 0;
        for (TypedAttribute attr : this._decider._attributes) {
            String fileAttr = structure.attribute(index).name();
            if (!attr.name().equals(fileAttr)) {
                throw new Exception("Expected attribute " + index + "-" + attr.name() + " but found " + fileAttr + " instead.");
            }
            ++index;
        }
        while ((nextInstance = loader.getNextInstance(structure)) != null) {
            this.add(nextInstance);
        }
        this.setClass(this._decider._classAttribute);
    }

    public InstanceBuilder<A, C> getInstanceBuilder() {
        return this._decider.getInstanceBuilder();
    }
}

