/*
 * Decompiled with CFR 0.152.
 */
package org.dmilne.weka.wrapper;

import java.util.HashMap;
import java.util.Vector;
import org.dmilne.weka.wrapper.Decider;
import org.dmilne.weka.wrapper.InstanceBuilder;
import org.dmilne.weka.wrapper.TypedAttribute;
import weka.core.Instance;
import weka.filters.Filter;

public class BinaryDecider<A extends Enum<A>>
extends Decider<A, Boolean> {
    protected BinaryDecider(String name, TypedAttribute[] attributes, TypedAttribute classAttribute, Vector<Filter> filters) throws Exception {
        super(name, attributes, classAttribute, filters);
    }

    @Override
    public Boolean getDecision(Instance instance) throws Exception {
        return this.getRawClassification(instance) == 0.0;
    }

    @Override
    public HashMap<Boolean, Double> getDecisionDistribution(Instance instance) throws Exception {
        double[] rawDist = this.getRawDistributionForInstance(instance);
        HashMap<Boolean, Double> dist = new HashMap<Boolean, Double>();
        dist.put(true, rawDist[0]);
        dist.put(false, rawDist[1]);
        return dist;
    }

    @Override
    public InstanceBuilder<A, Boolean> getInstanceBuilder() {
        return new InstanceBuilder<A, Boolean>(this._attributes, this._classAttribute, this._datasetHeader){

            @Override
            public InstanceBuilder<A, Boolean> setClassAttribute(Boolean value) {
                if (!BinaryDecider.this._classAttribute.getClassType().equals(Boolean.class)) {
                    throw new IllegalArgumentException(BinaryDecider.this._classAttribute.name() + " is not a Boolean attribute");
                }
                if (value.booleanValue()) {
                    this._instance.setClassValue(0.0);
                } else {
                    this._instance.setClassValue(1.0);
                }
                return this;
            }
        };
    }
}

