/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directtruststandards.timplus.common.crypto.PKCS11Credential;
import org.directtruststandards.timplus.common.crypto.exceptions.CryptoException;
import org.directtruststandards.timplus.common.crypto.impl.AbstractPKCS11TokenKeyStoreProtectionManager;

public class StaticPKCS11TokenKeyStoreProtectionManager
extends AbstractPKCS11TokenKeyStoreProtectionManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(StaticPKCS11TokenKeyStoreProtectionManager.class);

    public StaticPKCS11TokenKeyStoreProtectionManager() throws CryptoException {
    }

    public StaticPKCS11TokenKeyStoreProtectionManager(PKCS11Credential credential, String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias) throws CryptoException {
        super(credential, keyStorePassPhraseAlias, privateKeyPassPhraseAlias);
    }

    @Override
    public void initTokenStore() throws CryptoException {
        this.loadProvider();
        try {
            LOGGER.debug((Object)("Initializing token store type " + this.keyStoreType));
            this.ks = KeyStore.getInstance(this.keyStoreType);
            this.ks.load(this.keyStoreSource, this.credential.getPIN());
        }
        catch (Exception e) {
            throw new CryptoException("Error initializing PKCS11 token", e);
        }
    }
}

