/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.crypto.impl;

import java.security.Key;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.directtruststandards.timplus.common.crypto.KeyStoreProtectionManager;
import org.directtruststandards.timplus.common.crypto.WrappableKeyProtectionManager;
import org.directtruststandards.timplus.common.crypto.exceptions.CryptoException;
import org.directtruststandards.timplus.common.crypto.impl.AbstractPKCS11TokenKeyStoreProtectionManager;

public class BootstrappedKeyStoreProtectionManager
implements KeyStoreProtectionManager,
WrappableKeyProtectionManager {
    public static final String PrivKeyProtKey = "PrivKeyProtKey";
    public static final String KeyStoreProtKey = "KeyStoreProtKey";
    protected Key keyStoreProtectionKey;
    protected Key privateKeyProtectionKey;
    protected Map<String, KeyStore.Entry> keyEntries;

    public BootstrappedKeyStoreProtectionManager() {
        this.setKeyEntries(null);
    }

    public BootstrappedKeyStoreProtectionManager(String keyStoreProtectionKey, String privateKeyProtectionKey) throws CryptoException {
        this.setKeyEntries(null);
        this.setKeyStoreProtectionKey(keyStoreProtectionKey);
        this.setPrivateKeyProtectionKey(privateKeyProtectionKey);
    }

    public BootstrappedKeyStoreProtectionManager(String keyStoreProtectionKey, String privateKeyProtectionKey, Map<String, KeyStore.Entry> entries) throws CryptoException {
        this.setKeyEntries(entries);
        this.setKeyStoreProtectionKey(keyStoreProtectionKey);
        this.setPrivateKeyProtectionKey(privateKeyProtectionKey);
    }

    public void setKeyStoreProtectionKey(String keyStoreProtectionKey) throws CryptoException {
        this.keyStoreProtectionKey = this.buildSecretKeyFromString(keyStoreProtectionKey);
        this.keyEntries.put(KeyStoreProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.keyStoreProtectionKey));
    }

    public void setPrivateKeyProtectionKey(String privateKeyProtectionKey) throws CryptoException {
        this.privateKeyProtectionKey = this.buildSecretKeyFromString(privateKeyProtectionKey);
        this.keyEntries.put(PrivKeyProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.privateKeyProtectionKey));
    }

    public void setKeyEntries(Map<String, KeyStore.Entry> entries) {
        Map<String, KeyStore.Entry> map = this.keyEntries = entries == null ? new HashMap<String, KeyStore.Entry>() : new HashMap<String, KeyStore.Entry>(entries);
        if (this.keyStoreProtectionKey != null) {
            this.keyEntries.put(PrivKeyProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.keyStoreProtectionKey));
        }
        if (this.keyStoreProtectionKey != null) {
            this.keyEntries.put(KeyStoreProtKey, new KeyStore.SecretKeyEntry((SecretKey)this.privateKeyProtectionKey));
        }
    }

    @Override
    public Key getPrivateKeyProtectionKey() throws CryptoException {
        return this.privateKeyProtectionKey;
    }

    @Override
    public Key getKeyStoreProtectionKey() throws CryptoException {
        return this.keyStoreProtectionKey;
    }

    @Override
    public Map<String, Key> getAllKeys() throws CryptoException {
        HashMap<String, Key> keys = new HashMap<String, Key>();
        for (Map.Entry<String, KeyStore.Entry> keyEntry : this.keyEntries.entrySet()) {
            if (!(keyEntry.getValue() instanceof KeyStore.SecretKeyEntry)) continue;
            keys.put(keyEntry.getKey(), ((KeyStore.SecretKeyEntry)keyEntry.getValue()).getSecretKey());
        }
        return keys;
    }

    @Override
    public Key getKey(String keyName) throws CryptoException {
        KeyStore.Entry keyEntry = this.getEntry(keyName);
        if (keyEntry != null && keyEntry instanceof KeyStore.SecretKeyEntry) {
            return ((KeyStore.SecretKeyEntry)keyEntry).getSecretKey();
        }
        return null;
    }

    @Override
    public Map<String, KeyStore.Entry> getAllEntries() throws CryptoException {
        return Collections.unmodifiableMap(this.keyEntries);
    }

    @Override
    public KeyStore.Entry getEntry(String entryName) throws CryptoException {
        return this.keyEntries.get(entryName);
    }

    @Override
    public byte[] wrapWithSecretKey(SecretKey kek, Key keyToWrap) throws CryptoException {
        IvParameterSpec iv = new IvParameterSpec(AbstractPKCS11TokenKeyStoreProtectionManager.IV_BYTES);
        try {
            Cipher wrapCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            wrapCipher.init(3, (Key)kek, iv);
            return wrapCipher.wrap(keyToWrap);
        }
        catch (Exception e) {
            throw new CryptoException("Failed to wrap key: " + e.getMessage(), e);
        }
    }

    @Override
    public Key unwrapWithSecretKey(SecretKey kek, byte[] wrappedData, String keyAlg, int keyType) throws CryptoException {
        IvParameterSpec iv = new IvParameterSpec(AbstractPKCS11TokenKeyStoreProtectionManager.IV_BYTES);
        try {
            Cipher unwrapCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            unwrapCipher.init(4, (Key)kek, iv);
            return unwrapCipher.unwrap(wrappedData, keyAlg, keyType);
        }
        catch (Exception e) {
            throw new CryptoException("Failed to unwrap key: " + e.getMessage(), e);
        }
    }

    protected Key buildSecretKeyFromString(String data) throws CryptoException {
        byte[] salt = new byte[]{-125, -107, -87, -40};
        PBEKeySpec keySpec = new PBEKeySpec(data.toCharArray(), salt, 65536, 128);
        try {
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("pbewithsha256and128bitaes-cbc-bc", "BC");
            SecretKey tmp = keyFac.generateSecret(keySpec);
            return new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new CryptoException("Could not create secret key for password.", e);
        }
    }
}

