/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.cert;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.directtruststandards.timplus.common.cert.X509CertificateEx;
import org.directtruststandards.timplus.common.crypto.KeyStoreProtectionManager;
import org.directtruststandards.timplus.common.crypto.WrappableKeyProtectionManager;
import org.directtruststandards.timplus.common.crypto.exceptions.CryptoException;

public class WrappedOnDemandX509CertificateEx
extends X509CertificateEx {
    protected final KeyStoreProtectionManager mgr;
    protected final byte[] wrappedData;
    protected PrivateKey wrappedKey;

    public static X509CertificateEx fromX509Certificate(KeyStoreProtectionManager mgr, X509Certificate cert, byte[] wrappedData) {
        if (cert == null || wrappedData == null || wrappedData.length == 0) {
            throw new IllegalArgumentException("Cert or wrapped data cannot be null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("KeyStore manager cannot be null");
        }
        if (!(mgr instanceof WrappableKeyProtectionManager)) {
            throw new IllegalArgumentException("Key store must implement the WrappableKeyProtectionManager interface");
        }
        return new WrappedOnDemandX509CertificateEx(mgr, cert, wrappedData);
    }

    protected WrappedOnDemandX509CertificateEx(KeyStoreProtectionManager mgr, X509Certificate cert, byte[] wrappedData) {
        super(cert, null);
        this.mgr = mgr;
        this.wrappedData = wrappedData;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.wrappedData != null;
    }

    @Override
    public synchronized PrivateKey getPrivateKey() {
        if (this.wrappedKey != null) {
            return this.wrappedKey;
        }
        WrappableKeyProtectionManager wrapManager = (WrappableKeyProtectionManager)((Object)this.mgr);
        String keyAlg = this.internalCert.getPublicKey().getAlgorithm();
        try {
            this.wrappedKey = (PrivateKey)wrapManager.unwrapWithSecretKey((SecretKey)this.mgr.getPrivateKeyProtectionKey(), this.wrappedData, keyAlg, 2);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Failed to access wrapped private key.", e);
        }
        return this.wrappedKey;
    }
}

