/*
 * Decompiled with CFR 0.152.
 */
package org.directtruststandards.timplus.common.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.directtruststandards.timplus.common.cert.CertificateConversionException;
import org.directtruststandards.timplus.common.cert.X509CertificateEx;

public class CertUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toPkcs12(X509Certificate cert, PrivateKey privKey, String passPhrase) {
        if (cert == null) {
            throw new IllegalArgumentException("Cert cannot be null");
        }
        if (privKey == null) {
            throw new IllegalArgumentException("Private keyt cannot be null");
        }
        String pass = passPhrase == null ? "" : passPhrase;
        try (ByteArrayOutputStream outStr = new ByteArrayOutputStream();){
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
            localKeyStore.load(null, null);
            localKeyStore.setKeyEntry("privCert", privKey, "".toCharArray(), new Certificate[]{cert});
            localKeyStore.store(outStr, pass.toCharArray());
            byte[] byArray = outStr.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to create pkcs12 keystore.", e);
        }
    }

    public static byte[] pkcs12ToStrippedPkcs12(byte[] bytes, String passphrase) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Pkcs byte stream cannot be null or empty.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null.");
        }
        byte[] retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
            localKeyStore.load(bais, passphrase.toCharArray());
            Enumeration<String> aliases = localKeyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                Key key = localKeyStore.getKey(alias, "".toCharArray());
                if (key != null && key instanceof PrivateKey) {
                    char[] emptyPass = "".toCharArray();
                    localKeyStore.setKeyEntry("privCert", key, emptyPass, new Certificate[]{cert});
                    localKeyStore.store(outStr, emptyPass);
                    retVal = outStr.toByteArray();
                }
            }
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to strip encryption for PKCS stream.", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception exception) {}
            try {
                outStr.close();
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    public static byte[] x509CertificateToBytes(X509Certificate cert) {
        if (cert instanceof X509CertificateEx) {
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            try {
                KeyStore convertKeyStore = KeyStore.getInstance("PKCS12", "BC");
                convertKeyStore.load(null, null);
                char[] emptyPass = "".toCharArray();
                convertKeyStore.setKeyEntry("privCert", ((X509CertificateEx)cert).getPrivateKey(), emptyPass, new Certificate[]{cert});
                convertKeyStore.store(outStr, emptyPass);
                byte[] byArray = outStr.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw new CertificateConversionException("Failed to convert certificate to a byte stream.", e);
            }
            finally {
                try {
                    outStr.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            return cert.getEncoded();
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to convert certificate to a byte stream.", e);
        }
    }

    public static X509Certificate toX509Certificate(byte[] data) {
        return CertUtils.toX509Certificate(data, "");
    }

    public static X509Certificate toX509Certificate(byte[] data, String passPhrase) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Byte stream cannot be null or empty.");
        }
        if (passPhrase == null) {
            passPhrase = "";
        }
        X509Certificate retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", "BC");
                localKeyStore.load(bais, passPhrase.toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, passPhrase.toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        retVal = X509CertificateEx.fromX509Certificate(cert, (PrivateKey)key);
                    }
                }
            }
            catch (Exception localKeyStore) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to convert byte stream to a certificate.", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
        return retVal;
    }

    public X509Certificate certFromFile(String certFile) {
        File theCertFile = new File(certFile);
        try {
            return CertUtils.toX509Certificate(FileUtils.readFileToByteArray((File)theCertFile));
        }
        catch (Exception e) {
            return null;
        }
    }
}

